
(* ---------------------------------------------------------------
Title         Q&D Storm Simulation
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         
              minimal error messages and checking, etc.
              large model required here because of required wav buffers
              from vindoze, dmabuffersize must equal the largest wav
Bugs          another M2 one ! binary constants (########B) are a nono !!!
              weird noises at the end of each wavfile (click or garbage) !
              nothing could be done to prevent'em... why ??? page frontier ???
              well, seems it has to do with autoinitialize mode (1CH),
              but probably not worth the trouble (split buffer, isr, etc.)

Wish List     prettier forks, lightning fade, clouds sky,
              custom skyline (gothic)

--------------------------------------------------------------- *)

MODULE Storm;

IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;
IMPORT MsMouse;
IMPORT FIO;
IMPORT Storage;

FROM IO IMPORT WrStr, WrLn;
FROM IO IMPORT WrHex, WrShtHex,WrCard, WrLngCard,KeyPressed,WrShtCard;

FROM SYSTEM IMPORT In,Out;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
Ky_F1, Ky_F2, Ky_F3, Ky_F4, Ky_F5, Ky_F6, Ky_F7, Ky_F8, Ky_F9, Ky_F10,
Ky_Up, Ky_Left, Ky_Right, Ky_Down,
Ky_SUp, Ky_SLeft, Ky_SRight, Ky_SDown,
Ky_Home, Ky_End, Ky_PgUp, Ky_PgDn,
Ky_SHome, Ky_SEnd, Ky_SPgUp, Ky_SPgDn,
Ky_Ins, Ky_Del, Ky_SIns, Ky_SDel, Ky_Tab, Ky_RvsTab, Ky_STab,
Ky_BS, Ky_CR, Ky_ESC, Ky_Clr, Ky_Plus, Ky_Minus,
Ky_AltA, Ky_AltB, Ky_AltC, Ky_AltD, Ky_AltE, Ky_AltF, Ky_AltG,
Ky_AltH, Ky_AltI, Ky_AltJ, Ky_AltK, Ky_AltL, Ky_AltM, Ky_AltN,
Ky_AltO, Ky_AltP, Ky_AltQ, Ky_AltR, Ky_AltS, Ky_AltT, Ky_AltU,
Ky_AltV, Ky_AltW, Ky_AltX, Ky_AltY, Ky_AltZ,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

(* ------------------------------------------------------------ *)

CONST
    DEBUG      = FALSE;
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    ProgEXEname   = "STORM";
    ProgTitle     = "Q&D Storm Simulation";
    ProgVersion   = "v1.0e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";
    (* yes, hard coded, but for rather good reasons ! ;-) *)
    wavBackground = "STORM0.WAV";
    wavThunder    = "STORM1.WAV";
CONST
    sbpro             = TRUE;  (* assume (old) modern card ! *)
CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errCannotSetHires = 5;
    errMaybeWare      = 6;
    errNotFound       = 7;
    errSB             = 8;
    errWav            = 9;
    err64K            = 10;
    errAllocate       = 11;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = cr+lf;
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    credit+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "    -z   abort not only on keypress but on mouseclick too"+nl+
    "    -f:# persistence of flash (default is 6)"+nl+
    "    -i:# persistence of lightning after strike (default is 24)"+nl+
    "    -l:# maximum number of lightnings (default is 2)"+nl+
    "    -r:# lightnings probability range (default is 32 for 1/32)"+nl+
    "    -b   bold lightning"+nl+
    "    -c   allow children forks"+nl+
    "    -v   skyline"+nl+
    "    -n:# skyline rebuild frequency for monitor safety (default is 1000)"+nl+
    "    -p:# sky color (default is black)"+nl+
    "    -k:# divisor for maximum height of buildings (default=screen height / 5)"+nl+
    "    -a   twinkling lights"+nl+
    "    -s   SoundBlaster sounds (experimental :  feature !)"+nl+
    "    -t   no background sound (thunder sound only)"+nl+
    nl+
(*%T sbpro *)
    "    Sound requires a SoundBlaster Pro (or compatible) board."+nl;
(*%E *)
(*%F sbpro *)
    "    Sound requires a SoundBlaster (or compatible) board."+nl;
(*%E  *)

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo);
        Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetHires:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," mode !");
    | errMaybeWare:
        S := "Are you serious ? This is MAYBEWARE ! ;-)";
    | errNotFound :
        Str.Concat(S,einfo," does not exist !");
    | errSB :
        Str.Concat(S,einfo," !");
    | errWav :
        Str.Concat(S,einfo," !");
    | err64K :
        Str.Concat(S,einfo," data would take more than 64 KB !");
    | errAllocate:
        Str.Concat(S,"ALLOCATE() failed loading ",einfo);
        Str.Append(S," !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getrndlongrange (min,max:LONGCARD  ):LONGCARD;
VAR
    range : LONGCARD;
    rnd : REAL;
BEGIN
    range := max-min+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(min);
    RETURN LONGCARD(rnd);
END getrndlongrange;

PROCEDURE igetrndrange ( min,max:INTEGER ):INTEGER;
VAR
    range : CARDINAL;
BEGIN
    range := CARDINAL(max-min)+1 ;
    RETURN min+INTEGER(RANDOM_INT(range));
END igetrndrange;

PROCEDURE getrndrange ( min,max:CARDINAL ):CARDINAL;
VAR
    range : CARDINAL;
BEGIN
    range := max-min+1 ;
    RETURN min+ RANDOM_INT(range);
END getrndrange;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE longvalue (S:ARRAY OF CHAR;min,max:LONGCARD;VAR r:LONGCARD):BOOLEAN;
VAR
    R : str128;
    ok: BOOLEAN;
BEGIN
    GetString(S,R);
    IF Str.Length(R)=0 THEN RETURN FALSE; END;
    IF R[0]="$" THEN
        Str.Delete(R,0,1);
        r:=Str.StrToCard(R,16,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
    ELSE
        IF GetLongCard(S,r)=FALSE THEN RETURN FALSE; END;
    END;
    IF r < min THEN RETURN FALSE; END;
    IF r > max THEN RETURN FALSE; END;
    RETURN TRUE;
END longvalue;

PROCEDURE swapCards (VAR v1,v2:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    IF v1 <= v2 THEN RETURN; END;
    tmp := v2;
    v2  := v1;
    v1  := tmp;
END swapCards;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

PROCEDURE makebase (VAR basepath:ARRAY OF CHAR);
VAR
    u,d,n,e:str128;
BEGIN
    Lib.ParamStr(basepath,0);
    Lib.SplitAllPath(basepath,u,d,n,e);
    Str.Concat(basepath,u,d);
END makebase;

PROCEDURE chkSizeLessThan64K ( S:ARRAY OF CHAR ):BOOLEAN;
VAR
    hnd:FIO.File;
    n:LONGCARD;
BEGIN
    hnd:=FIO.OpenRead(S);
    n:=FIO.Size(hnd);
    FIO.Close(hnd);
    RETURN (n < MAX(CARDINAL)-1);  (* -1 is... added safety *)
END chkSizeLessThan64K;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    wavPtrType = POINTER TO BYTE; (* fake pointer to a buffer *)

(* assume size is < 64 Kb ! *)

PROCEDURE loadfile (S:ARRAY OF CHAR;headerlen,len:LONGCARD;VAR ptr:wavPtrType):BOOLEAN;
VAR
    needed:CARDINAL;
    hnd:FIO.File;
    n:CARDINAL;
BEGIN
    needed:=CARDINAL(len);
    IF Storage.Available (needed)=FALSE THEN RETURN FALSE; END;
    Storage.ALLOCATE(ptr,needed);
    hnd:=FIO.OpenRead(S);
    FIO.Seek(hnd,headerlen);
    n := FIO.RdBin(hnd,ptr^,needed);
    FIO.Close(hnd);
    RETURN TRUE;
END loadfile;

(* ------------------------------------------------------------ *)

CONST
    addrSBmixerindex  = 04H;
    addrSBmixervalue  = 05H;
    addrSBreset       = 06H;
    addrSBread        = 0AH;
    addrSBwrite       = 0CH;
    addrSBavailable   = 0EH;
    varBLASTER        = "BLASTER";
VAR
    SBaddr      : CARDINAL;
    SBdma       : CARDINAL;
VAR
    DSPWrite      : CARDINAL;
    DSPmixerIndex : CARDINAL;
    DSPmixerValue : CARDINAL;
    DSPReset      : CARDINAL;
    DSPRead       : CARDINAL;
    DSPAvailable  : CARDINAL;
VAR
    regaddr,regcount,regpage,regmask,regmode,regclear,regstatus:CARDINAL;
    terminal:SHORTCARD;
VAR (* infos from wav header *)
    lenheader:LONGCARD;
    fmt,channels,sampling,bytespersec,frequency : CARDINAL;
    datalen:LONGCARD;

(* ------------------------------------------------------------ *)

(* all use global variable SBaddr as base address *)

PROCEDURE WriteToDSP ( v : SHORTCARD);
BEGIN
    WHILE (In(DSPWrite) AND SHORTCARD(80H)) # SHORTCARD(00H) DO (* till bit 7 = 0 *)
    END;
    Out(DSPWrite,v);
END WriteToDSP;

PROCEDURE WriteDAC ( v:SHORTCARD);
BEGIN
    WriteToDSP (10H); (* direct mode to DAC *)
    WriteToDSP (v);   (* 8-bit sample *)
END WriteDAC;

PROCEDURE SBCardSpeakerOn();
BEGIN
    WriteToDSP (0D1H);
END SBCardSpeakerOn;

PROCEDURE SBCardSpeakerOff();
BEGIN
    WriteToDSP (0D3H);
END SBCardSpeakerOff;

PROCEDURE DMAstop (  );
BEGIN
    WriteToDSP (0D0H);
END DMAstop;

PROCEDURE DMAcontinue ();
BEGIN
    WriteToDSP (0D4H);
END DMAcontinue;


PROCEDURE SBCardReset (  ):BOOLEAN;
BEGIN
    Out (DSPReset,1);
    Lib.Delay(150); (* 0.15 second, 3 micro seconds needed but longer just to be safe *)
    Out (DSPReset,0);
    Lib.Delay(150);

    WHILE (In(DSPAvailable) AND SHORTCARD(80H)) # SHORTCARD(80H) DO (* till bit 7 = 1 *)
    END;

    RETURN ( In(DSPRead) = 0AAH );
END SBCardReset;

(* use globerk *)

PROCEDURE dmaregisters();
BEGIN
CASE SBdma OF
| 0 : regaddr:= 000H ; regcount:= 001H ; regpage:= 087H;
| 1 : regaddr:= 002H ; regcount:= 003H ; regpage:= 083H;
| 2 : regaddr:= 004H ; regcount:= 005H ; regpage:= 081H;
| 3 : regaddr:= 006H ; regcount:= 007H ; regpage:= 082H;
| 4 : regaddr:= 0C0H ; regcount:= 0C2H ; regpage:= 08FH;
| 5 : regaddr:= 0C4H ; regcount:= 0C6H ; regpage:= 08BH;
| 6 : regaddr:= 0C8H ; regcount:= 0CAH ; regpage:= 089H;
| 7 : regaddr:= 0CCH ; regcount:= 0CEH ; regpage:= 08AH;
END;
CASE SBdma OF
| 0,1,2,3 : regmask:= 00AH ; regmode:= 00BH ; regclear:= 00CH ; regstatus:= 008H;
| 4,5,6,7 : regmask:= 0D4H ; regmode:= 0D6H ; regclear:= 0D8H ; regstatus:= 0D0H;
END;
CASE SBdma OF
| 0,4 : terminal:= 001H;
| 1,5 : terminal:= 002H;
| 2,6 : terminal:= 004H;
| 3,7 : terminal:= 008H;
END;
END dmaregisters;

PROCEDURE GoPlayback (buffer:wavPtrType; bufferlen:LONGCARD;
                      channels,frequency:CARDINAL);
VAR
    size:CARDINAL;
    losize,hisize,loaddr,hiaddr,stringpageaddr:SHORTCARD;
    segment,offset,stringaddrword:CARDINAL;
    stringaddr : LONGCARD;
    timeconstant:SHORTCARD;
    dummy:SHORTCARD;
BEGIN
    size   := CARDINAL(bufferlen)-1;
    losize := SHORTCARD(size MOD 256);
    hisize := SHORTCARD(size DIV 256);
    segment        := Seg(buffer^);
    offset         := Ofs(buffer^);
    stringaddr     := 16*LONGCARD(segment)+LONGCARD(offset);
    stringpageaddr := SHORTCARD(stringaddr DIV 65536);
    stringaddrword := CARDINAL(stringaddr MOD 65536);
    loaddr         := SHORTCARD(stringaddrword MOD 256);
    hiaddr         := SHORTCARD(stringaddrword DIV 256);

    Out(regmask,(SHORTCARD(04H) + SHORTCARD(SBdma MOD 4))); (* cmd=set channel before programming it *)
    Out(regclear,00H);                       (* reset internal pointers *)
    Out(regmode,(SHORTCARD(48H) + SHORTCARD(SBdma MOD 4))); (* set mode to read & signal *)
    Out(regaddr, loaddr);         (* bits 0-7 of the 20bit address *)
    Out(regaddr, hiaddr);         (* bits 8-15 of the 20bit address *)
    Out(regpage, stringpageaddr); (* bits 16-19 of the 20bit address *)
    Out(regcount, losize);        (* bits 0-7 of size *)
    Out(regcount, hisize);        (* bits 8-16 of size *)
    Out(regmask,(SHORTCARD(00H) + SHORTCARD(SBdma MOD 4))); (* cmd=enable channel *)

    (* init DAC here *)
    (* set playback frequency *)
    timeconstant := 256 - SHORTCARD( 1000000 DIV LONGCARD(frequency)); (* force longcard for correct result *)

    WriteToDSP (40H);
    WriteToDSP (timeconstant);

    (*%T sbpro *)  (* BEGIN specific to SBpro *)
    Out(DSPmixerIndex,00H); (* reset mixer chip before changes *)
    Out(DSPmixerValue,00H);
    CASE channels OF
    | 1 :
        Out(DSPmixerIndex,0EH);
        Out(DSPmixerValue,SHORTCARD(00H)); (* bypass O/P filter and mono *)
    | 2 :
        Out(DSPmixerIndex,0EH);
        Out(DSPmixerValue,SHORTCARD(02H)); (* stereo *)
    END;
    (*%E  *) (* END specific to SBpro *)

    (* set playback type (only 8-bit DAC for now) *)
    WriteToDSP (14H);
    (* write lsb and msb of datalength-1 *)
    WriteToDSP (losize);
    WriteToDSP (hisize);
    (* make sure DMA is going *)
    dummy:=In(regstatus);
END GoPlayback;

PROCEDURE PlaybackDone():BOOLEAN;
VAR
    dummy:SHORTCARD;
BEGIN
    (* loop until terminal count bit set to 1 *)
    IF (In(regstatus) AND terminal) = terminal THEN (* wait till terminal count bit 7=1 *)
	(* acknowledge the DSP interrupt by reading the DATA AVAILABLE port once *)
	dummy:=In (DSPAvailable);
	(* send EOI to the interrupt controller port 20h just in case *)
	Out (020H, 020H);
	RETURN TRUE;
    ELSE
	RETURN FALSE;
    END;
END PlaybackDone;

(* ------------------------------------------------------------ *)

PROCEDURE BlasterHere (  ):BOOLEAN;
VAR
    S : str128;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    RETURN NOT(same(S,""));
END BlasterHere;

PROCEDURE goodBlasterAddress (VAR addr:CARDINAL):BOOLEAN;
VAR
    S,R : str128;
    p : CARDINAL;
    v : LONGCARD;
    ok:BOOLEAN;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    Str.Caps(S);
    p:=Str.CharPos(S,"A");
    IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
    Str.Delete(S,0,p+1);
    isoleItemS(R,S," ",0);
    v:=Str.StrToCard(R,16,ok);
    IF ok=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE;END;
    addr:=CARDINAL(v);
    CASE addr OF
    | 220H,240H,260H,280H: (* only valid addresses $02x0 where x=2,4,6,8 *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END goodBlasterAddress;

PROCEDURE goodBlasterDMA (VAR dma:CARDINAL ):BOOLEAN;
VAR
    S,R : str128;
    p : CARDINAL;
    v : LONGCARD;
    ok:BOOLEAN;
BEGIN
    Lib.EnvironmentFind(varBLASTER,S);
    Str.Caps(S);
    p:=Str.CharPos(S,"D");
    IF p = MAX(CARDINAL) THEN RETURN FALSE; END;
    Str.Delete(S,0,p+1);
    isoleItemS(R,S," ",0);
    v:=Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE;END;
    dma:=CARDINAL(v);
    CASE dma OF
    | 0,1,3: (* dma 8 bits is 0,1,3 *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END goodBlasterDMA;

PROCEDURE chkBlaster (VAR errormsg:ARRAY OF CHAR):BOOLEAN;
BEGIN
    Str.Copy(errormsg,"BLASTER environment variable not set");
    IF BlasterHere()=FALSE THEN RETURN FALSE; END;
    Str.Copy(errormsg,"Bad BLASTER address");
    IF goodBlasterAddress(SBaddr)=FALSE THEN RETURN FALSE; END;
    Str.Copy(errormsg,"Bad BLASTER DMA value");
    IF goodBlasterDMA(SBdma)=FALSE THEN RETURN FALSE; END;

    DSPWrite     := SBaddr + addrSBwrite;
    DSPReset     := SBaddr + addrSBreset;
    DSPRead      := SBaddr + addrSBread;
    DSPAvailable := SBaddr + addrSBavailable;
    DSPmixerIndex:= SBaddr + addrSBmixerindex;
    DSPmixerValue:= SBaddr + addrSBmixervalue;
    (* init DMA register addresses here *)
    dmaregisters();

(*%T DEBUG *)
WrStr("SoundBlaster address : ");WrHex(SBaddr,4);WrLn;
WrStr("SoundBlaster DMA     : ");WrHex(SBdma,4);WrLn;
WrStr("DSPWrite             : ");WrHex(DSPWrite,4);WrLn;
WrStr("DSPReset             : ");WrHex(DSPReset,4);WrLn;
WrStr("DSPRead              : ");WrHex(DSPRead,4);WrLn;
WrStr("DSPAvailable         : ");WrHex(DSPAvailable,4);WrLn;
WrStr("DSPmixerIndex        : ");WrHex(DSPmixerIndex,4);WrLn;
WrStr("DSPmixerValue        : ");WrHex(DSPmixerValue,4);WrLn;
WrLn;
WrStr("regaddr              : ");WrHex(regaddr,4);WrLn;
WrStr("regcount             : ");WrHex(regcount,4);WrLn;
WrStr("regpage              : ");WrHex(regpage,4);WrLn;
WrStr("regmask              : ");WrHex(regmask ,4);WrLn;
WrStr("regmode              : ");WrHex(regmode ,4);WrLn;
WrStr("regclear             : ");WrHex(regclear,4);WrLn;
WrStr("regstatus            : ");WrHex(regstatus   ,4);WrLn;
WrStr("terminal             : ");WrShtHex(terminal     ,4);WrLn;
WrLn;
(*%E  *)

(*%T sbpro *)
    Str.Copy(errormsg,"SoundBlaster Pro card would not reset");
(*%E  *)
(*%F sbpro *)
    Str.Copy(errormsg,"SoundBlaster card would not reset");
(*%E  *)

    RETURN SBCardReset();
END chkBlaster;

TYPE WavHeaderType = RECORD
    rID               : ARRAY [0..3] OF CHAR; (* "RIFF" *)
    rLen              : LONGCARD;             (* length of data chunk *)
    wID               : ARRAY [0..3] OF CHAR; (* "WAVE" *)
    fID               : ARRAY [0..3] OF CHAR; (* "fmt " *)
    fLen              : LONGCARD;
    wFormatTag        : CARDINAL;             (* 1 = pcm, ... *)
    nChannels         : CARDINAL;             (* 1=mono 2 = stereo *)
    nSamplesPerSec    : CARDINAL;             (* playback frequency *)
    unknown1          : CARDINAL;
    nAvgBytesPerSec   : CARDINAL;             (* average bytes / second data should be sent at *)
                                              (* nchannels * nSamplesPerSec * (nbitspersample/8) *)
    unknown2          : CARDINAL;
    nBlockAlign       : CARDINAL;             (* nchannels * (nbitspersample/8) *)
    FormatSpecific    : CARDINAL;
    dID               : ARRAY [0..3] OF CHAR; (* "data" *)
    dLen              : LONGCARD;             (* length of actual data *)
END;

PROCEDURE chkWavHeader (S:ARRAY OF CHAR;VAR errormsg:ARRAY OF CHAR):BOOLEAN;
VAR
    header : WavHeaderType;
    hnd:FIO.File;
    n:CARDINAL;
    filelen:LONGCARD;
BEGIN
    hnd:=FIO.OpenRead(S);
    n:=FIO.RdBin(hnd,header,SIZE(header));
    filelen:=FIO.Size(hnd);
    FIO.Close(hnd);

    lenheader  :=SIZE(header)+header.fLen-16 ; (* kludgy but works! ;-) normal is 16 *)
    fmt        :=header.wFormatTag;
    channels   :=header.nChannels;
    sampling   :=header.nSamplesPerSec;
    bytespersec:=header.nAvgBytesPerSec;

    frequency  :=bytespersec; (* do not feed with sampling?? !!! *)

    datalen    := filelen - lenheader;
(*%T DEBUG *)
WrStr("File               : ");WrStr(S);WrLn;
WrStr("Format             : ");WrCard(fmt,8);WrLn;
WrStr("Channels           : ");WrCard(channels,8);WrLn;
WrStr("Playback frequency : ");WrCard(sampling,8);WrLn;
WrStr("Bytes per second   : ");WrCard(bytespersec,8);WrLn;
WrStr("File length        : ");WrLngCard(filelen,8);WrLn;
WrStr("Header length      : ");WrLngCard(lenheader,8);WrLn;
WrStr("Data length        : ");WrLngCard(datalen,8);WrLn;
WrLn;
(*%E *)
    Str.Concat(errormsg,"Bad header for ",S);
    Str.Caps(header.rID);
    IF same (header.rID,"RIFF")=FALSE THEN RETURN FALSE; END;
    Str.Caps(header.wID);
    IF same (header.wID,"WAVE")=FALSE THEN RETURN FALSE; END;
    Str.Caps(header.fID);
    IF same (header.fID,"FMT ")=FALSE THEN RETURN FALSE; END;
(*%F sbpro  *)
    Str.Concat(errormsg,"Unsupported stereo data for ",S);
    IF channels # 1 THEN RETURN FALSE; END;
(*%E  *)
    Str.Concat(errormsg,"Unsupported WAV format for ",S);
    RETURN (fmt=1);
END chkWavHeader;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
(*
CONST
    sMode = "360x480x256";
    hires = Mode_360x480;
    xcount = 360;
    ycount = 480;
    PagesVirtual=1;
*)
CONST
    sMode = "320x400x256"; (* alas, we need two pages for background now... *)
    hires = Mode_320x400;
    xcount = 320;
    ycount = 400;
    PagesVirtual=2;
CONST
    xmin=0;
    xmax=xcount-1;
    ymin=0;
    ymax=ycount-1;
    workpage=0;
    backpage=1;
    xMaxVirtual=xcount;
    yMaxVirtual=ycount;
    mincolorindex = 0;
    maxcolorindex = 255;

PROCEDURE doHires ():BOOLEAN;
BEGIN
    RETURN (SET_VGA_MODEX(hires,xMaxVirtual,yMaxVirtual,PagesVirtual) <> 0);
END doHires;

PROCEDURE doText ();
BEGIN
    SET_VIDEO_MODE(3);
END doText;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

CONST
    egarange = 64; (* remember an EGA/VGA uses [$00..$3F], nothing more ! *)
CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    mediumblue  = LONGCARD(0000028H);
    darkblue    = LONGCARD(0000020H);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
    cyan        = LONGCARD(0003F3FH);

PROCEDURE remap (ndx:CARDINAL;rgb:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(rgb >> 16) MOD egarange;
    g := CARDINAL(rgb >> 8) MOD egarange;
    b := CARDINAL(rgb MOD egarange);
    SET_DAC_REGISTER(ndx,r,g,b);
END remap;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD 40H;
    g1 := INTEGER (startink >> gshift) MOD 40H;
    b1 := INTEGER (startink          ) MOD 40H;
    r2 := INTEGER (endink   >> rshift) MOD 40H;
    g2 := INTEGER (endink   >> gshift) MOD 40H;
    b2 := INTEGER (endink            ) MOD 40H;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r > 3FH THEN r:=3FH; END;
        IF g > 3FH THEN g:=3FH; END;
        IF b > 3FH THEN b:=3FH; END;
        SET_DAC_REGISTER(ndx+i-1,r,g,b);
    END;
END blend;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ndxBorder    = 0;   (* leave it alone *)
    ndxBlue      = 1;
    ndxBlueWhite = 16;
    ndxWhite     = 32;
    ndxYellow    = 96;
    ndxMedium    = 97;
    ndxOrange    = 98;
    ndxLightOrange=99;
    ndxBuildings = 127;
    ndxSky       = 128; (* from here to fade *)
    faderange    = ymax DIV 4; (* 480/4=120 *)
TYPE
    skycolortype = (blacksky,darkbluesky,lightbluesky,brightbluesky,
                    fadein,fadeout);
VAR
    skycolor : skycolortype;

PROCEDURE setskycolor (  );
VAR
    ndx,n:CARDINAL;
BEGIN
    CASE skycolor OF
    | blacksky :     SET_DAC_REGISTER(ndxSky,00H,00H,00H);
    | darkbluesky:   SET_DAC_REGISTER(ndxSky,00H,00H,18H);
    | lightbluesky:  SET_DAC_REGISTER(ndxSky,00H,00H,20H);
    | brightbluesky: SET_DAC_REGISTER(ndxSky,00H,00H,28H);
    | fadein:
        ndx := ndxSky;         n := faderange; (* 480/4=120 *)
        blend (ndx,n,black,mediumblue);
    | fadeout:
        ndx := ndxSky;         n := faderange;
        blend (ndx,n,mediumblue,black);
    END;
END setskycolor;

PROCEDURE newPalette ();
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
BEGIN
    ndx := 0;         n := 32;
    blend (ndx,n,blue,white);
    INC(ndx,n);       n := 32;
    blend (ndx,n,white,blue);

    SET_DAC_REGISTER(ndxBorder,00H,00H,00H); (* index 0 stays black because of border *)

    SET_DAC_REGISTER(ndxYellow,3FH,3FH,00H); (* for buildings lights *)
    SET_DAC_REGISTER(ndxMedium,38H,38H,00H);
    SET_DAC_REGISTER(ndxOrange,2FH,2FH,00H);
    SET_DAC_REGISTER(ndxLightOrange,
                               2FH,28H,00H);

    SET_DAC_REGISTER(ndxBuildings,1CH,1CH,1CH);

    setskycolor;
END newPalette;

PROCEDURE cls (  );
VAR
    y,y2,inkndx : CARDINAL;
BEGIN
    CASE skycolor OF
    | fadein,fadeout:
        inkndx:=ndxSky;
        FOR y := ymin TO ymax BY 4 DO
            y2:=y+ 3;
            FILL_BLOCK(xmin,y,xmax,y2,inkndx);
            INC(inkndx);
        END;
    ELSE
        CLEAR_VGA_SCREEN (ndxSky);
    END;
END cls;

(* ------------------------------------------------------------ *)

CONST
    minIntervalproba = 1;
    maxIntervalproba = 256;
    flashproba    = 4;   (* was 8 but not enough flashes ! *)
    forkproba     = 16;
    deltax        = 8;
    deltaymin     = 10;
    deltaymax     = 22;
    forkdeltax    = 12;
    forkdeltaymin = 8;
    forkdeltaymax = 22;
    forkmaxcount  = 8;
    minskycounter = 1; (* ridiculous ! *)
    maxskycounter = 65000; (* 4000=1minute, so about 15 minutes max *)
VAR
    stopmouse   : BOOLEAN;
    useforks    : BOOLEAN;
    skyline     : BOOLEAN;
    lastx,lasty,x,y,x2,y2,dx,dy : INTEGER;
    bold:BOOLEAN;
    skycount:CARDINAL;
    noise:BOOLEAN;
    maxskycount:CARDINAL;
    backgroundsound:BOOLEAN;
    animate:BOOLEAN;
    intervalproba : CARDINAL;
CONST
    minDelay = 1;
    maxDelay = 100;
    minLightning = 1;
    maxLightning = 16;
TYPE
    pos = RECORD
        lastx : INTEGER;
        lasty : INTEGER;
        alive : BOOLEAN;
    END;
VAR
    lightning : ARRAY[minLightning..maxLightning] OF pos;

    delayflash : CARDINAL;
    delaybetween:CARDINAL;
    lastlightning:CARDINAL;
    lights,alivecount:CARDINAL;

PROCEDURE tempo (n:CARDINAL);
VAR
    i : CARDINAL;
BEGIN
    FOR i := 1 TO n DO WaitVGAretrace; END;
END tempo;

PROCEDURE flash (delay:CARDINAL );
VAR
    i : CARDINAL;
BEGIN
    WaitVGAretrace();
    CASE skycolor OF
    | fadein,fadeout:
        FOR i := 0 TO (faderange-1) DO
            SET_DAC_REGISTER(ndxSky+i,3FH,3FH,3FH);
        END;
    ELSE
        SET_DAC_REGISTER(ndxSky,3FH,3FH,3FH); (* bright white *)
    END;
    tempo(delay);
    setskycolor;
END flash;

VAR
    xminimum,xmaximum,yminimum,ymaximum:INTEGER;

PROCEDURE dofork (lastx,lasty, deltax,deltaymin,deltaymax,forkmaxcount:INTEGER);
VAR
    i : CARDINAL;
    x,y:INTEGER;
BEGIN
    FOR i := 1 TO getrndrange(1,forkmaxcount) DO
        x := lastx + igetrndrange(-deltax,+deltax);
        IF x < xminimum THEN x := xminimum; END;
        IF x > xmaximum THEN x := xmaximum; END;
        y := lasty + igetrndrange(deltaymin,deltaymax);
        IF y < yminimum THEN y := yminimum; END;
        IF y > ymaximum THEN y := ymaximum; END;
        DRAW_LINE(lastx  , lasty  ,   x   ,  y  ,ndxWhite);
        IF y = ymaximum THEN RETURN; END;
        lastx := x;
        lasty := y;
    END;
END dofork;

(* ------------------------------------------------------------ *)

TYPE
    buildingtype = RECORD
        xpos,ypos,xpos2:CARDINAL;
        lightw,lighth:CARDINAL; (* dot, dotdot, or square *)
        lightsndx:CARDINAL;
    END;
CONST
    minWidth    = 8;
    maxWidth    = 16;
    minHeight   = 2;
    minSpace    = 2;
    maxSpace    = 16;
    minBuilding = 1;
    maxBuilding = (xmax DIV minSpace) + 1;
    minHeightDivisor=2;
    maxHeightDivisor=16;
VAR
    maxHeight : CARDINAL; (* ymax DIV 8 *)
VAR
    buildinfo    : ARRAY[minBuilding..maxBuilding] OF buildingtype;
    lastBuilding : CARDINAL;

PROCEDURE buildSkyline ();
VAR
    i : CARDINAL;
    x,h,w,x2:CARDINAL;
    ndx : CARDINAL;
BEGIN
    i:= minBuilding;
    x:= xmin;
    LOOP
        w:=getrndrange(minSpace,maxSpace);
        INC(x,w); (* inc seemed not to like direct increment with a function ! *)
        IF x > xmax THEN EXIT; END;
        w := getrndrange(minWidth,maxWidth);
        x2:= x+w-1;
        IF x2 > xmax THEN EXIT; END;
        h := getrndrange(minHeight,maxHeight);
        buildinfo[i].xpos   :=x;
        buildinfo[i].ypos   :=ymax-h+1;
        buildinfo[i].xpos2  :=x2;
        CASE getrndrange(1,3) OF
        | 1 : w := 1; h:= 1;
        | 2 : w := 2; h:= 1;
        | 3 : w := 2; h:= 2;
        END;
        buildinfo[i].lightw:=w;
        buildinfo[i].lighth:=h;
        CASE getrndrange(1,9) OF
        | 1,2   : ndx:=ndxYellow;
        | 3     : ndx:=ndxMedium;
        | 4,5,6 : ndx:=ndxOrange;
        | 7,8,9 : ndx:=ndxLightOrange;
        END;
        buildinfo[i].lightsndx:=ndx;
        INC(i);
    END;
    lastBuilding := i-1;
END buildSkyline;

PROCEDURE drawSkyline ();
CONST
    inset = 2;
VAR
    i : CARDINAL;
    x1,y1,x2,y2,w,h,ink,xx,yy:CARDINAL;
BEGIN
    y2 := ymax;
    FOR i := minBuilding TO lastBuilding DO
        x1:=buildinfo[i].xpos;
        y1:=buildinfo[i].ypos;
        x2:=buildinfo[i].xpos2;

        FILL_BLOCK(x1,y1,x2,y2,ndxBuildings); (* yes, we must redo for fake 3D appearance ! *)

        w   := buildinfo[i].lightw;
        h   := buildinfo[i].lighth;
        ink := buildinfo[i].lightsndx;

        yy := y1+inset;
        LOOP
            IF (yy+h-1) > y2 THEN EXIT; END;
            xx := x1+inset;
            LOOP
                IF (xx+w-1) > x2 THEN EXIT; END;
                IF getrndrange(1,10) <8 THEN SET_POINT(xx,yy,ink); END; (* random lights *)
                INC(xx,w);
                INC(xx);
            END;
            INC(yy,h);
            INC(yy);
        END;
    END;
END drawSkyline;

PROCEDURE redrawSkyline ();
CONST
    inset = 2;
    maxprobatwinkle = 200;
VAR
    i : CARDINAL;
    x1,y1,x2,y2,w,h,ink,xx,yy,currink:CARDINAL;
BEGIN
    y2 := ymax;
    FOR i := minBuilding TO lastBuilding DO
        x1:=buildinfo[i].xpos;
        y1:=buildinfo[i].ypos;
        x2:=buildinfo[i].xpos2;

        w   := buildinfo[i].lightw;
        h   := buildinfo[i].lighth;
        ink := buildinfo[i].lightsndx;

        yy := y1+inset;
        LOOP
            IF (yy+h-1) > y2 THEN EXIT; END;
            xx := x1+inset;
            LOOP
                IF (xx+w-1) > x2 THEN EXIT; END;
                currink:=READ_POINT(xx,yy);
                IF ( (currink = ink) OR (currink = ndxBuildings) ) THEN
                    CASE getrndrange(1,maxprobatwinkle) OF
                    | 1: SET_POINT(xx,yy,ink);
                    | 2: SET_POINT(xx,yy,ndxBuildings);
                    END;
                END;
                INC(xx,w);
                INC(xx);
            END;
            INC(yy,h);
            INC(yy);
        END;
    END;
END redrawSkyline;

PROCEDURE buildBackground (  );
BEGIN
    SET_ACTIVE_PAGE(backpage);
    cls;
    IF skyline THEN
        buildSkyline;
        drawSkyline;
    END;
    SET_ACTIVE_PAGE(workpage); (* do not forget ! *)
END buildBackground;

PROCEDURE twinkle ();
BEGIN
    SET_ACTIVE_PAGE(backpage);
    redrawSkyline();
    SET_ACTIVE_PAGE(workpage);
END twinkle;

(*
PROCEDURE log ();
VAR
    hnd:FIO.File;
    i,x1,y1,x2,y2:CARDINAL;
BEGIN
    hnd:=FIO.Append("debug.log");
    y2 := ymax;
    FOR i := minBuilding TO lastBuilding DO
        x1:=buildinfo[i].xpos;
        y1:=buildinfo[i].ypos;
        x2:=buildinfo[i].xpos2;
        FIO.WrStr(hnd,"building:");FIO.WrCard(hnd, i, 4);
        FIO.WrStr(hnd,"   x1:");FIO.WrCard(hnd, x1, 4);
        FIO.WrStr(hnd,"   y1:");FIO.WrCard(hnd, y1, 4);
        FIO.WrStr(hnd,"   x2:");FIO.WrCard(hnd, x2, 4);
        FIO.WrStr(hnd,"   y2:");FIO.WrCard(hnd, y2, 4);
        FIO.WrLn(hnd);
    END;
    FIO.Close(hnd);
END log;
*)

PROCEDURE initdefault (  );
BEGIN
    stopmouse     := FALSE;
    delayflash    := 6;
    delaybetween  := 24;
    bold          := FALSE;
    lastlightning := 2;
    useforks      := FALSE;
    skyline       := FALSE;
    noise         := FALSE;
    maxskycount   := 4000; (* 1000 vsyncs=about 15 seconds, so 4000 = 1 minute *)
    skycolor      := blacksky;
    backgroundsound:=TRUE;
    maxHeight     := ymax DIV 5;
    animate       := FALSE;
    intervalproba := 32;
END initdefault;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    wavthunderproba    = 2;

TYPE
    wavdatatype = RECORD
        headerlen : LONGCARD;
        len       : LONGCARD;
        channels  : CARDINAL;
        frequency : CARDINAL;
        ptr       : wavPtrType;
    END;
VAR
    databackground,datathunder:wavdatatype;
VAR
    parmcount   : CARDINAL;
    i           : CARDINAL;
    opt         : CARDINAL;
    S           : str128;
    R           : str128;
    n           : CARDINAL;
    pathBackground : str128;
    pathThunder    : str128;
    playing        : (rain,thunder,nada);
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    initdefault;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "Z"+delim+"MOUSE"+delim+
                                 "F:"+delim+"DELAYFLASH:"+delim+
                                 "I:"+delim+"DELAYINTERVAL:"+delim+
                                 "B"+delim+"BOLD"+delim+
                                 "L:"+delim+"LIGHTNINGS:"+delim+
                                 "C"+delim+"CHILDREN"+delim+
                                 "V"+delim+"SKYLINE"+delim+
                                 "S"+delim+"SOUND"+delim+
                                 "N:"+delim+"NEWLINE:"+delim+
                                 "P:"+delim+"SKYCOLOR:"+delim+
                                 "T"+delim+"THUNDER"+delim+
                                 "K:"+delim+"DIVISOR:"+delim+
                                 "A"+delim+"ANIMATE"+delim+
                                 "R:"+delim+"RANGE:"
                              );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                stopmouse := TRUE;
            | 6,7 :
                IF value(R,minDelay,maxDelay,delayflash)=FALSE THEN
                    abort(errRange,"flash delay");
                END;
            | 8,9 :
                IF value(R,minDelay,maxDelay,delaybetween)=FALSE THEN
                    abort(errRange,"interval");
                END;
            | 10,11:
                bold:=TRUE;
            | 12,13:
                IF value(R,minLightning,maxLightning,lastlightning)=FALSE THEN
                    abort(errRange,"maximum number of lightnings");
                END;
            | 14,15:
                useforks:=TRUE;
            | 16,17:
                skyline:=TRUE;
            | 18,19 :
                noise:=TRUE;
            | 20,21 :
                IF value(R,minskycounter,maxskycounter,maxskycount)=FALSE THEN
                    abort(errRange,"skyline rebuild frequency");
                END;
            | 22,23 :
                IF value(R,ORD(blacksky),ORD(fadeout),n)=FALSE THEN
                    abort(errRange,"sky color");
                END;
                skycolor := skycolortype(n);
            | 24,25:
                backgroundsound:=FALSE;
            | 26,27 :
                IF value(R,minHeightDivisor,maxHeightDivisor,n)=FALSE THEN
                    abort(errRange,"divisor for maximum size of buildings");
                END;
                maxHeight:=ymax DIV n;
            |28,29:
                animate:=TRUE;
            | 30,31:
                IF value(R,minIntervalproba,maxIntervalproba,intervalproba)=FALSE THEN
                    abort(errRange,"lighting probability range");
                END;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    IF noise THEN
        IF chkBlaster(S)=FALSE THEN abort(errSB,S); END;
        makebase(S);
        Str.Concat(pathBackground,S,wavBackground);
        Str.Concat(pathThunder,S,wavThunder);
        IF FIO.Exists(pathBackground)=FALSE THEN abort(errNotFound,pathBackground);END;
        IF FIO.Exists(pathThunder)=FALSE THEN abort(errNotFound,pathThunder);END;
        IF chkSizeLessThan64K(pathBackground)=FALSE THEN abort(err64K,pathBackground);END;
        IF chkSizeLessThan64K(pathThunder)=FALSE THEN abort(err64K,pathThunder);END;

        IF chkWavHeader(pathBackground,S)=FALSE THEN abort(errWav,S); END;
        databackground.headerlen :=lenheader;
        databackground.len       :=datalen;
        databackground.channels  :=channels;
        databackground.frequency :=frequency;
        IF chkWavHeader(pathThunder,S)=FALSE THEN abort(errWav,S); END;
        datathunder.headerlen    :=lenheader;
        datathunder.len          :=datalen;
        datathunder.channels     :=channels;
        datathunder.frequency    :=frequency;

        (* load files in allocated memory *)

        IF loadfile(pathBackground,
                    databackground.headerlen,databackground.len,
                    databackground.ptr)=FALSE THEN
            abort(errAllocate,pathBackground);
        END;
        IF loadfile(pathThunder,
                    datathunder.headerlen,datathunder.len,
                    datathunder.ptr)=FALSE THEN
            abort(errAllocate,pathThunder);
        END;

        (* abort(errMaybeWare,""); *)
    END;


(*
(* darn ! no click with this debug test !!! *)
(*
SBCardSpeakerOn();
GoPlayback (datathunder.ptr,datathunder.len,datathunder.channels,datathunder.frequency);
WHILE PlaybackDone()=FALSE DO
END;
SBCardSpeakerOff();
SBCardSpeakerOn();
GoPlayback (datathunder.ptr,datathunder.len,datathunder.channels,datathunder.frequency);
WHILE PlaybackDone()=FALSE DO
END;
SBCardSpeakerOff();
*)
FOR i := 1 TO 10 DO
SBCardSpeakerOn();
GoPlayback (databackground.ptr,databackground.len,databackground.channels,databackground.frequency);
WHILE PlaybackDone()=FALSE DO
END;
SBCardSpeakerOff();
SBCardSpeakerOn();
GoPlayback (databackground.ptr,databackground.len,databackground.channels,databackground.frequency);
WHILE PlaybackDone()=FALSE DO
END;
SBCardSpeakerOff();
END;

abort(errNone,"");
*)


    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    IF doHires()=FALSE THEN
        doText;
        abort(errCannotSetHires,sMode);
    END;

    INIT_RANDOM();
    newPalette();

    xminimum := xmin;
    xmaximum := xmax;
    yminimum := ymin;
    ymaximum := ymax;
    IF bold THEN
        INC(xminimum);
        DEC(xmaximum);
    END;

    IF noise THEN
        SBCardSpeakerOn();
        IF backgroundsound THEN
            GoPlayback (databackground.ptr,
                        databackground.len,
                        databackground.channels,
                        databackground.frequency);
            playing := rain;
        ELSE
            playing := nada;
        END;
    END;

    SET_DISPLAY_PAGE(workpage);
    SET_ACTIVE_PAGE (workpage);

    buildBackground();
    IF skyline THEN skycount:=0; END;

    LOOP
        WaitVGAretrace;
        IF skyline THEN
            INC(skycount);
            IF skycount = maxskycount THEN buildBackground(); skycount := 0; END;
            IF animate THEN
                IF (skycount MOD 16) = 0 THEN twinkle(); END;
            END;
        END;

        COPY_PAGE(backpage,workpage);

        IF noise THEN
            IF backgroundsound THEN (* rain or thunder playing *)
                IF PlaybackDone() THEN
                    GoPlayback (databackground.ptr,
                                databackground.len,
                                databackground.channels,
                                databackground.frequency);
                    playing := rain;
                END;
            ELSE
                IF playing # nada THEN (* thunder playing *)
                    IF PlaybackDone() THEN (* flush possible thunder *)
                        playing := nada;
                    END;
                END;
            END;
        END;

        IF getrndrange(1,intervalproba)=1 THEN
            lights:=getrndrange(minLightning,lastlightning);
            FOR i := minLightning TO lights DO
                lastx := getrndrange(xminimum,xmaximum);
                lasty := yminimum;
                lightning[i].lastx:=lastx;
                lightning[i].lasty:=lasty;
                lightning[i].alive :=TRUE;
            END;
            LOOP
                alivecount:=0;
                FOR i:= minLightning TO lights DO
                    IF lightning[i].alive THEN
                        INC(alivecount);
                        lastx := lightning[i].lastx;
                        lasty := lightning[i].lasty;
                        x := lastx + igetrndrange(-deltax,+deltax);
                        IF x < xminimum THEN x := xminimum; END;
                        IF x > xmaximum THEN x := xmaximum; END;
                        y := lasty + igetrndrange(deltaymin,deltaymax);
                        IF y < yminimum THEN y := yminimum; END;
                        IF y > ymaximum THEN y := ymaximum; END;
                        DRAW_LINE(lastx  , lasty  ,   x   ,  y  ,ndxWhite);
                        IF bold THEN
                            DRAW_LINE(lastx-1 , lasty , x-1 , y  ,ndxBlueWhite);
                            DRAW_LINE(lastx+1 , lasty , x+1 , y  ,ndxBlueWhite);
                        END;
                        IF useforks THEN
                            IF getrndrange(1,forkproba)=1 THEN
                                dofork( lastx,lasty,
                                        forkdeltax,
                                        forkdeltaymin,forkdeltaymax,
                                        forkmaxcount);
                            END;
                        END;
                        IF y = ymaximum THEN
                            lightning[i].alive:=FALSE;
                        END;
                        lightning[i].lastx := x;
                        lightning[i].lasty := y;
                    END;
                END;
                IF alivecount = 0 THEN EXIT; END;
            END;
            (* tempo(delaybetween); (* force a delay to see lightning ! *) *)
            IF getrndrange(1,flashproba) = 1 THEN
                flash(delayflash); (* flash is seen BEFORE its sound *)

                IF noise THEN
                    IF ( (playing # thunder) AND (getrndrange(1,wavthunderproba)=1) ) THEN
                        GoPlayback (datathunder.ptr,
                                    datathunder.len,
                                    datathunder.channels,
                                    datathunder.frequency);
                        playing := thunder;
                    ELSE
                        tempo(delaybetween); (* force a delay to see lightning ! *)
                    END;
                ELSE
                    tempo(delaybetween); (* force a delay to see lightning ! *)
                END;

            ELSE
                tempo(delaybetween); (* force a delay to see lightning ! *)
            END;
        END;

        n := SCAN_KEYBOARD();
        (* IF n = Ky_ESC THEN EXIT; END; *)

        IF n <> 0 THEN
            CASE n OF
            | Ky_F1 : (* space *)
                WHILE SCAN_KEYBOARD() = 0 DO
                    (* don't care about sound and PlaybackDone() ! *)
                END;
            ELSE
                EXIT; (* cr, esc, almost any other key *)
            END;
        END;

        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    IF (noise AND (playing # nada)) THEN (* thunder or rain still playing *)
        REPEAT
        UNTIL PlaybackDone();
        SBCardSpeakerOff();
    END;

    doText;

    abort(errNone,"");
END Storm.

