
(* ---------------------------------------------------------------
Title         see help
Author        see help
Overview      see help
Usage         see help
Notes         yes, we should have put graphics calls to a separate lib years ago...
              model cannot be small (buffers needed)
              video pointers are slower
              ugly artifact at first 1/5 of screen when refreshing !
              probably because doPlasma() code is too slow !
Bugs          see help... er... ;-)
Wish List

--------------------------------------------------------------- *)

MODULE wobbler;

IMPORT Str;
IMPORT Lib;
IMPORT SYSTEM;
IMPORT MATHLIB;
IMPORT MsMouse;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn;
FROM Storage IMPORT ALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    INTERNAL = TRUE; (* if true, use internal work screens... FASTER ! *)
    maxDelay  = 10;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE LCgetrndrange (lower,upper:LONGCARD):LONGCARD;
VAR
    range : REAL;
    rnd   : REAL;
BEGIN
    range := REAL(upper-lower)+1.0;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN LONGCARD(rnd);
END LCgetrndrange;

PROCEDURE doRandomize (  );
CONST
    warmcount=100;
VAR
    i:CARDINAL;
    rnd:REAL;
BEGIN
    Lib.RANDOMIZE;
    FOR i:=1 TO warmcount DO (* warm up ! *)
        rnd:=Lib.RAND();
    END;
END doRandomize;


PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyTAB     = 00900H;
    keyTABshift= 0000FH;
    keyStar    = ORD("*") << 8 ;
    upperR     = ORD("R") << 8 ;   lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;   lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;   lowerB     = ORD("b") << 8 ;
    upperS     = ORD("S") << 8 ;   lowerS     = ORD("s") << 8 ;
    upperN     = ORD("N") << 8 ;   lowerN     = ORD("n") << 8 ;
    upperI     = ORD("I") << 8 ;   lowerI     = ORD("i") << 8 ;
    upperE     = ORD("E") << 8 ;   lowerE     = ORD("e") << 8 ;
    keyPgUp    = 00049H;
    keyPgDn    = 00051H;
    keyDel     = 00800H;
    keyF1      = 0003BH;
    keyF2      = 0003CH;
    keyF3      = 0003DH;
    keyF4      = 0003EH;
    keyF5      = 0003FH;
    keyF6      = 00040H;

(* ------------------------------------------------------------ *)

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE pause (n:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := 1 TO n DO waitVGAretrace(); END;
END pause;

CONST
    hires       = 13H; (* 320x200x256 *)
    text        = 03H; (* 80x25 *)
    xcount      = 320;
    ycount      = 200;
    xmin        = 0;
    xmax        = xcount-1;
    ymin        = 0;
    ymax        = ycount-1;
    cx          = xmax DIV 2;
    cy          = ymax DIV 2;
    screensize  = xcount * ycount;
    screensizeW = (screensize DIV 2);
    screen1     = 0;
    screen2     = 1;
    vscreen     = 2;
    firstscreen = screen1;
    lastscreen  = vscreen;
TYPE
    screenType = ARRAY [0..screensize-1] OF BYTE;   (* 320x200=64000 *)
(*%F INTERNAL *)
VAR
    PlasmaScreen : ARRAY [firstscreen..lastscreen] OF POINTER TO screenType;
(*%E *)
(*%T INTERNAL  *)
VAR
    wScreen1,wScreen2,wVscreen : screenType;
(*%E  *)
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase : ARRAY [ymin..ymax] OF CARDINAL;

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

PROCEDURE clearvideoscreen (inkndx:CARDINAL);
BEGIN
    Lib.FarWordFill(FarADR(videoscreen),screensizeW,(inkndx << 8 + inkndx));
END clearvideoscreen;

(*%F INTERNAL *)
PROCEDURE psplot (n,x,y:CARDINAL;ink:BYTE);
BEGIN
    PlasmaScreen[n]^[Ybase[y]+x]:=ink;
END psplot;

PROCEDURE pspoint (n,x,y:CARDINAL):CARDINAL;
BEGIN
    RETURN CARDINAL(PlasmaScreen[n]^[Ybase[y]+x]);
END pspoint;
(*%E *)

(*%T INTERNAL  *)
PROCEDURE splot1 (x,y:CARDINAL;ink:BYTE);
BEGIN
    wScreen1[Ybase[y]+x]:=ink;
END splot1;

PROCEDURE spoint1 (x,y:CARDINAL):CARDINAL;
BEGIN
    RETURN CARDINAL(wScreen1[Ybase[y]+x]);
END spoint1;

PROCEDURE splot2 (x,y:CARDINAL;ink:BYTE);
BEGIN
    wScreen2[Ybase[y]+x]:=ink;
END splot2;

PROCEDURE spoint2 (x,y:CARDINAL):CARDINAL;
BEGIN
    RETURN CARDINAL(wScreen2[Ybase[y]+x]);
END spoint2;

PROCEDURE sVplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    wVscreen[Ybase[y]+x]:=ink;
END sVplot;
(*%E  *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);

CONST
    egarange     = 040H;
    mininkindex  = 0;
    maxinkindex  = 256-1;
    ndxblack     = mininkindex;
    mincolorindex= 0;
    maxcolorindex= 256-1; (* we use 64 colors palette here *)
    ndxwhite     = maxinkindex;
TYPE
    triplet = RECORD
        r,g,b:SHORTCARD;
    END;
VAR
    orgpal     : ARRAY [0..255] OF triplet;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE setTheDAC(index,red,green,blue:CARDINAL );
BEGIN
    setDAC(index, BYTE(red), BYTE(green), BYTE(blue));
END setTheDAC;

PROCEDURE resetdac(slow:BOOLEAN;index,red,green,blue:CARDINAL);
BEGIN
    IF slow THEN pause(1);END;
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE getDAC (index:CARDINAL;VAR r,g,b:SHORTCARD);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END getDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    getDAC(index,r,g,b);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE savesystempal (  );
VAR
    i:CARDINAL;
BEGIN
    FOR i := 0 TO 255 DO
        getDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
    END;
END savesystempal;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

TYPE
    palettetype = (graypal,
                  rpal,gpal,bpal,
                  grispal,satinpal,systempal);

PROCEDURE newPalette (pal:palettetype;slow:BOOLEAN);
VAR
    alpha,ndx,n,i,j   : CARDINAL;
    r,g,b:BYTE;
    ir,ig,ib:CARDINAL;
    v,pi:LONGREAL;
    lim,lim2,lim3:LONGCARD;
BEGIN
    waitVGAretrace(); (* reduce noise on screen *)
    CASE pal OF
    | graypal:
        lim :=0808080H;
        lim2:=01F1F1FH;
        lim3:=02F2F2FH;
        ndx := 0;
                    n := 8 ;  blend (ndx,n,black   ,lim);
        INC(ndx,n); n := 16;  blend (ndx,n,lim,lim2);

        INC(ndx,n); n := 64;  blend (ndx,n,lim2,lim3);

        INC(ndx,n); n := 40;  blend (ndx,n,lim3,white);
        INC(ndx,n); n := 40;  blend (ndx,n,white,lim3);

        INC(ndx,n); n := 64;  blend (ndx,n,lim3,lim2);

        INC(ndx,n); n := 16;  blend (ndx,n,lim2   ,lim);
        INC(ndx,n); n := 8;  blend (ndx,n,lim,black);

    | rpal:
        ndx := 0;
                          n := 64; blend (ndx,n,black,red);
        INC(ndx,n);       n := 64; blend (ndx,n,red,yellow);
        INC(ndx,n);       n := 64; blend (ndx,n,yellow,red);
        INC(ndx,n);       n := 64; blend (ndx,n,red,black);
    | gpal:
        lim := 0082F04H;
        ndx := 0;
                           n :=64; blend (ndx,n,black,lim);
        INC(ndx,n);       n := 64; blend (ndx,n,lim,yellow);
        INC(ndx,n);       n := 64; blend (ndx,n,yellow,lim);
        INC(ndx,n);       n := 64; blend (ndx,n,lim,black);
    | bpal:
        lim:=004082FH;
        ndx := 0;
                           n :=64; blend (ndx,n,black,lim);
        INC(ndx,n);       n := 64; blend (ndx,n,lim,cyan);
        INC(ndx,n);       n := 64; blend (ndx,n,cyan,lim);
        INC(ndx,n);       n := 64; blend (ndx,n,lim,black);
    | grispal:

        alpha:=256;
        pi   :=4.0 * MATHLIB.ATan(1.0);
        FOR i:= mincolorindex TO maxcolorindex DO
            v:=pi * LONGREAL(alpha) / 128.0;
            v:=MATHLIB.Cos(v) * 127.0;
            n:=CARDINAL(v);
            INC(n,128);
            n:=n >> 2;
            r:=BYTE(n);
            g:=BYTE(n);
            b:=BYTE(n);
            setDAC(i,r,g,b);
            DEC(alpha);
        END;
    | satinpal:
        lim:=0E0E0E0H;
        ndx := 0;
                          n := 8;   blend (ndx,n,black,lim);
        INC(ndx,n);       n := 120; blend (ndx,n,lim,white);
        INC(ndx,n);       n := 120; blend (ndx,n,white,lim);
        INC(ndx,n);       n := 8;   blend (ndx,n,lim,black);
    | systempal: (* assume it was saved ! *)
        FOR i := 0 TO 255 DO
            setDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
        END;
    END;
(*
    setDAC(ndxblack,00H,00H,00H);    (* safety 0=black *)
*)
END newPalette;

PROCEDURE input (  );
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxDelay THEN EXIT; END;
    END;
END input;

PROCEDURE showPalette (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
    clearvideoscreen(ndxblack);
    FOR i := 0 TO 255 DO
        FOR ypos := ymin TO ymax DO
            p := ypos * xcount + i ;
            videoscreen[p]:=BYTE(i);
        END;
    END;
    input;
END showPalette;

(* ------------------------------------------------------------ *)

CONST
    minbyte  = 0;
    maxbyte  = 256-1;
VAR
    costable : ARRAY [minbyte..maxbyte] OF SHORTINT;

PROCEDURE initcostable (  );
VAR
    pi,angle,d1:LONGREAL;
    i : CARDINAL;
BEGIN
    pi := 4.0 * MATHLIB.ATan(1.0);
    FOR i:= minbyte TO maxbyte DO
        angle := pi*LONGREAL(i) / LONGREAL(128.0);
        d1 := MATHLIB.Cos(angle) * LONGREAL(127.0);
        costable[i] := SHORTINT(d1);
        (* IO.WrCard(i,4);IO.WrShtInt( costable[i], 4);WrLn; *)
    END;
END initcostable;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    seedtype = RECORD
        CASE : BOOLEAN OF
        | TRUE:   lc:LONGCARD;
        | FALSE:  t:ARRAY [1..3] OF SHORTINT;
        END;
    END;
    coeffstype = ARRAY [1..5] OF SHORTINT;

PROCEDURE f (v:SHORTINT):SHORTINT;
VAR
    p:CARDINAL;
BEGIN
    p:=CARDINAL(v) MOD 256;
    RETURN costable[ p ];
END f;

PROCEDURE index2 (a,b:SHORTINT   ):SHORTINT ;
VAR
    aa,bb:INTEGER;
BEGIN
    aa:=INTEGER(a);
    bb:=INTEGER(b);
    RETURN SHORTINT(aa+bb);
END index2;

PROCEDURE index3 (a,b,c:SHORTINT   ):SHORTINT ;
VAR
    aa,bb,cc:INTEGER;
BEGIN
    aa:=INTEGER(a);
    bb:=INTEGER(b);
    cc:=INTEGER(c);
    RETURN SHORTINT(aa+bb+cc);
END index3;

PROCEDURE doPlasma ( seed:seedtype; VAR coeffs:coeffstype);
VAR
    x,y,i:INTEGER ;
    ndx,a,b:SHORTINT;
    ink:BYTE;
    inka,inkb:CARDINAL;
BEGIN
(*# save *)
(*# call(inline=> on) *)
    FOR i:=1 TO 3 DO
        INC(coeffs[i],seed.t[i] );
    END;
    coeffs[4]:=f( coeffs[1] );
    coeffs[5]:=f( coeffs[2] );

    FOR y:=ymin TO ymax DO
        FOR x:=xmin TO xmax DO
            ndx:=index3 ( SHORTINT(x), coeffs[1], coeffs[3]);
            a  :=f( ndx );
            ndx:=index2 ( SHORTINT(y), coeffs[2]);
            b  :=f( ndx );
            ndx:=a+b;
            ink:=f( ndx );
            (*%F INTERNAL *) psplot(screen1,x,y, ink); (*%E *)
            (*%T INTERNAL *) splot1(x,y,ink);          (*%E *)
        END;
    END;

    FOR y:=ymin TO ymax DO
        FOR x:=xmin TO xmax DO
            ndx:=index2(SHORTINT(x), coeffs[5]);
            a  :=f( ndx );
            ndx:=index2(SHORTINT(y), coeffs[4]);
            b  :=f( ndx );
            ndx:=index3(a,b,coeffs[1]);
            a  :=f( ndx );
            ink:=BYTE( a );
            (*%F INTERNAL *) psplot(screen2,x,y, ink); (*%E *)
            (*%T INTERNAL *) splot2(x,y,ink);          (*%E *)
        END;
    END;

    FOR y:=ymin TO ymax DO
        FOR x:=xmin TO xmax DO
            (*%F INTERNAL *)
            inka  :=pspoint(screen1,x,y);
            inkb  :=pspoint(screen2,x,y);
            (*%E *)
            (*%T INTERNAL  *)
            inka  :=spoint1(x,y);
            inkb  :=spoint2(x,y);
            (*%E  *)
            ink:=BYTE( (inka+inkb) );
            (*%F INTERNAL *) psplot(vscreen,x,y, ink); (*%E *)
            (*%T INTERNAL *) sVplot(x,y,ink);          (*%E *)
        END;
    END;
(*# call(inline=> off) *)
(*# restore *)
END doPlasma;

PROCEDURE doNorm (VAR seed:seedtype );
VAR
    i : CARDINAL;
BEGIN
    FOR i:=1 TO 3 DO
        seed.t[i] := seed.t[i] AND 007H;
    END;
END doNorm;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "WOBBLER";
    ProgTitle     = "Q&D Wobbler";
    ProgVersion   = "v1.0";
    ProgCopyright = "adapted by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    dollar        = "$";
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParameter        = 3;
    errBadHex           = 4;
    errBadDec           = 5;
    errStrToCard        = 6;
    errRange            = 7;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [seed] [option]..."+nl+
nl+
"  -w:# number of waits for screen retrace ([0..10], default is 1)"+nl+
"  -m   end on mouseclick too"+nl+
"  -p   show palette until keypress or 10 seconds"+nl+
"  -n   do not normalize individual byte seed components to [$00..$07]"+nl+
"  -c:# palette number"+nl+
nl+
"Without seed, program will chose a random one [$000000..$FFFFFF]."+nl+
"Best results require individual byte seed components to be smaller than 8."+nl+
"[i|r|g|b|s|Tab]-palette, [PageUp|PageDn]-waits, [n]-normalize, [Del]-seed,"+nl+
"[F1..F6]-adjust individual byte seed components, [Space], [Return|Escape]."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParameter:
        Str.Concat(S,"Useless ",einfo);Str.Append(S," parameter !");
    | errBadHex    :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," hexadecimal value !");
    | errBadDec    :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," decimal value !");
    | errStrToCard :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errRange:
        Str.Concat(S,einfo," is out of range !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE cvalue (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END cvalue;

(* assume trimed uppercase *)

PROCEDURE StrToLong (S:ARRAY OF CHAR; lower,upper:LONGCARD;
                    VAR v : LONGCARD) : CARDINAL;
CONST
    digits    = "0123456789";
    hexdigits = "ABCDEF"+digits;
VAR
    ok : BOOLEAN;
    base : CARDINAL;
BEGIN
    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        IF verifyString(S,hexdigits)=FALSE THEN RETURN errBadHex;END;
        base := 16;
    ELSIF ( (S[0]="0") AND (S[1]="X") ) THEN
        Str.Delete(S,0,2);
        IF verifyString(S,hexdigits)=FALSE THEN RETURN errBadHex;END;
        base := 16;
    ELSE
        IF verifyString(S,digits)=FALSE THEN RETURN errBadDec;END;
        base := 10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF NOT(ok) THEN RETURN errStrToCard; END;
    IF ((v < lower) OR (v > upper)) THEN RETURN errRange;END;
    RETURN errNone;
END StrToLong;

PROCEDURE PadHex (v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    delta : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,16,ok);
    delta := digits - Str.Length(S);
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END PadHex;

PROCEDURE newint (VAR v:INTEGER;shifted:BOOLEAN;
                  small,big:INTEGER;lower,upper:INTEGER;roll:BOOLEAN );
VAR
    tmp:INTEGER;
BEGIN
    tmp:=v;
    IF shifted THEN
        INC(tmp,big);
    ELSE
        INC(tmp,small);
    END;
    IF tmp < lower THEN
        IF roll THEN
            v:=upper-ABS(lower-tmp);
        END;
    ELSIF tmp > upper THEN
        IF roll THEN
            v:=lower+ABS(tmp-upper);
        END;
    ELSE
        v:=tmp;
    END;
END newint;

PROCEDURE newcard (VAR v:CARDINAL;shifted:BOOLEAN;
                   small,big:INTEGER;lower,upper:CARDINAL;roll:BOOLEAN);
VAR
    vv:INTEGER;
BEGIN
    vv:=INTEGER(v);
    newint( vv, shifted, small,big, INTEGER(lower), INTEGER(upper), roll );
    v:=CARDINAL(vv);
END newcard;

PROCEDURE newseed (adj:INTEGER;ndx:CARDINAL; normalize:BOOLEAN;
                  VAR seed:seedtype  );
VAR
    vv,lower,upper:INTEGER;
BEGIN
    vv:=INTEGER(seed.t[ndx]);
    lower:=MIN(SHORTINT);
    upper:=MAX(SHORTINT);
    newint( vv, FALSE, adj,adj, lower,upper, TRUE );
    seed.t[ndx]:=SHORTINT(vv);
    IF normalize THEN doNorm(seed);END;
END newseed;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    mingWait     = 0;
    maxgWait     = 10;
    defaultgWait = 1;
    minseed      = LONGCARD(0);
    maxseed      = LONGCARD(0FFFFFFH);
VAR
    parmcount,i,opt:CARDINAL;
    S,R:str128;
    normalize,showThePalette,stopmouse,autoincr:BOOLEAN;
    palette:palettetype;
    iv:INTEGER;
    gWait,keycode,v:CARDINAL;
    state:(waiting,gotseed);
    seed:seedtype;
    coeffs:coeffstype;
BEGIN
    WrLn;                       (* must be here for pretty ulterior display ! *)

    gWait        := defaultgWait;
    stopmouse    := FALSE;
    showThePalette:=FALSE;
    normalize    := TRUE;
    autoincr     := FALSE; (* TRUE is not pretty anyway *)
    palette      := graypal;
    state        := waiting;

    doRandomize();
    seed.lc      := LCgetrndrange(minseed,maxseed);

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "M"+delim+"MOUSE"+delim+
                                   "P"+delim+"PALETTE"+delim+
                                   "W:"+delim+"WAITS:"+delim+
                                   "N"+delim+"NORMALIZE"+delim+
                                   "C:"+delim+"COLOR:"
                               );
            CASE opt OF
            | 1,2,3: abort(errHelp,"");
            | 4,5 :  stopmouse   := TRUE;
            | 6,7 :  showThePalette:=TRUE;
            | 8,9 :  IF cvalue(R,mingWait,maxgWait,gWait)=FALSE  THEN
                         abort(errRange,S);
                     END;
            | 10,11: normalize := FALSE;
            | 12,13:
                IF cvalue(R,ORD(graypal),ORD(satinpal),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            ELSE
                abort(errOption,S);
            END;
        ELSE
            CASE state OF
            | waiting:
                opt:=StrToLong(R,minseed,maxseed,seed.lc);
                IF opt # errNone THEN abort(opt,R);END;
            | gotseed: abort(errParameter,S);
            END;
            INC(state);
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    initcostable();
    initYbase();

    (*%F INTERNAL *)
    NEW(PlasmaScreen[screen1]);
    NEW(PlasmaScreen[screen2]);
    NEW(PlasmaScreen[vscreen]);
    (*%E *)

    savesystempal;
    setVideoMode(hires);
    newPalette(palette,FALSE);

    IF showThePalette THEN showPalette; END;

    clearvideoscreen(ndxblack);

    flushKeyboard;

    FOR i:=1 TO 3 DO
        coeffs[i]:= SHORTINT( getrndrangeint ( MIN( SHORTINT), MAX( SHORTINT)));
    END;

    IF normalize THEN doNorm(seed);END;

    LOOP
        doPlasma(seed,coeffs);
(*
(*%F INTERNAL *) FarWordMove(FarADR(PlasmaScreen[screen1]^),FarADR(videoscreen),screensizeW); (*%E *)
(*%T INTERNAL *) FarWordMove(FarADR(wScreen1),FarADR(videoscreen),screensizeW); (*%E *)
input;
(*%F INTERNAL *) FarWordMove(FarADR(PlasmaScreen[screen2]^),FarADR(videoscreen),screensizeW); (*%E *)
(*%T INTERNAL *) FarWordMove(FarADR(wScreen2),FarADR(videoscreen),screensizeW); (*%E *)
input;
*)
        pause(gWait);
        (*%F INTERNAL *)
        Lib.FarWordMove(FarADR(PlasmaScreen[vscreen]^),FarADR(videoscreen),screensizeW);
        (*%E *)
        (*%T INTERNAL *)
        Lib.FarWordMove(FarADR(wVscreen),FarADR(videoscreen),screensizeW);
        (*%E *)

        IF autoincr THEN FOR i:=1 TO 3 DO INC( seed.t[i]); END; END;

        IF getKeyboardCode(keycode) THEN
            CASE keycode OF
            | keySpace        : input;
            | keyEscape,keyCR : EXIT;
            | lowerI,upperI,keyStar : palette:=graypal;newPalette(palette,FALSE );
            | lowerR,upperR : palette:=rpal;newPalette(palette,FALSE );
            | lowerG,upperG : palette:=gpal;newPalette(palette,FALSE );
            | lowerB,upperB : palette:=bpal;newPalette(palette,FALSE );
            | lowerS,upperS : palette:=satinpal;newPalette(palette,FALSE );
            | lowerE,upperE : palette:=grispal;newPalette(palette,FALSE );
            | keyTAB:
                IF palette = satinpal THEN
                    palette:=graypal;
                ELSE
                    INC(palette);
                END;
                newPalette(palette,FALSE );
            | keyTABshift:
                IF palette = graypal THEN
                    palette:=satinpal;
                ELSE
                    DEC(palette);
                END;
                newPalette(palette,FALSE );
            | keyPgUp:
                newcard (gWait, FALSE,-1,-1,mingWait,maxgWait, FALSE);
            | keyPgDn:
                newcard (gWait, FALSE, 1, 1,mingWait,maxgWait, FALSE);
            | keyDel:
                seed.lc      := LCgetrndrange(minseed,maxseed);
                IF normalize THEN doNorm(seed);END;
            | keyF1: newseed( 1,3,normalize,seed);
            | keyF2: newseed(-1,3,normalize,seed);
            | keyF3: newseed( 1,2,normalize,seed);
            | keyF4: newseed(-1,2,normalize,seed);
            | keyF5: newseed( 1,1,normalize,seed);
            | keyF6: newseed(-1,1,normalize,seed);
            | lowerN,upperN : normalize:=NOT(normalize);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    newPalette(systempal,FALSE);
    setVideoMode(text);

    Str.Concat(S,"$",PadHex(seed.lc,6));
    Str.Lows(S);
    Str.Prepend(S,"Seed was ");
    WrStr(S);WrLn;

    abort(errNone,"");
END wobbler.

