
(* --------------------------------------------------------------
Title         see help
Author        see help
Overview      see help
Usage         see help
Notes         pseudo brownian motion is ugly and was removed
              (search BROWNIAN)
Bugs

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE TVstatic;

IMPORT Graph;
IMPORT IO;
IMPORT Lib;
IMPORT Str;
IMPORT MsMouse;
IMPORT BiosIO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    BROWNIAN = FALSE;

CONST
    minpal      = 1;
    maxpal      = 6;
    minelement  = 1;
    maxelement  = 30000;
    minprop     = 0;
    maxprop     = 100;
    minmode     = 1;
    maxmode     = 2; (* 3 if BROWNIAN *)
    mindelay    = 0;
    maxdelay    = 100;
CONST
    defaultpal  = 1;
    defaultelements = 5000;
    defaultprop = 1;
    defaultmode = 1; (* beware of BROWNIAN FALSE ! *)
    defaultdelay= 0;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "STATIC";
    ProgTitle     = "Q&D Static TV screen";
    ProgVersion   = "v1.0a";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errBadParm        = 2;
    errBadOpt         = 3;
    errRange          = 4;
    errCannotSetMode  = 5;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [elements] [option]..."+nl+
nl+
"  -l    low resolution (320x200) mode"+nl+
"  -l:#  percentage of lines in static noise [0..100], default is 1"+nl+
"  -p:#  palette [1..6], default is 1"+nl+
"  -m:#  noise mode [1..2], default is 1"+nl+
"  -d:#  delay in milliseconds [0..100], default is 0"+nl+
"  -s    slow static noise fade at exit"+nl+
"  -k    ignore mouse click"+nl+
"  -v    verbose"+nl+
"  -x    just turn screen off ;-)"+nl+
nl+
"Number of elements belongs to [1..30000] interval, default is 5000."+nl+
nl
+"Keys while running : [Return|Escape], [PageUp|PageDn], [+|-], [M], [C]"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errBadParm:
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errBadOpt:
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetMode:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," video mode !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doRandomize (  );
BEGIN
    Lib.RANDOMIZE;
END doRandomize;

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE getvallong (S:ARRAY OF CHAR;mini,maxi:LONGCARD;
                     VAR v:LONGCARD):BOOLEAN;
CONST
    colon = ":";
    equal = "=";
VAR
    p,base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Subst(S,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(S,colon);
    IF p # MAX(CARDINAL) THEN Str.Delete(S,0,p+1); END;
    CASE S[0] OF
    | "$":
       base:=16;Str.Delete(S,0,1);
    | "0":
       CASE S[1] OF
       | "X","x":base:=16;Str.Delete(S,0,2);
       END;
    ELSE
       base:=10;
    END;
    v := Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE;END;
    IF v < mini THEN RETURN FALSE;END;
    IF v > maxi THEN RETURN FALSE;END;
    RETURN TRUE;
END getvallong;

PROCEDURE getval (S:ARRAY OF CHAR;mini,maxi:CARDINAL;
                 VAR v:CARDINAL):BOOLEAN;
VAR
    lc:LONGCARD;
BEGIN
    IF getvallong(S,LONGCARD(mini),LONGCARD(maxi),lc)=FALSE THEN
        RETURN FALSE;
    ELSE
        v:=CARDINAL(lc);
        RETURN TRUE;
    END;
END getval;

(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 0001BH;
    keySpace   = 00020H;
    keyCR      = 0000DH;
    keyPageUp  = 04900H;
    keyPageDn  = 05100H;
    keyM       = ORD("M");
    keym       = ORD("m");
    keyC       = ORD("C");
    keyc       = ORD("c");
    keyPlus    = ORD("+");
    keyMinus   = ORD("-");

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

(* keycode format is fixed and logical here ! *)

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c2) << 8) + ORD(c1);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    xmin         = 0;
    ymin         = 0;
VAR
    sMode        : str16;
    hires        : CARDINAL;
    screenwidth  : CARDINAL;
    screenheight : CARDINAL;
    xmax         : CARDINAL;
    ymax         : CARDINAL;
    cx,cy        : INTEGER;
    zmax         : CARDINAL;
    (* to avoid casts *)
    iscreenwidth  : INTEGER;
    iscreenheight : INTEGER;
    ixmax         : INTEGER;
    iymax         : INTEGER;

PROCEDURE initHires (VAR gmode:CARDINAL); (* just in case we need to fix it ! *)
BEGIN
    CASE gmode OF
    | Graph._MRES16COLOR:
        Str.Copy(sMode,"320x200x16");
        screenwidth  := 320;
        screenheight := 200;
    ELSE
        Str.Copy(sMode,"640x480x16");
        screenwidth  := 640;
        screenheight := 480;
        gmode        := Graph._VRES16COLOR;
    END;
    zmax         := screenwidth DIV 2; (* was screenheight, higher values are not pretty *)
    xmax        := screenwidth  -1;
    ymax        := screenheight -1;
    cx          := INTEGER(xmax DIV 2);
    cy          := INTEGER(ymax DIV 2);
    (* to avoid casts *)
    iscreenwidth  := INTEGER(screenwidth);
    iscreenheight := INTEGER(screenheight);
    ixmax         := INTEGER(xmax);
    iymax         := INTEGER(ymax);
END initHires;

PROCEDURE HiresON (gmode:CARDINAL ):BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(gmode);
END HiresON;

PROCEDURE HiresOFF ();
VAR
    rc : BOOLEAN;
BEGIN
    rc := Graph.SetVideoMode(Graph._DEFAULTMODE);
END HiresOFF;

PROCEDURE ClearPage(paper:LONGCARD);
VAR
    rgb:LONGCARD;
BEGIN
    rgb:=Graph.SetBkColor(paper);
    Graph.ClearScreen(Graph._GCLEARSCREEN);
END ClearPage;

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE pause (n:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i:=1 TO n DO waitVGAretrace();END;
END pause;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ndxinkmin   = 0; (* 0 is reserved as black *)
    ndxinkmax   = 16-1;
    ndxinkblack = 0;
    paperblack  = Graph._BLACK;
    paperwhite  = Graph._BRIGHTWHITE;
    colorrange  = 64;
    colorpals   = 4;
CONST
    black       = LONGCARD(0000000H);
    darkgray    = LONGCARD(0181818H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    red         = LONGCARD(03F0000H);
    darkred     = LONGCARD(0200000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    yellow      = LONGCARD(03F3F00H);
    orange      = LONGCARD(02F2F00H);
    cyan        = LONGCARD(0002F3FH);

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    egarange = 40H;  (* EGA/VGA is limited to $00..$3F *)
    rshift   = LONGCARD(16);
    gshift   = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r > egarange-1 THEN r:=egarange-1; END;
        IF g > egarange-1 THEN g:=egarange-1; END;
        IF b > egarange-1 THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE MakePalette (palette:CARDINAL);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
BEGIN
    waitVGAretrace;
    ndx:=0; n:=16;
    CASE palette OF
    | 1: blend (ndx,n,darkgray,white);
    | 2: blend (ndx,n,darkblue,white);
    | 3: blend (ndx,n,blue,white);
    | 4: blend (ndx,n,orange,yellow);
    | 5: blend (ndx,n,darkblue,blue);
    | 6: blend (ndx,n,darkgreen,green);
    END;
    setDAC(ndxinkblack, 00H,00H,00H); (* reset black *)
END MakePalette;

PROCEDURE getDAC (index:CARDINAL;VAR r,g,b:SHORTCARD);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END getDAC;

PROCEDURE palfadeto (r,g,b:SHORTCARD;n:CARDINAL );
VAR
    i,changed:CARDINAL;
    rr,gg,bb:SHORTCARD;
BEGIN
    LOOP
        changed:=0;
        pause(n);
        FOR i:=ndxinkmin TO ndxinkmax DO
            getDAC (i, rr,gg,bb);
            IF rr # r THEN
                IF rr < r THEN
                    INC(rr);
                ELSE
                    DEC(rr);
                END;
                INC(changed);
            END;
            IF gg # g THEN
                IF gg < g THEN
                    INC(gg);
                ELSE
                    DEC(gg);
                END;
                INC(changed);
            END;
            IF bb # b THEN
                IF bb < b THEN
                    INC(bb);
                ELSE
                    DEC(bb);
                END;
                INC(changed);
            END;

            setDAC(i, rr,gg,bb);
        END;
        IF changed=0 THEN EXIT; END;
    END;
END palfadeto;

PROCEDURE palfadetowhite (n:CARDINAL);
BEGIN
    palfadeto(03FH,03FH,03FH, n);
END palfadetowhite;

PROCEDURE palfadetoblack (n:CARDINAL);
BEGIN
    palfadeto(000H,000H,000H, n);
END palfadetoblack;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*%T BROWNIAN  *)
VAR (* the old way ! globerk and an array for each component ! what a mess ! *)
    px    : ARRAY [minelement..maxelement] OF CARDINAL;
    py    : ARRAY [minelement..maxelement] OF CARDINAL;
    pink  : ARRAY [minelement..maxelement] OF CARDINAL;
    isdot : ARRAY [minelement..maxelement] OF BOOLEAN;
(*%E *)

PROCEDURE dependancies (elements,proportion:CARDINAL;
                       VAR requiredlines,requireddots,wiline:CARDINAL);
BEGIN
    requiredlines:=CARDINAL( (LONGCARD(elements) * LONGCARD(proportion)) DIV 100);
    requireddots :=elements-requiredlines;
    wiline       :=screenwidth DIV 100;    wiline:=wiline DIV 2;
END dependancies;

PROCEDURE setup  (noisemode,dots,lines:CARDINAL);
VAR
    i,x,y,ink:CARDINAL;
    drawdot:BOOLEAN;
BEGIN
    CASE noisemode OF
    | 1: ;
    | 2: ;
(*%T BROWNIAN  *)
    | 3:
        IF dots=0 THEN INC(dots);END;
        IF lines=0 THEN INC(lines);END;
        i:=minelement;
        LOOP
            px[i]:=getrndrange(xmin,xmax);
            py[i]:=getrndrange(ymin,ymax);
            pink[i]:=getrndrange(ndxinkmin,ndxinkmax);

            IF getrndrange(1,10) < 5 THEN
                drawdot:=(dots # 0);
            ELSE
                drawdot:=(lines = 0);
            END;

            IF drawdot THEN
                isdot[i]:=TRUE;
                DEC(dots);
                INC(i);
            ELSE
                isdot[i]:=FALSE;
                DEC(lines);
                INC(i);
            END;
            IF ( (lines=0) AND (dots=0) ) THEN EXIT; END;
        END;
(*%E  *)
    END;
END setup;

PROCEDURE update (noisemode,dots,lines,wi:CARDINAL);
CONST
    probaforbigdot = 9; (* 90% change for a tiny dot *)
VAR
    i,count:CARDINAL;
    x,y,ink:CARDINAL;
    drawdot:BOOLEAN;
    xpos,ypos:INTEGER;
BEGIN
    waitVGAretrace;
    ClearPage (paperblack);
    CASE noisemode OF
    | 1:
        LOOP
            x:=getrndrange(xmin,xmax);
            y:=getrndrange(ymin,ymax);
            ink:=getrndrange(ndxinkmin,ndxinkmax);

            IF getrndrange(1,10) < 5 THEN
                drawdot:=(dots # 0);
            ELSE
                drawdot:=(lines = 0);
            END;

            IF drawdot THEN
                IF getrndrange(1,10) > probaforbigdot THEN
                   (* Graph.Disc(x,y,1,ink); *)
                   Graph.Rectangle(x,y,x+1,y+1,ink,TRUE);
                ELSE
                   Graph.Plot(x,y,ink);
                END;
                DEC(dots);
            ELSE
                Graph.Line(x-wi,y,x+wi,y,ink);
                DEC(lines);
            END;

            IF ( (lines=0) AND (dots=0) ) THEN EXIT; END;
        END;
    | 2:
        LOOP
            x:=getrndrange(xmin,xmax);
            y:=getrndrange(ymin,ymax);
            ink:=getrndrange(ndxinkmin,ndxinkmax);

            IF getrndrange(1,10) < 5 THEN
                drawdot:=(dots # 0);
            ELSE
                drawdot:=(lines = 0);
            END;

            IF drawdot THEN
                Graph.Plot(x,y,ink);
                DEC(dots);
            ELSE
                Graph.Line(x-wi,y,x+wi,y,ink);
                DEC(lines);
            END;

            IF ( (lines=0) AND (dots=0) ) THEN EXIT; END;
        END;

(*%T BROWNIAN  *)
    | 3:
        count:=dots+lines;
        FOR i:=minelement TO count DO
            x:=px[i];
            y:=py[i];
            ink:=pink[i];
            IF isdot[i] THEN
                Graph.Plot(x,y,ink);

                xpos:=INTEGER(x)+getrndrangeint(-2,+2);
                ypos:=INTEGER(y)+getrndrangeint(-2,+2);
                IF (xpos < xmin) OR (xpos > ixmax) OR (ypos < ymin) OR (ypos > iymax) THEN
                    px[i]:=getrndrange(xmin,xmax);
                    py[i]:=getrndrange(ymin,ymax);
                    pink[i]:=getrndrange(ndxinkmin,ndxinkmax);
                ELSE
                    px[i]:=CARDINAL(xpos);
                    py[i]:=CARDINAL(ypos);
                END;
            ELSE
                Graph.Line(x-wi,y,x+wi,y,ink);

                px[i]:=getrndrange(xmin,xmax);
                py[i]:=getrndrange(ymin,ymax);
                pink[i]:=getrndrange(ndxinkmin,ndxinkmax);
            END;
        END;
(*%E  *)
    END;
END update;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE clearvideoscreenline (y,ink:CARDINAL   );
BEGIN
    Graph.Line(xmin,y,xmax,y,ink);
END clearvideoscreenline;

PROCEDURE vplot (x,y,ink:CARDINAL);
BEGIN
    Graph.Plot(x,y,ink);
END vplot;

PROCEDURE zcircle (filled:BOOLEAN;cx,cy,r,ink:CARDINAL   );
BEGIN
    IF filled THEN
        Graph.TrueDisc(cx,cy,r,ink);
    ELSE
        Graph.TrueCircle(cx,cy,r,ink);
    END;
END zcircle;

(* fade palette to black while still showing moving static ! *)

PROCEDURE killstatic(fast:BOOLEAN; noisemode,dots,lines,wi:CARDINAL);
CONST
    numerator = 0;    (* after all, it's NOT pretty *)
    divisor   = 100;
VAR
    i,changed:CARDINAL;
    r,g,b,rr,gg,bb:SHORTCARD;
    v:LONGCARD;
BEGIN
    r:=0; g:=0; b:=0; (* fade to black while updating screen *)
    LOOP
        IF fast THEN
            v:=LONGCARD(dots) * numerator; dots:=CARDINAL(v DIV divisor);
            v:=LONGCARD(lines)* numerator; dots:=CARDINAL(v DIV divisor);
        END;
        update(noisemode,dots,lines,wi);
        changed:=0;

        pause(0);

        FOR i:=ndxinkmin TO ndxinkmax DO
            getDAC (i, rr,gg,bb);
            IF rr # r THEN
                IF rr < r THEN
                    INC(rr);
                ELSE
                    DEC(rr);
                END;
                INC(changed);
            END;
            IF gg # g THEN
                IF gg < g THEN
                    INC(gg);
                ELSE
                    DEC(gg);
                END;
                INC(changed);
            END;
            IF bb # b THEN
                IF bb < b THEN
                    INC(bb);
                ELSE
                    DEC(bb);
                END;
                INC(changed);
            END;

            setDAC(i, rr,gg,bb);
        END;
        IF changed=0 THEN EXIT; END;
    END;
    (* let's force screen to BE what it LOOKS *)
    ClearPage (paperblack);
END killstatic;

PROCEDURE turnedOFF(alone:BOOLEAN);
CONST
    speed          = 16; (* the higher the faster *)
    speedcircle    = 8;
    speedfadewhite = 0;

    blanc     = ndxinkmax;
    grisclair = blanc-1;
    grisfonce = blanc-2;
    noir      = ndxinkblack;

    outerrad  = 2;

    orgcode   = FALSE;
VAR
    v:SHORTCARD;
    i,y,j,r:CARDINAL;
ch:CHAR;
BEGIN
    IF alone THEN
        i:=2; (* weird stuff ! *)
    ELSE
        i:=speedfadewhite;
    END;
    palfadetowhite( i );

    ClearPage(paperwhite);

    pause(1);
    v:=colorrange-1;         setDAC(blanc, v,v,v);

    v:=3*(colorrange DIV 4); setDAC(grisclair , v,v,v);

    v:=2*(colorrange DIV 4); setDAC(grisfonce , v,v,v);

    v:=00H;                  setDAC(noir, v,v,v);

    FOR i:=ymin TO (ymax DIV 2) DO
        IF (i MOD speed) = 0 THEN pause(1); END;
        clearvideoscreenline(i,noir);
        clearvideoscreenline(ymax-i,noir);

        clearvideoscreenline(i+1,grisclair);
        clearvideoscreenline(ymax-i-1,grisclair);
    END;
    i:=(ymax DIV 2)+1;
    clearvideoscreenline(i,noir);

    (* from leftright to center *)

    y:=(ymax DIV 2);
    FOR i:=xmin TO (xmax DIV 2) DO
        IF (i MOD speed * 1) = 0 THEN pause(1); END;
        vplot(i,y,noir);
        vplot(xmax-i,y,noir);
        vplot(i+1,y,blanc);
        vplot(xmax-i-1,y,blanc);
    END;
    vplot(cx,cy,grisfonce); pause(speedcircle);
    vplot(cx,cy,grisclair); pause(speedcircle);

    (* twinkle *)

(*%T orgcode *)
    FOR i:=2 TO 4 DO
        pause(speedcircle);
        zcircle (FALSE, cx,cy, i  ,grisfonce);
        zcircle (TRUE,  cx,cy, i-1,grisclair);
        zcircle (TRUE,  cx,cy, i-2,blanc);
    END;

    FOR i:=4 TO 2 BY -1 DO
        pause(speedcircle);
        zcircle (FALSE, cx,cy, i  ,noir);
        zcircle (TRUE,  cx,cy, i-1,grisfonce);
        zcircle (TRUE,  cx,cy, i-2,grisclair);
        zcircle (TRUE,  cx,cy, i-3,blanc);
    END;

    pause( speedcircle );

    FOR i:=2 TO 0 BY -1 DO
        pause(speedcircle);
        zcircle (FALSE, cx,cy, i  ,noir);
    END;
(*%E  *)
(*%F orgcode  *)
    FOR j:=1 TO 3 DO
        FOR i:=1 TO outerrad DO
            pause(speedcircle);
            CASE j OF
            | 1:
                r:=i;
                (*
                zcircle (FALSE, cx,cy, r,grisfonce);
                IF r > 1 THEN zcircle (FALSE, cx,cy, r-1,grisclair); END;
                IF r > 2 THEN zcircle (FALSE, cx,cy, r-2,blanc); END;
                *)
                zcircle(TRUE,cx,cy,r,blanc);
                zcircle(FALSE,cx,cy,r+1,grisclair);
                zcircle(FALSE,cx,cy,r+2,grisfonce);
                zcircle(TRUE,cx,cy,r,blanc); (* just in case... *)
            | 2:
                ;
            | 3:
                r:=outerrad-i+1;
                (*
                zcircle (FALSE, cx,cy, r,noir);
                IF r > 1 THEN zcircle (FALSE, cx,cy, r-1,grisfonce); END;
                IF r > 2 THEN zcircle (FALSE, cx,cy, r-2,grisclair); END;
                *)
                zcircle(FALSE,cx,cy,r+2,noir);
                zcircle(FALSE,cx,cy,r+1,grisfonce);
                zcircle(FALSE,cx,cy,r,grisclair);
            END;
(* ch:=BiosIO.RdKey(); *)
        END;
    END;
    zcircle(TRUE,cx,cy,2,noir); pause(speedcircle);
    zcircle(TRUE,cx,cy,1,noir); pause(speedcircle);
(*%E  *)
END turnedOFF;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    big=100;
    small=1;
VAR
    palette,elements,proportion,noisemode,delay,gmode:CARDINAL;
    requireddots,requiredlines,wiline:CARDINAL;
    stopmouse,verbose,singlestep,chk,turnitoff,fastnoisefade:BOOLEAN;
    keycode:CARDINAL;
VAR
    parmcount,i,opt:CARDINAL;
    S,R:str128;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    elements     := defaultelements;
    proportion   := defaultprop;
    palette      := defaultpal;
    noisemode    := defaultmode; (* only 1 if BROWNIAN is FALSE *)
    delay        := defaultdelay;
    stopmouse    := TRUE;
    verbose      := FALSE;
    turnitoff    := FALSE;
    fastnoisefade:= TRUE;
    gmode        := Graph._VRES16COLOR;

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "K"+delim+"KEYPRESS"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "M:"+delim+"MODE:"+delim+
                                   "L:"+delim+"LINES:"+delim+
                                   "D:"+delim+"DELAY:"+delim+
                                   "V"+delim+"VERBOSE"+delim+
                                   "X"+delim+"OFF"+delim+
                                   "S"+delim+"SLOWFADE"+delim+
                                   "L"+delim+"LO"+delim+"LORES"+delim+"LOWRES"+delim+
                                   "3"+delim+"320"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   stopmouse:=FALSE;
            | 6,7:    IF getval(R,minpal,maxpal,palette)=FALSE THEN
                          abort(errRange,"palette");
                      END;
            | 8,9:    IF getval(R,minmode,maxmode,noisemode)=FALSE THEN
                          abort(errRange,"noise mode");
                      END;
            | 10,11:  IF getval(R,minprop,maxprop,proportion)=FALSE THEN
                          abort(errRange,"percentage of lines");
                      END;
            | 12,13:  IF getval(R,mindelay,maxdelay,delay)=FALSE THEN
                          abort(errRange,"delay");
                      END;
            | 14,15:  verbose:=TRUE;
            | 16,17:  turnitoff:=TRUE;
            | 18,19:  fastnoisefade:=FALSE;
            | 20,21,22,23: gmode:=Graph._MRES16COLOR;
            | 24,25:       gmode:=Graph._MRES16COLOR;
            ELSE
                abort(errBadOpt,S);
            END;
        ELSE
            Str.Prepend(R,"N:");
            IF getval(R,minelement,maxelement,elements)=FALSE THEN
                abort(errRange,"number of elements");
            END;
            (* abort(errIllegalParm,S); *)
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    doRandomize;

    initHires(gmode);

    IF HiresON(gmode) = FALSE THEN
        HiresOFF;
        abort(errCannotSetMode,sMode);
    END;

    MakePalette(palette);
    ClearPage (paperblack);

IF turnitoff THEN
    turnedOFF(TRUE);
ELSE

    flushKeyboard();
    singlestep := FALSE;

    dependancies (elements,proportion,  requiredlines,requireddots,wiline);

    setup(noisemode,requireddots,requiredlines);

    LOOP
        (* waitVGAretrace; *)
        IF delay # 0 THEN Lib.Delay(delay); END; (* milliseconds *)

        update(noisemode,requireddots,requiredlines,wiline);

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | keyEscape     : EXIT;
            | keyCR         : EXIT;
            | keySpace      : singlestep:=NOT (singlestep);
            | keyPageUp     : IF elements < (maxelement-big) THEN
                                  INC(elements,big);
                                  dependancies (elements,proportion,
                                               requiredlines,requireddots,wiline);
                              END;
            | keyPageDn     : IF elements > (minelement+big) THEN
                                  DEC(elements,big);
                                  dependancies (elements,proportion,
                                               requiredlines,requireddots,wiline);
                              END;
            | keyM,keym     : CASE noisemode OF
                              | 1:noisemode:=2;
                              | 2:noisemode:=1;
                              END;
            | keyC,keyc     : IF palette < maxpal THEN
                                  INC(palette);
                              ELSE
                                  palette:=minpal;
                              END;
                              MakePalette(palette);
            | keyPlus       : IF proportion < (maxprop-small) THEN
                                  INC(proportion,small);
                                  dependancies (elements,proportion,
                                               requiredlines,requireddots,wiline);
                              END;
            | keyMinus      : IF proportion > (minprop+small) THEN
                                  DEC(proportion,small);
                                  dependancies (elements,proportion,
                                               requiredlines,requireddots,wiline);
                              END;
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;

    IF keycode=keyCR THEN
        IF fastnoisefade=FALSE THEN
            killstatic(fastnoisefade,noisemode,requireddots,requiredlines,wiline);
        END;
        turnedOFF(FALSE);
    END;

END;

    HiresOFF;

    IF verbose THEN
        WrStr (ProgEXEname+" "); IO.WrCard(elements,-1);
        WrStr(" -l:");           IO.WrCard(proportion,-1);
        WrStr(" -p:");           IO.WrCard(palette,-1);
        WrStr(" -m:");           IO.WrCard(noisemode,-1);
        WrStr(" -d:");           IO.WrCard(delay,-1);
        WrLn;
    END;

    abort(errNone,"");
END TVstatic.

