
MODULE splines;

IMPORT Graph;
IMPORT IO;
IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows;

FROM IO IMPORT WrStr,WrLn;

(* ------------------------------------------------------------ *)


CONST
    xmin = 0;
    xmax = 640;
    ymin = 0;
    ymax = 480;

    FIRSTKNOT = 1-1;
    MAXKNOT   = 100+1+1;

    black  = 0;
    white  = 15;
    yellow = 14;
    mauve  = 13;
    red    = 12;
    blue   = 11;

    RADIUS = 4;

CONST
    start = 1;
VAR
    NumPts   : CARDINAL;
    Res      : CARDINAL;
    MinDelta : CARDINAL;
    MaxDelta : CARDINAL;

PROCEDURE defaults (  );
BEGIN
    Res      := 10;
    NumPts   :=  5;
    MinDelta :=  1;
    MaxDelta :=  4;
END defaults;

(* ------------------------------------------------------------ *)

PROCEDURE WaitVGAretrace (n:CARDINAL );
VAR
    i:CARDINAL;
BEGIN
    FOR i:=1 TO n DO
        WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
        END;
        WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
        END;
    END;
END WaitVGAretrace;

PROCEDURE HiresON () : BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(Graph._VRES16COLOR);
END HiresON;

PROCEDURE HiresOFF() : BOOLEAN;
BEGIN
    RETURN Graph.SetVideoMode(Graph._DEFAULTMODE);
END HiresOFF;

PROCEDURE line (x1,y1,x2,y2:INTEGER;ink:CARDINAL);
BEGIN
    IF x1 < xmin THEN RETURN; END;
    IF x1 >=xmax THEN RETURN; END;
    IF y1 < ymin THEN RETURN; END;
    IF y1 >=ymax THEN RETURN; END;
    IF x2 < xmin THEN RETURN; END;
    IF x2 >=xmax THEN RETURN; END;
    IF y2 < ymin THEN RETURN; END;
    IF y2 >=ymax THEN RETURN; END;
    Graph.Line(CARDINAL(x1),CARDINAL(y1),CARDINAL(x2),CARDINAL(y2),ink);
END line;

(* ------------------------------------------------------------ *)

(* globerk ! *)

VAR
    x : ARRAY [FIRSTKNOT..MAXKNOT] OF REAL;
    y : ARRAY [FIRSTKNOT..MAXKNOT] OF REAL;
    dx: ARRAY [FIRSTKNOT..MAXKNOT] OF REAL;
    dy: ARRAY [FIRSTKNOT..MAXKNOT] OF REAL;

(* ------------------------------------------------------------ *)

PROCEDURE newdelta (lower,limit:CARDINAL) : REAL;
VAR
    delta : INTEGER;
BEGIN
    LOOP
        delta :=Lib.RANDOM(limit*2+1)-limit;
        IF ABS(delta) >= INTEGER(lower) THEN EXIT; END;
    END;
    RETURN REAL(delta);
END newdelta;

PROCEDURE init_knots (first,N:CARDINAL);
VAR
    i,last : CARDINAL;
BEGIN
    last := first+N-1;
    Lib.RANDOMIZE;
    FOR i := first TO last DO
        x[i]:=REAL(Lib.RANDOM(xmax));
        y[i]:=REAL(Lib.RANDOM(ymax));
        dx[i]:=newdelta(MinDelta,MaxDelta);
        dy[i]:=newdelta(MinDelta,MaxDelta);
    END;
END init_knots;

PROCEDURE move_knots (first,last:CARDINAL);
VAR
    i : CARDINAL;
    t : REAL;
BEGIN
    FOR i := first TO last DO
        LOOP
            t := x[i] + dx[i];
            IF (t >= REAL(xmin) ) AND (t < REAL(xmax) ) THEN EXIT; END;
            dx[i] := newdelta(MinDelta,MaxDelta);
        END;
        x[i] := t;
        LOOP
            t := y[i] + dy[i];
            IF (t >= REAL(ymin) ) AND (t < REAL(ymax) ) THEN EXIT; END;
            dy[i] := newdelta(MinDelta,MaxDelta);
        END;
        y[i] := t;
    END;
END move_knots;

(* ------------------------------------------------------------ *)

PROCEDURE show_knots (first,last,ink : CARDINAL );
VAR
    i,r : CARDINAL;
BEGIN
    r := RADIUS;
    FOR i := first TO last DO
        Graph.Circle(CARDINAL(x[i]),CARDINAL(y[i]), r ,ink);
    END;
END show_knots;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE BernsteinBezier (first,N : CARDINAL; ink:CARDINAL );
VAR
    b,t: REAL;
    i,j,k:CARDINAL;
    lastX,lastY,X,Y : REAL;
BEGIN
    N := first + N -1;

    lastX := x[first];
    lastY := y[first];
    t := 0.0;
    WHILE t <= 1.0 DO
        X := 0.0;
        Y := 0.0;
        FOR j := 0 TO N-1 DO
            b := 1.0;
            k := N -1;
            WHILE k > j DO
                b := b * REAL(k);
                DEC(k);
            END;
            k := N -1 -j;
            WHILE k > 1 DO
                b := b / REAL(k);
                DEC(k);
            END;
            i := 1;
            WHILE i <= j DO
                b := b * t;
                INC(i);
            END;
            i := 1;
            WHILE i <= N-1 -j DO
                b := b * (1.0 -t);
                INC(i);
            END;
            X := X +x[j +1] * b;
            Y := Y +y[j +1] * b;
        END;
        line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
        lastX := X;
        lastY := Y;
        t := t + 0.04; (* .2 = 50 curve points, .05=20 i.e. 1/0.5 , .04=25 *)
    END;
END BernsteinBezier;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE Spline_Calc(T, D,Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy : REAL; VAR X,Y : REAL);
VAR
    T2,T3:REAL;
BEGIN
    T2 := T  * T;
    T3 := T2 * T;
    X := ((Apx * T3) +(Bpx * T2) +(Cpx * T) +Dpx)/D;
    Y := ((Apy * T3) +(Bpy * T2) +(Cpy * T) +Dpy)/D;
END Spline_Calc;

PROCEDURE CatMull_Rom_ComputeCoeffs (N : CARDINAL;VAR Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy:REAL);
BEGIN
    Apx := -x[N -1] +3.0 * x[N] -3.0 * x[N +1] +x[N +2];
    Bpx := 2.0 * x[N -1] -5.0 * x[N] +4.0 * x[N +1] -x[N+2];
    Cpx := -x[N -1] +x[N +1];
    Dpx := 2.0 * x[N];
    Apy := -y[N -1] +3.0 * y[N] -3.0 * y[N+1] +y[N +2];
    Bpy := 2.0 * y[N -1] -5.0 * y[N] +4.0 * y[N +1] -y[N +2];
    Cpy := -y[N -1] +y[N +1];
    Dpy := 2.0 * y[N];
END CatMull_Rom_ComputeCoeffs;

PROCEDURE CatMullRomSpline (first,N,Resolution, ink:CARDINAL);
VAR
    i,j : CARDINAL;
    lastX,lastY,X,Y:REAL;
    Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy:REAL;
BEGIN
    N := first+N-1;
    x[first-1]:=x[first];
    y[first-1]:=y[first];
    x[N+1]:=x[N];
    y[N+1]:=y[N];
    x[N+2]:=x[N];
    y[N+2]:=y[N];
    lastX:=x[first];
    lastY:=y[first];
    FOR i := first TO N-1 DO
        CatMull_Rom_ComputeCoeffs(i,Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy);
        FOR j := 1 TO Resolution DO
            Spline_Calc(REAL(j) / REAL(Resolution), 2.0,Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy ,X,Y);
            line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
            lastX := X;
            lastY := Y;
        END;
    END;
END CatMullRomSpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE BSpline_ComputeCoeffs (N : CARDINAL;VAR Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy:REAL );
BEGIN
    Apx := -x[N -1] +3.0 * x[N] -3.0 * x[N +1] +x[N +2];
    Bpx := 3.0 * x[N -1] -6.0 * x[N] +3.0 * x[N +1];
    Cpx := -3.0 * x[N -1] +3.0 * x[N +1];
    Dpx := x[N -1] +4.0 * x[N] +x[N +1];
    Apy := -y[N -1] +3.0 * y[N] -3.0 * y[N +1] +y[N +2];
    Bpy := 3.0 * y[N -1] -6.0 * y[N] +3.0 * y[N +1];
    Cpy := -3.0 * y[N -1] +3.0 * y[N +1];
    Dpy := y[N -1] +4.0 * y[N] +y[N +1];
END BSpline_ComputeCoeffs;

PROCEDURE BSpline (first,N,Resolution,ink:CARDINAL);
VAR
    i,j:CARDINAL;
    lastX,lastY,X,Y:REAL;
    Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy:REAL;
BEGIN
    N:=first+N-1;
    x[first-1]:=x[first];
    y[first-1]:=y[first];
    x[N+1]:=x[N];
    y[N+1]:=y[N];
    x[N+2]:=x[N];
    y[N+2]:=y[N];
    lastX:=x[first];
    lastY:=y[first];
    FOR i := first TO N DO
        BSpline_ComputeCoeffs(i,Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy);
        FOR j := 0 TO Resolution DO
            Spline_Calc( REAL(j) / REAL(Resolution), 6.0,Apx,Bpx,Cpx,Dpx,Apy,Bpy,Cpy,Dpy,X,Y );
            line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
            lastX := X;
            lastY := Y;
        END;
    END;
END BSpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE Parab_Calc (T, D, Apx,Bpx,Cpx,Apy,Bpy,Cpy : REAL; VAR X,Y : REAL);
VAR
    T2 : REAL;
BEGIN
    T2 := T * T;
    X  := ((Apx * T2) +(Bpx * T) +Cpx) / D;
    Y  := ((Apy * T2) +(Bpy * T) +Cpy) / D;
END Parab_Calc;

PROCEDURE Parab_ComputeCoeffs(N:CARDINAL;VAR Apx,Bpx,Cpx,Apy,Bpy,Cpy:REAL);
BEGIN
    Apx := x[N -1] -2.0 * x[N] +x[N +1];
    Bpx := -2.0 * x[N -1] +2.0 * x[N];
    Cpx := x[N -1] +x[N];
    Apy := y[N -1] -2.0 * y[N] +y[N +1];
    Bpy := -2.0 * y[N -1] +2.0 * y[N];
    Cpy := y[N -1] +y[N];
END Parab_ComputeCoeffs;

PROCEDURE ParabolicSpline (first,N,Resolution,ink:CARDINAL);
VAR
    i,j:CARDINAL;
    lastX,lastY,X,Y:REAL;
    Apx,Bpx,Cpx,Apy,Bpy,Cpy:REAL;
    starting : CARDINAL;
BEGIN
    N:=first+N-1;

    x[first-1]:=x[N];
    y[first-1]:=y[N];
    x[N+1]:=x[first];
    y[N+1]:=y[first];
    x[N+2]:=x[first+1];
    y[N+2]:=y[first+1];


    lastX:=x[first];
    lastY:=y[first];

    i := first;
    Parab_ComputeCoeffs(i,Apx,Bpx,Cpx,Apy,Bpy,Cpy);
    FOR j := 0 TO Resolution DO
        Parab_Calc( REAL(j) / REAL(Resolution), 2.0,Apx,Bpx,Cpx,Apy,Bpy,Cpy,X,Y );
        IF j >= (Resolution DIV 2) THEN
            line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
        END;
        lastX := X;
        lastY := Y;
    END;

    FOR i := first+1 TO N DO
        Parab_ComputeCoeffs(i,Apx,Bpx,Cpx,Apy,Bpy,Cpy);
        FOR j := 0 TO Resolution DO
            Parab_Calc( REAL(j) / REAL(Resolution), 2.0,Apx,Bpx,Cpx,Apy,Bpy,Cpy,X,Y );
            line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
            lastX := X;
            lastY := Y;
        END;
    END;

    i := N+1;
    Parab_ComputeCoeffs(i,Apx,Bpx,Cpx,Apy,Bpy,Cpy);
    FOR j := 0 TO Resolution DO
        Parab_Calc( REAL(j) / REAL(Resolution), 2.0,Apx,Bpx,Cpx,Apy,Bpy,Cpy,X,Y );
        IF j < (Resolution DIV 2) THEN
            line (INTEGER(lastX),INTEGER(lastY),INTEGER(X), INTEGER(Y),ink);
        END;
        lastX := X;
        lastY := Y;
    END;


END ParabolicSpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)
CONST
    cr  = CHR(13);
    lf  = CHR(10);
    nl  = cr+lf;
    help= "Q&D PSPLINE v1.0a by PhG"+nl+
          nl+
          "Syntax : PSPLINE B|C|P|S|* /S:# /P:# /L:# /U:# /L"+nl+
          nl+
          "    B=BernsteinBezier, C=CatMullRom, P=ParabolicSpline, S=BSpline, *=all"+nl+
          "    /S=segments, /P=points, /L=lowervelocity, /U=uppervelocity, /L=linesonly"+nl;
VAR
    parmcount : CARDINAL;
    i         : CARDINAL;
    opt       : CARDINAL;
    S         : str128;
    R         : str128;
    v         : LONGCARD;
    ok        : BOOLEAN;
    showdots  : BOOLEAN;
    ch        : CHAR;
BEGIN
    WrLn;

    defaults;
    ch := "?";
    showdots := TRUE;

    parmcount := Lib.ParamCount();

    IF parmcount = 0 THEN WrStr(help);HALT;END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"S:"+delim+
                                 "P:"+delim+
                                 "L:"+delim+
                                 "U:"+delim+
                                 "L"+delim+
                                 "?"+delim+"H"+delim+"HELP"
                              );
            CASE opt OF
            | 1 : ok:=GetLongCard(S,v); Res := CARDINAL(v);
            | 2 : ok:=GetLongCard(S,v); NumPts := CARDINAL(v);
            | 3 : ok:=GetLongCard(S,v); MinDelta := CARDINAL(v);
            | 4 : ok:=GetLongCard(S,v); MaxDelta := CARDINAL(v);
            | 5 : showdots := FALSE;
            | 6,7,8: WrStr(help); HALT;
            END;
        ELSE
            ch:=R[0];

        END;
    END;
    IF ch="?" THEN HALT; END;
    IF HiresON() = FALSE THEN HALT; END;
    Graph.ClearScreen(Graph._GCLEARSCREEN);

    init_knots (start,NumPts);

    LOOP
        Graph.ClearScreen(Graph._GCLEARSCREEN);
        IF showdots THEN show_knots (start,NumPts,yellow); END;
        CASE ch OF
        | "B" : BernsteinBezier(start,NumPts,white); (* ok *)
        | "C" : CatMullRomSpline(start,NumPts, Res, mauve); (* ok *)
        | "P" : ParabolicSpline(start,NumPts,Res,red); (* ok *)
        | "S" : BSpline(start,NumPts,Res,blue);
        | "*" : BernsteinBezier(start,NumPts,white); (* ok *)
                CatMullRomSpline(start,NumPts, Res, mauve); (* ok *)
                ParabolicSpline(start,NumPts,Res,red); (* ok *)
                BSpline(start,NumPts,Res,blue);
        ELSE
                EXIT;
        END;

        WaitVGAretrace(4);
(*
        IF showdots THEN show_knots (start,NumPts,black); END;
        CASE ch OF
        | "B" : BernsteinBezier(start,NumPts,black); (* ok *)
        | "C" : CatMullRomSpline(start,NumPts, Res, black); (* ok *)
        | "P" : ParabolicSpline(start,NumPts,Res,black); (* ok *)
        | "S" : BSpline(start,NumPts,Res,black);
        | "*" : BernsteinBezier(start,NumPts,black); (* ok *)
                CatMullRomSpline(start,NumPts, Res, black); (* ok *)
                ParabolicSpline(start,NumPts,Res,black); (* ok *)
                BSpline(start,NumPts,Res,black);
        ELSE
                EXIT;
        END;
*)
        move_knots (start,NumPts);

        IF IO.KeyPressed() THEN EXIT; END;
    END;

    IF HiresOFF()= FALSE THEN HALT; END;
    HALT;
END splines.
