(* ---------------------------------------------------------------
Title         Q&D popdir
Author        PhG
Overview      pop current directory
Usage         see help
Notes         assume TMP environment variable refers to an existing directory !
Bugs
Wish List     LFN support ? ah ah, only serious !

--------------------------------------------------------------- *)

MODULE PopDir;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows, cleantabs,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

(* ------------------------------------------------------------ *)

CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
CONST
    ProgEXEname   = "POPDIR";
    ProgTitle     = "Q&D Pop Directory";
    ProgVersion   = "v1.0d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    popname       = "~POPDIR.TMP";
    varPUSHPOP    = "PUSHPOP";
    varTMP        = "TMP";
    varTEMP       = "TEMP";
    varTMPDIR     = "TMPDIR";
    varTEMPDIR    = "TEMPDIR";
    vars          = varPUSHPOP+delim+
                    varTMP+delim+
                    varTEMP+delim+
                    varTMPDIR+delim+
                    varTEMPDIR;
    varlist       = varPUSHPOP+", "+
                    varTMP+", "+
                    varTEMP+", "+
                    varTMPDIR+" or "+
                    varTEMPDIR;
CONST
    firstDir    = 1;
    maxDir      = 100;
    strMaxDirs  = "100";

(* ------------------------------------------------------------ *)

CONST
    errNone             = 0;
    errHelp             = 1;
    errUnknownOption    = 2;
    errUselessParm      = 3;
    errVarTMP           = 4;
    errMissing          = 5;
    errStackOverflow    = 6;
    errEmptyStack       = 7;
    errNonsense         = 8;
    errNonsenseDiscard  = 9;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
nl+
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [-list|-zero|-keep]"+nl+
nl+
"This program goes back to latest saved drive and directory."+nl+
nl+
popname+" companion data file will be located in directory"+nl+
"specified by any of the following environment variables :"+nl+
varlist+" (in that order)."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOption :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errUselessParm :
        Str.Concat(S,"Uneeded ",einfo); Str.Append(S," parameter !");
    | errVarTMP:
        S := "Missing "+varlist+" environment variable !";
    | errMissing :
        Str.Concat(S,einfo," does not exist !");
    | errStackOverflow:
        S := "Too many directories pushed on stack while limit is "+strMaxDirs+" !";
    | errEmptyStack:
        S := "No directory pushed on stack !";
    | errNonsense :
        S := "-l and -z options are mutually exclusive !";
    | errNonsenseDiscard:
        S := "-k option is a nonsense with -l or -z options !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrLn; (* here *)
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE chkVarTMP (dbg:BOOLEAN; VAR R:ARRAY OF CHAR) : BOOLEAN;
VAR
    i:CARDINAL;
    varname,u,d,n,e:str128;
    rc:BOOLEAN;
BEGIN
    rc:= FALSE;
    i := 0;
    LOOP
        isoleItemS(varname,vars,delim,i);
        IF same(varname,"") THEN EXIT; END;
        Lib.EnvironmentFind(varname,R);
        IF dbg THEN WrStr(varname);WrStr(" = ");WrStr(R);WrLn;END;
        IF same(R,".") THEN
            Lib.ParamStr(R,0);
            Lib.SplitAllPath(R,u,d,n,e);
            Lib.MakeAllPath(R,u,d,"","");
            IF dbg THEN WrStr(varname);WrStr(" = ");WrStr(R);WrLn;END;
            rc:=TRUE;
            EXIT;
        END;
        IF same(R,"")=FALSE THEN
            rc:=TRUE;
            EXIT;
        END;
        INC(i);
    END;
    RETURN rc;
END chkVarTMP;

(* ------------------------------------------------------------ *)

CONST
    IObufferSize= (8 * 512) + FIO.BufferOverhead;
VAR
    IObuffer : ARRAY [1..IObufferSize] OF BYTE;
VAR
    i, parmcount, opt : CARDINAL;
    S,R               : str128;
    tmpdir,stackfile  : str128;
    u                 : SHORTCARD; (* current unit to save *)
    drive             : CHAR; (* current drive to save *)
    here              : str128;
    hnd               : FIO.File;
    ndx,fakendx       : CARDINAL;
    DEBUG,showlist,zerolist,discard : BOOLEAN;
VAR
    rep : ARRAY [firstDir..maxDir] OF str128;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    (* WrLn; *)

    showlist:=FALSE;
    zerolist:=FALSE;
    discard :=TRUE;
    DEBUG := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "Z"+delim+"ZERO"+delim+
                                  "K"+delim+"KEEP"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :     abort(errHelp,"");
            | 4,5:        showlist := TRUE;
            | 6,7:        zerolist := TRUE;
            | 8,9:        discard  := FALSE;
            | 10:         DEBUG    := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            abort(errUselessParm,S);
        END;
    END;
    IF zerolist THEN
        IF showlist THEN abort(errNonsense,"");END;
        IF NOT(discard) THEN abort(errNonsenseDiscard,"");END;
    END;
    IF showlist THEN
        IF NOT(discard) THEN abort(errNonsenseDiscard,"");END;
    END;

    IF (showlist OR DEBUG) THEN WrLn;END;
    IF chkVarTMP(DEBUG,tmpdir)=FALSE THEN abort(errVarTMP,"");END;
    fixDirectory(tmpdir);
    Str.Concat(stackfile,tmpdir,popname);
    Str.Caps(stackfile);
    IF DEBUG THEN WrStr(stackfile);WrLn;END;

    IF FIO.Exists(stackfile)=FALSE THEN abort(errMissing,stackfile);END;

    IF zerolist THEN
        FIO.Erase(stackfile);
        S:=nl+"::: ~ has been deleted."+nl;
        Str.Subst(S,"~",stackfile);
        WrStr(S);
        abort(errNone,"");
    END;

    hnd := FIO.OpenRead(stackfile);
    FIO.AssignBuffer(hnd,IObuffer);

    ndx := firstDir;
    FIO.EOF := FALSE;   (* just in case *)
    LOOP
        IF FIO.EOF THEN EXIT;END;
        IF ndx > maxDir THEN EXIT; END;
        FIO.RdStr(hnd,rep[ndx]);
        IF rep[ndx][0] # CHR(0) THEN
            IF (showlist OR DEBUG) THEN IO.WrCard(ndx,3);WrStr(" : ");WrStr(rep[ndx]);WrLn;END;
            INC(ndx);
        END;
    END;
    FIO.Close(hnd);
    IF ndx > maxDir THEN abort(errStackOverflow,"");END;
    DEC(ndx);
    IF ndx < firstDir THEN abort(errEmptyStack,"");END;

    IF showlist THEN
        S:=nl+"::: No action was taken because -list option was specified."+nl;
        WrStr(S);
        abort(errNone,"");
    END;

    FIO.Erase(stackfile);

    (* 1 or more *)

    IF discard THEN
        fakendx:=ndx;
    ELSE
        fakendx:=ndx+1; (* ugly trick *)
    END;

    IF fakendx > firstDir THEN              (* avoid creating an empty stackfile *)
        hnd := FIO.Create(stackfile);
        FIO.AssignBuffer(hnd,IObuffer);
        FOR i := firstDir TO (fakendx-1) DO (* remember to decrease ndx ! *)
            FIO.WrStr(hnd,rep[i]);
            FIO.WrLn(hnd);
        END;
        FIO.Flush(hnd);
        FIO.Close(hnd);
    END;

    here := rep[ndx];
    Str.Caps(here); (* useless but we err on the safe side... *)
    u := SHORTCARD ( ORD(here[0])-ORD("A")+1 );
    u := FIO.SetDrive(u);
    Str.Delete(here,0,2); (* remove u: in u:\path *)
    (* do not check if directory still exists! *)
    FIO.ChDir(here);

    IF NOT(discard) THEN
        S:=nl+"::: Target directory was not removed from stack."+nl;
        WrStr(S);
    END;

    abort(errNone,"");
END PopDir.
