(* -----------------------------------------------------------------
Title         Q&D Joystick
Author        PhG
Overview
Usage
Notes         very, very, very quick & dirty... as usual ! :-(
              weird : altpadaxis allows reading of buttons F and G
Bugs
Wish List     recheck 6 buttons gamepad display

----------------------------------------------------------------- *)

MODULE Joystick;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "JOYSTICK";
    ProgTitle     = "Q&D Joystick Check";
    ProgVersion   = "v1.0d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errBadParm1     = 2;
    errBadParm2     = 3;
    errNoSuchDevice = 4;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL);
CONST
    nl=CHR(13)+CHR(10);
    helpmsg=
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" < <A|B|G|P> | <1|2|0|6> > [*]"+nl+
nl+
"A or B = normal procedures, 1 or 2 = safer procedures,"+nl+
"G or 0 = 4 buttons gamepad, P or 6 = 6 buttons gamepad"+nl+
"(with P, position polling may be erratic : use safer 6 instead)."+nl+
"With P and 6, E and F buttons are said pressed if B joystick position < 128."+nl+
'Optional "*" second parameter disables device detection test.'+nl;

VAR
    S  : str256;
    ok : BOOLEAN;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errBadParm1:
        S := "Illegal first parameter !";
    | errBadParm2:
        S := "Illegal second parameter !";
    | errNoSuchDevice:
        S := "Specified device does not seem to exist !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp: ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE padDec (v : CARDINAL; digits : CARDINAL; ch:CHAR) : str16;
VAR
    R : str16;
    ok : BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr (LONGCARD(v),R,10,ok);
    FOR i:=Str.Length(R)+1 TO digits DO
        Str.Prepend(R,ch);
    END;
    RETURN R;
END padDec;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

(* ------------------------------------------------------------ *)

(*
                        Ŀ
                         7  6  5  4  3  2  1  0 
                        
                                               
Joy B, Button 2, Pad D                       Joy A, X Axis, Pad A
Joy B, Button 1, Pad C                 Joy A, Y Axis, Pad B
Joy A, Button 2, Pad B           Joy B, X Axis, Pad C
Joy A, Button 1, Pad A     Joy B, Y Axis, Pad D
*)

CONST
    joyPort    = 00201H;
    joytimeout = 0FFFFH;
CONST
    (* remember TS M2 does NOT like binary constants ! *)
    Abutton1 = 10H; (* 00010000 *)
    Abutton2 = 20H; (* 00100000 *)
    Bbutton1 = 40H; (* 01000000 *)
    Bbutton2 = 80H; (* 10000000 *)
    AXaxis   = 01H; (* 00000001 *)
    AYaxis   = 02H; (* 00000010 *)
    BXaxis   = 04H; (* 00000100 *)
    BYaxis   = 08H; (* 00001000 *)
CONST
    padXaxis = AXaxis;
    padYaxis = AYaxis;
    padButtonA=Abutton1;
    padButtonB=Abutton2;
    padButtonC=Bbutton1;
    padButtonD=Bbutton2;
    altpadXaxis = BXaxis; (* seems to be button F *)
    altpadYaxis = BYaxis; (* seems to be button G *)

PROCEDURE joypressed (buttonmask1,buttonmask2:SHORTCARD;VAR pressed1,pressed2:BOOLEAN);
VAR
    read : SHORTCARD;
    i  : CARDINAL;
BEGIN
    read := SYSTEM.In(joyPort);
    pressed1:= ( (read AND buttonmask1) = 0 );
    pressed2:= ( (read AND buttonmask2) = 0 );
END joypressed;

PROCEDURE polljoypressed (safe:BOOLEAN;buttonmask1,buttonmask2:SHORTCARD;VAR pressed1,pressed2:BOOLEAN);
CONST
    mini = 1;
    safemaxi = 5; (* assume 5 readings with the same result is enough ! *)
VAR
    ref1,ref2 : BOOLEAN;
    i,n,maxi  : CARDINAL;
BEGIN
    joypressed(buttonmask1,buttonmask2,ref1,ref2);
    IF safe THEN
        maxi:=safemaxi;
    ELSE
        (* maxi:=mini; *)
        pressed1:=ref1;
        pressed2:=ref2;
        RETURN;
    END;
    i:=mini;
    LOOP
        joypressed(buttonmask1,buttonmask2,pressed1,pressed2);
        n:=0;
        IF pressed1=ref1 THEN INC(n);END;
        IF pressed2=ref2 THEN INC(n);END;
        IF n=2 THEN
            INC(i);
            IF i > maxi THEN EXIT; END;
        ELSE
            ref1 := pressed1;
            ref2 := pressed2;
            i    := mini;
        END;
    END;
END polljoypressed;

PROCEDURE joypos (Xaxismask,Yaxismask:SHORTCARD;VAR xp,yp:CARDINAL);
VAR
    read : SHORTCARD;
    xnotyet,ynotyet:BOOLEAN;
BEGIN
    SYSTEM.DI; (* cli *)
    SYSTEM.Out(joyPort,0FFH); (* reset each axis bit to 1 *)
    xnotyet := TRUE;
    ynotyet := TRUE;
    xp := 0;
    yp := 0;
    LOOP
        read := SYSTEM.In(joyPort);
        IF (xnotyet AND ( (read AND Xaxismask) # 0 ) ) THEN
            IF xp = joytimeout THEN
                xnotyet := FALSE;
            ELSE
               INC(xp);
            END;
        ELSE
            xnotyet := FALSE;
        END;
        IF (ynotyet AND ( (read AND Yaxismask) # 0 ) ) THEN
            IF yp = joytimeout THEN
                ynotyet := FALSE;
            ELSE
                INC(yp);
            END;
        ELSE
            ynotyet := FALSE;
        END;
        IF ( (xnotyet=FALSE) AND (ynotyet=FALSE) ) THEN EXIT; END;
    END;
    SYSTEM.EI; (* sti *)
END joypos;

PROCEDURE joyhere (Xaxismask,Yaxismask:SHORTCARD):BOOLEAN;
VAR
    xp,yp:CARDINAL;
BEGIN
    joypos(Xaxismask,Yaxismask,xp,yp);
    RETURN ( (xp # joytimeout) AND (yp # joytimeout) );
END joyhere;

PROCEDURE polljoypos (safe:BOOLEAN;Xaxismask,Yaxismask:SHORTCARD;VAR xp,yp:CARDINAL);
CONST
    mini = 1;
    safemaxi = 5; (* average these readings for safety *)
VAR
    xx : ARRAY [mini..safemaxi] OF CARDINAL;
    yy : ARRAY [mini..safemaxi] OF CARDINAL;
    i,maxi  : CARDINAL;
    xl,yl  : LONGCARD;
BEGIN
    IF safe THEN
        maxi:=safemaxi;
    ELSE
        maxi:=mini;
    END;
    FOR i := mini TO maxi DO
        joypos(Xaxismask,Yaxismask,xx[i],yy[i]);
    END;
    xl:=0;
    yl:=0;
    FOR i := mini TO maxi DO
        INC(xl,LONGCARD(xx[i]));
        INC(yl,LONGCARD(yy[i]));
    END;
    xp:=CARDINAL(xl DIV LONGCARD(maxi));
    yp:=CARDINAL(yl DIV LONGCARD(maxi));
END polljoypos;

(* ------------------------------------------------------------ *)

PROCEDURE padpressed (VAR pressed1,pressed2,pressed3,pressed4:BOOLEAN);
VAR
    read : SHORTCARD;
    i  : CARDINAL;
BEGIN
    read := SYSTEM.In(joyPort);
    pressed1:= ( (read AND padButtonA) = 0 );
    pressed2:= ( (read AND padButtonB) = 0 );
    pressed3:= ( (read AND padButtonC) = 0 );
    pressed4:= ( (read AND padButtonD) = 0 );
END padpressed;

PROCEDURE pollpadpressed (safe:BOOLEAN;VAR pressed1,pressed2,pressed3,pressed4:BOOLEAN);
CONST
    mini = 1;
    maxisafe = 5; (* assume 5 readings with the same result is enough ! *)
VAR
    ref1,ref2,ref3,ref4 : BOOLEAN;
    i,n,maxi : CARDINAL;
BEGIN
    padpressed(ref1,ref2,ref3,ref4);
    IF safe THEN
        maxi:=maxisafe;
    ELSE
        (* maxi:=mini; *)
        pressed1:=ref1;
        pressed2:=ref2;
        pressed3:=ref3;
        pressed4:=ref4;
        RETURN;
    END;
    i:=mini;
    LOOP
        padpressed(pressed1,pressed2,pressed3,pressed4);
        n:=0;
        IF pressed1=ref1 THEN INC(n);END;
        IF pressed2=ref2 THEN INC(n);END;
        IF pressed3=ref3 THEN INC(n);END;
        IF pressed4=ref4 THEN INC(n);END;
        IF n=4 THEN
            INC(i);
            IF i > maxi THEN EXIT; END;
        ELSE
            ref1 := pressed1;
            ref2 := pressed2;
            ref3 := pressed3;
            ref4 := pressed4;
            i    := mini;
        END;
    END;
END pollpadpressed;

(* ------------------------------------------------------------ *)

PROCEDURE trail (b:BOOLEAN;S1,S2:ARRAY OF CHAR;VAR R:ARRAY OF CHAR   );
BEGIN
    IF b THEN
        Str.Append(R,S1);
    ELSE
        Str.Append(R,S2);
    END;
END trail;

(* ------------------------------------------------------------ *)

CONST
    probapos = 128;
    sepa     = "  ";
    padwi    = 3;
VAR
    S : str256;
    SR: str80;
    safe,stick,bothaxes,lookfordevice:BOOLEAN;
    button1 : SHORTCARD;
    button2 : SHORTCARD;
    Xaxis   : SHORTCARD;
    Yaxis   : SHORTCARD;
    xpos,ypos,xx,yy:CARDINAL;
    pressed1,pressed2:BOOLEAN;
    pressed3,pressed4:BOOLEAN;
    pressed5,pressed6:BOOLEAN;
    xmin,xmax,ymin,ymax:CARDINAL;
    center : INTEGER;
    i,parmcount : CARDINAL;
BEGIN
    WrLn;
    lookfordevice := TRUE;
    stick         := TRUE; (* default is joystick *)
    bothaxes      := FALSE; (* useless safety *)

    parmcount := Lib.ParamCount();
    FOR i:= 1 TO parmcount DO
         Lib.ParamStr(S,i);
         IF same(S,"-?") THEN abort(errHelp);END;
         IF same(S,"/?") THEN abort(errHelp);END;
         IF same(S,"?")  THEN abort(errHelp);END;
    END;

    CASE parmcount OF
    | 0 :
         abort(errHelp);
    | 1 :
         ;
    | 2 :
         Lib.ParamStr(S,2);
         IF same(S,"*") = FALSE THEN abort(errBadParm2);END;
         lookfordevice := FALSE;
    ELSE
         abort(errHelp);
    END;

    Lib.ParamStr(S,1);
    IF Str.Length(S) > 1 THEN abort(errBadParm1);END;

    CASE CAP(S[0]) OF
    | "A" :
        button1 := Abutton1; button2 := Abutton2;
        Xaxis   := AXaxis;   Yaxis   := AYaxis;
        safe    := FALSE;
    | "B" :
        button1 := Bbutton1; button2 := Bbutton2;
        Xaxis   := BXaxis;   Yaxis   := BYaxis;
        safe    := FALSE;
    | "1" :
        button1 := Abutton1; button2 := Abutton2;
        Xaxis   := AXaxis;   Yaxis   := AYaxis;
        safe    := TRUE;
    | "2" :
        button1 := Bbutton1; button2 := Bbutton2;
        Xaxis   := BXaxis;   Yaxis   := BYaxis;
        safe    := TRUE;
    | "G" :
        bothaxes:= FALSE;
        Xaxis   := padXaxis;   Yaxis   := padYaxis;
        stick   := FALSE;
        safe    := FALSE;
    | "0" :
        bothaxes:= FALSE;
        Xaxis   := padXaxis;   Yaxis   := padYaxis;
        stick   := FALSE;
        safe    := TRUE;
    | "P" :
        bothaxes:= TRUE;
        Xaxis   := padXaxis;   Yaxis   := padYaxis;
        stick   := FALSE;
        safe    := FALSE;
    | "6" :
        bothaxes:= TRUE;
        Xaxis   := padXaxis;   Yaxis   := padYaxis;
        stick   := FALSE;
        safe    := TRUE;
    ELSE
        abort(errHelp);
        (* abort(errBadParm); *)
    END;
    IF lookfordevice THEN
        IF stick THEN
            IF joyhere(Xaxis,Yaxis)=FALSE THEN abort(errNoSuchDevice);END;
        ELSE
            IF joyhere(Xaxis,Yaxis)=FALSE THEN abort(errNoSuchDevice);END;
        END;
    END;
    WrStr("Hit any key to stop ");
    CASE safe OF
    | FALSE : WrStr("normal");
    | TRUE  : WrStr("safer");
    END;
    IF stick THEN
        S:="joystick";
    ELSE
        IF bothaxes THEN
            S:="6 buttons gamepad";
        ELSE
            S:="4 buttons gamepad";
        END;
    END;
    WrStr(" ");WrStr(S);WrStr(" polling and return to DOS !");WrLn;
    WrLn;
    xmin:=MAX(CARDINAL);
    xmax:=0;
    ymin:=MAX(CARDINAL);
    ymax:=0;

    Flushkey();
    LOOP
        S := "";
        IF stick THEN
            polljoypressed(safe,button1,button2,pressed1,pressed2);
            trail(pressed1,"*B1*","-b1-",S); Str.Append(S,sepa);
            trail(pressed2,"*B2*","-b2-",S);
        ELSE
            pollpadpressed(safe,pressed1,pressed2,pressed3,pressed4);
            trail(pressed1,"*A*","-a-",S); Str.Append(S,sepa);
            trail(pressed2,"*B*","-b-",S); Str.Append(S,sepa);
            trail(pressed3,"*C*","-c-",S); Str.Append(S,sepa);
            trail(pressed4,"*D*","-d-",S);
            IF bothaxes THEN
                polljoypos(safe,altpadXaxis,altpadYaxis,xx,yy);
                pressed5:=xx < probapos;
                pressed6:=yy < probapos;
                Str.Append(S,sepa);
                trail(pressed5,"*E*","-e-",S); Str.Append(S,sepa);
                trail(pressed6,"*F*","-f-",S);
            END;
        END;
        polljoypos(safe,Xaxis,Yaxis,xpos,ypos);
        IF xpos < xmin THEN xmin:=xpos; END;
        IF xpos > xmax THEN xmax:=xpos; END;
        IF ypos < ymin THEN ymin:=ypos; END;
        IF ypos > ymax THEN ymax:=ypos; END;

        SR:="X[$..!..$]  Y[$..!..$]";

        Str.Subst(SR,"$",padDec(xmin,padwi,"0"));
        Str.Subst(SR,"$",padDec(xmax,padwi,"0"));
        Str.Subst(SR,"$",padDec(ymin,padwi,"0"));
        Str.Subst(SR,"$",padDec(ymax,padwi,"0"));

        center := INTEGER(xmax)-INTEGER(xmin);
        center := ABS(center) DIV 2 + INTEGER(xmin);
        Str.Subst(SR,"!",padDec(CARDINAL(center),padwi,"0"));

        center := INTEGER(ymax)-INTEGER(ymin);
        center := ABS(center) DIV 2 + INTEGER(ymin);
        Str.Subst(SR,"!",padDec(CARDINAL(center),padwi,"0"));

        Str.Append(S,"  ");
        Str.Append(S,SR);
        Str.Append(S,"  X=$  Y=$ ");

        Str.Subst(S,"$",padDec(xpos,padwi," "));
        Str.Subst(S,"$",padDec(ypos,padwi," "));

        video(S,TRUE);
        WaitVGAretrace();
        video(S,FALSE);
        IF IO.KeyPressed() THEN EXIT; END;
    END;
    Flushkey();

    WrStr(SR);WrLn;

    abort(errNone);
END Joystick.


