(* ---------------------------------------------------------------
Title         Q&D Factorize
Author        PhG
Overview      see help
Notes         chkPrime is about 4 times slower than factorize()
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE Factoriz;

IMPORT Str;
IMPORT Lib;
IMPORT IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    winum         = 13;  (* "#.###.###.###" *)
    blank         = " ";
    dot           = ".";
    coma          = ",";
    filteredChars = dot+coma;
CONST
    msgWait = "Computing, please wait... ";
    kEsc    = 1024;       (* keep 9X happy *)

(* ------------------------------------------------------------ *)

PROCEDURE filter (VAR R:ARRAY OF CHAR; filtered:ARRAY OF CHAR );
VAR
    i,len:CARDINAL;
    S:str128;
    ch:CHAR;
BEGIN
    S:="";
    FOR i:=1 TO Str.Length(R) DO
        ch:=R[i-1];
        IF Str.CharPos(filtered,ch)=MAX(CARDINAL) THEN Str.Append(S,ch);END;
    END;
    Str.Copy(R,S);
END filter;

PROCEDURE getvallc (S:ARRAY OF CHAR;VAR v : LONGCARD ):BOOLEAN;
VAR
    lc   : LONGCARD;
    base : CARDINAL;
    ok   : BOOLEAN;
BEGIN
    IF S[0]="$" THEN
        Str.Delete(S,0,1);
        base := 16;
    ELSE
        base := 10;
    END;
    lc:=Str.StrToCard(S,base,ok);
    IF NOT(ok) THEN RETURN FALSE; END;
    IF lc > MAX(LONGCARD) THEN RETURN FALSE; END;
    v := lc;
    RETURN TRUE;
END getvallc;

PROCEDURE getval (S:ARRAY OF CHAR;VAR v : CARDINAL ):BOOLEAN;
VAR
    lc:LONGCARD;
BEGIN
    lc := LONGCARD(v);
    IF getvallc(S, lc) THEN
        IF lc > MAX(CARDINAL) THEN
            RETURN FALSE;
        ELSE
            v := CARDINAL(lc);
            RETURN TRUE;
        END;
    ELSE
        RETURN FALSE;
    END;
END getval;

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

PROCEDURE beautifiedlc (v : LONGCARD;pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END beautifiedlc;

PROCEDURE beautified (v : CARDINAL;pad:CHAR; sep:CHAR; field:INTEGER) : str80;
BEGIN
    RETURN beautifiedlc ( LONGCARD(v),pad,sep,field);
END beautified;

PROCEDURE fmtme (v:LONGCARD;wi:CARDINAL; BEAUTIFY:BOOLEAN):str80;
VAR
    S:str80;
BEGIN
    IF BEAUTIFY THEN
        S:=beautifiedlc (v,blank,dot,wi);
    ELSE
        S:=fmtlc (v,10,wi,blank,"");
    END;
    RETURN S;
END fmtme;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    progTitle     = "Q&D Factorize";
    progVersion   = "v1.0a";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    progEXEname   = "FACTORIZ";
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;

(* ------------------------------------------------------------ *)

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errLongCard     = 4;
    errTHSfailure   = 5;
    errAborted      = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    PROCEDURE msg2 (VAR R : ARRAY OF CHAR;S1,S2:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);
    END msg2;

    PROCEDURE msg3 (VAR R : ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
         msg2(R,S1,S2);Str.Append(R,S3);
    END msg3;

CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax : "+progEXEname+" <number>... [option]..."+nl+
nl+
"   -p   (very slowly) check <number> found to be prime with alternate method"+nl+
"   -l   show one factor per line"+nl+
"   -r   do not beautify factors"+nl+
"   -ths try and build TxHxS from <number>"+nl+
"   -e   do not poll keyboard for Escape"+nl+
nl+
"This program (slowly) factorizes specified <number>."+nl+
"<number> must belong to [0..~] range."+nl+
"["+filteredChars+"] characters are filtered out from <number>."+nl+
nl+
"Examples : "+progEXEname+" 16,481,808 20,016,864"+nl+
"           "+progEXEname+" -ths 160,086,528"+nl+
"           "+progEXEname+" -p 01.02.1963"+nl;

VAR
    S : str128;
    H : str2048;
BEGIN
    CASE e OF
    | errHelp :       H := msgHelp;
                      Str.Subst(H,"~",fmtlc( MAX(LONGCARD),10,1,"","" ));
                      WrStr(H);
    | errOption :     msg3(S,'Unknown "',einfo,'" option !');
    | errParameter :  msg3(S,'Unexpected "',einfo,'" parameter !');
    | errLongCard :   msg3(S,'Illegal "',einfo,'" number !');
    | errTHSfailure : msg2(S,einfo," would not translate to valid TxHxS !");
    | errAborted :    S := "Aborted by user !"
    ELSE
                      S := "How did you get THERE ???";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE trydiv (VAR q : LONGCARD ;v,d:LONGCARD; DEBUG:BOOLEAN):BOOLEAN ;
BEGIN
    q := v DIV d;
IF DEBUG THEN
WrStr("value = ");      WrStr(fmtlc(v,10,winum,blank,""));
WrStr("  divisor = ");  WrStr(fmtlc(d,10,winum,blank,""));
WrStr("  quotient = "); WrStr(fmtlc(q,10,winum,blank,""));WrLn;
END;
    RETURN ( v = (q * d) );
END trydiv;

CONST
    minfactentry = 0;
    maxfactentry = 0;
    minfactor    = 1;    (* so we can flag using minfactor-1=0 *)
    maxfactor    = 32+1; (* should do for at most 2^32 ! *)
    ABORTED      = MAX(CARDINAL);
TYPE
    factortype = RECORD
       k    : LONGCARD;
       flag : BOOLEAN;
    END;
VAR
    factor : ARRAY[minfactentry..maxfactentry] , [minfactor..maxfactor] OF factortype;

PROCEDURE factorize (where:CARDINAL; v:LONGCARD;POLLESC, DEBUG:BOOLEAN):CARDINAL;
VAR
    i,ndx:CARDINAL;
    quotient, divisor,added : LONGCARD;
BEGIN
    ndx:=minfactor-1;
    (* handle trivial cases *)
    IF v = 0 THEN RETURN ndx; END;
    IF v = 1 THEN
        INC(ndx);
        factor[where][ndx].k:=v;
        factor[where][ndx].flag:=TRUE;
        RETURN ndx;
    END;

    FOR i:=1 TO 2 DO
        CASE i OF
        | 1: divisor := 2;
        | 2: divisor := 3;
        END;
        LOOP
            IF trydiv (quotient, v,divisor,DEBUG) THEN
                INC(ndx);
                IF ndx > maxfactor THEN RETURN minfactor-1; END; (* should never happen *)
                factor[where][ndx].k:=divisor;
                factor[where][ndx].flag:=TRUE;
                v:=quotient;
                IF quotient < divisor THEN RETURN ndx; END;
            ELSE
                EXIT;
            END;
            IF POLLESC THEN
                IF (divisor MOD kEsc) = 0 THEN
                    IF ChkEscape() THEN video(msgWait,FALSE); RETURN ABORTED; END;
                END;
            END;
        END;
    END;

    (*
    after 2 and 3, gen next prime (5, 7, 11, 13, 17, 19, 23, 25, 29, 31...)
    by adding alternatively 2 then 4 to previous value
    *)

    video(msgWait,TRUE);
    added := 2;
    INC(divisor,added); (* 3+2=5 *)
    LOOP
        IF trydiv (quotient,v,divisor,DEBUG) THEN
            INC(ndx);
            IF ndx  > maxfactor THEN RETURN minfactor-1; END;
            factor[where][ndx].k   :=divisor;
            factor[where][ndx].flag:=TRUE;
            v:=quotient;
            IF quotient < divisor THEN video(msgWait,FALSE);RETURN ndx; END;
        ELSE
            INC(divisor,added);
            IF added=2 THEN
                added:=4;
            ELSE (* is 4 *)
                added:=2;
            END;
        END;
        IF POLLESC THEN
            IF (divisor MOD kEsc)=0 THEN
                 IF ChkEscape() THEN ndx:=ABORTED;EXIT; END;
            END;
        END;
    END;
    video(msgWait,FALSE);

    RETURN ndx;
END factorize;

(* ------------------------------------------------------------ *)

PROCEDURE showfactors (what,ndx:CARDINAL; num:LONGCARD;ONEPERLINE,BEAUTIFY:BOOLEAN);
CONST
    equals = " = ";
VAR
    S:str80;
    v:LONGCARD;
    i,wi:CARDINAL;
BEGIN
    IF ONEPERLINE THEN
        wi:= winum;
    ELSE
        wi:= 1;
    END;
    S:=fmtme(num,wi,BEAUTIFY);
    WrStr(S);
    IF ndx = minfactor THEN
        WrStr(" is prime.");WrLn; RETURN;
    ELSE
        WrStr(equals);
        IF ONEPERLINE THEN WrLn;END;
    END;
    FOR i:=minfactor TO ndx DO
        v:=factor[what][i].k;
        S:=fmtme(v,wi,BEAUTIFY);
        WrStr(S);
        IF ONEPERLINE THEN
            IF i < ndx THEN WrLn; END;
        ELSE
            IF i < ndx THEN WrStr(" x ");END;
        END;
    END;
    WrLn;
END showfactors;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE chkPrime (num:LONGCARD; POLLESC,DEBUG:BOOLEAN):CARDINAL;
VAR
    ok : BOOLEAN;
    n  : LONGCARD;
    rc : CARDINAL;
BEGIN
    rc:= minfactor;
    IF num=2 THEN RETURN rc; END; (* 2 is prime *)
    video(msgWait,TRUE);
    completed (completedInit, num);
    n:=2; (* BFI : not the fastest way but it works *)
    LOOP
        IF ( num MOD n ) = 0 THEN rc:=maxfactor; EXIT; END;
        INC(n);
        IF n >= num THEN EXIT; END;
        IF POLLESC THEN
            IF (n MOD kEsc) = 0 THEN
                IF ChkEscape() THEN rc:=ABORTED;EXIT; END;
            END;
        END;
        completed(completedSHOW,n);
    END;
    completed(completedEnd,0);
    video(msgWait,FALSE);
    RETURN rc;
END chkPrime;

PROCEDURE showPrimeStatus (ndx:CARDINAL;num:LONGCARD;ONEPERLINE,BEAUTIFY:BOOLEAN);
VAR
    S : str80;
    wi: CARDINAL;
BEGIN
    IF ONEPERLINE THEN
        wi:= winum;
    ELSE
        wi:= 1;
    END;
    S:=fmtme(num,wi,BEAUTIFY);
    WrStr(S);
    IF ndx = minfactor THEN
        S:=" is prime indeed. :-)";
    ELSE
        S:=" does not look so prime at second sight. :-(";
    END;
    WrStr(S);WrLn;
END showPrimeStatus;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE findinfact (where,ndx:CARDINAL; limit:LONGCARD):LONGCARD;
VAR
    v, k: LONGCARD;
    i : CARDINAL;
BEGIN
    (*
    (* lazy eval : we don't find highest value here *)
    v := 1;
    i := minfactor-1;
    LOOP
        INC(i);
        IF i > ndx THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            ELSE
                EXIT;
            END;
        END;
    END;
    *)
    v := 1;
    i := ndx+1;
    LOOP
        DEC(i);
        IF i < minfactor THEN EXIT; END;
        IF factor[where][i].flag THEN
            k:=factor[where][i].k;
            IF v * k <= limit THEN
                factor[where][i].flag := FALSE; (* no longer useable *)
                v := v * k;
            END;
        END;
    END;
    RETURN v;
END findinfact;

CONST
    mintrack = 0;
    minhead  = 0;
    minsector= 1;
    FORCEBEST= 0;
    FORCE255 = 255;
    FORCE240 = 240;

PROCEDURE buildTHSfromTOTAL (VAR maxTrack,maxHead,maxSector:WORD;
                            BESTFIT:CARDINAL;totalSectors:LONGCARD;
                            POLLESC,DEBUG:BOOLEAN):BOOLEAN;
CONST
    maxsectorcount    = 63;
    maxsectorcountalt = 255; (* desperate try to keep CARDINALs everywhere *)
    maxheadcount      = 255;
    maxtrackcount     = MAX(LONGCARD);
VAR
    rebuilt,v,quotient:LONGCARD;
    t,h,s,smax:LONGCARD;
    headcount,trackcount,sectorcount:CARDINAL;
    retry,ndx,ndxref:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=TRUE;
    retry := 1;
    LOOP
        v:=totalSectors;
        CASE retry OF
        | 1 :
            s:=maxsectorcount; (* try 63 first *)
            IF trydiv(quotient, v,s,DEBUG) THEN
                v:=quotient;
            ELSE
                s:=0;
            END;
            smax := maxsectorcount;
        | 2 :
            s:=0;
            smax := maxsectorcountalt;
        END;
        (*
        FOR now, don't care about BESTFIT which is a BAD idea here
        CASE BESTFIT OF (* should always be FORCEBEST *)
        | FORCEBEST : h:=16;
        | FORCE255:   h:=255;
        | FORCE240:   h:=240;
        ELSE
                      h:=16; (* safety *)
        END;
        *)
        ndx:=factorize(minfactentry,v,POLLESC,DEBUG);
        IF ndx=ABORTED THEN
            maxTrack := ABORTED;
            maxHead  := ABORTED;
            maxSector:= ABORTED;
            RETURN FALSE;
        END;

        IF s = 0 THEN s:=findinfact(minfactentry,ndx,smax);END;
        h:=findinfact(minfactentry,ndx,maxheadcount);
        t:=findinfact(minfactentry,ndx,maxtrackcount);

        trackcount  := CARDINAL(t);
        headcount   := CARDINAL(h);
        sectorcount := CARDINAL(s);

        rebuilt     := LONGCARD(trackcount) * LONGCARD(headcount) * LONGCARD(sectorcount); (* safety *)
        IF rebuilt = totalSectors THEN EXIT; END;
        INC(retry);
        IF retry > 2 THEN rc:=FALSE; EXIT; END;
    END;
    maxTrack    := trackcount + mintrack -1;
    maxHead     := headcount  + minhead  -1;
    maxSector   := sectorcount+ minsector-1;
    RETURN rc;
END buildTHSfromTOTAL;

PROCEDURE showTHS (t,h,s:CARDINAL; v:LONGCARD; BEAUTIFY:BOOLEAN );
VAR
    R : str128;
    wi:CARDINAL;
BEGIN
    R := "~ = ~ x ~ x ~";
    wi:=1;
    Str.Subst(R,"~",fmtme(v,wi,BEAUTIFY));
    Str.Subst(R,"~",fmtme( LONGCARD(t-mintrack+1 ),wi,BEAUTIFY));
    Str.Subst(R,"~",fmtme( LONGCARD(h-minhead+1  ),wi,BEAUTIFY));
    Str.Subst(R,"~",fmtme( LONGCARD(s-minsector+1),wi,BEAUTIFY));
    WrStr(R);WrLn;
END showTHS;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 10;
VAR
    ONEPERLINE,BEAUTIFY,THSMODE,PARANOIA,POLLESC,DEBUG : BOOLEAN;
    lastparm,parmcount,i,opt:CARDINAL;
    S,R:str128;
    parm : ARRAY[firstparm..maxparm] OF str128;
    v:LONGCARD;
    ndx:CARDINAL;
    maxTrack,maxHead,maxSector:CARDINAL;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    PARANOIA   := FALSE;
    ONEPERLINE := FALSE;
    BEAUTIFY   := TRUE;
    POLLESC    := TRUE;
    THSMODE    := FALSE;
    DEBUG      := FALSE;
    lastparm   := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "L"+delim+"ONEPERLINE"+delim+
                                  "R"+delim+"RAW"+delim+
                                  "THS"+delim+
                                  "P"+delim+"PRIME"+delim+"PARANOIA"+delim+
                                  "E"+delim+"ESC"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5 :     ONEPERLINE := TRUE;
            | 6,7 :     BEAUTIFY   := FALSE;
            | 8:        THSMODE    := TRUE;
            | 9,10,11 : PARANOIA  := TRUE;
            | 12,13 :   POLLESC    := FALSE;
            | 14 :      DEBUG      := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParameter,S);END;
            Str.Copy( parm[lastparm], R);
        END;
    END;

    FOR i:= firstparm TO lastparm DO
        S := parm[i];
        filter(S,filteredChars);
        IF getvallc (S, v) THEN
            IF THSMODE THEN
                IF buildTHSfromTOTAL (maxTrack,maxHead,maxSector,
                                     FORCEBEST,v,POLLESC,DEBUG) THEN
                    showTHS(maxTrack,maxHead,maxSector,v,BEAUTIFY);
                ELSE
                    ndx:=0;
                    IF maxTrack= ABORTED THEN INC(ndx);END;
                    IF maxHead=  ABORTED THEN INC(ndx);END;
                    IF maxSector=ABORTED THEN INC(ndx);END;
                    IF ndx=3 THEN abort(errAborted,"");END;
                    abort(errTHSfailure,S);
                END;
            ELSE
                ndx:=factorize(minfactentry,v,POLLESC,DEBUG);
                IF ndx=ABORTED THEN abort(errAborted,"");END;
                showfactors(minfactentry,ndx,v,ONEPERLINE,BEAUTIFY);
                IF PARANOIA THEN
                    IF ndx=minfactor THEN
                        ndx:=chkPrime(v,POLLESC,DEBUG);
                        IF ndx=ABORTED THEN abort(errAborted,"");END;
                        showPrimeStatus(ndx,v,ONEPERLINE,BEAUTIFY);
                    END;
                END;
            END;
        ELSE
            abort(errLongCard,S);
        END;
        IF ONEPERLINE THEN
            IF i < lastparm THEN WrLn;END;
        END;
    END;

    abort(errNone,"");
END Factoriz.
