(* ---------------------------------------------------------------
Title         Q&D Elapsed
Author        PhG
Overview      compute interval between two date/time sets
Notes         many QDASTRO libs required (sky, calc, names, hide, make)
              best is to use QD_*.* from AstroPG
              and only QD_text.* from SrcMod

              as QDASTRO sources are private, any unlikely QDTOOLS user
              needing to recompile this program (but what for, eh ?)
              will have to provide his own QD_SKY functions

Bugs          probably, with this damn U.T. but who cares ?

Wish List     merge this ugly code with DT ? bah...

--------------------------------------------------------------- *)

MODULE elapsed;

IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;
IMPORT IO;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_Sky IMPORT int, frac, DateToJD, parseDeltaTU;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab,
getWindowWidth, getWindowHeight, getUseBiosMode,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup;

(* ------------------------------------------------------------ *)

CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;

CONST
    defaultink  = white;
    defaultpaper= black;

PROCEDURE colorhelp (  );
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE color (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END color;

(* ------------------------------------------------------------ *)

TYPE
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL;
    END;
    timetype = RECORD
        hours   : CARDINAL;
        minutes : CARDINAL;
        seconds : CARDINAL;
    END;
    languagetype = (usa,france);

CONST
    dash        = "-";
    slash       = "/";
    colon       = ":";
    doublequote = '"';
    CRLF        = CHR(13)+CHR(10);
CONST
    (* rounded values *)
    tokDays          = "$d";
    tokHours         = "$h";
    tokMinutes       = "$m";
    tokSeconds       = "$s";
    (* formatted *)
    tokDHM           = "$f"; (* days, hours, minutes *)
    tokDHMss         = "$z"; (* days, hours, minutes, seconds : silly at best *)
    (* misc *)
    sCRLF            = "$_";
    tokWarn          = "$w";
    tokFrankBlack    = "$!"; (* private joke *)
    tokFrankBlackAlt = "$@";
CONST
    sDELTATU    = "DELTATU";
    sPOURTU     = "POUR_TU"; (* same as AstroTools *)

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "ELAPSED";
    ProgTitle     = "Q&D Elapsed";
    ProgVersion   = "v1.0e";
    ProgCopyright = "by PhG";
CONST
    errNone              = 0;
    errHelp              = 1;
    errUnknownOpt        = 2;
    errDateOrigin        = 3;
    errDateNow           = 4;
    errTimeOrigin        = 5;
    errTimeNow           = 6;
    errTooManyParms      = 7;
    errMissingDateOrigin = 8;
    errMissingTimeOrigin = 9;
    errMissingTimeNow    = 10;
    errMissingMessage    = 11;
    errIllegalMessage    = 12;
    errBadVar            = 13;
    errBadNumber         = 14;
    errInkRange          = 15;
    errPaperRange        = 16;
    errOnlyOne           = 17;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = CHR(13) + CHR(10);
    helpmsg = nl+
ProgTitle+" "+ProgVersion+" "+ProgCopyright+nl+
nl+
"Syntax : "+ProgEXEname+" <message> <first_set> [second_set] [option]..."+nl+
nl+
"This program computes interval between two date/time sets."+nl+
nl+
"-fr   French"+nl+
"-us   English (default)"+nl+
"-c    century is 2000 if year is less than 100 (default is 1900)"+nl+
"-ut   ignore any existing U.T. environment variable ("+sDELTATU+" or "+sPOURTU+")"+nl+
"-w    append a reminder about [second_set] compared with <first_set>"+nl+
"-!    append another reminder about [second_set] compared with <first_set>"+nl+
"-@    append yet another reminder about [second_set] compared with <first_set>"+nl+
"-v    display <first_set> and [second_set] date/time sets"+nl+
"-i:#  ink [0..15] -- default is white"+nl+
"-p:#  paper [0..15] -- default is black"+nl+
"-b    monochrome BIOS output (no colors)"+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white."+nl+
nl+
"<message> should be enclosed with double quotes. Supported tokens are :"+nl+
'"'+tokDays+'" (days), "'+
tokHours+'" (hours), "'+
tokMinutes+'" (minutes), "'+
tokSeconds+'" (seconds),'+nl+
'"'+tokDHM+'" (D H M), "'+
tokDHMss+'" (D H M S), "'+
sCRLF+'" (CRLF), "'+
tokWarn+'" (-w), "'+
tokFrankBlack+'" (-!), "'+
tokFrankBlackAlt+'" (-@).'+nl+
'Integer values are rounded. Any token (except "'+sCRLF+'") can appear only once.'+nl+
nl+
"<first_set> and [second_set] format is <dd-mm-yyyy> <hh:mm:ss>."+nl+
'Date separator is "'+dash+'" or "'+slash+'", time separator is "'+colon+'" (seconds can be omitted).'+nl+
"If year is less than 100, 1900 century is assumed (unless -c was specified)."+nl+
nl+
"If omitted, [second_set] defaults to current date and time :"+nl+
"Universal Time (U.T.) is then assumed for system clock,"+nl+
"unless "+sDELTATU+" or "+sPOURTU+" (in this order) environment variables are defined"+nl+
"(-ut option forces program to ignore them)."+nl+
nl+
"Examples : "+ProgEXEname+' "You are '+tokDays+' old, Master !" 1/2/63 19:45'+nl+
"           "+ProgEXEname+' "'+tokDays+sCRLF+
                               tokHours+sCRLF+
                               tokMinutes+sCRLF+
                               tokSeconds+sCRLF+
                               tokDHM+sCRLF+
                               tokDHMss+sCRLF+sCRLF+tokWarn+'" 1/2/63 19:45'+nl+
"           "+ProgEXEname+' "'+tokDHM+'" 1/2/63 19:45 9-6-1987 12h00m00'+nl;

VAR
    S : str256;
BEGIN
    colorhelp;
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOpt :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," option !");
    | errDateOrigin :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," <origin> date !");
    | errDateNow :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," [now] date !");
    | errTimeOrigin :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," <origin> time !");
    | errTimeNow :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," [now] time !");
    | errTooManyParms:
        Str.Concat(S,"Useless ",einfo); Str.Append(S," parameter !");
    | errMissingDateOrigin :
        S:="Missing <origin> date !";
    | errMissingTimeOrigin :
        S:="Missing <origin> time !";
    | errMissingTimeNow:
        S:="Missing [now] time !";
    | errMissingMessage:
        S:="Missing <message> !";
    | errIllegalMessage :
        S:="Neither date nor time are a legal message !";
    | errBadVar:
        Str.Concat(S,"Illegal value for ",einfo); Str.Append(S," environment variable !");
    | errBadNumber:
        Str.Concat(S,"Illegal value in ",einfo);  Str.Append(S," option !");
    | errInkRange:
        S := "Ink range is [0..15] !";
    | errPaperRange:
        S := "Paper range is [0..15] !";
    | errOnlyOne:
        S := "-w, -! and -@ options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !!!";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    hoursPerDay      = 24.0;
    minutesPerHour   = 60.0;
    secondsPerMinute = 60.0;
    minutesPerDay    = hoursPerDay*minutesPerHour;
    secondsPerDay    = secondsPerMinute * minutesPerHour * hoursPerDay;

PROCEDURE makeMyDay (dd,hh,mm,ss:CARDINAL ) : LONGREAL;
VAR
    k : LONGREAL;
BEGIN
    k := LONGREAL(mm) + LONGREAL(ss) / secondsPerMinute;
    k := LONGREAL(hh) + LONGREAL(k) / minutesPerHour;
    k := LONGREAL(dd) + LONGREAL(k) / hoursPerDay;
    RETURN k;
END makeMyDay;

PROCEDURE unmakeMyDay(fracday:LONGREAL; VAR dd,hh,mm,ss : CARDINAL);
VAR
    day : LONGREAL;
    seconds : LONGCARD; (* 24*60*60=86400 so CARDINAL is not enough *)
BEGIN
    day := int( ABS(fracday) );
    dd  := CARDINAL(day);
    day := frac(fracday);
    seconds := VAL(LONGCARD, (day * hoursPerDay * minutesPerHour * secondsPerMinute + 0.5) );
    hh := CARDINAL(seconds DIV 3600); (* 60*60 *)
    mm := CARDINAL( (seconds MOD 3600) DIV 60);
    ss := CARDINAL(seconds MOD 60);
    IF hh > 23 THEN (* if this happens... do not bother too much ! *)
        hh := 23;
        mm := 59;
        ss := 59;
    END;
END unmakeMyDay;

(* ------------------------------------------------------------ *)

CONST
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    digits   = "0123456789";

PROCEDURE parseDateFull (fix2000:BOOLEAN; S : ARRAY OF CHAR;
                         VAR date : datetype) : BOOLEAN;
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1600;
    maxyy=2400-1;
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
    century : LONGCARD;
BEGIN
    IF fix2000 THEN
        v:=2000;
    ELSE
        v:=1900;
    END;
    century:=v;

    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    date.day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,"-"); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    date.month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v < 100 THEN INC(v,century); END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    date.year := CARDINAL(v);
    RETURN TRUE;
END parseDateFull;

(* ------------------------------------------------------------ *)

(* assume S is uppercase *)

CONST
    minhh=0;
    maxhh=23;
    minmm=0;
    maxmm=59;
    minss=0;
    maxss=59;

PROCEDURE parseTimeHMS (S : ARRAY OF CHAR;
                        VAR time : timetype) : BOOLEAN;
CONST
    separator=colon;
    separatorH="H";
    separatorM="M";
    separatorS="S";
    legaltimeset = digits+separator+separatorH+separatorM+separatorS;
    pat1 = "*:*:*";
    pat2 = "*:*";
    pat3 = "*H*M*S";
    pat4 = "*H*M*";
    pat5 = "*H*";
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaltimeset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;

    i:=0;
    IF Str.Match(S,pat1) THEN INC(i);END;
    IF Str.Match(S,pat2) THEN INC(i);END;
    IF Str.Match(S,pat3) THEN INC(i);END;
    IF Str.Match(S,pat4) THEN INC(i);END;
    IF Str.Match(S,pat5) THEN INC(i);END;
    IF i = 0 THEN RETURN FALSE; END;

    i:=0;
    IF CharCount(S,"H") > 1 THEN INC(i);END;
    IF CharCount(S,"M") > 1 THEN INC(i);END;
    IF CharCount(S,"S") > 1 THEN INC(i);END;
    IF CharCount(S,":") > 2 THEN INC(i);END;
    IF i # 0 THEN RETURN FALSE;END;

    Str.Subst(S,separatorH,separator);
    Str.Subst(S,separatorM,separator);
    Str.Subst(S,separatorS,separator);

    i := CharCount(S,separator);
    CASE i OF
    | 1,2 : ; (* ##h[##[m[##]] *)
    ELSE
        RETURN FALSE;
    END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < minhh) OR (v > maxhh) THEN RETURN FALSE; END;
    time.hours := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    IF same(R,"") THEN
        v:=minmm;
    ELSE
        v := Str.StrToCard(R,10,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
        IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    END;
    time.minutes := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    IF same(R,"") THEN
        v:=minss;
    ELSE
        v := Str.StrToCard(R,10,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
        IF (v < minss) OR (v > maxss) THEN RETURN FALSE; END;
    END;
    time.seconds := CARDINAL(v);

    RETURN TRUE;
END parseTimeHMS;

(* ------------------------------------------------------------ *)

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,dayOfWeek);
END getDateNow;

PROCEDURE getTimeNow (VAR t : timetype);
VAR
    hundredth : CARDINAL;
BEGIN
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END getTimeNow;

(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE WrDate (dmy:datetype;language:languagetype):str80;
CONST
    separator = dash;
    pad="0";
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ";
VAR
    R,S : str80;
BEGIN
    Str.Concat(R,  using(dmy.day,2,pad), separator);
    CASE language OF
    | france: Str.ItemS(S,tmonths ," ",dmy.month-1);
    | usa:    Str.ItemS(S,tmonths2," ",dmy.month-1);
    END;
    Str.Append(R,S);
    Str.Append(R,separator);
    Str.Append(R,using(dmy.year,4,pad));
    RETURN R;
END WrDate;

PROCEDURE WrTime (hms:timetype ):str80;
CONST
    separator = colon;
    pad="0";
VAR
    R : str80;
BEGIN
    Str.Concat(R, using(hms.hours,2,pad), separator);
    Str.Append(R, using(hms.minutes,2,pad));
    Str.Append(R, separator);
    Str.Append(R, using(hms.seconds,2,pad));
    RETURN R;
END WrTime;

CONST
    (* time in days of these operations undetermined for now, assume 1 second *)
    overheadprocesstime = ((1.0 / secondsPerMinute) / minutesPerHour) / hoursPerDay;

PROCEDURE ComputeDelta (DMY1:datetype;HMS1:timetype;
                        DMY2:datetype;HMS2:timetype) : LONGREAL;
VAR
    JDbase, JDnow : LONGREAL;
    d, m, y : LONGREAL;
BEGIN
    d := makeMyDay(DMY1.day,HMS1.hours,HMS1.minutes,HMS1.seconds);
    m := LONGREAL (DMY1.month);
    y := LONGREAL (DMY1.year);
    JDbase := DateToJD(d,m,y);

    d := makeMyDay(DMY2.day,HMS2.hours,HMS2.minutes,HMS2.seconds);
    m := LONGREAL (DMY2.month);
    y := LONGREAL (DMY2.year);
    JDnow  := DateToJD(d,m,y);

    RETURN (JDnow-JDbase); (* was ABS() *)
END ComputeDelta;

(* ------------------------------------------------------------ *)

PROCEDURE substring (S1,S2:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    Str.Lows(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    RETURN FALSE;
END substring;

PROCEDURE newstring (VAR R:ARRAY OF CHAR; old,new:ARRAY OF CHAR);
BEGIN
    IF Str.Pos(R,old) # MAX(CARDINAL) THEN
        Str.Subst(R,old,new);
    ELSE
        Str.Caps(old);
        IF Str.Pos(R,old) = MAX(CARDINAL) THEN RETURN; END;
        Str.Subst(R,old,new);
    END;
END newstring;

PROCEDURE plural (language:languagetype;v:LONGCARD;
                 PluralFR,SingularFR,PluralUS,SingularUS:ARRAY OF CHAR):str80;
VAR
    S,R:str80;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr(v,S,10,ok);
    Str.Append(R," ");
    CASE language OF
    | france:
        IF v > 1 THEN
            Str.Copy(R,PluralFR);
        ELSE
            Str.Copy(R,SingularFR);
        END;
    | usa:
        IF v > 1 THEN
            Str.Copy(R,PluralUS);
        ELSE
            Str.Copy(R,SingularUS);
        END;
    END;
    Str.Append(S,R);
    RETURN S;
END plural;

PROCEDURE pluralreal (orgv:LONGREAL;language:languagetype;
                   FR,FRpl,US,USpl:ARRAY OF CHAR;
                   VAR S : ARRAY OF CHAR );
CONST
    realOne = LONGREAL( 1.0 );
VAR
    ok : BOOLEAN;
    R  : str128;
    v  : LONGREAL;
BEGIN
    v:= ABS(orgv);
    Str.FixRealToStr( v,0,R,ok);
    Str.Append(R," ");
    CASE language OF
    | france:
        IF v > realOne THEN
            Str.Append(R,FRpl);
        ELSE
            Str.Append(R,FR);
        END;
    | usa:
        IF v > realOne THEN
            Str.Append(R,USpl);
        ELSE
            Str.Append(R,US);
        END;
    END;
    Str.Copy(S,R);
END pluralreal;

(* ------------------------------------------------------------ *)

PROCEDURE dbg (DEBUG:BOOLEAN;v:LONGREAL;lc:LONGCARD; S,Z:ARRAY OF CHAR);
CONST
    tabul = CHR(9);
VAR
    ok:BOOLEAN;
    R:str80;
BEGIN
    IF DEBUG THEN
        IF same(S,"")  THEN
            WrStr(tabul+tabul+tabul);
        ELSE
            Str.FixRealToStr(v,10,R,ok);
            WrStr(S);WrStr( tabul+tabul );WrStr(R);
        END;
        IF same(Z,"")=FALSE THEN
            Str.CardToStr(lc, R,10,ok);
            WrStr(tabul+tabul);WrStr(Z);WrStr( tabul+tabul );WrStr(R);
        END;
        WrLn;
    END;
END dbg;

CONST
    roundme = LONGREAL(0.5); (* I hate those rounding fixes *)

PROCEDURE fmtdhm (DEBUG:BOOLEAN;orgv:LONGREAL;language:languagetype;
                  VAR S : ARRAY OF CHAR);
VAR
    jours,heures,minutes:LONGCARD;
    R:str128;
    v:LONGREAL;
BEGIN
(* dbg(DEBUG,orgv,0,"orgv",""); *)
    v        := ABS(orgv);
    jours    := VAL(LONGCARD,v); (* as intended, does NOT perform any rounding *)
dbg(DEBUG,v,jours,"vj","jj");
    v        := frac(v) * hoursPerDay;
    heures   := VAL(LONGCARD,v);
dbg(DEBUG,v,heures,"vh","hh");
    v        := frac(v) * minutesPerHour;
    minutes  := VAL(LONGCARD,v+roundme);
dbg(DEBUG,v,minutes,"vm","mm");

    IF minutes > maxmm THEN
        minutes:=minmm;
        INC(heures);
        IF heures > maxhh THEN
            heures:=minhh;
            INC(jours);
        END;
    END;
dbg(DEBUG,v,jours,"","jjfixed");
dbg(DEBUG,v,heures,"","hhfixed");
dbg(DEBUG,v,minutes,"","mmfixed");

    Str.Copy  (S, plural (language,jours,
                         " jours, "  ,  " jour, "  ,
                         " days, "   ,  " day, "));

    Str.Append(S, plural (language,heures,
                         " heures et "  ,  " heure et "  ,
                         " hours and "  ,  " hour and "));

    Str.Append(S, plural (language,minutes,
                         " minutes"  ,  " minute"  ,
                         " minutes"  ,  " minute"));
END fmtdhm;

PROCEDURE fmtdhms (DEBUG:BOOLEAN;orgv:LONGREAL;language:languagetype;
                  VAR S : ARRAY OF CHAR);
VAR
    jours,heures,minutes,secondes:LONGCARD;
    ok:BOOLEAN;
    R:str128;
    v:LONGREAL;
BEGIN
(* dbg(DEBUG,orgv,0," orgV",""); *)
    v        := ABS(orgv);
    jours    := VAL(LONGCARD,v); (* as intended, does NOT perform any rounding *)
dbg(DEBUG,v,jours," Vj","jj");
    v        := frac(v) * hoursPerDay;
    heures   := VAL(LONGCARD,v);
dbg(DEBUG,v,heures," Vh","hh");
    v        := frac(v) * minutesPerHour;
    minutes  := VAL(LONGCARD,v);
dbg(DEBUG,v,minutes," Vm","mm");
    v        := frac(v) * secondsPerMinute;
    secondes := VAL(LONGCARD,v+roundme);
dbg(DEBUG,v,secondes," Vs","ss");

    IF secondes > maxss THEN
        secondes:=minss;
        INC(minutes);
        IF minutes > maxmm THEN
            minutes:=minmm;
            INC(heures);
            IF heures > maxhh THEN
                heures:=minhh;
                INC(jours);
            END;
        END;
    END;
dbg(DEBUG,v,jours,"","jjFIXED");
dbg(DEBUG,v,heures,"","hhFIXED");
dbg(DEBUG,v,minutes,"","mmFIXED");
dbg(DEBUG,v,secondes,"","mmFIXED");

    Str.Copy  (S, plural (language,jours,
                         " jours, "  ,  " jour, "  ,
                         " days, "   ,  " day, "));

    Str.Append(S, plural (language,heures,
                         " heures, "  ,  " heure, "  ,
                         " hours, "   ,  " hour, "));

    Str.Append(S, plural (language,minutes,
                         " minutes et "   ,  " minute et "  ,
                         " minutes and "  ,  " minute and "));

    Str.Append(S, plural (language,secondes,
                         " secondes"  ,  " seconde"  ,
                         " seconds"   ,  " second"));

END fmtdhms;

PROCEDURE fmtMillennium (orgv:LONGREAL;language:languagetype;
                        VAR S : ARRAY OF CHAR);
VAR
    R:str128;
    v:LONGINT;
BEGIN
    v:= LONGINT(orgv);
    CASE language OF
    | france:
        IF v < 0 THEN
            R:="Encore ~ avant le moment fatidique...";
        ELSIF  v > 0 THEN
            R:="Dj ~ de trop...";
        ELSE
            R:="Les temps sont venus.";
        END;
    | usa:
        IF v < 0 THEN
            R:="Still ~ remaining...";
        ELSIF  v > 0 THEN
            R:="Already ~ past deadline...";
        ELSE
            R:="The time has come.";
        END;
    END;
    Str.Subst(R,"~",S);
    Str.Copy(S,R);
END fmtMillennium;

PROCEDURE fmtwarning (orgv:LONGREAL;language:languagetype;
                     VAR S : ARRAY OF CHAR );
VAR
    R  : str128;
    v  : LONGINT;
BEGIN
    v:= LONGINT(orgv);
    CASE language OF
    | france:
        IF v < 0 THEN
            R:="C'est le temps qui reste AVANT la date fixe...";
        ELSIF  v > 0 THEN
            R:="C'est le temps pass DEPUIS la date fixe.";
        ELSE
            R:="C'est le jour exact !";
        END;
    | usa:
        IF v < 0 THEN
            R:="It's time remaining BEFORE specified moment...";
        ELSIF  v > 0 THEN
            R:="It's time past AFTER specified moment.";
        ELSE
            R:="It's the day now !";
        END;
    END;
    Str.Copy(S,R);
END fmtwarning;

PROCEDURE dumpDelta (DEBUG:BOOLEAN;msg:ARRAY OF CHAR;days:LONGREAL;language:languagetype);
VAR
    dd,h,m,s:CARDINAL;
    S:str128;
    R:str1024; (* str128 was sometimes too small *)
    ok:BOOLEAN;
BEGIN
    Str.Copy(R,msg);
    unmakeMyDay(frac(days),dd,h,m,s);

    LOOP
        IF substring(R,sCRLF)=FALSE THEN EXIT; END;
        newstring(R,sCRLF,CRLF);
    END;

    (* assume token appears only once *)

    pluralreal(days,language,"jour","jours","day","days",S);
    newstring(R,tokDays,S);

    pluralreal(days*hoursPerDay,language,"heure","heures","hour","hours",S);
    newstring(R,tokHours,S);

    pluralreal(days*minutesPerDay,language,"minute","minutes","minute","minutes",S);
    newstring(R,tokMinutes,S);

    pluralreal(days*secondsPerDay,language,"seconde","secondes","second","seconds",S);
    newstring(R,tokSeconds,S);

    fmtdhm(DEBUG,days,language,S);
    newstring(R,tokDHM,S);

    fmtdhms(DEBUG,days,language,S);
    newstring(R,tokDHMss,S);

    fmtdhm(FALSE,days,language,S);
    fmtMillennium(days*minutesPerDay,language,S);
    newstring(R,tokFrankBlack,S);

    fmtdhms(FALSE,days,language,S);
    fmtMillennium(days*secondsPerDay,language,S);
    newstring(R,tokFrankBlackAlt,S);

    fmtwarning(days,language,S);
    newstring(R,tokWarn,S);

    WrLn; WrStr(R); WrLn;

END dumpDelta;

PROCEDURE dumpDates (VAR Z : ARRAY OF CHAR;
                    country:languagetype;useVar,ignoreVar:BOOLEAN;
                    DMYorigin:datetype;HMSorigin:timetype;
                    DMYnow:datetype;HMSnow:timetype;
                    pourtu:ARRAY OF CHAR);
VAR
    S,R:str128;
BEGIN
    CASE country OF
    | france:
        IF useVar THEN
            IF ignoreVar THEN
                R:="(horloge systme)";
            ELSE
                Str.Concat(R,"(",pourtu);Str.Append(R," pour le T.U.)");
            END;
        ELSE
            R:="(horloge systme)";
        END;
        S:="Intervalle ~"+nl+"entre le ~ et le ~  ~";
    | usa:
        IF useVar THEN
            IF ignoreVar THEN
                R:="(system clock)";
            ELSE
                Str.Concat(R,"(",pourtu);Str.Append(R," for U.T.)");
            END;
        ELSE
            R:="(system clock)";
        END;
        S:="Interval ~"+nl+"between ~ at ~ and ~ at ~";
    END;
    Str.Subst(S,"~",R);
    Str.Subst(S,"~",WrDate(DMYorigin,country));
    Str.Subst(S,"~",WrTime(HMSorigin));
    Str.Subst(S,"~",WrDate(DMYnow,country));
    Str.Subst(S,"~",WrTime(HMSnow));
    Str.Copy(Z,S);
END dumpDates;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* adapted from chkPOURTU() in TRANSITS.MOD *)

PROCEDURE chkEnv (VAR fromHLtoTU:LONGREAL; VAR env,R:ARRAY OF CHAR) : BOOLEAN;
VAR
    rc, useLocal : BOOLEAN;
BEGIN
    Str.Copy(env,sDELTATU);
    Lib.EnvironmentFind(env,R); (* try DELTATU *)
    IF same(R,"") THEN
        Str.Copy(env,sPOURTU);
        Lib.EnvironmentFind(env,R); (* try POUR_TU *)
    END;
    IF same(R,"") THEN
        fromHLtoTU := 0.0;
        RETURN TRUE;
    END;
    rc:=parseDeltaTU(R,fromHLtoTU,useLocal); (* P is ok, but L is not ! *)
    IF rc = FALSE THEN
        fromHLtoTU := 0.0;
        RETURN FALSE;
    END;
    IF useLocal THEN
        fromHLtoTU := 0.0;
        RETURN FALSE;
    END;
    RETURN TRUE;
END chkEnv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 5; (* msg JMA HMS [JMA HMS] *)
VAR
    parm      : ARRAY [firstparm..maxparm] OF str128;
    S,R       : str128;
    parmcount,i,opt,lastparm   : CARDINAL;
    DMYorigin,DMYnow : datetype;
    HMSorigin,HMSnow : timetype;
    deltadays : LONGREAL;
    pourtu,message   : str128;
    needOverhead : BOOLEAN;
    language     : languagetype;
    DEBUG,verbose,useVar,ignoreVar,fix2000:BOOLEAN;
    warning,millennium,millenniumAlt : BOOLEAN;
    fromHLtoTU   : LONGREAL; (* in days *)
    ink,paper    : CARDINAL;
    v            : LONGCARD;
BEGIN
    Lib.DisableBreakCheck();

    (* handleVesa; *) (* useless, because we won't change video mode *)
    setUseBiosMode ( IsRedirected() );
    findInkPaperAtStartup();
    ink   := ORD(defaultink);
    paper := ORD(defaultpaper);

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,""); END;

    needOverhead := FALSE;
    language      := usa;
    verbose      := FALSE;
    useVar       := FALSE;
    ignoreVar    := FALSE;
    warning      := FALSE;
    millennium   := FALSE;
    millenniumAlt:= FALSE;
    fix2000      := FALSE;
    DEBUG        := FALSE;

    lastparm     := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "F"+delim+"FR"+delim+"FRANCE"+delim+
                                  "A"+delim+"US"+delim+"USA"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "I:"+delim+"INK:"+delim+
                                  "P:"+delim+"PAPER:"+delim+
                                  "B"+delim+"BIOS"+delim+
                                  "TU"+delim+"UT"+delim+"IGNORE"+delim+
                                  "W"+delim+"WARN"+delim+"WARNING"+delim+
                                  "C"+delim+"NEWCENTURY"+delim+"XXI"+delim+
                                  "!"+delim+"MILLENNIUM"+delim+
                                  "@"+delim+
                                  "DEBUG"
                              );

            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5,6 :   language := france;
            | 7,8,9 :   language := usa;
            | 10,11 :   verbose := TRUE;
            | 12,13:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errInkRange,"");END;
                ink:=CARDINAL(v);
            | 14,15:
                IF GetLongCard(S,v)=FALSE THEN abort(errBadNumber,S); END;
                IF ( (v < mincolor) OR (v > maxcolor) ) THEN abort(errPaperRange,"");END;
                paper:=CARDINAL(v);
            | 16,17:    setUseBiosMode ( TRUE );
            | 18,19,20: ignoreVar := TRUE;
            | 21,22,23: warning := TRUE;
            | 24,25,26: fix2000 := TRUE;
            | 27,28:    millennium:=TRUE;
            | 29:       millenniumAlt:=TRUE;
            | 30:       DEBUG   := TRUE;
            ELSE
                abort(errUnknownOpt,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            IF lastparm = firstparm THEN
                IF parseDateFull(fix2000,R,DMYorigin) THEN abort(errIllegalMessage,"");END;
                IF parseTimeHMS(R,HMSorigin) THEN abort(errIllegalMessage,"");END;
                parm[lastparm]:=S; (* keep original case for message *)
            ELSE
                parm[lastparm]:=R;
            END;
        END;
    END;

    CASE lastparm OF
    | firstparm-1:  abort(errMissingMessage,"");
    | 1:            abort(errMissingDateOrigin,"");
    | 2:            abort(errMissingTimeOrigin,"");
    | 3:
        R:=parm[2];
        IF parseDateFull(fix2000,R,DMYorigin)=FALSE THEN abort(errDateOrigin,R); END;
        R:=parm[3];
        IF parseTimeHMS(R,HMSorigin)=FALSE THEN abort(errTimeOrigin,R); END;

        getDateNow(DMYnow);
        getTimeNow(HMSnow); (* let's hope we don't cross midnight ! ;-) maybe we should reread date ! *)
        needOverhead := TRUE;
        useVar       := TRUE;
    | 4:            abort(errMissingTimeNow,"");
    | 5:
        R:=parm[2];
        IF parseDateFull(fix2000,R,DMYorigin)=FALSE THEN abort(errDateOrigin,R); END;
        R:=parm[3];
        IF parseTimeHMS(R,HMSorigin)=FALSE THEN abort(errTimeOrigin,R); END;

        R:=parm[4];
        IF parseDateFull(fix2000,R,DMYnow)   =FALSE THEN abort(errDateNow,R);    END;
        R:=parm[5];
        IF parseTimeHMS(R,HMSnow)   =FALSE THEN abort(errTimeNow,R);    END;
    END;
    Str.Copy(message,parm[firstparm]);

    i:=0;
    IF warning THEN INC(i);END;
    IF millennium THEN INC(i);END;
    IF millenniumAlt THEN INC(i);END;
    IF i > 1 THEN abort(errOnlyOne,"");END;

    deltadays:=ComputeDelta(DMYorigin,HMSorigin,DMYnow,HMSnow);

    IF useVar THEN
        IF ignoreVar=FALSE THEN
            IF chkEnv(fromHLtoTU,R,pourtu)=FALSE THEN abort(errBadVar,R);END;
            deltadays:=deltadays+fromHLtoTU;
        END;
    END;

    IF needOverhead THEN deltadays:=deltadays+overheadprocesstime;END;

    color(ink,paper);

    IF verbose THEN
        dumpDates (S,   language, useVar,ignoreVar,
                  DMYorigin,HMSorigin,DMYnow,HMSnow, pourtu);
        WrLn; WrStr(S); WrLn;
    END;

    dumpDelta(DEBUG,message,deltadays,language);

    IF warning THEN
        fmtwarning(deltadays,language,S);
        WrLn; WrStr(S); WrLn;
    END;

    IF millennium THEN
        fmtdhm(FALSE,deltadays,language,S);
        fmtMillennium(deltadays*minutesPerDay,language,S);
        WrLn; WrStr(S); WrLn;
    END;

    IF millenniumAlt THEN
        fmtdhms(FALSE,deltadays,language,S);
        fmtMillennium(deltadays*secondsPerDay,language,S);
        WrLn; WrStr(S); WrLn;
    END;

    colorhelp;

    abort(errNone,"");
END elapsed.





(*

@echo off
if "%1" == "" goto new
set p=\bat\elapsed
set f=old
goto both
:new
set p=elapsed
set f=new
:both
if exist %f% del %f%

set a=
set b=
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63
set b=
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/ 19
set b=
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19
set b=
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%



set a=1/2/63 19:45
set b=1/2/63 19h45m1
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19:45
set b=9/6/87 12h00
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19:45
set b=9/6/87 12h00m00
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19:45
set b=9/6/87 12h00m01
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19:45
set b=9/6/87 11h59m
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%

set a=1/2/63 19h45
set b=
%p% -v "$d$_$h$_$m$_$s$_You're $f old !$_$z$_$_$w" %a% %b% >> %f%


l %f%

*)

