(* ---------------------------------------------------------------
Title         Q&D Signature Finder
Author        PhG
Overview      see help
Usage         see help (bis repetita...)
Notes         very, very, very quick & dirty... as usual ! :-(
              help screen should make it clear that strings delimited
              by double quotes can be flagged as imaginary errors
              ("2G", etc.)
Bugs          yet another M$ one : vindoze does NOT like frequent calls
              to BIOS ChkEscape() !
Wish List     joker processing in dec data ?
              escape characters ?
              rc = 255 if data was not found for unique file ?

--------------------------------------------------------------- *)

MODULE SigFind;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec;

(* ------------------------------------------------------------ *)

CONST
    FROZEN = TRUE;
CONST
    msgSearchingHex    = "Hex string to find :";
    msgSearchingDec    = "Dec string to find :";
    msgSearchingAsc    = "Asc string to find :";
    msgWarning         = "File offsets and data are in hexadecimal, but without $ prefix";
    msgWarningOld      = "File offsets are in hexadecimal";
    msgCaseInsensitive = "Warning ! Search is not case-sensitive !";
    msgFixFpos         = "Warning ! File offset fix-up enabled : ";
    msgExactFpos       = "Warning ! Search at this file offset only : ";
    msgListOnly        = "Warning ! Matching files only !";
    msgScanningFile    = "File "; (* yes, one space more *)
    comment            = "; "; (* for XD *)
CONST
    decdigits      = "0123456789";
    hexdigits      = decdigits+"ABCDEF";
    hexdigitsJoker = hexdigits+"?";
CONST
    jokerstring    = "??";
    jokerstringhex = "???"; (* field width = 2 with "$" prefix *)
    jokerstringdec = "???"; (* field width = 3 *)
    jokerstringasc = "???"; (* field width = 1 between quotes *)
CONST
    dollar         = "$";
    doublequote    = '"';
    singlequote    = "'";
    blank          = " ";
    spacecode      = ORD(" ");
    gremlin        = ".";
    nullchar       = 0C; (* CHR(0) *)
    dot            = ".";
    dotdot         = dot+dot;
    colon          = ":";
CONST
    ProgEXEname   = "SIGFIND";
    ProgTitle     = "Q&D Signature Finder";
    ProgVersion   = "v1.1o";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone               = 0;
    errHelp               = 1;
    errBadHex             = 2;
    errBadHexFormat       = 3;
    errBadHexValue        = 4;
    errBadDec             = 5;
    errBadDecValue        = 6;
    errBadString          = 7;
    errUnmatchedQuote     = 8;
    errTooManyFiles       = 9;
    errNotFound           =10;
    errAborted            =11;
    errMissingSpec        =12;
    errMissingData        =13;
    errUnknownOption      =14;
    errBadValue           =15;
    errBadRange           =16;
    errNotInSet           =17;
    errCmdConflict        =18;
    errTooManyConversions =19;
    errTooManyStrings     =20;
    (* errFpos         =21; *)

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL;einfo:ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
    helpmsg=
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [option]... <filespec> <$Hex_String|Dec_Value|String>..."+nl+
"Syntax 2 : "+ProgEXEname+" <-n:#>..."+nl+
"Syntax 3 : "+ProgEXEname+" <-s:$>..."+nl+
nl+
"-d    duplicate each output line"+nl+
"-x    old output format with $ hexadecimal prefix (default : XD format)"+nl+
"-i    case-insensitive strings"+nl+
"-w    convert searched string to Win16 set"+nl+
"-u    convert searched string to Win32 (Unicode) set"+nl+
"-t    display ASCII data after file offset"+nl+
"-b    beep when done"+nl+
"-c    force hexadecimal values to uppercase (default is lowercase)"+nl+
'-f:#  fix file offset if data was found ("[+|-][$|0x]<digit>..." format)'+nl+
'-e:#  scan for data at exact file offset ("[$|0x]<digit>..." format)'+nl+
"-l    list filename only if sequence searched for exists (sequence not dumped)"+nl+
"-v    verbose mode (progression information but slower display)"+nl+
"-n:#  convert (hexa)decimal LONGCARD value (any other option ignored)"+nl+
"-s:$  show hexadecimal (possibly single- or double-quoted) string equivalent"+nl+
"-a[a] display ASCII reference set (-aa = decimal)"+nl+
"-o[o] display Windows OEM reference set (-oo = decimal)"+nl+
"-lfn  disable LFN support even if available"+nl+
nl+
"a) Any option must be specified BEFORE <filespec>."+nl+
"b) Unambiguous string parsing requires single or double quotes delimiters."+nl+
"c) From DOS, strings containing "+'"%"'+" require particular care."+nl+
"d) In hexadecimal strings ONLY, "+'"'+jokerstring+'"'+" sequence stands for any value."+nl+
"e) These options ignore any other option : -a[a], -o[o], -n:# and -s:$."+nl+
nl+
"Examples : "+ProgEXEname+" win.com $CD21"+nl+
"           "+ProgEXEname+' -i win.com "windows"'+nl+
"           "+ProgEXEname+" -n:1963 -n:$7ab"+nl;
(*
"For mysterious reasons which are beyond Programming Gods and Code Police,"+nl+
"-q option prevents program from working in *any* Windows 3.x/9x DOS box ! :-("+nl;
*)

VAR
    S : str256;
    ok:BOOLEAN;
BEGIN
    CASE e OF
    | errHelp :         WrStr(helpmsg);
    | errBadHex:        S:="Bad hexadecimal string in command line !";
    | errBadHexFormat:  S:="Each hexadecimal number must have exactly two digits !";
    | errBadHexValue:   S:="Hex number must be in the [$00..$FF] range !";
    | errBadDec:        S:="Bad decimal number in command line !";
    | errBadDecValue:   S:="Number must be in the [0..255] range !";
    | errBadString:     S:="Empty string !";
    | errUnmatchedQuote:S:="Unmatched quote in string definition !";
    | errTooManyFiles:  S:="Too many files match <filespec> !";
    | errNotFound:      S:="No file matches <filespec> !";
    | errAborted:       S:="Search aborted by user !";
    | errMissingSpec:   S:="Missing <filespec> !";
    | errMissingData:   S:="No data to look for !";
    | errUnknownOption: Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errBadValue:      Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errBadRange:      Str.Concat(S,"Out of range ",einfo);Str.Append(S," value !");
    | errNotInSet:      Str.Concat(S,"String contains at least one character without match in ",einfo);
                        Str.Append(S," set !");
    | errCmdConflict:   S:="-a[a], -o[o], -n:# and -s:$ options are mutually exclusive !";
    | errTooManyConversions: S:="Too many -n:# values !";
    | errTooManyStrings: S:="Too many -s:$ strings !";
    (*
    | errFpos:          Str.Concat(S,"Specified exact file offset does not fit ",einfo);
                        Str.Append(S," length !");
    *)
    ELSE
        (* S := "How Can Such A Thing B(i)e(rce) ???"; *)
        S:="This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;useLFN:BOOLEAN;spec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := SHORTCARD(len);
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

PROCEDURE makebase (useLFN:BOOLEAN;spec:pathtype;VAR basepath:pathtype);
VAR
    u,d,n,e,current:pathtype;
    unit:str2;
    drive:SHORTCARD;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Str.Concat(basepath,u,d);
    IF same(basepath,"") THEN
        drive:=FIO.GetDrive(); (* yes we could use 0 as default drive *)
        doGetCurrent(useLFN,drive,  unit,current); (* "u:" and "\" or "\*\" *)
        Str.Concat(basepath, unit,current);
    END;
END makebase;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE PadHex (nicehex:BOOLEAN; v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    delta : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,16,ok);
    delta := digits - Str.Length(S);
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    IF nicehex THEN Str.Lows(R); END;
    RETURN R;
END PadHex;

PROCEDURE PadDec (v : LONGCARD; digits : CARDINAL) : str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    delta : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,10,ok);
    delta := digits - Str.Length(S);
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END PadDec;

PROCEDURE num2str (n:CARDINAL):str16;
VAR
    R:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr ( LONGCARD(n),R,10,ok);
    RETURN R;
END num2str;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (16 * 512) + FIO.BufferOverhead; (* 8 would do *)
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    ioBuffer        : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
    hnd             : FIO.File;

PROCEDURE verify (S,legal:ARRAY OF CHAR): BOOLEAN;
VAR
    len,i : CARDINAL;
BEGIN
    len:=Str.Length(S);
    IF len = 0 THEN RETURN FALSE; END;
    FOR i := 1 TO len DO
        IF Str.CharPos(legal,S[i-1])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END verify;

PROCEDURE getch (S:ARRAY OF CHAR; base:CARDINAL;VAR ch:CHAR  ) : BOOLEAN;
CONST
    minbyte = LONGCARD(0);
    maxbyte = LONGCARD(255);
VAR
    ok:BOOLEAN;
    v:LONGCARD;
BEGIN
    v:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < minbyte) OR (v > maxbyte) THEN RETURN FALSE; END;
    ch:=CHAR(v);
    RETURN TRUE;
END getch;

(* ------------------------------------------------------------ *)

(*

//
PROCEDURE dumpdata ( filepos:LONGCARD;newstyle:BOOLEAN;hexdata:ARRAY OF CHAR);
VAR
    sVal : str16;
BEGIN
    sVal:=PadHex(filepos,6);
    IF NOT(newstyle) THEN WrStr("  $"); END;
    WrStr(sVal);
    IF newstyle THEN WrStr(" :"); WrStr(hexdata); END;
    WrLn;
END dumpdata;

*)

PROCEDURE dumprealdata (VAR matches:LONGCARD;
                       useLFN:BOOLEAN;file:pathtype;filepos:LONGCARD;
                       count:CARDINAL;
                       newstyle,dumpascii,dupfound,listonly,nicehex:BOOLEAN;
                       fixfpos:LONGINT );
VAR
    handle : FIO.File;
    sVal   : str16;
    i,got  : CARDINAL;
    ch     : BYTE;
    lastpass,pass   : CARDINAL;
BEGIN
    INC(matches);
    IF listonly THEN RETURN; END;
(*
WrStr("file     : ");WrStr(file);WrLn;
WrStr("filepos  : ");IO.WrLngHex(filepos,12);WrLn;
WrStr("count    : ");IO.WrCard(count,8);WrLn;
*)
    handle:=fileOpenRead(useLFN,file);

    IF fixfpos # 0 THEN
        INC(filepos,LONGCARD(fixfpos));
        (*
        // at second thought, don't mess with count !
        IF fixfpos < 0 THEN
            INC(count, CARDINAL( ABS(fixfpos) ) );
        ELSE
            DEC(count, CARDINAL( fixfpos ) );
        END;
        *)
    END;

    IF dupfound THEN
        lastpass:=2;
    ELSE
        lastpass:=1;
    END;

FOR pass:=1 TO lastpass DO

    sVal:=PadHex(nicehex,filepos,8); (* was 6 but with those (censored) huge files... *)
    IF NOT(newstyle) THEN WrStr("  $"); END;
    WrStr(sVal);
    IF newstyle THEN
        FIO.Seek(handle,filepos);
        WrStr(" :");
        FOR i:= 1 TO count DO
            got := FIO.RdBin(handle,ch,1);
            sVal:=PadHex( nicehex,LONGCARD(ORD(ch)), 2 );
            WrStr(" ");
            WrStr(sVal);
        END;
    END;
    IF dumpascii THEN
        FIO.Seek(handle,filepos);
        WrStr(" ; "+doublequote);
        FOR i:= 1 TO count DO
            got := FIO.RdBin(handle,ch,1);
            IF ( (ORD(ch) < spacecode) OR (ORD(ch) = 255) ) THEN
                WrStr(gremlin);
            ELSE
                WrStr(ch);
            END;
        END;
        WrStr(doublequote);
    END;
    WrLn;

END;

    FIO.Close(handle);
END dumprealdata;

(* ------------------------------------------------------------ *)

PROCEDURE getCli (VAR S : ARRAY OF CHAR);
CONST
    nullchar = CHR(0);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = nullchar THEN EXIT; END;
        INC(i);
    END;
    cleantabs(S); (* always remove tabs *)
END getCli;

PROCEDURE argc (cli : ARRAY OF CHAR; clean : BOOLEAN) : CARDINAL;
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch       : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    RETURN argCount;
END argc;

PROCEDURE argv (VAR argument : ARRAY OF CHAR;
                cli : ARRAY OF CHAR; n : CARDINAL; clean:BOOLEAN);
VAR
    state    : (empty,intoken,instring);
    cliLen   : CARDINAL;
    cliPos   : CARDINAL;
    argCount : CARDINAL;
    ch     : CHAR;
    code     : CARDINAL;
    arg      : str128;
    sdelim   : CARDINAL;
BEGIN
    IF ( (n < 1) OR (n > argc(cli,clean)) ) THEN
        Str.Copy(argument,"");
        RETURN;
    END;
    IF clean THEN
        LtrimBlanks(cli);
        RtrimBlanks(cli);
    END;
    cliLen   := Str.Length(cli);
    cliPos   := 1;
    argCount := 0;
    state    := empty;
    LOOP
        IF cliPos > cliLen THEN EXIT; END;
        ch := cli[cliPos-1];
        code := ORD(ch);
        CASE state OF
        | empty :
            IF n = argCount THEN EXIT; END; (* argV$ test *)
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN
                sdelim:= code;
                state := instring;        (* begin new string *)
                Str.Copy(arg,ch);
                INC(argCount);
            ELSIF code > ORD(blank) THEN  (* quote already trapped *)
                state := intoken;         (* begin new token *)
                Str.Copy(arg,ch);
                INC(argCount);
            END;
        | intoken :
            IF ( (code = ORD(doublequote)) OR (code=ORD(singlequote)) ) THEN (* quote in token *)
                sdelim:= code; (* fix *)
                state := instring;        (* if string in parameter *)
                Str.Append(arg,ch);
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                state := empty;           (* end of token *)
            END;
        | instring :
            IF code = sdelim THEN
                Str.Append(arg,ch);
                state := empty;           (* end of string *)
            ELSIF code > ORD(blank) THEN
                Str.Append(arg,ch);
            ELSE
                Str.Append(arg,blank);    (* remove TAB and controls if any *)
            END;
        END;
        INC(cliPos);
    END;
    Str.Copy(argument,arg);
END argv;

(* ------------------------------------------------------------ *)

(* [+|-][$|0x]digits *)

(* assume already trimmed and in uppercase *)

PROCEDURE StrToLongInt (S:ARRAY OF CHAR; VAR v : LONGINT) : BOOLEAN;
CONST
    dollar    = "$";
    digits    = "0123456789";
    hexdigits = "ABCDEF"+digits;
VAR
    ok       : BOOLEAN;
    len,base : CARDINAL;
    negative : BOOLEAN;
BEGIN
    len:=Str.Length(S);
    IF len=0 THEN RETURN FALSE; END; (* cannot happen ! *)
    CASE S[0] OF
    | "-": negative:=TRUE;  Str.Delete(S,0,1); DEC(len);
    | "+": negative:=FALSE; Str.Delete(S,0,1); DEC(len);
    ELSE
           negative:=FALSE;
    END;
    IF len=0 THEN RETURN FALSE; END;

    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        IF verify(S,hexdigits)=FALSE THEN RETURN FALSE;END;
        base := 16;
    ELSIF ( (S[0]="0") AND (S[1]="X") ) THEN
        Str.Delete(S,0,2);
        IF verify(S,hexdigits)=FALSE THEN RETURN FALSE;END;
        base := 16;
    ELSE
        IF verifyString(S,digits)=FALSE THEN RETURN FALSE;END;
        base := 10;
    END;
    v:=Str.StrToInt(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF negative THEN v:=-v; END;
(*
WrLn;
IO.WrLngInt(v,10);WrLn;
IO.WrLngHex( LONGCARD(v),10);WrLn;
WrLn;
*)
    RETURN TRUE;
END StrToLongInt;

(* [$|0x]digits *)

(* assume already trimmed and in uppercase *)

PROCEDURE StrToLongCard (S:ARRAY OF CHAR; VAR v : LONGCARD) : BOOLEAN;
CONST
    dollar    = "$";
    digits    = "0123456789";
    hexdigits = "ABCDEF"+digits;
VAR
    ok       : BOOLEAN;
    len,base : CARDINAL;
BEGIN
    len:=Str.Length(S);
    IF len=0 THEN RETURN FALSE; END; (* cannot happen ! *)

    IF S[0]=dollar THEN
        Str.Delete(S,0,1);
        IF verify(S,hexdigits)=FALSE THEN RETURN FALSE;END;
        base := 16;
    ELSIF ( (S[0]="0") AND (S[1]="X") ) THEN
        Str.Delete(S,0,2);
        IF verify(S,hexdigits)=FALSE THEN RETURN FALSE;END;
        base := 16;
    ELSE
        IF verifyString(S,digits)=FALSE THEN RETURN FALSE;END;
        base := 10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    RETURN TRUE;
END StrToLongCard;

(* ------------------------------------------------------------ *)

(* ripped and adapted from old PC2WIN v1.0a dated 29 Apr 00 *)

TYPE
    chardef   = RECORD
                    Code    : BYTE;
                    Flag    : CHAR;
                    MapChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF chardef;

CONST
    TpcTOwin  = CharTable (
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "!", 0B6H),
    chardef(015H, "!", 0A7H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "?",  " "),
    chardef(080H, "=", 0C7H),
    chardef(081H, "=", 0FCH),
    chardef(082H, "=", 0E9H),
    chardef(083H, "=", 0E2H),
    chardef(084H, "=", 0E4H),
    chardef(085H, "=", 0E0H),
    chardef(086H, "=", 0E5H),
    chardef(087H, "=", 0E7H),
    chardef(088H, "=", 0EAH),
    chardef(089H, "=", 0EBH),
    chardef(08AH, "=", 0E8H),
    chardef(08BH, "=", 0EFH),
    chardef(08CH, "=", 0EEH),
    chardef(08DH, "=", 0ECH),
    chardef(08EH, "=", 0C4H),
    chardef(08FH, "=", 0C5H),
    chardef(090H, "=", 0C9H),
    chardef(091H, "=", 0E6H),
    chardef(092H, "=", 0C6H),
    chardef(093H, "=", 0F4H),
    chardef(094H, "=", 0F6H),
    chardef(095H, "=", 0F2H),
    chardef(096H, "=", 0FBH),
    chardef(097H, "=", 0F9H),
    chardef(098H, "=", 0FFH),
    chardef(099H, "=", 0D6H),
    chardef(09AH, "=", 0DCH),
    chardef(09BH, "=", 0A2H),
    chardef(09CH, "=", 0A3H),
    chardef(09DH, "=", 0A5H),
    chardef(09EH, "?",  " "),
    chardef(09FH, "?",  " "),
    chardef(0A0H, "=", 0E1H),
    chardef(0A1H, "=", 0EDH),
    chardef(0A2H, "=", 0F3H),
    chardef(0A3H, "=", 0FAH),
    chardef(0A4H, "=", 0F1H),
    chardef(0A5H, "=", 0D1H),
    chardef(0A6H, "=", 0AAH),
    chardef(0A7H, "=", 0BAH),
    chardef(0A8H, "=", 0BFH),
    chardef(0A9H, "?",  " "),
    chardef(0AAH, "=", 0ACH),
    chardef(0ABH, "=", 0BDH),
    chardef(0ACH, "=", 0BCH),
    chardef(0ADH, "=", 0A1H),
    chardef(0AEH, "=", 0ABH),
    chardef(0AFH, "=", 0BBH),
    chardef(0B0H, "@",  " "),
    chardef(0B1H, "@",  " "),
    chardef(0B2H, "@",  " "),
    chardef(0B3H, "@",  " "),
    chardef(0B4H, "@",  " "),
    chardef(0B5H, "@",  " "),
    chardef(0B6H, "@",  " "),
    chardef(0B7H, "@",  " "),
    chardef(0B8H, "@",  " "),
    chardef(0B9H, "@",  " "),
    chardef(0BAH, "@",  " "),
    chardef(0BBH, "@",  " "),
    chardef(0BCH, "@",  " "),
    chardef(0BDH, "@",  " "),
    chardef(0BEH, "@",  " "),
    chardef(0BFH, "@",  " "),
    chardef(0C0H, "@",  " "),
    chardef(0C1H, "@",  " "),
    chardef(0C2H, "@",  " "),
    chardef(0C3H, "@",  " "),
    chardef(0C4H, "@",  " "),
    chardef(0C5H, "@",  " "),
    chardef(0C6H, "@",  " "),
    chardef(0C7H, "@",  " "),
    chardef(0C8H, "@",  " "),
    chardef(0C9H, "@",  " "),
    chardef(0CAH, "@",  " "),
    chardef(0CBH, "@",  " "),
    chardef(0CCH, "@",  " "),
    chardef(0CDH, "@",  " "),
    chardef(0CEH, "@",  " "),
    chardef(0CFH, "@",  " "),
    chardef(0D0H, "@",  " "),
    chardef(0D1H, "@",  " "),
    chardef(0D2H, "@",  " "),
    chardef(0D3H, "@",  " "),
    chardef(0D4H, "@",  " "),
    chardef(0D5H, "@",  " "),
    chardef(0D6H, "@",  " "),
    chardef(0D7H, "@",  " "),
    chardef(0D8H, "@",  " "),
    chardef(0D9H, "@",  " "),
    chardef(0DAH, "@",  " "),
    chardef(0DBH, "@",  " "),
    chardef(0DCH, "@",  " "),
    chardef(0DDH, "@",  " "),
    chardef(0DEH, "@",  " "),
    chardef(0DFH, "@",  " "),
    chardef(0E0H, "?",  " "),
    chardef(0E1H, "=", 0DFH),
    chardef(0E2H, "?",  " "),
    chardef(0E3H, "?",  " "),
    chardef(0E4H, "?",  " "),
    chardef(0E5H, "?",  " "),
    chardef(0E6H, "=", 0B5H),
    chardef(0E7H, "?",  " "),
    chardef(0E8H, "?",  " "),
    chardef(0E9H, "?",  " "),
    chardef(0EAH, "?",  " "),
    chardef(0EBH, "?",  " "),
    chardef(0ECH, "?",  " "),
    chardef(0EDH, "=", 0D8H),
    chardef(0EEH, "?",  " "),
    chardef(0EFH, "?",  " "),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=", 0B1H),
    chardef(0F2H, "?",  " "),
    chardef(0F3H, "?",  " "),
    chardef(0F4H, "?",  " "),
    chardef(0F5H, "?",  " "),
    chardef(0F6H, "=", 0F7H),
    chardef(0F7H, "?",  " "),
    chardef(0F8H, "=", 0B0H),
    chardef(0F9H, "?",  " "),
    chardef(0FAH, "?",  " "),
    chardef(0FBH, "?",  " "),
    chardef(0FCH, "?",  " "),
    chardef(0FDH, "=", 0B2H),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  " "));

(* ripped and adapted from old WIN2PC v1.0a dated 29 Apr 00 *)

CONST
    TwinTOpc  = CharTable(
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "=", 014H),
    chardef(015H, "=", 015H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "x",  " "),
    chardef(080H, "x",  " "),
    chardef(081H, "x",  " "),
    chardef(082H, "x",  " "),
    chardef(083H, "x",  " "),
    chardef(084H, "x",  " "),
    chardef(085H, "x",  " "),
    chardef(086H, "x",  " "),
    chardef(087H, "x",  " "),
    chardef(088H, "x",  " "),
    chardef(089H, "x",  " "),
    chardef(08AH, "x",  " "),
    chardef(08BH, "x",  " "),
    chardef(08CH, "x",  " "),
    chardef(08DH, "x",  " "),
    chardef(08EH, "x",  " "),
    chardef(08FH, "x",  " "),
    chardef(090H, "x",  " "),
    chardef(091H, "=",  "'"),
    chardef(092H, "=",  "'"),
    chardef(093H, "x",  " "),
    chardef(094H, "x",  " "),
    chardef(095H, "x",  " "),
    chardef(096H, "x",  " "),
    chardef(097H, "x",  " "),
    chardef(098H, "x",  " "),
    chardef(099H, "x",  " "),
    chardef(09AH, "x",  " "),
    chardef(09BH, "x",  " "),
    chardef(09CH, "x",  " "),
    chardef(09DH, "x",  " "),
    chardef(09EH, "x",  " "),
    chardef(09FH, "x",  " "),
    chardef(0A0H, "=",  " "),
    chardef(0A1H, "=",  ""),
    chardef(0A2H, "=",  ""),
    chardef(0A3H, "=",  ""),
    chardef(0A4H, "=",  ""),
    chardef(0A5H, "=",  ""),
    chardef(0A6H, "=",  "|"),
    chardef(0A7H, "!", 015H),
    chardef(0A8H, "?",  " "),
    chardef(0A9H, "!",  ""),
    chardef(0AAH, "=",  ""),
    chardef(0ABH, "=",  ""),
    chardef(0ACH, "=",  ""),
    chardef(0ADH, "=",  "-"),
    chardef(0AEH, "!",  ""),
    chardef(0AFH, "!",  "-"),
    chardef(0B0H, "=",  ""),
    chardef(0B1H, "=",  ""),
    chardef(0B2H, "=",  ""),
    chardef(0B3H, "?",  " "),
    chardef(0B4H, "?",  " "),
    chardef(0B5H, "=",  ""),
    chardef(0B6H, "!", 014H),
    chardef(0B7H, "?",  " "),
    chardef(0B8H, "?",  " "),
    chardef(0B9H, "?",  " "),
    chardef(0BAH, "=",  ""),
    chardef(0BBH, "=",  ""),
    chardef(0BCH, "=",  ""),
    chardef(0BDH, "=",  ""),
    chardef(0BEH, "?",  " "),
    chardef(0BFH, "=",  ""),
    chardef(0C0H, "=",  "A"),
    chardef(0C1H, "=",  "A"),
    chardef(0C2H, "=",  "A"),
    chardef(0C3H, "=",  "A"),
    chardef(0C4H, "=",  ""),
    chardef(0C5H, "=",  ""),
    chardef(0C6H, "=",  ""),
    chardef(0C7H, "=",  ""),
    chardef(0C8H, "=",  "E"),
    chardef(0C9H, "=",  ""),
    chardef(0CAH, "=",  "E"),
    chardef(0CBH, "=",  "E"),
    chardef(0CCH, "=",  "I"),
    chardef(0CDH, "=",  "I"),
    chardef(0CEH, "=",  "I"),
    chardef(0CFH, "=",  "I"),
    chardef(0D0H, "?",  " "),
    chardef(0D1H, "=",  ""),
    chardef(0D2H, "=",  "O"),
    chardef(0D3H, "=",  "O"),
    chardef(0D4H, "=",  "O"),
    chardef(0D5H, "=",  "O"),
    chardef(0D6H, "=",  ""),
    chardef(0D7H, "=",  "X"),
    chardef(0D8H, "=",  "O"),
    chardef(0D9H, "=",  "U"),
    chardef(0DAH, "=",  "U"),
    chardef(0DBH, "=",  "U"),
    chardef(0DCH, "=",  ""),
    chardef(0DDH, "=",  "Y"),
    chardef(0DEH, "?",  " "),
    chardef(0DFH, "=",  ""),
    chardef(0E0H, "=",  ""),
    chardef(0E1H, "=",  ""),
    chardef(0E2H, "=",  ""),
    chardef(0E3H, "=",  "a"),
    chardef(0E4H, "=",  ""),
    chardef(0E5H, "=",  ""),
    chardef(0E6H, "=",  ""),
    chardef(0E7H, "=",  ""),
    chardef(0E8H, "=",  ""),
    chardef(0E9H, "=",  ""),
    chardef(0EAH, "=",  ""),
    chardef(0EBH, "=",  ""),
    chardef(0ECH, "=",  ""),
    chardef(0EDH, "=",  ""),
    chardef(0EEH, "=",  ""),
    chardef(0EFH, "=",  ""),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=",  ""),
    chardef(0F2H, "=",  ""),
    chardef(0F3H, "=",  ""),
    chardef(0F4H, "=",  ""),
    chardef(0F5H, "=",  "o"),
    chardef(0F6H, "=",  ""),
    chardef(0F7H, "=",  ""),
    chardef(0F8H, "=",  "o"),
    chardef(0F9H, "=",  ""),
    chardef(0FAH, "=",  ""),
    chardef(0FBH, "=",  ""),
    chardef(0FCH, "=",  ""),
    chardef(0FDH, "=",  "y"),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  ""));

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* we normally use str16 but we may return a 32 bits binary : let's oversize ! *)

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str80;
VAR
    S:str80;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    IF base=16 THEN Str.Lows(S);END;
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    RETURN S;
END fmtbignum;

PROCEDURE n2str (n,base,wi:CARDINAL;padchar:CHAR):str16;
VAR
    R:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr( LONGCARD(n),R,base,ok );
    WHILE Str.Length(R) < wi DO
        Str.Prepend(R,padchar);
    END;
    IF base=16 THEN Str.Lows(R);Str.Prepend(R,dollar);END;
    RETURN R;
END n2str;

CONST
    ASCIIset = 1;
    OEMset   = 2;

PROCEDURE showset (what,base:CARDINAL);
CONST
    default = FALSE;
    (*%T default *)
    double = doublequote;
    single = quote;
    sep    = ":";
    (*%E *)
    (*%F default  *)
    double = " ";
    single = " ";
    sep    = " "; (* ":" *)
    (*%E  *)
VAR
    i,wi,last,v:CARDINAL;
    S,H:str128;
    V:str16;
    pad:CHAR;
BEGIN
    WrLn;

    CASE base OF
    | 10: wi:=3;pad:=" "; H:="   ";
    | 16: wi:=2;pad:="0"; H:="    ";
    END;
    FOR i:=1 TO base DO
        Str.Append(H," ");
        Str.Append(H,n2str(i-1,base,wi,pad));
    END;
    WrStr(H);WrLn;

    last:= ((255 DIV base)+1)*base;DEC(last);
    FOR i:=0 TO last DO
        IF (i MOD base) = 0 THEN
            Str.Copy(V,n2str(i,base,wi,pad));
            WrStr(V);WrStr(" ");
        END;
        WrStr(sep);
        CASE what OF
        | ASCIIset:
            CASE i OF
            | 0..4,7..0AH, 0DH, 1AH..1BH :
                S:="   ";
            | ORD(doublequote):
                Str.Concat(S,single,CHR(i));Str.Append(S,single);
            ELSE
                IF i > 255 THEN
                    v:=ORD(" ");
                ELSE
                    v:=i;
                END;
                Str.Concat(S,double,CHR(v));Str.Append(S,double);
            END;
        | OEMset:
            v := ORD( CHR(TwinTOpc[i].MapChar) );
            CASE v OF
            | 0..4,7..0AH, 0DH, 1AH..1BH :
                S:="   ";
            | ORD(doublequote) :
                Str.Concat(S,single,CHR(v));Str.Append(S,single);
            ELSE
                Str.Concat(S,double,CHR(v));Str.Append(S,double);
            END;
        END;
        WrStr(S);
        IF (i MOD base) = (base-1) THEN
            WrStr(sep+" ");WrStr(V);WrLn;
        END;
    END;
    WrStr(H);WrLn;
END showset;

PROCEDURE unquote(bothquotes:BOOLEAN ; VAR S:pathtype);
VAR
    len,last,i:CARDINAL;
    ch:CHAR;
    pat:str16;
BEGIN
    IF bothquotes THEN
        last:=2;
    ELSE
        last:=1;
    END;
    i:=1;
    LOOP
        CASE i OF
        | 1: ch:=doublequote;
        | 2: ch:=singlequote;
        END;
        Str.Concat(pat,ch,"*");Str.Append(pat,ch);
        IF Str.Match(S,pat) THEN
            Str.Delete(S,0,1); (* first doublequote *)
            len:=Str.Length(S);
            Str.Delete(S,len-1,1);
            EXIT;
        END;
        INC(i);
        IF i > last THEN EXIT; END;
    END;
END unquote;

PROCEDURE dumpname (show,newstyle,useLFN:BOOLEAN;file:ARRAY OF CHAR );
BEGIN
    IF NOT(show) THEN RETURN; END;
    WrLn;
    IF newstyle THEN WrStr(comment); END;
    WrStr(msgScanningFile);
    IF useLFN THEN WrStr(doublequote);END;
    WrStr(file);
    IF useLFN THEN WrStr(doublequote);END;
    WrLn;
    WrLn;
END dumpname;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    CHKEVERY    = 2048; (* let's call chkEscape every CHKEVERY loop, 256 is NOT enough *)
    firstindex  = 1;
    maxindex    = 128;
    firstlc     = 1; (* we'l use 0 as a flag *)
    maxlc       = 32; (* more than reasonable *)
VAR
    cli : str128; (* yes, it should be a pathtype but command line being limited anyway... *)
    spec,base,file  : pathtype;
    parmcount,i,opt : CARDINAL;
    hexcount  : CARDINAL;
    k,j       : CARDINAL;
    S,R,SORG  : pathtype;
    hexstring : str16;
    hexdata   : str128;
    onlyexact,newstyle,dumpascii,ignorecase,audiowarn:BOOLEAN;
    nicehex,dupfound,verbose,listonly : BOOLEAN;
    charset   : (dos,win,unicode);
    currparm  : CARDINAL;
    useLFN,joker,quotedstr : BOOLEAN;
    alcatraz        : BOOLEAN; (* escape from... *)
    chkrounds       : CARDINAL;
    candy           : str128;
    lastfpos   : LONGCARD;
    exactfpos:LONGCARD;
    cmd     : (work,showASCIIhex,showOEMhex,showASCIIdec,showOEMdec,
              showHexDec,showString);
    lastlc  : CARDINAL;
    lc      : ARRAY[firstlc..maxlc] OF LONGCARD;
    str     : ARRAY[firstlc..maxlc] OF str128;
    matches : LONGCARD;
VAR
    got,ndx : CARDINAL;
    c       : CHAR;
    state   : (waiting,maybe);
    filepos : LONGCARD;
    sVal    : str16;
    fixfpos : LONGINT;
    ptr,anchor  : pFname;
    countFile:CARDINAL;
VAR
    last,chindex,notinset : CARDINAL;
    ch,newch,chFlag,thisquote: CHAR;
    sCharSet  : str16;
    pattern   : ARRAY [firstindex..maxindex] OF CHAR; (* BYTE, in fact ! *)
    jokerflag : ARRAY [firstindex..maxindex] OF BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn;

    getCli(cli);
    parmcount := argc(cli,FALSE);
    IF parmcount = 0 THEN abort(errHelp,""); END;

(*%F FROZEN  *)
WrStr('cli     = "');WrStr(cli);WrStr('"');WrLn;WrLn;
FOR i:=1 TO parmcount DO
    argv(R,cli,i,FALSE);
    WrStr("argv");IO.WrCard(i,3);WrStr(' = "');WrStr(R);WrStr('"');WrLn;
END;
WrLn;
WrLn;
(*%E  *)

    (* default is no jokers *)
    FOR i := firstindex TO maxindex DO
        jokerflag[i] := FALSE;
    END;
    newstyle   := TRUE;
    ignorecase := FALSE;
    dumpascii  := FALSE;
    audiowarn  := FALSE;
    dupfound   := FALSE;
    verbose    := FALSE;
    fixfpos    := 0;
    exactfpos  := 0; (* init useless but... *)
    onlyexact  := FALSE;
    charset    := dos;
    cmd        := work;
    useLFN     := TRUE;
    listonly   := FALSE;
    nicehex    := TRUE;
    lastlc     := firstlc-1;

    i:=1;
    LOOP
        argv(S,cli,i,FALSE);
        Str.Copy(SORG,S);
        UpperCase(S);
        IF isOption(S) THEN
(*%F FROZEN *)
WrStr("opt ");IO.WrCard(i,3);WrStr(' = "');WrStr(S);WrStr('"');WrLn;
(*%E  *)
            opt := GetOptIndex(S, "?"+delim+"H"+delim+"HELP"+delim+
                                  "X"+delim+"OLD"+delim+
                                  "I"+delim+"IGNORECASE"+delim+
                                  "T"+delim+"TEXT"+delim+
                                  "B"+delim+"BEEP"+delim+
                                  "F:"+delim+"FIX:"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "D"+delim+"DUP"+delim+
                                  "W"+delim+
                                  "U"+delim+
                                  "A"+delim+"ASCII"+delim+
                                  "O"+delim+"OEM"+delim+"WINDOWS"+delim+
                                  "AA"+delim+
                                  "OO"+delim+
                                  "E:"+delim+"EXACT:"+delim+
                                  "LFN"+delim+
                                  "N:"+delim+
                                  "L"+delim+"LIST"+delim+
                                  "S:"+delim+"STRING:"+delim+
                                  "C"+delim+"UPPERCASEHEX"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : newstyle   := FALSE;
            | 6,7   : ignorecase := TRUE;
            | 8,9   : dumpascii  := TRUE;
            | 10,11 : audiowarn  := TRUE;
            | 12,13 : GetString(S,R);
                      IF StrToLongInt(R,fixfpos)=FALSE THEN abort(errBadValue,S);END;
                      IF fixfpos > LONGINT(MAX(INTEGER)) THEN abort(errBadRange,S);END;
            | 14,15 : verbose    := TRUE;
            | 16,17 : dupfound   := TRUE;
            | 18    : charset    := win;     sCharSet:="Win16";
            | 19    : charset    := unicode; sCharSet:="Win32";
            | 20,21 : CASE cmd OF
                      | work,showASCIIhex : cmd:=showASCIIhex;
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 22,23,24:CASE cmd OF
                      | work,showOEMhex : cmd:=showOEMhex;
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 25:     CASE cmd OF
                      | work,showASCIIdec : cmd:=showASCIIdec;
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 26:     CASE cmd OF
                      | work,showOEMdec : cmd:=showOEMdec;
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 27,28:  GetString(S,R);
                      IF StrToLongCard(R,exactfpos)=FALSE THEN abort(errBadValue,S);END;
                      onlyexact:=TRUE;
            | 29:     useLFN := FALSE;
            | 30:     CASE cmd OF
                      | work,showHexDec : cmd:=showHexDec;
                          INC(lastlc);
                          IF lastlc > maxlc THEN abort(errTooManyConversions,"");END;
                          GetString(S,R);
                          IF StrToLongCard(R,lc[lastlc])=FALSE THEN abort(errBadValue,S);END;
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 31,32:  listonly:=TRUE;
            | 33,34:  CASE cmd OF
                      | work,showString : cmd:=showString;
                          INC(lastlc);
                          IF lastlc > maxlc THEN abort(errTooManyStrings,"");END;
                          GetString(SORG,R);
                          unquote(TRUE,R);
                          Str.Copy(str[lastlc],R);
                      ELSE
                          abort(errCmdConflict,"");
                      END;
            | 35,36:  nicehex:=FALSE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            Str.Copy(spec,SORG);
            unquote(FALSE,spec); (* in case it's a LFN ! *)
(*%F FROZEN *)
WrStr("spec    = ");WrStr(spec);WrLn;
(*%E *)
            EXIT;
        END;
        INC(i);
        IF i > parmcount THEN
            IF cmd=work THEN abort(errMissingSpec,"");END;
        END;
    END;

    CASE cmd OF
    | work:
        currparm := i+1;
        IF currparm > parmcount THEN abort(errMissingData,"");END;
    | showASCIIhex:
        showset(ASCIIset,16);
    | showOEMhex:
        showset(OEMset,16);
    | showASCIIdec:
        showset(ASCIIset,10);
    | showOEMdec:
        showset(OEMset,10);
    | showHexDec:
        FOR i:=firstlc TO lastlc DO
            Str.Concat(R,fmtbignum(lc[i], 10, 10, " ") , " = $");
            Str.Append(R,fmtbignum(lc[i], 16,  8, "0") );
            Str.Append(R," = %");
            Str.Append(R,fmtbignum(lc[i],  2, 32, "0") );
            WrStr(R);WrLn;
        END;
    | showString:
        FOR i:=firstlc TO lastlc DO
            Str.Copy(R,str[i]);
            WrStr("String  :  "); (* account for dollar *)
            FOR k := 1 TO Str.Length(R) DO
                WrStr(R[k-1]); IF k < Str.Length(R) THEN WrStr(" ");END;
            END;
            WrLn;
            FOR j:=1 TO 2 DO
                CASE j OF
                | 1 : WrStr("DOS");
                | 2 : WrStr("OEM");
                END;
                WrStr(" hex : $");
                FOR k := 1 TO Str.Length(R) DO
                    ch:=R[k-1];
                    CASE j OF
                    | 1 : sVal:=PadHex( nicehex, LONGCARD(ORD(ch)), 2 );
                    | 2 : chindex := ORD(ch);
                          newch := CHAR (TpcTOwin[chindex].MapChar);
                          chFlag:= CHAR (TpcTOwin[chindex].Flag);
                          CASE chFlag OF
                          | "=", "!" : sVal:=PadHex( nicehex, LONGCARD(ORD(newch)), 2 );
                          | "?", "@" : sVal:="??"; (* no match OR graphic *)
                          END;
                    END;
                    WrStr(sVal);
                END;
                WrLn;
            END;
            IF i < lastlc THEN WrLn; END;
        END;
    END;
    IF cmd # work THEN abort(errNone,""); END;

    (* ------------------------------------------------------------ *)
    (* ok, now we're done with aborting commands, let's work        *)
    (* ------------------------------------------------------------ *)

    useLFN := ( useLFN AND w9XsupportLFN() );

    (* now parse data to search for *)

    last:=firstindex-1;
    FOR i := currparm TO parmcount DO
        argv(S, cli, i, FALSE);
(*%F FROZEN  *)
WrStr("data");IO.WrCard(i,3);WrStr(' = "');WrStr(S);WrStr('"');WrLn;
(*%E  *)
        CASE S[0] OF
        | "$" :
            Str.Caps(S); (* avoid possible a..f when only A..F is legal *)
            Str.Delete(S,0,1); (* remove $ *)
            IF verify(S,hexdigitsJoker)=FALSE THEN abort(errBadHex,""); END;
            hexcount:=Str.Length(S);
            IF (hexcount MOD 2) # 0 THEN abort(errBadHexFormat,""); END;
            FOR k := 1 TO (hexcount DIV 2) DO
                Str.Slice(hexstring,S,0,2);
                IF same(hexstring,jokerstring) THEN
                    ch := CHR (0); (* won't be used *)
                    joker:=TRUE;
                ELSE
                    IF getch(hexstring,16,ch)=FALSE THEN
                        abort(errBadHexValue,"");
                    END;
                    joker:=FALSE; (* sometimes redundant... *)
                END;
                INC(last);
                IF ignorecase THEN UpperCase(ch); END;
                pattern[last]   := ch;
                jokerflag[last] := joker;
                Str.Delete(S,0,2);
            END;
        | "0".."9" :
            IF verify(S,decdigits)=FALSE THEN abort(errBadDec,""); END;
            IF getch(S,10,ch)=FALSE THEN abort(errBadDecValue,""); END;
            INC(last);
            IF ignorecase THEN UpperCase(ch); END;
            pattern[last]:=ch;
        ELSE
            CASE S[0] OF
            | doublequote,singlequote:
                thisquote:=S[0];
                Str.Delete(S,0,1); (* remove it *)
                quotedstr:=TRUE;
            ELSE
                quotedstr:=FALSE;
            END;
            k:=Str.Length(S);
            IF k = 0 THEN abort(errBadString,""); END;
            IF quotedstr THEN
                IF S[k-1] # thisquote THEN abort(errUnmatchedQuote,""); END;
                S[k-1]:=CHR(0); (* brutally ignore closing quote *)
            END;
            notinset:=0;
            FOR k := 1 TO Str.Length(S) DO
                INC(last);
                ch := S[k-1];
                IF ignorecase THEN UpperCase(ch); END;
                CASE charset OF
                | dos :
                    pattern[last]:=ch; (* store as is *)
                | win,unicode:
                    chindex := ORD (ch);
                    newch := CHAR (TpcTOwin[chindex].MapChar);
                    chFlag:= CHAR (TpcTOwin[chindex].Flag);
                    CASE chFlag OF
                    | "=" : ;
                    | "?" : INC(notinset); (* no match *)
                    | "@" : INC(notinset); (* graphic *)
                    | "!" : ;
                    END;
                    pattern[last]:=newch;
                    IF charset=unicode THEN
                        INC(last);
                        pattern[last]:=CHR(0);
                    END;
                END;
            END;
            IF notinset # 0 THEN abort(errNotInSet,sCharSet);END;
        END;
    END;

    IF same(spec,".") THEN Str.Copy(spec,"*.*");END;

    initList(anchor);
    countFile:=buildFileList(anchor,useLFN,spec);
    IF countFile=MAX(CARDINAL) THEN abort(errTooManyFiles,"");END; (* errStorage *)
    IF countFile=0 THEN abort(errNotFound,""); END;

    makebase(useLFN,spec, base);

    (* dump search data *)

    hexdata := "";
    WrStr(comment);
    WrStr(msgSearchingHex);
    FOR i:= firstindex TO last DO
        IF jokerflag[i] THEN
            sVal:=jokerstringhex;
            WrStr(" "); (* prefix is in jokerstringhex *)
        ELSE
            sVal:=PadHex( nicehex, LONGCARD(ORD(pattern[i])), 2 );
            WrStr(" $");
        END;
        WrStr(sVal);
        Str.Append(hexdata," ");
        Str.Append(hexdata,sVal);
    END;
    WrLn;
    WrStr(comment);
    WrStr(msgSearchingDec);
    FOR i:= firstindex TO last DO
        IF jokerflag[i] THEN
            sVal:=jokerstringdec;
        ELSE
            sVal:=PadDec( LONGCARD(ORD(pattern[i])), 3 );
        END;
        WrStr(" ");
        WrStr(sVal);
    END;
    WrLn;
    WrStr(comment);
    WrStr(msgSearchingAsc);
    FOR i:= firstindex TO last DO
        WrStr(" ");
        IF jokerflag[i] THEN
            WrStr(jokerstringasc);
        ELSE
            ch:=pattern[i];
            CASE ch OF
            | doublequote:
                WrStr(singlequote);
            ELSE
                WrStr(doublequote);
            END;
            IF ( (ORD(ch) < spacecode) OR (ORD(ch) = 255) ) THEN
                WrStr(gremlin);
            ELSE
                WrStr(ch);
            END;
            CASE ch OF
            | doublequote:
                WrStr(singlequote);
            ELSE
                WrStr(doublequote);
            END;
        END;
    END;
    WrLn;
    WrLn;
    WrStr(comment);
    IF newstyle THEN
        WrStr(msgWarning);
    ELSE
        WrStr(msgWarningOld);
    END;
    WrLn;
    IF ignorecase THEN
        WrLn;
        WrStr(comment); WrStr(msgCaseInsensitive); WrLn;
    END;
    IF fixfpos # 0 THEN
        WrLn;
        WrStr(comment); WrStr(msgFixFpos);
        IF fixfpos > 0 THEN WrStr("+");END;
        IO.WrLngInt(fixfpos,1);
        WrStr(" ($"); IO.WrLngHex(LONGCARD(fixfpos),1);WrStr(")");WrLn;
    END;
    IF onlyexact THEN
        WrLn;
        WrStr(comment); WrStr(msgExactFpos);
        IO.WrLngCard(exactfpos,1);
        WrStr(" ($"); IO.WrLngHex(exactfpos,1);WrStr(")");WrLn;
    END;
    IF listonly THEN
        WrLn;
        WrStr(comment);WrStr(msgListOnly);WrLn;
        WrLn;
    END;

(*%F FROZEN  *)
abort(errNone,"");
(*%E  *)

    ptr:=anchor;
    WHILE ptr # NIL DO
        getStr(file,ptr);
        Str.Prepend(file,base);

        matches:=0;

        dumpname( NOT(listonly),newstyle,useLFN, file);

        lastfpos := fileGetFileSize(useLFN,file); (* always check filesize=0 *)
        IF verbose THEN
            Str.Concat(candy,num2str(i+1),"/");
            Str.Append(candy,num2str(countFile));
            Str.Append(candy," (");
            IF useLFN THEN Str.Append(candy,doublequote);END;
            getStr(R,ptr);
            Str.Append(candy,R);
            IF useLFN THEN Str.Append(candy,doublequote);END;
            Str.Append(candy,") ");
            video(candy,TRUE);
            completed (completedInit, lastfpos);
        END;

        IF lastfpos # 0 THEN (* if length is 0, we'll never find anything, eh eh... *)

            (* ok, search now ! *)

            alcatraz:=FALSE;
            chkrounds:=0;

            hnd:=fileOpenRead(useLFN,file);
            FIO.AssignBuffer(hnd,ioBuffer);

            IF onlyexact THEN
                IF (exactfpos+1) <= lastfpos THEN FIO.Seek(hnd,exactfpos); END;
            END;

            filepos:=FIO.GetPos(hnd);
            state:=waiting;
            LOOP
                (*
                WrStr("ndx = ");IO.WrCard(ndx,8);
                CASE state OF
                | waiting: S:=" -- waiting @ ";
                | maybe:   S:=" -- maybe   @ ";
                END;
                WrStr(S);IO.WrLngHex( FIO.GetPos(hnd), 12);WrLn;
                *)

                IF verbose THEN completed(completedShow,FIO.GetPos(hnd)); END;

                got := FIO.RdBin(hnd,c,1);
                IF got = 0 THEN EXIT; END; (* size was a multiple of iobufferSize *)

                IF ignorecase THEN
                    CASE charset OF
                    | dos :
                        ;
                    | win,unicode:
                        chindex := ORD (c);
                        newch := CHAR (TwinTOpc[chindex].MapChar); (* space for illegal *)
                        c:=newch;
                    END;
                    UpperCase(c);
                END;

                CASE state OF
                | waiting :
                    IF (jokerflag[firstindex] OR (c=pattern[firstindex])) THEN
                        filepos:=FIO.GetPos(hnd)-1; (* we have already past pos now *)
                        IF firstindex=last THEN (* special case ! *)
                            IF verbose THEN
                                completed(completedEnd,0);
                                video(candy,FALSE);
                            END;
                            dumprealdata (matches,  useLFN,file,filepos,last,
                                         newstyle,dumpascii,dupfound,listonly,nicehex,
                                         fixfpos);
                            IF verbose THEN
                                video(candy,TRUE);
                                completed (completedInit, lastfpos);
                            END;
                            IF onlyexact THEN EXIT; END;
                        ELSE
                            ndx   := firstindex+1;
                            state := maybe;
                        END;
                    ELSE
                        IF onlyexact THEN EXIT; END;
                    END;
                | maybe:
                    IF (jokerflag[ndx] OR (c=pattern[ndx])) THEN
                        IF ndx=last THEN
                            IF verbose THEN
                                completed(completedEnd,0);
                                video(candy,FALSE);
                            END;
                            dumprealdata (matches,  useLFN,file,filepos,last,
                                         newstyle,dumpascii,dupfound,listonly,nicehex,
                                         fixfpos);
                            IF verbose THEN
                                video(candy,TRUE);
                                completed (completedInit, lastfpos);
                            END;
                            IF onlyexact THEN EXIT; END;
                            FIO.Seek(hnd,filepos+1); (* restart after first byte which triggered this state *)
                            state := waiting;
                        ELSE
                            INC(ndx);
                        END;
                    ELSE
                        IF onlyexact THEN EXIT; END;
                        FIO.Seek(hnd,filepos+1); (* restart after first byte which triggered this state *)
                        state := waiting;
                    END;
                END;
                INC(chkrounds);
                IF (chkrounds MOD CHKEVERY) = 0 THEN alcatraz:=ChkEscape(); END;
                IF alcatraz THEN EXIT; END;
            END;
            FIO.Close(hnd);
            IF (matches # 0) THEN dumpname(listonly,newstyle,useLFN,file); END;
        END;
        IF verbose THEN
            completed(completedEnd,0);
            video(candy,FALSE);
        END;
        IF alcatraz THEN
            WrLn;
            freeList(anchor);
            abort(errAborted,"");
        END;

        ptr:=ptr^.next;
    END;
    IF audiowarn THEN
        Lib.Sound (100);
        Lib.Delay (50);
        Lib.NoSound;
    END;
    freeList(anchor);
    abort(errNone,"");
END SigFind.


