' author : Matt Pritchard

DEFINT A-Z

    ' ===== SCREEN RESOLUTIONS =====

%Mode320x200 = 0
%Mode320x400 = 1
%Mode360x200 = 2
%Mode360x400 = 3
%Mode320x240 = 4
%Mode320x480 = 5
%Mode360x240 = 6
%Mode360x480 = 7

    ' ===== MODE X SETUP ROUTINES =====

DECLARE FUNCTION SET.VGA.MODEX ALIAS "SET_VGA_MODEX" (BYVAL ModeType, BYVAL MaxXpos, BYVAL MaxYpos, BYVAL Pages)
DECLARE FUNCTION SET.MODEX ALIAS "SET_MODEX" (BYVAL Mode)

    ' ===== BASIC GRAPHICS PRIMITIVES =====

DECLARE SUB CLEAR.VGA.SCREEN ALIAS "CLEAR_VGA_SCREEN" (BYVAL ColorNum)
DECLARE SUB SET.POINT ALIAS "SET_POINT" (BYVAL Xpos, BYVAL Ypos, BYVAL ColorNum)
DECLARE FUNCTION READ.POINT ALIAS "READ_POINT" (BYVAL Xpos, BYVAL Ypos)
DECLARE SUB FILL.BLOCK ALIAS "FILL_BLOCK" (BYVAL Xpos1, BYVAL Ypos1, BYVAL Xpos2, BYVAL Ypos2, BYVAL ColorNum)
DECLARE SUB DRAW.LINE ALIAS "DRAW_LINE" (BYVAL Xpos1, BYVAL Ypos1, BYVAL Xpos2, BYVAL Ypos2, BYVAL ColorNum)

    ' ===== DAC COLOR REGISTER ROUTINES =====

DECLARE SUB SET.DAC.REGISTER ALIAS "SET_DAC_REGISTER" (BYVAL RegNo, BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB GET.DAC.REGISTER ALIAS "GET_DAC_REGISTER" (BYVAL RegNo, Red, Green, Blue)
DECLARE SUB LOAD.DAC.REGISTERS ALIAS "LOAD_DAC_REGISTERS" (SEG PalData AS ANY, BYVAL StartReg, BYVAL EndReg, BYVAL VSync)
DECLARE SUB READ.DAC.REGISTERS ALIAS "READ_DAC_REGISTERS" (SEG PalData AS ANY, BYVAL StartReg, BYVAL EndReg)

    ' ===== PAGE FLIPPING AND SCROLLING ROUTINES =====

DECLARE SUB SET.ACTIVE.PAGE ALIAS "SET_ACTIVE_PAGE" (BYVAL PageNo)
DECLARE FUNCTION GET.ACTIVE.PAGE ALIAS "GET_ACTIVE_PAGE" ()
DECLARE SUB SET.DISPLAY.PAGE ALIAS "SET_DISPLAY_PAGE" (BYVAL PageNo)
DECLARE FUNCTION GET.DISPLAY.PAGE ALIAS "GET_DISPLAY_PAGE" ()
DECLARE SUB SET.WINDOW ALIAS "SET_WINDOW" (BYVAL DisplayPage, BYVAL XOffset, BYVAL YOffset)
DECLARE FUNCTION GET.X.OFFSET ALIAS "GET_X_OFFSET" ()
DECLARE FUNCTION GET.Y.OFFSET ALIAS "GET_Y_OFFSET" ()
DECLARE SUB SYNC.DISPLAY ALIAS "SYNC_DISPLAY" ()

    ' ===== TEXT DISPLAY ROUTINES =====

DECLARE SUB GPRINTC (BYVAL CharacterNum, BYVAL Xpos, BYVAL Ypos, BYVAL ColorF, BYVAL ColorB)
DECLARE SUB TGPRINTC (BYVAL CharacterNum, BYVAL Xpos, BYVAL Ypos, BYVAL ColorF)
DECLARE SUB PRINT.STR ALIAS "PRINT_STR" (BYVAL StrSg, BYVAL StrOfs, BYVAL MaxLen, BYVAL Xpos, BYVAL Ypos, BYVAL ColorF, BYVAL ColorB)
DECLARE SUB TPRINT.STR ALIAS "TPRINT_STR" (BYVAL StrSg, BYVAL StrOfs, BYVAL MaxLen, BYVAL Xpos, BYVAL Ypos, BYVAL ColorF)
DECLARE SUB SET.DISPLAY.FONT ALIAS "SET_DISPLAY_FONT" (SEG FontData AS ANY, BYVAL FontNumber)

    ' ===== BITMAP (SPRITE) DISPLAY ROUTINES =====

DECLARE SUB DRAW.BITMAP ALIAS "DRAW_BITMAP" (SEG Image AS ANY, BYVAL Xpos, BYVAL Ypos, BYVAL xWidth, BYVAL Height)
DECLARE SUB TDRAW.BITMAP ALIAS "TDRAW_BITMAP" (SEG Image AS ANY, BYVAL Xpos, BYVAL Ypos, BYVAL xWidth, BYVAL Height)

    ' ==== VIDEO MEMORY to VIDEO MEMORY COPY ROUTINES =====

DECLARE SUB COPY.PAGE ALIAS "COPY_PAGE" (BYVAL SourcePage, BYVAL DestPage)
DECLARE SUB COPY.BITMAP ALIAS "COPY_BITMAP" (BYVAL SourcePage, BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL DestPage, BYVAL DestX1, BYVAL DestY1)

' ------------------ included UTILS.INC ---------------------


    ' Misc Constants

%True     = -1
%False    = 0
%nil      = 0

    ' Keyboard Codes: Extended

%KyF1     = &H3B00
%KyF2     = &H3C00
%KyF3     = &H3D00
%KyF4     = &H3E00
%KyF5     = &H3F00
%KyF6     = &H4000
%KyF7     = &H4100
%KyF8     = &H4200
%KyF9     = &H4300
%KyF10    = &H4400

%KyUp     = &H4800
%KyLeft   = &H4B00
%KyRight  = &H4D00
%KyDown   = &H5000
%KySLeft  = &HCB00
%KySRight = &HCD00
%KySUp    = &HC800
%KySDown  = &HD000

%KyHome   = &H4700
%KyPgUp   = &H4900
%KyEnd    = &H4F00
%KyPgDn   = &H5100
%KySHome  = &HC700
%KySPgUp  = &HC900
%KySEnd   = &HCF00
%KySPgDn  = &HD100

%KyIns    = &H5200
%KyDel    = &H5300
%KyRvsTab = &H8F00
%KySIns   = &HC200
%KySDel   = &HC300

%KyAltA   = &H1E00
%KyAltB   = &H3000
%KyAltC   = &H2E00
%KyAltD   = &H2000
%KyAltE   = &H1200
%KyAltF   = &H2100
%KyAltG   = &H2200
%KyAltH   = &H2300
%KyAltI   = &H1700
%KyAltJ   = &H2400
%KyAltK   = &H2500
%KyAltL   = &H2600
%KyAltM   = &H3200
%KyAltN   = &H3100
%KyAltO   = &H1800
%KyAltP   = &H1900
%KyAltQ   = &H1000
%KyAltR   = &H1300
%KyAltS   = &H1F00
%KyAltT   = &H1400
%KyAltU   = &H1600
%KyAltV   = &H2F00
%KyAltW   = &H1100
%KyAltX   = &H2D00
%KyAltY   = &H1500
%KyAltZ   = &H2C00

	' Keyboard Codes: Ascii

%KyBS     = 8
%KyTab    = 9
%KyCR     = 13
%KyESC    = &H1B
%KyClr    = &H7F
%KyPlus   = 45
%KyMinus  = 43

	' Color Constants

%c.BLACK  = 0
%c.BLUE   = 1
%c.GREEN  = 2
%c.CYAN   = 3
%c.RED    = 4
%c.PURPLE = 5
%c.BROWN  = 6
%c.WHITE  = 7
%c.GREY   = 8
%c.bBLUE  = 9
%c.bGREEN = 10
%c.bCYAN  = 11
%c.bRED   = 12
%c.bPURPLE = 13
%c.YELLOW = 14
%c.bWHITE = 15
%c.BRIGHT = 8

	' From UTILS.ASM

DECLARE SUB SET.VIDEO.MODE ALIAS "SET_VIDEO_MODE" (BYVAL Mode%)
DECLARE FUNCTION SCAN.KEYBOARD% ALIAS "SCAN_KEYBOARD" ()
DECLARE FUNCTION RANDOM.INT ALIAS "RANDOM_INT" (BYVAL MaxInt%)
DECLARE SUB INIT.RANDOM ALIAS "INIT_RANDOM" ()
DECLARE FUNCTION TIMER.COUNT& ALIAS "TIMER_COUNT" ()
DECLARE FUNCTION INT.SQR ALIAS "INT_SQR" (BYVAL X%, BYVAL Rownd%)



