(* ---------------------------------------------------------------
Title         Q&D Check Stamp
Overview      see help
Usage         see help
Notes
Bugs
Wish List     qd_file should have a isFileSystemLFN() avoiding call to qd_lfn

--------------------------------------------------------------- *)

MODULE chkStamp;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

(* ------------------------------------------------------------ *)

CONST
    nl          = CHR(13)+CHR(10);
    dquote      = '"';
    dash        = "-";
    colon       = ":";
    blank       = " ";
CONST
    placeholder1    = "$";
    placeholder2    = "^";
    opolder         = 0;  msgOlder        = "$ is older than ^";
    opolderorsame   = 1;  msgOlderOrSame  = "$ is older than or same as ^";
    opnewer         = 2;  msgNewer        = "$ is newer than ^";
    opnewerorsame   = 3;  msgNewerOrSame  = "$ is newer than or same as ^";
    opsame          = 4;  msgSame         = "$ is same as ^";

CONST
    errHelp         = 0;
    errOption       = 1;
    errParmExpected = 2;
    errParmOverflow = 3;
    errJoker        = 4;
    errDir          = 5;
    errCondition    = 6;
    errNotFound     = 7;

    errFalse        = 128; sfalse = "128";
    errTrue         = 255; strue  = "255";

CONST
    exe         = "CHKSTAMP";
    title       = "Q&D Check Date/Time stamp";
    version     = "1.0";
    author      = "by PhG";
    msgHelp     =
title+" "+version+" "+author+nl+
nl+
"Syntax : "+exe+" <spec1> <condition> <spec2> [-lfn] [-verbose]"+nl+
nl+
"<condition> is any of these forms :"+nl+
"OLDER[ORSAME[STAMP]], NEWER[ORSAME[STAMP]], SAME[STAMP][OROLDER|ORNEWER]."+nl+
"Program returns "+strue+" if <condition> is true, "+sfalse+" if <condition> is false"+nl+
"(all other codes are below 128).";

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    IF same(S,"")=FALSE THEN WrStr(S);WrLn;END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;


(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE booltostr ( tf:BOOLEAN ):str16;
VAR
    R:str16;
BEGIN
    IF tf THEN
        R:="TRUE"
    ELSE
        R:="FALSE";
    END;
    RETURN R;
END booltostr;

PROCEDURE enquote (VAR S:ARRAY OF CHAR );
BEGIN
    Str.Prepend(S,dquote);
    Str.Append(S,dquote);
END enquote;

(* ------------------------------------------------------------ *)

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=minyy+127; (* was 2099 *)
    baseyear=minyy;  (* 1980 *)

PROCEDURE UnpackDMY (dmy:CARDINAL;VAR d,m,y:CARDINAL);
BEGIN
    y := CARDINAL(BITSET(dmy) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(dmy) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(dmy) * ddMask) >> ddShft;
    INC(y,baseyear);
END UnpackDMY;

CONST
    dateplain = 0; (* dd-MMM-yyyy *)
    datestd   = 1; (* dd-mm-yyyy *)
    daterev   = 2; (* yyyy-mm-dd *)

PROCEDURE fmtDate (dmy:CARDINAL;datefmt:CARDINAL) : str16;
CONST
    tokday    = "~";
    tokmonth  = "@";
    tokmois   = "$";
    tokyear   = "!";
    separator = dash;
    pad       = "0";
    baseyear  = 1900;
    tmonths   = "Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2  = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R,S: str16;
    d,m,y:CARDINAL;
BEGIN
    UnpackDMY(dmy,d,m,y);
    IF ((m < minmm) OR (m > maxmm)) THEN m := 13; END;
    S:="";
    CASE datefmt OF
    | dateplain: R:=tokday +separator+tokmois +separator+tokyear;
                 Str.ItemS(S,tmonths2," ",m-1);
    | datestd:   R:=tokday +separator+tokmonth+separator+tokyear;
    | daterev:   R:=tokyear+separator+tokmonth+separator+tokday;
    ELSE
                 R:="??"+separator+"???"+separator+"????";
    END;
    Str.Subst(R,tokday   ,   using(d,2,pad));
    Str.Subst(R,tokmonth ,   using(m,2,pad));
    Str.Subst(R,tokyear  ,   using(y,4,pad));
    Str.Subst(R,tokmois  ,   S);

    RETURN R;
END fmtDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    timelong     = 0;
    timestd      = 1;
    timelongzero = 2;
    timestdzero  = 3;

PROCEDURE fmtTime (timedata:CARDINAL;timefmt:CARDINAL) : str16;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    tokhh     = "~";
    tokmm     = "@";
    tokss     = "$";
    tokHZ     = "!";
    separator = colon;
    padhours  = blank;
    pad       = "0";
VAR
    h,m,s : CARDINAL;
    R : str16;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* FIXED ! yes, yes, "* 2" works too... *)

    CASE timefmt OF
    | timelong    : R:=tokhh+separator+tokmm+separator+tokss;
    | timestd     : R:=tokhh+separator+tokmm;
    | timelongzero: R:=tokHZ+separator+tokmm+separator+tokss;
    | timestdzero : R:=tokHZ+separator+tokmm;
    ELSE
                 R:="??"+separator+"??"+separator+"??";
    END;

    Str.Subst(R, tokhh, using(h,2,padhours) );
    Str.Subst(R, tokmm, using(m,2,pad));
    Str.Subst(R, tokss, using(s,2,pad));
    Str.Subst(R, tokHZ, using(h,2,pad) );

    RETURN R;
END fmtTime;

(* ------------------------------------------------------------ *)

PROCEDURE fmtjma (jma:CARDINAL):str16;
BEGIN
    RETURN fmtDate(jma,dateplain);
END fmtjma;

PROCEDURE fmthms (hms:CARDINAL):str16;
BEGIN
    RETURN fmtTime(hms,timelongzero);
END fmthms;

PROCEDURE fmtdt (stamp:LONGCARD):str80;
VAR
    jma,hms:CARDINAL;
    R:str80;
BEGIN
    R:="jj-mm-aaaa hh:mm:ss";
    jma:=CARDINAL ( stamp >> 16 );
    hms:=CARDINAL ( stamp AND 0000FFFFH );
    Str.Concat(R,fmtjma(jma)," -- ");
    Str.Append(R,fmthms(hms));
    RETURN R;
END fmtdt;

PROCEDURE eval (useLFN,verbose:BOOLEAN;opcode,codeTrue,codeFalse:CARDINAL;spec1,spec2:pathtype):CARDINAL;
VAR
    isdir1,isdir2,tf:BOOLEAN;
    stamp1,stamp2:LONGCARD;
    msg:str1024; (* safety *)
    rc:CARDINAL;
BEGIN
    isdir1:=fileIsDirectorySpec(useLFN,spec1);
    IF isdir1 THEN unfixDirectory(spec1);END;
    isdir2:=fileIsDirectorySpec(useLFN,spec2);
    IF isdir2 THEN unfixDirectory(spec2);END;

    stamp1:=fileGetFileStamp(useLFN,spec1);
    stamp2:=fileGetFileStamp(useLFN,spec2);

    CASE opcode OF
    | opolder:        tf:=(stamp1 <  stamp2); msg:=msgOlder;
    | opolderorsame:  tf:=(stamp1 <= stamp2); msg:=msgOlderOrSame;
    | opnewer:        tf:=(stamp1 >  stamp2); msg:=msgNewer;
    | opnewerorsame:  tf:=(stamp1 >= stamp2); msg:=msgNewerOrSame;
    | opsame:         tf:=(stamp1 =  stamp2);  msg:=msgSame;
    END;
    IF tf THEN
        rc:=codeTrue;
    ELSE
        rc:=codeFalse;
    END;

    IF isdir1 THEN fixDirectory(spec1);END;
    IF isdir2 THEN fixDirectory(spec2);END;

    IF useLFN THEN
        enquote(spec1);
        enquote(spec2);
    END;

    Str.Subst(msg,placeholder1,spec1);
    Str.Subst(msg,placeholder2,spec2);

    IF verbose THEN
        WrStr("spec1       : ");WrStr(spec1);WrLn;
        WrStr("spec2       : ");WrStr(spec2);WrLn;
        WrStr("stamp1      : ");WrStr(fmtdt(stamp1));WrLn;
        WrStr("stamp2      : ");WrStr(fmtdt(stamp2));WrLn;
        WrStr("condition   : ");WrStr(msg);WrLn;
        WrStr("evaluation  : ");WrStr(booltostr(tf));WrLn;
        WrStr("return code : ");WrStr(using(rc,1,""));
        WrLn;
    END;

    RETURN rc;
END eval;

(* ------------------------------------------------------------ *)

CONST
    minparm = 1;
    maxparm = 3;
VAR
    parm : ARRAY[minparm..maxparm] OF pathtype;
    S,R,spec1,spec2:pathtype;
    verbose,useLFN:BOOLEAN;
    lastparm,opt,i,parmcount:CARDINAL;
    rc,opcode :CARDINAL;
BEGIN
    WrLn;

    verbose   := FALSE;
    useLFN    := TRUE;
    lastparm  := minparm-1;

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "L"+delim+"LFN"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,msgHelp);
            | 4,5     : verbose  := TRUE;
            | 6,7     : useLFN   := FALSE;
            ELSE
                abort(errOption,"Unknown option !");
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParmOverflow,"Too many parameters !");END;
            Str.Copy( parm[lastparm] , S);
        END;
    END;
    CASE lastparm OF
    | 0 : abort(errHelp,msgHelp);
    | 1 : abort(errParmExpected,"Expecting <condition> <file2> !");
    | 2 : abort(errParmExpected,"Expecting <file2> !");
    | 3 : (* ok *)
    ELSE
        ; (* trapped supra *)
    END;

    spec1 :=parm[1];
    IF chkJoker(spec1) THEN abort(errJoker,"<spec1> cannot contain any joker !"); END;
    IF fileExists(useLFN,spec1)=FALSE THEN abort(errNotFound,"<spec1> does not exist !");END;
    spec2 :=parm[3];
    IF chkJoker(spec2) THEN abort(errJoker,"<spec2> cannot contain any joker !"); END;
    IF fileExists(useLFN,spec2)=FALSE THEN abort(errNotFound,"<spec2> does not exist !");END;

    Str.Concat(R,dash,parm[2]);
    UpperCase(R);
    i :=GetOptIndex(R, "OLDER"+delim+
                       "OLDERORSAME"+delim+"SAMEOROLDER"+delim+
                       "OLDERORSAMESTAMP"+delim+"SAMESTAMPOROLDER"+delim+
                       "NEWER"+delim+
                       "NEWERORSAME"+delim+"SAMEORNEWER"+delim+
                       "NEWERORSAMESTAMP"+delim+"SAMESTAMPORNEWER"+delim+
                       "SAME"+delim+"SAMESTAMP");
    CASE i OF
    | 1     : opcode := opolder;
    | 2,3   : opcode := opolderorsame;
    | 4,5   : opcode := opolderorsame;
    | 6     : opcode := opnewer;
    | 7,8   : opcode := opnewerorsame;
    | 9,10  : opcode := opnewerorsame;
    | 11,12 : opcode := opsame;
    ELSE
        abort(errCondition,"Illegal <condition> !");
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );

    rc := eval(useLFN,verbose,opcode,errTrue,errFalse,spec1,spec2);

    abort(rc,"");
END chkStamp.
