
(* ---------------------------------------------------------------
Title         Q&D Characters Count
Overview
Usage         see help
Notes
Bugs
Wish List     ignore also graphics and the like?

--------------------------------------------------------------- *)

MODULE cCount;

IMPORT IO;
IMPORT Lib;
IMPORT Str;
IMPORT FIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, cleantabs;

(* ------------------------------------------------------------ *)

CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    quote       = '"';
    tab         = CHR(9);
    dot         = ".";
    comma       = ",";
    space       = " ";
    star        = "*";
    stardotstar = star+dot+star;
    backslash   = "\";
    blank       = ORD(space); (* yes, we use character value here *)
    firstcode   = 0;
    maxcode     = 255;

(* ------------------------------------------------------------ *)

CONST
    progEXEname   = "CCOUNT";
    progTitle     = "Q&D Character Counter";
    progVersion   = "v1.0g";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone          = 0;
    errHelp          = 1;
    errUnknownOption = 2;
    errTooManyParms  = 3;
    errMissingSpec   = 4;
    errTooManyMatches= 5;
    errNoMatch       = 6;
    errNonsense      = 7;
    errNonsenseVal   = 8;
    errBadNumber     = 9;
    errBarWidthRange = 10;

PROCEDURE abort (e : CARDINAL; einfo:ARRAY OF CHAR);
CONST
(*
 0        1         2         3         4         5         6         7         8
 12345678901234567890123456789012345678901234567890123456789012345678901234567890
*)
    msgHelp =
banner+nl+
nl+
"Syntax : "+progEXEname+" <file(s)> [option]..."+nl+
nl+
"This program counts bytes used in a file."+nl+
nl+
"-a    show data for all bytes (no restriction to only bytes appearing in file)"+nl+
"-p    add percentage to byte count"+nl+
"-c    compute percentages excluding control characters ([00..31]) from total"+nl+
"-s    sort from higher to lower byte count"+nl+
"-r    sort from lower to higher byte count"+nl+
"-x    prefix each character with its hexadecimal value"+nl+
"-d    prefix each character with its decimal value"+nl+
"-t    terse report (without header)"+nl+
"-g[g] show global cumulative data (-gg = global only)"+nl+
"-b[b] show bar graph (-bb = no semigraphics)"+nl+
"-w:#  bar graph width (default is 25 characters)"+nl+
"-e    eye candy"+nl+
nl+
"Example : "+progEXEname+" *.t -a"+nl;

VAR
    S : str256; (* oversized *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errUnknownOption :
        Str.Concat(S,"Unknown "+quote,einfo);
        Str.Append(S,quote+" option !");
    | errTooManyParms:
        Str.Concat(S,"Useless "+quote,einfo);
        Str.Append(S,quote+" parameter !");
    | errMissingSpec:
        S := "Missing <file(s)> specification !";
    | errTooManyMatches:
        Str.Concat(S,"Too many files match "+quote,einfo);
        Str.Append(S,quote+" specification !");
    | errNoMatch:
        Str.Concat(S,"No file matches "+quote,einfo);
        Str.Append(S,quote+" specification !");
    | errNonsense:
        S := "-s and -r options are mutually exclusive !";
    | errNonsenseVal:
        S := "-x and -d options are mutually exclusive !";
    | errBadNumber:
        Str.Concat(S,"Illegal number in ",einfo);
        Str.Append(S," parameter !");
    | errBarWidthRange:
        S := "Bar graph width should belong to the [1..200] range !";
    ELSE
        S := "How did you get THERE ? This is illogical, Captain ! ;-)";
    END;
    CASE e OF
    | errNone, errHelp:
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fmtlc (v : LONGCARD; pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtlc;

PROCEDURE fmtstring (S:ARRAY OF CHAR; pad:CHAR; n:INTEGER ) : str80;
VAR
    R : str80;
BEGIN
    Str.Copy(R,S);
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(n) THEN EXIT; END;
        IF n < 0 THEN
            Str.Append(R,pad); (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtstring;

PROCEDURE fmtpercent (v:LONGREAL;pad:CHAR;sep:CHAR;prec:CARDINAL;field:INTEGER):str80;
VAR
    R : str80;
    ok: BOOLEAN;
BEGIN
    Str.FixRealToStr(v,prec,R,ok);
    Str.Subst(R,dot,sep);
    RETURN fmtstring(R,pad,field);
END fmtpercent;

PROCEDURE fmtbar (percentused:LONGREAL;used,free:CHAR;field:CARDINAL):str80;
VAR
    R : str80;
    p,i : CARDINAL;
BEGIN
    percentused := (percentused / 100.0 ) * LONGREAL(field);
    p := CARDINAL(percentused + 0.5); (* round ! *)
    R := "";
    FOR i := 1 TO field DO
        IF i <= p THEN
           Str.Append(R,used);
        ELSE
           Str.Append(R,free);
        END;
    END;
    RETURN R;
END fmtbar;

(* ------------------------------------------------------------ *)

CONST
    IObufferSize = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = IObufferSize;
VAR
    ioBuffer : ARRAY [1..IObufferSize] OF BYTE;

(* ------------------------------------------------------------ *)

PROCEDURE WriteCharacter ( i : CARDINAL );
CONST
    hexdigits = "0123456789abcdef";
VAR
    ok : BOOLEAN;
BEGIN
    CASE i OF
    | 0..31, 127, 255 :
       WrStr("$");
       WrStr(hexdigits[i DIV 16]); (* assume $00..$FF range, of course ! *)
       WrStr(hexdigits[i MOD 16]);
    | ORD(quote):
       WrStr( "'" + '"' + "'");
    ELSE
       WrStr(quote);
       IO.WrChar( CHR(i) );
       WrStr(quote);
    END;
END WriteCharacter;

PROCEDURE showbargraph (semigraphics:BOOLEAN;wi:CARDINAL;count,maxcount:LONGCARD  );
CONST
    chUsed = CHR(219);  chUsedTxt = "+";
    chFree = CHR(176);  chFreeTxt = "-";
VAR
    v      : LONGREAL;
    charUsed,charFree:CHAR;
BEGIN
    IF semigraphics THEN
        charUsed := chUsed ;     charFree := chFree;
    ELSE
        charUsed := chUsedTxt ;  charFree := chFreeTxt;
    END;
    v := ( LONGREAL(count) / LONGREAL(maxcount) ) * 100.0;
    WrStr(fmtbar(v,charUsed,charFree,wi));
END showbargraph;

PROCEDURE wrval (i:CARDINAL;hex:BOOLEAN);
CONST
    digits    = "0123456789";
    hexdigits = digits+"abcdef";
BEGIN
    IF hex THEN
        WrStr("$");
        WrStr(hexdigits[i DIV 16]); (* assume $00..$FF range, of course ! *)
        WrStr(hexdigits[i MOD 16]);
    ELSE
        WrStr(digits[i DIV 100]);
        WrStr(digits[ (i MOD 100) DIV 10 ]);
        WrStr(digits[i MOD  10]);
    END;
END wrval;

(* ------------------------------------------------------------ *)

(* ugly globerks ! *)

VAR
    code      ,gcode      : ARRAY [firstcode..maxcode] OF CARDINAL;
    count     ,gcount     : ARRAY [firstcode..maxcode] OF LONGCARD;
    total     ,gtotal     : LONGCARD;
    ctrlchars ,gctrlchars : LONGCARD;
    filesize  ,gfilesize  : LONGCARD;
CONST
    wi            = (11+3);
    msgRem        = ";";
    msgFile       = msgRem+" File       : ";
    msgBytes      = msgRem+" Bytes read : ";
    msgTotal      = msgRem+" Total      : ";
    msgCtrl       = msgRem+" [00..31]   : ";
    msgRestricted = msgRem+" Show data only for bytes appearing in file";
    msgAll        = msgRem+" Show data for all bytes";
    msgNoCtrl     = msgRem+" Percentages computed excluding [00..31] from bytes read";
    msgWithCtrl   = msgRem+" Percentages computed using all bytes read";
    msgWarning    = msgRem+" Warning ! As total equals 0, percentages will NOT be computed !";

PROCEDURE process ( path:ARRAY OF CHAR;
                    excludecontrol,eyecandy,showglobal:BOOLEAN;
                    VAR filesize,total,ctrlchars:LONGCARD);
VAR
    hnd    : FIO.File;
    prompt : str128;
    i,got  : CARDINAL;
    ch     : BYTE;
BEGIN
    total     := 0;
    ctrlchars := 0;
    filesize  := getFileSize(path);
    IF filesize = 0 THEN RETURN; END;

    FOR i := firstcode TO maxcode DO
        count[i]:=0;
    END;

    Str.Concat(prompt,"Processing ",path);Str.Append(prompt," ");
    video(prompt,TRUE);
    IF eyecandy THEN Work(cmdInit);END;
    hnd:=FIO.OpenRead(path);
    FIO.AssignBuffer(hnd,ioBuffer);
    FIO.EOF:=TRUE; (* safety ! *)
    LOOP
        IF eyecandy THEN Work(cmdShow);END;
        got := FIO.RdBin(hnd,ch,1);
        IF got = 0 THEN EXIT; END;
        INC( count[CARDINAL(ch)] ); (* could use ORD(ch) if CHAR TYPE *)
        IF showglobal THEN
            INC( gcount[CARDINAL(ch)] );
        END;
    END;
    FIO.Close(hnd);
    IF eyecandy THEN Work(cmdStop);END;

    FOR i := firstcode TO (blank-1) DO
        INC(ctrlchars,count[i]);
        IF showglobal THEN INC(gctrlchars,count[i]); END;
    END;
    IF excludecontrol THEN
        total := filesize-ctrlchars;
    ELSE
        total := filesize;
    END;
    IF showglobal THEN INC(gtotal,total); INC(gfilesize,filesize); END;
    video(prompt,FALSE);
END process;

PROCEDURE dump (path:ARRAY OF CHAR;restricted,percentage,excludecontrol,
                hexval,decval,sort,reversesort,eyecandy,
                showheader,showglobal,showbar,semigraphics:BOOLEAN;
                filesize,total,ctrlchars:LONGCARD;barwi:CARDINAL);
VAR
    i : CARDINAL;
    exchange,test,dmpall : BOOLEAN;
    ln1,ln2:LONGCARD;
    n1,n2:CARDINAL;
    v : LONGREAL;
    S : str16;
    (* alphanum,symbols,graphics,others:LONGCARD; *)
BEGIN
    IF showheader THEN
        WrStr(msgFile);WrStr(path);WrLn;
        WrStr(msgBytes);WrStr(fmtlc(filesize,space,dot,wi));WrLn;
        WrStr(msgTotal);WrStr(fmtlc(total,space,dot,wi));WrLn;
        WrStr(msgCtrl);WrStr(fmtlc(ctrlchars,space,dot,wi));WrLn;
        WrStr(msgRem);WrLn;
        IF restricted THEN
            WrStr(msgRestricted);
        ELSE
            WrStr(msgAll);
        END;
        WrLn;
        IF percentage THEN
            IF excludecontrol THEN
                WrStr(msgNoCtrl);
            ELSE
                WrStr(msgWithCtrl);
            END;
            WrLn;
            IF total=0 THEN
                WrStr(msgWarning);WrLn;
                percentage := FALSE;
            END;
        END;
        WrLn;
    END;

    FOR i := firstcode TO maxcode DO
        code [i]:=i;
    END;

    IF (sort OR reversesort) THEN
        IF eyecandy THEN Animation(cmdInit);END;
        exchange := TRUE;
        WHILE exchange DO
            IF eyecandy THEN Animation(cmdShow);END;
            exchange := FALSE;
            FOR i := firstcode TO maxcode-1 DO
                ln1 := count[i];
                ln2 := count[i+1];
                IF sort THEN
                    test := (ln1 < ln2);  (* keep A, B, C,... sequence *)
                ELSIF reversesort THEN
                    test := (ln2 < ln1); (* <= instead of < forces A, B, C,... sequence, but would provoke an infinite loop *)
                END;
                IF test THEN
                    count[i]   := ln2;
                    count[i+1] := ln1;
                    n1         := code[i];
                    n2         := code[i+1];
                    code[i]    := n2;
                    code[i+1]  := n1;
                    exchange   := TRUE;
                END;
            END;
        END;
        IF eyecandy THEN Animation(cmdStop);END;
    END;

    dmpall := NOT(restricted);
    FOR i := firstcode TO maxcode DO
        IF ( dmpall OR (count[i] # 0) ) THEN

            IF hexval THEN wrval(ORD(code[i]),TRUE); WrStr(tab); END;
            IF decval THEN wrval(ORD(code[i]),FALSE);WrStr(tab); END;

            WriteCharacter(code[i]);
            WrStr(tab);
            IO.WrLngCard(count[i],11);
            IF percentage THEN
                WrStr(tab);
                v := ( LONGREAL(count[i]) / LONGREAL(total) ) * 100.0;
                Str.Concat(S, fmtpercent(v,space,comma,2, 6) , "%");
                IF excludecontrol THEN
                    CASE i OF
                    | 0..31 : S := "nonsense";
                    END;
                END;
                WrStr(S);
            END;
            IF showbar THEN
                WrStr(tab);
                showbargraph (semigraphics, barwi, count[i],total);
            END;
            WrLn;
        END;
    END;
END dump;

(* ------------------------------------------------------------ *)

CONST
    firstfile = 1;
    maxfile   = 1000;
VAR
    filename  : ARRAY [firstfile..maxfile] OF str16;
    lastfile  : CARDINAL;

PROCEDURE readMatching(spec:ARRAY OF CHAR;VAR lastfile:CARDINAL);
VAR
    found : BOOLEAN;
    entry : FIO.DirEntry;
BEGIN
    lastfile := firstfile-1;
    found := FIO.ReadFirstEntry(spec,allfiles,entry);
    WHILE found DO
        INC(lastfile);
        IF lastfile > maxfile THEN RETURN;END;
        Str.Copy(filename[lastfile],entry.Name);
        found := FIO.ReadNextEntry(entry);
    END;
END readMatching;

(* fix common cases  : "." -- "*\" -- "\*.*" *)

PROCEDURE fixdirspec (VAR R : ARRAY OF CHAR  );
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(R);
    IF len = 0 THEN RETURN; END; (* no risk ! *)
    IF same(R,dot) THEN Str.Copy(R,stardotstar); RETURN; END;        (* "." becomes "*.*" *)
    IF R[len-1]=backslash THEN Str.Append(R,stardotstar);RETURN;END; (* "*\" becomes "*\*.*" *)
END fixdirspec;

PROCEDURE buildbase (spec:ARRAY OF CHAR;VAR base:ARRAY OF CHAR);
VAR
    u,d,f8,e3 : str128; (* oversized just in CASE -- e3 include dot ! *)
BEGIN
    Lib.SplitAllPath(spec,u,d,f8,e3);
    Lib.MakeAllPath(base,u,d,"","");
    UpperCase(base);
END buildbase;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultBarWidth = 25;
    minBarWidth     = 1;
    maxBarWidth     = 200;
VAR
    restricted,percentage,excludecontrol,sort,reversesort,semigraphics : BOOLEAN;
    eyecandy,hexval,decval,showheader,showglobal,showall,showbar : BOOLEAN;
    barwi:CARDINAL;
VAR
    parmcount : CARDINAL;
    i,opt     : CARDINAL;
    S,R       : str128;
    status    : (waiting,gotspec);
    spec,base,path : str128;
    lc:LONGCARD;
BEGIN
    FIO.IOcheck := FALSE;
    WrLn; (* yes, here now for help, errors, etc. *)

    restricted     := TRUE;
    percentage     := FALSE;
    excludecontrol := FALSE;
    sort           := FALSE;
    reversesort    := FALSE;
    eyecandy       := FALSE;
    hexval         := FALSE;
    decval         := FALSE;
    showheader     := TRUE;
    showglobal     := FALSE;
    showall        := TRUE;
    showbar        := FALSE;
    semigraphics   := TRUE;
    barwi          := defaultBarWidth;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    status:=waiting;
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "A"+delim+"ALL"+delim+
                                  "P"+delim+"PERCENTAGE"+delim+
                                  "C"+delim+"CONTROL"+delim+
                                  "E"+delim+"EYECANDY"+delim+
                                  "S"+delim+"SORT"+delim+
                                  "R"+delim+"REVERSE"+delim+
                                  "X"+delim+"HEX"+delim+
                                  "D"+delim+"DEC"+delim+
                                  "T"+delim+"TERSE"+delim+
                                  "G"+delim+"GLOBAL"+delim+
                                  "GG"+delim+
                                  "B"+delim+"BARGRAPH"+delim+
                                  "BB"+delim+
                                  "W:"+delim+"WIDTH:"
                              );
            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5:      restricted     := FALSE;
            | 6,7:      percentage     := TRUE;
            | 8,9:      excludecontrol := TRUE;
            | 10,11:    eyecandy       := TRUE;
            | 12,13:    sort           := TRUE;
            | 14,15:    reversesort    := TRUE;
            | 16,17:    hexval         := TRUE;
            | 18,19:    decval         := TRUE;
            | 20,21:    showheader     := FALSE;
            | 22,23:    showglobal     := TRUE;
            | 24:       showglobal     := TRUE; showall:=FALSE;
            | 25,26:    showbar        := TRUE;
            | 27:       showbar        := TRUE; semigraphics:=FALSE;
            | 28,29:    IF GetLongCard(S,lc)=FALSE THEN abort(errBadNumber,S);END;
                        IF (lc < LONGCARD(minBarWidth)) OR (lc > LONGCARD(maxBarWidth)) THEN
                            abort(errBarWidthRange,"");
                        END;
                        barwi:=CARDINAL(lc);
            ELSE
                abort(errUnknownOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE status OF
            | waiting : Str.Copy(spec,S);
            | gotspec : abort(errTooManyParms,S);
            END;
            INC (status);
        END;
    END;
    IF status=waiting THEN abort(errMissingSpec,"");END;
    IF (sort AND reversesort) THEN abort(errNonsense,"");END;
    IF (hexval AND decval) THEN abort(errNonsenseVal,"");END;

    fixdirspec(spec);
    readMatching(spec,lastfile);
    IF lastfile > maxfile THEN abort(errTooManyMatches,spec);END;
    IF lastfile < firstfile THEN abort(errNoMatch,spec);END;
    buildbase(spec,base);

    IF showheader THEN
        WrStr(msgRem+" "+banner);WrLn;
        WrLn;
    END;

    IF showglobal THEN
        FOR i:=firstcode TO maxcode DO
            gcount[i]:=0;
        END;
        gtotal     :=0;
        gctrlchars :=0;
        gfilesize  :=0;
    END;

    FOR i := firstfile TO lastfile DO
        Str.Concat(path,base,filename[i]);
        process (path,excludecontrol,eyecandy,showglobal,
                filesize,total,ctrlchars);
        IF showall THEN
            IF filesize # 0 THEN
                IF i # firstfile THEN WrLn; END;
                dump (path,restricted,percentage,excludecontrol,
                     hexval,decval,sort,reversesort,
                     eyecandy,showheader,showglobal,showbar,semigraphics,
                         filesize,total,ctrlchars,barwi);
            END;
        END;
    END;

    IF showglobal THEN
        FOR i:=firstcode TO maxcode DO
            count[i]:=gcount[i];
        END;
        Str.Copy(path,"all specified files");
        WrLn;
        dump (path,restricted,percentage,excludecontrol,
             hexval,decval,sort,reversesort,
             eyecandy,showheader,showglobal,showbar,semigraphics,
                 gfilesize,gtotal,gctrlchars,barwi);
    END;

    abort(errNone,"");
END cCount.
