(* ---------------------------------------------------------------
Title         Q&D NewName
Author        PhG
Overview      remove/replace character(s) in filename(s)
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              fix chkValid()
Bugs          Win9X would sometimes not casify as asked to !
Wish List     still to do in order to match older newname0 : count
              recursion ?
              allow "?" joker
              process all 0..9 digits at once ?

--------------------------------------------------------------- *)

MODULE NewName;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec;

(* ------------------------------------------------------------ *)

CONST
    blank         = " ";
    alphaset      = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; (* uppercase *)
    digits        = "0123456789";
    symbols       = "_-$!(){}~#&@[]";
    legalLFN      = ",'.+%"+blank;
    DOScharset    = alphaset+digits+symbols;
    LFNcharset    = DOScharset+legalLFN;
    UNDOBATCH     = "ROLLBACK.BAT";
    ignoredrenumprefix  = "*"; (* ignore prefix when renumbering *)
    autonumsep          = "_";
    autonummarker       = "*";
CONST
    dot           = ".";
    dash          = "-";
    stardotstar   = "*.*";
    dquote        = '"';
    dotdot        = dot+dot;
    charnull      = 0C; (* CHR(0) *)
CONST
    deg           = "";
    slash         = "/";
    singlequote   = "'";
    escSet        = deg+dash+slash+singlequote;
    escCh         = deg; (* avoid \, already used in some batches for \\ etc. *)
CONST
    MINFIELD      = 1;
    MAXFIELD      = 12;
    DEFFIELD      = 4;
    MINDELTA      = 1;
    MAXDELTA      = 100;
    DEFDELTA      = 1;
CONST
    ProgEXEname   = "NEWNAME";
    ProgTitle     = "Q&D Filename Modifier";
    ProgVersion   = "v1.2l";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errUnknownOption= 2;
    errParmOverflow = 3;
    errStorage      = 4;
    errCmdConflict  = 5;
    errSyntax       = 6;
    errBadPrefix    = 7;
    errBadSuffix    = 8;
    errBadSpec      = 9;
    errNoMatch      = 10;
    errBadChar      = 11;
    errBadRemap     = 12;
    errRemapNonsense= 13;
    errBadVal       = 14;
    errBadInfix     = 15;
    errNonsense     = 16;
    errRange        = 17;
    errSortConflict = 18;
    errFieldWidth   = 19;
    errWontProcess  = 20;
    errBadSubstring = 21;
    errBadMeta      = 22;
    errLFNonly      = 23;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr=CHR(13);
    lf=CHR(10);
    nl=cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
     helpmsg=Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [-f] <string> <file(s)> [option]..."+nl+
"Syntax 2 : "+ProgEXEname+" [-m] <oldstring> <newstring> <file(s)> [option]..."+nl+
"Syntax 3 : "+ProgEXEname+" <-p[p]> <prefix|"+autonummarker+"> <file(s)> [option]..."+nl+
"Syntax 4 : "+ProgEXEname+" <-s[s]> <suffix|"+autonummarker+"> <file(s)> [option]..."+nl+
"Syntax 5 : "+ProgEXEname+" <-i:#> <insertion> <file(s)> [option]..."+nl+
"Syntax 6 : "+ProgEXEname+" <-z> <substring> <file(s)> [option]..."+nl+
"Syntax 7 : "+ProgEXEname+" <-c> <oldsubstring> <newsubstring> <file(s)> [option]..."+nl+
"Syntax 8 : "+ProgEXEname+" <-lc[c]|-uc[c]> <file(s)> [option]..."+nl+
"Syntax 9 : "+ProgEXEname+" <-n[n]> <prefix|"+ignoredrenumprefix+"> <first> <file(s)> [option]..."+nl+
nl+
"This program filters out characters from <string> (syntax 1) ;"+nl+
"remaps character(s) from <oldstring> using <newstring> (syntax 2) ;"+nl+
"processes prefixes (syntax 3), suffixes (syntax 4) and insertions (syntax 5) ;"+nl+
"removes substrings (syntax 6) ; changes <oldstring> to <newstring> (syntax 7) ;"+nl+
"changes LFN filenames case to lower or upper (syntax 8) ;"+nl+
"or renumbers filenames (syntax 9)."+nl+
nl+
"  -f        filter out mode (default if two parameters were specified)"+nl+
"  -m        remap mode (default if three parameters were specified)"+nl+
"  -p[p]     prefix mode (-pp = -d -p)"+nl+
"  -s[s]     suffix mode (-ss = -d -s)"+nl+
"  -i[i]:#   insert at specified 0-based column mode (-ii:# = -d -i:#)"+nl+
"  -z        remove substring mode"+nl+
"  -c        change oldsubstring to newsubstring mode"+nl+
"  -lc[c]    convert to lowercase mode (-lcc = do not try and preserve accents)"+nl+
"  -uc[c]    convert to uppercase mode (-ucc = do not try and preserve accents)"+nl+
'  -n[n]     renumber mode (-nn = "-n '+ignoredrenumprefix+'" syntax = do not use <prefix>)'+nl+
nl+
"  -d[?]     delete prefix or suffix (-ds = -s -d, -dp = -p -d)"+nl+
"  -a        take hidden and system files into account"+nl+
"  -o        rename even if new name already exists (previous content lost)"+nl+
"  -e        process extension (only when removing, remapping or converting)"+nl+ (* chars *)
"  -f:#      number field width ([1..12], default is 4)"+nl+
"  -k:#      renumbering increment ([1..100], default is 1)"+nl+
"  -s<n|e|z> sort when renumbering (-sn = name, -se = extension, -sz = size)"+nl+
"  -x        prepend renumbered value and <prefix> to <filename> (-n[n] only)"+nl+
"  -r[r]     do rename file(s) (-rr = create undo "+UNDOBATCH+")"+nl+
"  -l        disable LFN support even if available"+nl+
nl+
'Valid set (DOS) : "'+DOScharset+'"'+nl+
'Valid set (LFN) : "'+LFNcharset+'"'+nl+
nl+
"a) Any option irrelevant to specified mode command will be silently ignored."+nl+
"b) Program will handle up to 65530 files. "+UNDOBATCH+" name is reserved."+nl+
"c) Note collisions cannot be previewed : use -r only when sure of results !"+nl+
'd) Auto-numbering "-s *" and "-p *" syntaxes use "'+autonumsep+'" as a separator.'+nl+
'e) Support for escape sequences is minimalist : "'+escCh + '[' + escSet + ']" inserts symbol,' + nl +
'   while "' + escCh + "[$|x]#[" + escCh + ']" inserts (hexa)decimal character value.'+nl;

VAR
    S : str1024;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errUnknownOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParmOverflow :
        Str.Concat(S,"Uneeded ",einfo);Str.Append(S," parameter !");
    | errStorage :
        S := "Storage ALLOCATE() failure !";
    | errCmdConflict:
        S := "Mutually exclusive commands !";
    | errSyntax :
        S := "Syntax error !";
    | errBadPrefix:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" prefix !');
    | errBadSuffix:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" suffix !');
    | errBadSpec:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" specification !');
    | errNoMatch:
        Str.Concat(S,'No match for "',einfo);Str.Append(S,'" specification !');
    | errBadChar:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" string !');
    | errBadRemap:
        S:="<oldstring> and <newstring> must have the same length !";
    | errRemapNonsense:
        S:="Remapping a character to itself is a nonsense !";
    | errBadVal:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errBadInfix:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" insertion !');
    | errNonsense:
        Str.Concat(S,einfo," option is a nonsense with specified command !");
    | errRange:
        Str.Concat(S,einfo," is not in expected range !");
    | errSortConflict:
        S := "Mutually exclusive sort methods !";
    | errFieldWidth:
        S := "Field width is too small for total number of files to process !";
    | errWontProcess:
        S := "-rr option prevents processing of existing "+UNDOBATCH+" !";
    | errBadSubstring:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" substring !');
    | errBadMeta:
        Str.Concat(S,'Illegal escape sequence ("',einfo);Str.Append(S,'") !');
    | errLFNonly:
        S:= "Case changing requires LFN support !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferOut : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstEntry = 1; (* 1..count *)
TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next   : ptrToEntry;
        index  : CARDINAL; (* for possible later sort *)
        fsize  : LONGCARD;
        slen   : CARDINAL; (* a SHORTCARD would DO fine IN almost all cases  *)
        string : CHAR;     (* here, after other data, because variable length *)
    END;

VAR
    anchorSpec  : ptrToEntry; (* globerk *)

PROCEDURE getAnchor (  ):ptrToEntry;
BEGIN
    RETURN anchorSpec;
END getAnchor;

PROCEDURE initList (VAR anchor:ptrToEntry; VAR count:CARDINAL);
BEGIN
    count := firstEntry-1; (* complicated way to mean 0 *)
    anchor:= NIL;
END initList;

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildMatchList (VAR anchor:ptrToEntry;
                          useLFN,hiddensystem : BOOLEAN;spec:pathtype):CARDINAL;
VAR
    S:pathtype; (* some are oversized but safety first ! *)
    newInList : ptrToEntry;
    len,needed,count : CARDINAL;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
    fsize:LONGCARD;
BEGIN
    IF hiddensystem THEN
        dosattr:=allfiles;
    ELSE
        dosattr := FIO.FileAttr{aR,aA};
    END;

    count:=0;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(dosattr),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,dosattr,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
            fsize := w9Xentry.fsize.lo;
        ELSE
            Str.Copy(S,DOSentry.Name);
            fsize := DOSentry.size;     (* thanks, JPI, for using a reserved word here ! *)
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                IF count=MAX(CARDINAL) THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* too many files but let's fake ALLOCATE failure *)
                len:=Str.Length(S);
                needed:=SIZE(entryType)-SIZE(CHAR)+len;
                IF Available(needed)=FALSE THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* storage ALLOCATE failure *)
                IF anchor=NIL THEN
                    ALLOCATE( anchor,needed);
                    newInList := anchor;
                ELSE
                    ALLOCATE(newInList^.next,needed);
                    newInList :=newInList^.next;
                END;
                Lib.FastMove( ADR(S),ADR(newInList^.string),len);
                newInList^.slen := len;
                newInList^.fsize:= fsize;
                newInList^.next := NIL;
                newInList^.index:= 0; (* filled later *)
                INC(count);
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildMatchList;

PROCEDURE freeMatchList (anchor:ptrToEntry);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrToEntry;
BEGIN
    firstInList := anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        len         := CARDINAL(newInList^.slen);
        needed      := SIZE(entryType)-SIZE(CHAR)+len;
        firstInList := firstInList^.next;
        DEALLOCATE (newInList,needed);
        newInList := firstInList;
    END
END freeMatchList;

PROCEDURE findEntry (n:CARDINAL;  anchor:ptrToEntry  ):ptrToEntry;
VAR
    newInList:ptrToEntry;
BEGIN
    newInList := anchor;
    LOOP
        IF newInList = NIL THEN EXIT;END; (* gloups! *)
        IF newInList^.index = n THEN EXIT; END;
        newInList := newInList^.next;
    END;
    RETURN newInList;
END findEntry;

PROCEDURE getEntry (VAR R:pathtype;
                   n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := findEntry(n,anchor);
    IF newInList = NIL THEN Str.Copy(R,"???"); RETURN;END;
    len         := newInList^.slen;
    Lib.FastMove( ADR(newInList^.string),ADR(S),len);
    S[len]      := charnull; (* REQUIRED safety ! *)
    Str.Copy(R,S); (* yep, compiler won't let us fill R directly *)
END getEntry;

PROCEDURE getFsizeEntry (VAR R:LONGCARD;
                        n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := findEntry(n,anchor);
    IF newInList = NIL THEN R:=MAX(LONGCARD); RETURN;END;
    R := newInList^.fsize;
END getFsizeEntry;

PROCEDURE initIndexes (anchor:ptrToEntry );
VAR
    newInList:ptrToEntry;
    i : CARDINAL;
BEGIN
    i := firstEntry;
    newInList:=anchor;
    LOOP
        IF newInList = NIL THEN EXIT; END;
        newInList^.index := i;
        INC(i);
        newInList := newInList^.next;
    END;
END initIndexes;

(* ------------------------------------------------------------ *)

PROCEDURE doswap (i,j:CARDINAL);
VAR
    anchor,pi,pj:ptrToEntry;
    tmp:CARDINAL;
BEGIN
    anchor:=getAnchor();
    pi:=findEntry(i,anchor);
    pj:=findEntry(j,anchor);
    tmp:=pi^.index;
    pi^.index:=pj^.index;
    pj^.index:=tmp;
END doswap;

PROCEDURE dolessname (i,j:CARDINAL ):BOOLEAN ;
VAR
    SI,SJ: pathtype ;
    anchor:ptrToEntry;
BEGIN
    anchor:=getAnchor();
    getEntry(SI,i, anchor);
    getEntry(SJ,j, anchor);
    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);
    IF Str.Compare(SI,SJ) < 0 THEN (* -1 is less *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END dolessname;

PROCEDURE dolessext ( i,j:CARDINAL  ):BOOLEAN ;
VAR
    e1,e2:pathtype;
    p : CARDINAL;
    anchor:ptrToEntry;
BEGIN
    anchor:=getAnchor();
    getEntry(e1,i,anchor);
    getEntry(e2,j,anchor);
    LowerCase(e1); (* ignore accents when sorting *)
    LowerCase(e2);

    p := Str.RCharPos(e1,dot);
    IF p = MAX(CARDINAL) THEN
        e1:="";
    ELSE
        Str.Delete(e1,0,p+1);
    END;
    p := Str.RCharPos(e2,dot);
    IF p = MAX(CARDINAL) THEN
        e2:="";
    ELSE
        Str.Delete(e2,0,p+1);
    END;
    CASE Str.Compare(e1,e2) OF
    | -1 : RETURN TRUE;
    |  0 : RETURN dolessname(i,j);
    |  1 : RETURN FALSE;
    END;
END dolessext;

PROCEDURE dolesssize (i,j:CARDINAL ):BOOLEAN ;
VAR
    anchor:ptrToEntry;
    fsizeI,fsizeJ:LONGCARD;
BEGIN
    anchor:=getAnchor();
    getFsizeEntry(fsizeI,i, anchor);
    getFsizeEntry(fsizeJ,j, anchor);
    IF (fsizeI = fsizeJ) THEN
        RETURN dolessname(i,j);
    ELSE
        RETURN (fsizeI < fsizeJ);
    END;
END dolesssize;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE WrQ (S:ARRAY OF CHAR);
BEGIN
    WrStr(dquote);WrStr(S);WrStr(dquote);
END WrQ;

(* ripped from OldNew v1.1a last revised 30 Aug 08 *)

(*
shame on you not to have thought of more than one value at a time !
shame on you for relying on an external library to parse a mere hex value !
really gone is your Apple ][ genius... :-(
bah, old age is coming faster than end of the world...
*)

(* assume : digits already filtered and uppercased, base = 10 or 16, hex=## *)

PROCEDURE charvalToStr (VAR R:ARRAY OF CHAR; base:CARDINAL; digits:ARRAY OF CHAR):BOOLEAN;

    MODULE hxhelper;

    EXPORT hx;

    PROCEDURE hx (ch:CHAR):CARDINAL;
    CONST
        val0 = ORD("0");
        valA = ORD("A");
    VAR
        v:CARDINAL;
    BEGIN
        v:=ORD(ch);
        IF v < valA THEN
            DEC(v, val0 );
        ELSE
            DEC(v, valA );
            INC(v, 10);
        END;
        RETURN v;
    END hx;

    END hxhelper;

CONST
    maxcharval = MAX(SHORTCARD);
VAR
    rc : BOOLEAN;
    i,len,v: CARDINAL;
BEGIN
    rc := TRUE;
    len:= Str.Length(digits);
    Str.Copy(R,"");
    CASE base OF
    | 10: (* filtered for 0..9 *)
        v:=0;
        i:=1;
        LOOP
            IF i > len THEN EXIT;END;
            v := (v * 10);
            INC( v , ( ORD( digits[i-1] ) - ORD("0") ) );
            rc := ( v <= maxcharval ); IF NOT(rc) THEN EXIT; END;
            INC(i);
        END;
        IF rc THEN rc := (v # 0); END;
        IF rc THEN Str.Copy( R, CHR(v) );END;
    | 16: (* filtered for 0..9 A..F *)
        (* IF len < 2 THEN Str.Prepend(digits,"0"); INC(len);END; done by caller *)
        IF ODD(len) THEN
            rc:=FALSE;
        ELSE
            i:=1;
            LOOP
                IF i > len THEN EXIT; END;
                v:=  ( hx(digits[i-1]) << 4 );
                INC(i);
                INC(v, hx(digits[i-1]) );
                INC(i);
                rc := (v # 0);
                IF NOT(rc) THEN EXIT; END;
                Str.Append(R, CHR(v) );
            END;
        END;
    END;
    RETURN rc;
END charvalToStr;

(*

 - / '

###    $##    x##

*)

PROCEDURE metaproc (VAR S : ARRAY OF CHAR):BOOLEAN;
VAR
    ch:CHAR;
    c2:str80; (* really oversized for safety *)
    len,i,base:CARDINAL;
    R,orgS:str128;
    str:str128; (* in case we overflow ! *)
    state : (waiting,gotesc,grabhex,grabdec);
    rc:BOOLEAN;
BEGIN
    Str.Copy(orgS,S); (* in case of an error, return original unmodified string *)
    len := Str.Length(S);
    R   := "";
    i   := 1;
    rc  := TRUE;
    state := waiting;
    LOOP
        IF i > len THEN EXIT; END;
        ch := S[i-1];
        CASE state OF
        | waiting:
            CASE ch OF
            | escCh :
                state := gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            CASE ch OF
            | "x","X","$":Str.Copy(str,"");         state:=grabhex; base:=16;
            | "0".."9" :  Str.Copy(str,ch);         state:=grabdec; base:=10;
            ELSE
                IF Str.CharPos(escSet,ch) = MAX(CARDINAL) THEN
                    DEC(i); (* esc+verbatim : go back to make verbatim the next *)
                ELSE
                    Str.Append(R,ch); (* esc+reserved char *)
                END;
                state:=waiting;
            END;
        | grabhex:
            CASE ch OF
            | "0".."9", "A".."F", "a".."f" :
                Str.Append(str, CAP(ch) ); (* uppercase ! *)
            | escCh:
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        | grabdec:
            CASE ch OF
            | "0".."9" :
                Str.Append(str,ch);
            | escCh:
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        END;
        INC(i);
    END;
    CASE state OF
    | grabhex:
        IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    | grabdec:
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    END;
    IF rc THEN
        Str.Copy(S,R);
    ELSE
        Str.Copy(S,orgS); (* restore original *)
    END;
    RETURN rc;
END metaproc;

(* only handle "-" alone *)

PROCEDURE isOptionForReal (S:ARRAY OF CHAR  ):BOOLEAN ;
BEGIN
    IF same(S,dash) THEN RETURN FALSE; END; (* don't be fooled by a dash alone *)
    RETURN isOption(S);
END isOptionForReal;

PROCEDURE killfile (useLFN,killRO:BOOLEAN;S:pathtype);
BEGIN
    IF fileIsRO(useLFN,S) THEN
        fileErase(useLFN,S);
    ELSE
        IF killRO THEN
            fileSetRW(useLFN,S);
            fileErase(useLFN,S);
        END;
    END;
END killfile;

PROCEDURE padnum (lc:LONGCARD;wi:CARDINAL   ):str80;
VAR
    R:str80;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(lc,R,10,ok);
    FOR i:=Str.Length(R)+1 TO wi DO
        Str.Prepend(R,"0");
    END;
    RETURN R;
END padnum;

(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (nada,
              prefix,suffix,prefixkill,suffixkill,infix,infixkill,
              remove,remap,renum,substringkill,
              substringreplace,strlowercase,struppercase,
              strlowercasenoaccents,struppercasenoaccents,
              suffixautonum,prefixautonum);

PROCEDURE chkcmd (VAR cmd:cmdtype; wanted:cmdtype ):BOOLEAN;
BEGIN
    IF ( (cmd = nada) OR (cmd=wanted) ) THEN
        cmd:=wanted;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END chkcmd;

TYPE
    sorttype = (nosort,bysize,byname,byextension); (* bydatetime is neverware *)

PROCEDURE chksort (VAR sort:sorttype; wanted:sorttype ):BOOLEAN;
BEGIN
    IF ( (sort= nosort) OR (sort=wanted) ) THEN
        sort:=wanted;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END chksort;

PROCEDURE chkChars (useLFN,allowdot,allowDOSspace:BOOLEAN;S:ARRAY OF CHAR):BOOLEAN;
VAR
    R,allowed:pathtype;
BEGIN
    IF useLFN THEN
        Str.Copy(allowed,LFNcharset);
        allowdot:=TRUE;
    ELSE
        IF allowDOSspace THEN
            Str.Copy(allowed,blank+DOScharset); (* only for removing chars *)
        ELSE
            Str.Copy(allowed,DOScharset);
        END;
    END;
    IF NOT(allowdot) THEN Str.Subst(allowed,dot,"");END;
    Str.Copy(R,S);
    UpperCase(R);
    RETURN verifyString (R,allowed);
END chkChars;

PROCEDURE chkValid (useLFN,isSpec:BOOLEAN;S:ARRAY OF CHAR;VAR base:ARRAY OF CHAR):BOOLEAN;
VAR
    R,u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    IF isSpec THEN
        Lib.MakeAllPath(base,u,d,"","");
        IF same(base,"")=FALSE THEN fixDirectory(base);END;
    ELSE
        IF chkJoker(S) THEN RETURN FALSE; END;
        Lib.MakeAllPath(R,"","",n,e);
        IF same(S,R)=FALSE THEN RETURN FALSE;END; (* a path is not a valid fix *)
        RETURN chkChars(useLFN,TRUE,FALSE,R);
    END;
    RETURN TRUE;
END chkValid;

PROCEDURE chkRange (VAR v:CARDINAL;
                   lc:LONGCARD;lower,upper:CARDINAL):BOOLEAN ;
BEGIN
    IF lc > MAX(CARDINAL) THEN RETURN FALSE;END;
    v:=CARDINAL(lc); (* don't bother to check against filename len *)
    IF v < lower THEN RETURN FALSE;END;
    IF v > upper THEN RETURN FALSE;END;
    RETURN TRUE;
END chkRange;

(* ------------------------------------------------------------ *)

CONST
    placeholder    = "|"; (* does not belong to DOS or LFN charsets *)
    msgTooShort    = "--- Renamed "+placeholder+" would be empty !";
    msgTooLong     = "--- Renamed "+placeholder+" would be too long !";
    msgAlready     = "--- Renamed "+placeholder+" already exists !";
    msgWouldBe     = "::: "+placeholder+" would become "+placeholder;
    msgIsNow       = "+++ "+placeholder+" became "+placeholder;
    msgFileExists  = " (file exists)";
    msgFileExisted = " (file existed)";

PROCEDURE msg (useLFN,doCR:BOOLEAN;S,F:ARRAY OF CHAR   );
VAR
    R:str1024; (* oversized *)
BEGIN
    Str.Copy(R,S);
    IF useLFN THEN Str.Subst(R,placeholder,dquote+placeholder+dquote);END;
    Str.Subst(R,placeholder,F);
    WrStr(R);IF doCR THEN WrLn; END;
END msg;

PROCEDURE msg2 (useLFN,doCR:BOOLEAN;S,F1,F2:ARRAY OF CHAR   );
VAR
    R:str1024; (* oversized *)
BEGIN
    Str.Copy(R,S);
    IF useLFN THEN Str.Subst(R,placeholder,dquote+placeholder+dquote);END;
    Str.Subst(R,placeholder,F1);
    IF useLFN THEN Str.Subst(R,placeholder,dquote+placeholder+dquote);END;
    Str.Subst(R,placeholder,F2);
    WrStr(R);IF doCR THEN WrLn; END;
END msg2;

PROCEDURE chknewlen (VAR messages:CARDINAL;
                    useLFN:BOOLEAN;oldname,n:pathtype):BOOLEAN;
CONST
    MINF8 = 1;
    MAXF8 = 8;
VAR
    wecandoit:BOOLEAN;
    len : CARDINAL;
BEGIN
    len:=Str.Length(n);
    wecandoit:=FALSE;
    IF useLFN THEN
        CASE len OF
        | 0 :
            msg(useLFN,TRUE, msgTooShort,oldname);
        ELSE
            wecandoit:=TRUE; (* assume all ok *)
        END;
    ELSE
        CASE len OF
        | 0 :
             msg(useLFN,TRUE,msgTooShort,oldname);
        | MINF8..MAXF8 :
             wecandoit:=TRUE;
        ELSE
             msg(useLFN,TRUE,msgTooLong,oldname);
        END;
    END;
    IF wecandoit=FALSE THEN INC(messages);END;
    RETURN wecandoit;
END chknewlen;

PROCEDURE doClean (VAR n,e:pathtype; procext:BOOLEAN;str:ARRAY OF CHAR):BOOLEAN ;
VAR
    filename,extension,delme:pathtype;
    action,p,i,pass,lastpass : CARDINAL;
    ch:CHAR;
BEGIN
    IF procext THEN
       lastpass:=2
    ELSE
       lastpass:=1;
    END;

    Str.Copy(filename,n);
    Str.Copy(extension,e);
    Str.Copy(delme,str);
    UpperCase(filename);
    UpperCase(extension);
    UpperCase(delme);

    action := 0;
    FOR pass:=1 TO lastpass DO
        FOR i:=1 TO Str.Length(delme) DO
            ch:=delme[i-1];
            LOOP
                CASE pass OF
                | 1 : p:=Str.CharPos(filename,ch);
                      IF p # MAX(CARDINAL) THEN
                          Str.Delete(filename,p,1);
                          Str.Delete(n,p,1);
                          INC(action);
                      END;
                | 2 : p:=Str.CharPos(extension,ch);
                      IF p # MAX(CARDINAL) THEN
                          Str.Delete(extension,p,1);
                          Str.Delete(e,p,1);
                          INC(action);
                      END;
                END;
                IF p = MAX(CARDINAL) THEN EXIT; END;
            END;
        END;
    END;
    RETURN (action # 0);
END doClean;

PROCEDURE doRemap (VAR n,e:pathtype; procext:BOOLEAN;str,mapstr:ARRAY OF CHAR):BOOLEAN ;
VAR
    filename,extension,mapme:pathtype;
    action,p,i,pass,lastpass,len : CARDINAL;
    ch:CHAR;
BEGIN
    IF procext THEN
       lastpass:=2
    ELSE
       lastpass:=1;
    END;

    Str.Copy(filename,n);
    Str.Copy(extension,e);
    Str.Copy(mapme,str);
    UpperCase(filename);
    UpperCase(extension);
    UpperCase(mapme);

    action:=0;
    FOR pass:=1 TO lastpass DO
        CASE pass OF
        | 1 : len:=Str.Length(filename);
        | 2 : len:=Str.Length(extension);
        END;
        FOR i:=1 TO len DO
            CASE pass OF
            | 1 : p:=Str.CharPos(mapme,filename[i-1]);
                  IF p # MAX(CARDINAL) THEN
                      n[i-1]:=mapstr[p];
                      INC(action);
                  END;
            | 2 : p:=Str.CharPos(mapme,extension[i-1]);
                  IF p # MAX(CARDINAL) THEN
                      e[i-1]:=mapstr[p];
                      INC(action);
                  END;
            END;
        END;
    END;
    RETURN (action # 0);
END doRemap;

PROCEDURE doCasify (VAR n,e:pathtype; op:cmdtype;procext:BOOLEAN ):BOOLEAN;
BEGIN
        CASE op OF
        | strlowercase:          LowerCaseAlt(n);
        | struppercase:          UpperCaseAlt(n);
        | strlowercasenoaccents: LowerCase(n);
        | struppercasenoaccents: UpperCase(n);
        END;
    IF procext THEN
        CASE op OF
        | strlowercase:          LowerCaseAlt(e);
        | struppercase:          UpperCaseAlt(e);
        | strlowercasenoaccents: LowerCase(e);
        | struppercasenoaccents: UpperCase(e);
        END;
    END;
    RETURN TRUE;
END doCasify;

PROCEDURE doFix (VAR messages:CARDINAL; VAR newname:pathtype;
                 oldname:pathtype;useLFN,procext,safety,prefixrenum,DEBUG : BOOLEAN;
                 op:cmdtype;colpos:CARDINAL;
                 str,str2:pathtype):BOOLEAN;
VAR
    u,d,n,e,S1,S2,newn,tmpn:pathtype;
    p,len,count:CARDINAL;
    wecandoit:BOOLEAN;
BEGIN
    IF DEBUG THEN WrStr("; old : ");WrQ(oldname);WrLn; END;
    Lib.SplitAllPath(oldname,u,d,n,e);
    CASE op OF
    | prefix,prefixautonum :
        Str.Prepend(n,str);
        wecandoit:=chknewlen ( messages, useLFN, oldname,n);
    | suffix,suffixautonum :
        Str.Append(n,str);
        wecandoit:=chknewlen ( messages, useLFN, oldname,n);
    | prefixkill:
        count:=Str.Length(str);
        Str.Slice(S1,n,0,count);
        Str.Copy(S2,str);
        UpperCase(S1);
        UpperCase(S2);
        IF same(S1,S2) THEN
            Str.Delete(n,0,count);
            wecandoit:=chknewlen(messages,useLFN,oldname,n);
        ELSE
            wecandoit:=FALSE;
        END;
    | suffixkill:
        count:=Str.Length(str);
        len  :=Str.Length(n);
        IF len < count THEN
            wecandoit:=FALSE;
        ELSE
            Str.Slice(S1,n,len-count,count);
            Str.Copy(S2,str);
            UpperCase(S1);
            UpperCase(S2);
            wecandoit:= same(S1,S2);
            IF wecandoit THEN
                Str.Delete(n,len-count,count);
                wecandoit:=chknewlen(messages,useLFN,oldname,n);
            END;
        END;
    | remove :
        wecandoit:=doClean(n,e, procext,str);
    | remap :
        wecandoit:=doRemap(n,e, procext,str,str2);
    | infix:
        Str.Insert(n,str,colpos); (* don't bother to check *)
        wecandoit:=chknewlen(messages,useLFN,oldname,n);
    | infixkill:
        count:=Str.Length(str);
        Str.Slice(S1,n,colpos,count);
        Str.Copy(S2,str);
        UpperCase(S1);
        UpperCase(S2);
        wecandoit:=same(S1,S2);
        IF wecandoit THEN
            Str.Delete(n,colpos,count);
            wecandoit:=chknewlen(messages,useLFN,oldname,n);
        END;
    | renum:
        IF prefixrenum THEN
            Str.Prepend(n,str);
        ELSE
            Str.Copy(n,str); (* str is renumbered name *)
        END;
        wecandoit:=chknewlen(messages,useLFN,oldname,n);
    | substringkill:
        len:=Str.Length(str);
        Str.Copy(S2,str);
        UpperCase(S2);
        count:=0;
        LOOP
            Str.Copy(S1,n);
            UpperCase(S1);
            p:=Str.Pos(S1,S2);
            IF p = MAX(CARDINAL) THEN EXIT; END;
            Str.Delete(n,p,len);
            INC(count);
        END;
        IF count=0 THEN
            wecandoit:=FALSE;
        ELSE
            wecandoit:=chknewlen ( messages, useLFN, oldname,n);
        END;
    | strlowercase, struppercase, strlowercasenoaccents, struppercasenoaccents:
        wecandoit:=doCasify( n,e, op,procext);
    | substringreplace:
        Str.Copy(newn,"");
        len:=Str.Length(str);
        Str.Copy(S2,str);
        UpperCase(S2);
        count:=0;
        LOOP
            Str.Copy(S1,n);
            UpperCase(S1);
            p:=Str.Pos(S1,S2);
            IF p = MAX(CARDINAL) THEN EXIT; END;
            Str.Slice(tmpn,n,0,p); (* keep what's before *)
            Str.Delete(n,0,p+len); (* remove including oldsubstring *)
            Str.Append(newn,tmpn);
            Str.Append(newn,str2);
            INC(count);
        END;
        IF count=0 THEN
            wecandoit:=FALSE;
        ELSE
            Str.Prepend(n,newn);
            wecandoit:=chknewlen ( messages, useLFN, oldname,n);
        END;
    END;
    Lib.MakeAllPath(newname,"","",n,e);
    IF safety THEN
        Str.Copy(S1,newname);
        UpperCase(S1);
        wecandoit:=NOT( same(S1,UNDOBATCH) );
    END;
    IF DEBUG THEN WrStr("; new : ");WrQ(newname);WrLn; END;
    RETURN wecandoit;
END doFix;

PROCEDURE buildUndo (VAR R:ARRAY OF CHAR;
                    useLFN:BOOLEAN;base,oldname,newname:pathtype );
CONST
    cliren = "REN "+placeholder+" "+placeholder;
VAR
    S:str1024; (* oversized *)
    u,d,n,e,id:pathtype;
BEGIN
    Str.Copy(S,cliren);

    Lib.SplitAllPath(newname,u,d,n,e);
    Lib.MakeAllPath(id,"","",n,e);
    Str.Prepend(id,base);
    IF useLFN THEN Str.Subst(S,placeholder,dquote+placeholder+dquote);END;
    Str.Subst(S,placeholder,id);

    Lib.SplitAllPath(oldname,u,d,n,e);
    Lib.MakeAllPath(id,"","",n,e);
    IF useLFN THEN Str.Subst(S,placeholder,dquote+placeholder+dquote);END;
    Str.Subst(S,placeholder,id);
    Str.Copy(R,S);
END buildUndo;

PROCEDURE isCmdCasify (op:cmdtype):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    CASE op OF
    | strlowercase,struppercase,strlowercasenoaccents,struppercasenoaccents:
        rc:=TRUE;
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END isCmdCasify;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    msgWaitSort = "Sorting data, please wait...";
CONST
    firstparm = 1;
    maxparm   = 3;
VAR
    parm : ARRAY [firstparm..maxparm] OF pathtype;
VAR
    testmode,useLFN,overwrite,kill,processAll,procext,safety:BOOLEAN;
    userenumprefix,prefixrenum:BOOLEAN;
    cmd:cmdtype;
    sort:sorttype;
VAR
    parmcount,i,opt:CARDINAL;
    S,R,spec,base,str,mapstr,oldname,newname, oldstr,newstr:pathtype;
    lastparm,lastEntry,messages,colpos,fieldwidth,v:CARDINAL;
    DEBUG,allowed,existed,wecandoit:BOOLEAN;
    lc,currnum,rendelta:LONGCARD;
    hout:FIO.File;
    hugestr:str1024; (* oversized for LFNs *)
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    Str.Copy(mapstr,"");   (* default safety *)
    colpos:=MAX(CARDINAL); (* suffix *)

    cmd       := nada;
    sort      := nosort;
    fieldwidth:= DEFFIELD;
    rendelta  := DEFDELTA;
    currnum   := 1; (* default for "-s *" and "-p *" syntaxes *)
    testmode  := TRUE;
    useLFN    := TRUE;
    kill      := FALSE;
    overwrite := FALSE;
    processAll:= FALSE;
    procext   := FALSE;
    safety    := FALSE;
    userenumprefix := TRUE;
    prefixrenum:=FALSE;
    DEBUG          := FALSE;
    lastparm  := firstparm-1;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOptionForReal(R) THEN (* only handle "-" alone *)
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "P"+delim+"PREFIX"+delim+
                                   "S"+delim+"SUFFIX"+delim+
                                   "D"+delim+"DELETE"+delim+
                                   "O"+delim+"OVERWRITE"+delim+
                                   "R"+delim+"RENAME"+delim+
                                   "L"+delim+"LFN"+delim+
                                   "PP"+delim+
                                   "SS"+delim+
                                   "A"+delim+"ALL"+delim+
                                   "E"+delim+"EXTENSION"+delim+
                                   "I:"+delim+"INFIX:"+delim+
                                   "II:"+delim+
                                   "N"+delim+"RENUM"+delim+
                                   "F:"+delim+"FIELD:"+delim+
                                   "SN"+delim+
                                   "SE"+delim+
                                   "RR"+delim+
                                   "K:"+delim+
                                   "DP"+delim+
                                   "DS"+delim+
                                   "Z"+delim+"ZAP"+delim+
                                   "C"+delim+"CHANGE"+delim+"REPLACE"+delim+
                                   "LC"+delim+"LOWERCASE"+delim+"LOWS"+delim+
                                   "UC"+delim+"UPPERCASE"+delim+"CAPS"+delim+
                                   "F"+delim+"FILTER"+delim+
                                   "M"+delim+"REMAP"+delim+
                                   "LCC"+delim+
                                   "UCC"+delim+
                                   "SZ"+delim+
                                   "NN"+delim+
                                   "X"+delim+"PREFIXRENUM"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : IF chkcmd(cmd,prefix)=FALSE THEN abort(errCmdConflict,"");END;
            | 6,7   : IF chkcmd(cmd,suffix)=FALSE THEN abort(errCmdConflict,"");END;
            | 8,9   : kill:=TRUE;
            | 10,11 : overwrite:=TRUE;
            | 12,13 : testmode:=FALSE;
            | 14,15 : useLFN:=FALSE;
            | 16    : IF chkcmd(cmd,prefixkill)=FALSE THEN abort(errCmdConflict,"");END;
            | 17    : IF chkcmd(cmd,suffixkill)=FALSE THEN abort(errCmdConflict,"");END;
            | 18,19 : processAll:=TRUE;
            | 20,21 : procext:=TRUE;
            | 22,23 : IF chkcmd(cmd,infix)=FALSE THEN abort(errCmdConflict,"");END;
                      IF GetLongCard(R,lc)=FALSE THEN abort(errBadVal,S);END;
                      IF chkRange(colpos,lc,0,MAX(CARDINAL))=FALSE THEN abort(errRange,S);END;
            | 24    : IF chkcmd(cmd,infixkill)=FALSE THEN abort(errCmdConflict,"");END;
                      IF GetLongCard(R,lc)=FALSE THEN abort(errBadVal,S);END;
                      IF chkRange(colpos,lc,0,MAX(CARDINAL))=FALSE THEN abort(errRange,S);END;
            | 25,26 : IF chkcmd(cmd,renum)=FALSE THEN abort(errCmdConflict,"");END;
            | 27,28 : IF GetLongCard(R,lc)=FALSE THEN abort(errBadVal,S);END;
                      IF chkRange(fieldwidth,lc,MINFIELD,MAXFIELD)=FALSE THEN abort(errRange,S);END;
            | 29    : IF chksort(sort,byname)=FALSE THEN abort(errSortConflict,"");END;
            | 30    : IF chksort(sort,byextension)=FALSE THEN abort(errSortConflict,"");END;
            | 31    : testmode:=FALSE; safety:=TRUE;
            | 32    : IF GetLongCard(R,rendelta)=FALSE THEN abort(errBadVal,S);END;
                      IF chkRange(v,rendelta,MINDELTA,MAXDELTA)=FALSE THEN abort(errRange,S);END;
            | 33    : IF chkcmd(cmd,prefixkill)=FALSE THEN abort(errCmdConflict,"");END;
            | 34    : IF chkcmd(cmd,suffixkill)=FALSE THEN abort(errCmdConflict,"");END;
            | 35,36 : IF chkcmd(cmd,substringkill)=FALSE THEN abort(errCmdConflict,"");END;
            | 37,38,39: IF chkcmd(cmd,substringreplace)=FALSE THEN abort(errCmdConflict,"");END;
            | 40,41,42: IF chkcmd(cmd,strlowercase)=FALSE THEN abort(errCmdConflict,"");END;
            | 43,44,45: IF chkcmd(cmd,struppercase)=FALSE THEN abort(errCmdConflict,"");END;
            | 46,47 : IF chkcmd(cmd,remove)=FALSE THEN abort(errCmdConflict,"");END;
            | 48,49 : IF chkcmd(cmd,remap)=FALSE THEN abort(errCmdConflict,"");END;
            | 50    : IF chkcmd(cmd,strlowercasenoaccents)=FALSE THEN abort(errCmdConflict,"");END;
            | 51    : IF chkcmd(cmd,struppercasenoaccents)=FALSE THEN abort(errCmdConflict,"");END;
            | 52    : IF chksort(sort,bysize)=FALSE THEN abort(errSortConflict,"");END;
            | 53    : IF chkcmd(cmd,renum)=FALSE THEN abort(errCmdConflict,"");END;
                      userenumprefix := FALSE;
            | 54,55 : prefixrenum := TRUE;
            | 56    : DEBUG := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParmOverflow,S); END;
	        Str.Copy(parm[lastparm],S); (* keep original case *)
        END;
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );

    IF kill THEN
        CASE cmd OF
        | prefix: cmd:=prefixkill;
        | suffix: cmd:=suffixkill;
        | infix : cmd:=infixkill;
        END;
    END;

    (* we don't try too hard to protect user from himself ! ;-) *)

    CASE lastparm OF
    | 0 : abort(errSyntax,"");
    | 1 : CASE cmd OF
          | strlowercase,struppercase,
            strlowercasenoaccents,struppercasenoaccents :
              IF NOT(useLFN) THEN abort(errLFNonly,"");END;
              IF kill THEN abort(errNonsense,"-d");END;
          ELSE
              abort(errSyntax,"");
          END;
    | 2 : CASE cmd OF
          | prefix,suffix,prefixkill,suffixkill,infix,infixkill,substringkill:
              IF procext THEN abort(errNonsense,"-e");END;
          | nada, remove:
              IF procext THEN abort(errNonsense,"-e");END;
              cmd:=remove;
          ELSE
              abort(errSyntax,""); (* strlowercase struppercase remap renum substringreplace *)
          END;
    | 3 : CASE cmd OF
          | renum:
              IF kill THEN abort(errNonsense,"-d");END;
              IF procext THEN abort(errNonsense,"-e");END;
          | nada, remap:
              IF kill THEN abort(errNonsense,"-d");END;
              cmd:=remap;
          | substringreplace:
              IF kill THEN abort(errNonsense,"-d");END;
              IF procext THEN abort(errNonsense,"-e");END;
          ELSE
              abort(errSyntax,"");
          END;
    END;

    CASE cmd OF
    | prefix,prefixkill:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF same(str,autonummarker) THEN
            IF cmd = prefixkill THEN abort(errNonsense,"-pp"); END;
            cmd:=prefixautonum;
        ELSE
            IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadPrefix,str);END;
        END;
    | suffix,suffixkill:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF same(str,autonummarker) THEN
            IF cmd=suffixkill THEN abort(errNonsense,"-ss");END;
            cmd:=suffixautonum;
        ELSE
            IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadSuffix,str);END;
        END;
    | remove:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF chkChars(useLFN,FALSE,TRUE,str)=FALSE THEN abort(errBadChar,str);END;
    | remap:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(mapstr ,parm[firstparm+1]);
        Str.Copy(spec   ,parm[firstparm+2]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF metaproc(mapstr)=FALSE THEN abort(errBadMeta,mapstr);END;
        IF Str.Length(str) # Str.Length(mapstr) THEN abort(errBadRemap,"");END;
        IF chkChars(useLFN,FALSE,FALSE,str)=FALSE THEN abort(errBadChar,str);END;
        IF chkChars(useLFN,FALSE,FALSE,mapstr)=FALSE THEN abort(errBadChar,mapstr);END;
        Str.Copy(S,str);
        Str.Copy(R,mapstr);
        UpperCase(S);
        UpperCase(R);
        FOR i:=1 TO Str.Length(S) DO
            IF str[i-1] = mapstr[i-1] THEN abort(errRemapNonsense,"");END;
        END;
    | infix:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadInfix,str);END;
    | infixkill:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadInfix,str);END;
    | renum:
        Str.Copy(mapstr ,parm[firstparm]);   (* prefix *)
        Str.Copy(S      ,parm[firstparm+1]); (* first number *)
        Str.Copy(spec   ,parm[firstparm+2]);
        IF userenumprefix THEN
            IF same(mapstr,ignoredrenumprefix) THEN
                userenumprefix:=FALSE;
            ELSE
                IF metaproc(mapstr)=FALSE THEN abort(errBadMeta,mapstr);END;
                IF chkChars(useLFN,FALSE,FALSE,mapstr)=FALSE THEN abort(errBadChar,mapstr);END;
            END;
        END;
        IF NOT(userenumprefix) THEN mapstr:="";END;
        Str.Concat(R,"-FIX:",S); (* fake option *)
        IF GetLongCard(R,currnum)=FALSE THEN abort(errBadVal,S);END;
    | substringkill:
        Str.Copy(str    ,parm[firstparm]);
        Str.Copy(spec   ,parm[firstparm+1]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadSubstring,str);END;
    | strlowercase,struppercase, strlowercasenoaccents,struppercasenoaccents:
        Str.Copy(spec   ,parm[firstparm]);
    | substringreplace :
        Str.Copy(str    ,parm[firstparm]);    (* oldsubstring *)
        Str.Copy(mapstr ,parm[firstparm+1]);  (* newsubstring *)
        Str.Copy(spec   ,parm[firstparm+2]);
        IF metaproc(str)=FALSE THEN abort(errBadMeta,str);END;
        IF metaproc(mapstr)=FALSE THEN abort(errBadMeta,mapstr);END;
        IF chkValid(useLFN,FALSE,str,base)=FALSE THEN abort(errBadSubstring,str);END;
        IF chkValid(useLFN,FALSE,mapstr,base)=FALSE THEN abort(errBadSubstring,mapstr);END;
    END;

    IF same(spec,dot) THEN spec:=stardotstar;END;
    IF chkValid(useLFN,TRUE ,spec,base)=FALSE THEN abort(errBadSpec,spec);END;

    initList(anchorSpec,lastEntry);
    i:= buildMatchList(anchorSpec,useLFN,processAll,spec);
    IF i=MAX(CARDINAL) THEN abort(errStorage,""); END;
    INC(lastEntry,i);
    IF lastEntry < firstEntry THEN abort(errNoMatch,spec);END;
    initIndexes(anchorSpec);

    IF safety THEN
        FOR i:=firstEntry TO lastEntry DO
            getEntry(S,i,anchorSpec);
            UpperCase(S);
            IF same(S,UNDOBATCH) THEN abort(errWontProcess,"");END;
        END;
        hout:=FIO.Create(UNDOBATCH);
        FIO.AssignBuffer(hout,ioBufferOut);
        FIO.WrStr(hout,"@ECHO ON");FIO.WrLn(hout);
        FIO.WrStr(hout,"PAUSE Hit Ctrl-C or Ctrl-Break to abort !");FIO.WrLn(hout);
    END;

    CASE cmd OF
    | renum:
        Str.Copy(S,padnum(currnum,fieldwidth));
        lc:=currnum+rendelta*LONGCARD(lastEntry-1);
        Str.Copy(R,padnum(lc,fieldwidth));
        IF Str.Length(S) # Str.Length(R) THEN abort(errFieldWidth,"");END;

        IF sort # nosort THEN video(msgWaitSort,TRUE);END;
        CASE sort OF
        | byname      : Lib.QSort(lastEntry,dolessname, doswap);
        | byextension : Lib.QSort(lastEntry,dolessext , doswap);
        | bysize      : Lib.QSort(lastEntry,dolesssize, doswap);
        END;
        IF sort # nosort THEN video(msgWaitSort,FALSE);END;
    | suffixautonum,prefixautonum:
        Str.Copy(S,padnum(currnum,fieldwidth)); (* currnum defaults to 1 at init *)
        lc:=currnum+rendelta*LONGCARD(lastEntry-1);
        Str.Copy(R,padnum(lc,fieldwidth));
        IF Str.Length(S) # Str.Length(R) THEN abort(errFieldWidth,"");END;
    END;

    WrStr(Banner);WrLn;
    WrLn;

    messages:=0;
    FOR i := firstEntry TO lastEntry DO
        getEntry(S,i,anchorSpec);
        Str.Concat(oldname,base,S);
        Str.Copy(newname,S);
        CASE cmd OF
        | renum :
            IF prefixrenum THEN
                Str.Concat(str,padnum(currnum,fieldwidth),mapstr);
            ELSE
                Str.Concat(str,mapstr,padnum(currnum,fieldwidth));
            END;
            INC(currnum,rendelta);
        | suffixautonum:
            Str.Concat(str,autonumsep,padnum(currnum,fieldwidth));
            INC(currnum,rendelta);
        | prefixautonum:
            Str.Concat(str,padnum(currnum,fieldwidth),autonumsep);
            INC(currnum,rendelta);
        END;
        wecandoit := doFix (messages,newname, oldname,
                           useLFN,procext,safety,prefixrenum,DEBUG,
                           cmd,colpos,str,mapstr);
        IF wecandoit THEN
            Str.Prepend(newname,base);
            allowed:=TRUE;
            existed:=FALSE;
            IF fileExists(useLFN,newname) THEN
                IF overwrite THEN
                    IF testmode=FALSE THEN
                        IF isCmdCasify(cmd)=FALSE THEN
                            fileSetRW(useLFN,oldname); (* safety *)
                        ELSE
                            killfile(useLFN,overwrite,oldname); (* erase readonly too *)
                            existed:=TRUE;
                        END;
                    END;
                ELSE
                    IF isCmdCasify(cmd)=FALSE THEN (* LFN agrees to rename changing case *)
                        msg(useLFN,TRUE,msgAlready,oldname);
                        allowed:=FALSE;
                        INC(messages);
                    END;
                END;
            END;
            IF allowed THEN
                IF testmode THEN
                    msg2(useLFN,FALSE,msgWouldBe,oldname,newname);
                    IF existed THEN WrStr(msgFileExists);END;
                    WrLn;
                    INC(messages);
                ELSE
                    IF NOT (same (oldname, newname)) THEN
                        fileRename(useLFN,oldname,newname);
                    END;
                    msg2(useLFN,FALSE,msgIsNow,oldname,newname);
                    IF existed THEN WrStr(msgFileExisted);END;
                    WrLn;
                    INC(messages);

                    IF safety THEN
                        buildUndo(hugestr,useLFN,base,oldname,newname);
                        FIO.WrStr(hout,hugestr);FIO.WrLn(hout);
                    END;
                END;
            END;
        END;
    END;
    IF messages=0 THEN WrStr("::: Nothing to do !");WrLn; END;

    IF safety THEN
        FIO.Close(hout);
        WrLn;WrStr("::: "+UNDOBATCH+" has been created.");WrLn;
    END;

    freeMatchList(anchorSpec);

    abort(errNone,"");
END NewName.

