(* ---------------------------------------------------------------
Title         Q&D Delete but...
Author        PhG
Overview      delete all files but specified ones
Usage         see help
Notes         under Win9X, without any reason, dirbut can freeze with 6000+ files
Wish list     recursion ? ah, we must be joking !
              showdata() with -terse and LFN could be prettier
              an ini file specifying directory to be protected
              against any action (c:\, c:\dos, c:\windows, ...)
              a DIRBAT-like option to allow for date/time and size criteria
              (del all files except dated today or smaller than # ?)
              dirbut sometimes freezes without any reason when run from 9x

Bugs          a quirk : we ask about erasing RO even when useless... so what ?

--------------------------------------------------------------- *)

MODULE DelB;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr,WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str16, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
cleantabs,setReadWrite;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

(* ------------------------------------------------------------ *)

CONST
    cr            = CHR(13);
    lf            = CHR(10);
    dot           = ".";
    dotdot        = dot+dot;
    star          = "*";
    colon         = ":";
    antislash     = "\";
    dash          = "-";
    blank         = " ";
    coma          = ",";
    stardotstar   = "*.*";
    charnull      = 0C; (* CHR(0) *)
CONST
    ProgEXEname   = "DELB";
    ProgTitle     = "Q&D Delete but...";
    ProgVersion   = "v1.1e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errConflict         = 2;
    errUnknownOption    = 3;
    errBadSpec          = 4;
    errTooManyFilesHere = 5;
    errTooManyMatches   = 6;
    errEmptyDirectory   = 7;
    errAborted          = 128;
    errAbortedByUser    = 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = cr+lf;
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [file specification]... [option]..."+nl+
nl+
"  -l[n|e] list files to be deleted (DIRBUT)"+nl+
"  -x[n|e] list files NOT to be deleted (DIRONLY)"+nl+
"  -a      take hidden and system files into account"+nl+
"  -u      display filenames and attributes in uppercase"+nl+
"  -r      delete read-only files"+nl+
"  -d      delete without query"+nl+
"  -t[t]   terse listing (-tt = list with full path)"+nl+
"  -n      sort by name (-l or -x only)"+nl+
"  -e      sort by extension (-l or -x only)"+nl+
"  -v      show program activity (-l or -x only)"+nl+
"  -k      paging (-l or -x only, and ignored if output redirected)"+nl+
"  -f      disable LFN support even if available"+nl+
nl+
"a) Illogical options will be flagged, irrelevant ones will be ignored."+nl+
"b) By design, this command applies to files in current directory ONLY."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errConflict:
        Str.Concat(S,einfo," commands are mutually exclusive !");
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);
        Str.Append(S," option !");
    | errBadSpec:
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," specification !");
    | errTooManyFilesHere :
        (* S := "Storage ALLOCATE() failure !"; *)
        Str.Concat(S,"Too many files in ",einfo);
        Str.Append(S," directory !");
    | errTooManyMatches:
        Str.Concat(S,"Too many files match ",einfo);
        Str.Append(S," specification !");
    | errEmptyDirectory :
        Str.Concat(S,"No files in ",einfo);
        Str.Append(S," directory !");
    | errAborted :
        S := "Aborted by user !";
    | errAbortedByUser:
        S := "Listing aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstEntry = 1; (* 1..count *)
TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next   : ptrToEntry;
        index  : CARDINAL; (* 1.. for sort *)
        slen   : CARDINAL; (* a SHORTCARD would DO fine IN almost all cases  *)
        string : CHAR;     (* here, after other data, because variable length *)
    END;

VAR
    anchorMatching   : ptrToEntry; (* files anchorMatching specifications *)
    anchorCurrent    : ptrToEntry; (* files in anchorCurrent directory *)

PROCEDURE initList (VAR anchor:ptrToEntry; VAR count:CARDINAL);
BEGIN
    count := firstEntry-1; (* complicated way to mean 0 *)
    anchor:= NIL;
END initList;

PROCEDURE getAnchorCurrent (  ):ptrToEntry;
BEGIN
    RETURN anchorCurrent;
END getAnchorCurrent;

CONST
    w9XnothingRequired = FIO.FileAttr{};

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildMatchList (VAR anchor:ptrToEntry;
                          useLFN,hiddensystem : BOOLEAN;spec:pathtype):CARDINAL;
VAR
    S:pathtype; (* some are oversized but safety first ! *)
    newInList : ptrToEntry;
    len,needed,count : CARDINAL;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    IF hiddensystem THEN
        dosattr:=allfiles;
    ELSE
        dosattr := FIO.FileAttr{aR,aA};
    END;

    count:=0;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(dosattr),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,dosattr,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
        ELSE
            Str.Copy(S,DOSentry.Name);
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                IF count=MAX(CARDINAL) THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* too many files but let's fake ALLOCATE failure *)
                len:=Str.Length(S);
                needed:=SIZE(entryType)-SIZE(CHAR)+len;
                IF Available(needed)=FALSE THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* storage ALLOCATE failure *)
                IF anchor=NIL THEN
                    ALLOCATE( anchor,needed);
                    newInList := anchor;
                ELSE
                    ALLOCATE(newInList^.next,needed);
                    newInList :=newInList^.next;
                END;
                Lib.FastMove( ADR(S),ADR(newInList^.string),len);
                newInList^.slen := len;
                newInList^.next := NIL;
                newInList^.index:= 0; (* we'll fill it after we've read all files *)
                INC(count);
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildMatchList;

PROCEDURE freeMatchList (anchor:ptrToEntry);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrToEntry;
BEGIN
    firstInList := anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        len         := CARDINAL(newInList^.slen);
        needed      := SIZE(entryType)-SIZE(CHAR)+len;
        firstInList := firstInList^.next;
        DEALLOCATE (newInList,needed);
        newInList := firstInList;
    END
END freeMatchList;

PROCEDURE findEntry (n:CARDINAL;  anchor:ptrToEntry  ):ptrToEntry;
VAR
    newInList:ptrToEntry;
BEGIN
    newInList := anchor;
    LOOP
        IF newInList = NIL THEN EXIT;END; (* gloups! *)
        IF newInList^.index = n THEN EXIT; END;
        newInList := newInList^.next;
    END;
    RETURN newInList;
END findEntry;

PROCEDURE getEntry (VAR R:pathtype;
                   n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := findEntry(n,anchor);
    IF newInList = NIL THEN RETURN;END;
    len         := newInList^.slen;
    Lib.FastMove( ADR(newInList^.string),ADR(S),len);
    S[len]      := charnull; (* REQUIRED safety ! *)
    Str.Copy(R,S); (* yep, compiler won't let us fill R directly *)
END getEntry;

PROCEDURE doMatch (S:ARRAY OF CHAR;lastmatch:CARDINAL;anchor:ptrToEntry) : BOOLEAN;
VAR
    i : CARDINAL;
    R : pathtype;
BEGIN
    FOR i := firstEntry TO lastmatch DO
        getEntry(R, i,anchor);              (* not the fastest way to scan data ! *)
        IF same(S,R) THEN RETURN TRUE; END;
    END;
    RETURN FALSE;
END doMatch;

PROCEDURE initIndexes (anchor:ptrToEntry );
VAR
    newInList:ptrToEntry;
    i : CARDINAL;
BEGIN
    i := firstEntry;
    newInList:=anchor;
    LOOP
        IF newInList = NIL THEN EXIT; END;
        newInList^.index := i;
        INC(i);
        newInList := newInList^.next;
    END;
END initIndexes;

(* ------------------------------------------------------------ *)

PROCEDURE doswap (i,j:CARDINAL);
VAR
    anchor,pi,pj:ptrToEntry;
    tmp:CARDINAL;
BEGIN
    anchor:=getAnchorCurrent();
    pi:=findEntry(i,anchor);
    pj:=findEntry(j,anchor);
    tmp:=pi^.index;
    pi^.index:=pj^.index;
    pj^.index:=tmp;
END doswap;

PROCEDURE dolessname (i,j:CARDINAL ):BOOLEAN ;
VAR
    SI,SJ: pathtype ;
    anchor:ptrToEntry;
BEGIN
    anchor:=getAnchorCurrent();
    getEntry(SI,i, anchor);
    getEntry(SJ,j, anchor);
    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);
    IF Str.Compare(SI,SJ) < 0 THEN (* -1 is less *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END dolessname;

PROCEDURE dolessext ( i,j:CARDINAL  ):BOOLEAN ;
VAR
    e1,e2:pathtype;
    p : CARDINAL;
    anchor:ptrToEntry;
BEGIN
    anchor:=getAnchorCurrent();
    getEntry(e1,i,anchor);
    getEntry(e2,j,anchor);
    LowerCase(e1); (* ignore accents when sorting *)
    LowerCase(e2);

    p := Str.RCharPos(e1,dot);
    IF p = MAX(CARDINAL) THEN
        e1:="";
    ELSE
        Str.Delete(e1,0,p+1);
    END;
    p := Str.RCharPos(e2,dot);
    IF p = MAX(CARDINAL) THEN
        e2:="";
    ELSE
        Str.Delete(e2,0,p+1);
    END;
    CASE Str.Compare(e1,e2) OF
    | -1 : RETURN TRUE;
    |  0 : RETURN dolessname(i,j);
    |  1 : RETURN FALSE;
    END;
END dolessext;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtFileName ( S : ARRAY OF CHAR ) : str128;
VAR
    p : CARDINAL;
    R : str128;
    i : CARDINAL;
BEGIN
    IF Str.CharPos(S,dot) = MAX(CARDINAL) THEN
        Str.Append(S,dot);
    END;
    p := Str.CharPos(S,dot);
    Str.Slice(R,S,0,p);
    FOR i := 1 TO (8-p) DO
        Str.Append(R,blank);
    END;
    Str.Append(R,dot);
    Str.Delete(S,0,p+1);
    p:=Str.Length(S);
    Str.Append(R,S);
    FOR i := 1 TO (3-p) DO
        Str.Append(R,blank);
    END;
    RETURN R;
END fmtFileName;

PROCEDURE tf (VAR S:ARRAY OF CHAR;flag:BOOLEAN;chTrue,chFalse:CHAR);
BEGIN
    IF flag THEN
        Str.Append(S,chTrue);
    ELSE
        Str.Append(S,chFalse);
    END;
END tf;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str16;
VAR
    S : str16;
BEGIN
    S:="";
    tf(S, (aD IN attr), "D","-");
    tf(S, (aR IN attr), "R","-");
    tf(S, (aH IN attr), "H","-");
    tf(S, (aS IN attr), "S","-");
    tf(S, (aA IN attr), "A","-");
    RETURN S;
END fmtAttr;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtDate (datedata:CARDINAL) : str80;
CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
CONST
    separator = dash;
    paddays=blank;
    pad="0";
    baseyear = 1980;
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    y,m,d : CARDINAL;
    R : str80;
BEGIN
    y := CARDINAL(BITSET(datedata) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(datedata) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(datedata) * ddMask) >> ddShft;

    IF ((m < 1) OR (m > 12)) THEN m := 13; END;
    Str.ItemS(R,tmonths2," ",m-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(d,2,paddays));
    Str.Append(R,separator);
    Str.Append(R,using(baseyear+y,4,pad));
    RETURN R;
END fmtDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE fmtTime (timedata:CARDINAL) : str80;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    separator = colon;
    padhours = blank;
    pad="0";
VAR
    h,m,s : CARDINAL;
    R : str80;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* yes, yes, "* 2" works too... *)
    R := using(h,2,padhours);
    Str.Append(R,separator);
    Str.Append(R,using(m,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(s,2,pad));
    RETURN R;
END fmtTime;

PROCEDURE fmtSize (v : LONGCARD; pad:CHAR; sep:CHAR) : str80;
CONST
    field = 10+3; (* #,###,###,### *) (* 1Gb+ file okay now *)
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok); (* Str.FixRealToStr( LONGREAL(v),0,S,ok); was overkill *)
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE padstr (VAR R : ARRAY OF CHAR;n:INTEGER);
VAR
    i:CARDINAL;
BEGIN
    FOR i:=(Str.Length(R)+1) TO ABS(n) DO
        IF n < 0 THEN
            Str.Prepend(R,blank);
        ELSE
            Str.Append(R,blank);
        END;
    END;
END padstr;

PROCEDURE showdata (S,here:pathtype;useLFN,hiddensystem,lowercase,terse,showpath:BOOLEAN;
                    VAR totalcount:CARDINAL;
                    VAR totalsize:LONGCARD);
CONST
    widos = 8+1+3;
VAR
    foundFile   : BOOLEAN;
    R           : str1024; (* oversized for LFN *)
    str    : str128;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
    u,d,n,e,Sdos:pathtype;
BEGIN
    IF hiddensystem THEN
        dosattr := allfiles;
    ELSE
        dosattr := FIO.FileAttr{aR,aA};
    END;
    IF useLFN THEN
        foundFile:= w9XfindFirst (S,SHORTCARD(dosattr),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
        rc:=w9XfindClose(w9Xhandle,errcode);

        rc:=w9XlongToShort(S,errcode,Sdos);

        foundFile := FIO.ReadFirstEntry(Sdos,dosattr,DOSentry);
        dosattr:=DOSentry.attr;

        Lib.SplitAllPath(Sdos,u,d,n,e);
        Lib.MakeAllPath(Sdos,"","",n,e);
    ELSE
        foundFile := FIO.ReadFirstEntry(S,dosattr,DOSentry);
        dosattr:=DOSentry.attr;
        Str.Copy(Sdos,S);
    END;


    Str.Copy(R, fmtFileName(Sdos) );
    IF lowercase THEN LowerCase(R); END;
    IF terse THEN
        ReplaceChar(R," ","");
    ELSE
        Str.Append(R,"  ");
        Str.Append(R,fmtSize(DOSentry.size,blank,coma));
        Str.Append(R,"  ");
        Str.Append(R,fmtDate(DOSentry.date));
        Str.Append(R,"  ");
        Str.Append(R,fmtTime(DOSentry.time));
        IF hiddensystem THEN
            Str.Copy(str,fmtAttr(dosattr)); IF lowercase THEN LowerCase(str);END;
            Str.Append(R,"  ");
            Str.Append(R,str);
        END;
    END;
    IF useLFN THEN
        Lib.SplitAllPath(S,u,d,n,e);
        IF same(e,"") THEN e:=dot;END;
        Lib.MakeAllPath(S,u,d,n,e);
        IF terse THEN padstr(R,widos);END;
        Str.Append(R,'  "');
        IF (terse AND showpath) THEN Str.Append(R,here); END;
        Str.Append(R,S);Str.Append(R,'"');
    ELSE
        IF (terse AND showpath) THEN Str.Prepend(R,here); END;
    END;
    WrStr(R);WrLn;

    INC(totalcount);
    INC(totalsize,DOSentry.size);
END showdata;

PROCEDURE canWrite (S : ARRAY OF CHAR) : BOOLEAN;
VAR
    D  : FIO.DirEntry;
    rc : BOOLEAN;
BEGIN
    IF FIO.Exists(S)=FALSE THEN RETURN TRUE; END;
    rc := FIO.ReadFirstEntry(S,allfiles,D); (* assume file exists ! *)
    IF (FIO.readonly IN D.attr) THEN RETURN FALSE; END;
    RETURN TRUE;
END canWrite;

PROCEDURE killfile (S:ARRAY OF CHAR;killRO:BOOLEAN;msg:ARRAY OF CHAR);
BEGIN
    IF canWrite(S) THEN
        FIO.Erase(S);
        WrStr(msg);
    ELSE
        IF killRO THEN
            setReadWrite(S);
            FIO.Erase(S);
            WrStr(msg);
            WrStr(" (was Read-only)");
        ELSE
            WrStr("Skipped (is Read-only)");
        END;
    END;
END killfile;

PROCEDURE doDel (R:pathtype;VAR ask:BOOLEAN; useLFN,killRO:BOOLEAN);
CONST
    yes    = "Y";
    no     = "N";
    yesall = "A";
    quit   = "Q";
    cancel = CHR(27);
    nl     = cr+lf;
    msgAborted="Aborted by user !"+nl+nl;
VAR
    key : str2;
    S:str128;
    rc:BOOLEAN;
    errcode:CARDINAL;
    Sdos,u,d,n,e:pathtype;
BEGIN
    IF useLFN THEN
        rc:=w9XlongToShort(R,errcode,Sdos);
        Lib.SplitAllPath(Sdos,u,d,n,e);
        Lib.MakeAllPath(R,"","",n,e);
    END;
    S:=fmtFileName(R); (* dos name *)
    CASE ask OF
    | TRUE:
        WrStr(S);  WrStr(" to be deleted (Y/N/A/Q/Esc) ? ");
        Flushkey;  key := Waitkey();  UpperCase(key);
        IF same(key,yes) THEN
            killfile(S,killRO,"Yes");
        ELSIF same(key,yesall) THEN
            killfile(S,killRO,"All");   ask := FALSE; (* modify *)
        ELSIF same(key,quit) THEN
            WrStr(msgAborted);  abort(errAborted,"");
        ELSIF same(key,cancel) THEN
            WrStr(msgAborted);  abort(errAborted,"");
        ELSE
            WrStr("No");
        END;
        WrLn;
    | FALSE:
        WrStr(S);
        killfile(S,killRO," deleted");
        WrLn;
    END;
END doDel;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getCurrentDirectory (useLFN:BOOLEAN; VAR R : pathtype);
VAR
    drive : SHORTCARD;
    unit  : CHAR;
    rc:BOOLEAN;
    errcode:CARDINAL;
    longform:pathtype;
BEGIN
    drive := FIO.GetDrive();
    unit  := CHR(drive + ORD("A") -1 );
    FIO.GetDir(drive,R); (* \path without trailing slash nor leading u: *)
    Str.Prepend(R,colon);
    Str.Prepend(R,unit); (* u:\path *)
    IF useLFN THEN
        rc:=w9XshortToLong(R,errcode,longform);
        IF rc THEN Str.Copy(R,longform); END;
    END;
    fixDirectory(R);     (* u:\path\ *)
END getCurrentDirectory;

CONST
    msgIncluding   = ", INCLUDING hidden and system files";
    msgIgnoring    = ", ignoring hidden and system files";
    msgToBeDeleted = "Files to be deleted";

PROCEDURE precision (hiddensystem:BOOLEAN);
BEGIN
    IF hiddensystem THEN
        WrStr(msgIncluding);
    ELSE
        WrStr(msgIgnoring);
    END;
    WrLn;
END precision;

PROCEDURE active (verbose:BOOLEAN; cmd:CARDINAL  );
CONST
    msgWait = "::: Working, please wait...";
BEGIN
    IF verbose THEN
        CASE cmd OF
        | cmdInit : video(msgWait,TRUE);
        | cmdStop : video(msgWait,FALSE);
        END;
        Work(cmd);
    END;
END active;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    cmd : (deleteFiles,listIncluded,listExcluded);
    processAll    : BOOLEAN;
    showLowercase : BOOLEAN;
    killReadonly  : BOOLEAN;
    queryDelete   : BOOLEAN;
    terse         : BOOLEAN;
    showpath      : BOOLEAN;
    sort          : (none,byname,byextension);
    paging        : BOOLEAN;
    verbose       : BOOLEAN;
    useLFN        : BOOLEAN;

PROCEDURE initDefaults (  );
BEGIN
    cmd           := deleteFiles;
    processAll    := FALSE;
    showLowercase := TRUE ;
    killReadonly  := FALSE;
    queryDelete   := TRUE;
    terse         := FALSE;
    showpath      := FALSE;
    sort          := none;
    paging        := FALSE;
    verbose       := FALSE;
    useLFN        := TRUE;
END initDefaults;

(* ------------------------------------------------------------ *)

VAR
    parmcount : CARDINAL;
    i,opt : CARDINAL;
    S,R:pathtype;
    inf:str128;
    n,lastMatching,lastCurrent : CARDINAL;
    totalcount : CARDINAL;
    totalsize  : LONGCARD;
    basedir    : pathtype;
CONST
    initpagingcounter = 1; (* account for message *)
    kbdmsg = "Hit (almost) any key to continue or Escape to abort listing : ";
    cancel = CHR(27);
VAR
    vrows  [00040H:0084H] : SHORTCARD; (* add 1 *)
    lastRow               : CARDINAL;
    rowcount              : CARDINAL;
    key                   : str2;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    initDefaults;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "L"+delim+"INCLUDED"+delim+"DIRBUT"+delim+
                                 "X"+delim+"EXCLUDED"+delim+"DIRONLY"+delim+
                                 "U"+delim+"UPPERCASE"+delim+
                                 "R"+delim+"READONLY"+delim+
                                 "D"+delim+"DELETE"+delim+
                                 "T"+delim+"TERSE"+delim+
                                 "N"+delim+"NAME"+delim+
                                 "E"+delim+"EXTENSION"+delim+
                                 "K"+delim+"PAGING"+delim+
                                 "F"+delim+"LFN"+delim+
                                 "TT"+delim+
                                 "A"+delim+"ALLFILES"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "LN"+delim+
                                 "LE"+delim+
                                 "XN"+delim+
                                 "XE"
                              );
            CASE opt OF
            |  1,  2,  3 : abort(errHelp,"");
            |  4,  5,  6 :
                IF cmd = listExcluded THEN abort(errConflict,"-l and -x");END;
                cmd := listIncluded;
            |  7,  8,  9 :
                IF cmd = listIncluded THEN abort(errConflict,"-l and -x");END;
                cmd := listExcluded;
            | 10, 11 : showLowercase := FALSE;
            | 12, 13 : killReadonly := TRUE;
            | 14, 15 : queryDelete := FALSE;
            | 16, 17 : terse := TRUE;
            | 18, 19 :
                IF sort = byextension THEN abort(errConflict,"-n and -e"); END;
                sort := byname;
            | 20, 21 :
                IF sort = byname THEN abort(errConflict,"-n and -e"); END;
                sort := byextension;
            | 22, 23 : paging := TRUE;
            | 24, 25 : useLFN:=FALSE;
            | 26     : terse:=TRUE; showpath:=TRUE;
            | 27, 28 : processAll := TRUE;
            | 29, 30 : verbose := TRUE;
            | 31 : (* -ln *)
                IF cmd = listExcluded THEN abort(errConflict,"-l and -x");END;
                cmd := listIncluded;
                IF sort = byextension THEN abort(errConflict,"-n and -e"); END;
                sort := byname;
            | 32 : (* -le *)
                IF cmd = listExcluded THEN abort(errConflict,"-l and -x");END;
                cmd := listIncluded;
                IF sort = byname THEN abort(errConflict,"-n and -e"); END;
                sort := byextension;
            | 33 : (* -xn *)
                IF cmd = listIncluded THEN abort(errConflict,"-l and -x");END;
                cmd := listExcluded;
                IF sort = byextension THEN abort(errConflict,"-n and -e"); END;
                sort := byname;
            | 34 : (* -xe *)
                IF cmd = listIncluded THEN abort(errConflict,"-l and -x");END;
                cmd := listExcluded;
                IF sort = byname THEN abort(errConflict,"-n and -e"); END;
                sort := byextension;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            ; (* ignore specifications *)
        END;
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );

    initList(anchorMatching,lastMatching);
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            ; (* ignore options *)
        ELSE
            IF Str.CharPos(R,colon) # MAX(CARDINAL) THEN abort(errBadSpec,S);END;
            IF Str.CharPos(R,antislash) # MAX(CARDINAL) THEN abort(errBadSpec,S);END;
            IF same(S,dot) THEN S:=stardotstar;END;
            n:=buildMatchList(anchorMatching,useLFN,processAll,S);
            IF n=MAX(CARDINAL) THEN abort(errTooManyMatches,S); END;
            INC(lastMatching,n);
        END;
    END;

    getCurrentDirectory(useLFN,basedir);

    S:=stardotstar;
    initList(anchorCurrent,lastCurrent);
    n:= buildMatchList(anchorCurrent,useLFN,processAll,S);
    IF n=MAX(CARDINAL) THEN abort(errTooManyFilesHere,basedir); END;
    INC(lastCurrent,n);

    IF lastCurrent = (firstEntry-1) THEN abort(errEmptyDirectory,basedir);END;
    IF showLowercase THEN
        IF NOT(useLFN) THEN LowerCase(basedir); END; (* don't change LFNs case *)
    END;

    initIndexes(anchorMatching);
    initIndexes(anchorCurrent);

    CASE cmd OF
    | deleteFiles:
        WrStr(msgToBeDeleted);
        precision(processAll);
        IF queryDelete THEN
            WrStr("(Y=yes, N=no, A=yes to delete all files, Q or Esc=abort)");
            WrLn;
        END;
    | listExcluded:
        IF NOT(terse) THEN
            WrStr("Files matching specification(s)");
            precision(processAll);
        END;
    | listIncluded:
        IF NOT(terse) THEN
            WrStr("Files NOT matching specification(s)");
            precision(processAll);
        END;
    END;
    IF NOT(terse) THEN WrLn; END;

    CASE cmd OF
    | listExcluded,listIncluded:
        CASE sort OF
        | byname      : Lib.QSort(lastCurrent,dolessname,doswap);
        | byextension : Lib.QSort(lastCurrent,dolessext ,doswap);
        END;
        IF paging THEN
            lastRow  := CARDINAL(vrows)+1; (* 25, 43, 50, etc. *)
            rowcount := initpagingcounter;
            IF IsRedirected() THEN paging:=FALSE;END;
        END;
    END;

    totalcount := 0;
    totalsize  := 0;

    CASE cmd OF
    | listExcluded, listIncluded : active(verbose,cmdInit);
    END;

    FOR i := firstEntry TO lastCurrent DO
        getEntry(S, i,anchorCurrent);
        CASE cmd OF
        | deleteFiles:
            IF doMatch(S,lastMatching,anchorMatching)=FALSE THEN
                doDel(S,queryDelete,useLFN,killReadonly);
            END;
        | listExcluded:
            IF doMatch(S,lastMatching,anchorMatching) THEN
                active(verbose,cmdStop);
                showdata(S,basedir,useLFN,processAll,showLowercase,terse,showpath,totalcount,totalsize);
                IF paging THEN
                    INC(rowcount);
                    IF rowcount >= lastRow THEN (* = is enough but who knows what evil lurks in the heart of BIOS *)
                        rowcount := initpagingcounter;
                        video(kbdmsg,TRUE);
                        Flushkey;
                        key:=Waitkey();
                        video(kbdmsg,FALSE);
                        IF same(key,cancel) THEN abort(errAbortedByUser,"");END;
                    END;
                ELSE
                    IF ChkEscape() THEN abort(errAbortedByUser,"");END;
                END;
                active(verbose,cmdInit);
            ELSE
                active(verbose,cmdShow);
            END;
        | listIncluded:
            IF doMatch(S,lastMatching,anchorMatching)=FALSE THEN
                active(verbose,cmdStop);
                showdata(S,basedir,useLFN,processAll,showLowercase,terse,showpath,totalcount,totalsize);
                IF paging THEN
                    INC(rowcount);
                    IF rowcount >= lastRow THEN (* = is enough but who knows what evil lurks in the heart of BIOS *)
                        rowcount := initpagingcounter;
                        video(kbdmsg,TRUE);
                        Flushkey;
                        key:=Waitkey();
                        video(kbdmsg,FALSE);
                        IF same(key,cancel) THEN abort(errAbortedByUser,"");END;
                    END;
                ELSE
                    IF ChkEscape() THEN abort(errAbortedByUser,"");END;
                END;
                active(verbose,cmdInit);
            ELSE
                active(verbose,cmdShow);
            END;
        END;
    END;

    CASE cmd OF
    | listExcluded, listIncluded : active(verbose,cmdStop);
    END;

    CASE cmd OF
    | listExcluded,listIncluded:
        IF NOT(terse) THEN
            IF totalcount # 0 THEN WrLn; END;
            IO.WrCard(totalcount,4);
            WrStr(" file");
            CASE totalcount OF
            | 0,1 :
                WrStr(" ");
            ELSE
                WrStr("s");
            END;
            WrStr("    ");
            Str.Copy(inf, fmtSize(totalsize,blank,coma) );
            WrStr(inf);
            WrStr(" byte");
            IF totalsize > 1 THEN
                WrStr("s");
            END;
            WrLn;
        END;
    END;
    freeMatchList(anchorMatching);
    freeMatchList(anchorCurrent);

    abort(errNone,"");
END DelB.


