(* ---------------------------------------------------------------
Title         Q&D DD
Author        who cares ?
Overview      see help
Usage         see help
Notes         beware of names containing "$" and fsize > 4Gb
              probably the highest number of options to parse

              cosmetic quirk : paging option does not care about
              lines longer than screen width
              well... quirk : we never care about V attribute
              (useful for DIRWEIRD only anyway)

              a syntax quirk we'll fix for user safety :
              nuking "." with /zz obviously removes current dir and yes,
              it's legal and logical, though it's not a good idea
              (even m$ deltree does not do that because it parses "." as ".\*" )
              now, any "." spec changes -zz to -z ; any ".." forces abort

              don't try xlarge model : we get isl352 dynamic pool error !
              damn : "dynamic pool limit" strikes again just by seperating two statements !
              we had to move some inline code to external procs
              zut, I want a newer M2 compiler ! :-(
              (and no, NOT the XDS quirkrap)

              too much code : compact is no longer enough...

              coloring IS logical : if we define only ink, well...
              paper can change, etc. (see /fd definition)

              yep, we've finally merged dd.ini and dd.dat
              though (lack of) speed (ahem) will suffer (lazy liar)
              and now we can override more global settings

              quirk : multiunits filefind is very memory hungry
              and at least for now, we really don't feel like fixing this
              with a clever dir storage scheme
              now, if xds was not useless crap, or gnu-m2 was not unix-only... ;-)

              we could use "" (mu) as an escape char

              we use SHA-1 here

              -mem -fake is UNWISE and therefore UNDOCUMENTED ;-)

              "dir ???" does NOT find 118.htm WHILE "dir ???????" does :
              as DD storeFiles() uses the same LFN findFirst, it does the same

Bugs          under XP, crash when recursively allocating subdirs
              (with /lfn, farheapdeallocate error)
              oddly enough, no problem with 9x while processing
              approximately the same number of dirs
              seems it has to do with mad XP tree depth :
              seemingly fixed by increasing stack size from 24576 to 32767

              yet another TS one : 254C does not give CHR(254) !

              dd /ad+ /f:$u$d does not show dirnames !
              $d should always include $f for directories !
              C:\Z\foo.bar   DIR
              C:\Z\foobar.   DIR
              C:\Z\test.     FILE

Wish List
              more formats ? alignments ?
              execute format as a command the WITH way ? nope, rewrite WITH instead
              try and build enhanced WITH with appropriate compilation directives ?

              what about deleting R+ directories ?
              (interactive) gotodir in filefind mode ? best left to C utility
              include ATTRIB function ?

              a cleaner buildDirList() ?
              (storing indexes of each parent dir as to waste less RAM)

              add free space to final report ? eh, what if different units ? or worse : XP !
              look into archives ? best left to DIRBAT

              we know where and how to fix for filefind parsing fix "cdef:foobar"
              but for now we're too busy... ahem, lazy to do it
              partially done but we should not restore an arbo already in memory
              in another life perhaps ?

              a multiline compact display ? in yet another non-life perhaps...

              should /fd default to /adx ?
              (last mask would win, instead of flagging conflicts)

              fix $u$d problem for directories...
              (should be $u$f if directory)

--------------------------------------------------------------- *)

MODULE DD;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT IO;
IMPORT DOSErr;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available,HeapTotalAvail,MainHeap;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_Text IMPORT
colortype, cursorshapetype, scrolltype,
ff, cr, lf, bs, tab, nl, mincolor, maxcolor,
BW40, CO40, BW80, CO80, CO80x43, CO80x50, MONO,
vesa80x60, vesa132x25, vesa132x43, vesa132x50, vesa132x60,
selectCursorEmulation,
setCursorShape,
handleVesa, setBrightPaper, setBlinkMode,
setFillChar, setFillInk, setFillPaper,
setFillInkPaper, setTxtInk, setTxtPaper, setTxtInkPaper, setWrapMode,
setUseBiosMode, setTabWidth, getScreenData, setWindow,
setMode, restoreMode,
gotoXY, xyToHtabVtab, home, setVisualPage, setActivePage,
scrollWindow, fillTextAttr, cls, writeStr, writeLn, getScreenWidth,
getScreenHeight, getScreenMinX, getScreenMinY, getScreenMaxX, getScreenMaxY,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getUseBiosMode,
getMinHtab, getMaxHtab, getMinVtab, getMaxVtab, getHtab, getVtab,
getWindowWidth, getWindowHeight,
initScreenConsole,
findInkPaperAtStartup, getInkAtStartup, getPaperAtStartup,
setFullScreenWindow, gotoFullScreenXY;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

FROM QD_MD5 IMPORT MD5str, MD5digestType,
MD5toString, stringToMD5, ComputeMD5;

FROM QD_SHA IMPORT SHAstr, SHAdigestType,
SHAtoString, stringToSHA, ComputeSHA;

FROM QD_CRC IMPORT ComputeCRC32, ComputeCRCval, setSigmaUse,
SegmentFileComputeCRC32;

(* ------------------------------------------------------------ *)

CONST
    CHKSUMS = TRUE; (* enable/disable MD5 / SHA / CRC32 tokens *)
    FIXCHKFIXSPEC = TRUE; (* v1.1g *)
CONST
    (* aliases for our own procedures *)
    WrStr ::= writeStr;
    WrLn  ::= writeLn;
    WrChar::= writeStr;

CONST
    defaultink  = white;
    defaultpaper= black;

PROCEDURE colorhelp (  );
BEGIN
    setTxtInk(getInkAtStartup());      (* was green *)
    setTxtPaper(getPaperAtStartup());  (* was black *)
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END colorhelp;

PROCEDURE color (ink,paper:CARDINAL );
BEGIN
    setTxtInk   (VAL(colortype,ink));
    setTxtPaper (VAL(colortype,paper));
    setFillInkPaper(getInkAtStartup(),getPaperAtStartup());
END color;

(* ------------------------------------------------------------ *)

CONST
    (* must be lowercasealt *)
    fSwapWin92    = "386spart.par";
    fSwapWin98    = "win386.swp";
    fSwapWinXP    = "pagefile.sys";
    patSwapWin92  = "*\"+fSwapWin92;
    patSwapWin98  = "*\"+fSwapWin98;
    patSwapWinXP  = "*\"+fSwapWinXP;
CONST
    colon         = ":";
    dot           = ".";
    nullchar      = 0C;
    charnull      = nullchar;
    dotdot        = dot+dot;
    dquote        = '"';
    blank         = " ";
    coma          = ",";
    comaFR        = dot;
    comaUS        = coma;
    dash          = "-";
    underscore    = "_";
    percent       = "%";
    dollar        = "$";
    semicolon     = ";";
    pound         = "#";
    question      = "?";
    exclamation   = "!";
    equal         = "=";
    slash         = "/";
    star          = "*";
    openbracket   = "[";
    closebracket  = "]";
    echap         = CHR(27);
    tabchar       = CHR(9);
CONST
    sectionColors      = openbracket+"Colors"+closebracket;
    sectionProtected   = openbracket+"Protected"+closebracket;
    sectionNotProtected= openbracket+"NotProtected"+closebracket;
    dataProtection     = 0;
    dataColors         = 1;
CONST
    extEXE        = ".EXE";
    extINI        = ".INI";
    extLST        = ".LST";
    sFake         = ";-) ";        (* prefix *)
    strSUBDIR     = "<DIR>";
    strSUBDIRECTORY = "<DIRECTORY>";

    strRptlookingfor="::: Scanning ~: for ~ ...";
    strRptmatches   = "::: ~ matching file(s) found, taking ~ byte(s).";
    strRptnomatch   = "::: No match found.";
    strRptfiles     = "::: ~ file(s) found, taking ~ byte(s).";
    strRptdirsToo   = "::: ~ file(s) and ~ dir(s) found, taking ~ byte(s).";
    strRptdirsOnly  = "::: ~ dir(s) found.";

    strRptdel     = "::: ~ file(s) processed, ~ file(s) deleted, ~ byte(s) freed.";
    strRpttree    = "::: ~ file(s) processed, ~ file(s) deleted, ~ byte(s) freed.";

CONST
                  (* "123456789012345" *)
    sDelRO         = "+++ Deleted RO ";
    sSkipRO        = "::: Skipped RO ";
    sDel           = "+++ Deleted rw ";
    sIgnored       = "::: Ignored    ";
    sNotFound      = "--- Not found  ";
    sKeptRO        = "::: Kept RO    ";
    sKeptRW        = "::: Kept rw    ";
    sProtectedDir  = "::: PROTECTED "; (* uppercase for dirs *)
    sProtectedFile = "::: Protected ";
CONST
    (* sEmptiedDir = "+++ Emptied   "+strSUBDIR+" "; was misleading if files were left *)
    sSkippedDir    = "::: <DIR> skipped   ";
    sProcessedDir  = "+++ <DIR> processed ";
    sRemovedDir    = "+++ <DIR> removed   ";
    sLeftDir       = "--- <DIR> PROBLEM ! "; (* failure to perform requested op *)
    sNotDir        = "--- <DIR> is a file "; (* deltree *)
    sDNF           = "--- <DIR> not found "; (* deltree *)
    sDIRheader     = "::: <DIR> ";
CONST
    msgProcessing        = "Processing ~ ..."; (* was scanning but as it may be a filespec... *)
    msgProcessingRecurse = "Recursively processing ~ ..."; (* was scanning but as it may be a filespec... *)
    msgWorking     = "Working, please wait...";
    msgSortingDirs = "Sorting, please wait...";
    msgSortingFiles= "Sorting, please wait...";
    msgNoRemrootHere="::: -zz was changed to -z for user safety.";
CONST
    (* sDefaultPat   = "$z $a $t $l $c"; *)                   (* never /ff !  *)

    sDefaultPat     = "a$z  f$a  e$t  c$l  b$c";
    sDirPat         = "^1f$g^^  a$i  ^4e$j  c$v^^  b$f";   (* /fd : /g /j /q *)
    sTersePat       = "a$i  ^4e$w  c$l^^  b$c";              (* /ft *)

    sSumPat         = "$$^5$k^^  a$i  ^4e$j^^  b$f";       (* /fc : /g /q *)
    sMD5digestPat   = "$$^4e$m^^  b$f";                     (* /fm : /g /q *)
    sSHAdigestPat   = "$$^4e$s^^  b$f";                     (* /fs : /g /q *)

    sListPat        = "$c";                                   (* /fl *)
    sFilesPat       = "$f";                                   (* /fv : /q *)
CONST
    minProtected    = 1;
    maxProtected    = 50;    (* at least 3 ! *)
    strMaxProtected = "50";
    minUserColor    = 1;
    maxUserColor    = 64;
    strMaxUserColor = "64";
CONST
    (* no more letters available ! *)
    cZ        = "z";
    cI        = "i";
    cA        = "a";
    cH        = "h";
    cT        = "t";
    cJ        = "j";
    cU        = "u";
    cD        = "d";
    cB        = "b";
    cN        = "n";
    cE        = "e";
    cF        = "f";
    cC        = "c";
    cQ        = "q";
    cX        = "x";
    cY        = "y";
    cS        = "s";
    cG        = "g";
    cM        = "m";
    cK        = "k";
    cO        = "o";
    cR        = "r";
    cW        = "w";
    cV        = "v";
    cL        = "l";
    cPERCENT  = "p";
    cCRLF     = underscore;
    cDOLLAR   = dollar;
    cPOUND    = pound;
    cQUESTION = question;
    cEXCLAM   = exclamation;
CONST
    escink              = "";     (* uncommon, was "degree" *)
    escinkhex           = "$f9";
    inkdefault          = escink;
    inkPop              = CHR(254);    (* uncommon *)
    inkPush             = CHR(255);
    fmtResetDefaultInk  = escink+inkdefault;
    fmtInkRestore       = escink+inkPop;
    fmtInkSave          = escink+inkPush;
CONST
    escpaper            = "^";     (* uncommon too *)
    escpaperhex         = "$5e";
    paperdefault        = escpaper;
    paperPop            = CHR(254);    (* uncommon *)
    paperPush           = CHR(255);
    fmtResetDefaultPaper= escpaper+paperdefault;
    fmtPaperRestore     = escpaper+paperPop;
    fmtPaperSave        = escpaper+paperPush;
CONST
    escch       = dollar;
    fmtZ        = escch+cZ;
    fmtI        = escch+cI;
    fmtA        = escch+cA;
    fmtH        = escch+cH;
    fmtT        = escch+cT;
    fmtJ        = escch+cJ;
    fmtU        = escch+cU;
    fmtD        = escch+cD;
    fmtB        = escch+cB;
    fmtN        = escch+cN;
    fmtE        = escch+cE;
    fmtF        = escch+cF;
    fmtC        = escch+cC;
    fmtQ        = escch+cQ;
    fmtX        = escch+cX;
    fmtY        = escch+cY;
    fmtS        = escch+cS;
    fmtG        = escch+cG;
    fmtM        = escch+cM;
    fmtK        = escch+cK;
    fmtO        = escch+cO;
    fmtR        = escch+cR;
    fmtW        = escch+cW;
    fmtV        = escch+cV;
    fmtL        = escch+cL;
    fmtCRLF     = escch+cCRLF;
    fmtPERCENT  = escch+cPERCENT;
    fmtDOLLAR   = escch+cDOLLAR;
    fmtPOUND    = escch+cPOUND;
    fmtQUESTION = escch+cQUESTION;
    fmtEXCLAM   = escch+cEXCLAM;
CONST
    initpagingcounter = 1; (* account for message *)
    kbdmsg = "Hit (almost) any key to continue or Escape to abort listing : ";
    strY   = "yes";
    strN   = "no";
TYPE
    casifyType = (orgcase,uppercase,lowercase);
    attrstatetype = (dontcare,required,unwanted);
    masktype = RECORD (* D R H S A *)
        stateD,stateR,stateH,stateS,stateA : attrstatetype;
    END;
CONST
    firstattr      = 1;
    lastattr       = 5;
    allowedAttr    = "DRHSA"; (* 1..5 *)
CONST
    fakeoption     = "QD=";
    showdirstoo    = fakeoption+"D?";
    showdirsonly   = fakeoption+"D+";
    showfilesonly  = fakeoption+"D-";

(* ------------------------------------------------------------ *)

CONST
    progEXEname   = "DD";
    progTitle     = "Q&D xDir xDel xDeltree";
    progVersion   = "v1.1n"
(*%T CHKSUMS  *)
    ;
(*%E  *)
(*%F CHKSUMS  *)
    +"-";         (* show it's not memory hungry version, eh eh... *)
(*%E  *)
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
    sDDfmtEnv     = progEXEname+"FMT"; (* uppercase *)
    sDDenv        = progEXEname;    (* should match progEXEname defined infra *)

CONST
    errNone                = 0;
    errHelp                = 1;
    errOption              = 2;
    errParameter           = 3;
    errMode                = 4;
    errNetSlash            = 5;
    errPhantomUnit         = 6;
    errBadUnit             = 7;
    errColon               = 8;
    errNoParent            = 9;
    errInnerParent         = 10;
    errDirJoker            = 11;
    errStorage             = 12;
    errMissingSpec         = 13;
    errListSyntax          = 14;
    errListJoker           = 15;
    errListNotFile         = 16;
    errListNotFound        = 17;
    errJokerEntry          = 18;
    errKillThemAll         = 19;
    errNonsenseCmd         = 20;
    errNonsenseListMode    = 21;
    errNonsenseDelMode     = 22;
    errNonsenseDeltreeMode = 23;
    errNonsenseDirMode     = 24;
    errMoreHelp            = 25;
    errSection             = 26;
    errCasify              = 27;
    errBadEnv              = 28;
    errSizeRange           = 29;
    errDateRange           = 30;
    errMask                = 31;
    errEntryNotFound       = 32;
    errEntryIsFile         = 33;
    errMaskRedefined       = 34;
    errMaskSetting         = 35;
    errMaskOne             = 36;
    errFF                  = 37;
    errSort                = 38;
    errFormatRedefined     = 39;
    errEvenMoreHelp        = 40;
    errDotdot              = 41;
    errTooManyEntries      = 42;
    errTooManyColors       = 43;
    errBadColorDef         = 44;
    errInkPaper            = 45;
    errInkEsc              = 46;
    errPaperEsc            = 47;
    errColorEsc            = 48;
    errColorCode           = 49;
    errParameterFF         = 50;
    errGhostEntry          = 51;
    errJokerGhost          = 52;

    errUnexpectedWhatData  = 64;  (* cannot happen *)

    errNoFileMatchFound    = 128; (* not an error *)

    errAborted             = 255;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str;
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    END message;

CONST
    placeholder = "~";
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=
Banner+nl+
nl+
"Syntax 1 : "+progEXEname+" [[-d]|<-f>] <filespec>... [option]..."+nl+
"Syntax 2 : "+progEXEname+" <-k|-z[z]> <filespec>... [option]..."+nl+
"Syntax 3 : "+progEXEname+" <-@> <[@]filelist["+extLST+"]> [option]..."+nl+
nl+
"-d[?][?]  list entries (default, -dd = -d -m:D!, -ddd = -dds = -d -m:D! -s)"+nl+
"-f[f]     list matching files (-s -c forced, <[u:]filename> format required)"+nl+
"-k[y]     delete files (-ky = -k -y)"+nl+
"-z[e][y]  delete files then remove empty subdirectories except <filespec> root"+nl+
'-zz[e][y] same as -z but removing <filespec> root (note any "." forces -z)'+nl+
"-e        do not delete files, just remove empty subdirectories (-z[z] only)"+nl+
"-@        assume parameter is a list of files to be deleted (-k forced)"+nl+
"-s        recurse subdirectories (forced with -z[z])"+nl+
'-f<:$|?>  format (def="'+sDefaultPat+'") or predefined ([dtcmslv])'+nl+
"-i        inverse selection (-s not recommended, one <filespec> recommended)"+nl+
"-r|-o     delete read-only files"+nl+
"-n        do not prompt before deleting each file or directory"+nl+
"-y        really delete files and subdirectories (default is preview/test mode)"+nl+
"-t|-y-    reset preview/test mode"+nl+
"-c[c]     show final statistics (-cc = do not list files)"+nl+
"-v[v]     show parameters (-vv = show parameters and terminate)"+nl+
"-p[p][-]  paging (-d only, ignored if output redirected, -p- = disable paging,"+nl+
"          -pp[-] = -p[-] but dividing screen count of rows by 2)"+nl+
"-x|-a     ignore existing "+progEXEname+extINI+" (-x = protection, -a = colors)"+nl+
"-swaps    do not default to swapfiles protection"+nl+
'          ("'+patSwapWin92+'", "'+patSwapWin98+'" and "'+patSwapWinXP+'")'+nl+
"-w        warn about files without match instead of silently ignoring them (-d)"+nl+
"-s<?>[-]  sort listing (-sn = name, -sz = size, -sd = date, -se = extension)"+nl+
"-j|-u     force lower (-j) or upper (-u) case (-d only)"+nl+
'-&        use "'+comaUS+'" coma as number separator (default is "'+comaFR+'" dot)'+nl+
"-g[g]     directory header (-gg = display even without any <filespec>... match)"+nl+
'-d:$      filter according to specified "lower[:|..]upper" date range'+nl+
'          ("*"=today, "$"=same date, ":$"=before or on, "$:"=on or after)'+nl+
'-z:$      filter according to specified "lower[-|:|..]upper" size range'+nl+
'          ("#"=same size, ":#"=size less or equal, "#:"=size equal or more)'+nl+
"-m:$      filter according to specified attributes (<"+allowedAttr+">[-|+|?|!|x]...)"+nl+
"-a<?>[?]  set individual attribute filter (<"+allowedAttr+">[-|+|?|!|x])"+nl+
"-b        monochrome BIOS output (no color)"+nl+
"-xdir[s]  shortcut for -d -c -m:D! [-s]"+nl+
"-xdel[s]  shortcut for -k -n -r -c [-s]"+nl+
"-deltree  shortcut for -z -n -r -c"+nl+
"-!        filter files using operating system jokers (see infra)"+nl+
"-q        force LFN enclosing with double quotes for $d, $b, $n, $e, $f, $y"+nl+
"-$        disable ESCape polling (may be necessary with Win9X/WinXP)"+nl+
"-l        disable LFN support even if available"+nl+
"-m        do not beep on unexpected choice"+nl+
(* "-mem      ignore any Storage.ALLOCATE() error (unwise !)"+nl+ *)
"-??[?]    (even) more help (to be read at least once !)"+nl+
nl+
(* "Examples : "+progEXEname+' c:\*.* /s /m:H+S+D? /f:"LFN : $c$_DOS : $x"'+nl+ *)
(* "           "+progEXEname+" c:\tmp /z /r /y"+nl+ *)
(* "           "+progEXEname+" c:\*.c c:\*.cpp /s /r /k /y"+nl+ *) (* too bad, I loved this one ;-) *)
"Example : "+progEXEname+' c:\ d:\ e:\ f:\ /s /d:* /f:"copy $c g:\z" > g:\z\today.bat'+nl;

    msgmorehelp = nl+
'a) When in preview mode, each operation has "'+sFake+'" prefix as a reminder.'+nl+
'b) -y option can be set as default with '+sDDenv+'=Y environment variable ;'+nl+
"   preview mode can still be reset from command line with -t or -y- options."+nl+
'c) Without -! option, "?" and "*" jokers do NOT work the DOS or Win9X way :'+nl+
'   "?" matches exactly one character, "*" matches any sequence of characters.'+nl+
"d) Jokers are not allowed in directory part of <filespec>, nor in a list."+nl+
"e) Up to "+strMaxProtected+" entries (M2 jokers supported) may be protected against deletion,"+nl+
"   if they are specified in "+progEXEname+extINI+" file located in executable directory."+nl+
"   If such a file does not exist, these entries are protected by default :"+nl+
'   "'+patSwapWin92+'", "'+patSwapWin98+'" and "'+patSwapWinXP+'".'+nl+
"   Note protection is supported by -k and -z[z] options ONLY :"+nl+
"   files deleted from a list (-@ option) are NOT protected by this feature."+nl+
"f) Up to "+strMaxUserColor+" extension colors may be user-defined in "+progEXEname+extINI+" file"+nl+
'   located in executable directory. Format is ".extension='+escink+'?'+escpaper+'?".'+nl+
"g) String -f:$ format may be predefined using "+sDDfmtEnv+'="$" environment variable.'+nl+
'h) For safety, -m:$ option should be defined for each of "'+allowedAttr+'" attributes.'+nl+
(* "   Please note -f, -k and -z[z] options force D- attribute."+nl+ *)
"   [-]=off, [][+]=on, [?][!][x]=on or off. -f, -k and -z[z] options force D-."+nl+
'i) With -f[f] option, each "[u:]filename" <filespec> becomes "[u:]\filename",'+nl+
'   and ".*" is appended to any legal <filespec> without an extension (128=FNF).'+nl+
(* "   Return code is 128 if no matching file was found."+nl+ *)
"j) Case-insensitive sort is global for directories but local for files."+nl+
"k) Undocumented -- option forces a terser display while processing files."+nl+
"l) "+placeholder+nl+
"   "+placeholder+nl+
nl+
"Tokens allowed in list mode format are :"+nl+
nl+
fmtI+"|"+fmtZ            +'        raw or formatted filesize, or "'+strSUBDIRECTORY+'"'+nl+
fmtA                  +"           file attributes"+nl+
fmtT+"|"+fmtJ+"|"+fmtW      +"     file date (dd-MMM-yyyy, dd-mm-yyyy or yyyy-mm-dd)"+nl+
fmtH+"|"+fmtO+"|"+fmtL+"|"+fmtV+'  file time (hh:mm:ss or hh:mm, hh being padded with "'+blank+'" or "0")'+nl+
fmtU                  +"           unit"+nl+
fmtD+"|"+fmtB            +'        directory with or without trailing "\"'+nl+
fmtN                  +"           file"+nl+
fmtE                  +"           extension"+nl+
fmtF                  +"           file.extension"+nl+
fmtR+"|"+fmtG            +"        right-aligned or left-aligned file.extension forced to DOS format"+nl+
fmtC                  +"           shortcut for "+fmtU+fmtD+fmtF+" (enclosed with double quotes if LFN)"+nl+
fmtX                  +"           shortcut for "+fmtU+fmtD+fmtF+" (forced to DOS format)"+nl+
fmtY                  +"           shortcut for "+fmtU+fmtD+" (files)"+" or "+fmtU+fmtD+fmtF+" (directories)"+nl+
fmtPOUND              +"           auto-incremented ##### decimal number starting from 00001"+nl+
fmtQUESTION           +'           auto-incremented ???? string starting from "AAAA"'+nl+
(*%T CHKSUMS  *)
fmtM                  +"           MD5 digest (Win<92|98|XP> swapfiles automagically skipped)"+nl+
fmtS                  +"           SHA-1 digest (Win<92|98|XP> swapfiles files automagically skipped)"+nl+
fmtK                  +"           CRC32 value (Win<92|98|XP> swapfiles files automagically skipped)"+nl+
(*%E  *)
"("+fmtQ+" = double quote, "+fmtCRLF+" = newline, "+
    fmtPERCENT+" = percent, "+fmtDOLLAR+" = dollar, "+fmtEXCLAM+" = tabulation)"+nl+
nl+
"Use of $q token is highly recommended in order to avoid unexpected side effects"+nl+
"(only $c token automagically encloses LFN with double quotes ;"+nl+
"-q option is required to force this behavior for $d|$b|$n|$e|$f|$y tokens)."+nl;

    msgevenmorehelp = nl+
"Color tokens allowed in list mode format are :"+nl+
nl+
'  Sequence "'+escink+'[0..f]" changes ink, sequence "'+escpaper+'[0..f]" changes paper.'+nl+
'  Sequence "'+fmtResetDefaultInk+'" resets default ink, sequence "'+fmtResetDefaultPaper+'" resets default paper.'+nl+
"  Dark (0=black, 1=blue, 2=green, 3=cyan, 4=red, 5=magenta, 6=brown, 7=gray)"+nl+
"  Bright (8=gray, 9=blue, a=green, b=cyan, c=red, d=magenta, e=yellow, f=white)"+nl+
nl+
"Here is an example of "+progEXEname+extINI+" file :"+nl+
nl+
"   "+sectionProtected+nl+
nl+
"   ; These entries will be protected against /k and /z[z] but NOT against /@."+nl+
"   ; M2 jokers are allowed :"+nl+
'   ; "?" matches exactly one character, "*" matches any sequence of characters.'+nl+
"   ; Entries may be enclosed with double quotes if necessary."+nl+
(* nl+ *)
'   ; Swap files should always be protected against "delete" commands :'+nl+
"   ; the One and Golden Rule of Indifference should always rule."+nl+
nl+
"   "+patSwapWin92+nl+
"   "+patSwapWin98+nl+
"   "+patSwapWinXP+nl+
nl+
"   ?:\"+nl+
"   c:\dos\*"+nl+
'   "c:\windows\*"'+nl+
'   "*\index.dat"'+nl+
"   *\desktop.ini"+nl+
'   "?:\program files\*"'+nl+
nl+
"   "+sectionNotProtected+nl+
nl+
"   ; These entries will NOT be protected whatever "+sectionProtected+" section contains."+nl+
nl+
"   c:\windows\temp\*"+nl+
"   *.c"+nl+
"   *.cpp"+nl+
nl+
"   "+sectionColors+nl+
nl+
'   ; "'+escink+'" = '+escinkhex+' = trma (may look like a dot), "'+escpaper+'" = '+escpaperhex+' = accent circonflexe.'+nl+
nl+
'   ".exe='+escpaper+'1"'+nl+
"   .com="+escpaper+"1"+nl+
"   .bat="+escpaper+"1"+nl+
"   .zip="+escink+"d"+nl+
"   .arj="+escink+"d"+nl+
"   .dll="+escpaper+"2"+escink+"a"+nl+
"   .vxd="+escpaper+"2"+escink+"a"+nl;

VAR
    S : str1024;
    SS: str4096; (* should do *)
BEGIN
    colorhelp;
    CASE e OF
    | errHelp,errMoreHelp,errEvenMoreHelp :
        WrStr(msghelp);
        IF e # errHelp THEN
            Str.Copy(SS,msgmorehelp);

            (* now tell user about DD.INI *)

            Lib.ParamStr(S,0); (* retrieve executable location : yes, we assume it ! *)
            Str.Caps(S); (* safety *)
            Str.Subst(S,extEXE,extINI);

            IF FIO.Exists(S) THEN
                S:=progEXEname+extINI+" was found in executable directory :";
                Str.Subst(SS,placeholder,S);
                S:="protection against deletion is available for its entries (unless -x).";
            ELSE
                S:=progEXEname+extINI+" was NOT found in executable directory :";
                Str.Subst(SS,placeholder,S);
                S:="protection against deletion is limited to swapfiles (unless -swaps).";
            END;
            Str.Subst(SS,placeholder,S);
            WrStr(SS);
            IF e = errEvenMoreHelp THEN
                WrStr(msgevenmorehelp);
            END;
        END;
        e:=errHelp;
    | errOption :     msg3(S, "Illegal ",einfo," option !");
    | errParameter :  msg3(S, einfo," is one parameter too many"," !");
    | errMode :       S:="-d, -k and -z[z] commands are mutually exclusive !";
    | errNetSlash:    msg3(S, 'Illegal server "\\" in "',einfo,'" specification !');
    | errPhantomUnit: msg3(S, 'Unavailable unit in "',einfo,'" specification !');
    | errBadUnit:     msg3(S, 'Illegal unit in "',einfo,'" specification !');
    | errColon:       msg3(S, 'Unexpected ":" in "',einfo,'" specification !');
    | errNoParent:    msg3(S, 'Unresolvable ".." in "',einfo,'" specification !');
    | errInnerParent: msg3(S, 'Illegal ".." in "',einfo,'" specification !');
    | errDirJoker:    msg3(S, 'Illegal "',einfo,'" directory joker(s) !');
    | errStorage:     msg3(S, 'Storage.ALLOCATE() failure while processing "',einfo,'" specification !');
    | errMissingSpec: S:="No filespec was specified !";
    | errListSyntax:  S:="-@ option or @filespec format will not handle more than one list !";
    | errListJoker:   S:="-@ option or @filespec format will not handle jokers !";
    | errListNotFile: S:="-@ option or @filespec format will not handle a directory !";
    | errListNotFound:msg3(S, '"',einfo,'" list does not exist !');
    | errJokerEntry:  S:="Specified list contains at least one illegal entry !";
    | errKillThemAll: msg3(S, '-z[z] option expects "*.*" in "',einfo,'" specification !');
    | errNonsenseCmd: S:="-@, -z[z] and -d options are mutually exclusive !";
    | errNonsenseListMode:   msg3(S,einfo," option is a nonsense with -@ option"," !");
    | errNonsenseDelMode :   msg3(S,einfo," option is a nonsense with -k option"," !");
    | errNonsenseDeltreeMode:msg3(S,einfo," option is a nonsense with -z[z] option"," !");
    | errNonsenseDirMode:    msg3(S,einfo," option is a nonsense with -d option"," !");
    | errSection:     S:=progEXEname+extINI+" contains an illegal or unsupported section !";
    | errCasify:      S:="-j and -u options are mutually exclusive !";
    | errBadEnv:      msg3(S,'Illegal value in "',einfo,'" environment variable !');
    | errSizeRange  : msg3(S,"Illegal ",einfo," size range !");
    | errDateRange  : msg3(S,"Illegal ",einfo," date range !");
    | errMask  :      msg3(S,"Illegal or illogical ",einfo," attributes !");
    | errEntryNotFound: msg3(S, '"',einfo,'" specification does not exist !');
    | errEntryIsFile: msg3(S, '"',einfo,'" specification is not a directory !');
    | errMaskRedefined:S:="Illegal attempt to define -m:$ option more than once !";
    | errMaskSetting: S:="-m:$ and -a<?>[?] options are mutually exclusive !";
    | errMaskOne  :   msg3(S,"Illegal or illogical ",einfo," individual attributes !");
    | errFF       :   msg3(S, '"',einfo,'" format is illegal with -f[f] option !');
    | errSort     :   S:="-sn?, -sz?, -sd? and -se? options are mutually exclusive !";
    | errFormatRedefined:S:="-f:$ and -f? options are mutually exclusive !";
    | errDotdot :     S:='For user safety, -z[z] option will not process ".." specification !';
    | errNoFileMatchFound: S:="No match was found !"; (* never shown *)
    | errTooManyEntries:  S:=progEXEname+extINI+" contains too many entries !";
    | errTooManyColors:   S:=progEXEname+extINI+" contains too many color definitions !";
    | errBadColorDef,errInkPaper,errInkEsc,
      errPaperEsc,errColorEsc,errColorCode:
                          S:=progEXEname+extINI+" contains an illegal color definition !";
    | errParameterFF :  msg3(S, "Unpacked -f[f] ",einfo," makes one parameter too many !");
    | errGhostEntry  :  S:='Specified list contains at least one "not found" entry !';
    | errJokerGhost  :  S:='Specified list contains at least one illegal or "not found" entry !';

    | errUnexpectedWhatData:S:="Unexpected whatdata passed to initIniData() !"; (* cannot happen *)

    | errAborted:     S:="Aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp, errNoFileMatchFound : ;
    | errJokerEntry,errGhostEntry,errJokerGhost,errAborted:
        WrLn; (* uselessly beautify display *)
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    lstBuffer : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    HUGECARD = LONGREAL;
CONST
    HUGEZERO = 0.0;

PROCEDURE HUGEINC (VAR r:HUGECARD;n:HUGECARD );
BEGIN
    r := r + n;
END HUGEINC;

PROCEDURE nicefmthc (v : HUGECARD; pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.FixRealToStr( LONGREAL(v),0,S,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END nicefmthc;

PROCEDURE nicefmtlc (v : LONGCARD; pad:CHAR; sep:CHAR; field:INTEGER) : str80;
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END nicefmtlc;

(* ------------------------------------------------------------ *)

PROCEDURE fmtlc (v:LONGCARD;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
VAR
    R : str80;
    ok: BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:= Str.Length(R)+1 TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Append(R,ch);
        ELSE
            Str.Prepend(R,ch);
        END;
    END;
    IF base=16 THEN Str.Lows(R);END;
    Str.Prepend(R,prefix);
    RETURN R;
END fmtlc;

PROCEDURE fmt (v:CARDINAL;base:CARDINAL;wi:INTEGER;ch,prefix:CHAR) : str80;
BEGIN
    RETURN fmtlc(LONGCARD(v),base,wi,ch,prefix);
END fmt;

(* adapted from FCOMP v1.3c *)

PROCEDURE nice (useLFN:BOOLEAN;S:pathtype):pathtype;
VAR
    R:pathtype;
BEGIN
    IF useLFN THEN
        Str.Concat(R,dquote,S);
        Str.Append(R,dquote);
    ELSE
        Str.Copy(R,S);
    END;
    RETURN R;
END nice;

PROCEDURE showmem(S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    heapsize :=HeapTotalAvail(MainHeap);
    n :=16 * LONGCARD(heapsize);
    WrStr("::: ");WrStr(fmtlc(n,10,6," ","")); WrStr(" byte(s) free -- ");WrStr(S);WrLn;
END showmem;

PROCEDURE sound (freq,duration,pause:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
    Lib.Delay(pause);
END sound;

PROCEDURE errbip (okbeep:BOOLEAN);
CONST
    freq     = 55;
    duration = 55; (* was 300 *)
    tempo    = 100;
BEGIN
    IF okbeep THEN sound (freq,duration,tempo); END;
END errbip;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* //FIXME *)

CONST
    CHKEVERY9X = 128; (* let's call chkEscape every CHKEVERY LOOP *)
    CHKEVERYDOS= 8;  (* safety *)

PROCEDURE pollEscape (VAR chkrounds:CARDINAL; useLFN,ignoreESC:BOOLEAN):BOOLEAN;
VAR
    alcatraz:BOOLEAN;
    every:CARDINAL;
BEGIN
    (*
    9x really does NOT like ChkEscape() and randomely hangs till a keypress
    Flushkey() does NOT help
    *)
    (*
    IF useLFN THEN
        hit:=FALSE;
    ELSE
        hit:=ChkEscape();
    END;
    *)
    IF ignoreESC THEN RETURN FALSE;END;
    IF useLFN THEN
        every:=CHKEVERY9X;
    ELSE
        every:=CHKEVERYDOS;
    END;
    INC(chkrounds);
    IF (chkrounds MOD every) = 0 THEN
        chkrounds:=0;
        alcatraz:=ChkEscape();
    ELSE
        alcatraz:=FALSE;
    END;
    RETURN alcatraz;
END pollEscape;

(* ------------------------------------------------------------ *)

CONST (* reverse storage logic ! *)
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;

(* note we use IO as QD_Box Waitkey *)

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF IO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := IO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := IO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* trim and remove double quotes *)

PROCEDURE preprocessLine (VAR S:ARRAY OF CHAR); (* was pathtype *)
VAR
    len:CARDINAL;
BEGIN
    LtrimBlanks(S);
    RtrimBlanks(S);
    (* we could use Str.Match(S,dquote+"*"+dquote) but... *)
    len:=Str.Length(S);
    IF len < 2 THEN RETURN; END; (* at least 1+1 for possible dquote+dquote *)
    IF S[len-1] # dquote THEN RETURN; END;
    IF S[0] # dquote THEN RETURN; END;
    S[len-1]:=charnull;
    Str.Delete(S,0,1);
    (* just in case *)
    LtrimBlanks(S);
    RtrimBlanks(S);
END preprocessLine;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    NOUSERCOLOR = MAX(CARDINAL);
TYPE
    str4 = ARRAY [0..3] OF CHAR;
    usercolortype = RECORD
        scolor : str4;
        sext   : str16; (* in fact, we allow user to color almost anything... but we won't tell him *)
    END;
VAR
    usercolor          : ARRAY [minUserColor..maxUserColor] OF usercolortype;
    lastUserColor      : CARDINAL;

(* clever is not always faster : dynamic string allocation is much slower here -- and yes, we've tried it *)

VAR
    entryFlagProtected : ARRAY [minProtected..maxProtected] OF BOOLEAN;
    entryprotected     : ARRAY [minProtected..maxProtected] OF pathtype;
    lastEntryProtected : CARDINAL; (* globerk *)

(* return true if we can store it because it's either allowed or not protected *)

PROCEDURE chkNoProtection (verbose,isdir:BOOLEAN;S:pathtype):BOOLEAN;
VAR
    last,i,pass:CARDINAL;
    result,wantedflag,showme:BOOLEAN;
    msg:str16;
BEGIN
    last:=lastEntryProtected;
    IF last < minProtected THEN RETURN TRUE; END;


    LowerCaseAlt(S);

    FOR pass:=1 TO 2 DO
        CASE pass OF
        | 1 : wantedflag:=FALSE; result:=TRUE;   (* first, check allowed *)
              showme:=FALSE; (* no message if merely allowed exception *)
        | 2 : wantedflag:=TRUE;  result:=FALSE;  (* then check protected *)
              IF isdir THEN
                  msg:=sProtectedDir;
              ELSE
                  msg:=sProtectedFile;
              END;
              showme:=verbose;
        END;

        i:=minProtected-1;
        LOOP
            INC(i);
            IF i > last THEN EXIT; END;
            IF entryFlagProtected[i]=wantedflag THEN
                IF Str.Match(S,entryprotected[i]) THEN
                    IF showme THEN WrStr(msg); WrStr(S); WrLn; END;
                    RETURN result;
                END;
            END;
        END;
    END;
    RETURN TRUE;
END chkNoProtection;

(*
             ignoreini    forceswapfilesprotection
default      FALSE        TRUE
-swap        ?            FALSE
-x           TRUE         ?

if ini exists, its content override default protection unless -x was specified
if no ini, swapfiles protected unless -swaps
*)

PROCEDURE swapfilesprotectionFIX (forceswapfilesprotection,inihere,ignoreini:BOOLEAN):BOOLEAN;
BEGIN
    IF inihere THEN
        IF NOT(ignoreini) THEN
            forceswapfilesprotection:=FALSE; (* override possible default : user is responsible for ini entries *)
        END;
    END;
    RETURN forceswapfilesprotection;
END swapfilesprotectionFIX;

(* ------------------------------------------------------------ *)

PROCEDURE initIniData (VAR lastentry,lastusercolor:CARDINAL;
                      whatdata:CARDINAL;
                      ignoreini,forceswapfilesprotection,ignoredat,
                      useLFN,DEBUG:BOOLEAN):CARDINAL;
VAR
    ini,udne : pathtype;
    hin:FIO.File;
    i,p,whatproblem:CARDINAL;
    S,Z:str1024; (* str80 was enough for colors but now we also get pathtype *)
    inihere,flagProtected:BOOLEAN;
    R:str128;
    here,inkhere,paperhere:BOOLEAN;
    escch,ch:CHAR;
    state : (waiting,grabProtected,grabNotProtected,grabColors);
BEGIN
    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    inihere:=fileExists(useLFN,ini);

    CASE whatdata OF
    | dataProtection:
         forceswapfilesprotection:=swapfilesprotectionFIX(forceswapfilesprotection, inihere,ignoreini);
         lastentry := minProtected-1;
         IF forceswapfilesprotection THEN
             FOR i:= 1 TO 3 DO
                 CASE i OF
                 | 1: S:=patSwapWin92;
                 | 2: S:=patSwapWin98;
                 | 3: S:=patSwapWinXP;
                 END;
                 INC(lastentry);
                 Str.Copy(entryprotected[lastentry],S);
                 entryFlagProtected[lastentry]:=TRUE;
             END;
        END;
        IF ignoreini THEN RETURN errNone; END;
        IF NOT(inihere) THEN RETURN errNone; END;
    | dataColors:
        lastusercolor := minUserColor-1;
        IF ignoredat THEN RETURN errNone; END;
        IF NOT(inihere) THEN RETURN errNone; END;
    ELSE
        RETURN errUnexpectedWhatData; (* cannot happen *)
    END;

    state:=waiting;

    hin:=fileOpenRead(useLFN,ini);
    FIO.AssignBuffer(hin,lstBuffer);

    whatproblem:=errNone;

    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;

        preprocessLine (S);

        CASE S[0] OF
        | CHR(0), semicolon,pound :
            ;
        | openbracket:
            i:=getStrIndex(delim, S, sectionProtected+delim+
                                     sectionNotProtected+delim+
                                     sectionColors);
            CASE i OF
            | 1: IF whatdata=dataProtection THEN
                     state:=grabProtected;    flagProtected:=TRUE;
                 ELSE
                     state:=waiting;
                 END;
            | 2: IF whatdata=dataProtection THEN
                     state:=grabNotProtected; flagProtected:=FALSE;
                 ELSE
                     state:=waiting;
                 END;
            | 3: IF whatdata=dataColors     THEN
                     state:=grabColors;
                 ELSE
                     state:=waiting;
                 END;
            ELSE
                whatproblem:=errSection;
                EXIT;
            END;
        ELSE
            CASE state OF
            | waiting: ;
            | grabProtected,grabNotProtected: (* S is udne *)
                LowerCaseAlt(S); (* keep accents *)
                INC(lastentry);
                IF lastentry > maxProtected THEN
                    whatproblem:=errTooManyEntries;
                    EXIT;
                END;
                Str.Copy(entryprotected[lastentry],S);
                entryFlagProtected[lastentry]:=flagProtected;
                IF DEBUG THEN
                    IF flagProtected THEN
                        Z:="~ ~ (protected) : ~";
                    ELSE
                        Z:="~ ~ (allowed)   : ~";
                    END;
                    Str.Subst(Z,"~","Entry");
                    i:=lastentry;
                    Str.Subst(Z,"~",fmt(i,10,2," ",""));
                    Str.Subst(Z,"~",nice(useLFN, pathtype(S) ));
                    WrStr(S);WrLn;
                END;
            | grabColors:
                Str.Copy(Z,S);
                INC(lastusercolor);
                IF lastusercolor > maxUserColor THEN
                    whatproblem:=errTooManyColors;
                    EXIT;
                END;
                IF Str.Match(S,"*=*")=FALSE THEN
                    whatproblem:=errBadColorDef;
                    EXIT;
                END;

                (* .ext = ink paper --> sext & scolor *)
                p:=Str.CharPos(S,"=");
                Str.Slice( R , S,0,p);
                preprocessLine(R);
                Str.Delete(S,0,p+1);
                preprocessLine(S);

                inkhere   :=Str.Match(S,"*"+escink+"?");
                paperhere :=Str.Match(S,"*"+escpaper+"?");

                IF ( (NOT(inkhere)) AND (NOT(paperhere)) ) THEN
                    whatproblem:=errInkPaper;
                    EXIT;
                END;
                IF CharCount(S,escink) > 1 THEN
                    whatproblem:=errInkEsc;
                    EXIT;
                END;
                IF CharCount(S,escpaper) > 1 THEN
                    whatproblem:=errPaperEsc;
                    EXIT;
                END;
                FOR i:=1 TO 2 DO
                    CASE i OF
                    | 1: here:=inkhere;   escch:=escink;
                    | 2: here:=paperhere; escch:=escpaper;
                    END;
                    IF here THEN
                        p:=Str.CharPos(S,escch);
                        ch:=S[p+1];
                        CASE CAP(ch) OF
                        | "0".."9" : ;
                        | "A".."F" : ;
                        | escink,escpaper:
                            IF ch # escch THEN
                                 whatproblem:= errColorEsc;
                                 EXIT;
                            END;
                        ELSE
                            whatproblem:= errColorCode;
                            EXIT;
                        END;
                    END;
                END;

                Str.Prepend(R,"*");Str.Append(R,"*"); (* we'll use Str.Match  *)
                LowerCaseAlt(R); (* keep accents *)

                Str.Copy( usercolor[lastusercolor].sext, R);
                Str.Copy( usercolor[lastusercolor].scolor,S);

                IF DEBUG THEN
                    R:='User-defined color extension ~ : "~"';
                    i:=lastusercolor;
                    Str.Subst(R,"~",fmt(i,10,2," ",""));
                    Str.Subst(R,"~",Z);
                    WrStr(R);WrLn;
                END;
            END;
        END;
    END;
    FIO.Close(hin);
    RETURN whatproblem;
END initIniData;

(* ------------------------------------------------------------ *)

PROCEDURE dmpProtected (useLFN,cr:BOOLEAN;lastentry:CARDINAL );
VAR
    last,i:CARDINAL;
    R:str80;
    S:pathtype;
    flagProtected:BOOLEAN;
BEGIN
    IF lastentry < minProtected THEN RETURN; END;
    IF cr THEN WrLn;END;
        last:=lastentry;
        i:=minProtected;
        LOOP
            IF i > last THEN EXIT; END;
            S:=entryprotected[i];
            flagProtected:=entryFlagProtected[i];
            IF flagProtected THEN
                R:="Entry ~ (protected) : ";
            ELSE
                R:="Entry ~ (allowed)   : ";
            END;
            Str.Subst(R,"~",fmt(i,10,2," ","") );
            WrStr(R);
            WrStr( nice(useLFN,S));WrLn;
            INC(i);
        END;
END dmpProtected;

(* uses globerks *)

PROCEDURE chkUserColor (S:pathtype):CARDINAL;
VAR
    rc,last,i:CARDINAL;
    ok:BOOLEAN;
BEGIN
    last:=lastUserColor;
    rc:=NOUSERCOLOR;
    IF last < minUserColor THEN RETURN rc; END;
    LowerCaseAlt(S);
    i:=minUserColor-1;
    LOOP
        INC(i);
        IF i > last THEN EXIT; END;
        ok:=Str.Match(S,usercolor[i].sext);
        IF ok THEN
            rc:=i;
            EXIT;
        END;
    END;
    RETURN rc;
END chkUserColor;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* current is "\" or "\*\" *)

PROCEDURE buildParent (VAR parent:pathtype; current:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(current,"\") THEN RETURN FALSE; END;
    unfixDirectory(current);
    p:=Str.RCharPos(current,"\");
    Str.Slice(parent,current,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END buildParent;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

(*
    remember dirs can have an extension, and LFNs can have inner dots !

    we handle (whether u: or not) :

    .        current
    ..       parent
    .\xxx    current\xxx       F/D
    ..\xxx   parent\xxx        F/D

    xxx\     current\xxx\
    xxx\.    current\xxx\
    xxx      current\xxx       F/D

    \xxx\    \xxx\
    \xxx     \xxx              F/D
*)

PROCEDURE chkfixSpec (VAR base,spec:pathtype;
                     useLFN:BOOLEAN;orgS:pathtype;HDletters:ARRAY OF CHAR):CARDINAL;
VAR
    p,len,rc:CARDINAL;
    drive:SHORTCARD;
    u:CHAR;
    unit:str2;
    current,parent,S:pathtype;
    ok:BOOLEAN;
BEGIN
    Str.Copy(S,orgS);
    IF Str.Pos(S,"\\") # MAX(CARDINAL) THEN RETURN errNetSlash;END;

    (* process u: in S *)

    CASE CharCount(S,colon) OF
    | 0 :
        drive := FIO.GetDrive();
        rc:=errNone;
    | 1 :
        IF Str.CharPos(S,colon) = 1 THEN
            u:=CAP( S[0] );
            CASE u OF
            | "A".."Z" :
                IF verifyString(u,HDletters) THEN
                    drive := SHORTCARD( ORD(u) - ORD("A") +1 );
                    Str.Delete(S,0,2); (* remove u: *)
                    rc:=errNone;
                ELSE
                    rc:=errPhantomUnit;
                END;
            ELSE
                rc:=errBadUnit;
            END;
        ELSE
            rc:=errColon;
        END;
    ELSE
        rc:=errColon;
    END;
    IF rc # errNone THEN RETURN rc; END;

    (* note S no longer has u: *)

    doGetCurrent(useLFN,drive, unit,current); (* "u:" and "\" or "\*\" *)
    ok:=buildParent(parent, current);

    IF same(S,".") THEN Str.Copy(S,current);END;
    IF same(S,"..") THEN
        IF ok THEN Str.Copy(S,parent) ELSE RETURN errNoParent; END;
    END;
    IF Str.Match(S,".\*") THEN Str.Subst(S,".\",current); END;
    IF Str.Match(S,"..\*") THEN
        IF ok THEN Str.Subst(S,"..\",parent) ELSE RETURN errNoParent;END;
    END;
    IF Str.Match(S,"\*")=FALSE THEN Str.Prepend(S,current);END;
    IF Str.Match(S,"*\.") THEN
        (* S[Str.Length(S)-1]:=0C; *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
    (* we don't want inner or trailing ".." now *)
    IF Str.Pos(S,"..") # MAX(CARDINAL) THEN RETURN errInnerParent;END;

    (* base = "u:\xxx\" and spec = "xxx" *)

    IF Str.Match(S,"*\") THEN
        Str.Concat(base,unit,S);
        Str.Copy(spec,"*.*");
    ELSE
        Str.Prepend(S,unit);
        (* S is u:[\xxx]... without trailing "\" *)
        len:=Str.Length(S);
        p:=Str.RCharPos(S,"\");
        Str.Slice(base,S,0,p+1);
        Str.Slice(spec,S,p+1,len-p);
        IF chkJoker(spec)=FALSE THEN (* if spec has joker(s), assume files *)
            (* spec has no joker : dir or file ? *)
            IF fileIsDirectorySpec(useLFN,S) THEN
                Str.Copy(base,S);
                fixDirectory(base); (* safety *)
                Str.Copy(spec,"*.*");
            ELSE
                (* //FIXED hopefully : either entry not found, or found a file *)
                IF fileExists(useLFN,S) THEN
                    IF Str.RCharPos(spec,".")=MAX(CARDINAL) THEN
                        Str.Append(spec,"."); (* file extension *)
                    END;
                    RETURN errEntryIsFile;
                ELSE
(*%T FIXCHKFIXSPEC *)
                    IF Str.RCharPos(spec,".")=MAX(CARDINAL) THEN
                        Str.Append(spec,".*");
                        Str.Append(S   ,".*");
                    END;
                    IF fileExists(useLFN,S) THEN
                        RETURN errEntryIsFile;
                    ELSE
                        RETURN errEntryNotFound;
                    END;
(*%E  *)
(*%F FIXCHKFIXSPEC  *)
                    RETURN errEntryNotFound;
(*%E  *)
                END;
            END;
        END;
    END;
    IF chkJoker(base) THEN RETURN errDirJoker; END;
    (* //FIXED hopefully *)
    IF Str.Length(base) > 3 THEN (* "u:\" is assumed to always exist *)
        unfixDirectory(base);
        IF fileExists(useLFN,base)=FALSE THEN RETURN errEntryNotFound;END;
        fixDirectory(base);
    END;
    RETURN errNone;
END chkfixSpec;

PROCEDURE splitFileExt (VAR f,e:pathtype;S:pathtype):BOOLEAN;
VAR
   p:CARDINAL;
BEGIN
    p:=Str.RCharPos(S,".");
    CASE p OF
    | 0 :
        RETURN FALSE; (* nonsense : extension without file ! *)
    | MAX(CARDINAL) :
        Str.Copy(f,S);
        Str.Copy(e,"");
    ELSE
        Str.Slice(f,S,0,p);
        Str.Copy(e,S);
        Str.Delete(e,0,p+1);
    END;
    RETURN TRUE;
END splitFileExt;

(* ------------------------------------------------------------ *)

CONST
    firstEntry = 1; (* 1..count *)
    INDEXROOT  = 0; (* flag for root *)
    DIRDONE    = MAX(SHORTCARD); (* 20 parameters *)

TYPE
    pDirEntry = POINTER TO direntryType;
    direntryType = RECORD
        next      : pDirEntry;
        specindex : SHORTCARD; (* 1=spec1, 2=spec2, etc., DIRDONE=processed *)
        dirndxflag: CARDINAL;  (* 0=root any madman with more than 65535 dirs ? *)
        index     : CARDINAL;  (* 1.. for sort *)
        slen      : SHORTCARD;
        str       : CHAR;
        (*
        yes, a mere bit would do for rootflag, etc.
        WE DONT CARE ! asm days are DEAD ! even Apple ][ is DEAD ! :-(
        besides, in a Vindoze world, why care about speed and efficiency ?
        *)
    END;

PROCEDURE initDirList (VAR anchor : pDirEntry );
BEGIN
    anchor := NIL;
END initDirList;

PROCEDURE freeDirList (anchor : pDirEntry);
VAR
    needed : CARDINAL;
    p      : pDirEntry;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(direntryType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeDirList;

PROCEDURE buildNewDirPtr (VAR anchor,p:pDirEntry; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(direntryType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewDirPtr;

(* assume p is valid *)

PROCEDURE getDirStr (VAR S : pathtype; p:pDirEntry);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getDirStr;

PROCEDURE findMatchID (VAR p : pDirEntry;
                      anchor:pDirEntry;wanted:CARDINAL;IDwanted:LONGCARD):BOOLEAN;
BEGIN
    p:=anchor;
    WHILE anchor # NIL DO
        IF p^.specindex = SHORTCARD(wanted) THEN RETURN TRUE; END;
        p:=anchor^.next;
        anchor:=p;
    END;
    p:=NIL; (* added safety *)
    RETURN FALSE;
END findMatchID;

(* ------------------------------------------------------------ *)

TYPE
    pFileEntry = POINTER TO fileentryType;
    fileentryType = RECORD
        next      : pFileEntry;
        fsize     : LONGCARD;
        fattr     : FIO.FileAttr;
        fdate     : CARDINAL;
        ftime     : CARDINAL;
        index     : CARDINAL;  (* 1.. for sort *)
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initFileList (VAR anchor : pFileEntry );
BEGIN
    anchor := NIL;
END initFileList;

PROCEDURE freeFileList (anchor : pFileEntry);
VAR
    needed : CARDINAL;
    p      : pFileEntry;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fileentryType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeFileList;

PROCEDURE buildNewFilePtr (VAR anchor,p:pFileEntry; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fileentryType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewFilePtr;

(* assume p is valid *)

PROCEDURE getFileStr (VAR S : pathtype; p:pFileEntry);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getFileStr;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    diranchor:pDirEntry;    (* globerk from v1.0d *)
    fileanchor:pFileEntry;

PROCEDURE findDirByIndex(n:CARDINAL):pDirEntry;
VAR
    p:pDirEntry;
BEGIN
    p := diranchor;
    LOOP
        IF p = NIL THEN EXIT;END; (* gloups ! should NEVER happen ! *)
        IF p^.index = n THEN EXIT; END;
        p := p^.next;
    END;
    RETURN p;
END findDirByIndex;

PROCEDURE findFileByIndex(n:CARDINAL):pFileEntry;
VAR
    p:pFileEntry;
BEGIN
    p := fileanchor;
    LOOP
        IF p = NIL THEN EXIT;END; (* gloups ! should NEVER happen ! *)
        IF p^.index = n THEN EXIT; END;
        p := p^.next;
    END;
    RETURN p;
END findFileByIndex;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    globalPrivateDirListMsg : pathtype; (* shame on you ! *)

PROCEDURE setCosmeticHackForPossibleProtection (S:pathtype);
BEGIN
    Str.Copy(globalPrivateDirListMsg, S);
END setCosmeticHackForPossibleProtection;

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildDirList (VAR anchor:pDirEntry; VAR dirndxflag,lastdir: CARDINAL;
                       useLFN,recurse,dumpedmsg:BOOLEAN;
                       whatspec:CARDINAL;base:pathtype):CARDINAL;
VAR
    p: pDirEntry;
    len : CARDINAL;
    root,rootspec,entryname,newroot : pathtype;
    entry : FIO.DirEntry;
    found : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    rc : CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Copy(root,base);
    fixDirectory(root); (* safety *)

    (* assume base exists ! *)

    IF dumpedmsg THEN video(globalPrivateDirListMsg,FALSE); END;
    ok:=chkNoProtection(TRUE,TRUE,root); (* show,isdir *)
    IF dumpedmsg THEN video(globalPrivateDirListMsg,TRUE);  END;

    IF ok THEN
        len:=Str.Length(root);
        IF buildNewDirPtr(anchor,p,len)=FALSE THEN RETURN errStorage; END;
        p^.specindex := SHORTCARD (whatspec);
        p^.dirndxflag:= dirndxflag;
        INC(lastdir);
        p^.index     := lastdir;
        p^.slen      := SHORTCARD(len);
        Lib.FastMove ( ADR(root),ADR(p^.str),len );
    END;

    IF NOT(recurse) THEN RETURN errNone; END;

    IF ok THEN INC(dirndxflag); END;

    Str.Concat(rootspec,root,"*.*");
    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF (aD IN dosattr) THEN
                Str.Concat(newroot,root,entryname); (* u:\xx\ + xxx *)
                fixDirectory(newroot);
                rc:= buildDirList (anchor,dirndxflag,lastdir, useLFN,recurse,dumpedmsg,whatspec,newroot);
                IF rc # errNone THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN rc;
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END buildDirList;

(* ------------------------------------------------------------ *)

(*
    attrstatetype = (dontcare,required,unwanted);
    masktype = RECORD (* D R H S A *)
        stateD,stateR,stateH,stateS,stateA : attrstatetype;
    END;
*)

PROCEDURE matchMask (attr:FIO.FileAttr ; m:masktype):BOOLEAN ;
VAR
    i,pb:CARDINAL;
    here:BOOLEAN;
    status:attrstatetype;
BEGIN
    pb:=0;
    FOR i:=firstattr TO lastattr DO
        CASE i OF
        | 1 : here:=( aD IN attr ); status := m.stateD;
        | 2 : here:=( aR IN attr ); status := m.stateR;
        | 3 : here:=( aH IN attr ); status := m.stateH;
        | 4 : here:=( aS IN attr ); status := m.stateS;
        | 5 : here:=( aA IN attr ); status := m.stateA;
        END;
        CASE status OF
        | dontcare: ;
        | required: IF NOT(here) THEN INC(pb); END;
        | unwanted: IF here      THEN INC(pb); END;
        END;
    END;
    RETURN (pb=0);
END matchMask;

PROCEDURE storeFiles (VAR lastfile:CARDINAL; VAR fileanchor : pFileEntry;
                     pdir:pDirEntry;
                     useLFN,inverse,sizerange,daterange,osjokers:BOOLEAN;
                     losize,hisize:LONGCARD; lodate,hidate:CARDINAL;
                     maskfilter : masktype;
                     whatspec:CARDINAL;spec:pathtype):CARDINAL;
VAR
    matchspec,base,rootspec,entryname : pathtype;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    ok,keepit,found : BOOLEAN;
    len:CARDINAL;
    pp:pFileEntry;
    fsize:LONGCARD;
    stampdate,stamptime:CARDINAL;
BEGIN
    lastfile := firstEntry-1; (* 0 as fcount *)

    getDirStr(base,pdir);

    IF osjokers THEN
        Str.Concat(rootspec,base,spec);
        Str.Copy(matchspec,"*");         (* match everything *)
    ELSE
        Str.Concat(rootspec,base,"*.*"); (* was spec before osjoker option *)
        Str.Copy(matchspec,spec);
    END;

    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
        unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);

                fsize     := w9Xentry.fsize.lo; (* no file should be more than 4Gb anyway ;-) *)
                (*
                QD_LFN calls win9XfindFirst requiring DOS format
                DOS date/time values in low double-word of file time QWORD
                (date is high word, time is low word of double-word)
                darn, it's not creation field but lastmod seems ok
                *)
                stampdate := CARDINAL(w9Xentry.lastmod.lo >> 16);
            ELSE
                dosattr:=entry.attr;

                fsize     := entry.size;
                stampdate := entry.date;
            END;

            (* some time, be more clever here -- er... let's try to be, at least *)

            ok:=matchMask(dosattr,maskfilter);

            IF sizerange THEN (* nonsense with dirs *)
                keepit:=NOT ( (fsize < losize) OR (fsize > hisize) );
                ok := (ok AND keepit);
            END;
            IF daterange THEN
                keepit:=NOT ( (stampdate < lodate) OR (stampdate > hidate) );
                ok := (ok AND keepit);
            END;

            IF ok THEN
                (* if file has no extension, add it as a marker : valid for LFN and DOS *)
                (* //FIXME : what about directories ? *)
                IF Str.RCharPos(entryname,dot)=MAX(CARDINAL) THEN
                    Str.Append(entryname,dot);
                END;
                ok:=Str.Match(entryname,matchspec); (* was spec *)
                IF inverse THEN ok:=NOT(ok); END;

                ok:=(ok AND chkNoProtection(TRUE,FALSE,entryname) ); (* show,isdir *)

                IF ok THEN
                    len:=Str.Length(entryname);
                    IF buildNewFilePtr(fileanchor,pp,len)=FALSE THEN
                        IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                        RETURN errStorage;
                    END;
                    (* fsize and stampdate filled earlier now *)
                    IF useLFN THEN
                        (*
                        fsize     := w9Xentry.fsize.lo; (* no file should be more than 4Gb anyway ;-) *)
                        stampdate := CARDINAL(w9Xentry.lastmod.lo >> 16);
                        *)
                        stamptime := CARDINAL(w9Xentry.lastmod.lo AND 0FFFFH);
                    ELSE
                        (*
                        fsize     := entry.size;
                        stampdate := entry.date;
                        *)
                        stamptime := entry.time;
                    END;

                    pp^.fsize     := fsize;
                    pp^.fattr     := dosattr;
                    pp^.fdate     := stampdate;
                    pp^.ftime     := stamptime;
                    INC(lastfile);
                    pp^.index     := lastfile;
                    pp^.slen      := SHORTCARD(len);
                    Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END storeFiles;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE dmpDirs (anchor:pDirEntry;wanted:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = "&&& spec= ~  dirndx= ~  index= ~  ~"; (* file must always be last with this placeholder *)
VAR
    p : pDirEntry;
    R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
BEGIN
    p:=anchor;
    WHILE p # NIL DO
        ok:= (p^.specindex = SHORTCARD(wanted) );
        IF ok THEN
            Str.Copy(S, sInfo);
            Str.Subst(S,"~",fmt( CARDINAL(p^.specindex),10,2," ",""));
            Str.Subst(S,"~",fmt(p^.dirndxflag,10,5," ",""));
            Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
            getDirStr(R,p);
            Str.Subst(S,"~", nice(useLFN,R) );
            WrStr(S);WrLn;
        END;
        p:=p^.next;
    END;
END dmpDirs;

PROCEDURE dmpDirsAlt (anchor:pDirEntry;lastdir:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = "&&& SPEC= ~  DIRNDX= ~  INDEX= ~  ~"; (* uppercase to remind it's alt proc *)
VAR
    p : pDirEntry;
    R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
    i:CARDINAL;
BEGIN
    FOR i:=firstEntry TO lastdir DO
        p:=findDirByIndex(i);
            Str.Copy(S, sInfo);
            Str.Subst(S,"~",fmt( CARDINAL(p^.specindex),10,2," ",""));
            Str.Subst(S,"~",fmt(p^.dirndxflag,10,5," ",""));
            Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
            getDirStr(R,p);
            Str.Subst(S,"~", nice(useLFN,R) );
            WrStr(S);WrLn;
    END;
END dmpDirsAlt;

PROCEDURE dmpFiles (VAR bytecount:HUGECARD;VAR filecount,dircount:LONGCARD;
                   anchor:pFileEntry;pdir:pDirEntry;wanted:CARDINAL;useLFN:BOOLEAN);
CONST
     sInfo    = "&&& spec= ~  ";
     sInfoFile= "&&& index= ~    ";
VAR
    p : pFileEntry;
    base,R: pathtype;
    S:str128;
BEGIN
    Str.Copy(S,sInfo);
    Str.Subst(S,"~",fmt ( wanted,10, 2," ","") );
    WrStr(S);
    getDirStr(base,pdir);
    WrStr(nice(useLFN,base));WrLn;

    p:=anchor;
    WHILE p # NIL DO

        IF (aD IN p^.fattr) THEN
            INC(dircount);
        ELSE
            INC(filecount);
            HUGEINC(bytecount, HUGECARD(p^.fsize));
        END;

        Str.Copy(S,sInfoFile);
        Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        WrStr(S);
        getFileStr(R,p);
        Str.Prepend(R,base);
        WrStr(nice(useLFN,R));WrLn;
        p:=p^.next;
    END;
END dmpFiles;

PROCEDURE dmpFilesAlt (VAR bytecount:HUGECARD;VAR filecount,dircount:LONGCARD;
                   anchor:pFileEntry;pdir:pDirEntry;lastfile:CARDINAL;useLFN:BOOLEAN);
CONST
     sInfo    = "&&& ";
     sInfoFile= "&&& index= ~    ";
VAR
    p : pFileEntry;
    base,R: pathtype;
    S:str128;
    i:CARDINAL;
BEGIN
    Str.Copy(S,sInfo);
    WrStr(S);
    getDirStr(base,pdir);
    WrStr(nice(useLFN,base));WrLn;

    FOR i:=firstEntry TO lastfile DO
        p:=findFileByIndex(i);

        IF (aD IN p^.fattr) THEN
            INC(dircount);
        ELSE
            INC(filecount);
            HUGEINC(bytecount, HUGECARD(p^.fsize));
        END;

        Str.Copy(S,sInfoFile);
        Str.Subst(S,"~",fmt(p^.index,10,5," ",""));
        WrStr(S);
        getFileStr(R,p);
        Str.Prepend(R,base);
        WrStr(nice(useLFN,R));WrLn;
    END;
END dmpFilesAlt;

PROCEDURE getEnvVar (VAR R:ARRAY OF CHAR; envvar:ARRAY OF CHAR);
VAR
    p : CARDINAL;
BEGIN
    Lib.EnvironmentFind(envvar, R);
    RtrimBlanks(R);
    LtrimBlanks(R);
    IF same(R,"") THEN RETURN; END;
    IF Str.Match(R, dquote+"*"+dquote) THEN
        Str.Delete(R,0,1);
        p:=Str.RCharPos(R,dquote);
        Str.Delete(R,p,1);
    END;
END getEnvVar;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE padded (field:INTEGER;S:ARRAY OF CHAR):str80;
CONST
    pad = " ";
VAR
    R:str80;
    len:CARDINAL;
BEGIN
    Str.Copy(R,S);
    len:=Str.Length(R);
    WHILE (INTEGER(len) < ABS(field) ) DO
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
        INC(len);
    END;
    RETURN R;
END padded;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=minyy+127; (* was 2099 *)
    baseyear=minyy;  (* 1980 *)

PROCEDURE PackDMY (d,m,y : CARDINAL  ) : CARDINAL;
BEGIN
    IF y < baseyear THEN
        y:=baseyear;
    END;
    DEC(y,baseyear);
    IF y > 127 THEN y:=127; END; (* %1111111 i.e. $7f max *)
    y := y << yyShft;
    m := m << mmShft;
    RETURN (y + m + d);
END PackDMY;

PROCEDURE UnpackDMY (dmy:CARDINAL;VAR d,m,y:CARDINAL);
BEGIN
    y := CARDINAL(BITSET(dmy) * yyMask) >> yyShft;
    m := CARDINAL(BITSET(dmy) * mmMask) >> mmShft;
    d := CARDINAL(BITSET(dmy) * ddMask) >> ddShft;
    INC(y,baseyear);
END UnpackDMY;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

CONST
    dateplain = 0; (* dd-MMM-yyyy *)
    datestd   = 1; (* dd-mm-yyyy *)
    daterev   = 2; (* yyyy-mm-dd *)

PROCEDURE fmtDate (dmy:CARDINAL;datefmt:CARDINAL) : str16;
CONST
    tokday    = "~";
    tokmonth  = "@";
    tokmois   = "$";
    tokyear   = "!";
    separator = dash;
    pad       = "0";
    baseyear  = 1900;
    tmonths   = "Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2  = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R,S: str16;
    d,m,y:CARDINAL;
BEGIN
    UnpackDMY(dmy,d,m,y);
    IF ((m < minmm) OR (m > maxmm)) THEN m := 13; END;
    S:="";
    CASE datefmt OF
    | dateplain: R:=tokday +separator+tokmois +separator+tokyear;
                 Str.ItemS(S,tmonths2," ",m-1);
    | datestd:   R:=tokday +separator+tokmonth+separator+tokyear;
    | daterev:   R:=tokyear+separator+tokmonth+separator+tokday;
    ELSE
                 R:="??"+separator+"???"+separator+"????";
    END;
    Str.Subst(R,tokday   ,   using(d,2,pad));
    Str.Subst(R,tokmonth ,   using(m,2,pad));
    Str.Subst(R,tokyear  ,   using(y,4,pad));
    Str.Subst(R,tokmois  ,   S);

    RETURN R;
END fmtDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    timelong     = 0;
    timestd      = 1;
    timelongzero = 2;
    timestdzero  = 3;

PROCEDURE fmtTime (timedata:CARDINAL;timefmt:CARDINAL) : str16;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    tokhh     = "~";
    tokmm     = "@";
    tokss     = "$";
    tokHZ     = "!";
    separator = colon;
    padhours  = blank;
    pad       = "0";
VAR
    h,m,s : CARDINAL;
    R : str16;
BEGIN
    h := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    m := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    s := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    s := s << 1; (* FIXED ! yes, yes, "* 2" works too... *)

    CASE timefmt OF
    | timelong    : R:=tokhh+separator+tokmm+separator+tokss;
    | timestd     : R:=tokhh+separator+tokmm;
    | timelongzero: R:=tokHZ+separator+tokmm+separator+tokss;
    | timestdzero : R:=tokHZ+separator+tokmm;
    ELSE
                 R:="??"+separator+"??"+separator+"??";
    END;

    Str.Subst(R, tokhh, using(h,2,padhours) );
    Str.Subst(R, tokmm, using(m,2,pad));
    Str.Subst(R, tokss, using(s,2,pad));
    Str.Subst(R, tokHZ, using(h,2,pad) );

    RETURN R;
END fmtTime;

PROCEDURE fmtSize (v:LONGCARD;pad,sep:CHAR;isdir:BOOLEAN):str16;
CONST
    field = 10+3; (* "#,###,###,###" *) (* what if file is one giga+, eh ? *)
VAR
    S,R   : str16;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    IF isdir THEN
        S   := strSUBDIRECTORY;
        sep := "";
    ELSE
        Str.CardToStr(v,S,10,ok);
    END;
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE sbool (tf:BOOLEAN;sT,sF:ARRAY OF CHAR):str16;
VAR
    R:str16;
BEGIN
    IF tf THEN
        Str.Copy(R,sT);
    ELSE
        Str.Copy(R,sF);
    END;
    RETURN R;
END sbool;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str16;
VAR
    S : str16;
BEGIN
    Str.Copy  (S, sbool( (aD IN attr),"d","-") );
    Str.Append(S, sbool( (aR IN attr),"r","-") );
    Str.Append(S, sbool( (aH IN attr),"h","-") );
    Str.Append(S, sbool( (aS IN attr),"s","-") );
    Str.Append(S, sbool( (aA IN attr),"a","-") );
    RETURN S;
END fmtAttr;

(* ------------------------------------------------------------ *)

PROCEDURE wrcolored(cr:BOOLEAN;S:ARRAY OF CHAR);
VAR
    ink,paper,prevink,prevpaper:CARDINAL;
    getting : (grab,gotescink,gotescpaper);
    i,len:CARDINAL;
    ch,c:CHAR;
BEGIN
    ink     := ORD(defaultink);
    paper   := ORD(defaultpaper);
    prevink := ink;
    prevpaper:=paper;

    color (ink,paper);

        getting:=grab;
        len := Str.Length(S);
        i:=0;
        WHILE i < len DO
            c := S[i];
            ch:= CAP(c);
            CASE getting OF
            | grab :
                CASE c OF
                | escink: getting := gotescink;
                | escpaper:getting:= gotescpaper;
                ELSE
                    WrStr(c);
                END;
            | gotescink:
                CASE ch OF
                | "0".."9" :    ink:=ORD(ch)-ORD("0");
                                color(ink,paper);
                | "A".."F" :    ink:=ORD(ch)-ORD("A")+10;
                                color(ink,paper);
                | inkdefault:   ink:=ORD(defaultink);
                                color(ink,paper);
                | inkPop:       ink:=prevink;
                                color(ink,paper);
                | inkPush:      prevink:=ink;
                ELSE
                    WrStr(escink);WrStr(c);
                END;
                getting := grab;
            | gotescpaper:
                CASE ch OF
                | "0".."9" :    paper:=ORD(ch)-ORD("0");
                                color(ink,paper);
                | "A".."F" :    paper:=ORD(ch)-ORD("A")+10;
                                color(ink,paper);
                | paperdefault: paper:=ORD(defaultpaper);
                                color(ink,paper);
                | paperPop:     paper:=prevpaper;
                                color(ink,paper);
                | paperPush:    prevpaper:=paper;
                ELSE
                    WrStr(escpaper);WrStr(c);
                END;
                getting := grab;
            END;
            INC(i);
        END;

    colorhelp;
    IF cr THEN WrLn; END;
END wrcolored;

PROCEDURE waitAndSee (VAR rowcount:CARDINAL; lastRow:CARDINAL):BOOLEAN;
VAR
    key:str2;
BEGIN
    INC(rowcount);
    IF rowcount >= lastRow THEN (* = is enough but who knows what evil lurks in the heart of BIOS *)
        rowcount := initpagingcounter;
        video(kbdmsg,TRUE);
        Flushkey;
        key:=Waitkey();
        video(kbdmsg,FALSE);
        IF same(key,echap) THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END waitAndSee;

(* ------------------------------------------------------------ *)

PROCEDURE dmpUserColor (cr:BOOLEAN;lastusercolor:CARDINAL );
VAR
    last,i:CARDINAL;
    S:str128;
    R:str80;
BEGIN
    IF lastusercolor < minUserColor THEN RETURN; END;
    IF cr THEN WrLn;END;
        last:=lastusercolor;
        i:=minUserColor;
        LOOP
            IF i > last THEN EXIT; END;

            S := fmtResetDefaultInk+fmtResetDefaultPaper+
                 'User-defined extension colors ~ (raw)    : "~" = '+
                 fmtInkRestore+fmtPaperRestore;

            Str.Subst(S,"~", fmt(i,10,2," ","") );
            Str.Subst(S,"~", usercolor[i].sext);

            wrcolored(FALSE,S);

            S := '"~"';
            Str.Subst(S,"~", usercolor[i].scolor);
            WrStr(S);WrLn;

            S := fmtResetDefaultInk+fmtResetDefaultPaper+
                 'User-defined extension colors ~ (cooked) : "~'+
                 fmtInkRestore+fmtPaperRestore+'"';

            Str.Subst(S,"~", fmt(i,10,2," ","") );
            Str.Concat(R, usercolor[i].scolor, usercolor[i].sext);
            Str.Subst(S,"~",R);

            wrcolored(TRUE,S);

            INC(i);
        END;
END dmpUserColor;

(* ------------------------------------------------------------ *)

(*%T CHKSUMS  *)

CONST
    doMD5     = 0;
    doSHA     = 1;
    doCRC32   = 2;
CONST

(* md5/crc32 require an existing shortform, while ne may be a LFN *)

PROCEDURE calcsum (isdir:BOOLEAN;method:CARDINAL; shortform,ne:pathtype):str80; (* oversized *)
CONST
    msgWait      = "Computing, please wait...";
    nope         = "--------";  (* 8 chars *)
    msgSkipMD5   = nope+nope+nope+nope;      (* match strMD = 32 chars for speed *)
    msgSkipSHA   = nope+nope+nope+nope+nope; (* match SHA = 40 chars for speed *)
    msgSkipCRC32 = nope;                     (* match CRC32 =  8 chars for speed *)
VAR
    valMD : MD5digestType;
    strMD : MD5str;
    valSHA: SHAdigestType;
    strSHA: SHAstr;
    crc   : LONGCARD;
    R     : str80;
    ok    : BOOLEAN;
    i : CARDINAL;
BEGIN
    (*
    useless here : protection is not initialized by directory mode
    ok:=chkNoProtection (FALSE,FALSE,ne); (* show,isdir *)
    IF ok THEN (* not protected : try swapfiles and do it fast *)
    *)

    IF isdir THEN
        ok:=FALSE;
    ELSE
                        ok:=Str.Match(ne, fSwapWin92);
        IF NOT(ok) THEN ok:=Str.Match(ne, fSwapWin98);END;
        IF NOT(ok) THEN ok:=Str.Match(ne, fSwapWinXP);END;
        ok:=NOT(ok);
    END;
    IF ok THEN
        video(msgWait,TRUE);
        CASE method OF
        | doMD5 :
            ComputeMD5(valMD,shortform);
            MD5toString(strMD,valMD);
            Str.Copy(R, strMD);
        | doSHA :
            ComputeSHA(valSHA,shortform);
            SHAtoString(strSHA,valSHA);
            Str.Copy(R, strSHA);
        | doCRC32:
            crc:=ComputeCRC32(shortform);
            Str.Copy(R, fmtlc(crc,16,8,"0",""));
        END;
        video(msgWait,FALSE);
    ELSE
        CASE method OF
        | doMD5 :  R:=msgSkipMD5;
        | doSHA:   R:=msgSkipSHA;
        | doCRC32: R:=msgSkipCRC32;
        END;
    END;
    RETURN R;
END calcsum;

(*%E  *)

(* ------------------------------------------------------------ *)

CONST
    orgautonum      = 1-1;
    orgautonumalpha = "AAA"+CHR(ORD("A")-1); (* same as 1-1 ! *)
    autonumwi       = 4;

PROCEDURE incnumalpha (VAR S:str16);
VAR
    i,code:CARDINAL;
    carry:BOOLEAN;
BEGIN
    i:=Str.Length(S);
    IF i # autonumwi THEN RETURN; END; (* should never happen but... *)
    LOOP
        DEC(i);
        code:=ORD(S[i]);
        INC(code);
        IF code > ORD("Z") THEN
            IF i=0 THEN
                code:=ORD("_"); (* safety *)
            ELSE
                code:=ORD("A");
            END;
            carry:=TRUE;
        ELSE
            carry:=FALSE;
        END;
        S[i]:=CHR(code);
        IF carry=FALSE THEN EXIT; END;
        IF i=0 THEN EXIT; END;
    END;
END incnumalpha;

PROCEDURE frame (VAR R:ARRAY OF CHAR; ip:str4);
BEGIN
    Str.Prepend(R,ip);
    Str.Prepend(R,fmtInkSave+fmtPaperSave);
    Str.Append (R,fmtInkRestore+fmtPaperRestore);
END frame;

PROCEDURE dospad (padright:BOOLEAN;f8,e3:str16 ; ndxusercolor:CARDINAL; ip:str4):str80;
CONST
    widosf8 = 8;
    widose3 = 1+3; (* include dot *)
VAR
    R : str80; (* result may contain color codes *)
    wif8,wie3 : INTEGER;
BEGIN
    (* extension will always be ".x[x[x]]] *)
    IF padright THEN
        wif8 := widosf8;
        wie3 :=-widose3;
    ELSE
        wif8 :=-widosf8;
        wie3 :=-widose3;
    END;
    Str.Copy(R,padded( wif8,f8));
    Str.Append(R,padded (wie3,e3));
    IF ndxusercolor # NOUSERCOLOR THEN frame(R,ip);END;
    RETURN R;
END dospad;

(* ------------------------------------------------------------ *)

PROCEDURE doDir (VAR bytecount:HUGECARD; VAR filecount,dircount:LONGCARD;
                VAR rowcount:CARDINAL;   VAR singlestep:BOOLEAN;
                VAR autonum:CARDINAL;    VAR autonumalpha:str16;
                lastfile:CARDINAL; pdir:pDirEntry;
                useLFN,stats,showentries,paging,allowpause,
                dirheader,dirheaderalways,forceLFNquotes,divscreenrowcount:BOOLEAN;
                casify:casifyType; comaUSER:CHAR; pat:ARRAY OF CHAR):BOOLEAN;
VAR
    base:pathtype;
    p:pFileEntry;
    shortform,orgshortform,longform:pathtype;
    udne,u,d,dd,n,e,ext,ne,orgne:pathtype; (* was str128 *)
    R:str2048; (* really oversized ! *)
    ch,lowch:CHAR;
    getting:(grab,gotesc);
    j,i,len,rc,tmplen: CARDINAL;
    isdir,showdirheader:BOOLEAN;
    lastRow:CARDINAL;

    udos,ndos,edos:str16;
    ddos:str128;

    qfix,keychk:BOOLEAN;
    keycode,ink,paper,ndxusercolor:CARDINAL;
    snum:str16;
    ip:str4;
    numNotChanged,numalphaNotChanged:BOOLEAN;
BEGIN
    lastRow  := getWindowHeight();
    IF divscreenrowcount THEN lastRow:=(lastRow DIV 2); END;

    getDirStr(base,pdir);

    showdirheader:=dirheader; (* default *)
    IF showdirheader THEN
        IF NOT(dirheaderalways) THEN
            showdirheader := NOT (lastfile < firstEntry);
        END;
    END;

    IF showdirheader THEN
        ink   := ORD(defaultink);
        paper := ORD(defaultpaper);
        color(ink,paper);
        FOR i:= 1 TO 3 DO
            CASE i OF
            | 1 : R:="";
            | 2 : Str.Concat(R,sDIRheader, nice(useLFN,base) );
            | 3 : R:="";
            END;
            WrStr(R);WrLn;
            IF paging THEN (* code pasted from infra *)
                IF waitAndSee (rowcount,  lastRow)=FALSE THEN RETURN FALSE; END;
            END;
        END;
        colorhelp;
    END;

    FOR j:=firstEntry TO lastfile DO
        p:=findFileByIndex(j);

        isdir := (aD IN p^.fattr);

        IF stats THEN
            IF isdir THEN
                INC(dircount);
            ELSE
                INC(filecount);
                HUGEINC(bytecount, HUGECARD(p^.fsize));
            END;
        END;

        getFileStr(udne,p);
        Str.Prepend(udne,base);

        IF useLFN THEN
            Str.Copy(longform,udne);
            IF w9XlongToShort(longform,rc,shortform)=FALSE THEN
                Str.Copy(shortform,udne); (* gloups *)
            END;
        ELSE
            Str.Copy(shortform,udne);
        END;
        Str.Copy(orgshortform,shortform); (* for file operation *)

        CASE casify OF (* keep accents *)
        | lowercase:
            LowerCaseAlt(udne);
            LowerCaseAlt(shortform);
        | uppercase:
            UpperCaseAlt(udne);
            UpperCaseAlt(shortform);
        END;
        Lib.SplitAllPath(udne,u,d,n,e); (* "u:" "\*\" "f" ".e" *) (* handles multiple dots *)
        Lib.SplitAllPath(shortform,udos,ddos,ndos,edos);
        Lib.MakeAllPath(ne,"","",n,e);
        Str.Copy(orgne,ne); (* for file operation *)

        IF same(edos,"") THEN
            edos:=dot; (* beautify for $r and $g tokens *)
            Str.Append(shortform,dot); (* $x token *)
        END;

        Str.Copy(dd,d);
        unfixDirectory(dd);
        Str.Copy(ext,e); Str.Subst(ext,dot,""); (* never used anyway ! *)

        ndxusercolor:=chkUserColor(udne);
        IF ndxusercolor # NOUSERCOLOR THEN (* praise the Lord... Kludge ! *)
            ip:=usercolor[ndxusercolor].scolor;
            frame(u    ,ip);
            frame(d    ,ip);
            frame(n    ,ip);
            frame(e    ,ip);
            frame(ne   ,ip);
            frame(dd   ,ip);
            frame(ext  ,ip);
            frame(shortform,ip);
            (* don't frame ndos and edos wich will require padding *)
        ELSE
            ip:=""; (* safety *)
        END;

        R           := "";
        getting     := grab;
        len         := Str.Length(pat);
        i           := 0;

        numNotChanged      := TRUE;
        numalphaNotChanged := TRUE;

        WHILE i < len DO
            ch := pat[i];
            CASE getting OF
            | grab :
                IF ch = escch THEN
                    getting:=gotesc;
                ELSE
                    Str.Append(R,ch);
                END;
            | gotesc:
                lowch:=ch; Str.Lows(ch);
                CASE lowch OF
                | cZ:        Str.Append(R, fmtSize (p^.fsize,blank,comaUSER,isdir) );
                | cI:        Str.Append(R, fmtSize (p^.fsize,blank,""    ,isdir) );
                | cA:        Str.Append(R, fmtAttr (p^.fattr ) );
                | cH:        Str.Append(R, fmtTime (p^.ftime, timelong  ) );
                | cO:        Str.Append(R, fmtTime (p^.ftime, timestd   ) );
                | cV:        Str.Append(R, fmtTime (p^.ftime, timestdzero  ) );
                | cL:        Str.Append(R, fmtTime (p^.ftime, timelongzero  ) );
                | cT:        Str.Append(R, fmtDate (p^.fdate, dateplain ) );
                | cJ:        Str.Append(R, fmtDate (p^.fdate, datestd   ) );
                | cW:        Str.Append(R, fmtDate (p^.fdate, daterev   ) );
                | cU:        Str.Append(R,u);
                | cD:        Str.Append(R, nice(forceLFNquotes,d)); (* //FIXME *)
                | cB:        Str.Append(R, nice(forceLFNquotes,dd)); (* //FIXME *)
                | cN:        Str.Append(R, nice(forceLFNquotes,n));
                | cE:        Str.Append(R, nice(forceLFNquotes,e));
                | cF:        Str.Append(R, nice(forceLFNquotes,ne));
                | cR:        Str.Append(R, dospad (TRUE ,ndos,edos, ndxusercolor,ip));
                | cG:        Str.Append(R, dospad (FALSE,ndos,edos, ndxusercolor,ip));
                | cC:        IF useLFN THEN Str.Append(R,dquote);END;
                             Str.Append(R,u);
                             Str.Append(R,d);
                             Str.Append(R,n);Str.Append(R,e);
                             IF useLFN THEN Str.Append(R,dquote);END;
                | cX:        Str.Append(R,shortform);
                | cY:        IF forceLFNquotes THEN Str.Append(R,dquote);END;
                             Str.Append(R,u);
                             Str.Append(R,d);
                             IF isdir THEN (* //FIXME *)
                                 Str.Append(R,ne);
                                 tmplen:=Str.Length(R)-1;
                                 IF Str.RCharPos(R,dot)=tmplen THEN R[tmplen]:=CHR(0);END;
                                 fixDirectory(R);
                             END;
                             IF forceLFNquotes THEN Str.Append(R,dquote);END;
(*%T CHKSUMS  *)
                | cM:        Str.Append(R,calcsum(isdir,doMD5,  orgshortform,orgne));
                | cS:        Str.Append(R,calcsum(isdir,doSHA,  orgshortform,orgne));
                | cK:        Str.Append(R,calcsum(isdir,doCRC32,orgshortform,orgne));
(*%E  *)
                | cQ:        Str.Append(R,dquote);
                | cCRLF:     Str.Append(R,nl);
                | cPERCENT:  Str.Append(R,percent);
                | cDOLLAR:   Str.Append(R,dollar);
                | cEXCLAM:   Str.Append(R,tabchar);
                | cPOUND:    IF numNotChanged THEN
                                 INC(autonum);
                                 numNotChanged:=FALSE;
                             END;
                             Str.Copy(snum, fmt (autonum,10,5,"0",""));
                             Str.Append(R,snum);
                | cQUESTION: IF numalphaNotChanged THEN
                                 incnumalpha(autonumalpha);
                                 numalphaNotChanged:=FALSE;
                             END;
                             Str.Append(R,autonumalpha);
                ELSE
                    Str.Append(R,escch); Str.Append(R,ch);
                END;
                getting := grab;
            END;
            INC(i);
        END;

        IF showentries THEN wrcolored(TRUE, R); END; (* resets colorhelp *)

        IF paging THEN
            IF waitAndSee (rowcount,  lastRow)=FALSE THEN RETURN FALSE; END;
        ELSE
            IF allowpause THEN (* no paging, no redirection *)
                IF singlestep THEN
                    WHILE getKeyboardCode(keycode)=FALSE DO
                    END;
                    keychk:=(keycode # keySpace);
                    singlestep:=NOT(keychk);
                ELSE
                    keychk:=getKeyboardCode(keycode);
                END;
                IF keychk THEN
                    CASE keycode OF
                    | keySpace      : singlestep:=NOT (singlestep);
                    | keyEscape     : RETURN FALSE;
                    END;
                END;
            END;
        END;
    END;
    RETURN TRUE;
END doDir;

(* ------------------------------------------------------------ *)

PROCEDURE killfile (silently,doit,useLFN,killro,prompuser,preview,protected:BOOLEAN;
                   S:pathtype):BOOLEAN;
VAR
    msg : str16;
    rc  : BOOLEAN;
BEGIN
    rc:=FALSE;
    IF doit THEN
        IF protected THEN
            IF killro THEN
                IF preview=FALSE THEN
                    fileSetRW(useLFN,S);
                    fileErase(useLFN,S);
                END;
                msg:=sDelRO;    rc:=TRUE;
            ELSE
                msg:=sSkipRO;
            END;
        ELSE
            IF preview=FALSE THEN
                fileErase(useLFN,S);
            END;
            msg:=sDel;          rc:=TRUE;
        END;
    ELSE
        IF protected THEN
            msg:=sKeptRO;
        ELSE
            msg:=sKeptRW;
        END;
    END;
    IF NOT(silently) THEN
        IF preview THEN WrStr(sFake);END;
        WrStr(msg);WrStr( nice(useLFN,S));WrLn;
    END;
    RETURN rc;
END killfile;

CONST
    kYes       = "Y"; sYes       = "Yes";
    kNo        = "N"; sNo        = "No";
    kYesAll    = "A"; sYesAll    = "Yes to all";
    kQuit      = "Q"; sQuit      = "Quit"; (* "Aborted by user !"+nl+nl *)
    kEsc       = CHR(27);
    kOui       = "O";
    kOuiTous   = "T";
    strPrompt  = "Delete ? [Y|O]-yes  [N]-no  [A|T]-yes to all  [Q|Esc]-quit : ";

PROCEDURE queryUser(VAR promptuser,continue,doit:BOOLEAN;
                        useLFN,protected,preview,audio:BOOLEAN;udne:pathtype);
VAR
    key : str2;
    msg:str16;
    askagain:BOOLEAN;
BEGIN

    doit:=FALSE;

    Str.Copy(msg,sbool(protected,"RO","rw"));
    WrLn;
    WrStr(msg);WrStr(" file : "); WrStr(nice(useLFN,udne)); WrLn;

    IF preview THEN WrStr(sFake);END;
    WrStr(strPrompt);
    LOOP
        askagain:=FALSE;
        Flushkey;  key := Waitkey();  UpperCase(key);
        IF same(key,kYes) THEN        msg:=sYes; doit:=TRUE;
        ELSIF same(key,kYesAll) THEN  msg:=sYesAll; doit:=TRUE;promptuser:=FALSE;
        ELSIF same(key,kQuit) THEN    msg:=sQuit; continue:=FALSE;
        ELSIF same(key,kEsc) THEN     msg:=sQuit; continue:=FALSE;
        ELSIF same(key,kOui) THEN     msg:=sYes; doit:=TRUE;
        ELSIF same(key,kOuiTous) THEN msg:=sYesAll; doit:=TRUE;promptuser:=FALSE;
        ELSIF same(key,kNo) THEN      msg:=sNo;
        ELSE                          errbip(audio);askagain:=TRUE;
        END;
        IF NOT(askagain) THEN EXIT; END;
    END;
    WrStr(msg);WrLn;
END queryUser;

PROCEDURE doDel (VAR bytecount:HUGECARD;
                VAR filecount,dircount,fileskilled:LONGCARD;
                VAR promptuser,continue:BOOLEAN;
                fileanchor:pFileEntry; pdir:pDirEntry;
                useLFN,stats,killro,preview,audio:BOOLEAN);
VAR
    base:pathtype;
    p:pFileEntry;
    udne:pathtype;
    ROprotected:BOOLEAN;
    doit,silently:BOOLEAN;
BEGIN
    getDirStr(base,pdir);

    silently:=FALSE;
    continue:=TRUE;

    p:=fileanchor;
    WHILE p # NIL DO

        IF stats THEN
            IF (aD IN p^.fattr) THEN
                INC(dircount);
            ELSE
                INC(filecount);
                HUGEINC(bytecount, HUGECARD(p^.fsize));
            END;
        END;

        getFileStr(udne,p);
        Str.Prepend(udne,base);

        ROprotected:=(aR IN p^.fattr);

        IF promptuser THEN
            queryUser (promptuser,continue,doit,
                      useLFN,ROprotected,preview,audio, udne);
            IF continue=FALSE THEN RETURN; END;
        ELSE
            doit:=TRUE;
        END;
        IF killfile(silently,doit,useLFN,killro,promptuser,preview,ROprotected,udne) THEN
           INC(fileskilled);
        END;

        p:=p^.next;
    END;
END doDel;

PROCEDURE queryUserDir(VAR promptuser,continue,doit:BOOLEAN;
                        useLFN,preview,audio:BOOLEAN;base:pathtype);
VAR
    key : str2;
    msg:str16;
    canon:pathtype;
    askagain:BOOLEAN;
BEGIN
    Str.Concat(canon,base,"*.*");
    doit:=FALSE;

    WrLn;
    WrStr(strSUBDIR+" : "); WrStr(nice(useLFN,canon)); WrLn;

    IF preview THEN WrStr(sFake);END;
    WrStr(strPrompt);
    LOOP
        askagain:=FALSE;
        Flushkey;  key := Waitkey();  UpperCase(key);
        IF same(key,kYes) THEN        msg:=sYes; doit:=TRUE;
        ELSIF same(key,kYesAll) THEN  msg:=sYesAll; doit:=TRUE;promptuser:=FALSE;
        ELSIF same(key,kQuit) THEN    msg:=sQuit; continue:=FALSE;
        ELSIF same(key,kEsc) THEN     msg:=sQuit; continue:=FALSE;
        ELSIF same(key,kOui) THEN     msg:=sYes; doit:=TRUE;
        ELSIF same(key,kOuiTous) THEN msg:=sYesAll; doit:=TRUE;promptuser:=FALSE;
        ELSIF same(key,kNo) THEN      msg:=sNo;
        ELSE                          errbip(audio);askagain:=TRUE;
        END;
        IF NOT(askagain) THEN EXIT; END;
    END;
    WrStr(msg);WrLn;
END queryUserDir;

PROCEDURE doDelTree (VAR bytecount:HUGECARD;
                    VAR filecount,dircount,fileskilled:LONGCARD;
                    VAR promptuser,continue:BOOLEAN;
                    fileanchor:pFileEntry; pdir:pDirEntry;
                    useLFN,stats,killro,preview,audio:BOOLEAN);
VAR
    base:pathtype;
    p:pFileEntry;
    udne:pathtype;
    protected:BOOLEAN;
    doit,query,silently:BOOLEAN;
BEGIN
    getDirStr(base,pdir);

    silently:=TRUE;
    continue:=TRUE;

    IF promptuser THEN
        queryUserDir(promptuser,continue,doit, useLFN,preview,audio, base);
        IF continue=FALSE THEN RETURN; END;
    ELSE
        doit:=TRUE;
    END;
    IF doit=FALSE THEN
        IF preview THEN WrStr(sFake);END;
        WrStr(sSkippedDir);WrStr( nice(useLFN,base));WrLn;
        RETURN;
    END;

    query:=FALSE;

    p:=fileanchor;
    WHILE p # NIL DO

        IF stats THEN
            IF (aD IN p^.fattr) THEN
                INC(dircount);
            ELSE
                INC(filecount);
                HUGEINC(bytecount, HUGECARD(p^.fsize));
            END;
        END;

        getFileStr(udne,p);
        Str.Prepend(udne,base);

        protected:=(aR IN p^.fattr);

        IF killfile(silently,doit,useLFN,killro,query,preview,protected,udne) THEN
            INC (fileskilled);
        END;

        p:=p^.next;
    END;
    IF preview THEN WrStr(sFake);END;
    WrStr(sProcessedDir);WrStr( nice(useLFN,base));WrLn; (* not necessarily emptied *)
END doDelTree;

(* ------------------------------------------------------------ *)

PROCEDURE countEntries(useLFN:BOOLEAN;base:pathtype):CARDINAL;
VAR
    entries:CARDINAL;
    rootspec,entryname:pathtype;
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    w9Xentry : findDataRecordType;
    entry : FIO.DirEntry;
BEGIN
    entries:=0;

    Str.Concat(rootspec,base,"*.*"); (* was spec *)
    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
        unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            INC(entries);
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN entries;
END countEntries;

PROCEDURE doRemDir (useLFN,preview:BOOLEAN;dir:pathtype):BOOLEAN;
VAR
    rc:CARDINAL;
    base,S:pathtype;
    ok:BOOLEAN;
    msg:str80;
BEGIN
    Str.Copy(base,dir);
    unfixDirectory(base); (* FIO.RmDir does not like trailing "\" ! *)
    IF useLFN THEN
        IF w9XlongToShort(base,rc,S) THEN
            Str.Copy(base,S);
        END;
    END;
    IF preview THEN
        ok:=TRUE;
    ELSE
        FIO.RmDir(base); (* DOS path *)
        ok:= (FIO.IOresult()=DOSErr.NO_ERROR); (* true if directory found *)
    END;
    IF ok THEN
        msg:=sRemovedDir;
    ELSE
        msg:=sLeftDir;
    END;
    IF preview THEN WrStr(sFake);END;
    WrStr(msg);
    WrStr( nice(useLFN,dir));WrLn;
    RETURN ok; (* true if directory deleted *)
END doRemDir;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doDelFromList (VAR promptuser:BOOLEAN; VAR fileskilled:LONGCARD;
                    useLFN,killro,preview,audio,ignoreESC:BOOLEAN;
                    listfile:pathtype):CARDINAL;
VAR
    hin:FIO.File;
    udne:pathtype;
    pb,chkrounds,missing,rc:CARDINAL;
    protected,continue,doit,silently:BOOLEAN;
BEGIN
    chkrounds:=0;

    hin:=fileOpenRead(useLFN,listfile);
    FIO.AssignBuffer(hin,lstBuffer);

    pb:=0;
    missing:=0;
    silently:=FALSE;
    continue:=TRUE;

    (* yes, we could read each entry to memory then filter and process them all *)

    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,udne);
        IF FIO.EOF THEN EXIT; END;

        preprocessLine (udne);

        CASE udne[0] OF
        | CHR(0), semicolon,pound :
            ;
        ELSE
            IF chkJoker(udne) THEN
                INC(pb);
                IF preview THEN WrStr(sFake);END;
                WrStr(sIgnored);WrStr( nice(useLFN,udne));WrLn;
            ELSE
                IF fileExists(useLFN,udne) THEN
                    protected := fileIsRO(useLFN,udne);
                    IF promptuser THEN
                        queryUser (promptuser,continue,doit,
                                  useLFN,protected,preview,audio, udne);
                        IF continue=FALSE THEN EXIT;END;
                    ELSE
                        doit:=TRUE;
                    END;
                    IF killfile(silently,doit,useLFN,killro,promptuser,preview,protected,udne) THEN
                        INC(fileskilled);
                    END;
                ELSE
                    INC(missing);
                    IF preview THEN WrStr(sFake);END;
                    WrStr(sNotFound);WrStr( nice(useLFN,udne));WrLn;
                END;
            END;
        END;
        IF pollEscape(chkrounds,useLFN,ignoreESC) THEN continue:=FALSE;EXIT; END;
    END;
    FIO.Close(hin);
    IF continue=FALSE THEN RETURN errAborted;END;

    IF pb = 0 THEN
        IF missing = 0 THEN
            rc:=errNone;
        ELSE
            rc:=errGhostEntry;
        END;
    ELSE
        IF missing = 0 THEN
            rc:=errJokerEntry;
        ELSE
            rc:=errJokerGhost;
        END;
    END;
    RETURN rc;
END doDelFromList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getwidbg (  ):INTEGER ;
BEGIN
    RETURN -(28-1); (* Win<92|98|XP> forced us to use 31 *)
END getwidbg;

PROCEDURE getsepdbg (  ):str16;
BEGIN
    RETURN str16(" : ");
END getsepdbg;

PROCEDURE msgbool (flag:BOOLEAN;S,ST,SF:ARRAY OF CHAR);
VAR
    R:str80;
BEGIN
    Str.Copy(R,S);
    WrStr( padded ( getwidbg(),R) );
    WrStr( getsepdbg());
    IF flag THEN
        WrStr(ST);
    ELSE
        WrStr(SF);
    END;
    WrLn;
END msgbool;

(* don't change variable unless necessary *)

PROCEDURE chkEnvVar (VAR preview:BOOLEAN; whatvar : ARRAY OF CHAR):BOOLEAN ;
CONST
    sAllowed = "Y"+delim+"YES"+delim+"REALLY";
VAR
    R:str16;
    rc:BOOLEAN;
    i : CARDINAL;
BEGIN
    rc:=TRUE;
    Lib.EnvironmentFind(whatvar , R);
    LtrimBlanks(R);
    RtrimBlanks(R);
    IF same(R,"") THEN RETURN rc; END;
    CASE R[0] OF
    | "-" , "/" :
        ;
    ELSE
        Str.Prepend(R,"-");
    END;
    UpperCase(R);
    i := GetOptIndex(R, sAllowed);
    CASE i OF
    | 1..3 :
        preview:=FALSE;
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END chkEnvVar;

(* ------------------------------------------------------------ *)

(* see GetLongCard() in QD_Box *)

PROCEDURE removeOption (VAR R:ARRAY OF CHAR);
VAR
    p:CARDINAL;
BEGIN
    Str.Subst(R,equal,colon); (* command line option xxx= becomes xxx: *)
    p := Str.CharPos(R,colon);
    IF p # MAX(CARDINAL) THEN Str.Delete(R,0,p+1); END;
END removeOption;

PROCEDURE parseDate (S : ARRAY OF CHAR;
                     VAR dmy : CARDINAL) : BOOLEAN;
CONST
    century = 1900;
CONST
    digits   = "0123456789";
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
VAR
    i,day,month,year : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF v < 100 THEN INC(v,century); END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    year := CARDINAL(v);
    dmy:=PackDMY (day,month,year);
    RETURN TRUE;
END parseDate;

PROCEDURE parseDateRange (S:ARRAY OF CHAR;VAR lodate,hidate:CARDINAL):BOOLEAN;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
    d,m,y:CARDINAL;
    dow:Lib.DayType;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;

    (* not here, because dash can be a date separator ! *)
    (* ReplaceChar(S,dash, colon); (* change possible "*-*" range TO "*:*" *) *)

    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);

    IF p=MAX(CARDINAL) THEN
        IF same(S,"*") THEN                      (* today *)
            Lib.GetDate(y,m,d,dow);
            lodate:=PackDMY(d,m,y);
            rc:=TRUE;
        ELSE
            rc:=parseDate(S,lodate);
        END;
        hidate:=lodate;                          (* "$" means same *)
    ELSE
        Str.Slice(S1,S,0,p);
        Str.Delete(S,0,p+1); Str.Copy(S2,S);

        IF same(S1,"") THEN                      (* ":$" means before/on *)
            lodate:=PackDMY(1,1,0000);
            rc:=parseDate(S2,hidate);
        ELSIF same(S2,"") THEN                   (* "$:" means on/after *)
            hidate:=PackDMY(31,12,9999);
            rc:=parseDate(S1,lodate);
        ELSE
            rc:=parseDate(S1,lodate);
            IF rc THEN rc:=parseDate(S2,hidate); END;
        END;
    END;
    IF rc THEN
        rc:=(lodate <= hidate); (* safety check *)
    END;
    RETURN rc;
END parseDateRange;

PROCEDURE parseSizeRange (S:ARRAY OF CHAR;VAR losize,hisize:LONGCARD ):BOOLEAN ;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
    S1,S2:str128;
BEGIN
    removeOption(S); (* we had gotten an option "$:*" *)
    rc:=FALSE;
    ReplaceChar(S,dash, colon); (* change possible "*-*" range to "*:*" *)
    Str.Subst(S,dotdot,colon);  (* change possible "*..*" range to "*:*" *)
    p:=Str.CharPos(S,colon);
    IF p=MAX(CARDINAL) THEN
        Str.Concat(S1,colon,S);
        rc:=GetLongCard(S1,losize);
        hisize:=losize;                          (* "$" means exact size *)
    ELSE
        Str.Slice(S1,S,0,p); Str.Prepend(S1,colon);
        Str.Delete(S,0,p+1); Str.Concat(S2,colon,S);

        IF same(S1,colon) THEN                   (* ":$" means $ and less *)
            losize:=MIN(LONGCARD); (* complicated ways to mean 0 ! *)
            rc:=GetLongCard(S2,hisize);
        ELSIF same(S2,colon) THEN                (* "$:" means $ and more *)
            hisize:=MAX(LONGCARD);
            rc:=GetLongCard(S1,losize);
        ELSE
            rc:=GetLongCard(S1,losize);
            IF rc THEN rc:=GetLongCard(S2,hisize); END;
        END;
    END;
    IF rc THEN
        rc:=(losize <= hisize); (* safety check *)
    END;
    RETURN rc;
END parseSizeRange;

PROCEDURE parseMask (S:ARRAY OF CHAR; VAR m:masktype):BOOLEAN;
VAR
    included,excluded,indifferent:str16;
    i,len:CARDINAL;
    ch,keepch:CHAR;
    state:(wait,grab);
    rc:BOOLEAN;
    attrstate:attrstatetype;
BEGIN
    removeOption(S);

    (* accept ?+, ?-, ?x, ? (assuming ?+) : exemple A+R-H+ *)

    len:=Str.Length(S);
    FOR i:= 1 TO len DO
        ch:=S[i-1];
        IF Belongs(allowedAttr,ch) THEN
            IF CharCount(S,ch) > 1 THEN RETURN FALSE; END; (* avoid repeated or contradictory *)
        END;
    END;
    included := "";
    excluded := "";
    indifferent:="";
    i:=1;
    rc:=FALSE;
    state:=wait;
    LOOP
        IF i > len THEN rc:=TRUE; EXIT; END;
        ch:=S[i-1];
        CASE state OF
        | wait:
            CASE ch OF
            | "D","R","H","S","A" : keepch:=ch;
                IF (i+1) > len THEN Str.Append(included,keepch);END;
            ELSE
                EXIT;
            END;
            state:=grab;
        | grab:
            CASE ch OF
            | "+"         : Str.Append(included,keepch);
            | "-"         : Str.Append(excluded,keepch);
            | "?","!","X" : Str.Append(indifferent,keepch);
            | "D","R","H","S","A": Str.Append(included,keepch); (* fake "+" for previous flag *)
                DEC(i); (* but cancel next advance *)
            ELSE
                EXIT;
            END;
            state:=wait;
        END;
        INC(i);
    END;
    (* included and excluded don't share any attribute *)
    FOR i:=firstattr TO lastattr DO
        ch:=allowedAttr[i-1];
        IF Belongs(included,ch) THEN
            attrstate:=required;
        ELSIF Belongs(excluded,ch) THEN
            attrstate:=unwanted;
        ELSIF Belongs(indifferent,ch) THEN
            attrstate:=dontcare;
        ELSE
            attrstate:=dontcare;
        END;
        CASE ch OF
        | "D" : m.stateD := attrstate;
        | "R" : m.stateR := attrstate;
        | "H" : m.stateH := attrstate;
        | "S" : m.stateS := attrstate;
        | "A" : m.stateA := attrstate;
        END;
    END;
    RETURN rc;
END parseMask;

PROCEDURE fmtSizeRange (losize,hisize:LONGCARD):str80;
VAR
    R : str80;
BEGIN
    IF losize = hisize THEN
        Str.Copy(R,      fmtSize(losize,blank,"",FALSE ) );
    ELSE
        R:="[~..~]";
        Str.Subst(R,"~", fmtSize(losize,blank,"",FALSE ) );
        Str.Subst(R,"~", fmtSize(hisize,blank,"",FALSE ) );
    END;
    ReplaceChar(R,blank,"");
    RETURN R;
END fmtSizeRange;

PROCEDURE fmtDateRange (lodate,hidate:CARDINAL):str80;
VAR
    R:str80;
BEGIN
    IF lodate = hidate THEN
        Str.Copy(R, fmtDate(lodate,dateplain ) );
    ELSE
        R:="[~..~]";
        Str.Subst(R,"~", fmtDate(lodate,dateplain ) );
        Str.Subst(R,"~", fmtDate(hidate,dateplain ) );
    END;
    RETURN R;
END fmtDateRange;

PROCEDURE fmtMask (m:masktype):str80;
VAR
    R:str80;
    i:CARDINAL;
    ch:CHAR;
    attrstate:attrstatetype;
BEGIN
    R:="";
    FOR i:=firstattr TO lastattr DO
        ch:=allowedAttr[i-1];
        CASE ch OF
        | "D" : attrstate:=m.stateD;
        | "R" : attrstate:=m.stateR;
        | "H" : attrstate:=m.stateH;
        | "S" : attrstate:=m.stateS;
        | "A" : attrstate:=m.stateA;
        END;
        Str.Append(R,ch);
        CASE attrstate OF
        | dontcare: ch:="?";
        | required: ch:="+";
        | unwanted: ch:="-";
        END;
        Str.Append(R,ch);
        Str.Append(R," ");
    END;
    Rtrim(R," ");
    (* Str.Lows(R); *)
    RETURN R;
END fmtMask;

PROCEDURE preprocessFileFind (VAR S:pathtype):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    (* handle nonsense *)

    IF same(S,".") THEN RETURN FALSE; END;
    IF same(S,"..") THEN RETURN FALSE; END;

    (* each "[u:]filename" becomes "[u:]\filename" *)
    (* "[u:]\filename" is obviously legal *)
    (* add ".*" if no extension *)

    rc:=TRUE;

    (* \$ *)

    IF S[0] = "\" THEN
        IF Str.RCharPos(S,".") = MAX(CARDINAL) THEN Str.Append(S,".*");END;
        RETURN rc;
    END;

    (* $:\$ *)

    IF Str.Pos(S,":\") # MAX(CARDINAL) THEN
        IF Str.RCharPos(S,".") = MAX(CARDINAL) THEN Str.Append(S,".*");END;
        RETURN rc;
    END;

    IF Str.CharPos(S,"\") # MAX(CARDINAL) THEN RETURN FALSE; END; (* $\$ *)

    IF Str.CharPos(S,":") # MAX(CARDINAL) THEN (* $:$ *)
        Str.Subst(S,":",":\");
    ELSE
        Str.Prepend(S,"\"); (* $ because \$ was filtered earlier *)
    END;
    IF Str.RCharPos(S,".") = MAX(CARDINAL) THEN Str.Append(S,".*");END;
    RETURN rc;
END preprocessFileFind;

(*%F FIXCHKFIXSPEC *)

PROCEDURE preprocessDir (useLFN:BOOLEAN;VAR S:pathtype);
VAR
    u,d,n,e,ne:pathtype;
BEGIN
    IF fileIsDirectorySpec(useLFN,S) THEN RETURN; END;

    Lib.SplitAllPath(S, u,d,n,e);
    Lib.MakeAllPath(ne,"","",n,e);
    IF same(ne,"")=FALSE THEN
        IF Str.CharPos(ne,".") = MAX(CARDINAL) THEN Str.Append(S,".*"); END;
    END;
END preprocessDir;

(*%E *)

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE dodirswap (i,j:CARDINAL);
VAR
    pi,pj:pDirEntry;
    tmp:CARDINAL;
BEGIN
    pi:=findDirByIndex(i);
    pj:=findDirByIndex(j);
    tmp:=pi^.index;
    pi^.index:=pj^.index;
    pj^.index:=tmp;
END dodirswap;

PROCEDURE dofileswap (i,j:CARDINAL);
VAR
    pi,pj:pFileEntry;
    tmp:CARDINAL;
BEGIN
    pi:=findFileByIndex(i);
    pj:=findFileByIndex(j);
    tmp:=pi^.index;
    pi^.index:=pj^.index;
    pj^.index:=tmp;
END dofileswap;

PROCEDURE dolessdirname (i,j:CARDINAL):BOOLEAN;
VAR
    pi,pj:pDirEntry;
    SI,SJ: pathtype ;
BEGIN
    pi:=findDirByIndex(i);
    pj:=findDirByIndex(j);

    getDirStr(SI,pi);
    getDirStr(SJ,pj);

    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);
    RETURN ( Str.Compare(SI,SJ) < 0 ); (* -1 is less *)
END dolessdirname;

PROCEDURE dolessfilename (i,j:CARDINAL):BOOLEAN;
VAR
    pi,pj:pFileEntry;
    SI,SJ: pathtype ;
BEGIN
    pi:=findFileByIndex(i);
    pj:=findFileByIndex(j);

    getFileStr(SI,pi);
    getFileStr(SJ,pj);

    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);
    RETURN ( Str.Compare(SI,SJ) < 0 ); (* -1 is less *)
END dolessfilename;

PROCEDURE dolessfilesize (i,j:CARDINAL):BOOLEAN;
VAR
    pi,pj:pFileEntry;
BEGIN
    pi:=findFileByIndex(i);
    pj:=findFileByIndex(j);
    RETURN (pi^.fsize < pj^.fsize);
END dolessfilesize;

PROCEDURE dolessfileext (i,j:CARDINAL):BOOLEAN;
VAR
    pi,pj:pFileEntry;
    SI,SJ,u,d,n,ei,ej: pathtype ;
BEGIN
    pi:=findFileByIndex(i);
    pj:=findFileByIndex(j);

    getFileStr(SI,pi);
    getFileStr(SJ,pj);

    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);

    Lib.SplitAllPath(SI,u,d,n,ei); (* "u:" "\*\" "f" ".e" *) (* handles multiple dots *)
    Lib.SplitAllPath(SJ,u,d,n,ej); (* "u:" "\*\" "f" ".e" *) (* handles multiple dots *)

    CASE Str.Compare(ei,ej) OF
    | -1 : RETURN TRUE;
    |  0 : RETURN ( Str.Compare(SI,SJ) < 0 ); (* -1 is less *)
    |  1 : RETURN FALSE;
    END;
END dolessfileext;

PROCEDURE dolessfiledate (i,j:CARDINAL):BOOLEAN;
VAR
    pi,pj:pFileEntry;
    d,t,dti,dtj:LONGCARD;
BEGIN
    pi:=findFileByIndex(i);
    pj:=findFileByIndex(j);

    d:= LONGCARD (pi^.fdate);
    t:= LONGCARD (pi^.ftime);
    dti := (d << 16) + t;

    d:= LONGCARD (pj^.fdate);
    t:= LONGCARD (pj^.ftime);
    dtj := (d << 16) + t;

    RETURN (dti < dtj);
END dolessfiledate;

PROCEDURE dolessdirnamerev (i,j:CARDINAL):BOOLEAN;
BEGIN
    RETURN NOT ( dolessdirname(i,j) );
END dolessdirnamerev;

PROCEDURE dolessfilenamerev (i,j:CARDINAL):BOOLEAN;
BEGIN
    RETURN NOT ( dolessfilename(i,j) );
END dolessfilenamerev;

PROCEDURE dolessfiledaterev (i,j:CARDINAL):BOOLEAN;
BEGIN
    RETURN NOT ( dolessfiledate(i,j) );
END dolessfiledaterev;

PROCEDURE dolessfilesizerev (i,j:CARDINAL):BOOLEAN;
BEGIN
    RETURN NOT ( dolessfilesize(i,j) );
END dolessfilesizerev;

PROCEDURE dolessfileextrev (i,j:CARDINAL):BOOLEAN;
BEGIN
    RETURN NOT ( dolessfileext(i,j) );
END dolessfileextrev;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    cmdtype = (undefinedcmd,dirmode,delmode,deltreemode);
    sorttype= (nosort,byname,bysize,bydate,byext,
              bynamerev,bysizerev,bydaterev,byextrev);

PROCEDURE newcmd (VAR what:cmdtype; specified:cmdtype):BOOLEAN;
BEGIN
    IF ( (what=undefinedcmd) OR (what=specified) ) THEN
        what:=specified;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END newcmd;

PROCEDURE newsort (VAR what:sorttype; specified:sorttype):BOOLEAN;
BEGIN
    IF ( (what=nosort) OR (what=specified) ) THEN
        what:=specified;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END newsort;

PROCEDURE newcase (VAR what:casifyType; specified:casifyType):BOOLEAN;
BEGIN
    IF ( (what=orgcase) OR (what=specified) ) THEN
        what:=specified;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END newcase;

PROCEDURE procSort (sortmethod:sorttype;lastfile:CARDINAL);
BEGIN
    IF sortmethod # nosort THEN video(msgSortingFiles,TRUE); END;
    CASE sortmethod OF
    | nosort: ;
    | byname   : Lib.QSort(lastfile,dolessfilename   ,dofileswap);
    | bysize   : Lib.QSort(lastfile,dolessfilesize   ,dofileswap);
    | bydate   : Lib.QSort(lastfile,dolessfiledate   ,dofileswap);
    | byext    : Lib.QSort(lastfile,dolessfileext    ,dofileswap);
    | bynamerev: Lib.QSort(lastfile,dolessfilenamerev,dofileswap);
    | bysizerev: Lib.QSort(lastfile,dolessfilesizerev,dofileswap);
    | bydaterev: Lib.QSort(lastfile,dolessfiledaterev,dofileswap);
    | byextrev : Lib.QSort(lastfile,dolessfileextrev ,dofileswap);
    END;
    IF sortmethod # nosort THEN video(msgSortingFiles,FALSE); END;
END procSort;

PROCEDURE showParmsDelList (usingfilelist,useLFN,preview,audio,promptuser,killro:BOOLEAN);
BEGIN
    msgbool(usingfilelist  ,"Delete from list"       ,strY,strN);
    msgbool(useLFN         ,"LFN filesystem"         ,strY,strN);

    msgbool(preview        ,"Preview mode"           ,strY,strN);
    msgbool(promptuser     ,"Confirmation by user"   ,strY,strN);
    msgbool(audio          ,"Beep on unexpected choice",strY,strN);
    msgbool(killro         ,"Erase read-only files"  ,strY,strN);
END showParmsDelList;

PROCEDURE showParmsDel (cmd:cmdtype;
                       recurse,inverse,stats,useLFN,osjokers,
                       daterange,sizerange,preview,audio,promptuser,killro,
                       remroot,killemptyonly,flagIGNOREINI,flagFORCESWAPFILESPROTECTION:BOOLEAN;
                       maskfilter:masktype;
                       lodate,hidate:CARDINAL;losize,hisize:LONGCARD);
VAR
    ini:pathtype;
    inihere,actualswapfilesprotection:BOOLEAN;
BEGIN
    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    inihere:=fileExists(useLFN,ini);
    actualswapfilesprotection:=swapfilesprotectionFIX (flagFORCESWAPFILESPROTECTION,inihere,flagIGNOREINI);

    msgbool(recurse       ,"Recursion"              ,strY,strN);
    msgbool(inverse       ,"Invert specification"   ,strY,strN);
    msgbool(stats         ,"Show stats"             ,strY,strN);
    msgbool(useLFN        ,"LFN filesystem"         ,strY,strN);
  CASE cmd OF
  | delmode :
    msgbool(osjokers ,"Operating system jokers",strY,strN);
    msgbool(TRUE     ,"Attribute filter" , fmtMask(maskfilter),strN);
    msgbool(daterange,"Date range filter", fmtDateRange(lodate,hidate),strN);
    msgbool(sizerange,"Size range filter", fmtSizeRange(losize,hisize),strN);
  END;
    msgbool(preview       ,"Preview mode"           ,strY,strN);
    msgbool(promptuser    ,"Confirmation by user"   ,strY,strN);
    msgbool(audio         ,"Beep on unexpected choice",strY,strN);
    msgbool(killro        ,"Erase read-only files"  ,strY,strN);
  CASE cmd OF
  | deltreemode :
    msgbool(remroot       ,"Remove <filespec> root" ,strY,strN);
    msgbool(killemptyonly ,"Do not delete files"    ,strY,strN);
  END;
    msgbool(flagIGNOREINI,"Ignore "+progEXEname+extINI+" (cli)",strY,strN);
    msgbool(flagFORCESWAPFILESPROTECTION,"Protect Win swapfiles (cli)",strY,strN);
    msgbool(inihere,progEXEname+extINI+" found",strY,strN);
    msgbool(actualswapfilesprotection,"Autoprotect Win swapfiles",strY,strN);

    dmpProtected(useLFN,TRUE,lastEntryProtected );
END showParmsDel;

PROCEDURE showParmsDir (cmd:cmdtype;
                       recurse,inverse,showentries,stats,filefind,
                       useLFN,osjokers,daterange,sizerange,paging,flagIGNOREDAT,
                       forceLFNquotes:BOOLEAN;
                       maskfilter:masktype;
                       lodate,hidate:CARDINAL;losize,hisize:LONGCARD;
                       ink,paper:CARDINAL;casify:casifyType;sortmethod:sorttype;
                       pat:ARRAY OF CHAR);
VAR
    rpt:str128;
    ini:pathtype;
    inihere:BOOLEAN;
BEGIN
    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    inihere:=fileExists(useLFN,ini);

    msgbool(recurse       ,"Recursion"              ,strY,strN);
    msgbool(inverse       ,"Invert specification"   ,strY,strN);
    msgbool(showentries   ,"Show files"             ,strY,strN);
    msgbool(stats         ,"Show statistics"        ,strY,strN);
    msgbool(filefind      ,"Filefind mode"          ,strY,strN);
    msgbool(useLFN        ,"LFN filesystem"         ,strY,strN);
    msgbool(osjokers      ,"Operating system jokers",strY,strN);
    msgbool(TRUE          ,"Attribute filter" , fmtMask(maskfilter),strN);
    msgbool(daterange     ,"Date range filter", fmtDateRange(lodate,hidate),strN);
    msgbool(sizerange     ,"Size range filter", fmtSizeRange(losize,hisize),strN);
    msgbool(forceLFNquotes,"Force $dbnefy LFN enclosing",strY,strN);
    msgbool(TRUE          ,"Dir format (raw)"       ,nice(TRUE,pathtype(pat)),"");

    (* kludge matching msgbool *)
    WrStr( padded( getwidbg(),"Dir format (cooked)" ) );
    WrStr( getsepdbg());
    WrStr( dquote);
    wrcolored(FALSE, pat);
    color( ink, paper );
    WrStr(dquote+nl);

    msgbool(paging             ,"Paging"                 ,strY,strN);

    WrStr( padded( getwidbg(),"Pathnames case" ) );
    WrStr( getsepdbg());
    CASE casify OF
    | orgcase:   rpt:="unchanged";
    | lowercase: rpt:="forced to lower case";
    | uppercase: rpt:="forced to upper case";
    END;
    WrStr(rpt);WrLn;

    WrStr( padded( getwidbg(),"Sort" ) );
    WrStr( getsepdbg());
    CASE sortmethod OF
    | nosort   : rpt := "none";
    | byname   : rpt := "by name";
    | bysize   : rpt := "by size";
    | bydate   : rpt := "by date";
    | byext    : rpt := "by extension";
    | bynamerev: rpt := "by name (reversed)";
    | bysizerev: rpt := "by size (reversed)";
    | bydaterev: rpt := "by date (reversed)";
    | byextrev : rpt := "by extension (reversed)";
    END;
    WrStr(rpt);WrLn;

    msgbool(flagIGNOREDAT,"Ignore "+progEXEname+extINI+" definitions",strY,strN);
    msgbool(inihere,progEXEname+extINI+" found",strY,strN);

    dmpUserColor(TRUE,lastUserColor);
END showParmsDir;

PROCEDURE abortOnDefaultChanged (flag:BOOLEAN;errcode:CARDINAL;info:ARRAY OF CHAR);
BEGIN
    IF flag THEN abort(errcode,info);END;
END abortOnDefaultChanged;

(* if true, R1 = "u:*" RX = "uu...:*" *)

PROCEDURE isMultiUnits (VAR R1,RX:pathtype; S:pathtype):BOOLEAN;
VAR
    rc:BOOLEAN;
    p:CARDINAL;
BEGIN
    p:=Str.CharPos(S,colon);
    CASE p OF
    | 0,1,MAX(CARDINAL) :
        rc:=FALSE; (* illegal, one unit, no unit *)
    ELSE
        Str.Copy(R1,S); Str.Delete(R1,1,p-1); (* "abc:" becomes "a:" *)
        Str.Copy(RX,S); Str.Delete(RX,0,1);   (* "abc:" becomes "bc:" *)
        rc:=TRUE;
    END;
    RETURN rc;
END isMultiUnits;

PROCEDURE fixStorageError (VAR rc, ignoredstoragepb:CARDINAL;
                          fakeokstorage:BOOLEAN);
BEGIN
    IF rc=errStorage THEN
        IF fakeokstorage THEN
            rc:=errNone;
            INC(ignoredstoragepb);
        END;
    END;
END fixStorageError;

(* ------------------------------------------------------------ *)

CONST
    firstParm  = 1;
    maxParm    = 20; (* now, call that oversized ! *)
VAR
    parm     : ARRAY [firstParm..maxParm] OF pathtype;
    base     : ARRAY [firstParm..maxParm] OF pathtype;
    spec     : ARRAY [firstParm..maxParm] OF pathtype;
    status   : ARRAY [firstParm..maxParm] OF CARDINAL;
    matches  : ARRAY [firstParm..maxParm] OF LONGCARD;
VAR
    useLFN,recurse,killro,promptuser:BOOLEAN;
    usingfilelist,preview,stats,inverse,verbose,verbosebye:BOOLEAN;
    dirheader,dirheaderalways:BOOLEAN;
    showentries,remroot,paging,allowpause,forceLFNquotes,audio:BOOLEAN;
    flagIGNOREINI,flagFORCESWAPFILESPROTECTION,flagIGNOREDAT:BOOLEAN;
    divscreenrowcount,ignoreESC,killemptyonly:BOOLEAN;
    osjokers,filefind,showfnf,daterange,sizerange,usemask, singlestep: BOOLEAN;
    redirON,DEBUG : BOOLEAN;
    FAKEOKSTORAGE : BOOLEAN;
    IGNOREDSTORAGEPB:CARDINAL;
    lastparm:CARDINAL;
    S,R,listfile:pathtype;
    parmcount,i,opt:CARDINAL;
    ink,paper:CARDINAL;
    anchor,pdir:pDirEntry;
    cmd : cmdtype;
    ok,continue:BOOLEAN;
    sLegalUnits : str80; (* A..Z *)
    rc,dirndxflag:CARDINAL;
    pat,rpt:str128;
    bytecount:HUGECARD;
    filecount,dircount,fileskilled:LONGCARD; (* let's hope it's oversized ! ;-) *)
    chkrounds,rowcount,lastRow,deep:CARDINAL;
    casify:casifyType;
    lodate,hidate:CARDINAL;
    losize,hisize:LONGCARD;
    shuge : str1024; (* could be useful *)
    maskfilter:masktype;
    strmask:str80; (* in case user would be... well... absent-minded ? *)
    j,lastfile,lastdir:CARDINAL;
    sortmethod:sorttype;
    autonum:CARDINAL;
    autonumalpha:str16;
    comaUSER:CHAR;
    tersest : BOOLEAN;  (* worse than curiouser *)
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)

(*%T CHKSUMS  *)
    setSigmaUse (FALSE);
(*%E  *)

    (* handleVesa; *) (* useless, because we won't change video mode *)
    redirON :=  IsRedirected() ;
    setUseBiosMode ( redirON );
    findInkPaperAtStartup();
    ink   := ORD( getInkAtStartup() );
    paper := ORD( getPaperAtStartup() );
    ink   := ORD(defaultink);
    paper := ORD(defaultpaper);
    color(ink,paper);
    WrLn;               (* ok here *)

    cmd            := undefinedcmd;
    useLFN         := TRUE;
    recurse        := FALSE;
    pat            := "";
    killro         := FALSE;
    killemptyonly  := FALSE; (* -z specific *)
    promptuser     := TRUE;
    usingfilelist  := FALSE;
    preview        := TRUE;
    stats          := FALSE;
    inverse        := FALSE;
    remroot        := FALSE; (* change by -zz only *)
    paging         := FALSE;
    osjokers       := FALSE;
    flagIGNOREINI  := FALSE; (* -x will force existing ini to be ignored *)
    flagFORCESWAPFILESPROTECTION := TRUE;
    flagIGNOREDAT  := FALSE; (* -a will force existing ini to be ignored *)
    casify         := orgcase;
    filefind       := FALSE;
    verbose        := FALSE;
    verbosebye     := FALSE;
    showfnf        := FALSE;
    dirheader      := FALSE;
    dirheaderalways:= FALSE;
    showentries    := TRUE;
    forceLFNquotes := FALSE;
    ignoreESC      := FALSE;
    daterange      := FALSE;
    sizerange      := FALSE;
    usemask        := FALSE;
    ok:=parseMask(showfilesonly,maskfilter);
    strmask        := "";
    sortmethod     := nosort;
    audio          := TRUE;
    divscreenrowcount := FALSE;
    comaUSER       := comaFR;
    FAKEOKSTORAGE    := FALSE;
    IGNOREDSTORAGEPB := 0;
    tersest        := FALSE;
    DEBUG          := FALSE;
    lastparm       := firstParm-1;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,""); END;

    IF chkEnvVar(preview,sDDenv) = FALSE THEN abort(errBadEnv,sDDenv);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "??"+delim+
                                  "B"+delim+"BIOS"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "S"+delim+"RECURSE"+delim+
                                  "D"+delim+"DIR"+delim+"LIST"+delim+
                                  "K"+delim+"KILL"+delim+"DEL"+delim+
                                            "DELETE"+delim+"ERASE"+delim+
                                  "Z"+delim+"ZAP"+delim+
                                  "ZZ"+delim+"DELTREEROOT"+delim+
                                  "F:"+delim+"FMT:"+delim+
                                  "D:"+delim+"BYDATE:"+delim+
                                  "Z:"+delim+"BYSIZE:"+delim+
                                  "M:"+delim+"BYMASK:"+delim+
                                  "R"+delim+"O"+delim+"READONLY"+delim+
                                  "N"+delim+"NOPROMPT"+delim+
                                            "NOQUERY"+delim+"DONTASK"+delim+
                                  "@"+delim+"LISTMODE"+delim+
                                  "Y"+delim+"YES"+delim+"REALLY"+delim+
                                  "C"+delim+"COUNT"+delim+"STATS"+delim+
                                  "I"+delim+"INVERSE"+delim+
                                  "P"+delim+"PAGING"+delim+
                                  "X"+delim+"IGNOREINI"+delim+
                                  "T"+delim+"TEST"+delim+"Y-"+delim+"PREVIEW"+delim+
                                  "V"+delim+"SHOWPARMS"+delim+
                                  "VV"+delim+"SHOWPARMSQUIT"+delim+
                                  "J"+delim+"LOWERCASE"+delim+"LC"+delim+
                                  "U"+delim+"UPPERCASE"+delim+"UC"+delim+
                                  "KY"+delim+
                                  "ZY"+delim+
                                  "ZZY"+delim+
                                  "XDIR"+delim+
                                  "XDIRS"+delim+
                                  "XDEL"+delim+
                                  "XDELS"+delim+
                                  "DELTREE"+delim+
                                  "DD"+delim+
                                  "DDD"+delim+"DDS"+delim+
                                  "$"+delim+"ESC"+delim+

                                  "AD-"+delim+
                                  "AD"+delim+"AD+"+delim+
                                  "AD!"+delim+"AD?"+delim+"ADX"+delim+

                                  "AR-"+delim+
                                  "AR"+delim+"AR+"+delim+
                                  "AR!"+delim+"AR?"+delim+"ARX"+delim+

                                  "AH-"+delim+
                                  "AH"+delim+"AH+"+delim+
                                  "AH!"+delim+"AH?"+delim+"AHX"+delim+

                                  "AS-"+delim+
                                  "AS"+delim+"AS+"+delim+
                                  "AS!"+delim+"AS?"+delim+"ASX"+delim+

                                  "AA-"+delim+
                                  "AA"+delim+"AA+"+delim+
                                  "AA!"+delim+"AA?"+delim+"AAX"+delim+

                                  "???"+delim+
                                  "W"+delim+"WARN"+delim+"SHOWNOTFOUND"+delim+
                                  "F"+delim+"FIND"+delim+"FF"+delim+"FILEFIND"+delim+
                                  "SZ"+delim+"BYSIZE"+delim+"SS"+delim+
                                  "SN"+delim+"BYNAME"+delim+
                                  "SD"+delim+"BYDATE"+delim+
                                  "SE"+delim+"BYEXTENSION"+delim+
                                  "SZ-"+delim+"BYSIZE-"+delim+"SS-"+delim+
                                  "SN-"+delim+"BYNAME-"+delim+
                                  "SD-"+delim+"BYDATE-"+delim+
                                  "SE-"+delim+"BYEXTENSION-"+delim+
                                  "!"+delim+"JOKERS"+delim+"OS"+delim+
                                  "G"+delim+"DIRHEADER"+delim+

                                  (* dir terse crc32 md5 *)
                                  "FD"+delim+
                                  "FT"+delim+
                                  "FC"+delim+
                                  "FM"+delim+

                                  "CC"+delim+
                                  "E"+delim+"EMPTY"+delim+
                                  "ZE"+delim+
                                  "ZEY"+delim+
                                  "ZZE"+delim+
                                  "ZZEY"+delim+

                                  "FL"+delim+
                                  "FV"+delim+
                                  "A"+delim+"IGNOREDAT"+delim+
                                  "XX"+delim+ (* -xx is a mere alias for -x *)
                                  "Q"+delim+"QUOTES"+delim+
                                  "FS"+delim+
                                  "M"+delim+"BEEP"+delim+"QUIET"+delim+
                                  "SF"+delim+"SWAPS"+delim+"SWAPFILES"+delim+
                                  "P-"+delim+"PAGING-"+delim+
                                  "GG"+delim+
                                  "PP"+delim+
                                  "PP-"+delim+
                                  "&"+delim+"US"+delim+
                                  "MEM"+delim+"FAKE"+delim+
                                  "SKY"+delim+"KYS"+delim+
                                  "-"+delim+"TERSE"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1..3   : abort(errHelp,"");
            | 4      : abort(errMoreHelp,"");
            | 5..6   : setUseBiosMode ( TRUE );
            | 7..8   : useLFN    := FALSE;
            | 9..10  : recurse   := TRUE;
            | 11..13 : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
            | 14..18 : IF newcmd(cmd,delmode    )=FALSE THEN abort(errMode,"");END;
            | 19..20 : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
            | 21..22 : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                       remroot   := TRUE;
            | 23..24 : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                       GetString(S,pat); (* keep case *)
            | 25..26 : ok:=parseDateRange(R,lodate,hidate);
                       IF ok=FALSE THEN abort(errDateRange,S);END;
                       daterange := TRUE;
            | 27..28 : ok:=parseSizeRange(R,losize,hisize);
                       IF ok=FALSE THEN abort(errSizeRange,S);END;
                       sizerange := TRUE;
            | 29..30 : IF usemask THEN abort(errMaskRedefined,"");END;
                       ok:=parseMask(R,maskfilter);
                       IF ok=FALSE THEN abort(errMask,S);END;
                       usemask   := TRUE;
            | 31..33 : killro    := TRUE;
            | 34..37 : promptuser:= FALSE;
            | 38..39 : usingfilelist   := TRUE;
            | 40..42 : preview   := FALSE;
            | 43..45 : stats     := TRUE;
            | 46..47 : inverse   := TRUE;
            | 48..49 : paging    := TRUE;
            | 50..51 : flagIGNOREINI:= TRUE;
            | 52..55 : preview   := TRUE;
            | 56..57 : verbose   := TRUE;
            | 58..59 : verbose   := TRUE; verbosebye:=TRUE;
            | 60..62 : IF newcase(casify,lowercase)=FALSE THEN abort(errCasify,"");END;
            | 63..65 : IF newcase(casify,uppercase)=FALSE THEN abort(errCasify,"");END;
            | 66     : IF newcmd(cmd,delmode    )=FALSE THEN abort(errMode,"");END;
                       preview   :=FALSE; (* -ky = -k -y *)
            | 67     : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                       preview   :=FALSE; (* -zy = -z -y *)
            | 68     : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                       remroot   := TRUE;
                       preview   :=FALSE; (* -zzy = -zz -y *)
            | 69     : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
                       ok:=parseMask(showdirstoo,maskfilter);
                       stats     := TRUE; (* -xdir = -d -m:D! -c *)
            | 70     : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
                       ok:=parseMask(showdirstoo,maskfilter);
                       stats     := TRUE;
                       recurse   := TRUE; (* -xdirs = -d -m:D! -c -s *)
            | 71     : IF newcmd(cmd,delmode    )=FALSE THEN abort(errMode,"");END;
                       promptuser:= FALSE;
                       killro    := TRUE;
                       stats     := TRUE; (* -xdel = -k -n -r -c *)
            | 72     : IF newcmd(cmd,delmode    )=FALSE THEN abort(errMode,"");END;
                       promptuser:= FALSE;
                       killro    := TRUE;
                       stats     := TRUE;
                       recurse   := TRUE; (* -xdels = -k -n -r -c -s *)
            | 73     : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                       promptuser:= FALSE;
                       killro    := TRUE;
                       stats     := TRUE; (* -deltree = -z -n -r -c *)
            | 74     : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
                       ok:=parseMask(showdirstoo,maskfilter); (* -dd = -d -m:D! *)
            | 75..76 : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
                       ok:=parseMask(showdirstoo,maskfilter);
                       recurse   := TRUE; (* -ddd = -d -m:D! -s *)
            | 77..78 : ignoreESC := TRUE;

            | 79       : Str.Append(strmask,"D-");
            | 80..81   : Str.Append(strmask,"D+");
            | 82..84   : Str.Append(strmask,"D?");
            | 85       : Str.Append(strmask,"R-");
            | 86..87   : Str.Append(strmask,"R+");
            | 88..90   : Str.Append(strmask,"R?");
            | 91       : Str.Append(strmask,"H-");
            | 92..93   : Str.Append(strmask,"H+");
            | 94..96   : Str.Append(strmask,"H?");
            | 97       : Str.Append(strmask,"S-");
            | 98..99   : Str.Append(strmask,"S+");
            | 100..102 : Str.Append(strmask,"S?");
            | 103      : Str.Append(strmask,"A-");
            | 104..105 : Str.Append(strmask,"A+");
            | 106..108 : Str.Append(strmask,"A?");

            | 109      : abort(errEvenMoreHelp,"");
            | 110..112 : showfnf      := TRUE;
            | 113..116 : IF newcmd(cmd,dirmode    )=FALSE THEN abort(errMode,"");END;
                         recurse      := TRUE;
                         stats        := TRUE;
                         filefind     := TRUE;  (* only changed here *)
            | 117..119 : IF newsort(sortmethod,bysize)=FALSE THEN abort(errSort,"");END;
            | 120..121 : IF newsort(sortmethod,byname)=FALSE THEN abort(errSort,"");END;
            | 122..123 : IF newsort(sortmethod,bydate)=FALSE THEN abort(errSort,"");END;
            | 124..125 : IF newsort(sortmethod,byext )=FALSE THEN abort(errSort,"");END;
            | 126..128 : IF newsort(sortmethod,bysizerev)=FALSE THEN abort(errSort,"");END;
            | 129..130 : IF newsort(sortmethod,bynamerev)=FALSE THEN abort(errSort,"");END;
            | 131..132 : IF newsort(sortmethod,bydaterev)=FALSE THEN abort(errSort,"");END;
            | 133..134 : IF newsort(sortmethod,byextrev )=FALSE THEN abort(errSort,"");END;
            | 135..137 : osjokers := TRUE;
            | 138..139 : dirheader := TRUE;

            | 140      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         IF newcase(casify,lowercase)=FALSE THEN abort(errCasify,"");END;
                         pat           := sDirPat;
                         dirheader     := TRUE;
                         stats         := TRUE;
                         forceLFNquotes:=TRUE;
            | 141      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sTersePat;
            | 142      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sSumPat;
                         dirheader     := TRUE;
                         forceLFNquotes:=TRUE;
            | 143      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sMD5digestPat;
                         dirheader     := TRUE;
                         forceLFNquotes:=TRUE;

            | 144      : stats:=TRUE;
                         showentries:= FALSE;
                         (* paging     := FALSE; *)
            | 145..146 : killemptyonly:= TRUE;
            | 147      : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                         killemptyonly:= TRUE;    (* -ze *)
            | 148      : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                         preview      := FALSE;   (* -zy = -z -y *)
                         killemptyonly:= TRUE;    (* -zey *)
            | 149      : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                         remroot      := TRUE;
                         killemptyonly:= TRUE;    (* -zze *)
            | 150      : IF newcmd(cmd,deltreemode)=FALSE THEN abort(errMode,"");END;
                         remroot      := TRUE;
                         preview      := FALSE;   (* -zzy = -zz -y *)
                         killemptyonly:= TRUE;    (* -zzey *)

            | 151      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sListPat;
            | 152      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sFilesPat;
                         forceLFNquotes:= TRUE;

            | 153..154 : flagIGNOREDAT:=TRUE;
            | 155      : flagIGNOREINI:=TRUE; (* -xx is a mere alias for -x *)
            | 156..157 : forceLFNquotes:=TRUE;
            | 158      : IF same(pat,"")=FALSE THEN abort(errFormatRedefined,"");END;
                         pat           := sSHAdigestPat;
                         dirheader     := TRUE;
                         forceLFNquotes:=TRUE;
            | 159..161 : audio := FALSE;
            | 162..164 : flagFORCESWAPFILESPROTECTION:=FALSE;
            | 165..166 : paging    := FALSE;
            | 167      : dirheader := TRUE;
                         dirheaderalways := TRUE;
            | 168      : paging    :=TRUE;  divscreenrowcount:=TRUE;
            | 169      : paging    :=FALSE; divscreenrowcount:=TRUE;
            | 170,171  : comaUSER  := comaUS;
            | 172,173  : FAKEOKSTORAGE  := TRUE;
            | 174,175  : IF newcmd(cmd,delmode    )=FALSE THEN abort(errMode,"");END;
                         preview   :=FALSE; (* -ky = -k -y *)
                         recurse   :=TRUE;  (* -sky = -kys = -k -y -s *)
            | 176,177  : tersest := TRUE;
            | 178      : DEBUG := TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxParm THEN abort(errParameter,S);END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() ); (* here is a good idea *)

    CASE lastparm OF
    | firstParm-1 :
        IF NOT (verbosebye) THEN abort(errMissingSpec,""); END;
    ELSE
        Str.Copy(listfile, parm[firstParm]); (* let's assume listmode *)
        IF listfile[0] = "@" THEN
            Str.Delete( listfile,0,1);
            usingfilelist:=TRUE;
        END;
    END;

    (* no use to check remroot and filefind, trapped with /zz AND /f *)

    IF usingfilelist THEN
        CASE cmd OF
        | dirmode, deltreemode : abort(errNonsenseCmd,"");
        END;

        IF same(pat,"")=FALSE THEN abort(errNonsenseListMode,"-f:$");END;
        abortOnDefaultChanged(killemptyonly,errNonsenseListMode,"-e");
        (* abortOnDefaultChanged(stats        ,errNonsenseListMode,"-c"); *)
        abortOnDefaultChanged(recurse      ,errNonsenseListMode,"-s");
        abortOnDefaultChanged(inverse      ,errNonsenseListMode,"-i");
        abortOnDefaultChanged(paging       ,errNonsenseListMode,"-p");
        abortOnDefaultChanged(osjokers     ,errNonsenseListMode,"-!");
        abortOnDefaultChanged(dirheader    ,errNonsenseListMode,"-g[g]");
        abortOnDefaultChanged( NOT(showentries),errNonsenseListMode,"-cc");
        abortOnDefaultChanged(forceLFNquotes,errNonsenseListMode,"-q");
        abortOnDefaultChanged(flagIGNOREINI,errNonsenseListMode,"-x");
        abortOnDefaultChanged(flagIGNOREDAT,errNonsenseListMode,"-a");
        abortOnDefaultChanged(daterange    ,errNonsenseListMode,"-d:$");
        abortOnDefaultChanged(sizerange    ,errNonsenseListMode,"-z:$");
        abortOnDefaultChanged(usemask      ,errNonsenseListMode,"-m:$");
        IF same(strmask,"")=FALSE THEN abort(errNonsenseListMode,"-a<?>[?]");END;
        IF casify # orgcase THEN abort(errNonsenseListMode,"Any casify");END;
        IF sortmethod # nosort THEN abort(errNonsenseListMode,"Any sort");END;

        IF lastparm > firstParm THEN abort(errListSyntax,"");END;
        IF chkJoker(listfile) THEN abort(errListJoker,"");END;
        IF Str.CharPos(listfile,dot)=MAX(CARDINAL) THEN Str.Append(listfile,extLST);END;
      IF NOT(verbosebye) THEN
        IF fileIsDirectorySpec(useLFN,listfile) THEN abort(errListNotFile,"");END;
        IF fileExists(useLFN,listfile)=FALSE THEN abort(errListNotFound,listfile);END;
      END;
        IF verbose THEN
            showParmsDelList (usingfilelist,useLFN,preview,audio,promptuser,killro);
            IF verbosebye THEN abort(errNone,"");END;
            WrLn;
        END;

        fileskilled:=0;
        i:=doDelFromList (promptuser,fileskilled,
                         useLFN,killro,preview,audio,ignoreESC,listfile);
        CASE i OF
        | errJokerEntry: abort(errJokerEntry,"");
        | errGhostEntry: abort(errGhostEntry,"");
        | errJokerGhost: abort(errJokerGhost,"");
        | errAborted:    abort(errAborted,"");
        ELSE
            rpt:=strRptdel;
            Str.Subst(rpt, "~", nicefmtlc(filecount," ",comaUSER,1));
            Str.Subst(rpt, "~", nicefmtlc(fileskilled," ",comaUSER,1));
            IF stats THEN
                WrLn;
                WrStr(rpt);WrLn;
            END;
            abort(errNone,"");
        END;
    END;


    (* dir, del or deltree now *)


    IF cmd = undefinedcmd THEN ok:=newcmd(cmd,dirmode); END;

    CASE cmd OF
    | dirmode:
        IF same(pat,"") THEN (* not redefined using cli *)
            getEnvVar(pat,sDDfmtEnv);
            IF same(pat,"") THEN pat:=sDefaultPat; END; (* not redefined using env var *)
        END;
        abortOnDefaultChanged(killro             ,errNonsenseDirMode,"-r");
        abortOnDefaultChanged(killemptyonly      ,errNonsenseDirMode,"-e");
        abortOnDefaultChanged((promptuser=FALSE) ,errNonsenseDirMode,"-n");
        abortOnDefaultChanged((audio=FALSE)      ,errNonsenseDirMode,"-m");
        (* IF preview=FALSE THEN abort(errNonsenseDirMode,"-y");END; don't trigger env var ! *)
        (* abortOnDefaultChanged(flagIGNOREINI      ,errNonsenseDirMode,"-x"); *)
        IF same(strmask,"")=FALSE THEN
            IF usemask THEN abort(errMaskSetting,"");END;
            Str.Concat(R,fakeoption,strmask);
            usemask:= parseMask(R,maskfilter);
            IF usemask=FALSE THEN abort(errMaskOne,strmask);END;
        END;
        (*
        CASE maskfilter.stateD OF
        | dontcare,required : daterange:=FALSE; sizerange:=FALSE;
        END;
        *)
        IF filefind THEN
            maskfilter.stateD := unwanted; (* forced just in CASE *)
            (*
            here, we could split "uu...:*" filefind patterns
            updating lastparm and parm[], knowing real check is infra
            in fact, from "cdef:foo", we just fake manual "c:foo" "d:foo" etc.
            *)
            i:=firstParm;
            LOOP
                IF i > lastparm THEN EXIT; END;
                IF isMultiUnits(S,R,  parm[i]) THEN (* "ab...:" *)
                    INC(lastparm);
                    IF lastparm > maxParm THEN abort(errParameterFF,parm[i]);END;
                    Str.Copy(parm[i],S);        (* "a:*" *)
                    Str.Copy(parm[lastparm],R); (* "b...:*" *)
                END;
                INC(i);
            END;
        END;
        IF redirON THEN
            paging     := FALSE;
            allowpause := FALSE;
        ELSE
            allowpause := NOT(paging);
        END;
        singlestep     := FALSE; (* must persist with successive calls to doDir() *)

        rowcount := initpagingcounter; (* global *)

    | delmode:
        abortOnDefaultChanged(killemptyonly      ,errNonsenseDelMode,"-e");
        IF same(pat,"")=FALSE THEN abort(errNonsenseDelMode,"-f:$");END;
        abortOnDefaultChanged(paging             ,errNonsenseDelMode,"-p");
        abortOnDefaultChanged(dirheader          ,errNonsenseDelMode,"-g[g]");
        abortOnDefaultChanged(flagIGNOREDAT      ,errNonsenseDelMode,"-a");
        abortOnDefaultChanged( NOT(showentries)  ,errNonsenseDelMode,"-cc");
        abortOnDefaultChanged(forceLFNquotes     ,errNonsenseDelMode,"-q");
        IF casify # orgcase   THEN abort(errNonsenseDelMode,"Any casify");END;
        IF sortmethod # nosort THEN abort(errNonsenseDelMode,"Any sort");END;
        IF same(strmask,"")=FALSE THEN
            IF usemask THEN abort(errMaskSetting,"");END;
            Str.Concat(R,fakeoption,strmask);
            usemask:= parseMask(R,maskfilter);
            IF usemask=FALSE THEN abort(errMaskOne,strmask);END;
        END;
        (*
        CASE maskfilter.stateD OF
        | dontcare,required :      abort(errNonsenseDelMode,"-m:D<+|?>");
        END;
        *)
        maskfilter.stateD := unwanted; (* forced just in case *)
    | deltreemode :
        IF same(pat,"")=FALSE THEN abort(errNonsenseDeltreeMode,"-f:$");END;
        abortOnDefaultChanged(inverse           ,errNonsenseDeltreeMode,"-i");
        abortOnDefaultChanged(paging            ,errNonsenseDeltreeMode,"-p");
        abortOnDefaultChanged(osjokers          ,errNonsenseDeltreeMode,"-!");
        abortOnDefaultChanged(dirheader         ,errNonsenseDeltreeMode,"-g[g]");
        abortOnDefaultChanged(flagIGNOREDAT     ,errNonsenseDeltreeMode,"-a");
        abortOnDefaultChanged( NOT(showentries) ,errNonsenseDeltreeMode,"-cc");
        abortOnDefaultChanged(forceLFNquotes    ,errNonsenseDeltreeMode,"-q");
        abortOnDefaultChanged(daterange         ,errNonsenseDeltreeMode,"-d:$");
        abortOnDefaultChanged(sizerange         ,errNonsenseDeltreeMode,"-z:$");
        abortOnDefaultChanged(usemask           ,errNonsenseDeltreeMode,"-m:$");
        IF same(strmask,"")=FALSE THEN abort(errNonsenseDeltreeMode,"-a<?>[?]");END;
        IF casify # orgcase   THEN abort(errNonsenseDeltreeMode,"Any casify");END;
        IF sortmethod # nosort THEN abort(errNonsenseDeltreeMode,"Any sort");END;
        (*
        CASE maskfilter.stateD OF
        | dontcare,required :      abort(errNonsenseDeltreeMode,"-m:D<+|?>");
        END;
        *)
        maskfilter.stateD := unwanted; (* forced just in case *)
        recurse := TRUE; (* force it *)
    END;

    (* check, check ! *)

    getAllLegalUnits(TRUE,TRUE,TRUE,sLegalUnits); (* floppy,hd,CDROM *)
    IF DEBUG THEN WrStr("legal units : ");WrStr(sLegalUnits);WrLn;END;
    FOR i:=firstParm TO lastparm DO
        IF DEBUG THEN WrStr("parm : ");WrStr(parm[i]);WrLn; END;
        CASE cmd OF
        | dirmode :
            IF filefind THEN
                IF preprocessFileFind( parm[i])=FALSE THEN abort(errFF,parm[i]); END;
(*%F FIXCHKFIXSPEC *)
            ELSE
                preprocessDir(useLFN,  parm[i]);
(*%E *)
            END;
            IF DEBUG THEN
                (* IF filefind THEN WrStr("PARM : ");WrStr( parm[i] );WrLn; END; *)
                WrStr("PARM : ");WrStr( parm[i] );WrLn;
            END;
        | deltreemode:
            (* v1.0h illogical but safer fix *)
            IF same(parm[i],".") THEN
                IF remroot THEN
                    WrStr(msgNoRemrootHere);WrLn; (* warn user *)
                    remroot:=FALSE;
                END;
            ELSIF same(parm[i],"..") THEN
                abort(errDotdot,"");
            END;
        END;
        rc:= chkfixSpec( base[i],spec[i], useLFN,parm[i],sLegalUnits );
        IF DEBUG THEN
            WrStr("base : ");WrStr( base[i] );WrLn;
            WrStr("spec : ");WrStr( spec[i] );WrLn;
        END;
        status[i]:=rc; (* later use : errNone,errEntryIsFile,errEntryNotFound *)
        CASE rc OF
        | errNone:
            CASE cmd OF
            | deltreemode : (* deltree must kill every file *)
                IF same(spec[i],"*.*")=FALSE THEN abort(errKillThemAll,parm[i]);END;
            END;
        | errEntryIsFile, errEntryNotFound:
            ;
        ELSE
            abort(rc,parm[i]);
        END;
    END;

    CASE cmd OF
    | delmode,deltreemode :
        opt:=dataProtection;
        i:=initIniData (lastEntryProtected,lastUserColor,  opt,
                        flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                        flagIGNOREDAT,
                        useLFN,DEBUG);
        IF i # errNone THEN abort(i,""); END;

        IF verbose THEN
            showParmsDel(cmd, recurse,inverse,stats,useLFN,osjokers,
                              daterange,sizerange,preview,audio,promptuser,killro,
                              remroot,killemptyonly,flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                              maskfilter,lodate,hidate,losize,hisize);
            IF verbosebye THEN abort(errNone,"");END;
            WrLn;
        END;
    | dirmode:
        opt:=dataColors;
        i:=initIniData (lastEntryProtected,lastUserColor,  opt,
                        flagIGNOREINI,flagFORCESWAPFILESPROTECTION,
                        flagIGNOREDAT,
                        useLFN,DEBUG);
        IF i # errNone THEN abort(i,""); END;

        IF verbose THEN (* waste of time ! *)
            showParmsDir(cmd, recurse,inverse,showentries,stats,filefind,
                              useLFN,osjokers,daterange,sizerange,
                              paging,flagIGNOREDAT,forceLFNquotes,
                              maskfilter,lodate,hidate,losize,hisize,
                              ink,paper,casify,sortmethod,pat);
            IF verbosebye THEN abort(errNone,"");END;
            WrLn;
        END;
    END;

    chkrounds:=0; (* try and fix nasty Win9X behavior about ChkEscape *)

    (* step 1 : let's store directories *)

    IF DEBUG THEN showmem("before step 1 : initDirList");END;

    initDirList(diranchor);

    lastdir   :=firstEntry-1; (* global for all specs : must be here *)

    FOR i:=firstParm TO lastparm DO
        matches[i]:=0;
        (* remind we're in filefind mode *)
        IF cmd=dirmode THEN (* useless safety but cleaner  *)
            IF filefind THEN (* dirmode only *)
                rpt:=strRptlookingfor;
                Str.Subst(rpt,"~", base[i][0]);
                Str.Subst(rpt,"~", nice(useLFN,spec[i]));
                WrStr(rpt);WrLn;
            END;
        END;

        CASE status[i] OF
        | errNone:          ok := TRUE;
        | errEntryIsFile:   CASE cmd OF
                            | deltreemode :
                                ok:=FALSE; rpt:=sNotDir;
                            | dirmode, delmode:
                                ok:=TRUE ;
                            END;
        | errEntryNotFound: CASE cmd OF
                            | deltreemode :
                                ok:=FALSE; rpt:=sDNF;
                            | dirmode:
                                (*
                                IF showfnf THEN
                                    ok:=recurse; rpt:=sNotFound; (* v1.0j fix *)
                                ELSE
                                    ok:=TRUE;  (* silently hide it *)
                                END;
                                *)
                                ok:=TRUE; (* v1.0j fix : silently hide it for later *)
                            | delmode:
                                (*
                                ok:=recurse;     rpt:=sNotFound; (* v1.0j fix *)
                                *)
                                ok:=TRUE; (* v1.0j fix : silently hide it for later *)
                            END;
        END;
        IF ok THEN
            IF recurse THEN
                S:=msgProcessingRecurse;
            ELSE
                S:=msgProcessing;
            END;
            IF tersest THEN
                Str.Subst(S,"~", "");
            ELSE
                Str.Subst(S,"~", nice(useLFN,parm[i]));
            END;

            setCosmeticHackForPossibleProtection(S);
            video(S,TRUE);

            dirndxflag:=INDEXROOT; (* local : we can't init this value in recursive proc() *)
            rc:= buildDirList (diranchor,dirndxflag,lastdir, useLFN,recurse,TRUE,i,base[i]);

            video(S,FALSE);

            fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

            IF rc # errNone THEN abort(rc, parm[i] ); END;
            IF DEBUG THEN dmpDirs(diranchor,i,useLFN);WrLn;END;
        ELSE
            WrStr(rpt); WrStr( nice(useLFN, parm[i]) ); WrLn;
        END;
    END;

    IF DEBUG THEN showmem("after step 1 : buildDirList");END;

    IF cmd = dirmode THEN
        IF sortmethod # nosort THEN video(msgSortingDirs,TRUE); END;
        CASE sortmethod OF
        | byname   : Lib.QSort(lastdir,dolessdirname   ,dodirswap);
        | bynamerev: Lib.QSort(lastdir,dolessdirnamerev,dodirswap);
        ELSE
            ;
        END;
        IF sortmethod # nosort THEN video(msgSortingDirs,FALSE); END;
        IF DEBUG THEN dmpDirsAlt(diranchor,lastdir,useLFN);END;
    END;

    (* step 2 : let's list/delete files *)

    bytecount    := HUGEZERO; (* actualized even if not displayed *)
    filecount    := 0;
    dircount     := 0;
    fileskilled  := 0;

    autonum      := orgautonum; (* just in case we would need it *)
    autonumalpha := orgautonumalpha;

    IF DEBUG THEN showmem("before step 2 : storeFiles");END;

    FOR j:=firstEntry TO lastdir DO
        pdir:=findDirByIndex(j);

        FOR i:=firstParm TO lastparm DO
    (* before v1.0d
    FOR i:=firstParm TO lastparm DO
        FOR j:=firstEntry TO lastdir DO
            pdir:=findDirByIndex(j);
    *)
            ok:=( pdir^.specindex = SHORTCARD(i) );
            IF ok THEN
                initFileList(fileanchor);
                rc:=storeFiles (lastfile,fileanchor,
                               pdir,useLFN,inverse,sizerange,daterange,osjokers,
                               losize,hisize,lodate,hidate,maskfilter,
                               i,spec[i]);

                fixStorageError (rc,IGNOREDSTORAGEPB,  FAKEOKSTORAGE);

                IF rc # errNone THEN abort(rc, parm[i] ); END;
                INC( matches[i], LONGCARD ( lastfile) );

                IF cmd = dirmode THEN
                        procSort(sortmethod,lastfile);
                END;

                IF DEBUG THEN
                    dmpFiles(bytecount,filecount,dircount, fileanchor,pdir,i,useLFN);
                    WrLn;
                    IF sortmethod # nosort THEN
                    dmpFiles(bytecount,filecount,dircount, fileanchor,pdir,lastfile,useLFN);
                    END;
                ELSE
                    CASE cmd OF
                    | dirmode:
                        IF redirON THEN video(msgWorking,TRUE);END;
                        IF doDir (bytecount,filecount,dircount,rowcount,
                                 singlestep, autonum,autonumalpha,
                                 lastfile,pdir,
                                 useLFN,stats,showentries,paging,allowpause,
                                 dirheader,dirheaderalways,forceLFNquotes,divscreenrowcount,
                                 casify,comaUSER,pat) = FALSE THEN
                            IF redirON THEN video(msgWorking,FALSE );END;
                            freeFileList(fileanchor);
                            freeDirList(diranchor);
                            abort(errAborted,"");
                        END;
                        IF redirON THEN video(msgWorking,FALSE);END;

                    | delmode:
                        doDel (bytecount,filecount,dircount,fileskilled,promptuser,continue,
                               fileanchor,pdir,useLFN,stats,killro,preview,audio);
                        IF NOT(continue) THEN
                            freeFileList(fileanchor);
                            freeDirList(diranchor);
                            abort(errAborted,"");
                        END;
                    | deltreemode :
                        IF NOT(killemptyonly) THEN (* /e was NOT specified *)
                            doDelTree (bytecount,filecount,dircount,fileskilled,promptuser,continue,
                                      fileanchor,pdir,useLFN,stats,killro,preview,audio);
                            IF NOT(continue) THEN
                                freeFileList(fileanchor);
                                freeDirList(diranchor);
                                abort(errAborted,"");
                            END;
                        END;
                    END;
                END;

                freeFileList(fileanchor);
            END;
            IF pollEscape(chkrounds,useLFN,ignoreESC) THEN
                freeDirList(diranchor);
                abort(errAborted,"");
            END;
        END;
    END;

    IF DEBUG THEN showmem("after step 2 : storeFiles");END;

    (* v1.0j step 3 *)

    IF showfnf THEN
        CASE cmd OF
        | dirmode,delmode:
            FOR i:=firstParm TO lastparm DO
                IF matches[i]=0 THEN
                    color(ink,paper);
                    WrStr(sNotFound); WrStr( nice(useLFN, spec[i]) ); WrLn;
                END;
            END;
        END;
    END;

    (* step 4 *)

    CASE cmd OF
    | dirmode:
        IF stats THEN
            CASE maskfilter.stateD OF
            | required :
                rpt := strRptdirsOnly;
                Str.Subst(rpt, "~", nicefmtlc(dircount ," ",comaUSER,1));
            | dontcare :
                rpt := strRptdirsToo;
                Str.Subst(rpt, "~", nicefmtlc(filecount," ",comaUSER,1));
                Str.Subst(rpt, "~", nicefmtlc(dircount ," ",comaUSER,1));
                Str.Subst(rpt, "~", nicefmthc(bytecount," ",comaUSER,1));
            | unwanted:
                IF filefind THEN
                    IF filecount = 0 THEN
                        rpt:=strRptnomatch;
                    ELSE
                        rpt:=strRptmatches;
                    END;
                ELSE
                    rpt := strRptfiles;
                END;
                Str.Subst(rpt, "~", nicefmtlc(filecount," ",comaUSER,1));
                Str.Subst(rpt, "~", nicefmthc(bytecount," ",comaUSER,1));
            END;

            color( ink , paper );

            IF paging THEN
                lastRow:= getWindowHeight();
                FOR i:= 1 TO 2 DO
                    CASE i OF
                    | 1: pat:="";
                    | 2: pat:=rpt;
                    END;
                    WrStr(pat);WrLn;
                    IF waitAndSee (rowcount,  lastRow)=FALSE THEN abort(errAborted,"");END;
                END;
            ELSE
                WrLn;
                WrStr(rpt);WrLn;
            END;
        END;
        (* here in case someday we disable stats *)
        IF filefind THEN
            IF filecount=0 THEN abort(errNoFileMatchFound,"");END; (* all specs tried *)
        END;

    | delmode:
        IF stats THEN
            rpt:=strRptdel;
            Str.Subst(rpt, "~", nicefmtlc(filecount," ",comaUSER,1));
            Str.Subst(rpt, "~", nicefmtlc(fileskilled," ",comaUSER,1));
            Str.Subst(rpt, "~", nicefmthc(bytecount," ",comaUSER,1));
            color( ink , paper );
            WrLn;
            WrStr(rpt);WrLn;
        END;
    | deltreemode : (* now is time to remove directories if empty *)

        (* find highest number of directory separators i.e. deepest dir *)

        deep:=0;

        pdir:=diranchor;
        WHILE pdir # NIL DO
            getDirStr(S,pdir);
            i := CharCount(S,"\");
            IF i > deep THEN deep:=i; END;
            pdir:=pdir^.next;
        END;

        (* let's start from deepest dirs then go down to rootspec *)

        LOOP
            IF deep < 1 THEN EXIT; END;
            pdir:=diranchor;
            WHILE pdir # NIL DO
                ok:=(pdir^.specindex # DIRDONE);
                getDirStr(S,pdir);
                i:=CharCount(S,"\");
                ok := ( ok AND (i = deep) );
                IF ok THEN
                    IF remroot THEN
                        ok:=TRUE;
                    ELSE
                        ok:=( pdir^.dirndxflag # INDEXROOT );
                    END;
                    IF ok THEN
                        Str.Copy(R,S);
                        unfixDirectory(R); (* fileExists does not like trailing "\" *)
                        IF fileExists(useLFN, R ) THEN
                            IF countEntries(useLFN,S)=0 THEN (* ok for -e too *)
                                ok:= doRemDir (useLFN,preview,S);
                            END;
                        END;
                        (* we don't care if dir was not found, not empty or problematic *)
                        pdir^.specindex := DIRDONE;
                    END;
                END;
                pdir:=pdir^.next;
                IF pollEscape(chkrounds,useLFN,ignoreESC) THEN
                    freeDirList(diranchor);
                    abort(errAborted,"");
                END;
            END;
            DEC(deep);
        END;

        IF stats THEN
            rpt:=strRpttree;
            Str.Subst(rpt, "~", nicefmtlc(filecount," ",comaUSER,1));
            Str.Subst(rpt, "~", nicefmtlc(fileskilled," ",comaUSER,1));
            Str.Subst(rpt, "~", nicefmthc(bytecount," ",comaUSER,1));
            color( ink, paper );
            WrLn;
            WrStr(rpt);WrLn;
        END;

    END;

    IF DEBUG THEN showmem("almost done");END;

    freeDirList(diranchor);

    IF DEBUG THEN showmem("final");END;

    IF IGNOREDSTORAGEPB # 0 THEN
        WrStr("--- Storage.ALLOCATE() failure errors did happen and were ignored !");WrLn;
    END;

    abort(errNone,"");
END DD.

