(* ---------------------------------------------------------------
Title         Q&D Change Directory
Author        PhG
Overview      "C" useful... at last ! ;-)
Notes         Compact model
              - DOS internal command CHDIR does not like directory
                with a trailing "\" (FIO.ChDir does not either)
              - DOS CHDIR does not change unit
              - DOS CHDIR does not like directory enclosed with double quotes
                (but Win9X requires them)
              from v1.1b, we should no longer have a use for LFN flag (double quote prefix) but well...
              we handle floppy/hd/CDROM
Bugs          - ah ! chdir, whether from COMMAND.COM or from $213B is limited to 64 chars !
              - findanchor (unit ?)
              - message when used on floppy states it could not find dir using stored...
                even if there were no stored tree !
              - under XP, without any error message,
                C sometimes won't change to specified existing stored directory !
                yet this MAY work when using "=" flag... or even interactive mode !
                something to do with path length or accents ? seen with this path :
                "c:\documents and settings\all users\menu dmarrer\programmes\jowood\freak out - extreme freeride\"
                (checked using -v option)
                once again, so-called DOS emulation shows it's a BAD idea
                (and XP an even worse one : identical directory structure in 98 shows no such problem)
              - C seems not to find specified dir if first dir to search
                is very long including subdirs (ex: 6 subs, 90 chars...)

              - under XP, program may crash due to INVALID (sic!) 8086 opcode !
                most probable culprit is too many (3300+) subdirectories
                with huge and insane depth such as Titan Quest savegames

Wish List     shorten very long paths shown ? (u:...\* pattern ?)
              internal filefind (including archives supported in DIRBAT)
              with(out) jokers ?
              preserve accents when comparing ?

              should default behavior be :
              a) use stored tree
              b) reread if not found

              or

              always reread ? (environment var)

              exhaust all matches if first match is not found ?

              should -r store newly read directory tree ?
              well, code rewrite would be needed to free paths (see -c)

              force -c / -r if treeinfo.* is older than # days ?
              bah, just have maketree in startup.bat !

              compute CRC32 or MD5 for each matching file found ?

              if given one parm, try to CD to it before reading datafile ?

              DD is much faster because it scans in one pass :
              anyway, it won't allow successive chdirs on matches
              once again, "pourquoi adopter la manire simple
              puisqu'avec la manire complique, a marche aussi"...

              c -m    : 3.19s
              c -m -r : 4.51s
              dd -f   : 0.93s

--------------------------------------------------------------- *)

MODULE C;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT DOSErr;
IMPORT BiosIO;
IMPORT SYSTEM;
IMPORT IO;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE,HeapTotalAvail,MainHeap;

FROM IO IMPORT WrStr, WrLn;

FROM FIO IMPORT FIXEDLIBS;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;
CONST
    dquote        = '"';
    colon         = ":";
    backslash     = "\";
    netslash      = backslash+backslash;
    slash         = "/";
    dot           = ".";
    dotdot        = dot+dot;
    star          = "*";
    stardotstar   = star+dot+star;
    doublestar    = star+star;
    dotstar       = dot+star;
    nullchar      = CHR(0);
    beta          = CHR(225);
    dollar        = "$";
    equal         = "=";
    exclam        = "!";
    dash          = "-";
    blank         = " ";
    escape        = CHR(27);
    enter         = CHR(13);
    coma          = ",";
    charplus      = "+";
    semicolon     = ";";
    pound         = "#";
    immchars      = equal+charplus; (* not used in legal filenames *)
    immediateset  = "["+equal+"|"+charplus+"]";
CONST
    extDAT        = ".DAT";
    extLFN        = ".LFN";
    extEXE        = ".EXE";
    extINI        = ".INI";
    dirlistDOS    = backslash+"TREEINFO"+extDAT; (* root ! *)
    dirlistLFN    = backslash+"TREEINFO"+extLFN; (* root ! *)
    dirlistall    = backslash+"TREEINFO.<DAT|LFN>";
CONST
    alphabet      = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
TYPE
    opttype = (undefined,cd,create,find,listmatches,
              unsorted,alpha,pathlen,
              jokermode,fuzzmode,morefuzzmode);
CONST
    sEnvVar       = "QDCD"; (* uppercase *)



CONST
    minpattern      = 1;
    maxpattern      = 50; (* should do for now *)
    strMaxPattern   = "50";
VAR
    lastpattern     : CARDINAL;
    excludedpattern : ARRAY[minpattern..maxpattern] OF str128;
CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    lstBuffer : ioBufferType;



CONST
    progEXEname   = "C";
    progTitle     = "Q&D Partial Match Change Directory";
    progVersion   = "v1.1u";
    progCopyright = "by PhG";
    Banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errCommand      = 4;
    errSort         = 5;
    errSyntax       = 6;
    errTooManyDirs  = 7;
    errCreate       = 8;
    errBadUnits     = 9;
    errNonsense     = 10;
    errNonsenseS    = 11;
    errReading      = 12;
    errDirListFormat= 13;
    errExhausted    = 14;
    errAborted      = 15;
    errOnlyPhantoms = 16;
    errExclusive    = 17;
    errCannotProceed= 18;
    errSearchMode   = 19;
    errALLOC        = 20;
    errINI          = 21;

    errDone                   = 64;

    errChangeDir              = 128;
    errNotFound               = 129;
    errNoMatchInStored        = 130;
    errNoMatchRereading       = 131;
    errNotFoundAtAllInStored  = 132;
    errNotFoundAtAllRereading = 133;
    errNoMatchFoundInStored   = 134;
    errNoMatchFoundRereading  = 135;

    PROCEDURE enclose(VAR R:ARRAY OF CHAR);
    BEGIN
        Str.Prepend(R,dquote);
        Str.Append(R,dquote);
    END enclose;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);

    MODULE message;
    IMPORT Str,dquote;
    (* EXPORT msg3,enclose; *)
    EXPORT msg3;

    PROCEDURE msg3 (VAR R:ARRAY OF CHAR;S1,S2,S3:ARRAY OF CHAR);
    BEGIN
        Str.Concat(R,S1,S2);Str.Append(R,S3);
    END msg3;

    (*
    PROCEDURE enclose(VAR R:ARRAY OF CHAR);
    BEGIN
        Str.Prepend(R,dquote);
        Str.Append(R,dquote);
    END enclose;
    *)

    END message;

CONST
    cr=CHR(13);
    lf=CHR(10);
    nl=cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=nl+
Banner+nl+
nl+
"Syntax 1 : "+progEXEname+" [u[u]...:][ ]<subdir>... [-l-o-m[m]-v-i-e-g-r[-u|-a|-z]]"+nl+
"Syntax 2 : "+progEXEname+" [u[u]...:][ ]<filespec>... <-f[f]|-m[m] [-p-t]> [-l-o-r[-u|-a|-z]]"+nl+
"Syntax 3 : "+progEXEname+" [u[u]...:]... <-c> [-l[-u|-a|-z]]"+nl+
"Syntax 4 : "+progEXEname+nl+
nl+
"-f[f] immediately go to directory containing <filespec> (-ff = -f -r)"+nl+
'-m[?] list entries matching specification (-my, -mm, -mr, -mmy, -mry)'+nl+
"-p    list pathnames matching specification (default is filenames)"+nl+
"-t    terse mode when listing entries matching specification (-m[?] only)"+nl+
"-y    summary mode when listing entries matching specification (-m[?] only)"+nl+
"-c[?] create ?:"+dirlistall+" containing directory list (-cu, -ca, -cz)"+nl+
"-u    unsorted directory list (default)"+nl+
"-a    ASCII-sorted directory list"+nl+
"-z    pathlength-sorted directory list"+nl+
"-l    disable LFN support even if available"+nl+
"-o    search from root instead of current directory for first specified unit"+nl+
"-r[?] reread directory list(s), ignoring ?:"+dirlistall+" (-ru, -ra, -rz)"+nl+
"-s[s] alternate search mode (-ss = yet another alternate search mode)"+nl+
"-v    view list of matching directories (CD only if -i, -e or -g specified)"+nl+
"-i    interactive directory selection"+nl+
"-e    immediately go to exact match"+nl+
"-g    immediately go to exact match or to smallest match if no exact match"+nl+
"      (forced if any subdir matches "+immediateset+"*, *"+immediateset+" or "+immediateset+" alone)"+nl+
"-x    ignore existing "+progEXEname+extINI+nl+
nl+
"a) With syntaxes 1 and 2, -r option is forced if :"+nl+
"   - unit is a floppy (A:, B:) or a CDROM ;"+nl+
"   - ?:"+dirlistall+" do not exist."+nl+
"b) With syntax 3, floppies (A:, B:) and CDROM units are automatically excluded."+nl+
"c) Note -r[?] option DOES require a fast PC."+nl+
"d) Note -r[?] option does not update ?:"+dirlistall+" (if any)."+nl+
"e) -r[?] option may be always forced by setting "+sEnvVar+" environment variable :"+nl+
"   allowable values are U (unsorted), A (ASCII) or Z (path length)."+nl+
"f) Any error code above 127 means target (directory or file) was not found."+nl+
'g) -f[f] option automagically appends "'+dotstar+'" to <filespec> without "'+dot+'".'+nl+
"h) -m[m] option allows smarter than DOS jokers in <filespec> :"+nl+
'   "?" (any character) and "*" (any sequence, whether empty or not).'+nl+
"i) Directory names are excluded from search performed by -m[m] option."+nl+
(* "Whatever the syntax, specified unit search order is always preserved."+nl+ *)
'j) Empty removeable units will generate an "Abort, Retry, Fail ?" error.'+nl+
"k) With LFN support, ?:"+dirlistLFN+" is created in addition to ?:"+dirlistDOS+"."+nl+
"l) Up to "+strMaxPattern+" directory patterns (M2 jokers supported) can be ignored"+nl+
"   if they are specified in "+progEXEname+extINI+" located in executable directory :"+nl+
"   this feature may fix many random crashes under WinXP with deep tree depth."+nl+
"   Note patterns should be defined for both DOS and LFNs formats !"+nl+
(*%F FIXEDLIBS  *)
nl+
"Unfortunately, thanks to a fatal bug in TopSpeed Modula-2 FIO library,");WrLn;
"paths are limited to 65 characters (longer ones will NOT be found). :-("+nl+
(*%E  *)
nl+
"Examples : "+progEXEname+" c: MOD src"+nl+
(* "           "+progEXEname+" =z"+nl+ *)
(* "           "+progEXEname+" C:DOS"+nl+ *)
"           "+progEXEname+" m sr ="+nl+
"           "+progEXEname+" -mm cdef:*.dat"+nl;

(* "Program runs DOS internal CHDIR command if given a single u:\$ directory."+nl+ *)

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :
        msg3(S,"Unknown ",einfo," option !");
    | errParameter :
        msg3(S,einfo," is just one parameter ","too many !");
    | errCommand :
        S := "Syntax error !"; (* -c and -f[f]/-m[m] ! *)
    | errSort:
        S := "-u, -a and -z options are mutually exclusive !"; (* -c -r *)
    | errSyntax:
        msg3(S,"Syntax ",einfo," error !");
    | errTooManyDirs:
        msg3(S,"Too many directories in ",einfo," or not enough memory !");
    | errCreate:
        msg3(S,"Error while writing ",einfo," file !");
    | errBadUnits:
        msg3(S,"Illegal unit(s) in ",einfo," !");
    | errNonsense:
        msg3(S,einfo," option is a nonsense with specified syntax"," !");
    | errNonsenseS:
        msg3(S,einfo," options are a nonsense with specified syntax"," !");
    | errReading:
        msg3(S,einfo," loading could not be completed"," !");
    | errDirListFormat:
        msg3(S,"Mismatch between ",einfo," and LFN support !");
    | errExhausted:
        S := "No more match !";
    | errAborted:
        S := "Aborted by user !";
    | errOnlyPhantoms:
        S := "Specified list does not contain any valid unit !";
    | errExclusive:
        msg3(S,einfo," options are mutually exclusive"," !");
    | errCannotProceed:
        S := "No immediate match could be found !"; (* should never happen *)
    | errSearchMode:
        S := "-m and -mm options are mutually exclusive !";
    | errALLOC:
        msg3(S,"ALLOCATE() failure (",einfo,") !");
    | errINI:
        msg3(S,"Too many entries in ",einfo," !");

    | errDone:
        (* private joke ! eh C-dummy, it's just an unconditional branch after all ! *)
        S := "GOTO should NOT be considered harmful !";

    | errChangeDir:
        msg3(S,"Could not change to ",einfo," !");
    | errNotFound:
        msg3(S,einfo," does not exist"," !");
    | errNoMatchInStored:
        S:="No match could be found using stored directory list(s) !";
    | errNoMatchRereading:
        S:="No match could be found using reread directory list(s) !";
    | errNotFoundAtAllInStored:
        enclose(einfo);
        msg3(S,einfo," could not be found using stored directory list(s)"," !");
    | errNotFoundAtAllRereading:
        enclose(einfo);
        msg3(S,einfo," could not be found using reread directory list(s)"," !");
    | errNoMatchFoundInStored :
        msg3(S,einfo," using stored directory list(s)"," !");
    | errNoMatchFoundRereading :
        msg3(S,einfo," using reread directory list(s)"," !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errExhausted,errAborted: WrLn;
    END;
    CASE e OF
    | errDone:
        e:=errNone;
    | errNone, errHelp :
        ;
    ELSE
        CASE e OF
        | errNoMatchFoundInStored,errNoMatchFoundRereading:
            ; (* showListMatches already issued a WrLn *)
        ELSE
            WrLn;
        END;
        WrStr(progEXEname+" : "); WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE fmtSize (v : LONGCARD; pad:CHAR; sep:CHAR) : str80;
CONST
    field = 10+3; (* #,###,###,### *) (* what if file is one giga+, eh ? *)
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE showmem(S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    heapsize :=HeapTotalAvail(MainHeap);
    n :=16 * LONGCARD(heapsize);
    WrStr("::: ");
    (* WrStr(fmtlc(n,10,6," ","")); *)
    WrStr( fmtSize (n," ","") );
    WrStr(" byte(s) free -- ");WrStr(S);WrLn;
END showmem;

(* ------------------------------------------------------------ *)

(* // v1.1s uses earlier globerks *)

PROCEDURE initINIdata (dbg,ignoreINI:BOOLEAN;VAR ini:ARRAY OF CHAR):BOOLEAN;
(*
CONST
    dirpat1 = "*\"+dot;
    dirpat2 = "*\"+dotdot;
    INC(i);
    Str.Copy( excluded[i], dirpat1 );
    INC(i);
    Str.Copy( excluded[i], dirpat2 );
*)
CONST
    msg = "Reading directory patterns, please wait...";
VAR
    S : str128;
    hin:FIO.File;
    rc:BOOLEAN;
BEGIN
    lastpattern := minpattern-1;
    IF ignoreINI THEN RETURN TRUE; END;

    Lib.ParamStr(ini,0);
    UpperCase(ini); (* useless *)
    Str.Subst(ini,extEXE,extINI);
    IF FIO.Exists(ini)=FALSE THEN RETURN TRUE; END;

    video(msg,TRUE);

    rc:=TRUE;
    hin:=FIO.OpenRead(ini);
    FIO.AssignBuffer(hin,lstBuffer);

    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | CHR(0), semicolon,pound :
            ;
        ELSE
            LowerCaseAlt(S); (* keep accents *)

            INC(lastpattern);
            IF lastpattern > maxpattern THEN rc:=FALSE; EXIT;END;
            Str.Copy(excludedpattern[lastpattern],S);
            IF dbg THEN
                IO.WrCard(lastpattern,4);WrStr(" ");WrStr(S);WrLn;
            END;
        END;
    END;
    FIO.Close(hin);
    video(msg,FALSE);
    RETURN rc;
END initINIdata;

PROCEDURE includeIt (S:ARRAY OF CHAR):BOOLEAN;
VAR
    i : CARDINAL;
    rc: BOOLEAN;
BEGIN
    i := minpattern;
    LOOP
        IF i > lastpattern THEN rc:=TRUE;EXIT; END;
        IF Str.Match(S,excludedpattern[i]) THEN rc:=FALSE;EXIT; END;
        INC(i);
    END;
    (* IF rc=FALSE THEN WrStr("::: ignored : ");WrStr(S);WrLn;END; *)
    RETURN rc;
END includeIt;

(* ------------------------------------------------------------ *)

PROCEDURE me (S1,S2:ARRAY OF CHAR);
VAR
    len:CARDINAL;
BEGIN
    len:=Str.Length(S1);
    IF len < 25 THEN IO.WrCharRep(" ",25-len); END;
    WrStr(S1);WrStr(" : "+dquote);WrStr(S2);WrStr(dquote);WrLn;
END me;

(*
we may get an ugly Abort, Retry, Fail !

PROCEDURE isWriteableUnit (u:CHAR):BOOLEAN;
VAR
    path  : str16;
    entry : FIO.DirEntry;
    found : BOOLEAN;
    rw    : CARDINAL;
BEGIN
    Str.Concat(path,u,colon);
    Str.Append(path,backslash);
    Str.Append(path,stardotstar); (* "u:\*.*" *)
    rw := 0;
    found := FIO.ReadFirstEntry(path,FIO.FileAttr(aV),entry);
    WHILE found DO
        IF NOT(aR IN entry.attr) THEN
            INC(rw);
        END;
        found :=FIO.ReadNextEntry(entry);
    END;
    RETURN (rw # 0);
END isWriteableUnit;
*)

(* ------------------------------------------------------------ *)

PROCEDURE getUnitChar (u:SHORTCARD):CHAR;
BEGIN
    RETURN CHR(u+ORD("A")-1);
END getUnitChar;

PROCEDURE getUnitNumber (u:CHAR):SHORTCARD;
BEGIN
    RETURN SHORTCARD ( ORD(u)-ORD("A")+1 );
END getUnitNumber;

(* we don't fix directory here but we care about FIO.GetDir returning "u:\" which it should not *)

PROCEDURE getAnchor (useLFN:BOOLEAN; unit:SHORTCARD;
                    VAR shortform,longform:pathtype);
VAR
    rc:BOOLEAN;
    errcode:CARDINAL;
BEGIN
    FIO.GetDir(unit, shortform); (* 0=default, 1=A:, 2=B:, etc. *)
    IF Str.CharPos(shortform,colon)=MAX(CARDINAL) THEN (* always true, but who knows with win9X ? *)
        Str.Prepend(shortform,colon);
        Str.Prepend(shortform,getUnitChar(unit));
    END;
    IF useLFN THEN
        rc:=w9XshortToLong(shortform, errcode,longform);
    ELSE
        Str.Copy(longform,shortform);
    END;
END getAnchor;

(* ------------------------------------------------------------ *)

CONST
    firstPath = 1;   (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)
    maxPath   = 16000; (* should do for both DOS and Win9X and a few drives *)
    firstMatch= firstPath;
    maxMatch  = maxPath;

(* // we force a checked flag here ! *)

TYPE
    ptrToEntry = POINTER TO entrytype;
    entrytype  = RECORD
        checked : BOOLEAN;    (* // *)
        slen    : SHORTCARD;
        string  : CHAR; (* variable length *)
    END;
    PathType     = ARRAY[firstPath..maxPath] OF ptrToEntry;
    MatchingType = ARRAY[firstMatch..maxMatch] OF CARDINAL;   (* from best to worst *)
VAR
    Path     : POINTER TO PathType;
    Matching : POINTER TO MatchingType;

PROCEDURE getentry (i:CARDINAL; VAR R : pathtype);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path^[i]^.slen);
    Lib.FastMove( ADR(Path^[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

(* // we force lowercasealt and checked flag here ! *)

PROCEDURE setentry (i:CARDINAL; S : pathtype ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(entrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path^[i],needed);
        LowerCaseAlt(S); (* // *)
        Path^[i]^.checked:= FALSE; (* // *)
        Path^[i]^.slen   := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path^[i]^.string),len);
    ELSE
        Path^[i]:=NIL;
    END;
    RETURN (Path^[i] # NIL);
END setentry;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
VAR
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN
        Str.Copy(S,backslash);
    ELSE
        IF S[len-1] # backslash THEN
            Str.Append(S,backslash);
        END;
    END;
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

CONST
    nothingRequired = FIO.FileAttr{};

PROCEDURE doDir (root : pathtype;dbg,useLFN,eyecandy:BOOLEAN;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : pathtype;
    S       : pathtype;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
    full:pathtype;
    dosattr:FIO.FileAttr;
    isFile:BOOLEAN;
BEGIN
    IF dbg THEN eyecandy := FALSE; END; (* // v1.1s fix *)
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    fixDirPath(root); (* add required "\" here *)
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;
    Str.Copy(path,root); (* "\" already added *)
    Str.Append(path,stardotstar); (* root\*.* *)

    IF useLFN THEN
        found := w9XfindFirst (path,SHORTCARD(everything),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(path,everything,entry);
    END;
    WHILE found DO
        IF eyecandy THEN Animation(cmdShow); END;
        Str.Copy(S,root);
        fixDirPath(S);

        IF useLFN THEN
            Str.Copy(full,w9Xentry.fullfilename);
        ELSE
            Str.Copy(full,entry.Name);
        END;
        Str.Append(S,full); (* root\f8e3 *)
        isFile := NOT (  isDirEntry(full) ); (* skip "." AND ".." *)
        IF ( isFile AND includeIt(S) ) THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF (aD IN dosattr) THEN
                IF dbg THEN WrStr(S);WrLn;END; (* // v1.1s fix *)
                INC(index);
                doDir(S,dbg,useLFN,eyecandy,index,err);
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
END doDir;

PROCEDURE BuildPathList (dbg,continue,useLFN,recurse:BOOLEAN; rootdir : pathtype;
                        VAR lastpath : CARDINAL);
CONST
    msg1 = "Scanning ";
    msg2 = "Windows 9X ";
    msg3 = "directories for ";
    msg4 = colon+" unit ";
VAR
    found    : BOOLEAN;
    i        : CARDINAL;
    prompt   : pathtype; (* we may have a long filename *)
    error    : BOOLEAN;
BEGIN
    IF dbg THEN showmem("entering buildPathList()"); END;
    IF continue THEN
        i := lastpath+1; (* we'll use *next* entry henceforth the "+1" *)
    ELSE
        i := firstPath;  (* this is first entry henceforth no "-1" here *)
    END;
    error    := FALSE;
IF recurse THEN
    Str.Copy(prompt,msg1);
    IF useLFN THEN Str.Append(prompt,msg2);END;
    Str.Append(prompt,msg3);
    Str.Append(prompt,rootdir[0]);
    Str.Append(prompt,msg4);

    IF NOT(dbg) THEN
        video (prompt,TRUE);
        Animation(cmdInit);
    END;

    doDir(rootdir,dbg,useLFN,TRUE,i,error);

    IF NOT(dbg) THEN
        Animation(cmdStop);
        video (prompt,FALSE);
    END;
ELSE
    IF setentry(i,rootdir)=FALSE THEN error:=TRUE;END;
END;
    IF dbg THEN showmem("exiting buildPathList()"); END;
    IF error THEN i:=MAX(CARDINAL); END;
    lastpath:=i;
END BuildPathList;

PROCEDURE freePaths (lastpath:CARDINAL);
VAR
    i,len,needed:CARDINAL ;
BEGIN
    FOR i := firstPath TO lastpath DO
        IF Path^[i] # NIL THEN (* useless safety *)
            len := CARDINAL( Path^[i]^.slen);
            needed := SIZE(entrytype)-SIZE(CHAR)+len;
            DEALLOCATE(Path^[i],needed);
        END;
        Path^[i]:=NIL;
    END;
END freePaths;

PROCEDURE isLessAlpha (i,j : CARDINAL) : BOOLEAN;
VAR
    SI,SJ:pathtype;
BEGIN
    getentry(i,SI);
    getentry(j,SJ);
    LowerCase(SI); (* ignore accents when sorting *)
    LowerCase(SJ);
    IF Str.Compare(SI,SJ) < 0 THEN (* -1 is less *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isLessAlpha;

PROCEDURE isLessUsingSize (i,j : CARDINAL) : BOOLEAN;
VAR
    SI,SJ:pathtype;
    li,lj:CARDINAL;
BEGIN
    getentry(i,SI);
    getentry(j,SJ);
    li:=Str.Length(SI);
    lj:=Str.Length(SJ);
    IF li < lj THEN RETURN TRUE; END;
    IF li > lj THEN RETURN FALSE; END;
    (* same length, use alpha *)
    LowerCase(SI);
    LowerCase(SJ);
    IF Str.Compare(SI,SJ) < 0 THEN (* -1 is less *)
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END isLessUsingSize;

PROCEDURE doSwap (i,j : CARDINAL);
VAR
    S : ptrToEntry;
BEGIN
    S:=Path^[i];
    Path^[i]:=Path^[j];
    Path^[j]:=S;
END doSwap;

(* ------------------------------------------------------------ *)

(*
    check for actual existence of directory, assuming :
    1) no joker and 2) legal canonical
    we take care of trailing backslash
    we still check for jokers and "." / ".." just in CASE
    although these casees should NEVER, NEVER happen here
    because arg is got from stored list
*)

PROCEDURE direxists ( useLFN:BOOLEAN;canonicalpath:pathtype ):BOOLEAN;
VAR
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
    full:pathtype;
    dosattr:FIO.FileAttr;
BEGIN
    IF chkJoker(canonicalpath) THEN RETURN FALSE; END;
    unfixDirectory(canonicalpath); (* nobody seems to like trailing "\" ! glad we directory change string parm without intermediary storage *)
    IF useLFN THEN
        found := w9XfindFirst (canonicalpath,SHORTCARD(everything),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
        rc:=w9XfindClose(w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(canonicalpath,everything,entry);
    END;
    IF found THEN
        IF useLFN THEN
            Str.Copy(full,w9Xentry.fullfilename);
        ELSE
            Str.Copy(full,entry.Name);
        END;
        IF isDirEntry(full) THEN RETURN FALSE; END; (* skip . AND .. *)
        IF useLFN THEN
            dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
        ELSE
            dosattr:=entry.attr;
        END;
        found:=(aD IN dosattr);
    END;
    RETURN found;
END direxists;

(* ------------------------------------------------------------ *)

PROCEDURE buildDataPath (useLFN:BOOLEAN; u:CHAR;VAR datapath:pathtype);
BEGIN
    Str.Concat(datapath,u,colon);
    IF useLFN THEN
        Str.Append(datapath,dirlistLFN);
    ELSE
        Str.Append(datapath,dirlistDOS);
    END;
END buildDataPath;

(*
CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
*)
VAR
    ioBuffer  : ioBufferType;

(* LFNs have a double-quote prefix *)

PROCEDURE writeDirList (eyecandy,useLFN:BOOLEAN; lastpath:CARDINAL;
                       sortype:opttype; unit : CHAR) : BOOLEAN;
CONST
    msgUnsorted = "unsorted ";
    msgAlpha    = "ASCII-sorted ";
    msgPathlen  = "path length-sorted ";
    msg0 = "Writing ";
    msg1 = "Windows 9X ";
    msg2 = "directories to ";
    msg3 = " file ";
VAR
    datapath,prompt : pathtype; (* we may have a long filename *)
    hnd    : FIO.File;
    pb     : CARDINAL; (* should really be enough ! *)
    i      : CARDINAL;
    sdyn   : pathtype;
    R      : str80;
BEGIN
    buildDataPath(useLFN, unit, datapath);

    Str.Copy(prompt,msg0);
    CASE sortype OF
    | unsorted: R:=msgUnsorted;
    | alpha:    R:=msgAlpha;
    | pathlen:  R:=msgPathlen;
    END;
    Str.Append(prompt,R);
    IF useLFN THEN Str.Append(prompt,msg1);END;
    Str.Append(prompt,msg2);
    Str.Append(prompt,datapath);
    Str.Append(prompt,msg3);

    video (prompt,TRUE);
    IF eyecandy THEN Animation(cmdInit); END;

    pb := 0;
    hnd := FIO.Create(datapath);
    FIO.AssignBuffer(hnd,ioBuffer);
    INC(pb,FIO.IOresult());
    FOR i := firstPath TO lastpath DO
         IF eyecandy THEN Animation(cmdShow);END;
         getentry(i,sdyn);
         IF useLFN THEN Str.Prepend(sdyn,dquote);Str.Append(sdyn,dquote);END; (* marker *)
         FIO.WrStr(hnd,sdyn);
         INC(pb,FIO.IOresult());
         FIO.WrLn(hnd);
         INC(pb,FIO.IOresult());
    END;
    FIO.Close(hnd);
    INC(pb,FIO.IOresult());

    IF eyecandy THEN Animation(cmdStop); END;
    video (prompt,FALSE);

    RETURN (pb=0);
END writeDirList;

(* ------------------------------------------------------------ *)

PROCEDURE readDirList (dbg,continue,useLFN,eyecandy:BOOLEAN;unit:CHAR;
                      VAR lastpath,errcode:CARDINAL;
                      VAR einfo:ARRAY OF CHAR):BOOLEAN ;
CONST
    msg0 = "Reading ";
    msg1 = " file ";
VAR
    datapath,prompt : pathtype; (* we may have a long filename *)
    hnd    : FIO.File;
    pb,p   : CARDINAL; (* should really be enough ! *)
    sdyn   : pathtype;
BEGIN
    IF dbg THEN showmem("entering readDirList()"); END;

    buildDataPath(useLFN, unit, datapath);
    Str.Copy(einfo,datapath); (* default *)
    IF FIO.Exists(datapath)=FALSE THEN
        errcode:=errNotFound;
        RETURN FALSE;
    END;

    Str.Concat(prompt,msg0,datapath);Str.Append(prompt,msg1);
(*
    video (prompt,TRUE);
    IF eyecandy THEN Animation(cmdInit); END;
*)
    IF continue THEN
        ;
    ELSE
        lastpath := firstPath-1;
    END;
    pb       := 0;
    errcode  := errNone;

    FIO.EOF :=FALSE;
    hnd := FIO.OpenRead(datapath);
    FIO.AssignBuffer(hnd,ioBuffer);
    INC(pb,FIO.IOresult());

    LOOP
        IF FIO.EOF THEN EXIT; END;

(*        IF eyecandy THEN Animation(cmdShow);END; *)
        FIO.RdStr(hnd,sdyn);
        INC(pb,FIO.IOresult());
        IF Str.Length(sdyn) > 0 THEN
            IF sdyn[0] = dquote THEN
                IF useLFN = FALSE THEN errcode:=errDirListFormat; EXIT; END;
                Str.Delete(sdyn,0,1);
                p:=Str.RCharPos(sdyn,dquote);
                IF p # MAX(CARDINAL) THEN Str.Delete(sdyn,p,1);END;
            END;
            INC(lastpath);
            IF lastpath > maxPath THEN errcode:=errTooManyDirs; EXIT; END; (* einfo is datapath *)
            IF setentry(lastpath,sdyn)=FALSE THEN errcode:=errTooManyDirs;EXIT;END; (* yes, we should be more informative *)
        END;
    END;
    FIO.Close(hnd);
    INC(pb,FIO.IOresult());
(*
    IF eyecandy THEN Animation(cmdStop);END;
    video (prompt,FALSE);
*)
    IF dbg THEN showmem("exiting readDirList()"); END;
    IF errcode # errNone THEN RETURN FALSE; END;

    IF pb # 0 THEN errcode:=errReading; RETURN FALSE; END;
    RETURN TRUE;
END readDirList;

(* ------------------------------------------------------------ *)

PROCEDURE buildAndSort (unit:CHAR;dbg,continue,useLFN:BOOLEAN;sorttype:opttype;
                       VAR lastpath:CARDINAL);
VAR
    S : pathtype;
BEGIN
    Str.Concat(S,unit,colon);Str.Append(S,backslash);
    BuildPathList (dbg,continue, useLFN, TRUE, S, lastpath);
    IF lastpath = MAX(CARDINAL) THEN RETURN; END;
    CASE sorttype OF
    | unsorted :
        ;
    | alpha:
        Lib.QSort(lastpath,isLessAlpha,doSwap);
    | pathlen:
        Lib.QSort(lastpath,isLessAlpha,doSwap);
        Lib.QSort(lastpath,isLessUsingSize,doSwap);
    END;
END buildAndSort;

PROCEDURE newcmd (VAR what:opttype; specified:opttype):BOOLEAN;
BEGIN
    IF ( (what=undefined) OR (what=specified) ) THEN
        what:=specified;
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END newcmd;

(* ------------------------------------------------------------ *)

(* globerks *)

CONST
    firstparm = 1;
    maxparm   = 32; (* why 32 ? but why NOT 32 ? ;-) *)
    nofuzz    = 0;  (* exact match *)
    firstfuzz = 1;
    maxfuzz   = 3;
VAR
    parm        : ARRAY [firstparm..maxparm] OF pathtype;
    fuzz        : ARRAY [nofuzz..maxfuzz] OF pathtype;

(*
parse "[u[u]...:]..."

darn, we were lucky to check ":" alone,
because for Str.Match, "*" means 0 or more while "?" means one !
*)

PROCEDURE getCliUnits (lastparm:CARDINAL; VAR R:ARRAY OF CHAR):BOOLEAN;
VAR
    i,pb:CARDINAL;
    sUnits:str80;
    S:pathtype;
BEGIN
    Str.Copy(sUnits,"");
    pb:=0;
    FOR i:=firstparm TO lastparm DO
        Str.Copy(S, parm[i]);
        CASE CharCount(S,colon) OF
        | 1 :                                 (* only one "*:*"  *)
            CASE Str.CharPos(S,colon) OF
            | 0 :                             (* illegal  ":*"   *)
                INC(pb);
            ELSE
                IF Str.Match(S,"*:") THEN     (* ok       "*:"   *)
                    Str.Subst(S,colon,"");
                    Str.Append(sUnits,S);
                ELSE                          (* illegal  "*:*"  *)
                    INC(pb);
                END;
            END;
        ELSE
            INC(pb);
        END;
    END;
    Str.Copy(R,sUnits);
    RETURN (pb = 0);
END getCliUnits;

(*
   parse "[u[u]...:][ ]<subdir>..."
   we may return an empty sUnits if all were filtered out
   all units are removed from parm[] globerk : check we don't get an empty array
*)

PROCEDURE getTargetUnits (lastparm:CARDINAL; defaultUnit:CHAR;
                         VAR R : ARRAY OF CHAR):BOOLEAN;
VAR
    sUnits:str80;
    S:pathtype;
    p,pb,i:CARDINAL;
BEGIN
    Str.Copy(sUnits,"");
    pb:=0;
    FOR i:=firstparm TO lastparm DO
        Str.Copy(S,parm[i]);
        p:=Str.CharPos(S,colon);
        CASE i OF
        | firstparm:
            CASE CharCount(S,colon) OF
            | 0 :                              (* no unit specified *)
                ;
            | 1 :
                CASE p OF
                | 0 :
                    INC(pb);                   (* ":*" *)
                ELSE
                    Str.Slice(sUnits, S, 0, p);
                    Str.Delete(S,0,p+1);
                    Str.Copy(parm[i],S); (* units removed if any *)
                END;
            ELSE                               (* more than one ":" *)
                INC(pb);
            END;
        ELSE
            IF p # MAX(CARDINAL) THEN INC(pb);END; (* unit specification only in first parameter *)
        END;
    END;
    IF same(sUnits,"") THEN
        Str.Copy(R, CAP(defaultUnit) ); (* safety ! *)
    ELSE
        Str.Copy(R,sUnits);
    END;
    RETURN (pb = 0);
END getTargetUnits;

PROCEDURE filterUnits (someassemblyrequired:BOOLEAN;S:ARRAY OF CHAR;
                      VAR R, T:ARRAY OF CHAR);
CONST
    placeholder = "$";
VAR
    cdcount,i,p:CARDINAL;
    Z:str80;
    cdfirst,ch:CHAR;
BEGIN
    IF someassemblyrequired THEN
        (* S=hard disks, R=floppies/CDROM, T=original with phantoms and placeholders *)
        FOR i:=1 TO Str.Length(R) DO
            ch:=R[i-1];
            Str.Subst(T,placeholder,ch);
        END;
        Str.Concat(Z,S,R); (* Z=hard disks+floppies/CDROM *)
        FOR i:=1 TO Str.Length(T) DO
            ch:=T[i-1];
            IF Str.CharPos(Z,ch)=MAX(CARDINAL) THEN
                T[i-1]:=placeholder; (* phantom *)
            END;
        END;
        ReplaceChar(T,placeholder,"");
    ELSE
        (* S=original unit specs, R=hard disks, T=original order with placeholders *)
        Str.Copy(T,S);
        Str.Copy(R,"");
        getCDROMletters(cdcount,cdfirst, Z); Str.Prepend(Z,"AB");
        FOR i:=1 TO Str.Length(T) DO
            ch:=T[i-1];
            IF Str.CharPos(Z,ch) # MAX(CARDINAL) THEN
               Str.Append(R,ch);
               T[i-1]:=placeholder;
            END;
        END;
    END;
END filterUnits;

(* check reread, A:, B:, CDROM, hard disk *)

PROCEDURE isRereadNeeded (useLFN, flag:BOOLEAN;u:CHAR;units,special:ARRAY OF CHAR):BOOLEAN;
VAR
    datapath:pathtype;
BEGIN
    IF flag THEN RETURN TRUE; END; (* we specified -r *)
    IF Str.CharPos(special,u) # MAX(CARDINAL) THEN RETURN TRUE;END; (* reread if floppy or CDROM *)
    buildDataPath(useLFN, u, datapath);
    RETURN (FIO.Exists(datapath) = FALSE);
END isRereadNeeded;

PROCEDURE chkFastSpec (VAR flagGoto:BOOLEAN;VAR S:pathtype):BOOLEAN;
VAR
    len:CARDINAL;
    dostore:BOOLEAN;
BEGIN
    dostore:=TRUE;
    len:=Str.Length(S);
    IF len=1 THEN
        IF Str.CharPos(immchars,S[0]) # MAX(CARDINAL) THEN
            dostore:=FALSE;
            flagGoto:=TRUE;
        END;
    ELSE
        IF Str.CharPos(immchars,S[0]) # MAX(CARDINAL) THEN
            Str.Delete(S,0,1);
            flagGoto:=TRUE;
        ELSIF Str.CharPos(immchars,S[len-1]) # MAX(CARDINAL) THEN
            S[len-1]:=nullchar;
            flagGoto:=TRUE;
        END;
    END;
    RETURN dostore;
END chkFastSpec;

(*
    exact       \a\b\c                 \a   \b   \c

    fuzzy       *a*b*c*            *   a*   b*   c*

    fuzzy       \a*\b*\c*             \a*  \b*  \c*
    fuzzier     *a*b*c*            *   a*   b*   c*

    fuzzy       \a*\b*\c*             \a*  \b*  \c*
    fuzzier     *\a*\b*\c*         *  \a*  \b*  \c*
    fuzziest    *\*a*\*b*\*c*      * \*a* \*b* \*c*
*)


PROCEDURE buildFuzz (lastparm:CARDINAL;method:opttype):CARDINAL;
VAR
    i,k : CARDINAL;
    S,exact,fuzzy,fuzzier,fuzziest:pathtype;
    useOnlyExact:BOOLEAN;
BEGIN
    (* check if we merely want to go to root *)
    Str.Copy(S,"");
    FOR i:=firstparm TO lastparm DO
        Str.Append(S,parm[i]);
    END;
    useOnlyExact := same(S,backslash);

    CASE method OF
    | jokermode:
        Str.Copy(fuzzy,star);
    | fuzzmode:
        Str.Copy(fuzzy,"");
        Str.Copy(fuzzier,star);
    | morefuzzmode:
        Str.Copy(fuzzy,"");
        Str.Copy(fuzzier,star);
        Str.Copy(fuzziest,star);
    END;
    Str.Copy(exact,"");
    FOR i:=firstparm TO lastparm DO
        Str.Copy(S, parm[i]);
        IF same(S,"")=FALSE THEN          (* remember we removed unit(s) ! *)
            Str.Append(exact,backslash);
            Str.Append(exact,S);
            CASE method OF
            | jokermode:
                Str.Append(fuzzy,S);
                Str.Append(fuzzy,star);
            | fuzzmode:
                Str.Append(fuzzy,backslash);
                Str.Append(fuzzy,S);
                Str.Append(fuzzy,star);

                Str.Append(fuzzier,S);
                Str.Append(fuzzier,star);
            | morefuzzmode:
                Str.Append(fuzzy,backslash);
                Str.Append(fuzzy,S);
                Str.Append(fuzzy,star);

                Str.Append(fuzzier,backslash);
                Str.Append(fuzzier,S);
                Str.Append(fuzzier,star);

                Str.Append(fuzziest,backslash);
                Str.Append(fuzziest,star);
                Str.Append(fuzziest,S);
                Str.Append(fuzziest,star);
            ELSE
                ;
            END;
        END;
    END;
    k:=nofuzz;
    Str.Copy( fuzz[k],exact);
    IF NOT(useOnlyExact) THEN
        INC(k);
        Str.Copy( fuzz[k],fuzzy);
        CASE method OF
        | jokermode :
            ;
        ELSE
            INC(k); Str.Copy( fuzz[k],fuzzier);
            CASE method OF
            | fuzzmode :
                ;
            ELSE
                INC(k);
                Str.Copy( fuzz[k],fuzziest);
            END;
        END;
    END;
    FOR i:=nofuzz TO k DO
        Str.Copy(S, fuzz[i]);
        LowerCaseAlt( S );

        ReplaceChar(S,slash,backslash); (* internal unix sucks ! *)
        (* we may have specified backslashes, so remove any "\\" *)
        LOOP
            IF Str.Pos(S,netslash) = MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(S,netslash,backslash);
        END;
        (* we may have specified "*", so remove any "**" useless with Str.Match *)
        LOOP
            IF Str.Pos(S,doublestar) = MAX(CARDINAL) THEN EXIT; END;
            Str.Subst(S,doublestar,star);
        END;
        Str.Copy( fuzz[i], S);
    END;
    RETURN k;
END buildFuzz;

PROCEDURE findMatch (lastpath:CARDINAL;exact,signalNotFound:BOOLEAN;
                    wanted:pathtype):CARDINAL;
VAR
    i : CARDINAL;
    S : pathtype;
BEGIN
    i:=firstPath-1;
    LOOP
        INC(i);
        IF i > lastpath THEN EXIT; END;
        getentry(i,S);
        IF exact THEN
            IF same(S,wanted) THEN RETURN i; END;
        ELSE
            IF Str.Match(S,wanted) THEN RETURN i;END;
        END;
    END;
    IF signalNotFound THEN
        i:=MAX(CARDINAL);
    ELSE
        i:=firstPath;
    END;
    RETURN i;
END findMatch;

(* ------------------------------------------------------------ *)

(* for safety, don't assume anything about case *)

PROCEDURE findAnchor (lastpath:CARDINAL;rootanchor,useLFN:BOOLEAN;
                     sUnits:ARRAY OF CHAR;defaultDir:pathtype):CARDINAL;
VAR
    anchorndx:CARDINAL;
    wanted:pathtype;
    shortdir:pathtype;
    unit:SHORTCARD;
BEGIN
    fixDirectory(defaultDir); (* is enough here, fixDirPath not required *)
    LowerCaseAlt(defaultDir);
    LowerCaseAlt(sUnits);
    IF same(sUnits,"") THEN
        Str.Copy(wanted,defaultDir);
    ELSE
        IF sUnits[0]=defaultDir[0] THEN
            Str.Copy(wanted,defaultDir);
        ELSE
            (* unit:= getUnitNumber ( CAP(sUnits[0]) ); (* brutal uppercase *) *)
            unit:=FIO.GetDrive(); (* retrieve current *)
            getAnchor(useLFN,unit,shortdir,wanted);
        END;
    END;
    IF rootanchor THEN
        wanted[3]:=nullchar; (* brutal way to say "u:\" *)
    END;
    fixDirectory(wanted);
    LowerCaseAlt(wanted);
    anchorndx:=findMatch(lastpath,TRUE,FALSE,wanted); (* exact,firstpath if not found,keep unit *)
    (* now, stay at root if we wanted a root or if default is already root *)
    IF Str.Length(wanted) > 3 THEN (* not "u:\" *)
        INC(anchorndx); (* go right after anchor *)
        IF anchorndx > lastpath THEN anchorndx:=firstPath;END;
    END;
    RETURN anchorndx;
END findAnchor;

PROCEDURE buildMatch (VAR lastmatch:CARDINAL;
                     lastpath,anchorndx:CARDINAL;
                     DEBUG,useLFN,justreread,exact:BOOLEAN;wanted:pathtype);
VAR
    i:CARDINAL;
    S,SS:pathtype;
    found,ok:BOOLEAN;
BEGIN
    i:=anchorndx;
    LOOP
        IF Path^[i]^.checked = FALSE THEN
            getentry(i,SS);
            Str.Copy(S,SS);
            Str.Delete(S,0,2); (* remove "u:" *)
            IF exact THEN
                found:=same(S,wanted);
            ELSE
                found:=Str.Match(S,wanted);
            END;
            IF found THEN
                (* // v1.1k *)
                ok:=(justreread OR DEBUG);
                IF NOT(ok) THEN ok:=direxists(useLFN,SS);END;
                IF ok THEN
                    INC(lastmatch); (* useless to check for overflow here ! *)
                    Matching^[lastmatch]:=i;
                    Path^[i]^.checked:=TRUE;
                END;
            END;
        END;
        INC(i);
        IF i > lastpath THEN i:=firstPath;END;
        IF i = anchorndx THEN EXIT; END;
    END;
END buildMatch;

PROCEDURE buildAllMatches (DEBUG,useLFN,justreread:BOOLEAN; lastpath,lastfuzz,anchorndx:CARDINAL):CARDINAL;
VAR
    i,lastmatch:CARDINAL;
    exact:BOOLEAN;
BEGIN
    lastmatch:=firstMatch-1;
    exact:=FALSE;
    FOR i:=firstfuzz TO lastfuzz DO                     (* fuzzy, fuzzier, fuzziest... *)
        buildMatch(lastmatch, lastpath,anchorndx,DEBUG,useLFN,justreread,exact,fuzz[i]);
    END;
    exact:=TRUE;
    i:=nofuzz;
    buildMatch(lastmatch, lastpath,anchorndx,DEBUG,useLFN,justreread,exact,fuzz[i]);     (* ... then exact to avoid it being always alone *)
    IF lastmatch < firstMatch THEN lastmatch:=MAX(CARDINAL);END;
    RETURN lastmatch;
END buildAllMatches;

(* ------------------------------------------------------------ *)

(* ripped from QD_Box *)

PROCEDURE runFromWinXP (  ):BOOLEAN;
CONST
    WinXPconsoleMajor = 5;
    WinXPconsoleMinor = 50;
VAR
    major,minor:CARDINAL;
BEGIN
    w9XgetTrueDOSversion (major,minor);
    IF major = WinXPconsoleMajor THEN
        IF minor = WinXPconsoleMinor THEN RETURN TRUE; END; (* risky business ! *)
    END;
    RETURN FALSE;
END runFromWinXP;

(*
INT 21 - DOS 1+ - SELECT DEFAULT DRIVE
*)

PROCEDURE doChangeUnit (u:CHAR):BOOLEAN;
VAR
    rc:BOOLEAN;
    R:SYSTEM.Registers;
    unit,validletters:SHORTCARD;
BEGIN
    u:=CAP(u); (* safety *)
    CASE u OF
    | "A".."Z" :
        unit:=SHORTCARD( ORD(u)-ORD("A") ); (* 0=a:, 1=b:, etc. *)
        R.AH:=0EH;
        R.DL:=unit;
        Lib.Dos(R);
        validletters:=R.AL;
        rc:=( unit < validletters ); (* 0.. against 1.. so we use < here *)
        rc:=TRUE; (* bah, let's assume caller has already checked specified unit *)
    ELSE
        rc:=FALSE;
    END;
    RETURN rc;
END doChangeUnit;

PROCEDURE doChangeDir (useLFN:BOOLEAN; where:pathtype ):BOOLEAN;
CONST
    DBG = FALSE;
VAR
    ucolon,cmd,target,shortform : pathtype;
    rc,rcdos : CARDINAL;
    ok : BOOLEAN;
BEGIN
    Str.Slice(ucolon,where,0,2); (* "u:" ok whatever lfn *)
    unfixDirectory(where); (* nobody seems to like trailing "\" ! *)
IF DBG THEN WrStr("where  : ");WrStr(where);WrLn; END;
    IF useLFN THEN
        (* Str.Concat(target,dquote,where);Str.Append(target,dquote); *)
        Str.Copy(target,where);
    ELSE
        Str.Copy(target,where);
    END;

    ok:=doChangeUnit(ucolon[0]); (* was a stupid Lib.ExecCmd(ucolon) ! *)
IF DBG THEN WrStr("ucolon : ");WrStr(ucolon[0]);WrLn; END;
    IF useLFN THEN
        ok:=w9XchangeDir (target, rc);
IF DBG THEN WrStr("LFN    : ");WrStr(target);WrLn;END;
        IF ok=FALSE THEN (* try DOS f8e3 *)
            IF w9XlongToShort (target, rcdos,shortform) THEN
IF DBG THEN WrStr("LFNDOS : ");WrStr(shortform);WrLn; END;
                FIO.ChDir (shortform); (* still limited to 64 chars ! was target before v1.1t *)
                rc:=FIO.IOresult(); (* 0 is supposed to mean that all went smoothly *)
                ok:=(rc=0);
            END;
        END;
    ELSE
        (*
        Str.Concat(cmd,"CHDIR ",target);
        ok:=doChangeUnit(ucolon[0]); (* was a stupid Lib.ExecCmd(cmd) ! *)
        *)
IF DBG THEN WrStr("DOS    : ");WrStr(target);WrLn; END;
        FIO.ChDir (target); (* still limited to 64 chars ! *)
        rc:=FIO.IOresult(); (* 0 is supposed to mean that all went smoothly *)
        ok:=(rc=0);
    END;
    RETURN ok;
END doChangeDir;

(* ------------------------------------------------------------ *)

PROCEDURE selectIt (VAR errcode:CARDINAL;
                   lastmatch:CARDINAL;defaultDir:pathtype):CARDINAL;
CONST
    help     = " [CR=Yes,Space=Next,Esc] ? ";
    strYes   = "Y";
    strOui   = "O";
    strCR    = CHR(13);
    strEsc   = CHR(27);
    strSpace = " ";
    argh     = MAX(CARDINAL);
VAR
    i:CARDINAL;
    S,prompt:pathtype;
    ch:str2;
BEGIN
    fixDirectory(defaultDir); (* is enough here, fixDirPath not required *)
    LowerCaseAlt(defaultDir);

    i:=firstMatch-1;
    LOOP
        INC(i);
        IF i > lastmatch THEN errcode:=errExhausted;RETURN argh;END;
        getentry(Matching^[i],S);
        IF same(S,defaultDir)=FALSE THEN
            Str.Concat(prompt,S,help);
            video(prompt,TRUE);
            LOOP
                ch := Waitkey();
                UpperCase(ch);
                IF same(ch,strCR )   THEN errcode:=errHelp;EXIT;END;
                IF same(ch,strYes)   THEN errcode:=errHelp;EXIT;END;
                IF same(ch,strOui)   THEN errcode:=errHelp;EXIT;END;
                IF same(ch,strSpace) THEN errcode:=errNone;EXIT;END;
                IF same(ch,strEsc)   THEN errcode:=errAborted;EXIT;END;
            END;
            video(prompt,FALSE);
            CASE errcode OF
            | errHelp:     RETURN i;
            | errAborted:  RETURN argh;
            END;
        END;
    END;
END selectIt;

CONST
    noMatchFound=MAX(CARDINAL);

PROCEDURE selectGotoMatch (exactonly:BOOLEAN;lastmatch:CARDINAL):CARDINAL;
CONST
    argh=noMatchFound;
VAR
    i,len,isav,lensav : CARDINAL;
    S,wanted:pathtype;
BEGIN
    Str.Copy(wanted,fuzz[nofuzz]);
    fixDirectory(wanted);

    i:=firstMatch-1;
    LOOP
        INC(i);
        IF i > lastmatch THEN EXIT; END;
        getentry(Matching^[i],S);
        Str.Delete(S,0,2); (* remove "u:" *)
        IF same(S,wanted) THEN RETURN i; END;
    END;

    IF exactonly THEN RETURN argh;END;

    isav:=argh;
    lensav:=MAX(CARDINAL);
    Str.Copy(wanted,fuzz[firstfuzz]);
    fixDirectory(wanted);
    i:=firstMatch-1;
    LOOP
        INC(i);
        IF i > lastmatch THEN EXIT; END;
        getentry(Matching^[i],S);
        Str.Delete(S,0,2); (* remove "u:" *)
        IF Str.Match(S,wanted) THEN
            len:=Str.Length(S);
            IF len < lensav THEN
                lensav:=len;
                isav:=i;
            END;
        END;
    END;
    RETURN isav;
END selectGotoMatch;

(* ------------------------------------------------------------ *)

PROCEDURE foundHere (useLFN:BOOLEAN; root,spec:pathtype;
                    VAR itsme:pathtype):BOOLEAN;
VAR
    path:pathtype;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
BEGIN
    Str.Concat(path,root,spec); (* "root\" + filespec *)
    (* remove any "\\" *)
    LOOP
        IF Str.Pos(path,netslash) = MAX(CARDINAL) THEN EXIT; END;
        Str.Subst(path,netslash,backslash);
    END;
    IF useLFN THEN
        found := w9XfindFirst (path,SHORTCARD(allfiles),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
        rc:=w9XfindClose(w9Xhandle,errcode);
        IF found THEN
            Str.Copy(itsme,w9Xentry.fullfilename);
        END;
    ELSE
        found := FIO.ReadFirstEntry(path,allfiles,entry);
        IF found THEN
            Str.Copy(itsme,entry.Name);
        END;
    END;
    RETURN found;
END foundHere;

CONST
    msgSearching = "Searching, please wait... "; (* trailing space *)

PROCEDURE findFile (useLFN,eyecandy:BOOLEAN;lastpath,anchorndx:CARDINAL;
                   spec:pathtype; VAR itsme:pathtype):CARDINAL;
VAR
    i:CARDINAL;
    S:pathtype;
BEGIN
    video(msgSearching,TRUE);
    IF eyecandy THEN Animation(cmdInit); END;
    i:=anchorndx;
    LOOP
        IF eyecandy THEN Animation(cmdShow);END;
        getentry(i,S);
        IF foundHere(useLFN,S,spec,itsme) THEN
            IF eyecandy THEN Animation(cmdStop);END;
            video(msgSearching,FALSE);
            RETURN i;
        END;
        INC(i);
        IF i > lastpath THEN i:=firstPath;END;
        IF i = anchorndx THEN EXIT; END;
    END;
    IF eyecandy THEN Animation(cmdStop);END;
    video(msgSearching,FALSE);
    RETURN MAX(CARDINAL);
END findFile;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(*

w1*w2 = AND
{0..15} - 16 = NOT
i IN w = true if bit i set in word w
INCL(w,i) = set
EXCL(w,i) = clear

*)

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number

Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    miMask=BITSET{5..10};
    miShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    BIOSbaseYear = 80;

PROCEDURE unpackdate (ymd:CARDINAL;VAR y,m,d:SHORTCARD);
BEGIN
    y := SHORTCARD( CARDINAL(BITSET(ymd) * yyMask) >> yyShft );
    m := SHORTCARD( CARDINAL(BITSET(ymd) * mmMask) >> mmShft );
    d := SHORTCARD( CARDINAL(BITSET(ymd) * ddMask) >> ddShft );
END unpackdate;

PROCEDURE unpacktime (hms:CARDINAL;VAR h,m,s:SHORTCARD);
BEGIN
    h := SHORTCARD( CARDINAL(BITSET(hms) * hhMask) >> hhShft );
    m := SHORTCARD( CARDINAL(BITSET(hms) * miMask) >> miShft );
    s := SHORTCARD( CARDINAL(BITSET(hms) * ssMask) >> ssShft );
    s := s << 1; (* FIXED ! yes, yes, "* 2" works too... *)
END unpacktime;

PROCEDURE appbool (flag:BOOLEAN;svrai,sfaux:CHAR;VAR R:ARRAY OF CHAR);
BEGIN
    IF flag THEN
        Str.Append(R,svrai);
    ELSE
        Str.Append(R,sfaux);
    END;
END appbool;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str80;
VAR
    S : str80;
BEGIN
    Str.Copy(S,"");
    (* appbool( (aD IN attr),"D","-", S); *)
    appbool( (aR IN attr),"R","-", S);
    appbool( (aH IN attr),"H","-", S);
    appbool( (aS IN attr),"S","-", S);
    appbool( (aA IN attr),"A","-", S);
    Str.Lows(S); (* prettier display ! *)
    RETURN S;
END fmtAttr;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (d,m,y:SHORTCARD) : str80;
CONST
    separator = dash;
    pad="0";
    baseyear = 1900;
    tmonths ="Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R : str80;
BEGIN
    IF ((m < 1) OR (m > 12)) THEN m := 13; END;
    Str.ItemS(R,tmonths2," ",CARDINAL(m)-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(CARDINAL(d),2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(baseyear+CARDINAL(y),4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtTime (h,m,s:SHORTCARD) : str80;
CONST
    separator = colon;
    pad="0";
VAR
    R : str80;
BEGIN
    R := using(CARDINAL(h),2,pad);
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(m),2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(s),2,pad));
    RETURN R;
END fmtTime;


PROCEDURE biosGetKeycode (VAR k:CARDINAL);
VAR
    c1,c2:CHAR;
BEGIN
    c1:=BiosIO.RdKey();
    c2:=CHR(0);
    IF c1 = CHR(0) THEN c2:=BiosIO.RdKey();END;
    k:=ORD(c2) << 8 + ORD(c1);
END biosGetKeycode;

PROCEDURE biosKeyPressed (VAR k:CARDINAL):BOOLEAN;
VAR
    rc:BOOLEAN;
    c1,c2:CHAR;
BEGIN
    rc:=BiosIO.KeyPressed();
    IF rc THEN biosGetKeycode(k); END;
    RETURN rc;
END biosKeyPressed;


(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showMatch (useLFN,flagTerse:BOOLEAN;root,full:pathtype);
CONST
             (* RHSA  jj-MMM-aaaa  hh:mm:ss  #,###,###,### *)
    fileinfo = "????  ??-???-????  ??:??:??  ?,???,???,???  ";
    sep      =     "  ";
VAR
    S,shortform:pathtype;
    R:str1024;
    errcode:CARDINAL;
    ok:BOOLEAN;
    entry:FIO.DirEntry;
    y,m,d,hh,mm,ss:SHORTCARD;
BEGIN
    Str.Copy(S,root);
    fixDirPath(S); (* useless safety *)
    Str.Append(S,full);
    IF flagTerse THEN
        Str.Copy(R,S);
    ELSE
        IF useLFN THEN
            ok := w9XlongToShort (S, errcode,shortform); (* FALSE if longform does not exist *)
        ELSE
            Str.Copy(shortform,S);
            ok := TRUE;
        END;
        IF ok THEN
            ok := FIO.ReadFirstEntry(shortform,everything,entry);
            unpackdate(entry.date,y,m,d);
            unpacktime(entry.time,hh,mm,ss);

            Str.Concat(R,fmtAttr(entry.attr),sep);
            Str.Append(R,fmtDate(d,m,y+BIOSbaseYear)); (* warning with 1900, 1980... *)
            Str.Append(R,sep);
            Str.Append(R,fmtTime(hh,mm,ss));
            Str.Append(R,sep);
            Str.Append(R,fmtSize(entry.size,blank,coma));
            Str.Append(R,sep);
            Str.Append(R,S);
        ELSE
            Str.Concat(R,fileinfo,S);
        END;
    END;
    WrStr(R);WrLn;
END showMatch;

PROCEDURE doDirMatch (VAR count:CARDINAL;
                      eyecandy,useLFN,flagTerse,flagFullPath:BOOLEAN;
                      root,patternspec:pathtype);
VAR
    path,full,full0,pat0,root0 : pathtype;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    video(msgSearching,TRUE);
    IF eyecandy THEN Animation(cmdInit); END;

    Str.Copy(path,root);
    fixDirPath(path); (* probably useless but add required "\" *)
    Str.Copy(root0,path);
    LowerCaseAlt(root0); (* /// *)

    Str.Append(path,stardotstar); (* root\*.* *)

    Str.Copy(pat0,patternspec);
    LowerCaseAlt(pat0);        (* /// *)

    IF useLFN THEN
        found := w9XfindFirst (path,SHORTCARD(everything),SHORTCARD(nothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(path,everything,entry);
    END;
    WHILE found DO
        IF eyecandy THEN Animation(cmdShow); END;

        IF useLFN THEN
            Str.Copy(full,w9Xentry.fullfilename);
        ELSE
            Str.Copy(full,entry.Name);
            LowerCaseAlt(full);   (* /// *)
        END;

        IF isDirEntry(full)=FALSE THEN (* remember to skip "." and ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT(aD IN dosattr) THEN (* we don't care about directories *)
                IF flagFullPath THEN
                    Str.Concat(full0,root0,full);
                ELSE
                    Str.Copy(full0,full);
                END;
                LowerCaseAlt(full0); (* /// required safety even if already done for f8e3 ! *)
                IF Str.CharPos(full,dot)=MAX(CARDINAL) THEN (* handle filename without extension *)
                    Str.Append(full0,dot); (* yes, to fullZERO *)
                END;
                IF Str.Match(full0,pat0) THEN
                    IF eyecandy THEN Animation(cmdStop);END;
                    video(msgSearching,FALSE);
                    showMatch(useLFN,flagTerse,root,full);
                    INC(count);
                    video(msgSearching,TRUE);
                    IF eyecandy THEN Animation(cmdInit);END;
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    IF eyecandy THEN Animation(cmdStop);END;
    video(msgSearching,FALSE);
END doDirMatch;

PROCEDURE showListMatches (VAR count:CARDINAL;
                           useLFN,eyecandy,flagTerse,flagFullPath:BOOLEAN;
                           lastpath,anchorndx:CARDINAL;spec:pathtype):BOOLEAN;
CONST
    msgWait = "Hit [Space] or [Return] to continue, or [Escape] to abort : ";
VAR
    i,k:CARDINAL;
    S:pathtype;
BEGIN
    BiosFlushkey;
    WrLn;
    count:=0;
    i:=anchorndx;
    LOOP
        getentry(i,S);
        doDirMatch(count,eyecandy,useLFN,flagTerse,flagFullPath,S,spec);
        INC(i);
        IF i > lastpath THEN i:=firstPath;END;
        IF i = anchorndx THEN EXIT; END;
        IF biosKeyPressed(k) THEN
            CASE k OF
            | ORD(blank),ORD(enter) :
                video(msgWait,TRUE);
                LOOP
                    biosGetKeycode(k);
                    CASE k OF
                    | ORD(blank),ORD(enter):
                        video(msgWait,FALSE);
                        EXIT;
                    | ORD(escape):
                        video(msgWait,FALSE);
                        RETURN FALSE;
                    END;
                END;
            | ORD(escape):
                RETURN FALSE;
            END;
        END;
    END;
    RETURN TRUE;
END showListMatches;

(* in msg, ~ ~ ~ = fcount filename/pathname match(es) *)

PROCEDURE showSummary (flagSummary,flagFullPath,complete:BOOLEAN;
                                fcount:CARDINAL);
CONST
    sComplete  = "::: ~ ~ ~ found";
    sPartial   = sComplete +" so far";
    placeholder= "~";
VAR
    S1,S2:str16;
    S : str128;
BEGIN
    IF flagSummary = FALSE THEN RETURN; END;

    IF complete THEN
        S:=sComplete;
    ELSE
        S:=sPartial;
    END;
    IF flagFullPath THEN
        S1:="pathname";
    ELSE
        S1:="filename";
    END;
    IF fcount > 1 THEN
        S2:="matches";
    ELSE
        S2:="match";
    END;

    Str.Subst(S,placeholder, using(fcount, 1, "") );
    Str.Subst(S,placeholder, S1);
    Str.Subst(S,placeholder, S2);

    WrLn;
    WrStr(S);WrLn;
END showSummary;

(* ------------------------------------------------------------ *)

(* return TRUE if no dot in \f8.e3 part *)

PROCEDURE needTrailingDot (S:ARRAY OF CHAR):BOOLEAN;
VAR
    u,d,n,e,ne:pathtype; (* we may get a long filename *)
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    Lib.MakeAllPath(ne,"","",n,e);
    RETURN Str.CharPos(ne,dot)=MAX(CARDINAL);
END needTrailingDot;

(* ------------------------------------------------------------ *)

PROCEDURE parseEnv (VAR flagReread:BOOLEAN;VAR how:opttype);
CONST
    allowable = "U"+delim+"UNSORTED"+delim+
                "A"+delim+"ALPHA"+delim+
                "Z"+delim+"LENGTH";
VAR
    qdcd,opt:str128; (* oversized *)
    i:CARDINAL;
BEGIN
    Lib.EnvironmentFind(sEnvVar,qdcd);
    IF same(qdcd,"") THEN RETURN; END;

    UpperCase(qdcd); (* uppercase *)

    i:=0;
    LOOP
        isoleItemS(opt, allowable,delim,i);
        IF same(opt,"") THEN RETURN;END;
        IF same(opt,qdcd) THEN
            CASE (i+1) OF
            | 1,2: flagReread:=TRUE; how:=unsorted; RETURN;
            | 3,4: flagReread:=TRUE; how:=alpha;    RETURN;
            | 5,6: flagReread:=TRUE; how:=pathlen;  RETURN;
            END;
        END;
        INC(i);
    END;
END parseEnv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    lastparm    : CARDINAL;
    lastfuzz    : CARDINAL;
    lastmatch   : CARDINAL;
    cmd,how,searchmode,forceHow : opttype;
    useLFN,availableLFN,disableLFN,flagReread,forceFlagReread,flagIgnoreINI:BOOLEAN;
    showdirmatches,rootanchor:BOOLEAN;
    flagAsk,flagGoto,flagGotoExact,flagTerse,flagFullPath,flagSummary:BOOLEAN;
    ok,eyecandy,continue:BOOLEAN;
    defaultUnit : SHORTCARD;
    sOrder,sUnits,sOtherUnits,sOS  : str80; (* 26 ! *)
    lastpath    : CARDINAL;
    unit        : CHAR;
    errcode     : CARDINAL;
    alasnomatch : BOOLEAN;
    doCD,DEBUG,dostore,doload,doLFN    : BOOLEAN;
    filespec,shortDefaultDir,defaultDir  : pathtype;
    fcount,needed:CARDINAL;
VAR
    parmcount,i,opt,j : CARDINAL;
    itsme,S,R         : pathtype; (* LFN ! *)
BEGIN
    (* WrLn; *)
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    (* don't use NEW() to allocate arrays, for it crashes ungracefully *)
    (* bah, ugly C-like crap *)
    needed := SIZE(Path^);
    IF Available(needed)=FALSE THEN abort(errALLOC,"Path");END;
    ALLOCATE(Path,needed);
    needed := SIZE(Matching^);
    IF Available(needed)=FALSE THEN abort(errALLOC,"Matching");END;
    ALLOCATE(Matching,needed);

    DEBUG          := FALSE;
    eyecandy       := TRUE;
    disableLFN     := FALSE;
    flagReread     := FALSE;
    showdirmatches := FALSE;
    rootanchor     := FALSE;
    flagAsk        := FALSE;
    flagGoto       := FALSE;
    flagGotoExact  := FALSE;
    flagFullPath   := FALSE;
    flagTerse      := FALSE;
    flagSummary    := FALSE;
    flagIgnoreINI  := FALSE;

    cmd            := undefined;
    how            := undefined;
    searchmode     := undefined;

    parseEnv(forceFlagReread,forceHow);

    lastparm       := firstparm-1; (* 1-1 = 0 ! *)

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R,"?"+delim+"H"+delim+"HELP"+delim+
                                  "C"+delim+"CREATE"+delim+
                                  "U"+delim+"UNSORTED"+delim+"RAW"+delim+
                                  "A"+delim+"ALPHA"+delim+
                                  "Z"+delim+"LENGTH"+delim+
                                  "CU"+delim+
                                  "CA"+delim+
                                  "CZ"+delim+
                                  "L"+delim+"LFN"+delim+
                                  "R"+delim+"READ"+delim+"REREAD"+delim+
                                  "V"+delim+"VIEW"+delim+
                                  "O"+delim+"ROOT"+delim+
                                  "I"+delim+"INTERACTIVE"+delim+
                                  "G"+delim+"GOTO"+delim+
                                  "S"+delim+"FUZZ"+delim+
                                  "SS"+delim+"MOREFUZZ"+delim+
                                  "F"+delim+"FIND"+delim+
                                  "FF"+delim+"FILEFIND"+delim+
                                  "M"+delim+"MATCHES"+delim+
                                  "MM"+delim+"ALLMATCHES"+delim+"MR"+delim+
                                  "T"+delim+"TERSE"+delim+
                                  "P"+delim+"PATH"+delim+
                                  "E"+delim+"EXACT"+delim+
                                  "RU"+delim+
                                  "RA"+delim+
                                  "RZ"+delim+
                                  "Y"+delim+"SUMMARY"+delim+
                                  "MY"+delim+
                                  "MMY"+delim+"MRY"+delim+
                                  "X"+delim+"INI"+delim+
                                  "DEBUG"
                                  );
            CASE opt OF
            | 1,2,3   : abort(errHelp,"");
            | 4,5     : IF newcmd (cmd,create   )=FALSE THEN abort(errCommand,"");END;
            | 6,7,8   : IF newcmd (how,unsorted )=FALSE THEN abort(errSort   ,"");END;
            | 9,10    : IF newcmd (how,alpha    )=FALSE THEN abort(errSort   ,"");END;
            | 11,12   : IF newcmd (how,pathlen  )=FALSE THEN abort(errSort   ,"");END;
            | 13      : IF newcmd (cmd,create   )=FALSE THEN abort(errCommand,"");END;
                        IF newcmd (how,unsorted )=FALSE THEN abort(errSort   ,"");END;
            | 14      : IF newcmd (cmd,create   )=FALSE THEN abort(errCommand,"");END;
                        IF newcmd (how,alpha    )=FALSE THEN abort(errSort   ,"");END;
            | 15      : IF newcmd (cmd,create   )=FALSE THEN abort(errCommand,"");END;
                        IF newcmd (how,pathlen  )=FALSE THEN abort(errSort   ,"");END;
            | 16,17   : disableLFN := TRUE;
            | 18,19,20: flagReread := TRUE;
            | 21,22   : showdirmatches:= TRUE;
            | 23,24   : rootanchor := TRUE;
            | 25,26   : flagAsk    := TRUE;
            | 27,28   : flagGoto   := TRUE;
            | 29,30   : IF newcmd (searchmode,fuzzmode)=FALSE THEN abort(errSearchMode,"");END;
            | 31,32   : IF newcmd (searchmode,morefuzzmode)=FALSE THEN abort(errSearchMode,"");END;
            | 33,34   : IF newcmd (cmd,find     )=FALSE THEN abort(errCommand,"");END;
            | 35,36   : IF newcmd (cmd,find     )=FALSE THEN abort(errCommand,"");END;
                        flagReread := TRUE;
            | 37,38   : IF newcmd (cmd,listmatches)=FALSE THEN abort(errCommand,"");END;
            | 39,40,41: IF newcmd (cmd,listmatches)=FALSE THEN abort(errCommand,"");END;
                        flagReread := TRUE;
            | 42,43   : flagTerse  := TRUE;
            | 44,45   : flagFullPath:=TRUE;
            | 46,47   : flagGotoExact:=TRUE;
            | 48      : flagReread := TRUE; IF newcmd(how,unsorted)= FALSE THEN abort(errSort,"");END;
            | 49      : flagReread := TRUE; IF newcmd(how,alpha   )= FALSE THEN abort(errSort,"");END;
            | 50      : flagReread := TRUE; IF newcmd(how,pathlen )= FALSE THEN abort(errSort,"");END;
            | 51,52   : flagSummary:= TRUE;
            | 53      : IF newcmd (cmd,listmatches)=FALSE THEN abort(errCommand,"");END;
                        flagSummary:= TRUE;
            | 54,55   : IF newcmd (cmd,listmatches)=FALSE THEN abort(errCommand,"");END;
                        flagReread := TRUE;
                        flagSummary:= TRUE;
            | 56,57   : flagIgnoreINI := TRUE;
            | 58      : DEBUG      := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            dostore:=chkFastSpec(flagGoto, S); (* trap and eat immediate markers *)
            IF dostore THEN
                INC(lastparm);
                IF lastparm > maxparm THEN abort(errParameter,S);END;
                Str.Copy( parm[lastparm], S);
            END;
        END;
    END;

    availableLFN := w9XsupportLFN();
    IF availableLFN THEN
        useLFN := NOT(disableLFN);
    ELSE
        useLFN := FALSE;
    END;

    defaultUnit := FIO.GetDrive();
    getAnchor(useLFN,defaultUnit, shortDefaultDir,defaultDir);

    IF initINIdata(DEBUG,flagIgnoreINI,S)=FALSE THEN abort(errINI,R);END; (* // v1.1s uses globerks : this is a Q&D fix after all *)

    IF (flagGoto AND flagGotoExact) THEN abort(errExclusive,"-e and -g");END;

    IF cmd = undefined THEN cmd:=cd;END;
    IF how = undefined THEN how:=unsorted;END;

    IF DEBUG THEN showmem("main code"); END;

    CASE cmd OF
    | find,listmatches:
        IF searchmode # undefined THEN abort(errNonsenseS,"-s and -ss");END;
        IF showdirmatches THEN abort(errNonsense,"-v");END;
        IF flagAsk        THEN abort(errNonsense,"-i");END;
        IF flagGoto       THEN abort(errNonsense,"-g");END;
        IF flagGotoExact  THEN abort(errNonsense,"-e");END;
        IF cmd=find THEN
            IF flagTerse    THEN abort(errNonsense,"-t");END;
            IF flagFullPath THEN abort(errNonsense,"-p");END;
            IF flagSummary  THEN abort(errNonsense,"-y");END;
        END;

        IF getTargetUnits(lastparm,defaultDir[0],sUnits)=FALSE THEN abort(errSyntax,"2");END;
        UpperCaseAlt(sUnits);
        IF verifyString(sUnits,alphabet)=FALSE THEN abort(errBadUnits,sUnits);END;
        removeDups     (sUnits);

        (* keep possible A:, B:, CDROM unit and preserve search order too *)
        filterUnits(FALSE,sUnits,sOtherUnits,sOrder);
        removeFloppies (sUnits);
        removeCDROMs   (sUnits);
        removePhantoms (sUnits);
        filterUnits(TRUE, sUnits,sOtherUnits,sOrder);
        Str.Copy(sUnits,sOrder);
        IF same(sUnits,"") THEN abort(errOnlyPhantoms,"");END;

        j:=0;
        FOR i:=firstparm TO lastparm DO
            IF same(parm[i],"")=FALSE THEN
                Str.Copy(filespec,parm[i]);
                IF needTrailingDot(filespec) THEN
                    Str.Append(filespec,dotstar);  (* automagically append ".*" as DOS does *)
                END;
                INC(j);
            END;
        END;
        IF j # 1 THEN abort(errSyntax,"2");END; (* no filespec or many files ! *)

        IF forceFlagReread THEN flagReread:=TRUE; how:=forceHow; END;

        lastpath:=firstPath-1;
        FOR i:=1 TO Str.Length(sUnits) DO
            unit:=sUnits[i-1];
            doload:=isRereadNeeded(useLFN, flagReread,unit,sUnits,sOtherUnits);
            continue:=(i # 1);
            IF doload THEN
                buildAndSort(unit,DEBUG,continue,useLFN,how,  lastpath);
                IF lastpath = MAX(CARDINAL) THEN abort(errTooManyDirs,S);END;
            ELSE
                IF readDirList(DEBUG,continue,useLFN,eyecandy,unit, lastpath,errcode,S)=FALSE THEN
                    abort(errcode,S);
                END;
            END;
        END;

        j:=findAnchor(lastpath,rootanchor,useLFN,sUnits,defaultDir);

        IF DEBUG THEN
            WrLn;
                (* i,-5 was not pretty *)
            FOR i:=firstparm TO lastparm DO
                IO.WrCard(i,4);WrStr(" ");WrStr(parm[i]);WrLn;
            END;
            WrLn;
            FOR i:=firstPath TO lastpath DO
                getentry(i,S);
                IO.WrCard(i,4);WrStr(" ");WrStr(S);WrLn;
            END;
            WrLn;
            FOR i:=firstMatch TO lastmatch DO
                getentry(Matching^[i],S);
                IO.WrCard(i,4);WrStr(" ");
                IF direxists(useLFN,S) THEN (* test interesting here only, not for /f /m *)
                    R:="Y";
                ELSE
                    R:="n";
                END;
                WrStr(R);WrStr(" ");
                WrStr(S);WrLn;
            END;
            WrLn;
            me("units",sUnits);
            me("special units",sOtherUnits);
            me("current",defaultDir);
            getentry(j,S);
            me("anchor",S);
            me("filespec",filespec);
            abort(errNone,"");
        END;
        CASE cmd OF
        | find:
            i:=findFile(useLFN,eyecandy,lastpath,j,filespec,itsme);
            IF i = MAX(CARDINAL) THEN
                IF flagReread THEN
                    abort(errNotFoundAtAllRereading,filespec);
                ELSE
                    abort(errNotFoundAtAllInStored,filespec);
                END;
            END;
            getentry(i,S);

            freePaths(lastpath);

            ok:=doChangeDir(useLFN,S);
            (* don't bother with filesize etc. *)
            WrLn;WrStr("Found matching file : ");WrStr(itsme);WrLn;
        | listmatches:
            IF showListMatches (fcount,  useLFN,eyecandy,
                                flagTerse,flagFullPath,
                                lastpath,j,filespec)=FALSE THEN
                showSummary(flagSummary,flagFullPath,FALSE,fcount);
                abort(errAborted,"");
            END;

            freePaths(lastpath);

            IF fcount=0 THEN
                IF flagFullPath THEN
                    S:="No pathname";
                ELSE
                    S:="No filename";
                END;
                Str.Append(S," match found for "+dquote);
                Str.Append(S,filespec);
                Str.Append(S,dquote);
                IF flagReread THEN
                    abort(errNoMatchFoundRereading,S);
                ELSE
                    abort(errNoMatchFoundInStored,S);
                END;
            END;

            showSummary(flagSummary,flagFullPath,TRUE,fcount);

        END;
        (* useless but cleaner *)

        needed := SIZE(Path^);
        DEALLOCATE(Path,needed);
        needed := SIZE(Matching^);
        DEALLOCATE(Matching,needed);

        abort(errDone,"");

    | cd :
        CASE lastparm OF
        | firstparm-1:
            (* IF how # undefined THEN abort(errNonsenseS,"-n, -s and -z");END; *)
            IF searchmode # undefined THEN abort(errNonsenseS,"-s and -ss");END;
            IF flagReread     THEN abort(errNonsense,"-r");END;
            IF showdirmatches THEN abort(errNonsense,"-v");END;
            IF rootanchor     THEN abort(errNonsense,"-o");END;
            IF flagAsk        THEN abort(errNonsense,"-i");END;
            IF flagGoto       THEN abort(errNonsense,"-g");END;
            IF flagGotoExact  THEN abort(errNonsense,"-e");END;
            IF flagTerse      THEN abort(errNonsense,"-t");END;
            IF flagFullPath   THEN abort(errNonsense,"-p");END;
            IF flagSummary    THEN abort(errNonsense,"-y");END;

            Str.Copy(S,defaultDir);
            enclose(S);
            Str.Prepend(S,"Current directory is ");

            WrLn;
            WrStr(S);WrLn;
        ELSE
            IF (flagGoto AND flagAsk) THEN abort(errExclusive,"-g and -i");END;
            IF (flagGotoExact AND flagAsk) THEN abort(errExclusive,"-e and -i");END;

            IF searchmode = undefined THEN searchmode:=jokermode;END;

            IF getTargetUnits(lastparm,defaultDir[0],sUnits)=FALSE THEN abort(errSyntax,"1");END;
            UpperCaseAlt(sUnits);
            IF verifyString(sUnits,alphabet)=FALSE THEN abort(errBadUnits,sUnits);END;
            removeDups     (sUnits);

            (* keep possible A:, B:, CDROM unit and preserve search order too *)
            filterUnits(FALSE,sUnits,sOtherUnits,sOrder);
            removeFloppies (sUnits);
            removeCDROMs   (sUnits);
            removePhantoms (sUnits);
            filterUnits(TRUE, sUnits,sOtherUnits,sOrder);
            Str.Copy(sUnits,sOrder);
            IF same(sUnits,"") THEN abort(errOnlyPhantoms,"");END;

            errcode:=0;
            FOR i:=firstparm TO lastparm DO
                IF same(parm[i],"")=FALSE THEN INC(errcode);END;
            END;
            IF errcode = 0 THEN abort(errSyntax,"1");END; (* no subdir ! *)

            (* FIXME : loop once or twice forcing reread if not found using stored data ? *)

            IF forceFlagReread THEN flagReread:=TRUE; how:=forceHow; END;

            lastpath:=firstPath-1;
            FOR i:=1 TO Str.Length(sUnits) DO
                unit:=sUnits[i-1];
                doload:=isRereadNeeded(useLFN, flagReread,unit,sUnits,sOtherUnits);
                continue:=(i # 1);
                IF doload THEN
                    buildAndSort(unit,DEBUG,continue,useLFN,how,  lastpath);
                    IF lastpath = MAX(CARDINAL) THEN abort(errTooManyDirs,S);END;
                    (* FIXME : we could set flagReread = true so that error for A: is right *)
                ELSE
                    IF readDirList(DEBUG,continue,useLFN,eyecandy,unit, lastpath,errcode,S)=FALSE THEN
                        abort(errcode,S);
                    END;
                END;
            END;

            lastfuzz:=buildFuzz(lastparm,searchmode);
            j:=findAnchor(lastpath,rootanchor,useLFN,sUnits,defaultDir);
            lastmatch:=buildAllMatches(DEBUG,useLFN,flagReread,lastpath,lastfuzz,j);
            alasnomatch:= ( lastmatch = MAX(CARDINAL) );
            IF alasnomatch THEN
                (* FIXME : in fact, we should reread directory list before we abort *)
                IF DEBUG THEN (* give DEBUG a chance ! *)
                    lastmatch := firstMatch-1; (* safety for DEBUG dump *)
                ELSE
                    IF flagReread THEN
                        abort(errNoMatchRereading,"");
                    ELSE
                        abort(errNoMatchInStored,"");
                    END;
                END;
            END;

            IF DEBUG THEN
                (* i,-5 was not pretty *)
                WrLn;
                FOR i:=firstparm TO lastparm DO
                    IO.WrCard(i,4);WrStr(" ");WrStr(parm[i]);WrLn;
                END;
                WrLn;
                FOR i:=firstPath TO lastpath DO
                    getentry(i,S);
                    IO.WrCard(i,4);WrStr(" ");WrStr(S);WrLn;
                END;
                WrLn;
                FOR i:=nofuzz TO lastfuzz DO
                    Str.Copy(S, fuzz[i]);
                    IO.WrCard(i,4);WrStr(" ");WrStr(S);WrLn;
                END;
                WrLn;

                FOR i:=firstMatch TO lastmatch DO
                    getentry(Matching^[i],S);
                    IO.WrCard(i,4);WrStr(" ");
                    IF direxists(useLFN,S) THEN (* test interesting here only, not for /f /m *)
                        R:="Y";
                    ELSE
                        R:="n";
                    END;
                    WrStr(R);WrStr(" ");
                    WrStr(S);WrLn;
                END;
                WrLn;
                me("units",sUnits);
                me("special units",sOtherUnits);
                me("current",defaultDir);
                getentry(j,S);
                me("anchor",S);

                WrStr("::: doChangeDir() ");
                IF alasnomatch THEN
                    S:="would not be called (no match)";
                ELSE
                    getentry(Matching^[firstMatch],S);
                    enclose(S);
                    Str.Prepend(S,"would try ");
                END;
                WrStr(S);WrLn;

                abort(errNone,"");

            END;

            IF showdirmatches THEN
                WrLn;
                FOR i:=firstMatch TO lastmatch DO
                    getentry(Matching^[i],S);
                    WrStr(S);WrLn;
                END;
            END;

            IF flagAsk THEN
                i:=selectIt(errcode, lastmatch,defaultDir);
                IF i=MAX(CARDINAL) THEN abort(errcode,"");END;
            ELSIF flagGoto THEN
                i:=selectGotoMatch(FALSE,lastmatch);
                IF i=noMatchFound THEN abort(errCannotProceed,"");END;
            ELSIF flagGotoExact THEN
                i:=selectGotoMatch(TRUE,lastmatch);
                IF i=noMatchFound THEN abort(errCannotProceed,"");END;
            ELSE
                i:=firstMatch;
            END;
            getentry(Matching^[i],S);

            freePaths(lastpath);

            doCD:=(flagAsk OR flagGoto OR flagGotoExact);
            doCD:=( doCD OR (showdirmatches=FALSE) );
            IF doCD THEN
                ok:=doChangeDir(useLFN,S);
            ELSE
                ok:=TRUE;
            END;

            (* useless but cleaner *)

            needed := SIZE(Path^);
            DEALLOCATE(Path,needed);
            needed := SIZE(Matching^);
            DEALLOCATE(Matching,needed);

            IF NOT(ok) THEN abort(errChangeDir,S);END; (* warn user *)

            abort(errDone,"");
        END;
    | create:

        IF searchmode # undefined THEN abort(errNonsenseS,"-s and -ss");END;
        IF flagReread    THEN abort(errNonsense,"-r");END;
        IF showdirmatches   THEN abort(errNonsense,"-v");END;
        IF rootanchor    THEN abort(errNonsense,"-o");END;
        IF flagAsk       THEN abort(errNonsense,"-i");END;
        IF flagGoto      THEN abort(errNonsense,"-g");END;
        IF flagGotoExact THEN abort(errNonsense,"-e");END;
        IF flagTerse     THEN abort(errNonsense,"-t");END;
        IF flagFullPath  THEN abort(errNonsense,"-p");END;
        IF flagSummary   THEN abort(errNonsense,"-y");END;

        CASE lastparm OF
        | firstparm-1 :
            Str.Copy(sUnits,getUnitChar(defaultUnit));
        ELSE
            IF getCliUnits(lastparm,sUnits)=FALSE THEN abort(errSyntax,"3");END;
        END;

        UpperCaseAlt(sUnits);
        IF verifyString(sUnits,alphabet)=FALSE THEN abort(errBadUnits,sUnits);END;
        removeDups     (sUnits);

        removeFloppies (sUnits); (* avoid specifying phantom B: and who works on floppies anyway ? *)
        removeCDROMs   (sUnits);
        removePhantoms (sUnits);

        continue:=FALSE;
        WrLn;

        FOR j:=1 TO 2 DO
            CASE j OF
            | 1 : sOS:="DOS";        ok:=TRUE;   doLFN:=FALSE;
            | 2 : sOS:="Windows 9X"; ok:=useLFN; doLFN:=useLFN;
            END;
            IF ok THEN
                FOR i:=1 TO Str.Length(sUnits) DO
                    unit:=sUnits[i-1];
                    buildAndSort(unit,DEBUG,continue,doLFN,how, lastpath);
                    IF lastpath = MAX(CARDINAL) THEN abort(errTooManyDirs,S);END;

                    buildDataPath(doLFN, unit, R);
                    IF writeDirList (eyecandy,doLFN,lastpath,how,unit)=FALSE THEN abort(errCreate,R);END;
                    Str.Concat(R,"+++ ",unit);
                    Str.Append(R,": unit processed (");
                    Str.Append(R,sOS);
                    Str.Append(R," directories)");
                    WrStr(R);WrLn;

                    freePaths (lastpath);
                END;
            END;
        END;
    END;

    (* useless but cleaner *)

    needed := SIZE(Path^);
    DEALLOCATE(Path,needed);
    needed := SIZE(Matching^);
    DEALLOCATE(Matching,needed);

    abort(errNone,"");
END C.



(*

; safety

?:\system volume information\*
?:\windows\assembly\*
?:\windows\winSxS\*
?:\system~1\*

; silly game designers LOVE deep depths for savegames !

?:\documents*\my games\*titan quest*
?:\DOCUME~1\*\MYGAME~1\titan*

*)

