;=============================================================================
; tsr.inc:	TSR-related stuff.
;
; Copyright (c) 2006, 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	---
;
; Macros:
;	key_received	send_eoi
;
; Used global variables:
;	---
;
; Used global constants:
;	---
;=============================================================================


;=============================================================================
; key_received
;-----------------------------------------------------------------------------
; Sends key-received signal to keyboard controller.
;
%macro		key_received	0
		in	al,61h
		mov	ah,al
		or	al,80h
		out	61h,al
		xchg	ah,al
		out	61h,al
%endmacro
;
;=============================================================================
; send_eoi
;-----------------------------------------------------------------------------
; Sends end-of-interrupt signal to PIC.
;
%macro		send_eoi	0
		mov	al,20h
		out	20h,al
%endmacro
;
;=============================================================================
; E0F
;=============================================================================


