#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <io.h>

// #define DEBUG

char str1[256];
char str2[256];
char complement = 0;
char squeeze    = 0;
char delmode    = 0;
char multimode  = 0;
char lastch     = 0;
#ifdef DEBUG
char debug      = 0;
#endif

char helptext[] = "\n\
 TR 1.0 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: tr [ options ] <string1> [ <string2> [ <str3> <str4> ... ] ]\n\n\
 valid options are:\n\
     /C  (complement) all characters NOT in <string1>\n\
     /D  (delete)     remove all characters in <string1>\n\
     /S  (squeeze)    remove consecutive duplicate characters\n\
     /M  (multibyte)  replace all characters in <string1> by the\n\
		      corresponding <string2>, <str3>, <str4> ...\n\n\
 examples: echo abcDEFghi   | tr A-Z a-z\n\
	   echo a..o..u. | tr /M \\0A\\0D ae oe ue \"<LF>\" \"<CR>\"\n\n";

void set_sepchr(char *p, char *t, int l,char neg) {
  unsigned char tmp[256];
  unsigned char *q, c, tmp2[4];
  if(strchr(p,'\\')) {
    for(q=tmp; *p&&q<&tmp[l]; p++)
      if(*p!='\\') *q++ = *p;
      else {
	p++;
	if(!isxdigit(*p)||!isxdigit(p[1])) *q++ = *p;
	else {
	  tmp2[0] = *p++;
	  tmp2[1] = *p;
	  tmp2[2] = '\0';
	  *q++ = strtol(tmp2,NULL,16) & 0XFF;
	  }
	}
    *q++ = '\0';
    p = tmp;
    }
  q = t;
  *q++ = c = *p++;
  for( ; *p&&q<&t[l]; p++)
    if((*p!='-')||(c>=p[1])) *q++ = c = *p;
    else for(c++ ; c<p[1]; c++)  *q++ = c;
  *q = '\0';
  if(neg) {
    for(q=tmp,c=0; c<255&&q<&tmp[l]; c++) if(!strchr(t,c)) *q++ = c;
    *q = '\0';
    strcpy(t,tmp);
    }
  }

#ifdef DEBUG
void show_tables(int l) {
  int i,j,k;
  printf("DELMODE=%d   MULTIMODE=%d   COMPLEMENT=%d\n",delmode,multimode,complement);
  for(i=0,k=strlen(str1); i<k; i+=24) {
    printf("\n%3d:",i);
    for(j=0; j<24; j++) if(i+j<k) printf(" %02X",str1[i+j]&0XFF); else printf("   ");
    }
  printf("\n");
  for(i=0; i<l; i+=24) {
    printf("\n%3d:",i);
    for(j=0; j<24; j++) if(i+j<l) printf(" %02X",str2[i+j]&0XFF); else printf("   ");
    }
  printf("\n");
  }
#endif

void main (int argc, char* argv[]) {
  int   i,j,k;
  char  *p, *q, ch;

  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'C': complement = 1;              break;
	case 'D': multimode  = 0; delmode = 1; break;
	case 'M': multimode  = 1; delmode = 0; break;
	case 'S': squeeze    = 1;              break;
#ifdef DEBUG
	case 'X': debug      = 1;              break;
#endif
	case 'H': printf(helptext);            exit(0);
	}
      }

    set_sepchr(argv[i],str1,255,complement);
    strcpy(str2,str1);
    if(!delmode&&++i<argc) {
      if(!multimode) {
	set_sepchr(argv[i],str2,255,0);
	for(i=strlen(str1),j=strlen(str2),ch=str2[j-1]; j<i; j++) str2[j] = ch;
	}
      else {
	k = strlen(str2);
	j = k + 1;
	p = &str2[j];
	q = str2;
	while((i<argc)&&(j<250)) {
	  set_sepchr(argv[i],p,255-j,0);
	  if(q<&str2[k]) *q++ = j;
	  j += (strlen(p) + 1);
	  p = &str2[j];
	  i++;
	  }
	q--;
	for(ch=*q++; q<&str2[k]; q++) *q = ch;
	}
      }
#ifdef DEBUG
    if(debug) show_tables((multimode)?p-str2:strlen(str2));
    else
#endif
      {
      setmode(0,O_BINARY);
      while((i=getc(stdin))!=EOF) {
	j = ((p=strchr(str1,i))==NULL)?-1:p-str1;
	if(j<0) fputc(i,stdout);
	else if(!delmode) {
	  ch = str2[j];
	  if(!squeeze||(ch!=lastch)) {
	    if(!multimode) fputc(ch,stdout);
	    else fprintf(stdout,"%s",&str2[ch]);
	    lastch = ch;
	    }
	  }
	}
      setmode(0,O_TEXT);
      }
    }
  exit(0);
  }
