#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>

char   lfndos      = 1;
char   travel      = 0;
char   dostore     = 0;
char   cmdbuf[130] = "";
char   filemode    = 0;
char   all[4]      = "*.*";
char   root[2]     = "\\";
unsigned long fil0 = 0L;
FILE  *mfil;
char  *argx        = NULL;
char  *dirnam      = NULL;
char   curdir[70]  = "";
char   orgdir[70]  = "";
char   vroot[70]   = "";
char   deftop[80]  = "";
char   defbot1[80]  = "<\031>,<\030>,<Pg\031>,<Pg\030>,<Home> moves      <RETURN> confirms      <ESC> aborts";
char  *topline     = deftop;
char  *botline     = defbot1;
char   orgdisk     = -1;
char   newdisk     = -1;
char   lockdir     = 0;
char   keepdir     = 0;
char   seldir      = 0;
char   outform     = 0;
char   dirform     = 0;
char   dirstate    = 4;
char   attrib0     = 0;
char   attrib1     = 3;
struct ffblk ffblk;
unsigned long tout = 0L;
unsigned long t0   = 0L;
unsigned long far *timer = (unsigned long *)MK_FP(0X0040,0X006C);

#define SCRBAS  4
#define MAXSCR 20
#define MAXBUF 40
typedef char bufline[82];
bufline buf[MAXBUF];
int bfill   = 0;
int ofs0    = 0;
int ofs1    = 0;
int cursor  = 0;
char update = 0;

char helptext[]  = "\n\
 SELECT 1.6 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage:  select [ options ]  [drive:][path\\][dir mask]\n\n\
 valid options are:\n\
   /A[attr]    D:directories F:(ordinary) files\n\
	       A:archive H:hidden R:read-only S:system\n\
   /F          get menu content from file\n\
   /O[B,L,P,R] output: /OB base name /OL long form /OP full path /OR rel.path\n\
   /C[V,S,K]   change dirs /CV virtual root /CK keep on exit /CS \".\" selects\n\
   /D          append \"\\\" to directory names\n\
   /T<sec>     define time-out in seconds\n\
   /S[var]     make set command for environment variable <var>\n\
   /E[var]     store <var> directly in environment (tricky !!!)\n\
   /H /?       print this helptext\n\n\
	       set SELECT_TOP=Alternate header line\n\
	       set SELECT_BOT=Alternate footer line\n\n\
      in first lines of file (file menus only):\n\
	       .DEFAULT default response\n\
	       .TITLE   menu title\n";


void error(int code) {
  fprintf(stderr,"ERROR: ");
  switch(code) {
    case 1:  fprintf(stderr,
	    (filemode)?"no file name\n":"no direcrory mask\n");         break;
    case 2:  fprintf(stderr,"out of environment space\n");              break;
    case 3:  fprintf(stderr,"bad name in /S switch\n");                 break;
    case 4:  fprintf(stderr,"cannot open file: %s\n",argx);             break;
    case 5:  fprintf(stderr,"cannot change to: %s\n",argx);             break;
    case 6:  fprintf(stderr,"too many parameters: %s\n",argx);          break;
    case 7:  fprintf(stderr,"cannot change to drive: %c\n",newdisk+41); break;
    }
  if(orgdisk>=0) setdisk(orgdisk);
  exit(2);
  }

void put_parentenv(char *cmdp) {
  unsigned int far *ip1; // ptr --> parent's PSP
  unsigned int far *ip2; // ptr --> ptp -->  parent's environment
  unsigned int far *ip3; // ptr --> size  of parent's environment
  int pesize, peused;    // available, actually used
  char far *pebeg;       // ptr --> Parent's Environment BEGin
  char far *peend;       // ptr --> Parent's Environment END
  char far *cp1;
  char far *cp2;
  char far *vpos;        // ptr --> variable, if already present
  int  vlen,vsiz;        // new len, present len, if already present
  vpos = NULL;
  vsiz = 0;
  vlen = (strchr(cmdp,'=') - cmdp) + 1;
  ip1 = MK_FP(_psp,0X0016);
  ip2 = MK_FP(*ip1,0X002C);
  pebeg = MK_FP(*ip2,0);
  ip3 = MK_FP(*ip2-1,3);
  for(cp1=pebeg; *cp1; cp1=MK_FP(FP_SEG(cp1),FP_OFF(cp1)+_fstrlen(cp1)+1))
    if(!_fstrncmp(cp1,cmdp,vlen)) { vpos = cp1; vsiz = _fstrlen(cp1) + 1; }
  peend  = cp1;
  peused = cp1 - pebeg + 1;
  pesize = *ip3 <<  4;
  if(vsiz) {             // if already present, remove it first
    cp1 = vpos;
    cp2 = MK_FP(FP_SEG(cp1),FP_OFF(cp1)+vsiz);
    while(cp2 < peend) *cp1++ = *cp2++;
    peend  = cp1;
    peused -= vsiz;
    }
  if((pesize-peused-5)<strlen(cmdp)) error(2);
  else {                 // now append new copy, if space is sufficient
    _fstrcpy(peend,cmdp);
    cp1  = MK_FP(FP_SEG(peend),FP_OFF(peend)+strlen(cmdp)+1);
    *cp1 = '\0';
    }
  }

char *get_longname(char *p, int mode) {
  struct REGPACK r;
  static char lnam[262];
  char *p1, *q;
  if(!lfndos) return(NULL);
  r.r_ax=0X7160;
  r.r_cx=0X0002;
  r.r_ds=FP_SEG(p);
  r.r_si=FP_OFF(p);
  r.r_es=FP_SEG(lnam);
  r.r_di=FP_OFF(lnam);
  intr(0X21,&r);
  if(r.r_flags&1) {
    if(r.r_ax==0X7100) lfndos = 0;
    return(NULL);
    }
  for(p1=q=lnam; *p1; p1++) if(*p1=='\\') q = &p1[1];
  if(mode) return(lnam);
  return(q);
  }

void set_chdir(char *p) {
  travel = 1;
  for( ; *p; p++) {
    switch(toupper(*p)) {
      case 'K': keepdir  = 1;    break;
      case 'S': seldir   = 1;    break;
      case 'V': vroot[0] = '\\'; break;
      }
    }
  }

void set_attrib(char *p) {
  attrib0 = attrib1 = 0;
  for( ; *p; p++) {
    switch(toupper(*p)) {
      case 'A': attrib0 |= FA_ARCH;   break;
      case 'D': attrib1 |= 2;         break;
      case 'F': attrib1 |= 1;         break;
      case 'H': attrib0 |= FA_HIDDEN; break;
      case 'R': attrib0 |= FA_RDONLY; break;
      case 'S': attrib0 |= FA_SYSTEM; break;
      }
    }
  if(!attrib1) attrib1 = 3;
  }

int dir_entry(char *tmp) {
  char *p;
  int i,go,isdd,isdot,isroot;
  go = 1;
//isdd = 0;
  do {
    isroot = isdot = isdd = 0;
    switch(dirstate) {
      case 4: if(seldir&&!strcmp(&curdir[1],":\\")) {
		isroot=1; go = 0;   dirstate = 3;             break;
		}
      case 3: if(!(attrib1&2))      dirstate = 1;
	      else {	            dirstate = 2;
		i = findfirst("*.*",&ffblk,attrib0|FA_DIREC);
		} 	                                      break;
      case 2: i = findnext(&ffblk);
	      if(i) dirstate = 1;                             break;
      case 1: if(!(attrib1&1)) {  i = 1;  go = 0; }
	      else {                dirstate = 0;
		i = findfirst(dirnam,&ffblk,attrib0);
		}	                                      break;
      case 0: i = findnext(&ffblk); if(i) go = 0;             break;
      }
    if(!i&&(dirstate>1)&&(ffblk.ff_attrib&FA_DIREC)) {
      if(!strcmp(ffblk.ff_name,".")) {
	isdot = 1;
	go = (seldir==0);
	}
      else {
	isdd = !strcmp(ffblk.ff_name,"..");
	if(lockdir) go = isdd;
	else if(!travel&&isdd) go = 1;
	else go = 0;
	}
      }
    if(!i&&(dirstate<2)&&!(ffblk.ff_attrib&FA_DIREC)) go = 0;
    } while(go);
  if(i) tmp[0] = '\0';
  else {
    sprintf(tmp,"%-14s",ffblk.ff_name);
    p = &tmp[strlen(tmp)];
    if(ffblk.ff_attrib&FA_DIREC) sprintf(p,"%-11s","<DIR>");
    else sprintf(p,"%11ld",ffblk.ff_fsize);
    p = &tmp[strlen(tmp)];
    sprintf(p," %02d.%02d.%04d %02d:%02d",ffblk.ff_fdate&31,(ffblk.ff_fdate>>5)%15,
	    ((ffblk.ff_fdate>>9)&127)+1980,(ffblk.ff_ftime>>11)&31,(ffblk.ff_ftime>>6)&63);
    p = &tmp[strlen(tmp)];
    sprintf(p," ----");
    if(ffblk.ff_attrib&FA_RDONLY) p[1] = 'R';
    if(ffblk.ff_attrib&FA_SYSTEM) p[2] = 'S';
    if(ffblk.ff_attrib&FA_HIDDEN) p[3] = 'H';
    if(ffblk.ff_attrib&FA_ARCH)   p[4] = 'A';
    }
    if(lfndos) {
      if(isdd) strcat(tmp," ..");
      else if(isdot) strcat(tmp," .");
      else {
	p = get_longname(ffblk.ff_name,0);
	if(p) {
	  strcat(tmp," ");
	  if(strlen(p)<31) strcat(tmp,p);
	  else {
	    strncat(tmp,p,27);
	    strcat(tmp,"...");
	    }
	  }
	}
      }
  if(isroot) {
    strcpy(tmp,".");
    i = 0;
    }
  return(i);
  }

void read_directory(int count) {
  bufline tmp;
  int i;
  if((ofs0+count)<0) count = ofs0 * -1;
  if(count<0) {
    i = ofs0 + count;
    dirstate = 4;
    ofs0 = 0;
    while(i) {
      dir_entry(tmp);
      ofs0++;
      i--;
      }
    for(bfill=0; bfill<MAXBUF; bfill++) {
      if(dir_entry(tmp)) break;
      strcpy(buf[bfill],tmp);
      }
    }
  else for( ; count; count--) {
    if(dir_entry(tmp)) break;
    if(bfill<MAXBUF) strcpy(buf[bfill++],tmp);
    else {
      memmove(&buf[0][0],&buf[1][0],sizeof(bufline)*(MAXBUF-1));
      strcpy(&buf[MAXBUF-1][0],tmp);
      ofs0++;
      }
    }
  }

void read_file(int count) {
  bufline tmp;
  char *p;
  int i;
  if((ofs0+count)<0) count = ofs0 * -1;
  if(count<0) {
    i = ofs0 + count;
    fseek(mfil,fil0,0);
    ofs0 = 0;
    while(i) {
      fgets(tmp,sizeof(tmp),mfil);
      ofs0++;
      i--;
      }
    for(bfill=0; bfill<MAXBUF; bfill++) {
      if(!fgets(tmp,sizeof(tmp),mfil)) break;
      p = &tmp[strlen(tmp)-1];
      if(*p=='\n') *p = '\0';
      strcpy(buf[bfill],tmp);
      }
    }
  else for( ; count; count--) {
    if(!fgets(tmp,sizeof(tmp),mfil)) break;
    p = &tmp[strlen(tmp)-1];
    if(*p=='\n') *p = '\0';
    if(bfill<MAXBUF) strcpy(buf[bfill++],tmp);
    else {
      memmove(&buf[0][0],&buf[1][0],sizeof(bufline)*(MAXBUF-1));
      strcpy(&buf[MAXBUF-1][0],tmp);
      ofs0++;
      }
    }
  }

void show_menu(void) {
  char *p;
  int i;
  p = curdir;
  clrscr();
  textattr(0X70);
  cprintf(" %-78s",topline);
  textattr(0X07);
  if(lfndos&&!filemode) {
//  p = get_longname(curdir,1);
    p = get_longname(".",1);
    if(strlen(p)>78) p = curdir;
    }
  gotoxy(1,SCRBAS-2);
  cprintf("%s",p);
  for(i=0; i<MAXSCR; i++) {
    gotoxy(1,SCRBAS+i);
    if((i+ofs1)<bfill) {
      if(i==cursor) textattr(0X70);
      cprintf(buf[i+ofs1]);
      textattr(0X07);
      }
    }
  gotoxy(1,25);
  textattr(0X70);
  cprintf(" %-78s",botline);
  textattr(0X07);
  gotoxy(1,SCRBAS+MAXSCR);
  update = 0;
  }

void cursor_up(void) {
  int i;
  update = 1;
  if(cursor) cursor--;
  else if(ofs1) ofs1--;
  else {
    if(!ofs0) update = 0;
    else {
      i = ofs0 - 1;
      if(filemode) read_file(-MAXSCR);
      else    read_directory(-MAXSCR);
      ofs1 = i - ofs0;
      i = ofs1 + MAXSCR - bfill;
      if(i>=0) {
	ofs1   -= i;
	cursor += i;
	}
      }
    }
  }

void cursor_down(void) {
  int i,j;
  update = 1;
  if(cursor<(((bfill<MAXSCR)?bfill:MAXSCR)-1)) cursor++;
  else if((ofs1+MAXSCR)<bfill) ofs1++;
  else {
    j = ofs0;
    i = ofs0 + ofs1 + cursor + 1;
    if(filemode) read_file(MAXSCR);
    else    read_directory(MAXSCR);
    if(ofs0<=j) update = 0;
    else {
      ofs1 = i - ofs0 - cursor;
      if(ofs1<0) {
	ofs1   = 0;
	cursor = i - ofs0;
	}
      }
    }
  }

void cursor_home(void) {
  ofs0 = ofs1 = cursor = bfill = 0;
  if(filemode) {
    fseek(mfil,fil0,0);
    read_file(40);
    }
  else {
    dirstate = 4;
    read_directory(40);
    }
  update = 1;
  }

void page_up(void) {
  int i;
  if(cursor) cursor = 0;
  else for(i=MAXSCR; i&&(cursor||ofs0||ofs1); i--) cursor_up();
  update = 1;
  }

void page_down(void) {
  int i;
  i = ((bfill<MAXSCR)?bfill:MAXSCR)-1;
  if(cursor<i) cursor = i;
  else for(i=0; i<MAXSCR; i++) cursor_down();
  update = 1;
  }

int change_dir(void) {
  char *p, *q;
  p = buf[cursor+ofs1];
  if(p[14]!='<') return(0X0D);
  if((p[0]=='.')&&(p[1]<=' ')) return(0X0D);
  if((q=strchr(p,' '))!=NULL) {
    *q = '\0';
    chdir(p);
    getcwd(curdir,68);
    if(vroot[0]) lockdir = !strncmp(vroot,curdir,strlen(curdir));
    dirstate = 4;
    ofs0 = ofs1 = cursor = bfill = 0;
    read_directory(40);
    update = 1;
    }
  return(0);
  }

void main (int argc, char* argv[]) {
  int   i,j;
  char *p, *q;

  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'A': set_attrib(&argv[i][2]);           break;
	case 'F': filemode = 1;                      break;
	case 'D': dirform  = 1;                      break;
	case 'O': outform  = toupper(argv[i][2]);    break;
	case 'E': dostore  = 1;
	case 'S': strncpy(cmdbuf,&argv[i][2],64);    break;
	case 'T': tout     = atoi(&argv[i][2]);      break;
	case 'C': set_chdir(&argv[i][2]);            break;
	case 'H':
	case '?': printf(helptext);                  exit(0);
	}
      }
    if(tout) { tout *= 91; tout /= 5; }
    if(i >= argc) error(1);
    if(i+1 < argc) {
      argx = argv[i+1];
      error(6);
      }
    if(travel) attrib1 |= 2;
    if((p=getenv("SELECT_BOT"))!=NULL) botline = p;
    if((p=getenv("SELECT_TOP"))!=NULL) topline = p;
    else {
      if(filemode) strcpy(deftop," Select an item");
      else if(travel) {
	strcpy(deftop," Change to directory");
	if(attrib1&1) strcat(deftop," or select a file");
	}
      else if(attrib1==2) strcpy(deftop," Select a directory");
      else {
	strcpy(deftop," Select a file");
	if(attrib1&2) strcat(deftop," or directory");
	}
      strcat(deftop," please ...");
      }
    cmdbuf[64] = '\0';
    if(cmdbuf[0]) {
      if(strchr(cmdbuf,'=')) error(3);
      strupr(cmdbuf);
      strcat(cmdbuf,"=");
      }
    else strcpy(cmdbuf,"SELECT=");
    argx  = argv[i];
    if(filemode) {
      mfil = fopen(argx,"rt");
      if(mfil==NULL) error(4);
      fil0 = ftell(mfil);
      fgets(orgdir,sizeof(orgdir),mfil);
      while(!strnicmp(orgdir,".TITLE ",7)||!strnicmp(orgdir,".DEFAULT ",9)) {
	for(p=&orgdir[5]; *p&&(*p>' '); p++);
	for( ; *p&&(*p<=' '); p++);
	if(toupper(orgdir[1])=='T') strcpy(curdir,p);
	else {
	  strcpy(vroot,p);
	  filemode = 2;
	  }
	fil0 = ftell(mfil);
	fgets(orgdir,sizeof(orgdir),mfil);
	}
      fseek(mfil,fil0,0);
      fil0 = ftell(mfil);
      read_file(40);
      }
    else {
      orgdisk = getdisk();
      if(isalpha(argx[0])&&(argx[1]==':')) {
	newdisk = (argx[0]&0x1F) - 1;
	setdisk(newdisk);
	if(getdisk()!=newdisk) error(7);
	argx += 2;
	if(!*argx) argx = root;
	}
      getcwd(orgdir,68);
      dirnam = argx;
      for(p=argx,q=NULL; *p; p++) if(*p=='\\') q = p;
      if(q) dirnam = &q[1];
      if(!(p=strchr(dirnam,'*'))) p = strchr(dirnam,'?');
      if(!p) {
	dirnam = all;
	if(chdir(argx)) error(5);
	}
      else if(q) {
	*q = '\0';
	if(!*argx) argx = root;
	if(chdir(argx)) error(5);
	}
      getcwd(curdir,68);
      if(vroot[0]) {
	strcpy(vroot,curdir);
	lockdir = 1;
	}
      else strcpy(&vroot[1],curdir);
      get_longname(".",0);
      read_directory(40);
      }
    update = 1;
    t0 = *timer;
    do {
      if(update) show_menu();
      if(kbhit()) {
	t0 = *timer;
	i  = getch();
	if(!i) {
	  i = getch();
	  if     (i==0X47) cursor_home();
	  else if(i==0X48) cursor_up();
	  else if(i==0X49) page_up();
	  else if(i==0X50) cursor_down();
	  else if(i==0X51) page_down();
	  }
	if(travel&&(i==0X0D)) i = change_dir();
	}
      if(tout) if((*timer-t0)>tout) i = 0X1B;
      } while((i!=0X0D)&&(i!=0X1B));
    gotoxy(1,25);
    cprintf("%-79s","");
    gotoxy(1,SCRBAS+MAXSCR);
    if((i!=0X1B)||(filemode==2)) {
      if(i==0X1B) {
	p = vroot;
	i = 0X0D;
	}
      else p = buf[cursor+ofs1];
      if(seldir&&(*p=='.')&&(p[1]<=' ')) {
	if((outform=='P')||(outform=='R')) *p = '\0';
	else if(!lfndos||outform!='L') {
	  if(!strcmp(&curdir[1],":\\")) p = &curdir[2];
	  else {
	    if(!(q = strrchr(curdir,'\\'))) p = curdir;
	    else {
	      p = ++q;
              if(dirform) strcat(p,"\\");
	      }
	    }
	  }
	}
      while(*p&&(*p<=' ')) p++;
      if(!filemode||(outform!='L')) {
	if((q=strchr(p,' '))!=NULL) {
	  *q++ = '\0';
//	  if(dirform&&(strstr(q,"<DIR>")!=NULL)) strcat(p,"\\");
	  if(dirform&&(strstr(q,"<DIR>")!=NULL)) dirform=2;
	  }
	if(outform=='B') if((q=strchr(p,'.'))!=NULL) *q = '\0';
	}
      if(!filemode&&lfndos&&(outform=='L')) if((q=get_longname(p,0))!=NULL) p = q;
      if(*p&&(dirform==2)) strcat(p,"\\");
      if(!filemode&&((outform=='P')||(outform=='R'))) {
	q = (vroot[0])?vroot:&vroot[1];
	if((outform=='R')&&(strstr(curdir,q)==curdir)) {
	  j = strlen(q);
	  if(j>3) j++;
	  strcat(cmdbuf,&curdir[j]);
	  if(strcmp(curdir,q)) {
	    if(*p||dirform) strcat(cmdbuf,"\\");
	    }
	  else if(seldir&&!curdir[j]) strcat(cmdbuf,".\\");
	  }
	else {
	  strcat(cmdbuf,curdir);
	  if((*p||dirform)&&strlen(curdir)>3) strcat(cmdbuf,"\\");
	  }
	}
      strcat(cmdbuf,p);
      if(!dostore) printf("SET %s\n",cmdbuf);
      else put_parentenv(cmdbuf);
      }
    if((!keepdir||(i==0X1B))&&orgdir[0]) {
      chdir(orgdir);
      if(orgdisk>=0) setdisk(orgdisk);
      }
    if(i==0X1B) exit(1);
    }
  exit(0);
  }
