#include <string.h>
#include <stdlib.h>

/*
 * 8-bit to 16-bit Unicode conversion tables for some
 * code pages. High byte is code page, low byte is character.
 * Some code pages at http://free.prohosting.com/~vitivas/js/UniCode/UniCode.html
 */
 
/* US */
unsigned int cp437[256] = {
/* 0x0 */
0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 
/* 0x10 */
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 
/* 0x20 */
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
/* 0x30 */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 
/* 0x40 */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 
/* 0x50 */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 
/* 0x60 */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 
/* 0x70 */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 
/* 0x80 */
0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7, 
0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x00C5, 
/* 0x90 */
0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9, 
0x00FF, 0x00D6, 0x00DC, 0x00A2, 0x00A3, 0x00A5, 0x20A7, 0x0192, 
/* 0xA0 */
0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA, 
0x00BF, 0x2310, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB, 
/* 0xB0 */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, 
0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 0x255B, 0x2510, 
/* 0xC0 */
0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x255E, 0x255F, 
0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x2567, 
/* 0xD0 */
0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256B, 
0x256A, 0x2518, 0x250C, 0x2588, 0x2584, 0x258C, 0x2590, 0x2580, 
/* 0xE0 */
0x03B1, 0x00DF, 0x0393, 0x03C0, 0x03A3, 0x03C3, 0x00B5, 0x03C4, 
0x03A6, 0x0398, 0x03A9, 0x03B4, 0x221E, 0x03C6, 0x03B5, 0x2229, 
/* 0xF0 */
0x2261, 0x00B1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00F7, 0x2248, 
0x00B0, 0x2219, 0x00B7, 0x221A, 0x207F, 0x00B2, 0x25A0, 0x00A0 
};

/* Latin-1 */
unsigned int cp850[256] = {
/* 0x00 */
0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
/* 0x10 */
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
/* 0x20 */
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
/* 0x30 */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
/* 0x40 */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
/* 0x50 */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
/* 0x60 */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
/* 0x70 */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 
/* 0x80 */
0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7,
0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x0C5,
/* 0x90 */
0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9, 
0x00FF, 0x00D6, 0x00DC, 0x00F8, 0x00A3, 0x00D8, 0x00D7, 0x0192,
/* 0xA0 */
0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA,
0x00BF, 0x00AE, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB,
/* 0xB0 */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00C1, 0x00C2, 0x00C0,
0x00A9, 0x2563, 0x2551, 0x2557, 0x255D, 0x00A2, 0x00A5, 0x2510,
/* 0xC0 */
0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x00E3, 0x00C3,
0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x00A4,
/* 0xD0 */
0x00F0, 0x00D0, 0x00CA, 0x00CB, 0x00C8, 0x2552, 0x00CD, 0x00CE, 
0x00CF, 0x2518, 0x250C, 0x2588, 0x2584, 0x00A6, 0x00CC, 0x2580,
/* 0xE0 */
0x00D3, 0x00DF, 0x00D4, 0x00D2, 0x00F5, 0x00D5, 0x00B5, 0x00FE,
0x00DE, 0x00DA, 0x00DB, 0x00D9, 0x00FD, 0x00DD, 0x00AF, 0x00B4,
/* 0xF0 */
0x00AD, 0x00B1, 0x2017, 0x00BE, 0x00B6, 0x00A7, 0x00F7, 0x00B8,
0x00B0, 0x00A8, 0x00B7, 0x00B9, 0x00B3, 0x00B2, 0x25A0, 0x00A0
};

/* Latin-2 */
unsigned int cp852[256] = {
/* 0x00 */
0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
/* 0x10 */
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
/* 0x20 */
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
/* 0x30 */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
/* 0x40 */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
/* 0x50 */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
/* 0x60 */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
/* 0x70 */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 
/* 0x80 */
0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x016f, 0x0107, 0x00e7, 
0x0142, 0x00eb, 0x0150, 0x0151, 0x00ee, 0x0179, 0x00c4, 0x0106, 
/* 0x90 */
0x00c9, 0x0139, 0x013a, 0x00f4, 0x00f6, 0x013d, 0x013e, 0x015a, 
0x015b, 0x00d6, 0x00dc, 0x0164, 0x0165, 0x0141, 0x00d7, 0x010d, 
/* 0xA0 */
0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x0104, 0x0105, 0x017d, 0x017e, 
0x0118, 0x0119, 0x00ac, 0x017a, 0x010c, 0x015f, 0x00ab, 0x00bb, 
/* 0xB0 */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x011a, 
0x015e, 0x2563, 0x2551, 0x2557, 0x255d, 0x017b, 0x017c, 0x2510, 
/* 0xC0 */
0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x0102, 0x0103, 
0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4, 
/* 0xD0 */
0x0111, 0x0110, 0x010e, 0x00cb, 0x010f, 0x0147, 0x00cd, 0x00ce, 
0x011b, 0x2518, 0x250c, 0x2588, 0x2584, 0x0162, 0x016e, 0x2580, 
/* 0xE0 */
0x00d3, 0x00df, 0x00d4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161, 
0x0154, 0x00da, 0x0155, 0x0170, 0x00fd, 0x00dd, 0x0163, 0x00b4, 
/* 0xF0 */
0x00ad, 0x02dd, 0x02db, 0x02c7, 0x02d8, 0x00a7, 0x00f7, 0x00b8, 
0x00b0, 0x00a8, 0x02d9, 0x0171, 0x0158, 0x0159, 0x25a0, 0x00a0
};

/* Cyrillic 2 */
unsigned int cp866[256] = {
/* 0x0 */
0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 
/* 0x10 */
0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 
/* 0x20 */
0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 
/* 0x30 */
0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 
/* 0x40 */
0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 
/* 0x50 */
0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 
/* 0x60 */
0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 
/* 0x70 */
0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 
/* 0x80 */
0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 
0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 
/* 0x90 */
0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 
0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 
/* 0xA0 */
0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 
0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 
/* 0xB0 */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, 
0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 0x255B, 0x2510, 
/* 0xC0 */
0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x255E, 0x255F, 
0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x2567, 
/* 0xD0 */
0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256B, 
0x256A, 0x2518, 0x250C, 0x2588, 0x2584, 0x258C, 0x2590, 0x2580, 
/* 0xE0 */
0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 
/* 0xF0 */
0x0401, 0x0451, 0x0404, 0x0454, 0x0407, 0x0457, 0x040E, 0x045E, 
0x00B0, 0x2219, 0x00B7, 0x221A, 0x2116, 0x00A4, 0x25A0, 0x00A0 
};

/*
 * Uppercase conversion tables for all above codepages.
 * 8-bit -> 8-bit
 */

unsigned int cp437_uc[256] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9, /*0  -  9*/
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19, /*10 - 19*/
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29, /*20 - 29*/
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39, /*30 - 39*/
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49, /*40 - 49*/
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59, /*50 - 59*/
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69, /*60 - 69*/
     70,  71,  72,  73,  74,  75,  76,  77,  78,  79, /*70 - 79*/
     80,  81,  82,  83,  84,  85,  86,  87,  88,  89, /*80 - 89*/
     90,  91,  92,  93,  94,  95,  96,  65,  66,  67, /*90 - 99*/
     68,  69,  70,  71,  72,  73,  74,  75,  76,  77, /*100 - 109*/
     78,  79,  80,  81,  82,  83,  84,  85,  86,  87, /*110 - 119*/
     88,  89,  90, 123, 124, 125, 126, 127, 128, 154, /*120 - 129*/
    144, 182, 142, 183, 143, 128, 210, 211, 212, 216, /*130 - 139*/
    215, 222, 142, 143, 144, 146, 146, 226, 153, 227, /*140 - 149*/
    234, 235, 152, 153, 154, 155, 156, 157, 158, 159, /*150 - 159*/
    181, 214, 224, 233, 165, 165, 166, 167, 168, 169, /*160 - 169*/
    170, 171, 172, 173, 174, 175, 176, 177, 178, 179, /*170 - 179*/
    180, 181, 182, 183, 184, 185, 186, 187, 188, 189, /*180 - 189*/
    190, 191, 192, 193, 194, 195, 196, 197, 198, 199, /*190 - 199*/
    200, 201, 202, 203, 204, 205, 206, 207, 208, 209, /*200 - 209*/
    210, 211, 212, 213, 214, 215, 216, 217, 218, 219, /*210 - 219*/
    220, 221, 222, 223, 224, 225, 226, 227, 228, 229, /*220 - 229*/
    230, 231, 232, 233, 234, 235, 236, 237, 238, 239, /*230 - 239*/
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, /*240 - 249*/
    250, 251, 252, 253, 254, 255
};

/* Latin-1 */
unsigned int cp850_uc[256] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9, /*0  -  9*/
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19, /*10 - 19*/
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29, /*20 - 29*/
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39, /*30 - 39*/
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49, /*40 - 49*/
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59, /*50 - 59*/
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69, /*60 - 69*/
     70,  71,  72,  73,  74,  75,  76,  77,  78,  79, /*70 - 79*/
     80,  81,  82,  83,  84,  85,  86,  87,  88,  89, /*80 - 89*/
     90,  91,  92,  93,  94,  95,  96,  65,  66,  67, /*90 - 99*/
     68,  69,  70,  71,  72,  73,  74,  75,  76,  77, /*100 - 109*/
     78,  79,  80,  81,  82,  83,  84,  85,  86,  87, /*110 - 119*/
     88,  89,  90, 123, 124, 125, 126, 127, 128, 154, /*120 - 129*/
    144, 182, 142, 183, 143, 128, 210, 211, 212, 216, /*130 - 139*/
    215, 222, 142, 143, 144, 146, 146, 226, 153, 227, /*140 - 149*/
    234, 235, 152, 153, 154, 157, 156, 157, 158, 159, /*150 - 159*/
    181, 214, 224, 233, 165, 165, 166, 167, 168, 169, /*160 - 169*/
    170, 171, 172, 173, 174, 175, 176, 177, 178, 179, /*170 - 179*/
    180, 181, 182, 183, 184, 185, 186, 187, 188, 189, /*180 - 189*/
    190, 191, 192, 193, 194, 195, 196, 197, 199, 199, /*190 - 199*/
    200, 201, 202, 203, 204, 205, 206, 207, 208, 209, /*200 - 209*/
    210, 211, 212, 213, 214, 215, 216, 217, 218, 219, /*210 - 219*/
    220, 221, 222, 223, 224, 225, 226, 227, 229, 229, /*220 - 229*/
    230, 231, 232, 233, 234, 235, 237, 237, 238, 239, /*230 - 239*/
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, /*240 - 249*/
    250, 251, 252, 253, 254, 255
};
  
/* Latin-2 */  
unsigned int cp852_uc[256] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9, /*0  -  9*/
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19, /*10 - 19*/
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29, /*20 - 29*/
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39, /*30 - 39*/
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49, /*40 - 49*/
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59, /*50 - 59*/
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69, /*60 - 69*/
     70,  71,  72,  73,  74,  75,  76,  77,  78,  79, /*70 - 79*/
     80,  81,  82,  83,  84,  85,  86,  87,  88,  89, /*80 - 89*/
     90,  91,  92,  93,  94,  95,  96,  65,  66,  67, /*90 - 99*/
     68,  69,  70,  71,  72,  73,  74,  75,  76,  77, /*100 - 109*/
     78,  79,  80,  81,  82,  83,  84,  85,  86,  87, /*110 - 119*/
     88,  89,  90, 123, 124, 125, 126, 127, 128, 154, /*120 - 129*/
    144, 182, 142, 222, 143, 128, 157, 211, 138, 138, /*130 - 139*/
    215, 171, 142, 143, 144, 145, 146, 226, 153, 149, /*140 - 149*/
    149, 151, 151, 153, 154, 155, 155, 157, 158, 172, /*150 - 159*/
    181, 214, 224, 233, 164, 164, 166, 166, 168, 168, /*160 - 169*/
    170, 171, 172, 184, 174, 175, 176, 177, 178, 179, /*170 - 179*/
    180, 181, 182, 183, 184, 185, 186, 187, 188, 189, /*180 - 189*/
    189, 191, 192, 193, 194, 195, 196, 197, 198, 198, /*190 - 199*/
    200, 201, 202, 203, 204, 205, 206, 207, 209, 209, /*200 - 209*/
    210, 211, 210, 213, 214, 215, 183, 217, 218, 219, /*210 - 219*/
    220, 221, 222, 223, 224, 225, 226, 227, 227, 213, /*220 - 229*/
    230, 230, 232, 233, 232, 235, 237, 237, 221, 239, /*230 - 239*/
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, /*240 - 249*/
    250, 235, 252, 252, 254, 255
};

/* Cyrillic 2 */
unsigned int cp866_uc[256] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  /* 0 - 9 */
     10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  /* 10 - 19 */
     20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  /* 20 - 29 */
     30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  /* 30 - 39 */
     40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  /* 40 - 49 */
     50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  /* 50 - 59 */
     60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  /* 60 - 69 */
     70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  /* 70 - 79 */
     80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  /* 80 - 89 */
     90,  91,  92,  93,  94,  95,  96,  65,  66,  67,  /* 90 - 99 */
     68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  /* 100 - 109 */
     78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  /* 110 - 119 */
     88,  89,  90, 123, 124, 125, 126, 127, 128, 129,  /* 120 - 129 */      
    130, 131, 132, 133, 134, 135, 136, 137, 138, 139,  /* 130 - 139 */
    140, 141, 142, 143, 144, 145, 146, 147, 148, 149,  /* 140 - 149 */
    150, 151, 152, 153, 154, 155, 156, 157, 158, 159,  /* 150 - 159 */
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137,  /* 160 - 169 */
    138, 139, 140, 141, 142, 143, 176, 177, 178, 179,  /* 170 - 179 */
    180, 181, 182, 183, 184, 185, 186, 187, 188, 189,  /* 180 - 189 */
    190, 191, 192, 193, 194, 195, 196, 197, 198, 199,  /* 190 - 199 */
    200, 201, 202, 203, 204, 205, 206, 207, 208, 209,  /* 200 - 209 */
    210, 211, 212, 213, 214, 215, 216, 217, 218, 219,  /* 210 - 219 */
    220, 221, 222, 223, 144, 145, 146, 147, 148, 149,  /* 220 - 229 */
    150, 151, 152, 153, 154, 155, 156, 157, 158, 159,  /* 230 - 239 */
    240, 240, 242, 242, 244, 244, 246, 246, 248, 249,  /* 240 - 249 */ 
    250, 251, 252, 253, 254, 255
};


/*
 * code page index. Every codepage needs to be listed
 * under its number from http://www.ctyme.com/intr/rb-3168.htm#Table1757
 *
 */

struct cp_index_entry {
 unsigned int cp;
 unsigned int*         table;
 unsigned int*         uc_table;
};

struct cp_index_entry cp_index[] = {
 {437, cp437, cp437_uc},
 {850, cp850, cp850_uc},
 {852, cp852, cp852_uc},
 {866, cp866, cp866_uc}
};

                                              
/* pointers to unicode codepages */
unsigned char* unicode_pg[256];
/* pointer to current codepage */
unsigned int* cp_table = NULL;   
/* pointer to current upcase table */
unsigned int* asciiUpcase = NULL;  


/**
 * Gets the number of the current active DOS codepage
 */
#pragma optimize("gel",off) //cannot optimize asm
unsigned int getDOSActiveCP(void) {
 unsigned int cp;
 __asm {
   mov ax, 0x6601
   int 0x21
   mov [cp], bx
 }
 return cp;
}  
#pragma optimize("",on)  
         
         
   

/**
 * Conversion functions for zero terminated strings
 */
   
/* converts Unicode to current 8-bit codepage, returns length of ascii string */   
int uni2ascii(unsigned int* uni, unsigned char* ascii) {
  unsigned char* op;
  unsigned int* ip;
  unsigned char page, pg_off;
  unsigned char *uni_page;

  ip = uni;
  op = ascii;

  while (*ip) {
       pg_off = (*ip & 0x00FF);
       page = (*ip & 0xFF00) >> 8;
       *ip++;
       uni_page = unicode_pg[page];
       if (uni_page != NULL) {
            *op++ = uni_page[pg_off];
       } else {
            *op++ = '_'; /*unknown*/
       }
  }
  *op = 0;
  return (op - ascii);
}
 
/* converts 8-bit characters to Unicode using current code page, returns length of Unicode string */
int ascii2uni(unsigned char* ascii, unsigned int* uni) {
  unsigned char* ip;
  unsigned int* op;

  ip = ascii;
  op = uni;
  
  while (*ip) {
   *op++ = cp_table[*ip++];
  }
  *op = 0;
  return (op - uni);
}

/**
 * Initialisation. 
 */ 

/*debug*/
void printUniTbl(int pg) {
  for (int i=0; i<256; i++) {
   printf("%c\t", unicode_pg[pg][i]);
   if (i % 16 == 15) printf("\n");
  }
}
 
/* Creates the unicode tables for the current codepage.
  16-bit to 8-bit. Characters not in the current codepage
  will be converted to the underscore character (0x5F).
  Do not call directly.
 */
void makeUnicodeTables(void) {
  memset(unicode_pg, 0, sizeof(unicode_pg));
  for (unsigned int i=0; i<256; i++) {
    unsigned char pg = (cp_table[i] & 0xFF00) >> 8;
    unsigned char c  = (unsigned char) (cp_table[i] & 0x00FF);
    if (unicode_pg[pg] == NULL) {
      unicode_pg[pg] = (unsigned char*) malloc(256);
      memset(unicode_pg[pg], '_', 256);
    }  
    unicode_pg[pg][c] = i;
  }     
}   

/* call this once */
void initUnicodeLib(void) {
 unsigned int cp = getDOSActiveCP();
 int max = sizeof(cp_index) / sizeof(cp_index[0]);
 for (int i=0; i < max; i++) {
   if (cp_index[i].cp == cp) {
     cp_table = cp_index[i].table;
     asciiUpcase = cp_index[i].uc_table;
     break;
   }
 }
 if (cp_table == NULL) {
   printf("Codepage %u not supported\n", cp);
   exit(1);
 }       
 makeUnicodeTables();
}  

