;
;  Stream viewer (text) SVTXT.COM
;    syntax: type filename | svtxt
;
;    Designed and programmed by Lo Hung Che
;    Copyright (C) BAHCL 2004
;
;  Dedicated to FreeDOS www.freedos.org
;    under the terms and license of GNU GPL version 2
;
org 100h
segment .text
            mov     sp,stackbot+512         ; stack size = 512 bytes
            mov     bx,sp
            mov     cx,4
            shr     bx,cl
            inc     bx
            mov     ax,ds
            add     ax,bx
            mov     [stream],ax           ; seg. address for data
            mov     [itable],ax           ; line index table

            call    HW_Setting
            call    FileType
            mov     ax,[fhandle]
            push    ax
            call    Get_Data
            cmp     word [ssize],0
            jz      @0001                 ; no data at all

            call    Parse_Data
            call    Last_Line
            call    Clear_Screen
            call    Get_Scancode
            mov     bx,[fhandle]
            or      bx,bx
            jz      @0001
            mov     ax,3E00h              ; close file
            int     21h
@0001:
            call    Clear_Screen
            mov     ax,4C00h
            int     21h
;
; Determine input file be stream/regular
FileType
            xor     ax,ax
            mov     si,80h                ; check command tail
            lodsb
            or      al,al
            jz      @0010                 ; stream
            mov     di,si
            add     di,ax
            xchg    ah,al
            stosb
@0011:
            lodsb
            cmp     al,20h
            jz      @0011
            dec     si
            mov     ax,3D00h              ; open file
            mov     dx,si
            int     21h
            jc      @0010
            mov     [fhandle],ax

            push    es
            mov     ax,40h
            mov     es,ax
            mov     dx,[es:0F0h]          ; iaca intra application comm. area
            mov     cx,[es:0F2h]
            mov     ax,[es:0F4h]
            mov     [quitkey],ax
            xor     ax,ax
            mov     [es:0F0h],ax          ; clear iaca
            mov     [es:0F2h],ax
            mov     [es:0F4h],ax
            pop     es
            mov     ax,4200h
            mov     bx,[fhandle]
            int     21h
@0010:
            ret
;
;
; Display data to screen
Show_Data
            push    bp
            mov     bp,sp
            mov     cx,[bp+6]               ; lines to print
            xor     di,di
@nextline:
            mov     ax,[totlines]
            dec     ax
            cmp     ax,[bp+4]
            jbe     @0030
            push    cx
            mov     ax,[bp+4]               ; line# to print
            call    Make_String
            inc     word [bp+4]
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            mov     cx,[linewidth]           ; line size
            mov     si,buffer
            mov     ah,07
@nextbyte:
            lodsb
            stosw
            loop    @nextbyte
            pop     es
            pop     cx
            loop    @nextline
@0030:

            mov     ax,[bp+4]
            pop     bp
            ret     4
;
;
; format a string for display
Make_String
            push    di
            mov     si,ax
            shl     si,1
            mov     di,buffer
            mov     cx,[linewidth]           ; clear the line
            mov     al,20h
            rep     stosb
            mov     di,buffer
            xor     dx,dx
            push    ds
            mov     ax,[itable]
            mov     ds,ax
            lodsw
            pop     ds
            mov     si,ax
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
@nextchar:
            lodsb
            cmp     al,CR
            jz      @nextchar
            cmp     al,LF
            jz      @eoline                  ; End of line

            cmp     al,TAB
            jnz     @0041
            call    Do_TAB
            add     di,ax
            jmp     @0042
@0041:
            stosb
            inc     bx
@0042:
            cmp     bx,[cs:linewidth]
            jae     @eoline
            jmp     @nextchar
@eoline
            pop     ds
            pop     di
            ret
;
; user interface
; get keyboard scancode
Get_Scancode
            mov     ax,[oldline]
            cmp     ax,[linenum]
            je      @0021
            mov     ax,[totlines]
            cmp     ax,[lineperpage]
            jb      @0020
            mov     ax,[lineperpage]
@0020:
            push    ax
            mov     ax,[linenum]
            mov     [oldline],ax
            push    ax
            call    Show_Data
            push    es
            mov     ax,40h
            mov     es,ax
            xor     ax,ax
            mov     [es:0F0h],ax
            pop     es
@0021:
            mov     ah,1
            int     16h
            jz      @0022
            xor     ax,ax
            int     16h
            cmp     ax,[quitkey]
            jne     @0023
            ret
@0022:
            push    es                       ; what mouse event?
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:0F0h]
            pop     es
@0023:
            mov     cx,[keys]
            inc     cx
            mov     di,scancode
            mov     si,di
            repne   scasw
            jcxz    @0021
            mov     ax,di
            sub     ax,si
            dec     ax
            dec     ax

            mov     bx,procnames
            add     bx,ax
            call    [bx]
            cmp     ax,1
            jnz     Get_Scancode
            ret
;
; key = escape
K_Esc
            mov     ax,1
            ret
; key = up
K_Up
            mov     ax,1
            mov     dx,1
            call    Check_Limit
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = down
K_Dn
            mov     ax,1
            xor     dx,dx
            call    Check_Limit
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page up
K_P_Up
            mov     ax,[lineperpage]
            mov     dx,1
            call    Check_Limit
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page down
K_P_Dn
            mov     ax,[lineperpage]
            xor     dx,dx
            call    Check_Limit
            mov     [linenum],ax

            xor     ax,ax
            ret
; key = home
K_Home
            xor     ax,ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = end
K_End
            mov     ax,[totlines]
            xor     dx,dx
            call    Check_Limit
            mov     [linenum],ax
            xor     ax,ax
            ret
;
;
; clear the screen, send cursor home
Clear_Screen
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            xor     di,di
            mov     ax,0720h
            mov     cx,[lineperpage]
.loop       push    cx
            mov     cx,[linewidth]
            rep     stosw
            pop     cx
            loop    .loop
            pop     es
            mov     ah,2
            xor     bx,bx
            xor     dx,dx
            int     10h
            ret
;
;
; handle TAB
Do_TAB
            push    bx
            mov     al,bl
            xor     ah,ah
            mov     bl,TABSTOP
            div     bl
            mov     al,TABSTOP
            sub     al,ah
            xor     ah,ah
            pop     bx
            add     bx,ax
            ret
;
;
; handles LF CR
DO_LFCR
            mov     bx,[cs:linewidth]
            ret
;
; Parse data from stream                        ; find offset of each line
Parse_Data
            push    es
            push    ds
            mov     ax,[itable]
            mov     es,ax
            mov     cx,[ssize]
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
            xor     di,di
            xor     si,si
            xor     ax,ax
            stosw
@0090:
            lodsb
            cmp     si,cx
            jae     @eof
            cmp     al,CR
            jz      @0090
            cmp     al,TAB
            jnz     @0091
            call    Do_TAB
            jmp     @0093
@0091:
            cmp     al,LF
            jnz     @0092
            call    DO_LFCR
            jmp     @0093
@0092:
            inc     bx
@0093:
            mov     ax,[cs:linewidth]
            sub     ax,bx
            jnz     @0094
            mov     ax,si
            stosw
            xor     bx,bx
@0094:
            jmp     @0090
@eof:
            or      bx,bx                 ; data in last line
            jz      @0095
            stosw
@0095:
            pop     ds
            pop     es
            mov     ax,di
            shr     ax,1
            mov     [totlines],ax
            ret
;
; get data from stream
Get_Data
            push    bp
            mov     bp,sp
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            mov     ax,3F00h                 ; read file
            xor     dx,dx
            mov     cx,0FFF0h
            mov     bx,[bp+4]                ; file handle
            int     21h
;
            mov     bx,ax
            mov     dl,LF
            mov     byte [bx],dl
;
            pop     ds
            mov     [ssize],ax
            mov     cl,4
            shr     ax,cl
            inc     ax
            add     [itable],ax
            pop     bp
            ret     2
;
;
; hardware setting
HW_Setting
            mov     ah,0Fh             ; set up display mode seg. address
            int     10h
            cmp     al,7               ; mono
            jnz     @0100
            mov     ax,0B000h
            mov     [vid_seg],ax
@0100:
            push    es
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:4Ah]
            mov     [linewidth],ax
            xor     ax,ax
            mov     al,[es:84h]
            inc     ax
            mov     [lineperpage],ax
            pop     es
            ret
;
;
;  Decide the last line
Last_Line
            mov    ax,[totlines]
            cmp    ax,[lineperpage]
            jna    @0110
            sub    ax,[lineperpage]
            dec    ax
            mov    [lastline],ax
@0110:
            ret
;
; Check linenum within limit
Check_Limit
            mov     cx,ax
            xor     ax,ax
            mov     bx,[totlines]
            cmp     bx,[lineperpage]
            jna     @0120                 ; out of range
            or      dx,dx
            jnz     @0123                 ; Up, PageUp
            add     cx,[linenum]          ; Down, PageDown, End
            cmp     cx,[lastline]
            ja      @0121
            mov     ax,cx
            jmp     @0120
@0123:                                    ; for Up, PageUp
            mov     ax,[linenum]
            sub     ax,cx
            jc      @0122
            jmp     @0120
@0122:
            xor     ax,ax
            jmp     @0120
@0121:
            mov     ax,[lastline]
@0120:
            ret
;
;
segment .data
TABSTOP         EQU     8
TAB             EQU     9
CR              EQU     0Dh
LF              EQU     0Ah
fhandle         dw      0
vid_seg         dw      0B800h          ; color
lineperpage     dw      0
linewidth       dw      0
stream          dw      0               ; stream segment address
ssize           dw      0               ; stream size
itable          dw      0               ; line index segment address
oldline         dw      7                  ; ?
linenum         dw      0               ; line number
totlines        dw      0
lastline        dw      0               ; last top line
keys            dw      7
scancode        dw      011Bh,4800h,5000h,4900h,5100h,4700h,4F00h
procnames       dw      K_Esc,K_Up,K_Dn,K_P_Up,K_P_Dn,K_Home,K_End
quitkey         dw      0
buffer    times 80  db  20h
stackbot
;               db      'Designed and programmed by Lo Hung Che',0
;               db      'Copyright (C) BAHCL 2004',0
;
;
