/*
 * This file is part of FDNPKG.
 * Copyright (C) Mateusz Viste 2013. All rights reserved
 * 
 * Tests two version strings, and tells if the second one is newer than the first one.
 */

#include <stdio.h>
#include "showinst.c"

int main(int argc, char **argv) {
  int x;
  if (argc != 3) {
    printf("usage: %s ver1 ver2\r\n", argv[0]);
    return(1);
  }
  x = isversionnewer(argv[2], argv[1]);
  if (x > 0) {
      printf("'%s' is newer than '%s'.\r\n", argv[1], argv[2]);
    } else if (x == 0) {
      printf("'%s' is NOT newer than '%s'.\r\n", argv[1], argv[2]);
    } else {
      printf("could not understand version string(s).\r\n");
  }
  return(0);
}
