REM
REM
REM Mateusz Viste <mateusz.viste@mail.ru>
REM

SUB SelectiveSort(DirList() AS STRING, DirIndex AS UINTEGER)
  ' Sorts an array of strings using the selective sort algorithm.
  DIM AS UINTEGER x, y, SmallestEntry
  FOR x = 1 TO DirIndex
    SmallestEntry = x
    FOR y = x + 1 TO DirIndex
      IF LCASE(DirList(y)) < LCASE(DirList(SmallestEntry)) THEN SmallestEntry = y
    NEXT y
    Swap DirList(x), DirList(SmallestEntry)
  NEXT x
END SUB

SUB strQsort(myarray() AS STRING, LastEl AS INTEGER)
    DIM AS INTEGER qstack(200)
    DIM AS INTEGER i, j, first, last, stackptr
    DIM AS STRING temp

    first = Lbound(myarray)
    last  = LastEl 'ubound(myarray)
    DO
        DO
            temp = myarray((last + first)\2)
            i = first
            j = last
            DO  'reverse both < and > below to sort descending
                WHILE LCASE(myarray(i)) < LCASE(temp)
                    i += 1
                WEND
                WHILE LCASE(myarray(j)) > LCASE(temp)
                    j -= 1
                WEND
                IF i > j THEN
                    EXIT DO
                END IF
                IF i < j THEN
                    Swap myarray(i), myarray(j)
                END IF
                i += 1
                j -= 1
            LOOP UNTIL i > j
            IF i < last THEN
                qstack(stackptr) = i
                qstack(stackptr + 1) = last
                stackptr += 2
            END IF
            last = j
        LOOP UNTIL first >= last
        IF stackptr = 0 THEN
            EXIT DO
        END IF
        stackptr -= 2
        first = qstack(stackptr)
        last = qstack(stackptr + 1)
    LOOP
END SUB
