#include <stdio.h>    /* printf() */
#include <unistd.h>   /* read() */
#include "crc32lib.c"

#define BUFFSIZE 4096

int main() {
  unsigned long result;
  unsigned char buff[BUFFSIZE];
  int buffread;
  
  result = crc32_init();

  while ((buffread = read(STDIN_FILENO, buff, BUFFSIZE)) > 0) {
    if (buffread > 0) crc32_feed(&result, buff, buffread);
  }

  if (buffread < 0) {
    puts("read() error!");
    return(1);
  }

  crc32_finish(&result);

  printf("%08lX", result);
  return(0);
}
