/*
 *      fdav.h
 *
 *      Copyright 2008 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#ifndef __FDAV_H
#define __FDAV_H

#include <sys/types.h>
#include <sys/statvfs.h>
#include <sys/select.h>
#include <sys/stat.h>
#include <process.h>
#include <termios.h>
#include <clamav.h>
#include <limits.h>
#include <mntent.h>
#include <string.h>
#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <slang.h>
#include <stdio.h>
#include <dpmi.h>
#include <glob.h>
#include <newt.h>
#include <dir.h>
#include <dos.h>
#include <ftw.h>
#include <gpm.h>
#include <io.h>
#include <pc.h>

#define FDAV_VERSION_STRING "0.2"

#define DRIVE_FLOPPY        0x01
#define DRIVE_SUBST         0x02
#define DRIVE_NET           0x04
#define DRIVE_ALL           0x07

#define FDAV_ALLDRV         0x00000001
#define FDAV_REMOVE         0x00000002
#define FDAV_NODISP         0x00000004
#define FDAV_NMOUSE         0x00000008
#define FDAV_NONETD         0x00000010
#define FDAV_LOGFIL         0x00000020
#define FDAV_LMOUSE         0x00000040
#define FDAV_DSPTXT         0x00000080
#define FDAV_DMOUSE         0x00000100
#define FDAV_NEWLOG         0x00000200
#define FDAV_CLINEI         0x00000400
#define FDAV_RMOUSE         0x00000800
#define FDAV_REPORT         0x00001000
#define FDAV_QUTINE         0x00002000
#define FDAV_QCLEAN         0x00004000
#define FDAV_NREMOV         0x00008000
#define FDAV_GETVER         0x00010000
#define FDAV_VIDEOM         0x00020000
#define VIDEO_25            0x00040000
#define VIDEO_28            0x00080000
#define VIDEO_43            0x00100000
#define VIDEO_50            0x00200000
#define VIDEO_60            0x00400000
#define VIDEO_COLOR         0x00800000
#define VIDEO_BW            0x01000000
#define VIDEO_MONO          0x02000000
#define VIDEO_LCD           0x04000000
#define VIDEO_FF            0x08000000
#define VIDEO_ANSI          0x10000000
#define VIDEO_BIOS          0x20000000
#define VIDEO_NF            0x40000000
#define VIDEO_BT            0x80000000

#define VIDEO_LINES         ( VIDEO_25 | VIDEO_28 | VIDEO_43 | VIDEO_50 | VIDEO_60 )

#define TUI_QUICK           0
#define TUI_ASAVE           1
#define TUI_DETECT          2
#define TUI_ALLF            3
#define TUI_ASTEALTH        4
#define TUI_PROMPT          5
#define TUI_REPORT          6
#define TUI_BACKUP          7
#define TUI_NALARM          8
#define TUI_FCHECK          9
#define TUI_NCHECK          10
#define TUI_VERIFY          11
#define TUI_NOTEMP          12

#define TUI_OPTION( o )     ( av_options[ ( o ) ].state )
#define TUI_MAX_OPTS        13

#define TUI_BUTTON_DETECT   0
#define TUI_BUTTON_DCLEAN   1
#define TUI_BUTTON_NDRIVE   2
#define TUI_BUTTON_OPTION   3
#define TUI_BUTTON_AVEXIT   4
#define TUI_BUTTON_MAX      5

#define TUI_CHOICE_LEAVE    0
#define TUI_CHOICE_REMOVE   1
#define TUI_CHOICE_BACKUP   2

#define TUI_SIDEBAR_INFO    0
#define TUI_SIDEBAR_DETECT  1
#define TUI_SIDEBAR_DCLEAN  2
#define TUI_SIDEBAR_DRIVES  3
#define TUI_SIDEBAR_OPTIONS 4
#define TUI_SIDEBAR_MSGBOX  5

#define ACTION_CLEAN        0
#define ACTION_IGNORE       1
#define ACTION_BACKUP       2

#define ESCAPE_KEY          27

struct tui_listitem {
    char *name;
    char state;
};

extern uint32_t             opts;
extern int                  files;
extern char               **filev;
extern struct cl_engine    *scan_engine;
extern struct cl_limits     vlimits;
extern int                  scan_sigs;
extern int                  scan_opts;
extern long int             scanned;
extern long int             viruses;
extern long int             viruses_removed;
extern long int             files_checked;
extern int                  db_loaded;
extern char                *fdav_filename;
extern char                *fdav_inifile;
extern char                *fdav_backup;
extern char                *fdav_logfile;
extern char                *fdav_dirname;
extern char                *fdav_helpfile;
extern struct tui_listitem  av_options[];
extern char                *ini_strings[];

extern void dos_filename( char *filename );
extern char **get_drive_array( int types, int *read );
extern void free_drive_array( char **array, int size );
extern void write_tui_ops( void );
extern void read_tui_ops( void );
extern int  load_database( void );
extern void logprintf( const char *format, ... );
extern int  backup_file( const char *path );
extern int  input_ready( void );
extern int  has_ext( const char *path );
extern int  create_report( const char *drivepath );
extern int  fdav_cli( void );
extern int  fdav_tui( void );

extern void tui_view_help( int fdav_page );

#endif
