/*
 *      helpcomp.h
 *
 *      Copyright 2008 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#ifndef __HELPCOMP_H_INCLUDED
#define __HELPCOMP_H_INCLUDED

#include <stdio.h> /* We need FILE */

#define HELP_MAXNAME    20
#define HELP_MAXTITLE   40
#define HANDLE_PRAGMA_PACK_PUSH_POP 1

struct help_index {
    char    help_title[ HELP_MAXTITLE ];
    int     help_npages;
    int     help_nlinks;
    int     help_startpage;
};

struct help_link {
    int     hlink_page;
};

struct help_link_tofile {
    char    hlink_name[ HELP_MAXNAME ];
    int     hlink_page;
};

#pragma pack( push, 1 )
struct help_link_binary {
    char    hlink_open;
    short   hlink_num;
    char    hlink_close;
};
#pragma pack( pop )

struct help_page_entry {
    char    hent_title[ HELP_MAXNAME ];
    int     hent_start;
    long    hent_size;
    int     hent_nlinks;
};

typedef struct help_finfo {
    struct help_index       hfinf_index;
    struct help_link       *hfinf_links;
    struct help_page_entry *hfinf_pages;
    FILE                   *hfinf_file;
} HELP;

#define help_title( h )             ( ( h )->hfinf_index.help_title )
#define help_pages( h )             ( ( h )->hfinf_index.help_npages )
#define help_links( h )             ( ( h )->hfinf_index.help_nlinks )
#define help_spage( h )             ( ( h )->hfinf_index.help_startpage )
#define help_link_to_page( h, l )   ( ( h )->hfinf_links[ ( ( struct help_link_binary * )( l ) )->hlink_num ].hlink_page )
#define htlp_links_in_page( h, p ) ( ( h )->hfinf_pages[ ( p ) ].hent_nlinks )
#define help_pagetitle( h, p )      ( ( h )->hfinf_pages[ ( p ) ].hent_title )
#define help_pagesize( h, p )       ( ( h )->hfinf_pages[ ( p ) ].hent_size )
#define help_pagestart( h, p )      ( ( h )->hfinf_pages[ ( p ) ].hent_start )

extern void  help_close( HELP *hlp );
extern HELP *help_open( const char *filename );
extern char *help_readpage( HELP *hlp, int page );

#endif // __HELPCOMP_H_INCLUDED
