; callver: simple DOS version override helper, by Eric Auer 2003.
; compile with nasm -o callver.com callver.asm
; run as: callver 1.23 program arguments
; effect: program will get dos version "1.23" from int 21h, ah=30h.
; license: public domain. have fun!

	org 100h
start:	jmp setup

runit:	mov sp,stack	; not using cs:80h..cs:0ffh, need to preserve that
	mov bx,stack+4+0fh
	mov cl,4
	shr bx,cl
	push es
	mov ax,cs
	mov es,ax
	mov ah,4ah	; resize memory block on ES to minimum
	int 21h		; (must keep PSP and environment, of course)
	pop es		; (AX and BX got changed)
	mov ax,4b00h	; execute program
	mov bx,cs
	mov es,bx	; ds:dx - executable file name (from runit-caller)
	mov bx,exetab	; es:bx - parameter block
	int 21h

done:	cli
	mov ax,cs
	mov ss,ax
	mov sp,0xfc
	sti
	mov al,-1
	jc leaveit	; did exec itself fail?
	mov ah,4dh	; get errorlevel in AL
	int 21h		; discarded in AH: exit type, which is 0 normal,
			; 1 ctrl-c, 2 critical error, 3 TSR
leaveit:
	push ax
	mov ax,cs
	mov ds,ax
	mov es,ax
	push ds
	lds dx,[oldint]
	mov ax,2521h	; reset int 21h vector
	int 21h
	pop ds
	pop ax
	mov ah,4ch	; exit, returning errorlevel
	int 21h

handint:
	cmp ah,30h		; dos version check?
	jz fakever
	jmp far [cs:oldint]	; chain to original handler
fakever:
	pushf			; fake int operation
	call far [cs:oldint]	; call original handler
	mov ax,[cs:dosver]	; fake returned AX value
	iret			; return to caller

	; PS: exectab is processed by patchPSP and others in FreeDOS...
exetab:	dw 0		; use caller environment segment
	dw 80h		; pointer to "arguments" in PSP segment of callver
	dw 0		; will be PSP segment of callver
	dw 5ch		; 1st FCB: use the one of callver (?)
			; looks as if offset is -1 here, no FCBs are copied
	dw 0		; ... segment
	dw 6ch		; 2nd FCB ...
	dw 0

oldint:	dd 0		; original int 21h vector
dosver:	dw 0		; ah=minor al=major

hellomessage:		; will be overwritten by stack
	db "Usage: CALLVER 1.23 PROGRAM [ARGUMENTS]",13,10
	db "to make program believe that it is running DOS 1.23",13,10
	db "(any value of x.xx form is okay)",13,10
	db "COMSPEC must be valid as well.",13,10,"$"
cspecerrormessage:
	db "COMSPEC not found",13,10,"$"
comarg:	db " /c "

setup:	push es
	mov ax,3521h	; get and store original int 21h vector
	int 21h
	mov [cs:oldint],bx
	mov [cs:oldint+2],es
	pop es
	mov dx,handint	; new int 21h handler
	; mov ds,cs not needed
	mov ax,2521h	; set int 21h vector
	int 21h

	mov ax,cs
	mov [exetab+4],ax
	mov [exetab+8],ax
	mov [exetab+12],ax

	cld
	mov si,0x80	; argument length
	lodsb		; get size
	cmp al,6	; at least "1.23 x"
	jnb getarg
nusage:	jmp usage

getarg:	lodsb
	cmp al,' '	; skip spaces
	jz getarg
	cmp al,13	; end marker?
	jbe nusage
	call digit	; ensure DIGIT
	mov [dosver],al	; store MAJOR version number
	lodsb
	cmp al,'.'	; next must be dot
	jnz nusage
	lodsb
	call digit	; ensure DIGIT
	mov ah,10
	mul ah
	mov [dosver+1],al	; store MINOR version, high part
	lodsb
	call digit	; ensure DIGIT
	add [dosver+1],al	; store MINOR version, low part
spc:	lodsb
	cmp al,' '	; skip over space
	jz spc
	jb usage	; end marker reached before program name

	sub si,4+1	; point to 4 before program name now
	mov di,si
	dec di		; room for length byte
	mov [exetab+2],di	; arguments to command.com start here
	inc di
	mov si,comarg	; " /c " (4 chars)
	movsw
	movsw		; copied the string over the "n.nn " string now

	mov ah,4	; already have 4 chars
	mov si,di
argcnt:	lodsb
	inc ah
	cmp al,13	; eof marker?
	ja argcnt
	dec ah		; do not count eof marker
	; ... could replace eof marker by some other value here ...
	mov di,[exetab+2]	; "command tail" including length byte
	mov [di],ah	; store length
	
	mov ax,[ds:2ch]	; get environment segment from PSP
	mov ds,ax
	xor si,si

findcomspec:
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"CO"
	jnz skiparg
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"MS"
	jnz skiparg
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"PE"
	jnz skiparg
	lodsw
	and al,0dfh	; upcase (only the last "c" of "comspec"...)
	cmp ax,"C="
	jnz skiparg

gotcomspec:
	mov dx,si	; pointer to executable file name of shell
	; mov ds,ds
	jmp runit	; finally, RUN "%COMSPEC% /C program arguments"

skiparg:
	lodsb
	or al,al
	jnz skiparg	; skip until 0 byte
	cmp [ds:si],al	; next byte is 0, too?
	jz cspecerr	; bad luck, no COMSPEC found
	jmp findcomspec	; try next env variable

cspecerr:
	mov dx,cspecerrormessage
	jmp short usage2
usage:	mov dx,hellomessage
usage2:	mov ax,cs
	mov ds,ax
	mov ah,9	; show string
	int 21h
	mov al,-1	; report usage error
	jmp leaveit

digit:	cmp al,'0'	; leave if no digit (i.e. end marker)
	jb nodig
	cmp al,'9'
	ja nodig
	sub al,'0'
	ret		; return digit value otherwise

nodig:	pop ax		; throw away caller address
	jmp usage

	align 4		; setup and hellomessage to be overwritten
stack:	dd 0		; by stack while program is running!

