/*      DOSCONF.C
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <process.h>
#include <dir.h>
#include <direct.h>

#define DATFILE		"INSTALL.DAT"
#define CONFVERSION	"1.15A"
#define COPYRIGHT	"1999"
#define SRC		"A:\\"
#define DIR		"C:\\DOS"

FILE *stream;
void install(const char*);

void exec(char *program,char *argv[])
{
 if(spawnv(P_WAIT,program,argv)==-1)
 {
  printf("Error! Can't execute: %s",program);
  exit(1);
 }
}

int FileExist(char *filename)
{
 FILE *stream;
 if((stream=fopen(filename,"r"))==NULL)
 {
  fclose(stream);
  return 0;
 }
 fclose(stream);
 return 1;
}

int CheckPkg(char *file)
{
 FILE *pkg;
 int i,a;
 char File[255];
 if(!FileExist(file))
  return 0;
 pkg=fopen(file,"rt");
 fscanf(pkg,"%d",&i);
 for(a=0;a<i;a++)
 {
  fscanf(pkg,"%s",File);
  printf("%s ...",File);
  if(!FileExist(File))
  {
   printf("failed!\n");
   fclose(pkg);
   return 0;
  }
  printf("success!\n");
 }
 fclose(pkg);
 return 1;
}

char *FileTo(char *src,char *file,char *ext)
{
 char temp[255];
 strcpy(temp,src);
 strcat(temp,file);
 strcat(temp,ext);
 return temp;
}

int PkgCheck(int sw)
{
 int i,a,c;
 float version;
 char file[255];
 char zipfile[255];
 char pkgfile[255];
 char dfile[255];
 char pkgname[255];
 fscanf(stream,"%d",&i);
 for(a=0;a<i;a++)
 {
  fscanf(stream,"%s",&file);
  strcpy(zipfile,FileTo(SRC,file,".ZIP"));
  strcpy(pkgfile,FileTo(SRC"DAT\\",file,".DAT"));
  strcpy(dfile,FileTo(SRC"LSM\\",file,".LSM"));
  fscanf(stream,"%s",&pkgname);
  fscanf(stream,"%f",&version);
  if(sw)
   install(zipfile);
  else
  {
   printf("\nChecking for %s Version %G... \n",pkgname,version);
   if(!CheckPkg(pkgfile))
    if(!sw)
    {
     printf("failed!\n");
     printf("Do you want to (re)install (%s) (Y/N)?\n",pkgfile);
     c=getch();
     if(toupper(c)=='Y')
      install(zipfile);
    }
   }
  }
  return 0;
}

void ProcessInput(char sw)
{
 switch(sw)
 {
  case 's':
  case 'S':PkgCheck(1);
	   break;
  case 'c':
  case 'C':PkgCheck(0);
	   break;
/*  case '?':HelpMe();
	   break;*/
  default :PkgCheck(0);
	   break;
 }
}

void install(const char *zip)
{
 char full[80];
 char *argv[8]={SRC"unzip.exe","-o","-qq","","-d",DIR,NULL,NULL};
 sprintf(full, "%s",zip);
 argv[3]=full;
 exec(SRC"UNZIP.EXE",argv);
}

void main(int argc, char *argv[])
{
 clrscr();
 if(toupper(argv[1][1])!='S')
 {
  printf("DOSConfig Version "CONFVERSION"\n");
  printf("Copyright "COPYRIGHT" by Enrico Bartky\n\n");
 }
 if(!FileExist(DATFILE))
 {
  printf("Unable to open "DATFILE"\n");
  exit(1);
 }
 stream=fopen(DATFILE,"r");
 ProcessInput(argv[1][1]);
 fclose(stream);
}
