/* sed.h -- types and constants for the stream editor */

/* data area sizes used by both modules */
#define MAXBUF          4096    /* current line buffer size             */
#define MAXAPPENDS      20      /* maximum number of appends            */
#define MAXTAGS         9       /* tagged patterns are \1 to \9         */
#define MAXHOLD         MAXBUF  /* size of the hold space               */
#define GENSIZ          MAXBUF  /* maximum genbuf size                  */
#define MAXWBUF         1024    /* maximum word list buffer             */
#define MAXIOBUF        16384   /* maximum input/output file buffer     */
#define MAXCMDS         200     /* maximum number of compiled commands  */
#define MAXLINES        256     /* max # numeric addresses to compile   */ 

/* constants for compiled-command representation */
#define EQCMD   0x01    /* = -- print current line number               */
#define ACMD    0x02    /* a -- append text after current line          */
#define BCMD    0x03    /* b -- branch to label                         */
#define CCMD    0x04    /* c -- change current line                     */
#define DCMD    0x05    /* d -- delete all of pattern space             */
#define CDCMD   0x06    /* D -- delete first line of pattern space      */
#define GCMD    0x07    /* g -- copy hold space to pattern space        */
#define CGCMD   0x08    /* G -- append hold space to pattern space      */
#define HCMD    0x09    /* h -- copy pattern space to hold space        */
#define CHCMD   0x0A    /* H -- append hold space to pattern space      */
#define ICMD    0x0B    /* i -- insert text before current line         */
#define LCMD    0x0C    /* l -- print pattern space in escaped form     */
#define NCMD    0x0D    /* n -- get next line into pattern space        */
#define CNCMD   0x0E    /* N -- append next line to pattern space       */
#define PCMD    0x0F    /* p -- print pattern space to output           */
#define CPCMD   0x10    /* P -- print first line of pattern space       */
#define QCMD    0x11    /* q -- exit the stream editor                  */
#define RCMD    0x12    /* r -- read in a file after current line       */
#define SCMD    0x13    /* s -- regular-expression substitute           */
#define TCMD    0x14    /* t -- branch on last substitute successful    */
#define CTCMD   0x15    /* T -- branch on last substitute failed        */
#define WCMD    0x16    /* w -- write pattern space to file             */
#define CWCMD   0x17    /* W -- write first line of pattern space       */
#define XCMD    0x18    /* x -- exhange pattern and hold spaces         */
#define YCMD    0x19    /* y -- transliterate text                      */

struct  cmd_t                           /* compiled-command structure   */
{
        char    *addr1;                 /* first address for command    */
        char    *addr2;                 /* second address for command   */
        union
        {
                char            *lhs;   /* s command lhs                */
                struct cmd_t    *link;  /* label link - branch          */
        } u;
        char    command;                /* command code                 */
        char    *rhs;                   /* s command replacement string */
        FILE    *fout;                  /* associated output file       */
        struct                          /*                  descriptor  */
        {
                unsigned allbut  : 1;   /* was negation specified?      */
                unsigned global  : 1;   /* was p postfix specified?     */
                unsigned print   : 2;   /* was g postfix specified?     */
                unsigned inrange : 1;   /* in an address range?         */
                unsigned igcase  : 1;   /* ignore case in selection ?   */
        } flags;
};
typedef struct cmd_t    sedcmd;         /* use sedcmd for declarations  */

#define BAD     ((char *) -1)           /* guaranteed not a string ptr  */


/* address and regular expression compiled-form markers */
#define STAR    1        /* Kleene star to be ORed to other markers     */
#define CCHR    2        /* non-newline character to be matched follows */
#define CDOT    4        /* dot wild-card marker '.'                    */
#define CCL     6        /* character class follows (16 bytes) '[]'     */
#define CNL     8        /* match line start '^'                        */
#define CDOL    10       /* match line end   '$'                        */
#define CBWD    12       /* match word start '\<'                       */
#define CEWD    14       /* match word end   '\>'                       */
#define CBRA    16       /* tagged pattern start marker '\('            */
#define CKET    18       /* tagged pattern end marker '\)'              */
#define CBACK   20       /* backslash-digit pair marker '\d'            */
#define CLNUM   22       /* numeric-address index follows 'ddd'         */
#define CEND    24       /* symbol for end-of-source  '$'               */
#define CEOF    26       /* end-of-field mark                           */
#define CALF    28       /* alphanumeric   \a: one,  \A: one+ remaining */
#define CLET    30       /* letters        \l: one,  \L: one+ remaining */
#define CDIG    32       /* digits         \d: one,  \D: one+ remaining */
#define CHEX    34       /* hexdigit       \h: one,  \H: one+ remaining */
#define CSPS    36       /* space          \s: one,  \S: one+ remaining */

/* sed.h ends here */
