;
;  Stream viewer (hex) SVHEX.COM
;    syntax: type filename | svhex
;
;    Designed and programmed by Lo Hung Che
;    Copyright (C) BAHCL 2006
;
;  Dedicated to FreeDOS www.freedos.org
;    under the terms and license of GNU GPL version 2
;
org 100h
segment .text
            mov     sp,stackbot+512       ; stack size = 512 bytes
            mov     bx,sp
            mov     cx,4
            shr     bx,cl
            inc     bx
            mov     ax,ds
            add     ax,bx
            mov     [stream],ax           ; seg. address for data

            call    HW_Setting
            call    FileType
            cmp     byte [errflag],1
            jz      @0003
            cmp     dword [ssize],0
            jz      @0002                 ; no data at all
            call    Last_Line             ; find last top file
            call    Get_Scancode          ; user interface
            mov     bx,[fhandle]
            or      bx,bx
            jz      @0003                 ; stream file
@0002:
            mov     ax,3E00h              ; close file
            int     21h
@0003:
            call    Clear_Screen
            mov     ah,4Ch
            mov     al,byte [errflag]
            int     21h
;
; Determine input file be stream/regular
FileType
            xor     ax,ax
            mov     si,80h                ; check command tail
            lodsb
            or      al,al
            jz      @0011                 ; piped file
            mov     di,si
            add     di,ax
            xchg    ah,al
            stosb
@0010:
            lodsb
            cmp     al,20h
            jz      @0010
            dec     si
            inc     byte [errflag]        ; set error flag
            mov     ax,3D00h              ; open file
            mov     dx,si
            int     21h
            jc      @0013
            dec     byte [errflag]        ; clear error flag
            mov     [fhandle],ax
@0011:
            mov     ax,4202h              ; find file size
            mov     bx,[fhandle]
            xor     cx,cx
            xor     dx,dx
            int     21h
            mov     [ssize],ax
            mov     [ssize+2],dx

            push    es
            mov     ax,40h
            mov     es,ax
            mov     dx,[es:0F0h]          ; iaca intra application comm. area
            mov     cx,[es:0F2h]          ; msw
            mov     ax,[es:0F4h]          ; lsw
            mov     [quitkey],ax
            xor     ax,ax
            mov     [es:0F0h],ax          ; clear iaca
            mov     [es:0F2h],ax
            mov     [es:0F4h],ax
            pop     es

            cmp     cx,[ssize+2]
            jb      @0012
            cmp     dx,[ssize]
            jb      @0012
            xor     cx,cx
            xor     dx,dx
@0012:
            mov     [initpos0],cx         ; msw
            mov     [initpos1],dx         ; lsw

            mov     ax,cx                 ; try to synchronize offset from PG
            mov     cl,4
            ror     ax,cl
            mov     bx,ax
            and     ax,0FFFh
            mov     [linenum+2],ax
            mov     [initpos1],ax

            mov     ax,dx
            shr     ax,cl
            and     bx,0F000h
            add     ax,bx
            mov     [linenum],ax
            mov     [initpos0],ax
            call    Total_Lines
@0013:
            ret
;
;
Total_Lines
            mov     ax,[ssize]
            and     ax,0Fh
            mov     [eob],al
            mov     di,[ssize]            ; convert file size to total lines
            mov     ax,[ssize+2]
            mov     bx,16                 ; hex 16 bytes here [linewidth]
            mov     cl,4

            cwd
            div     bx
            push    ax
            shl     dx,cl
            rol     di,cl
            mov     ax,di
            and     ax,0Fh
            add     ax,dx

            cwd
            div     bx
            push    ax
            shl     dx,cl
            rol     di,cl
            mov     ax,di
            and     ax,0Fh
            add     ax,dx

            cwd
            div     bx
            push    ax
            shl     dx,cl
            rol     di,cl
            mov     ax,di
            and     ax,0Fh
            add     ax,dx

            cwd
            div     bx
            push    ax
            shl     dx,cl
            rol     di,cl
            mov     ax,di
            and     ax,0Fh
            add     ax,dx

            cwd
            div     bx

            pop     bx
            shl     bx,cl
            add     ax,bx
            pop     bx
            add     cl,4
            shl     bx,cl
            add     ax,bx
            pop     bx
            add     cl,4
            shl     bx,cl
            add     ax,bx

            or      dx,dx
            jz      @0015
            add     ax,1
@0015:
            pushf
            mov     [totlines],ax
            popf
            pop     ax
            jnc     @0016
            inc     ax
@0016:
            mov     [totlines+2],ax

            ret
;
; Display data to screen
Show_Data
            push    bp
            mov     bp,sp
            mov     cx,[bp+4]             ; lines to print
            xor     di,di
            mov     ax,[linenum]
            mov     [templine],ax
            mov     ax,[linenum+2]
            mov     [templine+2],ax
            mov     word [kounter],0
@nextline:
            push    cx
            push    di
            mov     byte [skip],0
            mov     ax,[kounter]
            push    ax
            call    Make_String
            add     word [linenum],1
            jnc     @0040
            inc     word [linenum+2]
@0040:
            inc     word [kounter]
            pop     di
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            mov     cx,[linewidth]        ; line size
            mov     si,buffer
            mov     ah,07                 ; color attribute
@nextbyte:
            lodsb
            stosw
            loop    @nextbyte
            pop     es
            pop     cx
            cmp     byte [skip],0
            je      @0041
            mov     cx,1
@0041:
            loop    @nextline

            mov     ax,[templine]
            mov     [linenum],ax
            mov     ax,[templine+2]
            mov     [linenum+2],ax
            pop     bp
            ret     2
;
;
; format a string for display
Make_String
            push    bp
            mov     bp,sp

            push    ds

            mov     di,buffer+57
            mov     cx,16                 ; get the offset
            xor     dx,dx
            mov     ax,[bp+4]             ; counter
            mul     cx
            mov     si,ax
            add     ax,cx
            sub     ax,[bytesread]
            jbe     @0030
            push    ax                    ; clear the line as EOF
            xor     ax,ax
            mov     cx,65
            mov     di,buffer+11
            rep     stosb
            pop     ax
            mov     al,'-'
            mov     di,buffer+34
            stosb
            mov     cl,byte [eob]
            mov     byte [skip],1
@0030:
            mov     di,buffer+60
            push    cx
            mov     ax,[stream]
            mov     ds,ax
            rep     movsb
            pop     cx
            pop     ds
            mov     si,buffer+60
            mov     di,buffer+11
            mov     bx,HexTable
.loop
            push    cx
            lodsb
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb                               ; translate content
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb
            inc     di
            pop     cx
            loop    .loop

            mov     ax,[linenum+2]              ; line #
            xchg    ah,al
            mov     di,buffer
            mov     bx,HexTable

            mov     dx,ax
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb                               ; translate line #
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            mov     ax,dx
            xchg    ah,al
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            mov     ax,[linenum]                ; line #
            xchg    ah,al
            mov     di,buffer+4
            mov     bx,HexTable

            mov     dx,ax
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb                               ; translate line #
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            mov     ax,dx
            xchg    ah,al
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            pop     bp
            ret     2
;
; get keyboard scancode
Get_Scancode

            mov     ax,[oldline+2]
            cmp     ax,[linenum+2]
            jne     @0020
            mov     ax,[oldline]
            cmp     ax,[linenum]
            je      @0022
@0020:
            call    Clear_Screen
            call    Read_Data

            mov     ax,[totlines]
            cmp     ax,[lineperpage]
            jb      @0021
            mov     ax,[lineperpage]
@0021:
            push    ax
            call    Show_Data
            mov     ax,[linenum+2]
            mov     [oldline+2],ax
            mov     ax,[linenum]
            mov     [oldline],ax

            push    es
            mov     ax,40h
            mov     es,ax
            xor     ax,ax
            mov     [es:0F0h],ax
            pop     es
@0022:
            mov     ah,1
            int     16h
            jz      @0023
            xor     ax,ax
            int     16h
            cmp     ax,[quitkey]
            jne     @0024
            ret
@0023:
            push    es                    ; what mouse event
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:0F0h]
            pop     es
@0024:
            mov     cx,KEYS
            inc     cx
            mov     di,scancode
            mov     si,di
            repne   scasw
            jcxz    @0022
            mov     ax,di
            sub     ax,si
            dec     ax
            dec     ax

            mov     bx,procnames
            add     bx,ax
            call    [bx]

            cmp     ax,1
            jnz     Get_Scancode
            ret
;
; key = escape
K_Esc
            mov     ax,1
            ret
; key = up
K_Up
            mov     ax,1
            call    Check_Up
            xor     ax,ax
            ret
;
; key = down
K_Dn
            mov     ax,1
            call    Check_Down
            xor     ax,ax
            ret
;
; key = page up
K_P_Up
            mov     ax,[lineperpage]
            call    Check_Up
            xor     ax,ax
            ret
;
; key = page down
K_P_Dn
            mov     ax,[lineperpage]
            call    Check_Down
            xor     ax,ax
            ret
;
; key = home
K_Home
            xor     ax,ax
            mov     [linenum],ax
            mov     [linenum+2],ax
            xor     ax,ax
            ret
;
; key = end
K_End
            mov     ax,[lastline]
            mov     [linenum],ax
            mov     ax,[lastline+2]
            mov     [linenum+2],ax
            xor     ax,ax
            ret
;
; key = d  dump hex
K_d
            ret
;
;
;
; key = Alt-1 restore to caller position
K_A1
            mov     ax,[initpos0]
            mov     [linenum],ax
            mov     ax,[initpos1]
            mov     [linenum+2],ax
            xor     ax,ax
            ret
;
;
;
; clear the screen, send cursor home
Clear_Screen
            mov     dx,3DAh
@0090:      in      al,dx              ; syncronize with vertical refresh
            test    al,8
            jnz     @0090
@0091:      in      al,dx
            test    al,8
            jz      @0091

            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            xor     di,di

            mov     ax,0720h
            mov     cx,[lineperpage]
.loop       push    cx
            mov     cx,[linewidth]
            rep     stosw
            pop     cx
            loop    .loop
            pop     es
            mov     ah,2                  ; send cursor home
            xor     bx,bx
            xor     dx,dx
            int     10h
            ret
;
; get data from stream
Read_Data
            mov     bx,16
            mov     ax,[linenum]
            xor     dx,dx
            mul     bx
            push    ax
            push    dx
            mov     ax,[linenum+2]
            xor     dx,dx
            mul     bx
            pop     cx
            add     cx,ax                 ; msw
            pop     ax
            add     dx,ax                 ; lsw
            mov     ax,4200h              ; set file pointer
            mov     bx,[fhandle]
            int     21h

            mov     cx,[pagesize]
            mov     bx,[fhandle]          ; file handle
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            mov     ax,3F00h              ; read file
            xor     dx,dx
            int     21h
            pop     ds
            mov     [bytesread],ax
            ret
;
HW_Setting
            mov     ah,0Fh                ; set up display mode seg. address
            int     10h
            cmp     al,7                  ; mono
            jnz     @0100
            mov     ax,0B000h
            mov     [vid_seg],ax
@0100:
            push    es
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:4Ah]
            mov     [linewidth],ax
            xor     ax,ax
            mov     al,[es:84h]
            inc     ax
            mov     [lineperpage],ax
            pop     es

            mov     ax,[lineperpage]
            mov     bx,16
            mul     bx
            mov     [pagesize],ax
            ret
;
;  Decide the last line
Last_Line
            mov    ax,[totlines]
            cmp    ax,[lineperpage]
            ja     @0110
            mov    dx,[totlines+2]
            or     dx,dx
            jz     @0112
@0110:
            sub    ax,[lineperpage]
            pushf
            mov    [lastline],ax
            popf
            mov    ax,[totlines+2]
            jnc    @0111
            dec    ax
@0111:
            mov    [lastline+2],ax
@0112:
            ret
;
; Check linenum within limit
Check_Down
            cmp     word [totlines+2],0
            ja      @0124
            mov     bx,[totlines]
            cmp     bx,[lineperpage]
            jna     @0121                 ; out of range
@0124:
            mov     dx,[linenum+2]
            add     ax,[linenum]          ; Down, PageDown
            adc     dx,0
@0120:
            cmp     dx,[lastline+2]
            jb      @0122
            ja      @0121
            cmp     ax,[lastline]
            jbe     @0122
            ja      @0121
@0121:
            mov     ax,[lastline]
            mov     dx,[lastline+2]
@0122:
            mov     [linenum],ax
            mov     [linenum+2],dx
            ret
;
; Check linenum within limit
Check_Up
            cmp     word [totlines+2],0
            ja      @0134
            mov     bx,[totlines]
            cmp     bx,[lineperpage]
            jna     @0131                 ; out of range
@0134:
            mov     bx,ax
            mov     dx,[linenum+2]
            mov     ax,[linenum]
            sub     ax,bx
            sbb     dx,0
            jc      @0131
@0130:
            jmp     @0132
@0131:                                    ; BOF
            xor     ax,ax
            xor     dx,dx
@0132:
            mov     [linenum],ax
            mov     [linenum+2],dx
            ret
;
;
segment .data
TABSTOP         EQU     8
TAB             EQU     9
CR              EQU     0Dh
LF              EQU     0Ah
bytesread       dw      0
fhandle         dw      0
vid_seg         dw      0B800h             ; color
lineperpage     dw      0
linewidth       dw      0
initpos0        dw      0
initpos1        dw      0
stream          dw      0                  ; stream segment address
ssize           dw      0                  ; stream size
                dw      0
pagesize        dw      0
HexTable        dw      '0123456789ABCDEF'
oldline         dd      1
linenum         dd      0                  ; line number
totlines        dd      0
lastline        dd      0                  ; last top line
templine        dd      0
kounter         dw      0
procnames       dw      K_Esc,K_Up,K_Dn,K_P_Up,K_P_Dn,K_Home,K_End,K_A1,K_d
scancode        dw      011Bh,4800h,5000h,4900h,5100h,4700h,4F00h,7800h,2064h
KEYS            EQU     ($-scancode)/2
quitkey         dw      0
errflag         db      0
eob             db      0
skip            db      0
buffer          db      '000000000  00 00 00 00 00 00 00 00-'
          times 132-$+buffer db  20h
stackbot
;               db      'Designed and programmed by Lo Hung Che',0
;               db      'Copyright (C) BAHCL 2006',0
