/*
  pg.c    1.12

  (c) 1995-1998 Bill Weinman, wew@bearnet.com

  Generic Screen Pager for FreeDOS

  This program was coded particularly for use with my FreeDOS help
  system.  I am making it available as a module for general use because
  it's generally useful.  It is not intended to be the pager-to-beat-
  all-pagers because I don't need that.  If you do, you can either
  suggest enhancements--and if I think they're really kewl and feel
  like coding them I will--or you can code them yourself and submit
  them to me; but please, if you want me to continue to support this
  code then please don't enhance the code without letting me know.
                      --BearHeart, Phoenix, AZ
                        wew@bearnet.com

  Maintainer: BAHCL


  Programming Environment:
    Please read pg.man section "INSTALL PG"


  Legal Stuff

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <process.h>
#include "pg.h"

#define setattr(attr) (curatt = attr)

/* Globals */

char *stat[] =
{
  "     ",
  "<top>",
  "<end>"
};

char *plugin[] =
{
   "SVHEX.COM",
   "SVTXT.COM"
};

struct {                                        /* file list */
  char filename[12];                            /* file name */
  unsigned long start;                          /* display line */
  unsigned long offset;                         /* display offset */
} *filelist, *fl;

char pgman[65];                                 /* path for PG.MAN */
char searchstr[20];                             /* search string */
char buffer[128];                               /* scratch buffer */
int  groupid;                                   /* active group id */
int  lpg = LINEADDRS;                           /* Lines per group */
unsigned long lineaddr[LINEADDRS];              /* offset of a line in file */
unsigned long groups[GROUPS];                   /* offset of the first line in the group */
unsigned long bookmark[5];                      /* BAHCL add 5 bookmarks */
unsigned long searchline;                       /* search line number */
unsigned long numlines;                         /* num of lines in the file */
int Color = false;                              /* color flag */
int mouse = 0;                                  /* mouse driver ok? */
unsigned int  VideoRegen;                       /* video regen pointer */
unsigned int  RegenSize;                        /* in words  */
unsigned char DispMode;                         /* display adapter mode */
unsigned char DispRows;                         /* display rows (from BIOS) */
unsigned int  DispCols;                         /* display cols (from BIOS) */
unsigned char curatt;                           /* current attribute */
unsigned char attr_status, attr_lo_status, attr_text;
char linebuf[MAXSIZELINE+1];                    /* buffer for reading lines */
char *cmd;                                      /* path of COMMAND.COM */
char *infilename;                               /* input file name */
FILE *infile;                                   /* input file pointer */
FILE *pgsav=NULL;                               /* save file */
int  tabstops = TABSTOPS;                       /* should be run-time switch */
int  filenum, maxfile;                          /* infile number, max. files */
int  sense;                                     /* case sensitivity flag */
unsigned long cursor = 0;                       /* set cursor to where search ok */
unsigned long showline;                         /* show top line */
unsigned long offset;                           /* infile offset */
unsigned char bit7 = 0xFF;                      /* all bits on */
extern unsigned _heaplen = MAX_FILE * 20 + (LINEADDRS + GROUPS) * 4; /* memory saver */

/* Local Functions */
void InitVideo(void);                           /* call this first */
int  getline(long);                             /* get a line from infile */
void exptabs(void);                             /* expand tabstop */
void display(long, int);                        /* display file content */
int  pagefile(long);                            /* user interface */
void save_screen(long, long);                   /* save screen to disk */
void mvaddnstr(int,int,int,char *);             /* print at only n char from str */
void usage(void);                               /* tell 'em how ta use it */
void errorexit(int, char *);                    /* error!! bail out! */
void headline(long);                            /* program head line */
void clearscreen(void);                         /* clear a screen */
void clearline(int, char);                      /* clear a line */
char *strfind(char *, char *);                  /* find substring */
char *strrfind(char *, char *);                 /* find substr backward */
void line2offset(long);                         /* convert line # to offset */
void load_grp_li_addr(int);                     /* reload the line addresses of a group */
int  accept(char *);                            /* accept files not blacklisted */
void scroll_up(int,int,int,int,int);            /* scroll up N lines */

/* Global Assembly language functions */
extern check_mouse(void);                       /* Setup mouse user routine */
extern reset_mouse(void);                       /* Reset mouse */
extern mvaddch(int, int, int);                  /* position,char,attr */
extern getbiosinfo(void);                       /* get BIOS information */
extern getstr(char *);                          /* Get a string */
extern kbget(void);                             /* get keyboard scancode */
extern mouseorkey(void);                        /* get mouse or keyboard scancode */
extern move(int, int);                          /* move cursor to */
extern iaca(long,int);                          /* intra app. comm. area */
extern read_infile(void);                       /* asm routine to read infile */

int
main(int argc, char **argv)
{
  int pathlen, i;
  struct ffblk ffblk;

  strcpy(pgman,argv[0]);
  cmd =  strchr(pgman,'.');                         /* to find */
  strcpy(cmd,".MAN");                               /* PG.MAN */

  infilename = buffer+20;
  fnsplit(argv[1], buffer+20, buffer+23, buffer+90, buffer+100);
  InitVideo();                                      /* Init & get screen info */
  if (argc == 1)                                    /* no file name */
    {
      iaca(0L,0);
      i = execlp(plugin[1], plugin[1],  NULL);      /* use svtxt.com */
    }
  else if (strcmp(argv[1], "/?") == 0)              /* basic help */
    {
      usage();
    }
  else                                              /* get ready */
    {
      cmd = getenv("COMSPEC");                      /* find COMMAND.COM */
      filelist = malloc(MAX_FILE*20);               /* allocate mem. for */
                                                    /* max. 256 filenames */
      fl = filelist;
      maxfile  = 0;
      filenum = findfirst(argv[1],&ffblk,0);        /* find # of files */
      while((!filenum) & (maxfile < MAX_FILE))
        {
          if (accept(ffblk.ff_name))                /* checks file extension */
            {
              strncpy(fl->filename, ffblk.ff_name, 12);
              fl->start = 1L;
              fl->offset = 0L;                      /* each file starts line 1 */
              ++fl;                                 /* offset 0 */
              ++maxfile;
            }
          filenum = findnext(&ffblk);
        }
      free(filelist);
      if (maxfile == 0)                             /* No file */
        {
          errorexit(1, strcat("pg: cannot open file ", argv[1]));
        }
    }

/* check mouse here */
   check_mouse();

/*  adjust the actual memory required */
  filelist = malloc(maxfile * sizeof(*filelist));
  filenum = 1;
  strcat(infilename, infilename+3);
  pathlen = strlen(infilename);
  while (filenum <= maxfile)                        /* process individual file */
    {
      fl = filelist+filenum-1;
      strncpy(infilename + pathlen, fl->filename, 12);

      infilename[pathlen + 12] = '\0';
      groupid = 0;
      for (i = 0; i < 5; i++)
        {
          bookmark[i] = 0L;
        }

      numlines = 0;
      read_infile();                                /* assembly routines */

      infile = fopen(infilename, "rb");
      clearscreen();
      showline = fl->start;
      offset = fl->offset;

      display(showline, 0);                               /* instant display file content */
      filenum = pagefile(showline);                 /* page thru the file */

      fl->start = showline;
      fl->offset = offset;
      setattr(attr_text);                           /* reset video attribute */
      fclose(infile);
    }
  free(filelist);
  if (mouse)
    {
      reset_mouse();
    }
  clearscreen();
  move(0,0);
  return(0);
}


/*
   getline() -  Find a line of text from the line buffer. Returns
   pointer to linebuf or zero if cannot find
*/
int
getline(long linenum)
{
  linebuf[0] = NULL;
  if (linenum > numlines)
    {
      return 0;                                 /* error */
    }
  else
    {
      line2offset(linenum);
      fseek(infile, offset, SEEK_SET);
      fgets(linebuf, MAXSIZELINE+1, infile);
      return 1;
    }
}

/*
   exptabs() -  Expand tabs in the line buffer.
   (Added 21 aug 98, wew)
   BAHCL : handles LF,CR as Turbo C 'gets' does not remove them;
           also SPACE => space
*/
void
exptabs(void)
{
  register i;
  register o;
  char out[MAXSIZELINE+1];
  char *in;
  char space;

  in = linebuf;
  memset(out, 0, MAXSIZELINE+1);
  space = '\x20';
  for(i = o = 0; (o < MAXSIZELINE) && in[i]; i++, o++)
    {
      switch(in[i])
        {
          case TAB:
            out[o] = space;
            while((o+1) % tabstops && (o < (MAXSIZELINE)))
              {
                out[++o] = space;
              }
            break;
          case '\xD':                               /* replace linefeed */
            out[o] = space;
            break;
          case '\xA':                               /* replace return */
            out[o] = NULL;
            break;
          case '\x8':                               /* backspace */
            if (o) o-=2;
            break;
          default:
            out[o] = in[i] & bit7;
            break;
        }
    }
  memcpy(linebuf, out, MAXSIZELINE+1);
}

/* display lines to screen */
void display(long topline, int pancolumn)
{

  int lineno;                   /* current line number */
  int botline;                  /* bottom screen line */
  int screenline;               /* current screenline */
  int pageoffset;               /* offset into page */
  long templine;
  char *str;

  /* Initialize variables */
  botline    = DispRows - 2;
  templine   = topline;
  pageoffset = 0;
  lineno     = 0;

  if (botline > numlines) botline = numlines;

  headline(topline);                        /* show file information */
  setattr(attr_status);
  while(lineno < botline)                   /* display loop */
    {
      screenline = ++lineno;              /* where are we on the screen? */
      line2offset(topline);
      fseek(infile, offset, SEEK_SET);
      ++topline;
      str = fgets(linebuf, MAXSIZELINE+1, infile);
      if(str)
        {
          exptabs();                         /* expand the tabs (21 aug 98 wew) */
          clearline(screenline, attr_text);
          setattr(attr_text);
          mvaddnstr(screenline, 0, DispCols, linebuf+pageoffset+pancolumn);
        }
    } /* while */
  setattr(attr_status);
  if (pancolumn > 0)
    {
      itoa(pancolumn, buffer,10);
      mvaddnstr(0, 56, 4, "+   ");
      mvaddnstr(0, 57, 3, buffer);
    }
  topline = templine;
  if (cursor)
    {
      move((int)(cursor-topline+1),0);       /* show cursor */
    }
  else
    {
      move(DispRows,0);                      /* hide cursor */
    }
  cursor = 0;
  line2offset(topline);
}

/* user interface here */
int
pagefile(long line)
{
  long topline;                 /* top screen line */
  int pagesize;                 /* vert size of display area */
  int quit;                     /* (jh) flag, for the exit condition */
  int pancolumn;                /* pan columns */
  char sdf;                     /* search direction flag */
  int  scanascii;
  char asciicode;

  /* Initialize variables */
  pancolumn  = 0;
  searchline = 0;
  topline    = line;
  pagesize   = DispRows - 2;
  quit       = 0;               /* (jh) */
  sdf        = 'F';             /* assume forward */

  headline(topline);                        /* show file information */
  clearline(DispRows - 1, attr_status);

  while (!quit)
    {
/*    scanascii = kbget(); */
      scanascii = mouseorkey();
      switch(scanascii)
        {
          case DOSSHELL:
            clearscreen();
            spawnl(P_WAIT, cmd, "COMMAND.COM", NULL);
            clearline((int) DispRows - 1, attr_status);
            break;
          case PG_UP:
            topline -= pagesize;
            break;
          case SPACE:                   /* (jh) */
          case PG_DN:                   /* scroll down by one screen */
            topline += pagesize;
            break;
          case KEY_HOME:
            topline = 1;
            break;
          case KEY_END:
            topline = numlines - pagesize + 1;
            break;
          case KEY_UP:
            --topline;
            break;
          case RETURN:                          /* scroll down one line only */
          case KEY_DN:
            ++topline;
            break;
          case KEY_LFILE:                           /* Last file */
            if (filenum > 1)
              {
                --filenum;
                quit = 1;
              }
            break;
          case KEY_NFILE:                           /* Next file */
            if (filenum < maxfile)
              {
                ++filenum;
                quit = 1;
              }
            break;
          case ESC:                                 /* Esc=Quit */
            quit = 1;
            filenum = maxfile + 1;
            break;
          case JUMPTO:                              /* Backspace=Jump to line */
            clearline((int) DispRows - 1, attr_status);
            mvaddnstr((int) DispRows - 1, 0, 8, "Jump to:");
            move(DispRows-1,9);
            buffer[0]=19;
            getstr(buffer);
            if (buffer[1])
              {
                topline = atol(buffer + 2);
                cursor = topline;
              }
            clearline((int) DispRows - 1, attr_status);
            break;
          case JBM_A1:                              /* Back to bookmark #1 */
            topline = bookmark[0];
            break;
          case JBM_A2:
            topline = bookmark[1];
            break;
          case JBM_A3:
            topline = bookmark[2];
            break;
          case JBM_A4:
            topline = bookmark[3];
            break;
          case JBM_A5:
            topline = bookmark[4];
            break;
          case KEY_F1:                                /* On-line help */
            iaca(0L,scanascii);
            spawnlp(P_WAIT, plugin[1], plugin[1], pgman, NULL);
            clearline((int) DispRows - 1, attr_status);
            break;
          case KEY_SF2:                               /* cont. search backward (S) */
          case KEY_F2:                                /* cont. search backward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        "); /* clear result area */
            if (searchstr[1])
            {
              if (sdf == 'F')
                {
                  searchline -= 2;
                }
              sense = (scanascii == KEY_SF2 ? 1 : 0);
              if (strrfind(linebuf, searchstr+2))
                {
                  topline = searchline+1;
                  ltoa(topline, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  cursor = topline;
                }
              sdf = 'R';                            /* reverse search */
            }
            break;
          case KEY_SF3:                             /* cont. search forward (S) */
          case KEY_F3:                              /* cont. search forward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        ");
            if (searchstr[1])
            {
              if (sdf == 'R')
                {
                  searchline += 2;
                }
              sense = (scanascii == KEY_SF3 ? 1 : 0);
              if (strfind(linebuf, searchstr+2))
                {
                  topline = searchline-1;
                  ltoa(topline,buffer,10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  cursor = topline;
                }
              sdf = 'F';                            /* forward search */
            }
            break;
          case KEY_F4:                              /* Search mode */
            clearline((int) DispRows-1, attr_status);
            mvaddnstr((int) DispRows-1, 0, 7, "Search:");
            move(DispRows-1,8);
            searchstr[0]=19;
            getstr(searchstr);
            strcpy(buffer+105,searchstr+2);
            strlwr(buffer+105);
            if (searchstr[1])
            {
              searchline = topline;
              sense = 0;
              if (strfind(linebuf, searchstr+2))
                {
                  topline = searchline-1;
                  ltoa(topline, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  cursor = topline;
                }
              sdf = 'F';
            }
            break;
          case KEY_F5:                              /* save screen to file */
            save_screen(topline, topline + pagesize);
            break;
          case KEY_LT:                              /* Left key */
            pancolumn -= 30;                        /* pan left */
            if (pancolumn < 0)
              {
                pancolumn = 0;
              }
            break;
          case KEY_RT:                              /* Right key */
            pancolumn += 30;                        /* pan right */
            if (pancolumn > PANLIMIT)
              {
                pancolumn = PANLIMIT;
              }
            break;
          default:
            asciicode = scanascii & 0xFF;
            switch (asciicode)
              {
                 case SBM_1:                        /* set Bookmark #1 */
                   bookmark[0] = topline;
                   break;
                 case SBM_2:
                   bookmark[1] = topline;
                   break;
                 case SBM_3:
                   bookmark[2] = topline;
                   break;
                 case SBM_4:
                   bookmark[3] = topline;
                   break;
                 case SBM_5:
                   bookmark[4] = topline;
                   break;
                 case 'b':
                 case BITON:
                   bit7 = bit7 ^ 0xFF;
                   bit7 = bit7 | 0x7F;
                   break;
                 case ADDFILE:
                   break;
                 case 'h':
                 case HEX:     /* Display in HEX. format */
                   iaca(offset,scanascii);
                   spawnlp(P_WAIT, plugin[0], plugin[0], buffer+20, NULL);
                   clearline((int) DispRows - 1, attr_status);
                   break;
                 case 'w':
                 case WRAP:    /* Wrap long line */
                   iaca(offset,scanascii);
                   spawnlp(P_WAIT, plugin[1], plugin[1], buffer+20, NULL);
                   clearline((int) DispRows - 1, attr_status);
                   break;
                 case 'q':
                 case QUIT:
                   quit = 1;
                   filenum = maxfile + 1;
                   break;
              }
            break;
         } /* switch */

       if (topline < 1)                         /* alert top of file? */
         {
           topline = 1;
         }
       else if (topline > (numlines - pagesize))    /* alert bot of file? */
         {
           topline = numlines - pagesize +1;
         }
       if (topline < 1) topline = 1;           /* alert top of file? */
       if (numlines < pagesize) topline = 1;
       if (quit != 1)
         {
           line2offset(topline);
           display(topline, pancolumn);
         }
    }   /* !Quit */
    showline = topline;
    return filenum;
}

/* save screen to a save file */
void
save_screen(long saveline, long toline)
{
  long seekpos, pos1, pos2;
  char *savefile = "C:\\PG.SAV";

  clearline((int) DispRows-1, attr_status);
  mvaddnstr((int) DispRows-1, 0, 10, "Save to...");
  move(DispRows-1,10);                          /* move cursor */
  if (pgsav == NULL)                            /* if not open yet */
    {
      buffer[0]=2;                              /* get the drive letter only */
      getstr(buffer);
      savefile[0] = buffer[2];
    }

  if ((pgsav = fopen(savefile, "ab")) == NULL)  /* append data */
    {
      return;
    }
  strcpy(linebuf, "!!! Copy from ");            /* indentify copy info */
  strcat(linebuf, infilename);
  strcat(linebuf, " line ");
  strcat(linebuf, ltoa(saveline, buffer,10));
  strcat(linebuf, " !!! ");
  fwrite(linebuf, strlen(linebuf), 1, pgsav);

  if (toline > numlines)
    toline = numlines+1;
  line2offset(saveline);
  fseek(infile, offset, SEEK_SET);
  pos1 = ftell(infile);
  while (--toline - (saveline-1))
    {
      fgets(linebuf, MAXSIZELINE+1, infile);
      pos2 = ftell(infile);
      fwrite(linebuf, pos2 - pos1, 1, pgsav);
      pos1 = pos2;
    }
  fclose(pgsav);
  mvaddnstr((int) DispRows-1, 9, 10, savefile);
}

/* Get display adaptor info. and initialize */
void
InitVideo(void)
{
  getbiosinfo();
  RegenSize = DispRows * DispCols;     /* for use in asm functions */
  VideoRegen = (DispMode == MONO ? 0xb000 : 0xb800);
  Color = (DispMode == MONO ? false : true);

/* BAHCL moved from main() */
#ifdef USE_COLOR_MODE                   /* (jh) */
  if(Color)
    {
      attr_status    = CO_STATUS;
      attr_lo_status = CO_LO_STATUS;
      attr_text      = CO_TEXT;
    }
  else
    {
      attr_status    = MO_STATUS;
      attr_lo_status = MO_LO_STATUS;
      attr_text      = MO_TEXT;
    }
#else
  attr_status    = ATTR (BLACK, WHITE);                 /* (jh) */
  attr_lo_status = ATTR (BLACK, WHITE);                 /* (jh) */
  attr_text      = ATTR (WHITE, BLACK);                 /* (jh) */
#endif /* USE_COLOR_MODE */

  setattr(attr_text);

}

/* BAHCL: useful as the one in Linux ncurses */
void
mvaddnstr(int prow, int pcol, int n, char *s)
{
  int i,j;
  i = 0;
  j = (prow * DispCols + pcol) * 2;
  while (s[i] && (i < n))
    {
      mvaddch(j, s[i++], curatt);
      j += 2;
    }
}

/* error exit */
void
errorexit(int pcode, char *args)
{
    mvaddnstr((int) DispRows-1,0,80,args);
    exit(pcode);
}

/* program usage */
void
usage(void)
{
  /* (jh) I moved all the usage text here so that the text wasn't
     separated from the usage() function */

  /* (jh) I moved the VERSION text here, since it is not used
     anywhere else. */

  /* (jh) Most DOS programs just show the name and usage, but you can
     build with the GNU 'copying' statement anyway by using
     -DSHOW_GNU_COPYING */
  int i;
  i = 0;
  clearscreen();   /* BAHCL */
  mvaddnstr(0,0,80,"PG, version 1.0 (c) 1995-1998 Bill Weinman, wew@bearnet.com");
  mvaddnstr(1,0,80,"PG, version 1.12 2004 Maintained by BAHCL");

#ifdef SHOW_GNU_COPYING
  mvaddnstr(2,0,80,"Distributed under the terms of the GNU General Public License.");
  mvaddnstr(3,0,80,"See the file COPYING for details.");
  i = 2;
#endif

  mvaddnstr(3+i,0,80,"usage:  PG [/?] [filename]");
  mvaddnstr(4+i,0,80,"  /?       - display this help screen.");
  mvaddnstr(5+i,0,80,"  filename - page through filename on the PC screen");
  mvaddnstr(6+i,0,80,"             filename may be in wildcard format");
  mvaddnstr(7+i,0,80,"             if filename is omitted, assume piping from <stdin>");
  mvaddnstr(8+i,0,80,"  Read pg.man for details.");

  exit(0);
}

/* Clear the entire screen */
void
clearscreen()
{
  scroll_up((int) 0, 0, DispCols, (int) DispRows, (int) DispRows);
}

/* Just a blank line with status attribute */
void
clearline(int lin, char attr)
{
  int i;

  setattr(attr);
  for (i = 0; i < DispCols; i++)
    {
      mvaddnstr(lin, i, 1, " ");
    }
}

/* PG -- headline of file information */
void
headline(long line)
{
  int pgstat;

  clearline(0, attr_status);
  mvaddnstr(0, 1, 6, "PG -- ");
  mvaddnstr(0, 7, 40, infilename);
  pgstat = STATOK;

  if (line <= 1)
    {
      pgstat = STATTOP;
    }

  if ((line + DispRows - 2) > numlines)
    {
      pgstat = STATBOT;
    }

  mvaddnstr(0, 50, 5, stat[pgstat]);
  ltoa(numlines, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-10, 6, buffer);      /* total lines */
  ltoa(line, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-1, 6, buffer);       /* top line */
}

/* find sub-string in forward manner */
char *strfind(char *str1, char *str2)
{
  char *ptr, *cis;

  cis = buffer+105;                 /* case insensitive search */
  if (searchline > numlines)
    {
      searchline = 1;
    }
  do
  {
    getline(searchline++);
    if (sense)                      /* case sensitive search */
      {
        ptr = strstr(str1, str2);
      }
    else
      {
        /* convert to lower case before the search */
        ptr = strstr(strlwr(str1), cis);
      }
  } while((searchline <= numlines) && (ptr == NULL));
  return ptr;
}

/* find sub-string in backward manner */
char *strrfind(char *str1, char *str2)
{
  char *ptr, *cis;

  cis = buffer+105;                 /* case insensitive search */
  if (searchline > numlines)
    {
      searchline = numlines;
    }
  do
  {
    getline(searchline--);
    if (sense)                      /* case sensitive search */
      {
        ptr = strstr(str1, str2);
      }
    else
      {
        /* convert to lower case before the search */
        ptr = strstr(strlwr(str1), cis);
      }
  } while((searchline <= numlines) && (ptr == NULL));
  return ptr;
}

/* convert from line number to line address and the group  */
void line2offset(long line)
{
  int linenum, group;

  --line;                                           /* adjust for zero based */
  linenum = line % LINEADDRS;
  group   = line / GROUPS;
  if (groupid != group)                             /* not in current group */
    {
      load_grp_li_addr(group);
      groupid = group;
    }
  offset = lineaddr[linenum];
}

/* load line addresses within a group */
void load_grp_li_addr(int group)
{                                       /* this routine may be wrong if */
  int  i;                               /* its length is > 256 bytes */
  char *str;

  offset = groups[group];
  fseek(infile, offset, SEEK_SET);
  for (i = 0; i < LINEADDRS; i++)
  {
    lineaddr[i] = offset;
    str = fgets(linebuf, MAXSIZELINE+1, infile);
    if (str == NULL) break;                       /* end of file */
    offset = ftell(infile);
  }
}

/* only accept files with file extension not binary format */
int accept(char *src)
{
  char *blacklist="BINCOMDLLDRVEXEOBJVXDZIP";    /* file extensions */
  char *ptr;
  int i, j, k;

  k = 1;                                            /* accept */
  ptr = strchr(src,'.');
  if (ptr)
  {
    for (i=0, j=0; j < (strlen(blacklist) / 3); j++)
      {
        if (strncmp(blacklist + i, ptr + 1, 3) == 0)
          {
            k = 0;                                  /* reject */
            break;
          }
        i += 3;
      }
  }
  return k;
}
