/*
  pg.c    1.04

  (c) 1995-1998 Bill Weinman, wew@bearnet.com

  Generic Screen Pager for FreeDOS

  This program was coded particularly for use with my FreeDOS help
  system.  I am making it available as a module for general use because
  it's generally useful.  It is not intended to be the pager-to-beat-
  all-pagers because I don't need that.  If you do, you can either 
  suggest enhancements--and if I think they're really kewl and feel
  like coding them I will--or you can code them yourself and submit
  them to me; but please, if you want me to continue to support this
  code then please don't enhance the code without letting me know.
                      --BearHeart, Phoenix, AZ
                        wew@bearnet.com

  Maintainer: BAHCL   freedos_pg@yahoo.com.hk


  Programming Environment:
    Please read pg.man section "INSTALL PG"


  Legal Stuff
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include "pg.h"

#define setattr(attr) (curatt = attr)

/* Globals */

char *stat[] =
{ 
  "     ", 
  "<top>", 
  "<end>" 
};

char searchstr[20];                             /* search string */
char buffer[20];                                /* scratch buffer */
unsigned long bookmark[5];                      /* BAHCL add 5 bookmarks */
long searchline;                                /* search line number */
long saveline;                                  /* copy from line */
long toline;                                    /* copy to line */
long showline;
unsigned long offset;                           /* infile offset */
unsigned long numlines;                         /* num of lines in the file */
int Color = false;                              /* color flag */
unsigned int  VideoRegen;                       /* video regen pointer */
unsigned int  RegenSize;                        /* in words  */
unsigned char DispMode;                         /* display adapter mode */
unsigned char DispRows;                         /* display rows (from BIOS) */
unsigned int  DispCols;                         /* display cols (from BIOS) */
unsigned char curatt;                           /* current attribute */
unsigned char attr_status, attr_lo_status, attr_text;
char linebuf[MAXSIZELINE];                      /* buffer for reading lines */
int  tabstops = TABSTOPS;                       /* should be run-time switch */
int  filenum, maxfile;                          /* infile number, max. files */
char *infilename;                               /* input file name */
FILE *infile;                                   /* input file pointer */
FILE *pgtmp;                                    /* temp file */
FILE *pgsav;                                    /* save file */

/* Local Functions */
void InitVideo(void);                           /* call this first */
unsigned long readlines(FILE *);                /* read in the line addresses */
int  getline(long);                             /* get a line from infile */
void exptabs(void);                             /* expand tabstop */
int  pagefile(long);                            /* user interface */
void save_screen(long, long);
void mvaddnstr(int,int,int,char *);             /* print at only n char from str */
void usage(void);                               /* tell 'em how ta use it */
void errorexit(int, char *);                    /* error!! bail out! */
void headline(long);                            /* program head line */
void clearline(int, char);                      /* clear a line */
char *strfind(char *, char *);                  /* find substring */
char *strrfind(char *, char *);                 /* find substr backward */

/* Global Assembler language functions */
extern scroll_down(int, int, int, int, int);    /* x1,y1,x2,y2,lines */
extern scroll_up(int, int, int, int, int);      /* x1,y1,x2,y2,lines */
extern mvaddch(int, int, int, int);             /* row,col,vidchar,attr */
extern getbiosinfo(void);                       /* get BIOS information */
extern getstr(char *);                          /* Get a string */
extern kbget(void);                             /* get keyboard scancode */
extern setup_help(void);                        /* setup help information */
extern on_line_help(void);                      /* On line help */

int
main(int argc, char ** argv)
{
  int pathlen, filepos;
  char filepath[128];
  struct ffblk ffblk;

  fnsplit(argv[1], filepath, filepath+3, filepath+60, filepath+70);
  InitVideo();                                  /* Init & get screen info */
  if (argc == 1)                                /* no file name */
    {
      usage();                                  /* show usage */
    }
  else if (strcmp(argv[1], "/?") == 0)          /* basic help */
    {
      usage();
    }
  else                                          /* get ready */
    {
      if ((pgtmp = fopen("C:\\TEMP\\PG.TMP","wb")) == NULL)
        {
          errorexit(1, "pg: cannot create C:\\TEMP\\PG.TMP");
        }
      pgsav = fopen("C:\\TEMP\\PG.SAV", "w");
      fclose(pgsav);
      showline = 1;
      maxfile = 0;
      filenum = findfirst(argv[1],&ffblk,0);       /* number of files */
      while(!filenum)
        {
          ++maxfile;
          strncpy(linebuf, ffblk.ff_name, 12);
          memcpy(linebuf+12, &showline, sizeof(long));
          fwrite(&linebuf, 16, 1, pgtmp);
          filenum = findnext(&ffblk);
        }
      if (maxfile == 0)                             /* No file */
        {
          errorexit(1, strcat("pg: cannot open file ", argv[1]));
        }
      pgtmp = freopen("C:\\TEMP\\PG.TMP", "r+b",pgtmp);    /* reopen for read */
    }

  setup_help();                               /* Setup on-line help */
  filenum = 1;
  strcat(filepath, filepath+3);
  pathlen = strlen(filepath);
  while (filenum)                             /* process individual file */
    {
      filepos = (filenum - 1) * 16;
      fseek(pgtmp, filepos, SEEK_SET);
      fread(&filepath[pathlen], 12, 1, pgtmp);
      filepath[pathlen+12] = '\0';
      fread(&showline, sizeof(long), 1, pgtmp);
      infile = fopen(filepath, "rb");
      infilename = filepath;
      numlines = readlines(infile);           /* read all the line addresses */
      rewind(pgtmp);
      saveline = 0;

      filenum = pagefile(showline);           /* page thru the file */

      if (filenum < 1)  filenum = 1;
      if (filenum > maxfile)  filenum = 0;
      scroll_up(0, 0, DispCols-1, DispRows, DispRows);  /* clear screen */
      setattr(attr_text);                               /* reset video attribute */

      fseek(pgtmp, filepos + 12, SEEK_SET);             /* update topline last file */
      fwrite(&showline, sizeof(long), 1, pgtmp);
      fclose(infile);
    }
  fclose(pgtmp);

  remove("C:\\TEMP\\PG.TMP");

  clrscr();
  return(0);
}

/*
   readlines() - Read the whole file and extract the address of the
   beginnng of each line.
   BAHCL : These addresses are stored in a temporary file.
*/
unsigned long
readlines(FILE *infile)
{
  unsigned long linenum;
  int rc;

  rc = 1;
  clrscr();
  mvaddnstr(0, 1, 30, "Reading file . . . ");
  fseek(pgtmp, (long) maxfile * 16, SEEK_SET);
  for (linenum = 1; rc; linenum++)
    {
      offset = ftell(infile);
      fwrite(&offset, sizeof(long), 1, pgtmp);
      (char *) rc =  fgets(linebuf, MAXSIZELINE - 1, infile);
    }
  return (linenum - 1);
}

/*
   getline() -  Find a line of text from the line buffer. Returns
   pointer to linebuf or zero if cannot find
*/
int
getline(long linenum)
{
  unsigned long tmpoffset;
  linebuf[0] = NULL;
  if (linenum >= numlines)
    {
      return 0;                                 /* error */
    }
  else
    {
      tmpoffset = (linenum - 1) * sizeof(long);
      fseek(pgtmp, tmpoffset + maxfile * 16, SEEK_SET);
      fread(&offset, sizeof(long), 1, pgtmp);
      fseek(infile, offset, SEEK_SET);
      fgets(linebuf, MAXSIZELINE - 1, infile);
      return 1;
    }
}

/*
   exptabs() -  Expand tabs in the line buffer.
   (Added 21 aug 98, wew)
   BAHCL : handles LF,CR as Turbo C 'gets' does not remove them;
           also SPACE => space
*/
void
exptabs(void)
{
  register i;
  register o;
  char out[MAXSIZELINE];
  char *in;
  char space;

  in = linebuf;
  memset(out, 0, MAXSIZELINE);
  space = '\x20';
  for(i = o = 0; o < (MAXSIZELINE - 1) && in[i]; i++, o++)
    { 
      switch(in[i])
        {
          case TAB:
            out[o] = space;
            while((o+1) % tabstops && (o < (MAXSIZELINE - 1)))
              {
                out[++o] = space;
              }
            break;
          case '\xD':                               /* replace linefeed */
            out[o] = space;
            break;
          case '\xA':                               /* replace return */
            out[o] = NULL;
            break;
          default:
            out[o] = in[i];
            break;
        }
    }
  memcpy(linebuf, out, MAXSIZELINE);
}

/* user interface here */
int
pagefile(long fromline)
{
  int redraw;

  long lineno;                  /* current line number */
  long topline;                 /* top screen line */

  int botline;                  /* bottom screen line */
  int screenline;               /* current screenline */
  int pagesize;                 /* vert size of display area */
  int pageoffset;               /* offset into page */
  int kc;                       /* current keypress */
  int rc;                       /* return code */
  int pgstat;                   /* current status for display */
  int quit;                     /* (jh) flag, for the exit condition */
  int pancolumn;                /* pan columns  max 50 */

  /* Initialize variables */
  redraw     = true;
  pancolumn  = 0;
  searchline = 0;
  kc         = 0;
  topline    = fromline;
  botline    = DispRows - 2;
  pagesize   = DispRows - 2;
  pageoffset = 0;
  rc         = -1;
  pgstat     = STATOK;
  quit       = 0;               /* (jh) */
  if (numlines < (pagesize))
    {
      pagesize = numlines-1;
    }
  clearline(botline+1, attr_status);

  while (!quit)
    {
      setattr(attr_status);
      if (topline < 1)          /* alert top of file? */
        {
          topline = 1;
          pgstat = STATTOP;
        }
      else if (topline > (numlines - pagesize)) /* alert bot of file? */
        {
          topline = numlines - pagesize;
          pgstat = STATBOT;
        }

      headline(topline);                        /* show file information */

      lineno = topline;
      while((lineno - topline) < botline)       /* display loop */
        {
          screenline = lineno - topline + 1;    /* where are we on the screen? */
          rc = getline(lineno++);               /* read the next line from input */
          exptabs();                            /* expand the tabs (21 aug 98 wew) */
          if(rc)
            {
              if(redraw)                        /* display it */
                {
                  clearline(screenline, attr_text);
                  setattr(attr_text);
                  mvaddnstr(screenline, pageoffset, DispCols, linebuf+pancolumn);
                  if(kc == KEY_UP)
                    redraw = false;
                }
            }
          else   /* past end of file, blank rest of screen */
            {
              pgstat = STATBOT;
            }
        } /* while */

      if (!redraw && rc && (kc == KEY_DN))      /* we scrolled up, */
        {                                       /* so need to disp last line */
          setattr(attr_text);
          mvaddnstr(botline, 0, DispCols, linebuf+pancolumn);
        }
      redraw = false;
      setattr(attr_status);
      mvaddnstr(0, 50, 5, stat[pgstat]);
      pgstat = STATOK;
      switch(kc=kbget())
        {
          case PG_UP:
            topline -= (pagesize - 1);
            redraw = true;
            break;
          case SPACE:                   /* (jh) */
          case PG_DN:                   /* scroll down by one screen */
            if((topline + pagesize) < numlines)
              {
                topline = lineno - 1;
              }
            else
              {
                pgstat = STATBOT;
              }
            redraw = true;
            break;
          case KEY_HOME:
            topline = 1;
            redraw = true;
            break;
          case KEY_END:
            topline = numlines - pagesize;
            redraw = true;
            break;
          case KEY_UP:
            if(--topline)
              {
                scroll_down(0, 1, DispCols-1, pagesize, 1);
              }
            else
              {
                pgstat = STATTOP;
              }
            redraw = true;
            break;
          case RETURN:                          /* scroll down one line only */
          case KEY_DN:
            kc = KEY_DN;
            if((topline + pagesize) < numlines)
              {
                scroll_up(0, 1, DispCols-1, pagesize, 1);
                redraw = false;
                topline++;
              }
            else
              {
                pgstat = STATBOT;
              }
            break;
          case KEY_LAST:                            /* Ctrl-PageUp */
            quit = 1;
            --filenum;
            break;
          case KEY_NEXT:                            /* Ctrl-PageDn */
            quit = 1;
            ++filenum;
            break;
          case ESC:                                 /* Quit */
          case KEY_Q:
          case KEY_q:
            quit = 1;
            filenum = maxfile + 1;
            break;
          case SEARCH:                              /* Begin a search */
            clearline((int) DispRows-1, attr_status);
            mvaddnstr((int) DispRows-1, 0, 9, "Search:  ");
            searchstr[0]=19;
            searchline = topline;
            getstr(searchstr);
            if (searchstr[1])
            {
              if (strfind(linebuf, searchstr))
                {
                  ltoa(searchline-1, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                }
            }
            redraw = true;
            break;
          case KEY_JMP:                              /* ? Jump to line */
            clearline((int) DispRows-1, attr_status);
            mvaddnstr((int) DispRows-1, 0, 10, "Jump to:  ");
            buffer[0]=19;
            getstr(buffer);
            if (buffer[1])
              {
                topline = atol(buffer+2);
              }
            clearline((int) DispRows-1, attr_status);
            redraw = true;
            break;
          case KEY_1:                               /* set Bookmark #1 */
            bookmark[0] = topline;
            break;
          case KEY_2:
            bookmark[1] = topline;
            break;
          case KEY_3:
            bookmark[2] = topline;
            break;
          case KEY_4:
            bookmark[3] = topline;
            break;
          case KEY_5:
            bookmark[4] = topline;
            break;
          case KEY_A1:                              /* Back to bookmark #1 */
            topline = bookmark[0];
            redraw = true;
            break;
          case KEY_A2:
            topline = bookmark[1];
            redraw = true;
            break;
          case KEY_A3:
            topline = bookmark[2];
            redraw = true;
            break;
          case KEY_A4:
            topline = bookmark[3];
            redraw = true;
            break;
          case KEY_A5:
            topline = bookmark[4];
            redraw = true;
            break;
          case KEY_F1:                                /* On-line help */
            on_line_help();
            break;
          case KEY_F2:                                /* cont. search backward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        "); /* clear result area */
            if (searchline > 0)
            {
              if (strrfind(linebuf, searchstr))
                {
                  ltoa(searchline, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                }
            }
            break;
          case KEY_F3:                              /* cont. search forward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        ");
            if ( searchline < numlines)
            {
              if (strfind(linebuf, searchstr))
              {
                ltoa(searchline-1,buffer,10);
                mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
              }
            }
            break;
          case KEY_F4:                              /* save screen to file */
            save_screen(topline, topline + DispRows - 2);
            break;
          case KEY_LT:                              /* Left key */
            pancolumn -= 10;                        /* pan left */
            if (pancolumn < 0) pancolumn = 0;
            redraw = true;
            break;
          case KEY_RT:                              /* Right key */
            pancolumn += 10;                        /* pan right */
            if (pancolumn > 50) pancolumn = 0;
            redraw = true;
            break;
          case BK_SPACE:
          default:
            break;
         } /* switch */
    }   /* !Quit */
    showline = topline;
    return filenum;
}

/* save screen to a save file */
void
save_screen(long fromline, long toline)
{
  long seekpos, pos1, pos2;
  pgsav = fopen("C:\\TEMP\\PG.SAV", "ab");

  strcpy(linebuf, "!!! Copy from ");            /* info about the copy */
  strcat(linebuf, infilename);
  strcat(linebuf, " line ");
  strcat(linebuf, ltoa(fromline, buffer,10));
  strcat(linebuf, " !!! ");
  fwrite(linebuf, strlen(linebuf), 1, pgsav);

  if (toline >= numlines)
    toline = numlines;
  seekpos = maxfile * 16 + (fromline - 1) * sizeof(long);
  fseek(pgtmp, seekpos, SEEK_SET);
  fread(&offset, sizeof(long), 1, pgtmp);
  fseek(infile, offset, SEEK_SET);
  pos1 = ftell(infile);
  while (--toline - (fromline-1))
    {
      fgets(linebuf, MAXSIZELINE - 1, infile);
      pos2 = ftell(infile);
      fwrite(linebuf, pos2 - pos1, 1, pgsav);
      pos1 = pos2;
    }
  fclose(pgsav);
}

/* Get display adaptor info. and initialize */
void
InitVideo(void)
{
  getbiosinfo();
  RegenSize = DispRows * DispCols;     /* for use in asm functions */
  VideoRegen = (DispMode == MONO ? 0xb000 : 0xb800);
  Color = (DispMode == MONO ? false : true);

/* BAHCL moved from main() */
#ifdef USE_COLOR_MODE                   /* (jh) */
  if(Color)
    {
      attr_status    = CO_STATUS;
      attr_lo_status = CO_LO_STATUS;
      attr_text      = CO_TEXT;
    }
  else
    {
      attr_status    = MO_STATUS;
      attr_lo_status = MO_LO_STATUS;
      attr_text      = MO_TEXT;
    }
#else
  attr_status    = ATTR (BLACK, WHITE);			/* (jh) */
  attr_lo_status = ATTR (BLACK, WHITE);			/* (jh) */
  attr_text      = ATTR (WHITE, BLACK);			/* (jh) */
#endif /* USE_COLOR_MODE */

  setattr(attr_text);

}

/* BAHCL: useful as the one in Linux ncurses */
void
mvaddnstr(int prow, int pcol, int n, char *s)
{
  int i;
  i = 0;
  while (s[i] && (i < n))
    {
      mvaddch(prow, pcol++, s[i++], curatt);
    }
}

/* error exit */
void
errorexit(int pcode, char *args)
{
    mvaddnstr((int) DispRows-1,0,80,args);
    exit(pcode);
}

/* program usage */
void
usage(void)
{
  /* (jh) I moved all the usage text here so that the text wasn't
     separated from the usage() function */

  /* (jh) I moved the VERSION text here, since it is not used
     anywhere else. */

  /* (jh) Most DOS programs just show the name and usage, but you can
     build with the GNU 'copying' statement anyway by using
     -DSHOW_GNU_COPYING */
  int i;
  i = 0;
  clrscr();   /* BAHCL */
  mvaddnstr(0,0,80,"PG, version 1.0 (c) 1995-1998 Bill Weinman, wew@bearnet.com");
  mvaddnstr(1,0,80,"PG, version 1.04 2003 Maintainer BAHCL, freedos_pg@yahoo.com.hk");

#ifdef SHOW_GNU_COPYING
  mvaddnstr(2,0,80,"Distributed under the terms of the GNU General Public License.");
  mvaddnstr(3,0,80,"See the file COPYING for details.");
  i = 2;
#endif

  mvaddnstr(3+i,0,80,"usage:  PG [/?] [filename]");
  mvaddnstr(4+i,0,80,"  /?       - display this help screen.");
  mvaddnstr(5+i,0,80,"  filename - page through filename on the PC screen");
  mvaddnstr(6+i,0,80,"             filename maybe in wildcard format");
  mvaddnstr(7+i,0,80,"             if filename is omitted, shows this help screen");
  mvaddnstr(8+i,0,80,"  Read pg.man for details.");

  exit(0);
}

/* Just a blank line with status attribute */
void
clearline(int lin, char attr)
{
  int i;

  setattr(attr);
  for (i=0; i < DispCols; i++) mvaddnstr(lin, i, 1, " ");
}

/* PG -- file information headline */
void
headline(long line)
{
  clearline(0, attr_status);
  mvaddnstr(0, 1, 6, "PG -- ");
  mvaddnstr(0, 7, 40, infilename);
  ltoa(numlines-1, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-10, 6, buffer);
  ltoa(line, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-1, 6, buffer);
}

/* find sub-string in forward manner */
char *strfind(char *str1, char *str2)
{
  char *ptr;

  do
  {
    getline(searchline++);
    ptr = strstr(str1, str2+2);
  } while((searchline < numlines) && (ptr == NULL));

  return ptr;
}

/* find sub-string in backward manner */
char *strrfind(char *str1, char *str2)
{
  char *ptr;

  do
  {
    getline(--searchline);
    ptr = strstr(str1, str2+2);
  } while((searchline > 0) && (ptr == NULL));

  return ptr;
} 
