{**********************************************************************
** RegFS 0.1.0                                                       **
** ----------------------------------------------------------------- **
** Acces to register on text files                                   **
** ----------------------------------------------------------------- **
** Cronos, 1992,1999-2000                                            **
** This unit is distributed with NO WARRANTY, under the terms of     **
** the GNU-GPL (ver 2.0 or later) license                            **
** ----------------------------------------------------------------- **
** Original author: Aitor Santamara Merino (0.1.0)                  **
** Modifications: <NONE>                                             **
**********************************************************************}
UNIT
    RegFS;


Interface

const
     CommentChar = ';';

(********************************************************************
** RegFSErr: status of last RegFS operation                        **
** --------------------------------------------------------------- **
** OUTPUT: error code of the operation                             **
********************************************************************)
Function RegFS_Error: byte;

(********************************************************************
** GetLabel: Reads the value of a variable in a INI-like file      **
** --------------------------------------------------------------- **
** INPUT: FileName:   name of the file where the variable is       **
*         secname: the name of the section in the ini file,        **
**                        without brackets                         **
**        varname: name of the variable                            **
**        ocurrence: number of ocurrence of the variable           **
** OUTPUT: returns the label string                                **
********************************************************************)
Function GetLabel (FileName, SecName, VarName: string; ocurrence:byte): string;

(********************************************************************
** GetVarName: Lists variables in a section                        **
** --------------------------------------------------------------- **
** INPUT: FileName:   name of the file where you look for variables **
**        secname: the name of the section in the ini file,        **
**                        without brackets                         **
**        ocurrence: number of variable to be found                **
** OUTPUT: returns the var name                                    **
********************************************************************)
Function GetVarName (FileName, SecName: string; ocurrence:byte): string;

Implementation

Uses
    PASExt;

Var
   F: text;
   regfs_err : byte;


FUNCTION GetValidLine: string;
VAR
   s: string;
BEGIN
     REPEAT
        ReadLn (F, S)
     UNTIL S[1]<>commentchar;  {avoid comments}
     GetValidLine := S
END;



Function RegFS_error: byte;
Begin
     RegFS_error := RegFS_err;
     RegFS_err   := 0
End;

Procedure SearchSec (sectn: string);
Var
   UseStr: string;
Begin
     UseStr :='';
     While (UseStr<> ('['+sectn+']')) and (not (eof(F))) do
           UseStr := GetValidLine;
     If eof(F) Then RegFS_Err := 1;
End;


Function StrTill (CTCCar: char; CTCStr: string): String;
Var
   CTCI: byte;
   CTCCadSum: string;
Begin
     CTCCadSum := '';
     CTCI:= 1;
     While (CTCStr[CTCI]<>CTCCar) and (CTCI<=Length(CTCStr)) do
           Begin
                CTCCadSum := CTCCadSum + CTCStr[CTCI];
                Inc (CTCI)
           End;
     StrTill:= CTCCadSum
End;


Function StrFrom (CFCCar: Char; CFCStr: string): String;
Var
   CFCI: byte;
   CFCCadSum : String;
Begin
     CFCCadSum := '';
     CFCI:= length(CFCStr);
     While (CFCStr[CFCI]<>CFCCar) and (CFCI>=1) do
           Begin
                CFCCadSum := CFCStr[CFCI]+CFCCadSum;
                Dec (CFCI)
           End;
     StrFrom:= CFCCadSum
End;



Function GetLabel (FileName, SecName, VarName: string; ocurrence:byte): string;
var
   UseStr: string;
Begin
     If Not FileExist(FileName) Then Begin RegFS_Err := 3;
                                           exit
                                     end;
     Assign (F,FileName);
     Reset (F);
     UseStr :='';
     If IOResult=0 Then Begin
     SearchSec (SecName);
     While not ((StrTill('=',UseStr) = VarName) and (ocurrence=0))
           and (UseStr[1]<>'[') and (not eof(F)) do begin
           useStr:= GetValidLine;
           If (StrTill('=',UseStr) = VarName) Then Dec(ocurrence)
     End;
     If (UseStr[1]='[') or (eof(f) and (ocurrence>0))
                                   Then begin useStr :='';
                                              RegFS_Err := 2
                                         end
                                    Else begin useStr := StrFrom('=',useStr);
                                               RegFS_Err := 0
                                         End;
     Close(F);
     End;
     GetLabel := UseStr
End;


Function GetVarName (FileName, SecName: string; ocurrence:byte): string;
var
   UseStr: string;
Begin
     Assign (F,FileName);
     Reset (F);
     SearchSec (SecName);
     Repeat
           Repeat
                UseStr:=GetValidLine;
           Until (UseStr<>'') or (Eof(F));
           Dec (ocurrence);
     Until (ocurrence<=0) or (UseStr[1]='[') or (Eof(F));
     If (UseStr[1]='[') or (Eof(F) and (ocurrence>0)) or (UseStr='')
                Then GetVarName := '#'
                Else GetVarName := StrTill ('=', UseStr);
     Close(F);
End;



Begin
     RegFS_Err := 0;
End.


{Tabla de errores:
1: Section not found
2: Variable not found
3: File not found}
