include wsub.inc
include dir.inc
include fblk.inc
include string.inc
include io.inc
include iost.inc
include unzip.inc
include filter.inc
include progress.inc
include alloc.inc
include conio.inc
include syserrls.inc
include doserrls.inc
include errno.inc

public		cp_emarchive
externdef	scan_fblock:S_WFBLK


DC_MAXOBJ	equ 5000 ; Max number of files in one subdir (recursive)

.data
cp_emarchive	db "Error in archive",0

.code

wzipfindentry proc private uses esi edi fblk:dword, ziph:size_t
	mov	esi,ziph
	mov	edi,fblk
	invoke  strlen,addr [edi].S_FBLK.fb_name
	add	eax,SIZE S_FBLK
	add	edi,eax
	invoke  lseek,esi,[edi],SEEK_SET
	invoke  osread,esi,addr zip_local,SIZE S_LZIP
	.if eax == SIZE S_LZIP && zip_local.lz_pkzip == ZIPHEADERID && \
	    zip_local.lz_zipid == ZIPLOCALID
	    movzx eax,zip_local.lz_fnsize
	    add ax,zip_local.lz_extsize
	    invoke lseek,esi,eax,SEEK_CUR
	    .if zip_local.lz_flag & 8
		mov eax,fblk
		mov eax,[edi+4]
		mov zip_local.lz_crc,eax
		mov eax,[edi+8]
		mov zip_local.lz_csize,eax
	    .endif
	    mov eax,1
	.else
	    sub eax,eax
	.endif
	test eax,eax
	ret
wzipfindentry endp

wzipcopyfile proc private uses esi edi ebx wsub:dword, fblk:dword, out_path:dword
local fhandle:dword
local fname[WMAXPATH*2]:byte
    mov ebx,fblk
    .if filter_fblk(ebx)
	.if wsopenarch(wsub) != -1
	    mov esi,eax
	    .if wzipfindentry(ebx,esi)
		lea edi,fname
		invoke strfcat,edi,out_path,addr [ebx].S_FBLK.fb_name
		.if !progress_set(addr [ebx].S_FBLK.fb_name,
		    out_path,dword ptr [ebx].S_FBLK.fb_size)
		    .if SDWORD ptr ogetouth(edi,M_WRONLY) > 0
			mov    fhandle,eax
			mov    edx,eax
			mov    eax,[ebx].S_FBLK.fb_flag
			mov    zip_attrib,eax
			mov    eax,esi
			invoke unzip
			push   eax
			invoke close,esi
			pop eax
			.if !eax
			    invoke setftime,fhandle,[ebx].S_FBLK.fb_time
			    invoke close,fhandle
			    mov	   eax,[ebx].S_FBLK.fb_flag
			    and	   eax,_A_FATTRIB
			    invoke setfattr,edi,eax
			    sub	   eax,eax
			    jmp	   copy_end
			.else
			    mov	   esi,fhandle
			    push   eax
			    invoke remove,edi
			    pop	   eax
			    .if eax == ER_USERABORT || eax == ERROR_INVALID_FUNCTION
				jmp @F
			    .endif
			    mov edi,eax
			    mov edx,offset CP_ENOMEM
			    .if eax == ER_MEM
				mov eax,edx
			    .elseif eax == ER_DISK
				mov eax,offset CP_ENOSPC
			    .else
				mov edx,offset CP_EIO
				mov eax,offset cp_emarchive
				mov ecx,errno
				.if ecx
				    mov edx,sys_errlist[ecx*4]
				.endif
			    .endif
			    invoke ermsg,eax,edx
			    mov eax,edi
			    jmp @F
			.endif
		    .else
			jmp @F
		    .endif
		.else
		    jmp @F
		.endif
	    .else
		add    ebx,S_FBLK.fb_name
		invoke ermsg,addr CP_ENOENT,ebx
		mov    eax,ER_FIND
	      @@:
		invoke close,esi
		mov eax,edx
	    .endif
	.else
	    mov eax,ER_NOZIP
	.endif
    .endif
copy_end:
    ret
wzipcopyfile endp

S_ZSUB		STRUC
zs_wsub		S_WSUB <>
zs_off_path	dd ?
zs_off_file	dd ?
zs_index	dd ?
zs_result	dd ?
S_ZSUB		ENDS

wzipcopypath proc private uses esi edi ebx wsub:dword, fblk:dword, out_path:dword
local zs:S_ZSUB
	lea	edi,zs
	mov	ebx,wsub
	mov	eax,[ebx].S_WSUB.ws_path
	mov	zs.zs_wsub.ws_path,eax
	mov	eax,[ebx].S_WSUB.ws_file
	mov	zs.zs_wsub.ws_file,eax
	mov	eax,[ebx].S_WSUB.ws_mask
	mov	zs.zs_wsub.ws_mask,eax
	mov	esi,offset scan_fblock
	mov	[esi].S_PATH.wp_flag,_W_SORTSIZE
	mov	eax,esi
	mov	zs.zs_wsub.ws_flag,eax
	add	eax,S_PATH.wp_arch
	mov	zs.zs_wsub.ws_arch,eax
	mov	zs.zs_wsub.ws_count,0
	mov	zs.zs_wsub.ws_maxfb,DC_MAXOBJ
	mov	edx,eax
	mov	eax,fblk
	add	eax,S_FBLK.fb_name
	mov	ebx,[ebx].S_WSUB.ws_arch
	.if byte ptr [ebx]
	    invoke strfcat,edx,ebx,eax
	.else
	    invoke strcpy,edx,eax
	.endif
	add esi,S_PATH.wp_file
	mov ebx,fblk
	invoke strfcat,esi,out_path,addr [ebx].S_FBLK.fb_name
	.if mkdir(esi) != -1
	    .if !setfattr(esi,0)
		mov eax,fblk
		mov eax,[eax]
		and eax,_A_FATTRIB
		and eax,not _A_SUBDIR
		invoke setfattr,esi,eax
	    .endif
	.endif
	push	esi
	add	esi,SIZE S_PATH.wp_file
	invoke  strlen,esi
	add	eax,esi
	mov	zs.zs_off_file,eax
	call	strlen
	sub	esi,SIZE S_PATH.wp_file
	add	eax,esi
	mov	zs.zs_off_path,eax
	invoke  progress_set,addr [ebx].S_FBLK.fb_name,out_path,0
	jnz	wzipcopypath_end
	invoke  wsopen,edi
	test	eax,eax
	jnz	wzipcopypath_read
	dec	eax
	jmp	wzipcopypath_end
    wzipcopypath_read:
	invoke  wzipread,edi
	cmp	eax,1
	ja	wzipcopypath_sort
	invoke  wsclose,edi
	xor	eax,eax
    wzipcopypath_end:
	ret
    wzipcopypath_warning:
	invoke  stdmsg,addr cp_warning,addr cp_emaxfb,eax,eax
	jmp	wzipcopypath_max
    wzipcopypath_sort:
	invoke  wssort,edi
	mov	eax,[edi].S_WSUB.ws_maxfb
	cmp	eax,[edi].S_WSUB.ws_count
	je	wzipcopypath_warning
    wzipcopypath_max:
	mov	eax,[edi].S_WSUB.ws_count
	dec	eax
	mov	zs.zs_index,eax
	xor	eax,eax
	mov	zs.zs_result,eax
    wzipcopypath_next:
	cmp	byte ptr zs.zs_result,0
	jne	wzipcopypath_close
	mov	eax,zs.zs_index
	cmp	eax,1
	jl	wzipcopypath_close
	mov	ebx,[edi].S_WSUB.ws_fcb
	mov	ebx,[ebx+eax*4]
	mov	eax,[ebx]
	and	eax,_A_SUBDIR
	jz	wzipcopypath_file
	invoke  wzipcopypath,edi,ebx,esi
	mov	zs.zs_result,eax
	xor	al,al
	mov	edx,zs.zs_off_file
	mov	[edx],al		; *a = 0;
	mov	edx,zs.zs_off_path
	mov	[edx],al		; *p = 0;
	jmp	wzipcopypath_free
    wzipcopypath_close:
	invoke  wsclose,edi
	mov	eax,zs.zs_result
	jmp	wzipcopypath_end
    wzipcopypath_file:
	push	edx
	push	ebx
	invoke  progress_set,addr [ebx].S_FBLK.fb_name,out_path,
		dword ptr [ebx].S_FBLK.fb_size
	mov	zs.zs_result,eax
	pop	ebx
	pop	edx
	jnz	wzipcopypath_close
	invoke  wzipcopyfile,edi,ebx,esi
	mov	zs.zs_result,eax
    wzipcopypath_free:
	mov	ebx,[edi].S_WSUB.ws_fcb
	mov	eax,zs.zs_index
	lea	ebx,[ebx+eax*4]
	xor	eax,eax
	push	[ebx]
	mov	[ebx],eax
	call	free
	dec	zs.zs_index
	jmp	wzipcopypath_next
wzipcopypath endp

wzipcopy proc wsub:dword, fblk:dword, out_path:dword
	mov eax,fblk
	.if byte ptr [eax] & _A_SUBDIR
	    invoke wzipcopypath,wsub,eax,out_path
	.else
	    invoke wzipcopyfile,wsub,eax,out_path
	.endif
	ret
wzipcopy endp

	END
