include _tinfo.inc
include keyb.inc
include string.inc
include stdio.inc
include wsub.inc
include alloc.inc

ifdef USE_DICTIONARY
CodeInfo proto
endif

;-----------------------------------------------------------------------------
; Event handler
;-----------------------------------------------------------------------------

.data

ifndef __DZ__
externdef IDD_TEHelp:dword
endif
externdef IDD_TEReload:dword
externdef IDD_TEReload2:dword

te_keytable label dword
ifndef __DZ__
	dd KEY_F1,		__F1		; Help
endif
	dd KEY_F2,		__F2		; Save file
	dd KEY_F3,		tisearch	; Search
	dd KEY_F4,		tireplace	; Replace
	dd KEY_F6,		__F6
	dd KEY_ESC,		__Esc		; Exit - leave files open
	dd KEY_ALTX,		__AltX
	dd KEY_CTRLX,		__CtrlX
	dd KEY_F11,		titogglemenus	; Zoom (Ctrl-M)
	dd KEY_CTRLF2,		__CtrlF2	; Save as
	dd KEY_CTRLF6,		__CtrlF9	; Options
	dd KEY_CTRLF9,		__CtrlF9	; Options
	dd KEY_CTRLA,		__CtrlA		; Select All
	dd KEY_CTRLB,		__CtrlB		; User screen
	dd KEY_CTRLF,		__CtrlF		; Optimal fill on/off
	dd KEY_CTRLG,		tilseek		; Goto line
	dd KEY_CTRLI,		__CtrlI		; Autoindent on/off
	dd KEY_CTRLL,		__CtrlL		; Search again
	dd KEY_CTRLM,		titogglemenus	; Toggle menus on/off
	dd KEY_CTRLO,		__CtrlB		;
	dd KEY_CTRLR,		tereload	; Reload file
	dd KEY_CTRLS,		__CtrlS		; Toggle style on/off
	dd KEY_CTRLT,		__CtrlT		; Tabs mode on/off
	dd KEY_ALTL,		tilseek		;
	dd KEY_ALTS,		tisearchxy	; Word search
	dd KEY_ALT0,		__Alt0		; Window List
	ti_keytable dd 128*2 dup(0)		; external keys/macros
te_keycount = (($ - offset te_keytable) / 8)

.code

tioption:
	push	esi
	push	edi
	mov	esi,titabsize
	mov	edi,teflag
	mov	edx,tinfo
	mov	eax,[edx].S_TINFO.ti_flag
	mov	teflag,eax
	mov	eax,[edx].S_TINFO.ti_tabz
	mov	titabsize,eax
	invoke  teoption
	mov	eax,titabsize
	mov	ecx,teflag
	mov	teflag,edi
	mov	titabsize,esi
	mov	esi,eax
	mov	edx,tinfo
	mov	eax,[edx].S_TINFO.ti_flag
	mov	edi,eax
	and	ecx,_T_TECFGMASK
	and	eax,not _T_TECFGMASK
	or	eax,ecx
	mov	[edx].S_TINFO.ti_flag,eax
	mov	eax,edi
	and	eax,_T_USETABS
	and	ecx,_T_USETABS
	.if eax != ecx || esi != titabsize
	    .if edi & _T_MODIFIED
		.if tisavechanges()
		    mov eax,tinfo
		    call tiflush
		.endif
	    .endif
	    mov edx,tinfo
	    mov [edx].S_TINFO.ti_tabz,esi
	    call tereload
	.endif
	pop edi
	pop esi
	ret

__CtrlF9:
	call	tioption
	jmp	ticontinue

ifndef __DZ__
__F1:
	invoke  rsmodal,IDD_TEHelp
	jmp	ticontinue
endif

__F2:
	mov	eax,tinfo
	call	tisave
	jmp	ticontinue

__F6:
	.if tigetfile()
	    mov edx,tinfo
	    .if [edx].S_TINFO.ti_next
		mov eax,[edx].S_TINFO.ti_next
	    .endif
	    jmp titogglefile
	.endif
	ret

;__dlpop proto
titogglefile proc uses esi edi
	mov edi,tinfo
	.if eax != edi
	    .if [eax].S_TINFO.ti_flag & _T_TEDIT
		mov tinfo,eax
		mov esi,eax
		invoke tishow,eax
		.if [esi].S_TINFO.ti_DOBJ.dl_flag & _D_DOPEN
		    and [edi].S_TINFO.ti_DOBJ.dl_flag,not (_D_DOPEN or _D_ONSCR)
		    movzx eax,[esi].S_TINFO.ti_DOBJ.dl_rect.rc_col
		    movzx ecx,[esi].S_TINFO.ti_DOBJ.dl_rect.rc_row
		    mul ecx
		    add eax,eax
		    invoke memcpy,[esi].S_TINFO.ti_DOBJ.dl_wp,[edi].S_TINFO.ti_DOBJ.dl_wp,eax
		    invoke free,[edi].S_TINFO.ti_DOBJ.dl_wp
;		    lea edi,[edi].S_TINFO.ti_DOBJ
;		    invoke __dlpop
		.else
		    mov tinfo,edi
		.endif
	    .endif
	.endif
	sub eax,eax
	ret
titogglefile endp

	;------------------------------------------
	; Close window and exit -- leave files open
	;------------------------------------------
__Esc:
	mov	eax,tinfo
	test	eax,eax
	jz	@F
	test	[eax].S_TINFO.ti_flag,_T_TEDIT
	jz	@F
	invoke  tihide,eax
	mov	eax,_TI_RETEVENT
	ret
      @@:

	;----------------------------------------
	; Close current file -- exit if last file
	;----------------------------------------
__CtrlX:
	invoke  tclose
	mov	eax,_TI_RETEVENT
	jz	@F
	mov	eax,tinfo
	test	eax,eax
	jz	@F
	invoke  tishow,eax
	mov	eax,_TI_CONTINUE
     @@:
	ret

__Alt0:
	.if tdlgopen() > 2
	    jmp titogglefile
	.elseif eax == 1
	    mov tinfo,edx
	    jmp __CtrlX
	.elseif eax == 2
	    mov eax,edx
	    invoke tisave
	.endif
	ret

__CtrlF2:
	mov edx,tinfo
	invoke strcpy,addr _bufin,[edx].S_TINFO.ti_file
	invoke strfn,eax
	.if eax != offset _bufin
	    mov byte ptr [eax-1],0
	.endif
	.if wdlgopen(addr _bufin,eax,0)
	    mov edx,tinfo
	    invoke strcpy,[edx].S_TINFO.ti_file,eax
	    mov eax,tinfo
	    call tiflush
	    mov eax,tinfo
	    xor [eax].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	.endif
	sub eax,eax
	ret

__CtrlA:
	invoke  tiselectall
	jmp	titoggleupdate

__CtrlB:
	invoke  consuser
	sub	eax,eax
	ret

__CtrlI:
	mov	eax,_T_USEINDENT
	jmp	@F
__CtrlF:
	mov	eax,_T_OPTIMALFILL
	jmp	@F
__CtrlS:
	mov	eax,_T_USESTYLE
	jmp	@F
__CtrlT:
	mov	eax,_T_SHOWTABS
      @@:
	mov	edx,tinfo
	xor	[edx].S_TINFO.ti_flag,eax
	jmp	titoggleupdate

__CtrlL:
	invoke  ticontinuesearch
	jmp	ticontinue

titoggleupdate:
	invoke  tiputs
	jmp	ticontinue

timemzero proc private uses edi
	mov	edi,eax
	mov	eax,[edi].S_TINFO.ti_bcol
	mul	[edi].S_TINFO.ti_brow
	shr	eax,2
	mov	ecx,eax
	mov	edi,[edi].S_TINFO.ti_bp
	sub	eax,eax
	rep	stosd
	ret
timemzero endp

tereload proc private
	mov	eax,tinfo
	test	[eax].S_TINFO.ti_flag,_T_MODIFIED
	jz	@F
	invoke  rsmodal,IDD_TEReload2
	jnz	@F
	jmp	ticontinue
      @@:
	mov	eax,tinfo
	invoke  timemzero
	mov	eax,tinfo
	invoke  tiread
	jz	@F
	invoke  tiseto
	invoke  tiputs
	jmp	ticontinue
      @@:
	mov	edi,KEY_ESC
	dec	eax
	ret
tereload endp

	;-----------------------------
	; Close all open files -- exit
	;-----------------------------
__AltX:
	invoke  tcloseall
	mov	eax,_TI_RETEVENT
	ret

teevent proc uses esi edi ebx
 update:
	invoke  tiseto
	invoke  tiputs
     do:
	mov	eax,tinfo
	mov	esi,eax
	invoke  tiftime
	jz	@F
	cmp	eax,[esi].S_TINFO.ti_time
	je	@F
	invoke  rsmodal,IDD_TEReload
	jz	@F
	mov	eax,esi
	invoke  timemzero
	mov	eax,esi
	invoke  tiread
	mov	edi,KEY_ESC
	jz	toend
	invoke  tiseto
	invoke  tiputs
     @@:
	invoke  timenus
ifdef USE_DICTIONARY
     @@:
	call	getkey
	jnz	@F
	call	tupdate
	test	eax,eax
	mov	eax,KEY_ESC
	jnz	@F
	call	mousep
	mov	eax,MOUSECMD
	jnz	@F
	mov	eax,keyshift
	mov	eax,[eax]
	and	eax,SHIFT_RIGHT or SHIFT_LEFT
	cmp	eax,SHIFT_RIGHT or SHIFT_LEFT
	jne	@B
	invoke  CodeInfo
	jmp	@B
     @@:
else
	call	tgetevent
endif
	mov	edi,eax
	lea	esi,te_keytable
	mov	ecx,te_keycount
	sub	ebx,ebx
     @@:
	cmp	ebx,[esi]
	je	@F
	cmp	eax,[esi]
	je	found
	add	esi,8
	dec	ecx
	jnz	@B
     @@:
	invoke  ticlipevent
	invoke  tievent
	jmp	update
  found:
	mov	eax,[esi+4]
	call	eax
	cmp	eax,_TI_CONTINUE
	je	do
  toend:
	mov	eax,edi
	ret
teevent endp

	END
