include _tinfo.inc
include string.inc
include io.inc
include wsub.inc
include fblk.inc
include keyb.inc
include stdlib.inc
include errno.inc
include alloc.inc
include helpid.inc
include process.inc

MAXERROR	equ 100		; read .err file from compile

externdef	configfile:byte

tisavefiles	proto
tiloadfiles	proto
view_readme	proto
titogglefile	proto
tereload	proto
cmdlini		proto buffer:dword, filename:dword, section:dword
command		proto :dword

ERFILE		STRUC
m_file		db WMAXPATH dup(?)
m_info		db 256 dup(?)
m_line		dd ?
ERFILE		ENDS

.data
cp_AltFX	db 'AltF'
cp_AltX		db '1',0
cp_ShiftFX	db 'ShiftF'
cp_ShiftX	db '1',0
error_count	dd 0
error_id	dd 0
err_file	dd 0

keytable label dword
	dd KEY_SHIFTF1, __ShiftF1	; [Compile]
	dd KEY_SHIFTF2, __ShiftF2
	dd KEY_SHIFTF3, __ShiftF3
	dd KEY_SHIFTF4, __ShiftF4
	dd KEY_SHIFTF5, __ShiftF5
	dd KEY_SHIFTF6, __ShiftF6
	dd KEY_SHIFTF7, __ShiftF7
	dd KEY_SHIFTF8, __ShiftF8
	dd KEY_SHIFTF9, __ShiftF9
	dd KEY_ALTF1,	__AltF1
	dd KEY_ALTF2,	__AltF2
	dd KEY_ALTF3,	__AltF3
	dd KEY_ALTF4,	__AltF4
	dd KEY_ALTF5,	__AltF5
	dd KEY_ALTF6,	__AltF6
	dd KEY_ALTF7,	tipreviouserror
	dd KEY_ALTF8,	tinexterror
	dd KEY_ALTF9,	__AltF9 ; [Compile]
	dd KEY_F1,	__F1
	dd KEY_F8,	tisavefiles
	dd KEY_F9,	tiloadfiles
keycount equ (($ - offset keytable) / 8)

.code

__F1:
	mov	eax,HELPID_05
	invoke  view_readme
	jmp	ticontinue

__AltF1:
	push	esi
	mov	esi,tinfo
	invoke  topen,addr configfile
	jz	@F
	mov	eax,tinfo
	mov	tinfo,esi
	call	titogglefile
     @@:
	pop	esi
	ret

inicmd  macro l1,id
l1&id&: mov al,id+'0'
	jmp &l1&X
	endm
;inicmd __AltF,1
inicmd  __AltF,2
inicmd  __AltF,3
inicmd  __AltF,4
inicmd  __AltF,5
inicmd  __AltF,6
inicmd  __AltF,9
inicmd  __ShiftF,1
inicmd  __ShiftF,2
inicmd  __ShiftF,3
inicmd  __ShiftF,4
inicmd  __ShiftF,5
inicmd  __ShiftF,6
inicmd  __ShiftF,7
inicmd  __ShiftF,8
inicmd  __ShiftF,9

__AltFX:
	mov	cp_AltX,al
	mov	eax,offset cp_AltFX
	jmp	tiexecuteini

__ShiftFX:
	mov	cp_ShiftX,al
	mov	eax,offset cp_ShiftFX
	jmp	tiexecuteini

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Parse output from Edit command
;
; WCC	 '<file>(<line>): Error! <id>: <message>'
; JWasm  '<file>(<line>) : Error <id>: <message>: <text>'
; Masm	 '<file>(<line>) : error <id>: <message>'
;
.data
chars	db "\abcdefghijklmnopqrstuvwxyz0123456789_@",0

.code

clear_error:
	mov	eax,err_file
	test	eax,eax
	jz	@F
	invoke  free,eax
     @@:
	sub eax,eax
	mov err_file,eax
	mov error_id,eax
	mov error_count,eax
	ret

TestChar proc private uses edi ecx eax
	.if al >= 'A' && al <= 'Z'
	    or al,20h
	.endif
	mov edi,offset chars
	mov ecx,sizeof chars
	repne scasb
	cmp byte ptr [edi-1],0
	ret
TestChar endp

	assume ebx:ptr ERFILE

ParseLine proc private uses ecx edi esi ebx
	mov eax,SIZE ERFILE
	mul error_count
	add eax,err_file
	mov ebx,eax
	mov edi,esi
	mov al,[edi]
	call TestChar
	.if !ZERO?
	    .if strchr(edi,40)
		mov cl,[eax+1]
		.if (cl >= '0' && cl <= '9')
		    xchg esi,eax
		    mov byte ptr [esi],0
		    inc esi
		    invoke atol,esi
		    mov ecx,eax
		    inc esi
		    mov [ebx].m_line,ecx
		    invoke strncpy,addr [ebx].m_file,edi,WMAXPATH-1
		    .if strchr(esi,':')
			inc eax
			mov esi,eax
		    .endif
		    invoke strncpy,addr [ebx].m_info,esi,255
		    inc error_count
		.endif
	    .endif
	.endif
	ret
ParseLine endp

	assume ebx:nothing

ParseOutput proc private uses esi edi ebx
local pBuffer:dword
local bSize:dword
local FName[WMAXPATH]:byte
	call clear_error
	mov edx,tinfo
	lea edi,FName
	invoke strfn,[edx].S_TINFO.ti_file
	invoke strcpy,edi,eax
	invoke setfext,eax,".err"
	.if filexist(eax) == 1
	    .if osopen(edi,0,M_RDONLY,A_OPEN) != -1
		mov esi,eax
		invoke filelength,esi
		inc eax
		mov bSize,eax
		.if malloc(eax)
		    mov pBuffer,eax
		    mov edi,eax
		    mov ebx,bSize
		    dec ebx
		    invoke osread,esi,eax,ebx
		    mov byte ptr [edi+ebx],0
		    invoke close,esi
		    .if malloc(MAXERROR*SIZE ERFILE)
			mov err_file,eax
			invoke memzero,eax,MAXERROR*SIZE ERFILE
			mov esi,edi
			mov ecx,bSize
			.repeat
			    mov al,10
			    repne scasb
			    .if ecx
				mov byte ptr [edi-2],0
				call ParseLine
			    .else
				call ParseLine
				.break
			    .endif
			    mov esi,edi
			.until 0
		    .endif
		    invoke free,pBuffer
		.else
		    invoke close,esi
		.endif
	    .endif
	.endif
	mov eax,error_count
	ret
ParseOutput endp

GetMessageId proc private id:dword
	mov	eax,err_file
	test	eax,eax
	jz	@F
	mov	eax,SIZE ERFILE
	mul	id
	add	eax,err_file
     @@:
	ret
GetMessageId endp

tifindfile proc private uses esi edi ebx fname:dword
	invoke  tigetfile
	test	eax,eax
	jz	toend
	mov	esi,eax
     @@:
	invoke  stricmp,fname,[esi].S_TINFO.ti_file
	jz	found
	sub	eax,eax
	cmp	esi,edx
	je	toend
	mov	esi,[esi].S_TINFO.ti_next
	jmp	@B
  toend:
	test	eax,eax
	ret
  found:
	mov	eax,esi
	jmp	toend
tifindfile endp

LoadMessageFile proc private uses esi edi ebx M:dword
	mov esi,tinfo
	mov edi,M
	.if !tifindfile(addr [edi].ERFILE.m_file)
	    .if !topen(addr [edi].ERFILE.m_file)
		jmp toend
	    .endif
	    mov eax,tinfo
	.endif
	.if eax != esi
	    mov tinfo,esi
	    invoke titogglefile
	    mov esi,tinfo
	.endif
	mov eax,[edi].ERFILE.m_line
	.if eax
	    dec eax
	.endif
	invoke tialigny
	invoke tiputs
	lea eax,[edi].ERFILE.m_info
	mov ebx,[esi].S_TINFO.ti_yoff
	inc ebx
	.if [esi].S_TINFO.ti_flag & _T_USEMENUS
	    inc ebx
	.endif
	invoke scputs,0,ebx,4Fh,[esi].S_TINFO.ti_cols,eax
	mov old_bcrc,0
	mov eax,1
  toend:
	ret
LoadMessageFile endp

tipreviouserror proc private
	.if error_count
	    .if GetMessageId(error_id)
		invoke LoadMessageFile,eax
		.if error_id
		    dec error_id
		.else
		    mov eax,error_count
		    dec eax
		    mov error_id,eax
		.endif
	    .endif
	.endif
	mov eax,_TI_CONTINUE
	ret
tipreviouserror endp

tinexterror proc private
	.if error_count
	    .if GetMessageId(error_id)
		invoke LoadMessageFile,eax
		mov eax,error_id
		inc eax
		.if eax >= error_count
		    sub eax,eax
		.endif
		mov error_id,eax
	    .endif
	.endif
	mov eax,_TI_CONTINUE
	ret
tinexterror endp

cmspawnini proc private uses ebx IniSection:dword
local cursor:S_CURSOR
	sub eax,eax
	mov ebx,tinfo
	.if [ebx].S_TINFO.ti_flag & _T_TEDIT
	    .if [ebx].S_TINFO.ti_flag & _T_MODIFIED
		mov eax,ebx
		invoke tisave
	    .endif
	    .if cmdlini(addr __srcfile,[ebx].S_TINFO.ti_file,IniSection)
		mov ebx,eax
;		invoke cursorget,addr cursor
;		invoke tihide,tinfo
;		.if !command(ebx)
		.if !CreateConsole(ebx,_P_WAIT)
		    mov eax,errno
		    mov eax,sys_errlist[eax*4]
		    invoke ermsg,0,"Unable to execute command:\n\n%s\n\n'%s'",addr __srcfile,eax
		    sub eax,eax
		.endif
;		push eax
;		invoke tishow,tinfo
;		invoke cursorset,addr cursor
;		pop eax
	    .endif
	.endif
	ret
cmspawnini endp

tiexecuteini:
	push eax
	call clear_error
	pop eax
	.if cmspawnini(eax)
	    .if ParseOutput()
		invoke tinexterror
	    .endif
	.endif
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

wedit proc fcb:dword, count:size_t
     @@:
	invoke  fbffirst,fcb,count
	jz	@F
	and	[eax].S_FBLK.fb_flag,not _FB_SELECTED
	test	ecx,_FB_ARCHIVE or _A_SUBDIR
	jnz	@B
	add	eax,S_FBLK.fb_name
	invoke  topen,eax
	jnz	@B
     @@:
	sub	eax,eax
	invoke  tmodal
	ret
wedit	endp

Install:
	push	esi
	push	edi
	lea	edi,ti_keytable
	lea	esi,keytable
	mov	ecx,keycount*2
	rep	movsd
	pop	edi
	pop	esi
	ret

pragma_init Install, 170

	END
