include clip.inc
include string.inc
include conio.inc
include alloc.inc
include iost.inc
include keyb.inc
include _tinfo.inc

externdef IDD_ClipboardWarning:dword

;public  clipbsize
;public  clipboard

.data
winoldap  dd 0
clipbsize dd 0
clipboard dd 0

.code

ClipboardFree proc
	invoke  free,clipboard
	sub	eax,eax
	mov	clipbsize,eax
	mov	clipboard,eax
	ret
ClipboardFree endp

ClipboardCopy proc uses esi edi ebx string:dword, len:size_t
	mov edi,len
	call ClipboardFree
	.if console & CON_CLIPB
	    .if OpenClipboard(0)
		invoke EmptyClipboard
		inc edi
		.if GlobalAlloc(GMEM_MOVEABLE or GMEM_DDESHARE,edi)
		    dec edi
		    mov esi,eax
		    invoke GlobalLock,eax
		    invoke memcpy,eax,string,edi
		    mov ebx,eax
		    mov byte ptr [ebx+edi],0
		    invoke GlobalUnlock,esi
		    invoke SetClipboardData,CF_TEXT,ebx
		    mov eax,edi
		.endif
		push eax
		invoke CloseClipboard
		pop eax
	    .endif
	.endif
      @@:
	ret
ClipboardCopy endp

ClipboardPaste proc private uses ebx
	.if (console & CON_CLIPB)
	    .if IsClipboardFormatAvailable(CF_TEXT)
		.if OpenClipboard(0)
		    .if GetClipboardData(CF_TEXT)
			mov ebx,eax
			.if strlen(eax)
			    mov clipbsize,eax
			    inc eax
			    .if malloc(eax)
				invoke strcpy,eax,ebx
				mov clipboard,eax
			    .endif
			.endif
		    .endif
		    push eax
		    call CloseClipboard
		    pop  eax
		.endif
	    .endif
	.else
	    .if clipbsize
		mov eax,clipboard
	    .else
		sub eax,eax
	    .endif
	.endif
	test eax,eax
	ret
ClipboardPaste endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Cut		Shift-Del	Ctrl-X -- removed
; Copy		Ctrl-Ins	Ctrl-C
; Paste		Shift-Ins	Ctrl-V
; Clear		Del		Ctrl-Del
;

	assume  edx: ptr S_TINFO

GetShiftState proc private
	mov	eax,keyshift
	mov	al,[eax]
	and	eax,KEY_SHIFT
	ret
GetShiftState endp

tiselected proc
	mov	edx,tinfo
	mov	eax,[edx].ti_clel	; CX line count
	sub	eax,[edx].ti_clsl
	mov	ecx,eax
	jnz	@F
	mov	eax,[edx].ti_cleo	; AX byte count
	sub	eax,[edx].ti_clso
      @@:
	ret
tiselected endp

ticlipset proc  ; set clipboard to current position
	mov	edx,tinfo
	mov	eax,[edx].ti_xoff
	add	eax,[edx].ti_boff
	mov	[edx].ti_clso,eax
	mov	[edx].ti_cleo,eax
	mov	eax,[edx].ti_loff
	add	eax,[edx].ti_yoff
	mov	[edx].ti_clsl,eax
	mov	[edx].ti_clel,eax
	ret
ticlipset endp

ticopyselection proc private uses edi ebx
	xor	edi,edi
	invoke  oinitst,addr STDO,MAXCLIPSIZE
	jnz	@F
	invoke  oinitst,addr STDO,1000h
	jz	ticopyselection_eof
      @@:
	inc	edi
	mov	STDO.ios_flag,IO_CLIPBOARD
	mov	eax,[esi].S_TINFO.ti_clsl
	mov	edx,[esi].S_TINFO.ti_clso
	mov	ecx,[esi].S_TINFO.ti_clel
	mov	ebx,[esi].S_TINFO.ti_cleo
	invoke  tiflushl
	jnz	@F
	mov	eax,ebx
	mov	[esi].S_TINFO.ti_clsl,edx
	mov	[esi].S_TINFO.ti_clso,eax
	inc	edi
	invoke  rsmodal,IDD_ClipboardWarning
      @@:
	invoke  oflush
	invoke  ofreest,addr STDO
    ticopyselection_eof:
	mov	eax,edi
	test	eax,eax
	ret
ticopyselection endp

ticlipcut proc private uses esi edi
	mov	esi,tinfo
	mov	edi,eax		; AX: Copy == 0, Cut == 1
	invoke  tiselected	; get size of selection
	jz	@F
	invoke  ticopyselection
	jz	toend
	dec	eax
	jnz	toend
	test	edi,edi
	jz	@F
	invoke  ticlipdel
     @@:
	invoke  ticlipset
  toend:
	sub	eax,eax
	ret
ticlipcut endp

titostartofselection proc private uses edi
	mov	edi,[edx].ti_loff
	mov	eax,[edx].ti_yoff
	mov	ecx,edi
	add	ecx,eax
	sub	ecx,[edx].ti_clsl
	test	ecx,ecx		; subtract AX then DI while CX--
	je	done
	cmp	eax,ecx
	jb	@F
	sub	eax,ecx
	jmp	done
     @@:
	sub	ecx,eax
	xor	eax,eax
	sub	edi,ecx
   done:
	mov	[edx].ti_loff,edi
	mov	[edx].ti_yoff,eax
	mov	eax,[edx].ti_clso
	invoke  tialignx
	ret
titostartofselection endp

ticlipdel proc uses esi edi ebx
	invoke  tiselected
	mov	edi,ecx		; DI line count selected
	jz	toend
	invoke  titostartofselection
	mov	eax,[edx].ti_clsl
	invoke  tigetline	; get line
	jz	toend
	test	edi,edi
	jnz	@F
	or	[edx].ti_flag,_T_MODIFIED
	mov	ecx,eax		; single line -- copy(start,end)
	add	eax,[edx].ti_clso
	add	ecx,[edx].ti_cleo
	invoke  strcpy,eax,ecx
	jmp	set
     @@:
	mov	esi,eax
	sub	eax,eax
	add	esi,[edx].ti_clso
	mov	[esi],al
	mov	eax,[edx].ti_clel
	invoke  tigetline	; get last selected line
	jz	toend
	or	[edx].ti_flag,_T_MODIFIED
	mov	ecx,eax		; copy(last line,end)
	add	ecx,[edx].ti_cleo
	invoke  strcpy,eax,ecx
	dec	edi
	jz	delete
	mov	esi,[edx].ti_clsl
	inc	esi
	mov	eax,[edx].ti_lcnt
	sub	eax,esi
	mov	ebx,edi
	mov	ecx,[edx].ti_bcol
	shr	ecx,8
	add	ecx,7
	mov	edi,esi
	shl	edi,cl
	add	edi,[edx].ti_bp
	mov	esi,ebx
	shl	esi,cl
	add	esi,edi
	shl	eax,cl
	shr	eax,2
	mov	ecx,eax
	rep	movsd
	sub	[edx].ti_lcnt,ebx
 delete:
	invoke  tidelete
    set:
	invoke  tiseto
	invoke  ticlipset
	sub	eax,eax
	inc	eax
  toend:
	ret
ticlipdel endp

ticlipget proc private uses esi edi ebx
	mov	esi,tinfo
	mov	eax,[esi].S_TINFO.ti_flag
	test	eax,_T_OVERWRITE
	jz	@F
	invoke  ticlipdel
	jmp	paste
     @@:
	invoke  ticlipset
  paste:
	invoke  ClipboardPaste
	jz	toend
	push	[esi].S_TINFO.ti_yoff
	push	[esi].S_TINFO.ti_loff
	push	[esi].S_TINFO.ti_xoff
	push	[esi].S_TINFO.ti_boff
	mov	esi,clipbsize
	mov	edi,eax
	mov	edx,eax		; Problem of inserting text by pushing
	mov	ecx,esi		; a long line in front - EOL == abort
	mov	eax,0Ah		; Insert '\n' if clipboard contain a '\n'
	repne	scasb		; then move back to prev pos
	mov	edi,edx
	jne	do
	mov	ebx,esi
	cmp	[edi+ebx-1],al
	jne	@F
	mov	[edi+ebx-1],ah
     @@:
	invoke  tiputc
	cmp	eax,_TI_CONTINUE
	jne	break
	mov	edx,tinfo
	mov	eax,[esp]
	mov	[edx].ti_boff,eax
	mov	eax,[esp+4]
	mov	[edx].ti_xoff,eax
	mov	eax,[esp+8]
	mov	[edx].ti_loff,eax
	mov	eax,[esp+12]
	mov	[edx].ti_yoff,eax
	mov	esi,clipbsize
     do:
	mov	al,[edi]
	test	al,al
	jz	break
	inc	edi
	invoke  tiputc
	cmp	eax,_TI_CONTINUE
	jne	break
	dec	esi
	jnz	do
  break:
	mov	esi,tinfo
	pop	eax
	pop	ecx
	mov	[esi].S_TINFO.ti_boff,eax
	mov	[esi].S_TINFO.ti_xoff,ecx
	pop	ecx
	pop	eax
	mov	[esi].S_TINFO.ti_yoff,eax
	mov	[esi].S_TINFO.ti_loff,ecx
  toend:
	invoke  ticlipset
	xor	eax,eax
	ret
ticlipget endp

ticlip_INS:
	invoke  GetShiftState
	jz	@F
	invoke  ticlipget
	mov	eax,_TI_CONTINUE
     @@:
	ret

ticlip_Copy:
	sub	eax,eax
	jmp	ticlipcut

ticlip_Cut:
	mov	eax,1
	jmp	ticlipcut

.data

cl_proctable label dword
	dd ticlip_Copy
	dd ticlip_Copy
	dd ticlipget
;	dd ticlip_Cut
	dd ticlip_Cut

cl_keytable label dword
	dd KEY_CTRLINS
	dd KEY_CTRLC
	dd KEY_CTRLV
;	dd KEY_CTRLX
	dd KEY_CTRLDEL
cl_keycount = (($ - offset cl_keytable) / 4)

cl_shiftkeytable label dword
	dd KEY_HOME
	dd KEY_LEFT
	dd KEY_RIGHT
	dd KEY_END
    ifdef __TE__
	dd KEY_UP
	dd KEY_DOWN
	dd KEY_PGUP
	dd KEY_PGDN
    endif
cl_shiftkeycount = (($ - offset cl_shiftkeytable) / 4)

cl_nodeletekeys label dword
	dd KEY_ESC
    ifdef __MOUSE__
	dd MOUSECMD
    endif
	dd KEY_BKSP
	dd KEY_ENTER
	dd KEY_KPENTER
cl_nodeletecount = (($ - offset cl_nodeletekeys) / 4)

.code

ticlipevent proc uses esi edi ebx
	mov	esi,eax
	invoke  tiselected
	jnz	@F
	invoke  ticlipset
     @@:
	xor	edi,edi
	mov	ecx,cl_keycount
	jmp	ticlipevent_loop
    ticlipevent_found:
	call	cl_proctable[edi]
	jmp	ticlipevent_end
    ticlipevent_loop:
	cmp	esi,cl_keytable[edi]
	je	ticlipevent_found
	add	edi,4
	dec	ecx
	jnz	ticlipevent_loop
	mov	ebx,keyshift
	mov	al,[ebx]
	and	al,KEY_SHIFT
	jnz	@F
	cmp	esi,KEY_DEL
	jne	ticlipevent_ESC
	invoke  ticlipdel
	jz	ticlipevent_set
	xor	eax,eax
	jmp	ticlipevent_end
      @@:
	cmp	esi,KEY_INS
	jne	@F
	invoke  ticlipget
	jmp	ticlipevent_end
      @@:
	cmp	esi,KEY_DEL
	jne	@F
	mov	eax,1
	invoke  ticlipcut
	jmp	ticlipevent_end
      @@:
	mov	edi,offset cl_shiftkeytable
	mov	ecx,cl_shiftkeycount
ifdef __TE__
	mov	ebx,tinfo
	test	[ebx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	sub	ecx,4
endif
     @@:
	cmp	esi,[edi]
	je	ticlipevent_MOVE
	add	edi,4
	dec	ecx
	jnz	@B
    ticlipevent_ESC:
	mov	ecx,cl_nodeletecount
	xor	edi,edi
     @@:
	cmp	esi,cl_nodeletekeys[edi]
	je	ticlipevent_set
	add	edi,4
	dec	ecx
	jnz	@B
	mov	eax,esi
	test	al,al
	jz	ticlipevent_set
ifdef __TE__
	mov	ebx,tinfo
	test	[ebx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	cmp	esi,KEY_TAB
	je	ticlipevent_set
      @@:
endif
	invoke  ticlipdel
    ticlipevent_set:
	invoke  ticlipset
	mov	eax,esi
    ticlipevent_end:
	ret
    ticlipevent_MOVE:
	mov	eax,esi
	invoke  tievent
	cmp	eax,_TI_CMFAILED
	je	ticlipevent_nul
	cmp	eax,_TI_RETEVENT
	je	ticlipevent_nul
	mov	ebx,tinfo
ifdef __TE__
	mov	ecx,[ebx].S_TINFO.ti_loff
	add	ecx,[ebx].S_TINFO.ti_yoff
	cmp	ecx,[ebx].S_TINFO.ti_clsl
	jb	ticlipevent_MOVEBACK
endif
	mov	eax,[ebx].S_TINFO.ti_boff
	add	eax,[ebx].S_TINFO.ti_xoff
	cmp	eax,[ebx].S_TINFO.ti_clso
	jb	ticlipevent_MOVEBACK
	cmp	esi,KEY_RIGHT
	jne	@F
	mov	edx,eax
	dec	edx
	cmp	edx,[ebx].S_TINFO.ti_clso
	jne	@F
	cmp	edx,[ebx].S_TINFO.ti_cleo
	jne	ticlipevent_MOVEBACK
     @@:
	mov	[ebx].S_TINFO.ti_cleo,eax
ifdef __TE__
	mov	[ebx].S_TINFO.ti_clel,ecx
endif
	jmp	ticlipevent_nul
    ticlipevent_MOVEBACK:
	mov	[ebx].S_TINFO.ti_clso,eax
ifdef __TE__
	mov	[ebx].S_TINFO.ti_clsl,ecx
endif
    ticlipevent_nul:
	sub	eax,eax
	jmp	ticlipevent_end
ticlipevent endp

	END
