include keyb.inc

SCROLLLOCK_ON		equ 40h
CAPSLOCK_ON		equ 80h
NUMLOCK_ON		equ 20h
ENHANCED_KEY		equ 100h
RIGHT_ALT_PRESSED	equ 1h
RIGHT_CTRL_PRESSED	equ 4h

.code

	ASSUME  ebx:ptr INPUT_RECORD

UpdateKeyEvent proc uses esi ebx pInput:ptr INPUT_RECORD
	sub	esi,esi
	mov	ebx,pInput
	movzx	eax,[ebx].KeyEvent.wVirtualKeyCode
	mov	keybcode,al
	mov	al,byte ptr [ebx].KeyEvent.wVirtualScanCode
	mov	keybscan,al
	mov	cl,al
	mov	al,byte ptr [ebx].KeyEvent.Char
	mov	keybchar,al
	mov	eax,keyshift
	mov	edx,[eax]
	mov	eax,[ebx].KeyEvent.dwControlKeyState
	and	edx,not (SHIFT_SCROLL or SHIFT_NUMLOCK or SHIFT_CAPSLOCK or SHIFT_ENHANCED)
	.if eax & SCROLLLOCK_ON
	    or edx,SHIFT_SCROLL
	.endif
	.if eax & NUMLOCK_ON
	    or edx,SHIFT_NUMLOCK
	.endif
	.if eax & CAPSLOCK_ON
	    or edx,SHIFT_CAPSLOCK
	.endif
	.if eax & ENHANCED_KEY
	    or edx,SHIFT_ENHANCED
	.endif
	xchg edx,eax
	.if [ebx].KeyEvent.bKeyDown
	    mov keybstate,1
	    or eax,SHIFT_RELEASEKEY
	    .if cl == 2Ah
		or eax,SHIFT_LEFT
	    .elseif cl == 36h
		or eax,SHIFT_RIGHT
	    .elseif cl == 38h
		.if edx & RIGHT_ALT_PRESSED
		    or eax,SHIFT_ALT
		.else
		    or eax,SHIFT_ALTLEFT or SHIFT_ALT
		.endif
	    .elseif cl == 1Dh
		.if edx & RIGHT_CTRL_PRESSED
		    or eax,SHIFT_CTRL
		.else
		    or eax,SHIFT_CTRLLEFT or SHIFT_CTRL
		.endif
	    .elseif cl == 46h
		or eax,SHIFT_SCROLLKEY
	    .elseif cl == 3Ah
		or eax,SHIFT_CAPSLOCKKEY
	    .elseif cl == 45h
		or eax,SHIFT_NUMLOCKKEY
	    .elseif cl == 52h && keybcode == 2Dh
		or eax,SHIFT_INSERTKEY
		xor eax,SHIFT_INSERTSTATE
		mov esi,5200h
	    .elseif cl == 57h
		mov esi,8500h	; F11
	    .elseif cl == 58h
		mov esi,8600h	; F12
	    .else
		mov dl,keybchar
		mov dh,cl
		and edx,0000FFFFh
		mov esi,edx
	    .endif
	.else
	    mov keybstate,0
	    and eax,not SHIFT_RELEASEKEY
	    .if cl == 2Ah
		and eax,not SHIFT_LEFT
	    .elseif cl == 36h
		and eax,not SHIFT_RIGHT
	    .elseif cl == 38h
		and eax,not (SHIFT_ALT or SHIFT_ALTLEFT)
	    .elseif cl == 1Dh
		and eax,not (SHIFT_CTRL or SHIFT_CTRLLEFT)
	    .elseif cl == 46h
		and eax,not SHIFT_SCROLLKEY
	    .elseif cl == 3Ah
		and eax,not SHIFT_CAPSLOCKKEY
	    .elseif cl == 45h
		and eax,not SHIFT_NUMLOCKKEY
	    .elseif cl == 52h
		and eax,not SHIFT_INSERTKEY
	    .endif
	.endif
	mov ecx,keyshift
	mov [ecx],eax
	mov eax,esi
	ret
UpdateKeyEvent endp

	end
