include iost.inc

	.code

	assume  edx:ptr S_IOST
	assume  ebx:ptr S_IOST

ocopyst proc uses esi edi ebx ost, ist, len:qword
	sub	eax,eax
	mov	edx,ist
	mov	ebx,ost
	mov	esi,dword ptr len[4]
	mov	edi,dword ptr len
	test	esi,esi
	jnz	@F
	test	edi,edi
	jz	ocopy_success
     @@:
	mov	ecx,[edx].ios_c		; if count is zero -- file copy
	sub	ecx,[edx].ios_i
	jnz	@F
	mov	eax,edx
	invoke  ogetcst
	jz	ocopy_end
	dec	[edx].ios_i
	mov	ecx,[edx].ios_c
	sub	ecx,[edx].ios_i
	jz	ocopy_end
     @@:
	mov	eax,[ebx].ios_size	; copy max byte from STDI to STDO
	sub	eax,[ebx].ios_i
	cmp	eax,ecx
	ja	@F
	mov	ecx,eax
    @@:
	test	esi,esi
	jnz	@F
	cmp	edi,ecx
	ja	@F
	mov	ecx,edi
    @@:
	mov	eax,ecx
	push	esi
	push	edi
	mov	esi,[edx].ios_bp
	add	esi,[edx].ios_i
	mov	edi,[ebx].ios_bp
	add	edi,[ebx].ios_i
	rep	movsb
	pop	edi
	pop	esi
	add	[ebx].ios_i,eax
	add	[edx].ios_i,eax
	sub	edi,eax
	sbb	esi,0
	mov	eax,edi
	or	eax,esi
	jz	ocopy_success
	mov	eax,[edx].ios_c
	test	eax,eax
	jz	ocopy_block
	sub	eax,[edx].ios_i ; flush inbuf
	jz	ocopy_block
     @@:
	mov	eax,edx
	invoke  ogetcst
	jz	ocopy_end
	mov	edx,ebx
	invoke  oputcst
	mov	edx,ist
	jz	ocopy_end
	sub	edi,eax
	sbb	esi,0
	mov	eax,esi
	or	eax,edi
	jz	ocopy_success	; success if zero (inbuf > len)
	mov	eax,[edx].ios_i
	cmp	eax,[edx].ios_c
	jne	@B		; do byte copy from STDI to STDO
    ocopy_block:
	invoke  oflushst,ebx	; flush STDO
	jz	ocopy_end	; do block copy of bytes left
	push	[ebx].ios_size
	push	[ebx].ios_bp
	mov	eax,[edx].ios_bp
	mov	[ebx].ios_bp,eax
	mov	eax,[edx].ios_size
	mov	[ebx].ios_size,eax
    ocopy_next:
	invoke  ofreadst,edx
	jz	ocopy_eof
	mov	eax,[edx].ios_c		; count
	test	esi,esi
	jnz	ocopy_more
	cmp	eax,edi
	jae	ocopy_last
    ocopy_more:
	sub	edi,eax
	sbb	esi,0
	mov	[ebx].ios_i,eax		; fill STDO
	mov	[edx].ios_i,eax		; flush STDI
	invoke  oflushst,ebx		; flush STDO
	jnz	ocopy_next		; copy next block
    ocopy_exit:
	pop	ecx
	mov	[ebx].ios_bp,ecx
	pop	ecx
	mov	[ebx].ios_size,ecx
	jmp	ocopy_end
    ocopy_success:
	sub	eax,eax
	inc	eax
    ocopy_end:
	ret
    ocopy_last:
	mov	eax,edi
	mov	[edx].ios_i,eax
	mov	[ebx].ios_i,eax
	invoke  oflushst,ebx
	jmp	ocopy_exit
    ocopy_eof:
	sub	eax,eax
	test	esi,esi
	jnz	ocopy_exit
	test	edi,edi
	jnz	ocopy_exit
	inc	eax
	jmp	ocopy_exit
ocopyst endp

	end
