include errno.inc

.data

errnotable label byte
	db EINVAL
	db ENOENT
	db ENOENT
	db EMFILE
	db EACCES
	db EBADF
	db ENOMEM
	db ENOMEM
	db ENOMEM
	db E2BIG
	db ENOEXEC
	db EINVAL
	db EINVAL
	db ENOENT
	db EACCES
	db EXDEV
	db ENOENT
	db EACCES
	db ENOENT
	db EACCES
	db ENOENT
	db EEXIST
	db EACCES
	db EACCES
	db EINVAL
	db EAGAIN
	db EACCES
	db EPIPE
	db ENOSPC
	db EBADF
	db EINVAL
	db ECHILD
	db ECHILD
	db EBADF
	db EINVAL
	db EACCES
	db ENOTEMPTY
	db EACCES
	db ENOENT
	db EAGAIN
	db EACCES
	db EEXIST
	db ENOENT
	db EAGAIN
	db ENOMEM

syserrtable label byte
	db ERROR_INVALID_FUNCTION
	db ERROR_FILE_NOT_FOUND
	db ERROR_PATH_NOT_FOUND
	db ERROR_TOO_MANY_OPEN_FILES
	db ERROR_ACCESS_DENIED
	db ERROR_INVALID_HANDLE
	db ERROR_ARENA_TRASHED
	db ERROR_NOT_ENOUGH_MEMORY
	db ERROR_INVALID_BLOCK
	db ERROR_BAD_ENVIRONMENT
	db ERROR_BAD_FORMAT
	db ERROR_INVALID_ACCESS
	db ERROR_INVALID_DATA
	db ERROR_INVALID_DRIVE
	db ERROR_CURRENT_DIRECTORY
	db ERROR_NOT_SAME_DEVICE
	db ERROR_NO_MORE_FILES
	db ERROR_LOCK_VIOLATION
	db ERROR_BAD_NETPATH
	db ERROR_NETWORK_ACCESS_DENIED
	db ERROR_BAD_NET_NAME
	db ERROR_FILE_EXISTS
	db ERROR_CANNOT_MAKE
	db ERROR_FAIL_I24
	db ERROR_INVALID_PARAMETER
	db ERROR_NO_PROC_SLOTS
	db ERROR_DRIVE_LOCKED
	db ERROR_BROKEN_PIPE
	db ERROR_DISK_FULL
	db ERROR_INVALID_TARGET_HANDLE
	db ERROR_INVALID_HANDLE
	db ERROR_WAIT_NO_CHILDREN
	db ERROR_CHILD_NOT_COMPLETE
	db ERROR_DIRECT_ACCESS_HANDLE
	db ERROR_NEGATIVE_SEEK
	db ERROR_SEEK_ON_DEVICE
	db ERROR_DIR_NOT_EMPTY
	db ERROR_NOT_LOCKED
	db ERROR_BAD_PATHNAME
	db ERROR_MAX_THRDS_REACHED
	db ERROR_LOCK_FAILED
	db ERROR_ALREADY_EXISTS
	db ERROR_FILENAME_EXCED_RANGE
	db ERROR_NESTING_NOT_ALLOWED
	db ERROR_NOT_ENOUGH_QUOTA

.code

osmaperr proc
	push	ebx
	invoke  GetLastError
	mov	edx,eax
	mov	doserrno,eax
	sub	ecx,ecx
	jmp	osmaperr_loop
    osmaperr_next:
	mov	ebx,ecx
	cmp	dl,syserrtable[ebx]
	jnz	osmaperr_01
	sub	eax,eax
	mov	al,errnotable[ebx]
	mov	errno,eax
	jmp	osmaperr_end
    osmaperr_01:
	inc	ecx
    osmaperr_loop:
	cmp	ecx,45
	jl	osmaperr_next
	cmp	edx,ERROR_WRITE_PROTECT
	jb	osmaperr_37
	cmp	edx,ERROR_SHARINGBUF_EXCEEDED
	ja	osmaperr_37
	mov	errno,EACCES
	jmp	osmaperr_end
    osmaperr_37:
	cmp	edx,ERROR_INVALID_CODESEG
	jb	osmaperr_22
	cmp	edx,ERROR_LOOP_IN_RELOC_CHAIN
	ja	osmaperr_22
	mov	errno,ENOEXEC
	jmp	osmaperr_end
    osmaperr_22:
	mov	errno,EINVAL
    osmaperr_end:
	pop	ebx
	mov	eax,-1
	ret
osmaperr endp

	END
