include	dir.inc
include	string.inc
include	errno.inc
include	alloc.inc
include	string.inc

	.code

getdcwd	proc uses ebx buffer:ptr byte, drive:size_t, maxlen:size_t
local dirbuf[WMAXPATH]:byte
local drvstr[4]:byte
local pname:dword
	mov ebx,drive
	.if ebx
	    .if !validdrive(ebx)
		mov doserrno,ERROR_INVALID_DRIVE
		mov errno,EACCES
		jmp @F
	    .endif
	    mov eax,'A' - 1
	    add eax,ebx
	    mov drvstr[0],al
	    mov drvstr[1],':'
	    mov drvstr[2],'.'
	    mov drvstr[3],0
	    invoke GetFullPathName,addr drvstr,WMAXPATH,addr dirbuf,addr pname
	.else
	    invoke GetCurrentDirectory,WMAXPATH,addr dirbuf
	.endif
	.if !eax || eax >= WMAXPATH
	    sub eax,eax
	    jmp @F
	.endif
	.if !buffer
	    .if !malloc(WMAXPATH)
		mov errno,ENOMEM
		sub eax,eax
		jmp @F
	    .endif
	    mov buffer,eax
	.elseif eax > maxlen
	    mov errno,ERANGE
	    sub eax,eax
	    jmp @F
	.endif
	invoke strcpy,buffer,addr dirbuf
      @@:
	ret
getdcwd	endp

getcwd	proc buffer:ptr byte, maxlen:size_t
	invoke getdcwd,buffer,0,maxlen
	ret
getcwd	endp

	END
