include doszip.inc
include stdio.inc
include stdlib.inc
include io.inc
include string.inc
include process.inc
include alloc.inc

doszip_init	proto :dword
doszip_open	proto
doszip_modal	proto
doszip_close	proto
;
; NTFS - New Technology File System
;
; Maximum number of files on disk: 4,294,967,295
; Maximum number of files in a single folder: 4,294,967,295
;
.data

copyright label byte
	db 'The Doszip Commander Version ',VERSSTR,', '
	db 'Copyright (c) 1997-2014 Hjort Nidudsson',10,10,0
cp_usage label byte
	db 'Command line switches',10
	db ' The following switches may be used in the command line:',10
	db 10
	db '  -N<file_count> - Maximum number of files in each panel',10
	db '	 default is 5000.',10
	db 10
	db '  -C<config_path> - Read/Write setup from/to <config_path>',10
	db 10
	db '  DZ <filename> command starts DZ and forces it to show <filename>',10
	db 'contents if it is an archive or show folder contents if <filename>',10
	db 'is a folder.',10,0

.code

main proc c uses esi edi ebx
	sub edi,edi
	mov eax,1
	.if eax < _argc
	    mov esi,eax
	    .repeat
		mov eax,_argv
		mov ebx,[eax+esi*4]
		mov al,[ebx]
		.if al == '?'
		    jmp ExitUsage
		.elseif al == '/' || al == '-'
		    inc ebx
		    mov al,[ebx]
		    or  al,20h
		    .if al == 'n'
			inc ebx
			.if strtol(ebx)
			    mov numfblock,eax
			.endif
		    .elseif al == 'c'
			inc ebx
			.if filexist(ebx) == 2
			    invoke strcpy,addr configpath,ebx
			.else
			    jmp ExitUsage
			.endif
		    .else
			jmp ExitUsage
		    .endif
		.else
		    mov edi,ebx
		.endif
		inc esi
	    .until esi >= _argc
	.endif
	.if !doszip_init(edi)
	    invoke _print,addr copyright
	    invoke doszip_open
	    invoke doszip_modal
	    invoke doszip_close
	    .if cflag & _C_DELHISTORY
		invoke historyremove
	    .else
		invoke historywrite
	    .endif
  ifdef __TE__
	    invoke tcloseall
  endif
  ifdef __INI_LOAD__
	    invoke ExecuteSection,"Exit"
  endif
	    sub eax,eax
	.endif
     @@:
	ret
ExitUsage:
	invoke _print,addr copyright
	invoke _print,addr cp_usage
	sub eax,eax
	jmp @B
main	endp

	END
