include doszip.inc
include ini.inc
include tview.inc
include string.inc
include stdlib.inc
include keyb.inc
ifdef __DLL__
include dll.inc
endif
ifdef __ZIP__
include io.inc
include time.inc
include progress.inc
endif

.data

cp_F3		db 'F3',0
cp_F4		db 'F4',0
cp_Alt		db 'Alt',0
cp_Ctrl		db 'Ctrl',0
cp_Shift	db 'Shift',0
cp_section_view db 'View',0
cp_argerror	db 'TVIEW error: %s',0
ifdef __ZIP__
cp_unziptotemp  db 'Unzip file to TEMP',0
cp_missingTEMP  db 'Bad or missing TEMP directory',0
endif

.code

; type 4: F4	- edit
; type 3: Alt	- edit/view
; type 2: Ctrl  - edit/view
; type 1: Shift - edit/view
; type 0: F3	- view

loadiniproc proc uses esi edi section:dword, filename:dword, itype:dword
local	path[WMAXPATH]:byte
	mov edi,filename
	mov al,byte ptr itype
	.if al == 4
	    mov eax,offset cp_F4
	.elseif al == 3
	    mov eax,offset cp_Alt
	.elseif al == 2
	    mov eax,offset cp_Ctrl
	.elseif al == 1
	    mov eax,offset cp_Shift
	.else
	    mov eax,offset cp_F3
	.endif
	.if inientry(section,eax)
	    mov edx,eax
	    invoke strncpy,addr path,edx,WMAXPATH-1
	    invoke strlen,eax
	    mov edx,eax
	    invoke strlen,edi
	    add eax,edx
	    .if eax < WMAXPATH
		invoke cmdlparse,addr path,edi
		invoke command,addr path
		mov eax,1
	    .else
		xor eax,eax
	    .endif
	.endif
	ret
loadiniproc endp

load_tview proc uses esi edi filename:dword, etype:dword
local offs:dword
	mov edi,filename
	.if !loadiniproc(addr cp_section_view,edi,etype)
	    call clrcmdl
	    mov esi,edi
	    xor eax,eax
	    mov offs,eax
	    .while 1	; %view% [-options] [file]
		lodsb
		.break .if !al
		.if al == '"'
		    mov edi,esi ; start of "file name"
		    @@:
			lodsb
			.if !al
			    jmp ltview_argerror
			.endif
			cmp al,'"'
			jne @B
			xor eax,eax
			mov [esi-1],al
		    .break
		.elseif al == '/' && byte ptr [esi-2] == ' '
		    lodsb
		    or al,20h
		    .if al == 't'
			and tvflag,not _TV_HEXVIEW
		    .elseif al == 'h'
			or tvflag,_TV_HEXVIEW
		    .elseif al == 'o'		; -o<offset> - Start offset
			invoke strtol,esi
			mov offs,eax
		    .else
			jmp ltview_argerror
		    .endif
		    .while 1
			lodsb
			.break .if al <= ' '
		    .endw
		    .break .if !al
		    mov edi,esi
		.endif
	    .endw
	    invoke tview,edi,offs
	    xor eax,eax
	.endif
      @@:
	ret
ltview_argerror:
	invoke ermsg,0,addr cp_argerror,edi
	dec eax
	jmp @B
load_tview endp

ifdef __ZIP__

unzip_to_temp proc private uses esi edi
	mov edi,eax	; AX &FBLK
	.if envtemp	; return: AX == BX == %TEMP%\name
	    invoke progress_open,addr cp_unziptotemp,addr cp_copy
	    invoke progress_set,
		addr [edi].S_FBLK.fb_name,
		envtemp,
		dword ptr [edi].S_FBLK.fb_size
	    mov eax,cpanel
	    invoke wsdecomp,[eax].S_PANEL.pn_wsub,edi,envtemp
	    invoke progress_close
	    .if !eax
		add edi,S_FBLK.fb_name
		invoke strfcat,ebx,envtemp,edi
	    .else
		xor eax,eax
	    .endif
	.else
	    invoke ermsg,0,addr cp_missingTEMP
	.endif
	test eax,eax
	ret
unzip_to_temp endp

viewzip proc private uses edi
	mov eax,edx
	mov edi,ecx
	.if unzip_to_temp()
	    invoke load_tview,eax,edi
	    invoke setfattr,ebx,0
	    invoke remove,ebx
	    mov eax,1
	.endif
	ret
viewzip endp

ifdef __TE__

zipadd  proc private uses esi edi archive:dword, path:dword, file:dword
	invoke strcpy,addr __srcfile,file
	invoke strcpy,addr __srcpath,eax
	invoke strpath,eax
	invoke strcpy,addr __outpath,path
	invoke strcpy,addr __outfile,archive
	.if osopen(file,_A_NORMAL,M_RDONLY,A_OPEN) != -1
	    mov esi,eax
	    .if filelength(eax)
		mov edi,eax
		invoke close,esi
		invoke dostime
		push eax
		invoke getfattr,file
		pop edx
		invoke wzipadd,edi,edx,eax
	    .else
		invoke close,esi
		dec eax
	    .endif
	.endif
	ret
zipadd  endp

editzip proc uses esi edi
	mov eax,edx
	mov edi,ecx
	.if unzip_to_temp()
	    mov edx,_diskflag
	    mov esi,[edx]
	    invoke setfattr,eax,0
	    mov eax,_diskflag
	    mov byte ptr [eax],0
	    invoke tedit,ebx,0
	    mov eax,_diskflag
	    mov eax,[eax]
	    .if eax
		mov eax,cpanel
		mov eax,[eax]
		lea edx,[eax].S_PATH.wp_arch
		add eax,S_PATH.wp_file
		invoke zipadd,eax,edx,ebx
	    .else
		mov eax,_diskflag
		mov [eax],esi
	    .endif
	    invoke remove,ebx
	.endif
	ret
editzip endp

 endif ; __TE__
endif ; __ZIP__

TVGetCurrentFile proc uses edi buffer:dword
	xor edi,edi		; 0 (F3 or F4)
	mov eax,keyshift	; test shift state for F3 or F4
	mov al,[eax]
	.if al & KEY_SHIFT	; 1 (Shift)
	    mov edi,1
	.elseif al & KEY_CTRL	; 2 (Ctrl)
	    mov edi,2
	.elseif al & KEY_ALT	; 3 (Alt)
	    mov edi,3
	.endif
	mov eax,cpanel
	.if panel_curobj()
	    xchg eax,ecx
	    .if eax & _FB_ARCHIVE
		.if eax & _A_SUBDIR
		    xor eax,eax		; 0 (subdir in archive)
		.else
ifdef __DLL__
		    .if eax & _FB_ARCHEXT
			mov eax,4	; 4 (plugin)
		    .else
			mov eax,2	; 2 (zip)
		    .endif
else
		     mov eax,2  ; 2 (zip)
endif
		.endif
	    .else
		.if eax & _A_SUBDIR
		    mov eax,3		; 3 (subdir)
		.else
		    mov eax,cpanel	; 1 (file)
		    mov eax,[eax].S_PANEL.pn_path
		    add eax,S_PATH.wp_path
		    invoke strfcat,buffer,eax,ecx
		    mov eax,1
		.endif
	    .endif
	.endif
	mov ecx,edi
	ret
TVGetCurrentFile endp

cmview proc uses ebx
local fname[WMAXPATH*2]:byte
	lea ebx,fname
	.if TVGetCurrentFile(ebx) == 1
	    invoke load_tview,ebx,ecx
	.elseif eax == 3
	    invoke cmsubsize
ifdef __ZIP__
	.elseif eax == 2
	    invoke viewzip
endif
ifdef __DLL__
	.elseif eax == 4
	    mov ecx,ebx
	    mov ebx,cpanel
	    mov ebx,[ebx].S_PANEL.pn_wsub
	    invoke dll_call,_DLL_VIEW,ebx,edx,ecx,0
endif
	.endif
	ret
cmview  endp

	END
