include doszip.inc
include io.inc
include keyb.inc
include string.inc

; (PG)UP,DOWN:  Move
; ESC,TAB,ALTX: Quit
; ENTER:	Quit
; BKSP:		Search from start
; insert char:  Search from current pos.

;SKIPSUBDIR = 1 ; Exclude directories in search

.data

cp_quicksearch  db '&Quick Search: ',1Ah,'   ',0
cmquicksearch_keys label dword
	dd 0,KEY_ESC,KEY_TAB,KEY_ALTX,KEY_ENTER,KEY_KPENTER
	dd KEY_LEFT,KEY_RIGHT,KEY_UP,KEY_PGUP,KEY_DOWN,KEY_PGDN
	dd KEY_HOME,KEY_END,KEY_BKSP
cmquicksearch_label label dword
	dd event_loop,event_exit,event_exit,event_exit,event_enter
	dd event_enter,event_pevent,event_pevent,event_pevent,event_pevent
	dd event_pevent,event_pevent,event_pevent,event_pevent,event_bksp
cmquicksearch_count = ($ - cmquicksearch_label) / 4

.code

psearch proc private uses esi edi ebx cname:dword, l:dword, direction:dword
local	fcb:dword
local	cindex:dword
local	lindex:dword
	mov	ebx,cpanel		; current index
	mov	esi,[ebx].S_PANEL.pn_fcb_index
	add	esi,[ebx].S_PANEL.pn_cel_index
	mov	lindex,esi
	mov	cindex,esi
	mov	edi,[ebx].S_PANEL.pn_fcb_count
	mov	ebx,[ebx].S_PANEL.pn_wsub
	mov	eax,direction
	test	eax,eax			; if (direction == 0) search from start
	mov	eax,[ebx].S_WSUB.ws_fcb
	mov	fcb,eax
	jz	psearch_all		; (case BKSP)
    psearch_loop:
	cmp	esi,edi			; search from current to end
	jnb	psearch_start
	mov	ebx,fcb
	mov	ebx,[ebx+esi*4]
  ifdef SKIPSUBDIR
	test	byte ptr [ebx],_A_SUBDIR
	jnz	psearch_next
  endif
	invoke  strnicmp,cname,addr [ebx].S_FBLK.fb_name,l
	test	eax,eax
	jz	psearch_match
    psearch_next:
	inc	esi
	jmp	psearch_loop
    psearch_all:
	mov	lindex,edi
    psearch_start:
	xor	esi,esi
	mov	edi,lindex
	mov	lindex,esi
	cmp	esi,edi
	jne	psearch_loop
	xor	eax,eax
	jmp	psearch_end
    psearch_match:
	mov	ebx,cpanel
	invoke  dlclose,[ebx].S_PANEL.pn_xl
	mov	eax,ebx
	mov	edx,esi
	invoke  panel_setid
	invoke  panel_putitem,ebx,0
	mov	eax,ebx
	invoke  pcell_show
	mov	eax,1
    psearch_end:
	mov	edx,cindex
	ret
psearch endp

event_pevent:
	invoke  panel_event,cpanel,eax
event_loop:
	sub	eax,eax
	ret
event_bksp:			; delete char and search from start
	cmp	esi,15
	jle	event_loop
	dec	esi
	mov	edx,edi
	invoke  scputw,esi,edi,2,' '
	invoke  gotoxy,esi,edi
	xor	eax,eax
	mov	ecx,15
event_back:
	push	eax
	mov	edx,esi
	sub	edx,ecx
	invoke  psearch,ebx,edx,eax
	test	eax,eax
	pop	eax
	jz	event_loop
	test	eax,eax
	jz	event_loop
	invoke  scputw,esi,edi,1,eax
	cmp	esi,78
	jge	event_loop
	inc	esi
	invoke  gotoxy,esi,edi
	jmp	event_loop
event_enter:
	mov	eax,esi
	sub	eax,15
	invoke  psearch,ebx,eax,1
  ifdef SKIPSUBDIR
	jmp	event_loop
  else
	test	eax,eax
	jz	event_loop
	mov	ecx,cpanel
	mov	eax,[ecx].S_PANEL.pn_fcb_index
	add	eax,[ecx].S_PANEL.pn_cel_index
	cmp	eax,edx
	jne	event_loop
  endif
event_exit:
	mov eax,1
	ret

cmquicksearch proc uses esi edi ebx
local cursor:S_CURSOR
local stline[256]:word
local fname[256]:byte
	.if cpanel_state()
	    invoke cursorget,addr cursor
	    invoke cursoron
	    invoke wcpushst,addr stline,addr cp_quicksearch
	    lea	   ebx,fname
	    mov	   esi,15		; SI = x
	    mov	   edi,_scrrow		; DI = y
	    invoke gotoxy,esi,edi	; cursor to (x,y)
	    .repeat
		call tupdate
		invoke getkey		; get key
		.continue .if !eax
		mov ecx,cmquicksearch_count	; test key
		xor edx,edx
		.repeat
		    .break .if eax == cmquicksearch_keys[edx]
		    add edx,4
		.untilcxz
		.if ecx
		    call cmquicksearch_label[edx]
		.else
		    movzx eax,al
		    mov [ebx+esi-15],al
		    mov ecx,14
		    call event_back
		.endif
	    .until eax
	    invoke wcpopst,addr stline
	    invoke cursorset,addr cursor
	.endif
	sub eax,eax
	ret
cmquicksearch endp

	END
