include doszip.inc
include io.inc
include string.inc
include confirm.inc
include progress.inc
include errno.inc
ifdef __DLL__
include dll.inc
endif
ifdef __ZIP__
include iost.inc
include unzip.inc
extrn	foreslash:byte
extrn	cp_ziptemp:byte
extrn	arc_flength:dword
zip_copyendcentral proto
endif

externdef	cp_delete:byte
setconfirmflag  proto

.data
__spath dd 0

.code

open_progress proc private
	invoke  setconfirmflag
	invoke  progress_open,addr cp_delete,0
	ret
open_progress endp

remove_file proc private uses esi directory:dword, filename:dword, attrib:dword
local path[WMAXPATH*2]:byte
	lea esi,path
	.if !progress_set(filename,directory,0)
	    .if confirm_delete_file(filename,attrib) && eax != -1
		invoke strfcat,esi,directory,filename
		.if byte ptr attrib & _A_RDONLY
		    invoke setfattr,esi,0
		.endif
		mov errno,0
		.if remove(esi)
		    invoke erdelete,esi
		.endif
	    .endif
	.endif
	ret
remove_file endp

remove_directory proc private directory:dword
local path[WMAXPATH*2]:byte
	invoke strfcat,addr path,__spath,directory
	.if confirm_delete_sub(eax) == 1
	    invoke scan_directory,0,addr path
	.endif
	ret
remove_directory endp

fp_remove_file proc private directory:dword, wfblock:dword
	mov	edx,wfblock
	lea	eax,[edx].S_WFBLK.wf_name
	invoke  remove_file,directory,eax,[edx].S_WFBLK.wf_attrib
	ret
fp_remove_file endp

fp_remove_directory proc private directory:dword
	invoke  progress_set,0,directory,1
	jnz	@F
	invoke  scan_files,directory
	push	eax
	invoke  setfattr,directory,0
	invoke  rmdir,directory
	pop	eax
      @@:
	ret
fp_remove_directory endp

ifdef __ZIP__

wsdeletearc proc private uses ebp esi edi
	mov	ebp,eax		; AX --> BP = wsub
	mov	edi,edx		; DX --> DI = fblk
	xor	eax,eax
    delete_zip_file:
	mov	esi,eax
	test	eax,eax		; AX set if repeated call with same directory
	lea	eax,entryname
	jnz	wzipdel_progress
	mov	ecx,[edi].S_FBLK.fb_flag
	lea	eax,[edi].S_FBLK.fb_name
	test	cl,_A_SUBDIR
	jz	@F
	invoke  confirm_delete_sub,eax
	jmp	wzipdel_confirm
      @@:
	invoke  confirm_delete_file,eax,ecx
    wzipdel_confirm:
	test	eax,eax
	jz	wzipdel_end		; 0: Skip file
	inc	eax
	jz	wzipdel_cancel		; -1: Cancel
	invoke  strfcat,addr __srcfile,[ebp].S_WSUB.ws_path,[ebp].S_WSUB.ws_file
	invoke  strcpy,addr __outfile,eax
	invoke  setfext,eax,addr cp_ziptemp
	invoke  strfcat,addr __outpath,[ebp].S_WSUB.ws_arch,addr [edi].S_FBLK.fb_name
	invoke  dostounix,eax
	test	byte ptr [edi].S_FBLK.fb_flag,_A_SUBDIR
	jz	@F
	invoke  strcat,eax,addr foreslash
      @@:
	invoke  strcmp,addr __srcfile,addr __outfile
	test	eax,eax
	jz	wzipdel_err
	mov	eax,offset __outpath
    wzipdel_progress:
	invoke  progress_set,eax,addr __srcfile,arc_flength
	mov	eax,offset __srcfile
	mov	edx,offset __outfile
	invoke  wscopy_open
	cmp	eax,-1
	je	zip_delete_end
	mov	STDO.ios_flag,IO_UPDTOTAL or IO_USEUPD
	test	eax,eax
	jz	zip_delete_error
	;
	; copy compressed data to temp file
	;
	; 0: match directory\*.*
	; 1: exact match -- file or directory/
	;
	xor	esi,1
	invoke  zip_copylocal,esi
	;
	; local offset to Central directory in DX
	;
	inc	eax
	jz	zip_delete_error
	mov	eax,STDO.ios_total
	add	eax,STDO.ios_i
	mov	ecx,zip_endcent.ze_off_cent
	mov	zip_endcent.ze_off_cent,eax
	sub	ecx,eax
	invoke  zip_copycentral,edx,ecx,esi
	;
	; must be found..
	;
	dec	eax
	jnz	zip_delete_error
	;
	;-------- End Central Directory
	;
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	mov	eax,offset __srcfile
	mov	edx,offset __outfile
	invoke  zip_copyendcentral
	inc	eax
	mov	eax,0
	jnz	zip_delete_end
    zip_delete_error:
	invoke  oclose,addr STDI
	mov	eax,offset __outfile
	invoke  wscopy_remove
	mov	eax,esi
	test	eax,eax
	jz	@F
	dec	eax
	dec	eax
      @@:
	inc	eax
    zip_delete_end:
	mov	dl,[edi]
	and	dl,_A_SUBDIR
	jnz	wzipdel_end
	cmp	eax,1
	jne	wzipdel_end
    wzipdel_err:		; 2: ZIP file deleted (Ok)
	cmp	errno,0
	jne	@F
	mov	errno,ENOENT
      @@:
	invoke  erdelete,addr __outpath
	inc	eax
    wzipdel_cancel:
	inc	eax
    wzipdel_end:		; 0: Jump/Ok/Continue
	test	eax,eax
	jnz	wsdeletearc_end
	mov	ecx,[edi]
	test	cl,_A_SUBDIR
	jz	wsdeletearc_end
	inc	eax
	jmp	delete_zip_file
    wsdeletearc_end:
	test	eax,eax
	ret
wsdeletearc endp

cmdeletezip proc private uses ebp edi	; DX = fblk, CX = flag
	mov	edi,edx
	mov	ebp,ecx
	sub	eax,eax
	test	ecx,_FB_ARCHZIP
	jz	cmdeletezip_end
	invoke  open_progress
      @@:
	mov	eax,cpanel
	mov	eax,[eax].S_PANEL.pn_wsub
	mov	edx,edi
	invoke  wsdeletearc
	test	eax,eax
	jnz	@F
	mov	eax,[edi]
	and	eax,not _FB_SELECTED
	mov	[edi],eax
	mov	eax,cpanel
	invoke  panel_findnext
	jz	@F
	mov	edi,edx
	jmp	@B
      @@:
	invoke  progress_close
    cmdeletezip_end:
	ret
cmdeletezip endp

endif ; __ZIP__

cmdelete_remove proc private
	.if cl & _A_SUBDIR
	    invoke remove_directory,eax
	.else
	    mov errno,0
	    invoke remove_file,__spath,eax,ecx
	.endif
	test eax,eax
	ret
cmdelete_remove endp

cmdelete proc uses ebx
	invoke  cpanel_findfirst
	jz	toend
ifdef __ROT__
	test	ecx,_FB_ROOTDIR
	jnz	toend
endif
ifdef __DLL__
	test	ecx,_FB_ARCHEXT
	jz	@F
	mov	ebx,cpanel
	mov	ebx,[ebx].S_PANEL.pn_wsub
	invoke  dll_call,_DLL_DELETE,ebx,edx,0,0
	jmp	toend
      @@:
endif
ifdef __ZIP__
	test	ecx,_FB_ARCHIVE
	jnz	delzip
endif
	mov	ebx,edx
	mov	eax,cpanel
	mov	edx,[eax]
	lea	eax,[edx].S_PATH.wp_path
	mov	__spath,eax
	mov	fp_maskp,offset cp_stdmask
	mov	fp_fileblock,fp_remove_file
	mov	fp_directory,fp_remove_directory
	invoke  open_progress
	mov	edx,ebx
	mov	ecx,[edx].S_FBLK.fb_flag
	lea	eax,[edx].S_FBLK.fb_name
	test	ecx,_FB_SELECTED
	jz	delete1
     @@:
	jz	toend
	invoke  cmdelete_remove
	jnz	toend
	and	[ebx].S_FBLK.fb_flag,not _FB_SELECTED
	mov	eax,cpanel
	invoke  panel_findnext
	mov	ebx,edx
	jmp	@B
delete1:
	invoke  cmdelete_remove
  toend:
	invoke  progress_close
	ret
ifdef __ZIP__
 delzip:
	invoke  cmdeletezip
	jmp	toend
endif
cmdelete endp

	END
