ifndef __LIBC_INC
 include libc.inc
endif

.xlist

ENOERR		equ 0
EPERM		equ 1
ENOENT		equ 2
ESRCH		equ 3
EINTR		equ 4
EIO		equ 5
ENXIO		equ 6
E2BIG		equ 7
ENOEXEC		equ 8
EBADF		equ 9
ECHILD		equ 10
EAGAIN		equ 11
ENOMEM		equ 12
EACCES		equ 13
EFAULT		equ 14
ENOTBLK		equ 15
EBUSY		equ 16
EEXIST		equ 17
EXDEV		equ 18
ENODEV		equ 19
ENOTDIR		equ 20
EISDIR		equ 21
EINVAL		equ 22
ENFILE		equ 23
EMFILE		equ 24
ENOTTY		equ 25
ETXTBSY		equ 26
EFBIG		equ 27
ENOSPC		equ 28
ESPIPE		equ 29
EROFS		equ 30
EMLINK		equ 31
EPIPE		equ 32
EDOM		equ 33
ERANGE		equ 34
EUCLEAN		equ 35
EDEADLK		equ 36
EUNKNOWN	equ 37
ENAMETOOLONG	equ 38
ENOLCK		equ 39
ENOSYS		equ 40
ENOTEMPTY	equ 41
EILSEQ		equ 42

ERROR_INVALID_FUNCTION		equ 1
ERROR_FILE_NOT_FOUND		equ 2
ERROR_PATH_NOT_FOUND		equ 3
ERROR_TOO_MANY_OPEN_FILES	equ 4
ERROR_ACCESS_DENIED		equ 5
ERROR_INVALID_HANDLE		equ 6
ERROR_ARENA_TRASHED		equ 7
ERROR_NOT_ENOUGH_MEMORY		equ 8
ERROR_INVALID_BLOCK		equ 9
ERROR_BAD_ENVIRONMENT		equ 10
ERROR_BAD_FORMAT		equ 11
ERROR_INVALID_ACCESS		equ 12
ERROR_INVALID_DATA		equ 13
ERROR_INVALID_DRIVE		equ 15
ERROR_CURRENT_DIRECTORY		equ 16
ERROR_NOT_SAME_DEVICE		equ 17
ERROR_NO_MORE_FILES		equ 18
ERROR_WRITE_PROTECT		equ 19
ERROR_NOT_ENOUGH_QUOTA		equ 24
ERROR_LOCK_VIOLATION		equ 33
ERROR_SHARINGBUF_EXCEEDED	equ 36
ERROR_BAD_NETPATH		equ 53
ERROR_NETWORK_ACCESS_DENIED	equ 65
ERROR_BAD_NET_NAME		equ 67
ERROR_FILE_EXISTS		equ 80
ERROR_CANNOT_MAKE		equ 82
ERROR_FAIL_I24			equ 83
ERROR_INVALID_PARAMETER		equ 87
ERROR_NO_PROC_SLOTS		equ 89
ERROR_DRIVE_LOCKED		equ 108
ERROR_BROKEN_PIPE		equ 109
ERROR_DISK_FULL			equ 112
ERROR_INVALID_TARGET_HANDLE	equ 114
ERROR_INVALID_LEVEL		equ 124
ERROR_WAIT_NO_CHILDREN		equ 128
ERROR_CHILD_NOT_COMPLETE	equ 129
ERROR_DIRECT_ACCESS_HANDLE	equ 130
ERROR_NEGATIVE_SEEK		equ 131
ERROR_SEEK_ON_DEVICE		equ 132
ERROR_DIR_NOT_EMPTY		equ 145
ERROR_NOT_LOCKED		equ 158
ERROR_BAD_PATHNAME		equ 161
ERROR_MAX_THRDS_REACHED		equ 164
ERROR_LOCK_FAILED		equ 167
ERROR_ALREADY_EXISTS		equ 183
ERROR_INVALID_CODESEG		equ 188
ERROR_LOOP_IN_RELOC_CHAIN	equ 202
ERROR_FILENAME_EXCED_RANGE	equ 206
ERROR_NESTING_NOT_ALLOWED	equ 215

ER_ZIP		equ 2
ER_BADERR	equ 3
ER_MEM		equ 4
ER_CRCERR	equ 5
ER_NOZIP	equ 9
ER_FIND		equ 11
ER_OPEN		equ 12
ER_DISK		equ 50
ER_USERABORT	equ 66
ER_READARCH	equ -2

__ISWRITE	equ 01h
__DISKAREA	equ 06h
__FAILALLOWED	equ 08h
__RETRYALLOWED  equ 10h
__IGNOREALLOWED equ 20h
__ISDEVICE	equ 80h

externdef errno:	dword
externdef doserrno:	dword
externdef sys_errlist:  dword
;externdef sys_nerr:	dword
;externdef errnotable:  byte
;externdef syserrtable:  byte

;externdef CP_NOERROR:  byte	; No Error
;externdef CP_ERROR:	byte	; Error
;externdef CP_EPERM:	byte	; Operation not permitted
externdef CP_ENOENT:	byte	; No such file or directory
;externdef CP_ESRCH:	byte	; No such process
;externdef CP_EINTR:	byte	; Interrupted function call
externdef CP_EIO:	byte	; Input/output error
;externdef CP_ENXIO:	byte	; No such device or address
;externdef CP_E2BIG:	byte	; Arg list too long
;externdef CP_ENOEXEC:  byte	; Exec format error
;externdef CP_EBADF:	byte	; Bad file descriptor
;externdef CP_ECHILD:	byte	; No child processes
;externdef CP_EAGAIN:	byte	; Resource temporarily unavailable
externdef CP_ENOMEM:	byte	; Not enough space
;externdef CP_EACCES:	byte	; Permission denied
;externdef CP_EFAULT:	byte	; Bad address
;externdef CP_EBUSY:	byte	; Resource device
;externdef CP_EEXIST:	byte	; File exists
;externdef CP_EXDEV:	byte	; Improper link
;externdef CP_ENODEV:	byte	; No such device
;externdef CP_ENOTDIR:  byte	; Not a directory
;externdef CP_EISDIR:	byte	; Is a directory
;externdef CP_EINVAL:	byte	; Invalid argument
;externdef CP_ENFILE:	byte	; Too many open files in system
;externdef CP_EMFILE:	byte	; Too many open files
;externdef CP_ENOTTY:	byte	; Inappropriate I/O control operation
;externdef CP_EFBIG:	byte	; File too large
externdef CP_ENOSPC:	byte	; No space left on device
;externdef CP_ESPIPE:	byte	; Invalid seek
;externdef CP_EROFS:	byte	; Read-only file system
;externdef CP_EMLINK:	byte	; Too many links
;externdef CP_EPIPE:	byte	; Broken pipe
;externdef CP_EDOM:	byte	; Domain error
;externdef CP_ERANGE:	byte	; Result too large
;externdef CP_EDEADLK:  byte	; Resource deadlock avoided
;externdef CP_ENAMETOOLONG:byte  ; Filename too long
;externdef CP_ENOLCK:	byte	; No locks available
externdef CP_ENOSYS:	byte	; Function not implemented
;externdef CP_ENOTEMPTY: byte	; Directory not empty
;externdef CP_EILSEQ:	byte	; Illegal byte sequence
;externdef CP_UNKNOWN:  byte	; Unknown error

osmaperr	proto
notsup		proto
eropen		proto :dword
ermkdir		proto :dword
erdelete	proto :dword
errnomsg	proto :dword, :dword, :dword
ermsg		proto c :dword, :dword, :VARARG
GetLastError	proto

.list
