;************** Inflate and Explode
;
;  inflate.c -- by Mark Adler
;  explode.c -- by Mark Adler
;
; Change history:
; 03/31/2010	Removed 386 instructions
; ../../1997	Modified for Doszip

include iost.inc
include alloc.inc
include string.inc
include unzip.inc
include errno.inc

public  zip_inflate
public  zip_explode

OSIZE	equ 8000h
BMAX	equ 16		; Maximum bit length of any code (16 for explode)
N_MAX	equ 288		; Maximum number of codes in any set
;
; Huffman code lookup table entry--this entry is four bytes for machines
;   that have 16-bit pointers (e.g. PC's in the small or medium model).
;   Valid extra bits are 0..13.  e == 15 is EOB (end of block), e == 16
;   means that v is a literal, 16 < e < 32 means that v is a pointer to
;   the next table, which codes e - 16 bits, and lastly e == 99 indicates
;   an unused code.  If a code with e == 99 is looked up, this implies an
;   error in the data.
;
HUFT	STRUC
e	db ?		; number of extra bits or operation
b	db ?		; number of bits in this code or subcode
 UNION
  n	dw ?		; literal, length base, or distance base
  t	dd ?		; pointer to next level of table
 ENDS
eight	dw ?
HUFT	ENDS

.data

fixed_bd dd 0
fixed_bl dd 0
fixed_td dd 0
fixed_tl dd 0

border  dw 16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15
cplens  dw 3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51
	dw 59,67,83,99,115,131,163,195,227,258,0,0
cplext  dw 0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5
	dw 5,5,5,0,99,99
cpdist  dw 1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257
	dw 385,513,769,1025,1537,2049,3073,4097,6145,8193
	dw 12289,16385,24577
cpdext  dw 0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9
	dw 10,10,11,11,12,12,13,13
zlbits  dd 9
zdbits  dd 6
cplen2  dw 2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
	dw 18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34
	dw 35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51
	dw 52,53,54,55,56,57,58,59,60,61,62,63,64,65
cplen3  dw 3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
	dw 19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35
	dw 36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52
	dw 53,54,55,56,57,58,59,60,61,62,63,64,65,66
exextra dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw 8
cpdist4 dw 1,65,129,193,257,321,385,449,513,577,641,705
	dw 769,833,897,961,1025,1089,1153,1217,1281,1345,1409,1473
	dw 1537,1601,1665,1729,1793,1857,1921,1985,2049,2113,2177
	dw 2241,2305,2369,2433,2497,2561,2625,2689,2753,2817,2881
	dw 2945,3009,3073,3137,3201,3265,3329,3393,3457,3521,3585
	dw 3649,3713,3777,3841,3905,3969,4033
cpdist8 dw 1,129,257,385,513,641,769,897,1025,1153,1281
	dw 1409,1537,1665,1793,1921,2049,2177,2305,2433,2561,2689
	dw 2817,2945,3073,3201,3329,3457,3585,3713,3841,3969,4097
	dw 4225,4353,4481,4609,4737,4865,4993,5121,5249,5377,5505
	dw 5633,5761,5889,6017,6145,6273,6401,6529,6657,6785,6913
	dw 7041,7169,7297,7425,7553,7681,7809,7937,8065

bmask	dd 00000000h,00000001h,00000003h,00000007h
	dd 0000000Fh,0000001Fh,0000003Fh,0000007Fh
	dd 000000FFh,000001FFh,000003FFh,000007FFh
	dd 00000FFFh,00001FFFh,00003FFFh,00007FFFh
	dd 0000FFFFh,0001FFFFh,0003FFFFh,0007FFFFh
	dd 000FFFFFh,001FFFFFh,003FFFFFh,007FFFFFh
	dd 00FFFFFFh,01FFFFFFh,03FFFFFFh,07FFFFFFh
	dd 0FFFFFFFh,1FFFFFFFh,3FFFFFFFh,7FFFFFFFh
	dd -1

.code

bk	equ <STDI.ios_l>
bb	equ <STDI.ios_bb>

getbits proc private
	mov	ecx,eax
	cmp	bk,eax  ; AL = count
	jb	@F
	mov	eax,bmask[eax*4]
	and	eax,bb  ; bits to EAX
	test	cl,cl	; set ZF flag
	ret
      @@:		; add a byte to bb
	mov	eax,STDI.ios_i
	cmp	eax,STDI.ios_c
	je	getbits_read
	inc	STDI.ios_i
	add	eax,STDI.ios_bp
	movzx	eax,byte ptr [eax]
	push	ecx
	mov	cl,byte ptr bk
	shl	eax,cl
	or	bb,eax
	add	bk,8
	pop	eax
	jmp	getbits
    getbits_read:
	push	edx
	push	ecx
	call	ofread
	pop	ecx
	pop	edx
	jnz	@B
	sub	eax,eax
	ret
getbits endp

;
; Free the malloc'ed tables built by huft_build(), which makes a linked
; list of the tables it made, with the links in a dummy first entry of
; each table.
;
huft_free proc private huft:dword
	mov eax,huft
	.while eax
	    sub eax,SIZE HUFT
	    push [eax].HUFT.t
	    invoke free,eax
	    pop eax
	.endw
	ret
huft_free endp

huft_build proc private uses esi edi ebx \
	b:dword,	; code lengths in bits (all assumed <= BMAX)
	n:dword,	; number of codes (assumed <= N_MAX)
	s:dword,	; number of simple-valued codes (0..s-1)
	d:dword,	; list of base values for non-simple codes
	e:dword,	; list of extra bits for non-simple codes
	t:dword,	; result: starting table
	m:dword		; maximum lookup bits, returns actual
local	z:dword		; number of entries in current table
local	y:dword		; number of dummy codes added
local	w:dword		; bits before this table == (l * h)
local	p:dword		; pointer into c[], b[], or v[]
local	l:dword		; stack of bits per table
local	k:dword		; number of bits in current code
local	i:dword		; counter, current code
local	g:dword		; maximum code length
local	el:dword	; length of EOB code (value 256)
local	a:dword		; counter for codes of length k
local	q:dword		; points to current table
local	r:HUFT		; table entry for structure assignment
local	x[BMAX+1]:word  ; bit offsets, then code stack
local	lx[BMAX+1]:word ; memory for l[-1..BMAX-1]
local	_c[BMAX+1]:word ; bit length count table
local	u[BMAX]:ptr HUFT; table stack
local	v[N_MAX]:word	; values in order of bit length
	mov	ecx,ebp
	lea	edi,v
	sub	ecx,edi
	sub	eax,eax
	rep	stosb
	;--------------------------------------------------------------------
	; Generate counts for each bit length
	;--------------------------------------------------------------------
	lea	eax,lx[2]
	mov	l,eax		; l = lx+1
	mov	ecx,n		; i = n
	mov	edi,b		; p = b
	mov	eax,BMAX	; set length of EOB code, if any
	cmp	ecx,256
	jbe	@F
	mov	ax,[edi+512]	; b[256]
      @@:
	mov	el,eax
	assert  ecx,0,jne,"i = 0"
	sub	eax,eax		; do { c[*p]++; p++; } while (--i);
	lea	edx,_c
      @@:
	mov	ax,[edi]
	add	edi,2
	inc	word ptr [edx+eax*2]
	dec	ecx
	jnz	@B
      @@:
	mov	eax,n
	cmp	[edx],ax
	jne	@F
	xor	eax,eax		; null input -- all zero length codes
	mov	edx,t
	mov	[edx],eax
	mov	[edx+4],ax
	mov	edx,m
	mov	[edx],eax
	jmp	huft_build_end
      @@:
	;--------------------------------------------------------------------
	; Find minimum and maximum length, bound *m by those
	;--------------------------------------------------------------------
	mov	edi,1
	xor	eax,eax
      @@:
	cmp	edi,BMAX
	ja	@F
	cmp	[edx+edi*2],ax
	jne	@F
	inc	edi
	jmp	@B
      @@:
	mov k,edi		; minimum code length
	mov eax,m
	.if [eax] < edi		; if (*m < j)
	    mov [eax],edi	;  *m = j
	.endif
	mov ecx,BMAX		; for (i = BMAX; i; i--)
	xor eax,eax		;  if (c[i]) break
	.repeat
	    .break .if [edx+ecx*2] != ax
	.untilcxz
	mov g,ecx		; maximum code length
	mov eax,m		; if (*m > i)
	.if [eax] > ecx		;  *m = i
	    mov [eax],ecx
	.endif
	;--------------------------------------------------------------------
	; Adjust last length count to fill out codes, if needed
	;--------------------------------------------------------------------
	mov esi,ecx		; for (y = 1 << j; j < i; j++, y <<= 1)
	mov ecx,edi
	mov eax,1
	shl eax,cl
	mov ecx,eax		; y = 1 << j
	.while edi < esi	; j < i
	    sub cx,[edx+edi*2]  ; if ((y -= c[j]) < 0)
	    jl huft_build_erzip ; bad input: more codes than bits
	    add ecx,ecx		; y <<= 1
	    inc edi		; j++
	.endw
	lea ebx,[edx+edi*2]
	sub cx,[ebx]
	jl  huft_build_erzip
	add [ebx],cx
	mov y,ecx
	;--------------------------------------------------------------------
	; Generate starting offsets into the value table for each length
	;--------------------------------------------------------------------
	xor eax,eax		; x[1] = j = 0
	lea ebx,x[2]		; xp = x + 2;
	mov [ebx],ax
	lea edi,[edx+2]		; p = c + 1;
	dec esi			; i == g from above
	.while esi		; while (--i) {
	    add ax,[edi]	;  *xp++ = (j += *p++);
	    add edi,2
	    add ebx,2
	    mov [ebx],ax
	    dec esi
	.endw
	;--------------------------------------------------------------------
	; Make a table of values in order of bit lengths
	;--------------------------------------------------------------------
	xor ecx,ecx		; p = b;  i = 0;
	mov esi,b
	lea ebx,x
	lea edi,v
	.repeat				; do {
	    movzx eax,word ptr [esi]
	    add esi,2
	    .if eax			; if ((j = *p++) != 0)
		lea edx,[ebx+eax*2]	; &x[j]
		mov ax,[edx]
		inc word ptr [edx]	; x[j]++
		mov [edi+eax*2],cx	; v[x[j]++] = i
	    .endif
	    inc ecx
	.until ecx >= n			; } while (++i < n);
	;--------------------------------------------------------------------
	; Generate the Huffman codes and for each, make the table entries
	;--------------------------------------------------------------------
	xor	eax,eax		; x[0] = i = 0; first Huffman code is zero
	mov	i,eax		; w = l[-1] = 0; no bits decoded yet
	mov	x,ax
	mov	lx,ax
	mov	esi,-1		; h = -1; no tables yet--level -1
	lea	eax,v
	mov	p,eax		; p = v; grab values in bit order
	jmp	HUFT_BUILD_35
    huft_build_erzip:
	mov	eax,ER_ZIP
	jmp	huft_build_end
	;--------------------------------------------------------------------
	; compute minimum size table less than or equal to *m bits
	;--------------------------------------------------------------------
    HUFT_BUILD_16:
	mov	w,eax		; w += l[h++]; add bits already decoded
	inc	esi
	mov	eax,g		; z = (z = g - w) > *m ? *m : z; upper limit
	sub	eax,w
	mov	z,eax
	mov	edx,m
	mov	edx,[edx]
	.if eax > edx
	    mov eax,edx
	    mov z,eax
	.endif
	mov	eax,k
	sub	eax,w
	mov	edi,eax		; j = k - w
	mov	ecx,eax
	mov	eax,1
	shl	eax,cl		; 1 << j
	mov	ecx,eax
	mov	edx,a
	inc	edx
	.if eax > edx		; if ((f = 1 << (j = k - w)) > a + 1)
	    sub ecx,edx		; too few codes for k-w bit table
	    mov eax,k		; deduct codes from patterns left
	    lea ebx,_c[eax*2]	; xp = c + k
	    .repeat		; while (++j < z)
		mov eax,z
		inc edi
		.break .if di >= ax
		add ecx,ecx
		mov eax,ecx
		add ebx,2	; if ((f <<= 1) <= *++xp) break
		.break .if ax <= [ebx]
		movzx eax,word ptr [ebx]
		sub ecx,eax	; f -= *xp
	    .until 0
	.endif
	mov edx,el
	mov eax,w		; if (w + j > el && w < el)
	add eax,edi
	.if eax > edx
	    mov eax,edx
	    .if w < eax
		sub eax,w
		mov edi,eax	; j = el - w -- make EOB code end at table
	    .endif
	.endif
	mov eax,1
	mov ecx,edi
	shl eax,cl
	mov z,eax		; z = 1 << j -- table entries for j-bit table
	mov edx,l
	mov [edx+esi*2],di	; l[h] = j   -- set table size in stack
	inc eax			; (z + 1)*sizeof(struct huft)
	shl eax,3
	invoke malloc,eax
	.if ZERO?
	    .if esi
		invoke huft_free,u
	    .endif
	    mov eax,ER_MEM
	    jmp huft_build_end
	.endif
	;--------------------------------------------------------------------
	; link to list for huft_free()
	;--------------------------------------------------------------------
	mov	ebx,t
	add	eax,SIZE HUFT
	mov	q,eax		; ++q
	mov	[ebx],eax	; *t = q + 1
	sub	eax,SIZE HUFT - 2
	mov	t,eax		; t = &(q->v.t)
	xor	ebx,ebx
	mov	[eax],ebx	; *(t = &(q->v.t)) = (struct huft *)NULL
	lea	ebx,u[esi*4]
	mov	eax,q
	mov	[ebx],eax	; u[h] = ++q
	mov	eax,esi
	test	eax,eax		; if (h)
	jz	HUFT_BUILD_23	; connect to last table, if there is one
	add	eax,eax
	lea	ebx,x		; save patteen for backing up
	mov	edx,i
	mov	[ebx+eax],dx	; x[h] = i
	mov	ebx,l		; bits to dump before this table
	movzx	ecx,word ptr [ebx+eax-2]
	mov	r.b,cl		; r.b = l[h-1] - bits in this table
	mov	ebx,eax		;
	lea	eax,[edi+16]
	mov	r.e,al		; r.e = 16 + j
	mov	eax,q		; pointer to this table
	mov	r.t,eax		; r.v.t = q
	mov	eax,w		;
	sub	eax,ecx		; w - l[h-1]
	mov	edx,eax
	mov	eax,w
	mov	eax,bmask[eax*4]
	mov	ecx,i
	and	ecx,eax		; i & (1 << w) - 1
	mov	eax,ecx
	mov	ecx,edx
	shr	eax,cl		; j = (i & ((1 << w) - 1)) >> (w - l[h-1])
	shl	eax,3		; u[h-1][j] = r
	mov	edx,eax
	mov	eax,esi		; h-1
	dec	eax
	mov	eax,u[eax*4]	; connect to last table
	add	eax,edx
	mov	ebx,eax
	mov	ax,word ptr r
	mov	[ebx],ax
	mov	eax,r.t
	mov	[ebx].HUFT.t,eax
    HUFT_BUILD_23:		; while (k > w + l[h])
	mov	eax,l
	movzx	eax,word ptr [eax+esi*2]
	add	eax,w
	cmp	k,eax
	jg	HUFT_BUILD_16
	mov	eax,k		; set up table entry in r
	sub	eax,w
	mov	r.b,al		; r.b = k - w
	mov	eax,n
	lea	eax,v[eax*2]
	mov	ebx,p
	.if ebx >= eax		; if (p >= v + n)
	    mov r.e,99		; out of values--invalid code
	.else
	    movzx eax,word ptr [ebx]
	    add p,2
	    .if eax < s		; else if (*p < s)
		mov r.e,16	; r.v.n = *p++
		.if eax >= 256  ; 256 is end-of-block code
		    mov r.e,15
		.endif
	    .else
		sub eax,s
		mov ebx,e
		mov dl,[ebx+eax*2]
		mov r.e,dl	; r.e = e[*p - s]
		mov ebx,d
		mov ax,[ebx+eax*2] ; r.v.n = d[*p++ - s]
	    .endif
	    mov r.n,ax
	.endif
	mov ecx,k		; fill code-like entries with r
	sub ecx,w
	mov eax,1
	shl eax,cl		; f = 1 << (k - w)
	mov edi,eax
	mov ecx,w		; for (j = i >> w; j < z; j += f)
	mov eax,i
	shr eax,cl
	mov ecx,eax
	mov ebx,q
	.while ecx < z
	    mov ax,word ptr r	; q[j] = r
	    mov [ebx+ecx*8],ax
	    mov eax,r.t
	    mov [ebx+ecx*8].HUFT.t,eax
	    add ecx,edi
	.endw
	mov ecx,k		; backwards increment the k-bit code i
	dec ecx
	mov eax,1		; 1 << (k - 1)
	shl eax,cl
	mov ecx,eax
	mov edi,i
	.while edi & ecx	; for (j = 1 << (k - 1); i & j; j >>= 1)
	    xor edi,ecx		;  i ^= j
	    shr ecx,1
	.endw
	xor edi,ecx		; i ^= j
	mov i,edi
	.repeat			; backup over finished tables
	    mov eax,w		; while ((i & ((1 << w) - 1)) != x[h])
	    mov eax,bmask[eax*4]
	    mov edx,edi
	    and edx,eax		; i & ((1 << w) - 1)
	    lea eax,x
	    .break .if dx == [eax+esi*2]
	    dec esi		; w -= l[--h] -- don't need to update q
	    mov eax,l
	    movzx eax,word ptr [eax+esi*2]
	    sub w,eax
	.until 0
    HUFT_BUILD_33:
	mov eax,a
	dec a
	.if ax
	   jmp HUFT_BUILD_23
	.endif
	inc k
    HUFT_BUILD_35:
	mov eax,k
	cmp eax,g
	jg @F
	lea edx,_c
	movzx eax,word ptr [edx+eax*2]
	mov a,eax
	jmp HUFT_BUILD_33
      @@:
	mov eax,l
	movzx eax,word ptr [eax]
	mov edx,m
	mov [edx],eax	; return actual size of base table
	mov eax,1	; Return true (1) --warning error--
	.if y == 0 || g == 1
	    dec eax	; if we were given an incomplete table
	.endif
    huft_build_end:
	ret
huft_build endp

;************** Explode an imploded compressed stream

; Get the bit lengths for a code representation from the compressed
; stream. If gettree() returns 4, then there is an error in the data.
; Otherwise zero is returned.

ex_b	equ [ebp-04]
ex_io	equ [ebp-08]
ex_s	equ [ebp-12]
ex_bd	equ [ebp-16]
ex_bl	equ [ebp-20]
ex_bb	equ [ebp-24]
ex_td	equ [ebp-28]
ex_tl	equ [ebp-32]
ex_tb	equ [ebp-36]
ex_l	equ [ebp-548]

get_tree proc private
	mov	edi,eax
	call	ogetc
	inc	eax
	push	eax
	xor	esi,esi
	.repeat
	    call ogetc
	    mov edx,eax
	    and eax,000Fh
	    mov ecx,eax
	    inc ecx
	    and edx,00F0h
	    shr edx,4
	    inc edx
	    mov eax,edx
	    add eax,esi
	    .if eax <= edi
		lea eax,ex_l
		.repeat
		    mov [eax+esi*2],cx
		    inc esi
		    dec edx
		.until !edx
		pop eax
		dec eax
		.if !ZERO?
		    push eax
		.else
		    .if esi == edi
			ret
		    .endif
		    .break
		.endif
	    .else
		pop eax
		.break
	    .endif
	.until 0
	mov	eax,4
	test	eax,eax
	ret
get_tree endp

explode_init proc private
	xor	eax,eax
	mov	STDI.ios_l,eax
	mov	STDI.ios_bb,eax
	mov	ex_io,eax
	mov	eax,zip_local.lz_fsize
	mov	ex_s,eax
	ret
explode_init endp

decode_huft proc private
	mov edx,bmask[eax*4]
	call getbits
	.repeat
	    not eax
	    and eax,edx
	    shl eax,3
	    add ebx,eax
	    mov cl,[ebx].HUFT.b
	    sub byte ptr bk,cl
	    shr bb,cl
	    movzx eax,[ebx].HUFT.e
	    mov esi,eax
	    mov al,0
	    .if esi > 16
		inc eax
		.if esi != 99
		    sub esi,16
		    mov eax,esi
		    mov edx,bmask[eax*4]
		    call getbits
		    mov ebx,[ebx].HUFT.t
		.else
		    .break
		.endif
	    .else
		.break
	    .endif
	.until 0
	test eax,eax
	ret
decode_huft endp

explode_docopy proc private
	mov	eax,ex_b
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	mov	edi,eax
	mov	ebx,ex_td
	mov	eax,ex_bd
	call	decode_huft
	jnz	@_docopy_end
	movzx	edx,[ebx].HUFT.n
	mov	eax,STDO.ios_i
	sub	eax,edi
	sub	eax,edx
	mov	edi,eax
	mov	eax,ex_bl
	mov	ebx,ex_tl
	call	decode_huft
	jnz	@_docopy_end
	mov	eax,esi
	movzx	esi,[ebx].HUFT.n
	test	eax,eax
	jz	@F
	mov	eax,8
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	add	esi,eax
      @@:
	xor	eax,eax
	mov	edx,ex_s
	mov	ex_s,eax
	mov	eax,esi
	cmp	edx,eax
	jbe	@_docopy_edi
	sub	edx,eax
	mov	ex_s,edx
    @_docopy_edi:
	and	edi,OSIZE-1
	mov	eax,edi
	cmp	eax,STDO.ios_i
	ja	@F
	mov	eax,STDO.ios_i
      @@:
	mov	ecx,OSIZE
	sub	ecx,eax
	cmp	ecx,esi
	jb	@F
	mov	ecx,esi
      @@:
	sub	esi,ecx
	mov	eax,STDO.ios_i
	add	STDO.ios_i,ecx
	push	esi
	mov	esi,edi
	add	edi,ecx
	push	edi
	mov	ebx,STDO.ios_bp
	mov	edi,ebx
	add	edi,eax
	add	ebx,esi
	cmp	eax,esi
	mov	esi,ebx
	jbe	@_docopy_io
    @_docopy_mov:
	rep	movsb
    @_docopy_pop:
	pop	edi
	pop	esi
	cmp	STDO.ios_i,OSIZE
	jae	@_docopy_flush
    @_docopy_lup:
	test	esi,esi
	jnz	@_docopy_edi
	sub	eax,eax
    @_docopy_end:
	ret
    @_docopy_io:
	mov	al,ex_io
	test	al,al
	jnz	@_docopy_mov
	rep	stosb
	jmp	@_docopy_pop
    @_docopy_flush:
	call	oflush
	mov	ex_io,al
	jnz	@_docopy_lup
	mov	eax,ER_DISK
	ret
explode_docopy endp

; Decompress the imploded data using coded literals and a sliding
; window (of size 2^(6+bdl) bytes).

explode_lit proc private
	call	explode_init
      @@:
	mov	eax,ex_s
	test	eax,eax
	jz	explode_flush
	mov	eax,1
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	test	al,al
	jz	@lit_docopy
	dec	dword ptr ex_s
	mov	ebx,ex_tb
	mov	eax,ex_bb
	call	decode_huft
	jnz	@F
	mov	ax,[ebx].HUFT.n
	call	oputc
	jz	explode_eof
	cmp	eax,STDO.ios_i
	jbe	@B
	mov	ex_io,al
	jmp	@B
      @lit_docopy:
	call	explode_docopy
	test	eax,eax
	jz	@B
      @@:
	ret
explode_lit endp

explode_flush:
	call	oflush
explode_eof:	; Out of space..
	dec	eax
	ret

; Decompress the imploded data using uncoded literals and a sliding
; window (of size 2^(6+bdl) bytes).

explode_nolit proc private
	call	explode_init
      @@:
	mov	eax,ex_s
	test	eax,eax
	jz	explode_flush
	mov	eax,1
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	test	al,al
	jz	@nolit_docopy
	dec	dword ptr ex_s
	mov	eax,8
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	call	oputc
	jz	explode_eof
	cmp	eax,STDO.ios_i
	jbe	@B
	mov	ex_io,al
	jmp	@B
      @nolit_docopy:
	call	explode_docopy
	test	eax,eax
	jz	@B
	ret
explode_nolit endp

zip_explode proc uses esi edi ebx
local exb:  dword	; -04
local exio: dword	; -08
local exs:  dword	; -12
local exbd: dword	; -16
local exbl: dword	; -20
local exbb: dword	; -24
local extd: dword	; -28
local extl: dword	; -32
local extb: dword	; -36
local exl[256]: word	; -548
	mov	eax,7
	mov	exbl,eax
	cmp	zip_local.lz_csize,200000
	jbe	@F
	inc	eax
      @@:
	mov	exbd,eax
	xor	eax,eax
	mov	extb,eax
	.if zip_local.lz_flag & 4
	    mov exbb,9
	    mov eax,256
	    .if get_tree()
		jmp explode_end
	    .endif
	    .if huft_build(addr exl,256,256,0,0,addr extb,addr exbb)
		.if eax == 1
		    jmp explode_freetb
		.endif
		jmp explode_end
	    .endif
	    mov eax,64
	    .if get_tree()
		jmp explode_freetb
	    .endif
	    mov edx,offset cplen3
	.else
	    mov eax,64
	    .if get_tree()
		jmp explode_end
	    .endif
	    mov edx,offset cplen2
	.endif
	.if huft_build(addr exl,64,0,edx,addr exextra,addr extl,addr exbl)
	    .if eax == 1
		jmp explode_freetl
	    .endif
	    jmp explode_freetb
	.endif
	mov eax,64
	.if get_tree()
	    jmp explode_freetl
	.endif
	mov exb,6
	mov edx,offset cpdist4
	.if zip_local.lz_flag & 2
	    mov edx,offset cpdist8
	    inc exb
	.endif
	.if huft_build(addr exl,64,0,edx,addr exextra,addr extd,addr exbd)
	    .if eax == 1
		jmp explode_freetd
	    .endif
	    jmp explode_freetb
	.endif
	.if extb == eax
	    call explode_nolit
	.else
	    call explode_lit
	.endif
    explode_freetd:
	push	eax
	invoke  huft_free,extd
	pop	eax
    explode_freetl:
	push	eax
	invoke  huft_free,extl
	pop	eax
    explode_freetb:
	push	eax
	invoke  huft_free,extb
	pop	eax
    explode_end:
	ret
zip_explode endp

;************** Decompress the codes in a compressed block

inflatecode proc private
	call	getbits
	lea	ebx,[ebx+eax*8]
	movzx	eax,[ebx].HUFT.e
	mov	esi,eax
	cmp	al,16
	ja	@F
	mov	cl,[ebx].HUFT.b
	sub	byte ptr bk,cl
	shr	bb,cl
	sub	eax,eax
	ret
      @@:
	cmp	al,99
	je	@F
	mov	cl,[ebx].HUFT.b
	sub	byte ptr bk,cl
	shr	bb,cl
	sub	esi,16
	mov	eax,esi
	call	getbits
	mov	ebx,[ebx].HUFT.t
	lea	ebx,[ebx+eax*8]
	movzx	eax,[ebx].HUFT.e
	mov	esi,eax
	cmp	al,16
	ja	@B
	mov	cl,[ebx].HUFT.b
	sub	byte ptr bk,cl
	shr	bb,cl
	sub	eax,eax
      @@:
	test	eax,eax
	ret
inflatecode endp

inflate_codes proc private uses esi edi tl:dword, td:dword, wl:dword, wd:dword
	;
	; do until end of block
	;
    continue:
	mov	ebx,tl
	mov	eax,wl
	invoke  inflatecode
	jnz	toend
	cmp	esi,15
	je	toend
	cmp	esi,16			; then it's a literal
	jne	@F
	mov	ax,[ebx].HUFT.n		; slide[w++] = t->v.n
	invoke  oputc
	jnz	continue
	jmp	disk_full
      @@:
	mov	eax,esi
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	add	ax,[ebx].HUFT.n
	mov	edi,eax
	mov	ebx,td
	mov	eax,wd
	call	inflatecode
	jnz	toend
	movzx	eax,[ebx].HUFT.n
	push	eax
	mov	eax,esi
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	mov	edx,eax
	mov	eax,STDO.ios_i
	pop	ebx
	sub	eax,ebx
	sub	eax,edx
	mov	ebx,eax
    while_1:
	and	ebx,OSIZE-1
	mov	ecx,OSIZE
	mov	eax,ebx
	cmp	eax,STDO.ios_i
	ja	@F
	mov	eax,STDO.ios_i
      @@:
	sub	ecx,eax
	cmp	ecx,edi
	jbe	@F
	mov	ecx,edi
      @@:
	sub	edi,ecx
	mov	eax,STDO.ios_i
	add	STDO.ios_i,ecx
	mov	edx,edi
	mov	edi,STDO.ios_bp
	mov	esi,STDO.ios_bp
	add	edi,eax
	add	esi,ebx
	add	ebx,ecx
	add	eax,ecx
	rep	movsb
	mov	edi,edx
	cmp	eax,OSIZE
	jae	flush_codes
    untildiz:
	test	edi,edi
	jnz	while_1
	jmp	continue
    toend:
	ret
    flush_codes:
	invoke  oflush
	jnz	untildiz
    disk_full:
	mov	eax,ER_DISK
	jmp	toend
inflate_codes endp

;************** Decompress an inflated type 1 (fixed Huffman codes) block

inflate_fixed proc private uses edi
local l[288]:word	; length list for huft_build
	lea edi,l
	xor eax,eax
	.if fixed_tl == eax
	    mov ebx,edi
	    mov ecx,144 ; literal table
	    mov eax,8
	    rep stosw
	    mov ecx,112
	    mov eax,9
	    rep stosw
	    mov ecx,24
	    mov eax,7
	    rep stosw	; make a complete, but wrong code set
	    mov ecx,8
	    mov eax,8
	    rep stosw
	    mov edi,ebx
	    mov fixed_bl,7
	    .if huft_build(edi,288,257,addr cplens,addr cplext,addr fixed_tl,addr fixed_bl)
		mov fixed_tl,0
		jmp @F
	    .endif
	    mov edx,edi ; make an incomplete code set
	    mov ecx,30
	    mov eax,5
	    rep stosw
	    mov fixed_bd,5
	    mov edi,edx
	    .if huft_build(edi,30,0,addr cpdist,addr cpdext,addr fixed_td,addr fixed_bd)
		.if eax != 1
		    push   eax
		    invoke huft_free,fixed_tl
		    mov	   fixed_tl,0
		    pop	   eax
		    jmp	   @F
		.endif
	    .endif
	.endif
	;
	; decompress until an end-of-block code
	;
	invoke  inflate_codes, fixed_tl, fixed_td, fixed_bl, fixed_bd
	test	eax,eax
	jz	@F
	mov	eax,1
      @@:
	ret
inflate_fixed endp

;************** Decompress an inflated type 2 (dynamic Huffman codes) block

inflate_dynamic proc private uses esi edi
local nd:dword		; number of distance codes
local nl:dword		; number of literal/length codes
local nb:dword		; number of bit length codes
local tl:dword		; literal/length code table
local td:dword		; distance code table
local wl:dword		; lookup bits for tl (bl)
local wd:dword		; lookup bits for td (bd)
local n:dword		; number of lengths to get
local ll[320]:word	; literal/length and distance code lengths
	mov	eax,5
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	add	eax,257
	mov	nl,eax  ; number of literal/length codes
	mov	eax,5
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	inc	eax
	mov	nd,eax  ; number of distance codes
	mov	eax,4
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	add	eax,4
	mov	nb,eax  ; number of bit length codes
	;
	; PKZIP_BUG_WORKAROUND
	;
	.if nl > 288 || nd > 32
	    mov eax,1
	    jmp inflate_dynamic_end
	.endif
	sub esi,esi
	lea edi,ll
	.while esi < nb
	    mov eax,3
	    call getbits
	    sub byte ptr bk,cl
	    shr bb,cl
	    movzx edx,border[esi*2]
	    mov [edi+edx*2],ax
	    inc esi
	.endw
	.while esi < 19
	    movzx eax,border[esi*2]
	    mov word ptr [edi+eax*2],0
	    inc esi
	.endw
	mov wl,7
	invoke huft_build,edi,19,19,0,0,addr tl,addr wl
	.if !wl
	    mov eax,1	; no bit lengths
	.endif
	.if eax		; incomplete code set
	    jmp inflate_dynamic_free1
	.endif
	mov eax,nl
	add eax,nd
	mov n,eax
	xor esi,esi
	mov edi,esi
	.while esi < n
	    mov eax,tl
	    mov td,eax
	    mov eax,wl
	    call getbits
	    shl eax,3
	    add td,eax
	    mov ebx,td
	    mov cl,[ebx].HUFT.b
	    sub byte ptr bk,cl
	    shr bb,cl
	    movzx eax,[ebx].HUFT.n
	    .if eax == 16
		mov eax,2
		call getbits
		sub byte ptr bk,cl
		shr bb,cl
		add eax,3
		mov edx,eax
		add eax,esi
		.if eax > n
		    mov eax,1
		    jmp inflate_dynamic_end
		.endif
		lea eax,ll
		.while edx
		    mov [eax+esi*2],di
		    inc esi
		    dec edx
		.endw
	    .elseif eax > 16
		.if eax != 17
		    mov eax,7
		    call getbits
		    sub byte ptr bk,cl
		    shr bb,cl
		    add eax,11
		.else
		    mov eax,3
		    call getbits
		    sub byte ptr bk,cl
		    shr bb,cl
		    add eax,3
		.endif
		mov edx,eax
		add eax,esi
		.if eax > n
		    mov eax,1
		    jmp inflate_dynamic_end
		.endif
		sub edi,edi
		lea eax,ll
		.while edx
		   mov [eax+esi*2],di
		   inc esi
		   dec edx
		.endw
	    .else
		mov edi,eax
		lea eax,ll
		mov [eax+esi*2],di
		inc esi
	    .endif
	.endw
	invoke huft_free,tl
	mov eax,zlbits
	mov wl,eax
	invoke huft_build,addr ll,nl,257,addr cplens,addr cplext,addr tl,addr wl
	.if !wl
	    mov eax,1
	.endif
	.if eax
	    jmp inflate_dynamic_free1
	.endif
	mov eax,zdbits
	mov wd,eax
	lea edx,ll
	add edx,nl
	add edx,nl
	invoke huft_build,edx,nd,0,addr cpdist,addr cpdext,addr td,addr wd
	.if !wd && nl > 257
	    mov eax,1
	    jmp inflate_dynamic_free
	.endif
	.if eax == 1
	    xor eax,eax
	.endif
	.if eax
	    jmp inflate_dynamic_free
	.endif
	invoke  inflate_codes,tl,td,wl,wd
	push	eax
	invoke  huft_free,td
	pop	eax
	test	eax,eax
	jz	inflate_dynamic_free
	mov	eax,1
    inflate_dynamic_free:
	push	eax
	invoke  huft_free,tl
	pop	eax
    inflate_dynamic_end:
	ret
    inflate_dynamic_free1:
	cmp	eax,1
	je	inflate_dynamic_free
	jmp	inflate_dynamic_end
inflate_dynamic endp

;****** Decompress an inflated type 0 (stored) block.

inflate_stored proc private uses esi
	mov	STDI.ios_l,0
	mov	eax,16
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	mov	esi,eax ; number of bytes in block
	mov	eax,16
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	not	ax
	cmp	ax,si
	jne	error_data
	test	ax,ax
	jz	break
      while_rsi:	; read and output the compressed data
	mov	eax,8
	call	getbits
	jz	error_data
	sub	byte ptr bk,cl
	shr	bb,cl
	call	oputc
	jz	error_disk
	dec	esi
	jnz	while_rsi
      break:
	xor	eax,eax
      @@:
	ret
error_data:
	mov	eax,1	; error in compressed data
	jmp	@B
error_disk:
	mov	eax,ER_DISK
	jmp	@B
inflate_stored endp

zip_inflate proc uses esi edi ebx
	xor	eax,eax
	mov	STDI.ios_bb,eax
    while_0:
	mov	eax,1
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	mov	edi,eax
	mov	eax,2
	call	getbits
	sub	byte ptr bk,cl
	shr	bb,cl
	test	eax,eax
	je	stored
	cmp	eax,1
	je	fixed
	cmp	eax,2
	mov	eax,ER_ZIP
	jne	continue
    dynamic:
	invoke  inflate_dynamic
    continue:
	mov	esi,eax
	test	eax,eax
	jne	@F
	test	edi,edi
	jz	while_0
	invoke  oflush
	jnz	@F
	mov	esi,ER_USERABORT
	test	STDO.ios_flag,IO_ERROR
	jz	@F
	mov	esi,ER_DISK
      @@:
	sub	eax,eax
	cmp	fixed_tl,eax
	je	@F
	invoke  huft_free,fixed_td
	invoke  huft_free,fixed_tl
	sub	eax,eax
	mov	fixed_td,eax
	mov	fixed_tl,eax
      @@:
	mov	eax,esi
      @@:
	ret
    fixed:
	invoke  inflate_fixed
	jmp	continue
    stored:
	invoke  inflate_stored
	jmp	continue
    error:
	jmp	@B
zip_inflate endp

	END
