include _tinfo.inc
include iost.inc
include string.inc
include ctype.inc

tistripend proto

.code
	assume  edx: ptr S_TINFO

; eax: line offset
; edx: &tinfo

tioptimalfill proc private uses esi edi ebx ecx
	mov	esi,eax
	invoke  tistripend
	mov	eax,[edx].ti_flag
	and	eax,_T_LINEBUF or _T_OPTIMALFILL or _T_USETABS
	cmp	eax,_T_LINEBUF or _T_OPTIMALFILL or _T_USETABS
	mov	eax,esi
	jne	toend
	cmp	[edx].ti_tabz,8
	jne	toend
	cmp	ecx,5
	jb	toend
	push	esi
	sub	eax,eax
     do:
	mov	ebx,esi
	lodsb
	test	al,al
	jz	break
	cmp	al,39
	je	quote
	cmp	al,'"'
	je	quote
	test	__ctype[eax+1],_SPACE
	jz	do
     @@:
	lodsb
	test	__ctype[eax+1],_SPACE
	jnz	@B
	dec	esi
   next:
	mov	edi,ebx
	sub	edi,[esp]
	mov	ecx,edi
	add	edi,8
	and	edi,-8
	sub	edi,ecx
	mov	ecx,esi
	inc	ecx
	sub	ecx,ebx
	cmp	ecx,4
	jb	done
	cmp	ecx,edi
	jbe	done
	mov	byte ptr [ebx],9
	inc	ebx
	mov	ecx,edi
	dec	ecx
	jz	next
	mov	edi,ebx
	add	ebx,ecx
	mov	al,TITABCHAR
	rep	stosb
	jmp	next
   done:
	test	ecx,ecx
	jz	do
	dec	ecx
	jz	do
	mov	al,' '
	mov	edi,ebx
	rep	stosb
	jmp	do
  break:
	pop	eax
  toend:
	ret
  quote:
	mov	bl,al
     @@:
	lodsb
	test	al,al
	jz	break
	cmp	al,bl
	je	do
	jmp	@B
tioptimalfill endp

tiflushl proc uses esi edi ebp
	;
	; Produce output to clipboard or file
	;
	; args: AX start line	?, 0
	;	DX start offset ?, 0
	;	CX end line	?, line count - 1 ?
	;	BX end offset	?, -1
	;
	mov	ebp,eax
	mov	edi,edx
	invoke  tigetline
	jz	eoi
	jnc	@F		; CF set if string buffer
	test	[edx].ti_flag,_T_LINEBUF
	jnz	eoi		; else CF is EOF
     @@:
	mov	esi,eax
	invoke  tioptimalfill
	sub	eax,esi
	add	edi,eax
	add	ebx,eax
     do:
	inc	edi
	mov	eax,[edx].ti_bcol
	cmp	ebp,ecx
	jne	@F
	mov	eax,ebx
     @@:
	cmp	edi,eax
	ja	eob
	mov	al,[esi+edi-1]
	test	al,al
	jz	eol
	cmp	al,9
	je	tab
    put:
	assert  al,0,jne,"tiflushl: al=0"
	invoke  oputc
	jnz	do		; out of space..
    eof:
	xor	eax,eax
	stc
	jmp	toend
    tab:
	mov	ah,TIMAXTABSIZE-1
     @@:
	mov	al,[esi+edi]
	cmp	al,TITABCHAR
	jne	putt
	inc	edi
	dec	ah
	jnz	@B
   putt:
	mov	al,9
	jmp	put
    eob:			; end of selection buffer
	cmp	ebp,ecx		; break if last line
	je	eok
    eol:			; end of line
	inc	ebp
	cmp	ebp,ecx
	ja	last		; break if last line (BP==CX)
	mov	eax,ebp
	invoke  tigetline
	jbe	eoi		; break if last line (EOF)
	invoke  tioptimalfill
	mov	esi,eax
	sub	edi,edi
	test	[edx].ti_flag,_T_USECRLF
	jz	@F		; insert line: 0D0A or 0A
	mov	al,0Dh
	invoke  oputc
     @@:
	mov	al,0Ah
	invoke  oputc
	jz	eof
	jmp	do
    eoi:			; end of input (CF)
	xor	eax,eax
	inc	eax
	stc
	jmp	toend
   last:
	dec	ebp
    eok:
	xor	eax,eax
	inc	eax
	clc
  toend:			; out:  AX result
	mov	ebx,edi		;	DX line index
	mov	edx,ebp		;	BX line offset
	ret
tiflushl endp

	END
