include	io.inc
include	errno.inc

	.code

chsize	proc uses edi esi handle:size_t, new_size:dword
local	zbuf[512]:byte
local	offs:dword
local	count:dword
	invoke	lseek,handle,0,SEEK_CUR
	mov	offs,eax	; save current offset
	cmp	eax,-1
	je	chsize_end	; seek to end of file
	invoke	lseek,handle,0,SEEK_END
	cmp	eax,-1
	je	chsize_end
	cmp	eax,new_size
	ja	truncate
	jb	chsize_inc
	jmp	chsize_back	; All done..
    chsize_inc:
	push	eax
	lea	edi,zbuf
	sub	eax,eax
	mov	ecx,512/4
	rep	stosd
	pop	eax
	mov	edi,new_size
	sub	edi,eax
    write_loop:
	mov	count,512
	cmp	edi,count
	jae	write_chunk
	mov	count,edi
	test	edi,edi
	jz	chsize_back
    write_chunk:
	sub	edi,count
	invoke	oswrite,handle,addr zbuf,count
	cmp	eax,count
	je	write_loop
	mov	errno,ERROR_DISK_FULL
	mov	eax,-1
	jmp	chsize_end
    truncate:
	invoke	lseek,handle,new_size,SEEK_SET
	cmp	eax,-1
	je	chsize_end
	; Write zero byte at current file position
	invoke	oswrite,handle,addr zbuf,0
    chsize_back:
	invoke	lseek,handle,offs,SEEK_SET
	cmp	eax,-1
	je	chsize_end
	sub	eax,eax
    chsize_end:
	ret
chsize	endp

	END
