include conio.inc
include keyb.inc
include io.inc
include time.inc

scroll_delay	proto

.data
tdoffss dd 0
ocurs	S_CURSOR <0,0,0,0>
tobjp	dd 0
oflag	dd 0
orect	dd 0
oxpos	dd 0
oypos	dd 0
oxlen	dd 0
event	dd 0
result  dd 0
dlexit  dd 0
xlbuf	dw 256 dup(0)

_scancodes label byte	;  A - Z
	db 1Eh,30h,2Eh,20h,12h,21h,22h,23h,17h,24h,25h,26h,32h
	db 31h,18h,19h,10h,13h,1Fh,14h,16h,2Fh,11h,2Dh,15h,2Ch

proctab label dword
	dd case_ESC,case_ESC
  ifndef SKIP_ALTMOVE
	dd case_ALTUP,case_ALTDN,case_ALTLEFT,case_ALTRIGHT
  endif
	dd case_ENTER,case_ENTER,cmdmouse,case_LEFT,case_UP
	dd case_RIGHT,case_DOWN,case_HOME,case_END,case_TAB
	dd case_PGUP,case_PGDN

keytable label dword
	dd KEY_ESC,KEY_ALTX
  ifndef SKIP_ALTMOVE
	dd KEY_ALTUP,KEY_ALTDN,KEY_ALTLEFT,KEY_ALTRIGHT
  endif
	dd KEY_ENTER,KEY_KPENTER,MOUSECMD,KEY_LEFT,KEY_UP
	dd KEY_RIGHT,KEY_DOWN,KEY_HOME,KEY_END,KEY_TAB
	dd KEY_PGUP,KEY_PGDN
	key_count = ($ - offset keytable) / 4

eventproc label dword
	dd dlpbuttevent,dlradioevent,dlcheckevent,dlxcellevent
	dd dlteditevent,dlmenusevent,dlxcellevent

.code

dummy_update:
	xor eax,eax
	ret

tdshortkey:
	push eax
	.if [edx].S_TOBJ.to_flag & _O_DEACT || ![edx].S_TOBJ.to_ascii
	    sub eax,eax
	.else
	    and al,0DFh
	    .if [edx].S_TOBJ.to_ascii == al
		or al,1
	    .else
		mov al,[edx].S_TOBJ.to_ascii
		and al,0DFh
		sub al,'A'
		push edx
		movzx edx,al
		cmp ah,[edx+_scancodes]
		pop edx
		.if ZERO?
		    or al,1
		.else
		    sub eax,eax
		.endif
	    .endif
	.endif
	pop eax
	ret

handle_event:
	test	eax,eax
	jnz	handle_event_do
	ret
    handle_event_do:
	push	esi
	push	edi
	push	ebx
	xor	ebx,ebx
	mov	esi,ebx
	mov	ecx,ebx
	mov	edx,tdialog
	mov	cl,[edx].S_DOBJ.dl_count
	mov	edx,[edx].S_DOBJ.dl_object
	cmp	eax,KEY_F1
	je	handle_event_help
	test	cl,cl
	jz	handle_event_null
    handle_event_loop:
	test	[edx].S_TOBJ.to_flag,_O_GLCMD
	jz	handle_event_shkey
	mov	ebx,[edx].S_TOBJ.to_data
    handle_event_shkey:
	call	tdshortkey
	jnz	handle_event_si_to_index
	add	edx,16
	inc	esi
	dec	ecx
	jnz	handle_event_loop
	test	ebx,ebx
	jz	handle_event_null
	mov	edx,ebx
    handle_event_gloop:
	cmp	[edx].S_GLCMD.gl_key,0
	jz	handle_event_null
	cmp	[edx].S_GLCMD.gl_key,eax
	je	handle_event_found
	add	edx,SIZE S_GLCMD
	jmp	handle_event_gloop
    handle_event_found:
	call	[edx].S_GLCMD.gl_proc
	jmp	handle_event_end
    handle_event_null:
	sub	eax,eax
	jmp	handle_event_end
    handle_event_si_to_index:
	test	[edx].S_TOBJ.to_flag,_O_PBKEY
	mov	eax,esi
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	mov	eax,_C_RETURN
	jnz	handle_event_end
    handle_event_one:
	mov	eax,_C_NORMAL
    handle_event_end:
	mov	result,eax
	pop	ebx
	pop	edi
	pop	esi
	ret
    handle_event_help:
	xor	eax,eax
	mov	edx,tdialog
	test	[edx].S_DOBJ.dl_flag,_D_DHELP
	jz	handle_event_end
	cmp	thelp,eax
	jz	handle_event_end
	call	thelp
	mov	eax,_C_NORMAL
	jmp	handle_event_end

test_event:
	sub	edx,edx
    test_event_loop:
	cmp	eax,keytable[edx]
	je	test_event_found
	add	edx,size_l
	dec	ecx
	jnz	test_event_loop
	call	handle_event
	ret
    test_event_found:
	call	proctab[edx]
	ret

LoadCurrentObjectSaveCursor:
	push	eax
	invoke  cursorget,addr ocurs
	pop	eax

LoadCurrentObject:
	mov	edx,tdialog
	cmp	[edx].S_DOBJ.dl_count,0
	jne	@F
	sub	eax,eax
	ret
     @@:
	test	eax,eax
	jnz	@F
	mov	al,[edx].S_DOBJ.dl_index
	inc	eax
      @@:
	mov	cx,[edx+4]
	mov	edx,[edx].S_DOBJ.dl_object
	dec	eax
	shl	eax,4
	add	eax,edx
	mov	tobjp,eax
	mov	edx,eax
	mov	ax,[edx].S_DOBJ.dl_flag
	mov	oflag,eax
	mov	eax,[edx].S_TOBJ.to_rect
	mov	orect,eax
	add	word ptr orect,cx
	and	eax,0FFh
	add	al,cl
	mov	oxpos,eax
	mov	al,orect.S_RECT.rc_y
	mov	oypos,eax
	mov	al,orect.S_RECT.rc_col
	mov	oxlen,eax
	mov	ax,[edx].S_TOBJ.to_flag
	ret

omousecmd:
	call	mousex
	mov	edx,eax
	call	mousey
	cmp	eax,oypos
	jne	omousecmd_nil
	mov	eax,oxpos
	dec	eax
	cmp	edx,eax
	jb	omousecmd_nil
	add	eax,2
	cmp	edx,eax
	jbe	omousecmd_one
    omousecmd_nil:
	sub	al,al
	mov	eax,MOUSECMD
	ret
    omousecmd_one:
	or	al,1
	ret

ExecuteChild:
	inc eax
	call LoadCurrentObject
	.if [edx].S_TOBJ.to_proc
	    call [edx].S_TOBJ.to_proc
	    mov result,eax
	    .if eax == _C_REOPEN
		mov edx,tdialog
		mov al,[edx].S_DOBJ.dl_index
		push eax
		invoke dlinit,tdialog
		pop eax
		mov edx,tdialog
		mov [edx].S_DOBJ.dl_index,al
	    .endif
	.endif
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

item_init:
	mov	edx,tdialog
	movzx	eax,[edx].S_DOBJ.dl_count
	movzx	ecx,[edx].S_DOBJ.dl_index
	mov	edx,[edx].S_DOBJ.dl_object
	push	eax
	mov	eax,ecx
	shl	eax,4
	add	edx,eax
	pop	eax
	test	ecx,ecx
	ret

cl_to_index:
	dec	ecx
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,cl
	sub	eax,eax
	inc	eax
	ret

cl_to_index_if_act:
	test	[edx].S_TOBJ.to_flag,_O_DEACT
	jz	cl_to_index
	test	ch,ch
	ret

previtem:
	call	item_init
	jz	previtem_00
	sub	edx,SIZE S_TOBJ		; prev object
     @@:
	call	cl_to_index_if_act
	jnz	@F
	sub	edx,SIZE S_TOBJ
	dec	ecx
	jnz	@B
     @@:
	jnz	previtem_end
	sub	ecx,ecx
    previtem_00:
	mov	edx,tdialog
	add	cl,[edx].S_DOBJ.dl_count
	jz	previtem_02
	movzx	eax,[edx].S_DOBJ.dl_index
	mov	edx,[edx].S_DOBJ.dl_object
	push	eax
	mov	eax,ecx
	dec	eax
	shl	eax,4
	add	edx,eax
	pop	eax
     @@:
	cmp	al,cl
	ja	previtem_02
	test	[edx].S_TOBJ.to_flag,_O_DEACT
	jz	cl_to_index
	sub	edx,SIZE S_TOBJ
	dec	ecx
	jnz	@B
    previtem_02:
	sub	eax,eax
    previtem_end:
	mov	result,eax
	ret

itemleft:
	call	item_init
	jz	itemleft_0
	sub	edx,SIZE S_TOBJ		; prev object
	mov	eax,[edx+20]		; RECT next object
    itemleft_loop:
	cmp	ah,[edx+5]		; .rc_y
	jne	@F
	cmp	al,[edx+4]		; .rc_x
	jbe	@F
	call	cl_to_index_if_act
	jnz	itemleft_end
     @@:
	sub	edx,SIZE S_TOBJ
	dec	ecx
	jnz	itemleft_loop
    itemleft_0:
	sub	eax,eax
    itemleft_end:
	mov	result,eax
	ret

nextitem:
	mov	edx,tdialog
	movzx	eax,[edx].S_DOBJ.dl_count
	movzx	ecx,[edx].S_DOBJ.dl_index
	inc	ecx
	mov	edx,[edx].S_DOBJ.dl_object
	push	eax
	mov	eax,ecx
	shl	eax,4
	add	edx,eax
	inc	ecx
	pop	eax
     @@:
	cmp	ecx,eax
	ja	@F
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	ecx
	add	edx,SIZE S_TOBJ
	jmp	@B
     @@:
	mov	eax,tdialog
	mov	edx,[eax].S_DOBJ.dl_object
	movzx	eax,[eax].S_DOBJ.dl_index
	inc	eax
	mov	ecx,1
     @@:
	cmp	ecx,eax
	ja	@F
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	ecx
	add	edx,SIZE S_TOBJ
	jmp	@B
     @@:
	sub	eax,eax
    nextitem_04:
	mov	result,eax
	ret

itemright:
	push	ebx
	mov	edx,tdialog
	movzx	ebx,[edx].S_DOBJ.dl_count
	movzx	ecx,[edx].S_DOBJ.dl_index
	inc	ecx
	mov	edx,[edx].S_DOBJ.dl_object
	mov	eax,ecx
	shl	eax,4
	add	edx,eax
	inc	ecx
	mov	ax,[edx-12]
    itemright_00:
	cmp	ecx,ebx
	ja	itemright_02
	cmp	ah,[edx+5]
	jnz	@F
	cmp	al,[edx+4]
	jnb	@F
	call	cl_to_index_if_act
	jnz	itemright_end
     @@:
	inc	ecx
	add	edx,16
	jmp	itemright_00
    itemright_02:
	xor	eax,eax
    itemright_end:
	pop	ebx
	mov	result,eax
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

xbuttxchg:
	invoke  getxyc,oxpos,oypos
	xchg	esi,eax
	invoke  scputc,oxpos,oypos,1,eax
	mov	eax,oxpos
	add	eax,oxlen
	dec	eax
	push	eax
	invoke  getxyc,eax,oypos
	xchg	edi,eax
	pop	ebx
	invoke  scputc,ebx,oypos,1,eax
	ret

xbuttms:
	push	esi
	push	edi
	push	ebx
	mov	esi,' '
	mov	edi,esi
	call	xbuttxchg
	inc	ebx
	invoke  getxyc,ebx,oypos
	push	eax
	sub	ebx,oxlen
	mov	eax,oypos
	inc	eax
	inc	ebx
	invoke  getxyc,ebx,eax
	push	eax
	mov	eax,oflag
	and	eax,000Fh
	push	eax
	jnz	xbuttms_00
	mov	eax,oypos
	inc	eax
	invoke  scputc,ebx,eax,oxlen,' '
	add	ebx,oxlen
	dec	ebx
	invoke  scputc,ebx,oypos,1,' '
    xbuttms_00:
	call	msloop
	call	xbuttxchg
	pop	edx
	pop	eax
	pop	edi
	test	edx,edx
	jnz	xbuttms_end
	mov	ebx,oxpos
	inc	ebx
	mov	edx,oypos
	inc	edx
	invoke  scputc,ebx,edx,oxlen,eax
	add	ebx,oxlen
	dec	ebx
	invoke  scputc,ebx,oypos,1,edi
    xbuttms_end:
	pop	ebx
	pop	edi
	pop	esi
	ret

cmdmouse:
	push esi
	push edi
	push ebp
	mov  edx,tdialog
	call mousex
	mov  ecx,eax
	call mousey
	mov  ebp,eax
	mov  result,_C_NORMAL
	.if rcxyrow(dword ptr [edx].S_DOBJ.dl_rect,ecx,eax)
	    push eax
	    mov edi,[edx].S_DOBJ.dl_rect
	    mov al,[edx].S_DOBJ.dl_count
	    mov esi,eax
	    mov edx,[edx].S_DOBJ.dl_object
	    .while esi
		mov eax,[edx].S_TOBJ.to_rect
		add ax,di
		.if rcxyrow(eax,ecx,ebp)
		    mov edx,tdialog
		    pop eax
		    sub eax,eax
		    push eax
		    mov al,[edx].S_DOBJ.dl_count
		    sub eax,esi
		    mov esi,eax
		    inc eax
		    call LoadCurrentObject
		    .if !(eax & _O_DEACT)
			mov edx,tdialog
			mov eax,esi
			mov [edx].S_DOBJ.dl_index,al
			mov eax,oflag
			and al,0Fh
			.if al == _O_TBUTT || al == _O_PBUTT
			    call xbuttms
			.endif
			mov eax,oflag
			.if eax & _O_DEXIT
			    mov result,_C_ESCAPE
			.endif
			.if eax & _O_CHILD
			@@:
			    mov eax,esi
			    call ExecuteChild
			.else
			    and eax,000Fh
			    .if al == _O_TBUTT || al == _O_PBUTT || \
				al == _O_MENUS || al == _O_XHTML
				mov result,_C_RETURN
			    .endif
			.endif
		    .else
			and eax,0Fh
			.if al == _O_LLMSU
			    call TDLListMouseUP
			.elseif al == _O_LLMSD
			    call TDLListMouseDN
			.elseif al == _O_MOUSE
			    .if ecx & _O_CHILD
				jnz  @B
			    .endif
			.endif
		    .endif
		    .break
		.endif
		add edx,SIZE S_TOBJ
		dec esi
	    .endw
	    pop eax
	    .if eax == 1
		invoke dlmove,tdialog
	    .elseif eax
		call msloop
	    .endif
	.else
	    mov result,_C_ESCAPE
	.endif
	pop ebp
	pop edi
	pop esi
	ret

MouseDelay:
	call	mousep
	jnz	@F
	ret
      @@:
	call	scroll_delay
	call	scroll_delay
	or	al,1
	ret

TDLListMouseUP:
	mov	edx,tdllist
	sub	eax,eax
	cmp	eax,[edx].S_LOBJ.ll_count
	jz	TDReturnNormal
	mov	[edx].S_LOBJ.ll_celoff,eax
	mov	eax,[edx].S_LOBJ.ll_dlgoff
	mov	edx,tdialog
	cmp	al,[edx].S_DOBJ.dl_index
	mov	[edx].S_DOBJ.dl_index,al
	je	@F
	ret
      @@:
	call	case_UP
	test	eax,eax
	jz	TDReturnNormal
	call	MouseDelay
	jnz	@B
	jmp	TDReturnNormal

TDLListMouseDN:
	mov	edx,tdllist
	sub	eax,eax
	cmp	eax,[edx].S_LOBJ.ll_count
	jz	TDReturnNormal
	mov	eax,[edx].S_LOBJ.ll_numcel
	dec	eax
	mov	[edx].S_LOBJ.ll_celoff,eax
	add	eax,[edx]
	mov	edx,tdialog
	cmp	al,[edx].S_DOBJ.dl_index
	mov	[edx].S_DOBJ.dl_index,al
	jz	@F
	sub	eax,eax
	ret
      @@:
	call	case_DOWN
	test	eax,eax
	jz	TDReturnNormal
	call	MouseDelay
	jnz	@B

TDReturnNormal:
	call	msloop
	mov	eax,_C_NORMAL
	ret

TDListItem?:
	sub	eax,eax
	call	LoadCurrentObject
	test	eax,_O_LLIST
	jnz	@F
	and	eax,0Fh
	cmp	al,_O_MENUS
	je	@F
	mov	result,_C_NORMAL
	pop	eax
      @@:
	ret

case_HOME:
	call	TDListItem?
	mov	eax,0
	jz	@F
	mov	edx,tdllist
	mov	[edx].S_LOBJ.ll_index,eax
	mov	[edx].S_LOBJ.ll_celoff,eax
	push	[edx].S_LOBJ.ll_dlgoff
	call	[edx].S_LOBJ.ll_proc
	pop	eax
      @@:
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	call	nextitem
	call	previtem
	ret

case_LEFT:
	sub	eax,eax
	call	LoadCurrentObject
	test	eax,_O_LLIST
	jz	@F
	jmp	case_PGUP
      @@:
	and	eax,000Fh
	cmp	al,_O_MENUS
	jz	@F
	call	itemleft
	jz	case_UP
	ret
      @@:
	jmp	case_EXIT

case_RIGHT:
	sub	eax,eax
	call	LoadCurrentObject
	test	eax,_O_LLIST
	jz	@F
	jmp	case_PGDN
      @@:
	and	eax,000Fh
	cmp	al,_O_MENUS
	jz	@F
	call	itemright
	jz	case_DOWN
	ret
      @@:
	jmp	case_EXIT

case_UP:
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_LLIST
	jz	case_UP_01
	sub	eax,eax
	mov	edx,tdllist
	cmp	eax,[edx].S_LOBJ.ll_celoff
	jne	case_UP_01
	cmp	eax,[edx].S_LOBJ.ll_index
	je	@F
	mov	ecx,[edx].S_LOBJ.ll_dlgoff
	mov	edx,tdialog
	cmp	[edx].S_DOBJ.dl_index,cl
	je	case_UP_02
	mov	[edx].S_DOBJ.dl_index,cl
	inc	eax
      @@:
	ret
    case_UP_01:
	call	previtem
	ret
    case_UP_02:
	mov	edx,tdllist
	dec	[edx].S_LOBJ.ll_index
	jmp	case_LLPROC

case_DOWN:
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_LLIST
	jz	case_NEXT
	mov	edx,tdllist
	mov	eax,[edx].S_LOBJ.ll_dcount
	mov	ecx,[edx].S_LOBJ.ll_celoff
	dec	eax
	cmp	eax,ecx
	jz	@F
	mov	eax,ecx
	add	eax,[edx].S_LOBJ.ll_index
	inc	eax
	cmp	eax,[edx].S_LOBJ.ll_count
	jb	case_NEXT
      @@:
	mov	eax,[edx].S_LOBJ.ll_dlgoff
	add	eax,ecx
	mov	edx,tdialog
	mov	ah,[edx].S_DOBJ.dl_index
	mov	[edx].S_DOBJ.dl_index,al
	cmp	al,ah
	jne	case_NORMAL
	mov	edx,tdllist
	mov	eax,[edx].S_LOBJ.ll_count
	sub	eax,[edx].S_LOBJ.ll_index
	sub	eax,[edx].S_LOBJ.ll_dcount
	jle	return_NULL
	inc	[edx].S_LOBJ.ll_index

case_LLPROC:
	call	[edx].S_LOBJ.ll_proc
	jmp	return_AX

case_EXIT:
	inc	edi
return_NULL:
	sub	eax,eax
return_AX:
	mov	result,eax
	ret
case_NORMAL:
	mov	result,_C_NORMAL
	ret

case_TAB:
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_LLIST
	jz	case_NEXT
	mov	edx,tdllist
	mov	eax,[edx].S_LOBJ.ll_dlgoff
	add	eax,[edx].S_LOBJ.ll_dcount
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	jmp	case_NORMAL
case_NEXT:
	jmp	nextitem

case_ESC:
	mov	result,_C_ESCAPE
	ret

case_PGUP:
	call	TDListItem?
	jz	case_PGUP_02
	mov	edx,tdllist
	sub	eax,eax
	cmp	eax,[edx].S_LOBJ.ll_celoff
	jz	case_PGUP_01
	mov	[edx].S_LOBJ.ll_celoff,eax
	mov	eax,[edx].S_LOBJ.ll_dlgoff
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
    case_PGUP_00:
	mov	result,_C_NORMAL
	ret
    case_PGUP_01:
	cmp	eax,[edx].S_LOBJ.ll_index
	jz	case_PGUP_00
	mov	eax,[edx].S_LOBJ.ll_dcount
	cmp	eax,[edx].S_LOBJ.ll_index
	jbe	case_PGUP_03
    case_PGUP_02:
	jmp	case_HOME
    case_PGUP_03:
	sub	[edx].S_LOBJ.ll_index,eax
	jmp	case_LLPROC

case_PGDN:
	call	TDListItem?
	jz	case_END
	mov	edx,tdllist
	mov	eax,[edx].S_LOBJ.ll_dcount
	dec	eax
	cmp	eax,[edx].S_LOBJ.ll_celoff
	jz	case_PGDN_00
	mov	eax,[edx].S_LOBJ.ll_numcel
	add	eax,[edx].S_LOBJ.ll_dlgoff
	dec	eax
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	mov	result,_C_NORMAL
	ret
    case_PGDN_00:
	add	eax,[edx].S_LOBJ.ll_celoff
	add	eax,[edx].S_LOBJ.ll_index
	inc	eax
	cmp	eax,[edx].S_LOBJ.ll_count
	jnb	case_END
	mov	eax,[edx].S_LOBJ.ll_dcount
	add	[edx].S_LOBJ.ll_index,eax
	jmp	case_LLPROC

case_END:
	call	TDListItem?
	jnz	@F
	mov	edx,tdialog
	mov	al,[edx].S_DOBJ.dl_count
	dec	al
	mov	[edx].S_DOBJ.dl_index,al
	call	previtem
	call	nextitem
	ret
      @@:
	mov	edx,tdllist
	mov	eax,[edx].S_LOBJ.ll_count
	cmp	eax,[edx].S_LOBJ.ll_dcount
	jnb	@F
	mov	eax,[edx].S_LOBJ.ll_numcel
	dec	eax
	mov	[edx].S_LOBJ.ll_celoff,eax
	add	eax,[edx].S_LOBJ.ll_dlgoff
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	mov	result,_C_NORMAL
	ret
      @@:
	sub	eax,[edx].S_LOBJ.ll_dcount
	cmp	eax,[edx].S_LOBJ.ll_index
	jz	@F
	mov	[edx].S_LOBJ.ll_index,eax
	mov	eax,[edx].S_LOBJ.ll_dcount
	dec	eax
	mov	[edx].S_LOBJ.ll_celoff,eax
	add	eax,[edx].S_LOBJ.ll_dlgoff
	mov	edx,tdialog
	mov	[edx].S_DOBJ.dl_index,al
	mov	edx,tdllist
	jmp	case_LLPROC
      @@:
	jmp	return_NULL

case_ENTER:
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_CHILD
	mov	eax,_C_RETURN
	jnz	@F
	mov	result,eax
	ret
      @@:
	mov	edx,tdialog
	movzx	eax,[edx].S_DOBJ.dl_index
	call	ExecuteChild
	ret

OGOTOXY:
	sub	eax,eax
	call	LoadCurrentObjectSaveCursor
	call	cursoron
	inc	oxpos
	invoke  gotoxy,oxpos,oypos
	ret

TDXORRADIO:
	push	edx
	push	ecx
	test	byte ptr [edx].S_TOBJ.to_flag,_O_RADIO
	mov	eax,' '
	jz	@F
	mov	eax,7
      @@:
	mov	cx,[edx+4]
	mov	edx,tdialog
	add	cx,[edx+4]
	mov	dl,ch
	inc	ecx
	invoke  scputc,ecx,edx,1,eax
	pop	ecx
	pop	edx
	ret

xorradioflag proc private
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_RADIO
	jnz	break
	mov	edx,tdialog
	sub	ecx,ecx
	add	cl,[edx].S_DOBJ.dl_count
	jz	toend
	mov	edx,[edx].S_DOBJ.dl_object
     @@:
	test	byte ptr [edx].S_TOBJ.to_flag,_O_RADIO
	jnz	@F
	add	edx,16
	dec	ecx
	jnz	@B
	jmp	toend
     @@:
	and	byte ptr [edx].S_TOBJ.to_flag,not _O_RADIO
	call	TDXORRADIO
	xor	eax,eax
	call	LoadCurrentObject
	or	byte ptr [edx].S_TOBJ.to_flag,_O_RADIO
	call	TDXORRADIO
  break:
	call	msloop
	mov	eax,_C_NORMAL
  toend:
	ret
xorradioflag endp

ORETURN:
	invoke  cursorset,addr ocurs
	ret

TDXORSWITCH:
	sub	eax,eax
	call	LoadCurrentObject
	xor	eax,_O_FLAGB
	mov	[edx],ax
	test	eax,_O_FLAGB
	mov	eax,' '
	jz	@F
	mov	eax,'x'
      @@:
	mov	dx,word ptr orect
	mov	cl,dh
	inc	edx
	invoke  scputc,edx,ecx,1,eax
	invoke  msloop
	sub	eax,eax
	ret

TDTestXYRow:
	invoke  mousey
	mov	edx,eax
	invoke  mousex
	invoke  rcxyrow,orect,eax,edx
	mov	eax,MOUSECMD
	ret

TDSelectObject:
	invoke  rcread,orect,addr xlbuf
	mov	al,at_background[B_Inverse]
	invoke  wcputbg,addr xlbuf,oxlen,eax
	invoke  rcxchg,orect,addr xlbuf
	ret

TDDeselectObject:
	push	eax
	invoke  rcwrite,orect,addr xlbuf
	pop	eax
	ret

ifndef SKIP_ALTMOVE
case_ALTUP:
	mov	eax,rcmoveup
	jmp	case_ALTMOVE
case_ALTDN:
	mov	eax,rcmovedn
	jmp	case_ALTMOVE
case_ALTLEFT:
	mov	eax,rcmoveleft
	jmp	case_ALTMOVE
case_ALTRIGHT:
	mov	eax,rcmoveright
case_ALTMOVE:
	push	esi
	push	edi
	push	ebx
	mov	edi,tdialog
	movzx	ecx,[edi].S_DOBJ.dl_flag
	test	ecx,_D_DMOVE
	jz	@F
	mov	esi,[edi].S_DOBJ.dl_wp
	mov	ebx,[edi].S_DOBJ.dl_rect
  ifdef __CDECL__
	push	ecx
	push	esi
	push	ebx
  else
	push	ebx
	push	esi
	push	ecx
  endif
	.if ecx & _D_SHADE
	    push eax
	    invoke rcclrshade,ebx,esi
	    pop eax
	.endif
	call eax
	mov bx,ax
	mov word ptr [edi].S_DOBJ.dl_rect,ax
	.if [edi].S_DOBJ.dl_flag & _D_SHADE
	    invoke rcsetshade,ebx,esi
	.endif
     @@:
	pop	ebx
	pop	edi
	pop	esi
	ret
endif

;************** Public

dlpbuttevent proc
	push	esi
	push	edi
	sub	eax,eax
	call	LoadCurrentObjectSaveCursor
	call	cursoron
	mov	eax,oxpos
	inc	eax
	invoke  gotoxy,eax,oypos
	mov	al,byte ptr oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	@F
	call	cursoroff
      @@:
	mov	esi,16
	mov	edi,17
	call	xbuttxchg
	call	tgetevent
	push	eax
	call	xbuttxchg
	invoke  cursorset,addr ocurs
	pop	eax
	pop	edi
	pop	esi
	ret
dlpbuttevent endp

dlradioevent proc
	call OGOTOXY
	.repeat
	    call tgetevent
	    .if eax == MOUSECMD
		call omousecmd
		jz @F
	    .elseif eax != KEY_SPACE
		jmp @F
	    .endif
	    call xorradioflag
	.until oflag & _O_EVENT
	mov eax,KEY_SPACE
      @@:
	call ORETURN
	ret
dlradioevent endp

dlcheckevent proc
	call	OGOTOXY
    tdcheckevent_00:
	call	tgetevent
	cmp	eax,MOUSECMD
	je	@F
	cmp	eax,KEY_SPACE
	je	tdcheckevent_02
	jmp	tdcheckevent_03
      @@:
	call	omousecmd
	jz	tdcheckevent_03
    tdcheckevent_02:
	call	TDXORSWITCH
	test	oflag,_O_EVENT
	jz	tdcheckevent_00
	mov	eax,KEY_SPACE
    tdcheckevent_03:
	call	ORETURN
	ret
dlcheckevent endp

dlxcellevent proc
	sub	eax,eax
	call	LoadCurrentObject
	jz	@F
	call	cursoroff
      @@:
	test	oflag,_O_LLIST
	jz	@F
	mov	edx,tdialog
	movzx	eax,[edx].S_DOBJ.dl_index
	mov	edx,tdllist
	cmp	eax,[edx].S_LOBJ.ll_dlgoff
	jb	@F
	sub	eax,[edx].S_LOBJ.ll_dlgoff
	cmp	eax,[edx].S_LOBJ.ll_numcel
	jnb	@F
	mov	[edx].S_LOBJ.ll_celoff,eax
      @@:
	call	TDSelectObject
    tdxcellevent_loop:
	call	tgetevent
	cmp	eax,MOUSECMD
	jne	tdxcellevent_07
	call	TDTestXYRow
	jz	tdxcellevent_07
	invoke  mousewait,oxpos,oypos,oxlen
	mov	eax,oflag
	and	eax,000Fh
	cmp	eax,_O_XHTML
	mov	eax,KEY_ENTER
	jz	tdxcellevent_07
	push	esi
	mov	esi,10
      @@:
	invoke  delay,16
	call	mousep
	jnz	@F
	dec	esi
	jnz	@B
      @@:
	call	mousep
	jz	@F
	call	TDTestXYRow
	jz	@F
	mov	eax,KEY_ENTER
	jmp	tdxcellevent_06
      @@:
	sub	eax,eax
    tdxcellevent_06:
	pop	esi
    tdxcellevent_07:
	test	eax,eax
	jz	tdxcellevent_loop
	call	TDDeselectObject
	ret
dlxcellevent endp

dlteditevent proc
	push	esi
	mov	edx,tdialog
	mov	si,[edx+4]
	sub	eax,eax
	call	LoadCurrentObject
	mov	eax,[edx].S_TOBJ.to_rect
	add	ax,si
	movzx	ecx,[edx].S_TOBJ.to_count
	shl	ecx,4
	invoke  dledit,[edx].S_TOBJ.to_data,eax,ecx,oflag
	pop	esi
	ret
dlteditevent endp

dlmenusevent proc
	call cursoroff
	sub  eax,eax
	call LoadCurrentObjectSaveCursor
	.if [edx].S_TOBJ.to_data
	    mov al,' '
	    mov ah,at_background[B_Menus]
	    or  ah,at_foreground[F_Menus]
	    mov ecx,_scrrow
	    invoke scputw,20,ecx,60,eax
	    invoke scputs,20,ecx,0,60,[edx].S_TOBJ.to_data
	.endif
	call TDSelectObject
	call tgetevent
	call TDDeselectObject
	invoke cursorset,addr ocurs
	ret
dlmenusevent endp

dlevent proc uses esi edi ebx dialog:dword
local	prevdlg:dword	; init tdialog
local	cursor:S_CURSOR ; init cursor
	mov	eax,tdialog
	mov	prevdlg,eax
	mov	eax,dialog
	mov	tdialog,eax
	mov	ebx,tdialog
	mov	si,[ebx]
	test	si,_D_ONSCR
	jnz	@F
	invoke  dlshow,dialog
	jz	tdevent_end
      @@:
	invoke  cursorget,addr cursor
	call	cursoroff
	sub	eax,eax
	cmp	[ebx].S_DOBJ.dl_count,al
	je	@F
	call	LoadCurrentObject
	test	eax,_O_DEACT
	jz	tdevent_modal
	call	nextitem
	jnz	tdevent_modal
      @@:
	call	tgetevent
	mov	ecx,9
	call	test_event
	mov	eax,result
	cmp	eax,_C_ESCAPE
	je	tdevent_cancel
	cmp	eax,_C_RETURN
	je	tdevent_cancel
	jmp	@B
    tdevent_modal:
	call	msloop
	sub	edi,edi
    tdevent_continue:
	sub	eax,eax
	mov	result,eax
	call	LoadCurrentObject
	and	eax,_O_EVENT
	jz	@F
	call	[edx].S_TOBJ.to_proc
	jmp	tdevent_test
      @@:
	mov	al,[edx]
	and	eax,0Fh
	cmp	al,6
	jbe	tdevent_event
	cmp	al,_O_TBUTT
	jne	@F
	call	dlpbuttevent
	jmp	tdevent_test
      @@:
	mov	eax,KEY_ESC
	jmp	tdevent_test
    tdevent_event:
	call	eventproc[eax*4]
    tdevent_test:
	mov	dlexit,eax
	mov	event,eax
	mov	ecx,key_count
	call	test_event
	mov	eax,result
	cmp	eax,_C_ESCAPE
	je	tdevent_cancel
	cmp	eax,_C_RETURN
	je	tdevent_return
	test	edi,edi
	jz	tdevent_continue
    tdevent_exit:
	invoke  cursorset,addr cursor
	mov	eax,event
	test	eax,eax
	jmp	tdevent_end
    tdevent_return:
	sub	eax,eax
	call	LoadCurrentObject
	and	eax,_O_DEXIT
	jnz	tdevent_cancel
    tdevent_index:
	mov	edx,tdialog
	movzx	eax,[edx].S_DOBJ.dl_index
	inc	eax
	mov	event,eax
	jmp	tdevent_exit
    tdevent_cancel:
	mov	event,0
	jmp	tdevent_exit
    tdevent_end:
	mov	edx,eax
	mov	eax,prevdlg
	mov	tdialog,eax
	mov	eax,edx
	mov	ecx,dlexit
	test	eax,eax
	ret
dlevent endp

Install:
	mov	eax,getevent
	mov	tgetevent,eax
	mov	tgetevent[4],eax
	ret

pragma_init	Install,32

	END
